/*
 * xrick/src/e_box.c
 *
 * This source code file is part of the xrick distribution, and as such is
 * copyrighted. Please read the README file in the root directory of the
 * distribution for information about copyrights, trademarks, license,
 * disclaimers, etc.
 */

#include "system.h"
#include "game.h"
#include "ents.h"
#include "e_box.h"

#include "e_bullet.h"
#include "e_bomb.h"
#include "e_rick.h"
#include "maps.h"
#include "util.h"

/*
 * Entity action
 *
 * ASM 245A
 */
void
e_box_action(U8 e)
{
#define cnt c1
  static U8 sp[] = {0x24, 0x25, 0x26, 0x27, 0x28};  /* sprites */

  if (ent_ents[e].n & ENT_LETHAL) {
    ent_ents[e].sprite = sp[ent_ents[e].cnt >> 1];
    if (--ent_ents[e].cnt == 0) {
      ent_ents[e].n = 0;
      map_marks[ent_ents[e].mark].ent |= MAP_MARK_NACT;
    }
  }
  else {
    if (e_rick_boxtest(e)) {
#ifdef ENABLE_SOUND
      syssnd_play(WAV_BOX, 1);
#endif
      if (ent_ents[e].n == 0x10)
	game_bombs = 6;
      else  /* 0x11 */
	game_bullets = 6;
      ent_ents[e].n = 0;
      map_marks[ent_ents[e].mark].ent |= MAP_MARK_NACT;
    }
    else if (E_RICK_STTST(E_RICK_STSTOP) &&
	     u_fboxtest(e, e_rick_stop_x, e_rick_stop_y)) {
      ent_ents[e].cnt = 0x0A;
      ent_ents[e].n |= ENT_LETHAL;
    }
    else if (E_BULLET_ENT.n && u_fboxtest(e, e_bullet_xc, e_bullet_yc)) {
      E_BULLET_ENT.n = 0;
      ent_ents[e].cnt = 0x0A;
      ent_ents[e].n |= ENT_LETHAL;
    }
    else if (e_bomb_lethal && e_bomb_hit(e)) {
      ent_ents[e].cnt = 0x0A;
      ent_ents[e].n |= ENT_LETHAL;
    }
  }
#undef c1
}

/* eof */


