/*
 * xrick/src/rects.c
 *
 * This source code file is part of the xrick distribution, and as such is
 * copyrighted. Please read the README file in the root directory of the
 * distribution for information about copyrights, trademarks, license,
 * disclaimers, etc.
 */

#include <stdlib.h>  /* malloc */

#include "system.h"
#include "rects.h"


/*
 * Free a list of rectangles and set the pointer to NULL.
 *
 * p: rectangle list CHANGED to NULL
 */
void
rects_free(rect_t *r) {
  if (r) {
    rects_free(r->next);
    free(r);
  }
}


/*
 * Add a rectangle to a list of rectangles
 */
rect_t *
rects_new(U16 x, U16 y, U16 width, U16 height, rect_t *next)
{
  rect_t *r;

  r = malloc(sizeof *r);
  r->x = x;
  r->y = y;
  r->width = width;
  r->height = height;
  r->next = next;
  return r;
}

/* eof */
