/*
 * xrick/src/scr_pause.c
 *
 * This source code file is part of the xrick distribution, and as such is
 * copyrighted. Please read the README file in the root directory of the
 * distribution for information about copyrights, trademarks, license,
 * disclaimers, etc.
 */

#include <stddef.h> /* NULL */

#include "system.h"
#include "game.h"
#include "screens.h"

#include "draw.h"
#include "control.h"
#include "ents.h"


/*
 * Display the pause indicator
 */
void
screen_pause(U8 pause)
{
  if (pause == TRUE) {
    draw_tilesBank = 0;
    draw_tllst = screen_pausedtxt;
    draw_setfb(120, 80);
#ifdef GFXPC
    draw_filter = 0xAAAA;
#endif
    draw_tilesList();
  }
  else {
#ifdef GFXPC
    draw_filter = 0xFFFF;
#endif
    draw_map();
    ent_draw();
    draw_drawStatus();
  }
  game_rects = &draw_SCREENRECT;
}


/* eof */

