/*
 * xrick/src/scr_xrick.c
 *
 * This source code file is part of the xrick distribution, and as such is
 * copyrighted. Please read the README file in the root directory of the
 * distribution for information about copyrights, trademarks, license,
 * disclaimers, etc.
 */

#include "system.h"
#include "game.h"
#include "screens.h"

#include "draw.h"
#include "control.h"
#include "img.h"

#include "img_splash.e"

/*
 * Display XRICK splash screen
 *
 * return: SCREEN_RUNNING, SCREEN_DONE, SCREEN_EXIT
 */
U8
screen_xrick(void)
{
  static U8 seq = 0;
  static U8 wait = 0;

  if (seq == 0) {
    sysvid_clear();
    draw_img(IMG_SPLASH);
    game_rects = &draw_SCREENRECT;
    seq = 1;
  }

  switch (seq) {
  case 1:  /* wait */
    if (wait++ > 0x2) {
#ifdef ENABLE_SOUND
      syssnd_play(WAV_DING, 1);
#endif
      seq = 2;
      wait = 0;
    }
    break;

  case 2:  /* wait */
    if (wait++ > 0x20) {
      seq = 99;
      wait = 0;
    }
  }

  if (control_status & CONTROL_EXIT)  /* check for exit request */
    return SCREEN_EXIT;

  if (seq == 99) {  /* we're done */
    sysvid_clear();
    sysvid_setGamePalette();
    seq = 0;
    return SCREEN_DONE;
  }
  
  return SCREEN_RUNNING;
}

/* eof */

