/*
 * xrick/src/sysevt.c
 *
 * This source code file is part of the xrick distribution, and as such is
 * copyrighted. Please read the README file in the root directory of the
 * distribution for information about copyrights, trademarks, license,
 * disclaimers, etc.
 */

#include <SDL.h>

#include "system.h"
#include "game.h"
#include "debug.h"

#include "control.h"
#include "draw.h"

#define SYSJOY_RANGE 3280

static SDL_Event event;

/*
 * Process an event
 */
static void
processEvent()
{
  U16 key;
  SDL_ActiveEvent *aevent;

  switch (event.type) {
  case SDL_KEYDOWN:
    key = event.key.keysym.sym;
    if (key == syskbd_up || key == SDLK_UP) {
      control_status |= CONTROL_UP;
      control_last = CONTROL_UP;
    }
    else if (key == syskbd_down || key == SDLK_DOWN) {
      control_status |= CONTROL_DOWN;
      control_last = CONTROL_DOWN;
    }
    else if (key == syskbd_left || key == SDLK_LEFT) {
      control_status |= CONTROL_LEFT;
      control_last = CONTROL_LEFT;
    }
    else if (key == syskbd_right || key == SDLK_RIGHT) {
      control_status |= CONTROL_RIGHT;
      control_last = CONTROL_RIGHT;
    }
    else if (key == syskbd_pause) {
      control_status |= CONTROL_PAUSE;
      control_last = CONTROL_PAUSE;
    }
    else if (key == syskbd_end) {
      control_status |= CONTROL_END;
      control_last = CONTROL_END;
    }
    else if (key == syskbd_xtra) {
      control_status |= CONTROL_EXIT;
      control_last = CONTROL_EXIT;
    }
    else if (key == syskbd_fire) {
      control_status |= CONTROL_FIRE;
      control_last = CONTROL_FIRE;
    }
    else if (key == SDLK_1) {
      sysvid_toggleFullscreen();
    }
    else if (key == SDLK_2) {
      sysvid_zoom(-1);
    }
    else if (key == SDLK_3) {
      sysvid_zoom(+1);
    }
#ifdef ENABLE_SOUND
    else if (key == SDLK_4) {
      syssnd_toggleMute();
    }
    else if (key == SDLK_5) {
      syssnd_vol(-1);
    }
    else if (key == SDLK_6) {
      syssnd_vol(+1);
    }
#endif
#ifdef ENABLE_CHEATS
    else if (key == SDLK_7) {
      game_toggleCheat(1);
    }
    else if (key == SDLK_8) {
      game_toggleCheat(2);
    }
    else if (key == SDLK_9) {
      game_toggleCheat(3);
    }
#endif
    break;
  case SDL_KEYUP:
    key = event.key.keysym.sym;
    if (key == syskbd_up || key == SDLK_UP) {
      control_status ^= CONTROL_UP;
      control_last = CONTROL_UP;
    }
    else if (key == syskbd_down || key == SDLK_DOWN) {
      control_status ^= CONTROL_DOWN;
      control_last = CONTROL_DOWN;
    }
    else if (key == syskbd_left || key == SDLK_LEFT) {
      control_status ^= CONTROL_LEFT;
      control_last = CONTROL_LEFT;
    }
    else if (key == syskbd_right || key == SDLK_RIGHT) {
      control_status ^= CONTROL_RIGHT;
      control_last = CONTROL_RIGHT;
    }
    else if (key == syskbd_pause) {
      control_status ^= CONTROL_PAUSE;
      control_last = CONTROL_PAUSE;
    }
    else if (key == syskbd_end) {
      control_status ^= CONTROL_END;
      control_last = CONTROL_END;
    }
    else if (key == syskbd_xtra) {
      control_status ^= CONTROL_EXIT;
      control_last = CONTROL_EXIT;
    }
    else if (key == syskbd_fire) {
      control_status ^= CONTROL_FIRE;
      control_last = CONTROL_FIRE;
    }
    break;
  case SDL_QUIT:
    /* player tries to close the window -- this is the same as pressing ESC */
    control_status |= CONTROL_EXIT;
    control_last = CONTROL_EXIT;
    break;
#ifdef ENABLE_FOCUS
  case SDL_ACTIVEEVENT: {
    aevent = (SDL_ActiveEvent *)&event;
    IFDEBUG_EVENTS(
      printf("xrick/events: active %x %x\n", aevent->gain, aevent->state);
      );
    if (aevent-> gain == 1)
      control_active = TRUE;
    else
      control_active = FALSE;
    }
  break;
#endif
#ifdef ENABLE_JOYSTICK
  case SDL_JOYAXISMOTION:
    IFDEBUG_EVENTS(sys_printf("xrick/events: joystick\n"););
    if (event.jaxis.axis == 0) {  /* left-right */
      if (event.jaxis.value < -SYSJOY_RANGE) {  /* left */
	control_status &= CONTROL_LEFT;
      }
      else if (event.jaxis.value > SYSJOY_RANGE) {  /* right */
	control_status &= CONTROL_RIGHT;
      }
      else {  /* center */
	control_status ^= CONTROL_LEFT;
	control_status ^= CONTROL_RIGHT;
      }
    }
    if (event.jaxis.axis == 1) {  /* up-down */
      if (event.jaxis.value < -SYSJOY_RANGE) {  /* up */
	control_status &= CONTROL_UP;
      }
      else if (event.jaxis.value > SYSJOY_RANGE) {  /* down */
	control_status &= CONTROL_DOWN;
      }
      else {  /* center */
	control_status ^= CONTROL_DOWN;
	control_status ^= CONTROL_UP;
      }
    }
    break;
  case SDL_JOYBUTTONDOWN:
    control_status &= CONTROL_FIRE;
    break;
  case SDL_JOYBUTTONUP:
    control_status ^= CONTROL_FIRE;
    break;
#endif
  default:
    break;
  }
}
  
/*
 * Process events, if any, then return
 */
void
sysevt_poll(void)
{
  while (SDL_PollEvent(&event))
    processEvent();
}

/*
 * Wait for an event, then process it and return
 */
void
sysevt_wait(void)
{
  SDL_WaitEvent(&event);
  processEvent();
}

/* eof */



