/*
 * xrick/src/sysjoy.c
 *
 * This source code file is part of the xrick distribution, and as such is
 * copyrighted. Please read the README file in the root directory of the
 * distribution for information about copyrights, trademarks, license,
 * disclaimers, etc.
 */

#include <SDL.h>

#include "system.h"
#include "debug.h"

static SDL_Joystick *j = NULL;

void
sysjoy_init(void)
{
  U8 i, jcount;

  if (SDL_InitSubSystem(SDL_INIT_JOYSTICK) < 0) {
    IFDEBUG_JOYSTICK(
      sys_printf("xrick/joystick: can not initialize joystick subsystem\n");
      );
    return;
  }

  jcount = SDL_NumJoysticks();
  if (!jcount) {  /* no joystick on this system */
    IFDEBUG_JOYSTICK(sys_printf("xrick/joystick: no joystick available\n"););
    return;
  }

  /* use the first joystick that we can open */
  for (i = 0; i < jcount; i++) {
    j = SDL_JoystickOpen(i);
    if (j)
      break;
  }

  /* enable events */
  SDL_JoystickEventState(SDL_ENABLE);
}

void
sysjoy_shutdown(void)
{
  if (j)
    SDL_JoystickClose(j);
}

/* eof */

