	opt	o+,c-,w-
MFP:	EQU	$FFFA00
IERA:	EQU	MFP+$07
IERB:	EQU	MFP+$09
IPRA:	EQU	MFP+$0B
iISRA:	EQU	MFP+$0F
IMRA:	EQU	MFP+$13
IMRB:	EQU	MFP+$15
VECTOR:	EQU	MFP+$17
TACR:	EQU	MFP+$19
TADR:	EQU	MFP+$1F
ISRVEC:	EQU	$134
SCREG:	EQU	$FF8800		;CHIP REGISTER SELECT
SCDATA:	EQU	$FF8802		;REGISTER DATA
P_TERM_OLD: EQU	0	
F_SUPER:  EQU	$20
GETMPB:	 EQU	0
BCONSTAT: EQU	1
BCONIN:	 EQU	2
BCONOUT:	 EQU	3
INPUT:	EQU	$FB0001
OUTPUT:	EQU	$FA0000
key_vec:	equ	$118
st:		equ	1
cr:		equ	0		;carraige return and lf equate
leftbutton:	equ	1
rightbutton:	equ	2
bothbuttons:	equ	3
bshotspeed:	equ	600
shotxvel:	equ	0
shotyvel:	equ	2
shotzvel:	equ	4
shotlife:	equ	6
shotspeed:	equ	250
cxmin:		equ	16
cxmax:		equ	303
cymin:		equ	13
cymax:		equ	123
mminx:		equ	16
channelvolume:		equ	0
channelwaveform:	equ	2
channellife:		equ	4
channelspeed:		equ	6
channelspeed2:		equ	8
channelfine:		equ	10
channelcoarse:		equ	12
channelreg:		equ	14
channeladd:		equ	16
channelcmp:		equ	18
channelprocess:		equ	20
channelnoise:		equ	22
channelreg2:		equ	24
channelvel:		equ	26
channelmixa:		equ	28
channelvolreg:		equ	30
channelfinereg:		equ	32
channelcoarsereg:	equ	34
channeloff:		equ	36
channelmixb:		equ	38
mmaxx:		equ	303
mminy:		equ	13
mmaxy:		equ	122
filled: 	equ	0
line:		equ	1
dots:		equ	2
obviewpb:	equ	0
obx:		equ	4
oby:		equ	6
obz:		equ	8
obvert: 	equ	10
obfacelist:	equ	14
obvrtnum:	equ	0
obfacenum:	equ	0
centrepoint:	equ	20
style:		equ	18
numdots:	equ	20
linecolinfo:	equ	20
obcolors:	equ	22
hidenflag:	equ	26
activeflag:	equ	28
canitbehit:	equ	30
obw:		equ	32
onscreenx:	equ	34
onscreeny:	equ	36
obint:		equ	38
obxvel: 	equ	40
obyvel: 	equ	42
obzvel: 	equ	44
evd:	equ	1
cred:	equ	2
wep:	equ	3
fuel:	equ	4
notn:	equ	0
bub:	equ	5
nogame: 	equ	0
parralax1a:	equ	1
parralax1b:	equ	2
parralax1c:	equ	3
parralax2a:	equ	4
parralax2b:	equ	5
parralax2c:	equ	6
trading:	equ	7
scrollera:	equ	8
scrollerb:	equ	9
scrollerc:	equ	10
gametype:	equ	0
prize:		equ	2
planetattacklist:	equ	4
planetgraphic:		equ	8
planetname:	equ	9
solnum: 	equ	0
solx:		equ	2
soly:		equ	4
planetnum:	equ	6
orbittype:	equ	8
solcx:		equ	10
solcy:		equ	12
defences:	equ	14
solname:	equ	16
regular:	equ	1
irregular:	equ	-1
nodefence:	equ	0
fighter1:	equ	1
fighter2:	equ	2
multidek:	equ	3
node:		equ	4
rho:		equ	0
theta:		equ	2
phi:		equ	4
s_theta:	equ	6
c_theta:	equ	8
s_phi:		equ	10
c_phi:		equ	12
s_rho:		equ	14
c_rho:		equ	16
dltad:		equ	8*9
dltshootx:	equ	72+4
dltshooty:	equ	72+4+2
ulx:		equ	0
uly:		equ	2
brx:		equ	4
bry:		equ	6
boomx:		equ	0
boomy:		equ	2
boomexp:	equ	4
boomframe:	equ	6
laserx: 	equ	0
lasery: 	equ	2
laserlife:	equ	4
xv8:		equ	4
yv8:		equ	4
active8:	equ	0
shotx8: 	equ	2
shoty8: 	equ	4
shotxvel8:	equ	6
shotyvel8:	equ	8
maxinertia:	equ	44
objhitcount:	equ	18
cspritex:	equ	0
cspritey:	equ	2
cspriteheight:	equ	8
cspritewidth:	equ	10
cspritead:	equ	4
cactive:	equ	12
cspritexvel:	equ	14
cspriteyvel:	equ	16
cattackcount:	equ	18
cspritex2:	equ	20
cspritey2:	equ	22
whatwep:	equ	14
bs:		equ	118
nsamount4:	equ	5
ewamount4:	equ	5
nsamount2:	equ	2
ewamount2:	equ	2
nsamount:	equ	25
ewamount:	equ	25
iea:	equ	$fffa07
ieb:	equ	$fffa09
isra:	equ	$fffa0f
ima:	equ	$fffa13
tbcr:	equ	$fffa1b
tbdr:	equ	$fffa21
vbl_vec:	equ	$70
*key_vec:	equ	$118
hbl_vec:	equ	$120
magic:		equ	1650
magic2: 	equ	1650
numstars:	equ	12
speed:		equ	350
zclip:		equ	100
xangle:		equ	0
yangle:		equ	2
xangadd:	equ	4
yangadd:	equ	6
xcount:		equ	8
ycount:		equ	10
start:
	dc.w	$a00a
	clr.l	-(SP)		;sup
	move.w	#$20,-(SP)
	trap	#1
	addq.l	#6,SP
	move.l	D0,savesup
	move.b	$484,save484
	move.b	#0,$484
	move.l	$426,rvsave
	move.l	$42a,resave
	move.l	$84,trappoke+2
	move.l	#mytrap,$84
	move.w	#4,-(sp)
	trap	#14
	addq.l	#2,sp
	move.w	d0,ressave

	move.w	#0,-(sp)	;low res
	move.l	#-1,-(sp)
	move.l	#-1,-(sp)
	move.w	#5,-(sp)
	trap	#14
	add.l	#12,sp

setupkey:
	move.w	#1,-(sp)
	move.w	#14,-(sp)
	trap	#14
	addq.l	#4,sp
	move.l	d0,keybuf
	jsr	getscrn
	jsr	plotinit
	jsr	clearboth
	move.b	ieb,oldieb
	move.b	iea,oldiea
	move.b	ima,oldima
	bsr	dotitle
	jsr	clearboth
	move.w	#-1,firebutton
	lea	bluepalette,a0
	jsr	mydocolors
	jsr	joystuff
	jsr	putrout
	jsr	prepchannels
	lea	channel0params,a0
	move.w	#%00001001,channeloff(a0)
	move.w	#-1,channelprocess(a0)
	lea	channel1params,a0
	move.w	#%00010010,channeloff(a0)
	move.w	#-1,channelprocess(a0)
	lea	channel2params,a0
	move.w	#%00100100,channeloff(a0)
	move.w	#-1,channelprocess(a0)
	jsr	setuphbl
	move.l	#fileshipcomp,filename
	jsr	loadscr
	move.l	#12345,d0
	jsr	randomseed
	move.w	#-1,firebutton
	jsr	copyintoboth
	move.w	#0,cursorx
	move.w	#0,cursory
	jsr	drawcircle
	jsr	initstars
	jsr	initstars2
	jsr	initstars3
	lea	radarvpb,a0
	move.w	#0,theta(a0)
	move.w	#192,phi(a0)
	move.w	#0,rho(a0)
	move.l	#sol0info,location
	move.l	#sol0info,destination
	move.l	#bluepalette,whichpalette
	jsr	resetsprites
	jmp	shipscomputer
testloop:
	jsr	joydir
	jsr	testdraw
	jsr	moveeverything
	jsr	flip_scr
	jsr	keyboard
	bra	testloop

scroll8wayloop:
	jsr	scroll8way
	jsr	stch
	jsr	joydir2
	jsr	dobaddies
	jsr	doobjective
	jsr	domeshoot8way
	jsr	drawshots8way
	jsr	dome8way
	jsr	collisions8
	jsr	pde6		;halfway through pdoexplosions
	jsr	doradar8
	jsr	flip_scr3
	jsr	keysbattle
	bra.s	scroll8wayloop

tunnelloop:
	jsr	joydir
	jsr	stch
	jsr	domyview
	jsr	dostartube
	jsr	dometeors
	jsr	tubeshoot
	jsr	moveshots
	jsr	drawpart1
	jsr	mecollisions
	jsr	shotcollisions
	jsr	dosight
	jsr	flip_scr
	jsr	keysbattle
	cmpi.w	#100,hypercount
	ble	tunnelover
	bra.s	tunnelloop

parra1loop:
	jsr	stch
	bsr	parralaxscroll
	jsr	joydir3
	jsr	pdoexplosions
	jsr	doattack
	jsr	checkwep
	jsr	pweppack
	jsr	pshoot
	jsr	pmyship
	jsr	pdocollisions
	jsr	flip_scr3
	jsr	keyboard
	bra.s	parra1loop
parra2loop:
	jsr	stch
	bsr	p2stars
	bsr	parralaxscroll2
	jsr	joydir3
	jsr	pdoexplosions
	jsr	doattack
	jsr	checkwep
	jsr	pweppack
	jsr	pshoot
	jsr	pmyship
	jsr	pdocollisions
	jsr	flip_scr4
	jsr	keyboard
	bra.s	parra2loop

fighter2loop:
	jsr	joydir3
	jsr	stch
	jsr	drawpart3
	jsr	dospacestars
	jsr	doobian
	jsr	doworld
	jsr	moveeverything
	jsr	battleshoot
	jsr	movebattleshots
	jsr	battleshotcollisions
	jsr	battlemecollisions
	jsr	sortndrawlist
	jsr	doradar
	jsr	dosight
	jsr	flip_scr
	jsr	keysbattle
	bra.s	fighter2loop

fighter1loop:
	jsr	joydir3
	jsr	stch
	jsr	drawpart2
	jsr	dospacestars
	jsr	dowarp
	jsr	doworld
	jsr	moveeverything
	jsr	battleshoot
	jsr	movebattleshots
	jsr	battleshotcollisions
	jsr	battlemecollisions
	jsr	sortndrawlist
	jsr	doradar
	jsr	dosight
	jsr	flip_scr
	jsr	keysbattle
	bra.s	fighter1loop

multideckloop:
	jsr	joydir3
	jsr	stch
	jsr	drawpart4
	jsr	dospacestars2
	jsr	autodeckdock
	jsr	dodeck
	jsr	deckshoot
	jsr	deckend
	jsr	doworld2
	jsr	moveeverything
	jsr	battleshoot
	jsr	movebattleshots
	jsr	battleshotcollisions
	jsr	battlemecollisions
	jsr	sortndrawlist
	jsr	doradar
	jsr	dosight
	jsr	flip_scr
	jsr	keysbattle
	bra.s	multideckloop

deckfightloop:
	jsr	stch
	bsr	dodeckmen
	bsr	dodecksight
	jsr	flip_scrdock
	jsr	keyboard
	bra.s	deckfightloop

dotrading:
	jsr	stch
	jsr	copysolar2
	jsr	copytextbit
	bsr	dopenta
	bsr	dotradecursor
	bsr	dombuttont
	jsr	flip_scr3
*	jsr	keyboard
	bra	dotrading

dotransaction:
	move.w	whichitem,d0
	cmpi.w	#7,d0		;is it trade
	bne	exitmaybe
	move.w	lastitem,d1	;what was the purchase
	bmi	notfuel
	cmpi.w	#0,d1		;is it sights
	bne	notsight
	tst.w	sightavail
	bpl	doalready
	cmpi.w	#500,credits
	blt	donotenough
	sub.w	#500,credits
	move.w	#1,sightavail
	move.w	#-1,whichitem
	move.w	#-1,lastitem
	bra	printafter
notsight:
	cmpi.w	#1,d1		;is it laser
	bne.s	notlaser
	tst.w	laser
	bpl	doalready
	cmpi.w	#3500,credits
	blt	donotenough
	sub.w	#3500,credits
	move.w	#1,laser
	move.w	#-1,whichitem
	move.w	#-1,lastitem
	bra	printafter
notlaser:
	cmpi.w	#2,d1		;is it laser
	bne.s	notdock
	tst.w	adsoftware
	bpl	doalready
	cmpi.w	#2000,credits
	blt	donotenough
	sub.w	#2000,credits
	move.w	#1,adsoftware
	move.w	#-1,whichitem
	move.w	#-1,lastitem
	bra	printafter
notdock:
	cmpi.w	#3,d1		;is it laser
	bne.s	notcloak
	tst.w	cloakingdevice
	bpl	doalready
	cmpi.w	#500,credits
	blt	donotenough
	sub.w	#500,credits
	move.w	#1,cloakingdevice
	move.w	#-1,whichitem
	move.w	#-1,lastitem
	bra	printafter
notcloak:
	cmpi.w	#4,d1		;is it laser
	bne.s	notamat
*	tst.w	amat
*	bpl	doalready
	cmpi.w	#500,credits
	blt	donotenough
	sub.w	#500,credits
	addq.w	#1,amat
	move.w	#-1,whichitem
	move.w	#-1,lastitem
	bra	printafter
notamat:
	cmpi.w	#5,d1		;is it laser
	bne.s	notirreg
	tst.w	orbitsoftware
	bpl	doalready
	cmpi.w	#5500,credits
	blt	donotenough
	sub.w	#5500,credits
	move.w	#1,orbitsoftware
	move.w	#-1,whichitem
	move.w	#-1,lastitem
	bra	printafter
notirreg:
	cmpi.w	#6,d1		;is it laser
	bne.s	notfuel
	cmpi.w	#1000,credits
	blt	donotenough
	sub.w	#1000,credits
	add.w	#250,shipsfuel
	move.w	#-1,whichitem
	move.w	#-1,lastitem
	bra	printafter
notfuel:
	move.w	#-1,whichitem
	rts

exitmaybe:
	cmpi.w	#8,d0		;is it exit
	bne.s	trans2		;nah just an item for purchase
	jsr	cleartext
	move.l	a6,a0
	jsr	printmany
	jsr	copysolar2
	jsr	copytextbit
	jsr	flip_scr3
	jsr	copysolar2
	jsr	copytextbit
	jsr	flip_scr3
	move.w	#-1,specialprsp
	move.l	#500000,d7	;display the exit msg for a bit
	jsr	generaldelay
	jsr	stopallsound
	addq.l	#8,sp		;remove return address
	jmp	shipscomputer	;bye
trans2:
	move.w	#-1,whichitem
	rts


donotenough:
	lea	errorsound,a1
	bsr	startsound
	jsr	cleartext
	lea	nomoneymsg,a0
	jsr	printmany
	move.w	#-1,whichitem
	rts
doalready:
	jsr	cleartext
	lea	alreadymsg,a0
	jsr	printmany
	move.w	#-1,whichitem
	rts



dopenta:
	lea	penta1,a0
	cmpi.w	#-8,expanding
	beq.s	skipbl
	subq.w	#1,expanding
	bmi.s	smaller
	sub.w	#130,obz(a0)
	bra.s	skipbl
smaller:
	add.w	#130,obz(a0)
skipbl:
	move.l	a0,whichob
	move.l	obviewpb(a0),a0
	addq.w	#8,theta(a0)
	addq.w	#4,rho(a0)
	addq.w	#5,phi(a0)
	jmp	dobefore


dotradecursor:
	lea	tcursorsprite,a0
	move.w	mx,(a0)
	move.w	my,2(a0)
	bsr	drawclipped
	rts

dombuttont:
	tst.w	changestate
	bpl	nodbt
	tst.w	buttondat
	beq	nodbt
	cmpi.w	#2,buttondat
	beq	nodbt
	lea	keyclicksound,a1
	bsr	startsound
	move.w	mx,d0
	move.w	my,d1
	lea	tradelist,a0
	moveq	#8,d7		;number of buttons
dmbloopt:
	move.w	(a0),d2
	cmp.w	d0,d2
	bgt.s	nodbft
	move.w	2(a0),d2
	cmp.w	d1,d2
	bgt.s	nodbft
	move.w	4(a0),d2
	cmp.w	d0,d2
	blt.s	nodbft
	move.w	6(a0),d2
	cmp.w	d1,d2
	blt.s	nodbft
	move.w	8(a0),d3
	tst.w	whichitem
	bmi.s	dontold
	move.w	whichitem,lastitem
dontold:
	move.w	d3,whichitem
	move.l	10(a0),a6	;text string for print many
	bsr	printitem
	cmpi.w	#-8,expanding
	bne.s	nodbt
	move.w	#8,expanding
	rts
nodbft:
	lea	14(a0),a0
	dbf	d7,dmbloopt
nodbt2:
	move.w	#-1,whichitem
nodbt:
	rts

printitem:
	cmpi.w	#7,d3
	beq	dotransaction
	cmpi.w	#8,d3
	beq	dotransaction
printafter:
	jsr	cleartext
	move.l	a6,a0
	jsr	printmany
	rts
*************************************************
*	Enter with a0 pointing at text to print	*
*************************************************
imdead1:
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	bsr	getboundaries
	move.l	#death1file,filename		;final frame
	move.l	specscreen1,wheretoload
	move.l	#51104,lengthtoread
	jsr	loadfile
	move.l	#death2file,filename		;final frame
	move.l	specscreen2,wheretoload
	move.l	#51104,lengthtoread
	jsr	loadfile
	jsr	restoremfp
	bsr	start512
	move.w	#1,-(sp)
	trap	#1
	addq.l	#2,sp
	bsr	stop512
	jmp	gem2

imdead2:
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	bsr	getboundaries
	move.l	#death3file,filename		;final frame
	move.l	specscreen1,wheretoload
	move.l	#32000,lengthtoread
	jsr	loadfile
	move.l	#death4file,filename		;final frame
	move.l	specscreen2,wheretoload
	move.l	#32000,lengthtoread
	jsr	loadfile
	jsr	restoremfp
	lea	death2palette,a0
	jsr	mydocolors
	bsr	startinterlace
	move.w	#1,-(sp)
	trap	#1
	addq.l	#2,sp
	bsr	stopinterlace
	jmp	gem


getboundaries:
	move.l	generalstore,a0
dtl1:
	move.l	a0,d0
	divu	#512,d0
	swap	d0
	tst.w	d0
	beq.s	dtl2
	addq.l	#2,a0
	bra	dtl1
dtl2:
	move.l	a0,specscreen1
	add.l	#32000,a0
	move.l	a0,colortable1
	add.l	#19104,a0
dtl3:
	move.l	a0,d0
	divu	#512,d0
	swap	d0
	tst.w	d0
	beq.s	dtl4
	addq.l	#2,a0
	bra	dtl3
dtl4:
	move.l	a0,specscreen2
	add.l	#32000,a0
	move.l	a0,colortable2
	rts
********************************
startinterlace:
	LEA	vblsave,A0
	move.l  $000004CE,(A0)		;vbl que save
	LEA     myintvbl,A0
	MOVE.L  A0,$000004CE		;address of my vbl rout
	RTS

stopinterlace:
	MOVE.L	vblsave,$000004CE	;restore old vbl
	rts
myintvbl:
	move.l	specscreen1,A6
	move.l	specscreen2,specscreen1
	move.l	A6,specscreen2
	move.b	specscreen1+1,$ff8201
	move.b	specscreen1+2,$ff8203
	rts
*******************************************
start512:
	move.l	colortable2,-(sp)
	move.l	specscreen2,-(sp)
	move.l	colortable1,-(sp)
	move.l	specscreen1,-(sp)
	move.w	#1,-(sp)
	bsr	show512
	add.l	#18,sp
	rts

stop512:
	move.w	#0,-(sp)
	jsr	show512
	addq.w	#2,sp
	rts

show512:
	MOVEM.L D3-D7/A3-A6,-(A7)	;save regs
	LEA     thisis26a,A6
	ST      $0001(A6)		;set true
	TST.W   $0028(A7)		;was it turn off ?
	BEQ     restoreeverything	;yep

	TST.B   (A6)		;is the vbl and mouse already fixed
	BNE	alreadyin	;yep

	MOVE.W  #2,-(A7)		;get screen physical
	TRAP    #14
	ADDQ.L  #2,A7			;stack cleanup
	MOVE.L  D0,$000C(A6)		;save screen address
	PEA     moff		;turn mouse off $12
	CLR.W   -(A7)			;length-1
	MOVE.W  #$0019,-(A7)		;send string to int keyboard
	TRAP    #14
	ADDQ.L  #8,A7			;clean stack

	MOVE.B  43(A7),$0002(A6)
	MOVE.B  44(A7),$0003(A6)
	MOVE.L  46(A7),$0004(A6)
	MOVE.B  51(A7),otherscreen1
	MOVE.B  52(A7),otherscreen2
	move.l	54(a7),otherpalette

	PEA	setup512vbl
	MOVE.W  #$0026,-(A7)		;execute in supervisor mode
	TRAP    #$E
	ADDQ.L  #6,A7			;clean stack
	BRA.S   skipalready
alreadyin:
	MOVE.B  $002B(A7),$0002(A6)
	MOVE.B  $002C(A7),$0003(A6)
	MOVE.L  $002E(A7),$0004(A6)
	MOVE.B  51(A7),otherscreen1
	MOVE.B  52(A7),otherscreen2
	move.l	54(a7),otherpalette

skipalready:
	TST.B   $0001(A6)
	BNE.S   skipalready
	BRA	exit

*	Turn off 512 color display	*
restoreeverything:
	TST.B	(A6)		;hadn't been started so no restore
	BEQ	exit
	PEA	restorethings
	MOVE.W	#$0026,-(A7)		;execute in supervisor
	TRAP	#14
	ADDQ.L  #6,A7			;clean stack

restorescreen:
	MOVE.W	#-1,-(A7)		;ignore res
	MOVE.L	$000C(A6),-(A7)		;put saved physbase
	MOVE.L	#-1,-(A7)		;ignore logical
	MOVE.W	#5,-(A7)		;set screen
	TRAP	#14
	LEA	$000C(A7),A7

	PEA	mon		;08 re-enable mouse
	CLR.W   -(A7)			;length-1
	MOVE.W  #$0019,-(A7)		;int keyboard sen
	TRAP    #14
	ADDQ.L  #8,A7			;clean stack
	SF      (A6)			;back to original state
exit:
	MOVEM.L (A7)+,D3-D7/A3-A6	;restore regs and return
	RTS


setup512vbl:
	LEA	$00FF8240,A0		;color reg 0
	LEA	savecolors,A1
	MOVE.W  #$000F,D7
savecoloop:
	MOVE.W  (A0)+,(A1)+
	dbf	D7,savecoloop

	LEA     $00FF8260,A0		;shift mode
	LEA	shiftsave,A1
	MOVE.B  (A0),(A1)		;save the shift mode
	CLR.B   (A0)			;set to low res

	LEA	vblsave,A0
	move.l  $000004CE,(A0)		;vbl que save
	move.b	$ff820a,d7
	btst	#1,d7
	bne	ispal
	LEA     my512vbl,A0
	MOVE.L  A0,$000004CE		;address of my vbl rout
	RTS
ispal:
	LEA     my512vblpal,A0
	MOVE.L  A0,$000004CE		;address of my vbl rout
	RTS

restorethings:
	MOVE.L	vblsave,$000004CE	;restore old vbl
	MOVE.B	shiftsave,$00FF8260	;restore old shift mode
	LEA	$00FF8240,A0		;color 0
	LEA	savecolors,A1
	MOVE.W	#$000F,D7
restorecoloop:
	MOVE.W	(A1)+,(A0)+
	DBF	D7,restorecoloop
	RTS

my512vblpal:
	TST.W   $0000043E	;do nothing if disk activity
	BNE     thisis268
	MOVE    SR,-(A7)	;save the sr
	ORI     #$0700,SR
	LEA     thisis26a,A0
	TST.B   (A0)
	BEQ     thisis246
	LEA     $00FF8240,A4	;color 0
	LEA     $00FF8209,A5	;vid address counter low
	LEA     thisis174p,A6
	MOVE.L	thisis272,A3
	LEA     $0020(A3),A3
	MOVE.W  #$00C4,D7
	CLR.L   D0
waitloopp:
	TST.B   (A5)
	BEQ.S   waitloopp

	MOVE.B  (A5),D0
	adda.l	d0,a6
	JMP     (A6)
thisis174p:
	rept	120
	nop
	endr
colloop1p:
	nop
	NOP
	LEA     (A4),A0
	LEA     (A4),A1
	LEA     (A4),A2
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A2)+
	MOVE.L  (A3)+,(A2)+
	MOVE.L  (A3)+,(A2)+
	MOVE.L  (A3)+,(A2)+
	MOVE.L  (A3)+,(A2)+
	MOVE.L  (A3)+,(A2)+
	MOVE.L  (A3)+,(A2)+
	MOVE.L  (A3)+,(A2)+
	DBF     D7,colloop1p
	nop
	LEA     (A4),A0
	LEA     (A4),A1
	LEA     (A4),A2
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A2)+
	MOVE.L  (A3)+,(A2)+
	MOVE.L  (A3)+,(A2)+
	MOVE.L  (A3)+,(A2)+
	MOVE.L  (A3)+,(A2)+
	MOVE.L  (A3)+,(A2)+
	MOVE.L  (A3)+,(A2)+
	MOVE.L  (A3)+,(A2)+
	LEA     (A4),A0
	LEA     (A4),A1
	LEA     (A4),A2
	lea	-$4a60(A3),A4
	NOP
	NOP
	nop
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A4)+,(A2)+
	MOVE.L  (A4)+,(A2)+
	MOVE.L  (A4)+,(A2)+
	MOVE.L  (A4)+,(A2)+
	MOVE.L  (A4)+,(A2)+
	MOVE.L  (A4)+,(A2)+
	MOVE.L  (A4)+,(A2)+
	MOVE.L  (A4)+,(A2)+
	LEA     thisis26a,A6
	ST      (A6)
	SF      $0001(A6)
	move.b	2(a6),d0
	move.b	otherscreen1,2(a6)
	move.b	d0,otherscreen1
	move.b	3(a6),d0
	move.b	otherscreen2,3(a6)
	move.b	d0,otherscreen2
	move.l	4(a6),d0
	move.l	otherpalette,4(a6)
	move.l	d0,otherpalette

	MOVE.B  $0002(A6),$00FF8201	;vidbasehi
	MOVE.B  $0003(A6),$00FF8203	;"   "  lo
	MOVE.L  $0004(A6),$0008(A6)
	MOVE    (A7)+,SR		;restore the sr
	RTS

my512vbl:
	TST.W   $0000043E	;flock, why I don't know
	BNE     thisis268
	MOVE    SR,-(A7)	;save the sr
	ORI     #$0700,SR
	LEA     thisis26a,A0
	TST.B   (A0)
	BEQ     thisis246
	LEA     $00FF8240,A4	;color 0
	LEA     $00FF8209,A5	;vid address counter low
	LEA     thisis174,A6
	MOVE.L thisis272,A3
	LEA     $0020(A3),A3
	MOVE.W  #$00C4,D7
	CLR.L   D0
waitloop:
	TST.B   (A5)
	BEQ.S   waitloop

	MOVE.B  (A5),D0
	CMP.B   #$18,D0
	BHI     thisis246
	ADDA.L  D0,A6
	JMP     (A6)
thisis174:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	MOVE.W  #$0018,D0
waitloop2:
	NOP
	DBF     D0,waitloop2
colloop1:
	NOP
	LEA     (A4),A0
	LEA     (A4),A1
	LEA     (A4),A2
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A2)+
	MOVE.L  (A3)+,(A2)+
	MOVE.L  (A3)+,(A2)+
	MOVE.L  (A3)+,(A2)+
	MOVE.L  (A3)+,(A2)+
	MOVE.L  (A3)+,(A2)+
	MOVE.L  (A3)+,(A2)+
	MOVE.L  (A3)+,(A2)+
	DBF     D7,colloop1

	LEA     (A4),A0
	LEA     (A4),A1
	LEA     (A4),A2
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A2)+
	MOVE.L  (A3)+,(A2)+
	MOVE.L  (A3)+,(A2)+
	MOVE.L  (A3)+,(A2)+
	MOVE.L  (A3)+,(A2)+
	MOVE.L  (A3)+,(A2)+
	MOVE.L  (A3)+,(A2)+
	MOVE.L  (A3)+,(A2)+
	LEA     (A4),A0
	LEA     (A4),A1
	LEA     (A4),A2
	lea	-$4a60(A3),A4
	NOP
	NOP
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A0)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A3)+,(A1)+
	MOVE.L  (A4)+,(A2)+
	MOVE.L  (A4)+,(A2)+
	MOVE.L  (A4)+,(A2)+
	MOVE.L  (A4)+,(A2)+
	MOVE.L  (A4)+,(A2)+
	MOVE.L  (A4)+,(A2)+
	MOVE.L  (A4)+,(A2)+
	MOVE.L  (A4)+,(A2)+
thisis246:
	LEA     thisis26a,A6
	ST      (A6)
	SF      $0001(A6)

	move.b	2(a6),d0
	move.b	otherscreen1,2(a6)
	move.b	d0,otherscreen1
	move.b	3(a6),d0
	move.b	otherscreen2,3(a6)
	move.b	d0,otherscreen2
	move.l	4(a6),d0
	move.l	otherpalette,4(a6)
	move.l	d0,otherpalette

	MOVE.B  $0002(A6),$00FF8201	;vidbasehi
	MOVE.B  $0003(A6),$00FF8203	;"   "  lo
	MOVE.L  $0004(A6),$0008(A6)
	MOVE    (A7)+,SR		;restore the sr
thisis268:
	rts

***************************************
prepchannels:
	move.b	#%00111111,d1
	moveq	#7,d0
	bsr	writedata
	moveq	#0,d1
	moveq	#8,d0
	bsr	writedata
	moveq	#0,d1
	moveq	#9,d0
	bsr	writedata
	moveq	#0,d1
	moveq	#10,d0
	bsr	writedata
	rts
stopallsound:
	lea	channel0params,a1
	move.w	#-1,channelprocess(a1)
	bsr	stopsound0
	lea	channel1params,a1
	move.w	#-1,channelprocess(a1)
	bsr	stopsound0
	lea	channel2params,a1
	move.w	#-1,channelprocess(a1)
	bsr	stopsound0
	rts
***************************************
dotitle:
	lea	titlepalette,a0
	jsr	mydocolors
	move.l	seen,a0
	move.w	#3999,d0
dtloop1:
	move.w	#0,(a0)+	;put all blue screen
	move.w	#-1,(a0)+
	move.w	#0,(a0)+
	move.w	#0,(a0)+
	dbf	d0,dtloop1
	move.l	#title1file,filename		;final frame
	move.l	hiden,wheretoload
	move.l	#32000,lengthtoread
	jsr	loadfilep
	move.l	#title2file,filename		;dlt file
	move.l	generalstore,wheretoload
	move.l	#90000,lengthtoread
	jsr	loadfilep
	move.l	generalstore,dltmemcount
	move.l	generalstore,dltsave
	moveq	#0,d3
	move.w	#12000,d7
	jsr	dodltt
	jsr	flip_scr3
	move.l	#title4file,filename		;dlt file
	move.l	generalstore,wheretoload
	move.l	#6000,lengthtoread
	jsr	loadfilep

	move.l	#960000,d7
	jsr	generaldelay
	bsr	waitvb
	lea	titlepalette1,a0
	jsr	mydocolors
	move.l	#20000,d7
	jsr	generaldelay
	bsr	waitvb
	lea	titlepalette2,a0
	jsr	mydocolors
	move.l	#20000,d7
	jsr	generaldelay
	bsr	waitvb
	lea	titlepalette3,a0
	jsr	mydocolors
	move.l	#20000,d7
	jsr	generaldelay
	bsr	waitvb
	lea	titlepalette4,a0
	jsr	mydocolors
	move.l	#20000,d7
	jsr	generaldelay
	bsr	waitvb
	lea	titlepalette5,a0
	jsr	mydocolors
	move.l	#20000,d7
	jsr	generaldelay
	bsr	waitvb
	lea	titlepalette6,a0
	jsr	mydocolors
	bsr	waitvb
	move.l	#20000,d7
	jsr	generaldelay
	lea	blackpal,a0
	jsr	mydocolors
	jsr	clearboth
	move.l	#title3file,filename		;dlt file
	move.l	hiden,wheretoload
	move.l	#32000,lengthtoread
	jsr	loadfilep
	move.l	hiden,a0
	move.l	seen,a1
	move.w	#3240-1,d0
cptl:
	move.l	(a0)+,(a1)+
	dbf	d0,cptl

	bsr	initialisedigi
	move.l	generalstore,d0
	move.l	d0,-(sp)
	add.l	#5000,d0
	move.l	d0,-(sp)
	move.w	#-1,-(sp)
	bsr	startsampsound
	add.l	#10,sp
	lea	titlepalette7,a0
	jsr	mydocolors
	move.l	#500000,d7
	jsr	generaldelay
	move.l	generalstore,d0
	move.l	d0,-(sp)
	add.l	#5000,d0
	move.l	d0,-(sp)
	move.w	#-1,-(sp)
	bsr	startsampsound
	add.l	#10,sp

	jsr	flip_scr3
	move.l	#1900000,d7
	jsr	generaldelay
	bsr	stopsound
	bsr	oldmfp
	rts

waitvb:
	move.w	#37,-(sp)
	trap	#14
	addq.l	#2,sp
	rts
***************************************
initialisedigi:
	BSR	SAVEMFP
	MOVE.W	#$2700,SR
	move.l	$114,old200
	move.l	#my200,$114
	LEA	INULL,A0
	BSR	SETINT
	MOVEQ	#0,D0		;freq=5k
	BSR	SETFREQ
	BSR	ENABMFP
	BSR	SETSND
	MOVE.W	mysr,SR	;ENABLE THE INTERRUPTS
	rts
my200:
	addq.l	#1,$4ba
	rte

*****************************************************************
startsampsound:
	move.w	4(sp),hr			;get the stuff off the stack
	move.l	#moff,-(sp)
	clr.w	-(sp)
	move.w	#25,-(sp)
	trap	#14
	addq.l	#8,sp
	move.l	10(sp),currentsad
	move.l	10(sp),soundstart
	move.l	6(sp),soundend
	bsr	setsnd
	lea	ireplay,a0
	bsr	setint
	rts
stopsound:
	move.l	#mon,-(sp)
	clr.w	-(sp)
	move.w	#25,-(sp)
	trap	#14
	addq.l	#8,sp
	lea	inull,a0
	bsr	setint
	rts


****************************************
*     THE NULL INTERRUPT ROUTINE       *
****************************************
inull:
	rte		;when not playing just return
****************************************
*       REPLAY FROM MEMORY             *
****************************************
IREPLAY:
	movem.l	d0/d3/d4/d5/d7/a0/a3/a4/a6,-(sp)
	move.w	#$2500,sr
	MOVEQ	#0,D7
	move.l	currentsad,a6	;current sample address
	MOVE.B	(A6)+,D7	;get the sample
	CMP.L	soundend,A6	;is it past the end
	BGT.S	haltorrepeat	;you betcha
	move.l	a6,currentsad
	bra.s	INTOUTP		;ELSE OUTPUT IT
haltorrepeat:
	tst.w	hr		;should it stop or repeat
	bmi.s	onceonly
	move.l	soundstart,currentsad
	movem.l	(sp)+,d0/d3/d4/d5/d7/a0/a3/a4/a6
	RTE
onceonly:
	lea	inull,a0
	bsr	setint
	movem.l	(sp)+,d0/d3/d4/d5/d7/a0/a3/a4/a6
	RTE

INTOUTP:
	lea	screg,a4
	MOVE.B	#7,(a4)		;SET UP CHANNEL MIXING & PORT 'A' I/O
	MOVE.B	#$FF,SCDATA
	lea	snd_out,a3
	AND.W	#$00FF,D7	;MASK OFF RUBBISH
	ADD.B	#$80,D7		;COMPLENT VALUE
	LSL.W	#3,D7		;DOUBLE LONG WORD OFFSET
	MOVE.L	0(A3,D7.W),d5	;GET DATA #1
	MOVE.W	4(A3,D7.W),D4	;GET DATA #2
	MOVEP.L	D5,0(A4)	;PLAY #1
	MOVEP.W	D4,0(A4)	;PLAY #2
	move.w	#$2000,sr
	movem.l	(sp)+,d0/d3/d4/d5/d7/a0/a3/a4/a6
	RTE

savemfp:
	move.w	sr,mysr
	MOVE.B	IERA,MFPMEM		;save all this shit for later
	MOVE.B	IERB,MFPMEM+1
	MOVE.B	IMRA,MFPMEM+2
	MOVE.B	IMRB,MFPMEM+3
	MOVE.B	TADR,MFPMEM+4
	MOVE.B	TACR,MFPMEM+5
	MOVE.B	VECTOR,MFPMEM+6
	rts
oldmfp:
	move.l	old200,$114
	MOVE.B	MFPMEM+6,VECTOR		;put back what we found
	MOVE.B	MFPMEM+5,TACR
	MOVE.B	MFPMEM+4,TADR
	MOVE.B	MFPMEM+3,IMRB
	MOVE.B	MFPMEM+2,IMRA
	MOVE.B	MFPMEM+1,IERB
	MOVE.B	MFPMEM,IERA
	move.w	mysr,sr
	RTS

setint:
	MOVE.W	SR,D0
	MOVE.W	#$2700,SR	;interrupts begone
	MOVE.L	A0,ISRVEC
	MOVE.W	D0,SR
	RTS
setfreq:
	MOVE.B	#0,TACR
	AND.W	#7,D0
	LEA	FREQTAB,A0
	LSL.W	#1,D0
	MOVE.W	0(A0,D0.W),D0
	MOVE.B	D0,TACR
	LSR.W	#8,D0
 	MOVE.B	D0,TADR
	RTS
enabmfp:
	bset	#5,IMRA
	bset	#5,IERA
	BCLR	#3,VECTOR
	RTS
setsnd:
	MOVE.B	#0,SCREG	;CHANNEL A
	MOVE.B	#0,SCDATA
	MOVE.B	#1,SCREG
	MOVE.B	#0,SCDATA

	MOVE.B	#2,SCREG	;CHANNEL B
	MOVE.B	#0,SCDATA
	MOVE.B	#3,SCREG
	MOVE.B	#0,SCDATA

	MOVE.B	#4,SCREG	;CHANNEL C
	MOVE.B	#0,SCDATA
	MOVE.B	#5,SCREG
	MOVE.B	#0,SCDATA

	MOVE.B	#7,SCREG	;SET UP CHANNEL MIXING & PORT 'A' I/O
	MOVE.B	#$FF,SCDATA

	MOVE.B	#8,SCREG	;SET ALL VOLUMES TO ZERO
	MOVE.B	#0,SCDATA
	MOVE.B	#9,SCREG
	MOVE.B	#0,SCDATA
	MOVE.B	#10,SCREG
	MOVE.B	#0,SCDATA
	RTS

***************************************
dosound:
	lea	channel0params,a1
	bsr	dosoundstuff
	lea	channel1params,a1
	bsr	dosoundstuff
	lea	channel2params,a1
dosoundstuff:
	tst.w	channelprocess(a1)
	bmi	noch0
	tst.w	channelcmp(a1)
	beq	still0
	subq.w	#1,channellife(a1)
	bpl	still0
	move.w	#-1,channelprocess(a1)
	bra	stopsound0
still0:
	tst.w	channelwaveform(a1)	;does it need shaping
	bmi	skip0waveforms
	subq.w	#1,channelspeed2(a1)
	tst.w	channelspeed2(a1)
	bpl	skip0waveforms
	move.w	channelspeed(a1),channelspeed2(a1)
	cmpi.w	#0,channelwaveform(a1)
	bne	ch0p1
	move.w	channelvolume(a1),d1
	addq.w	#1,d1
	cmpi.w	#15,d1
	blt	ch0pl
	moveq	#14,d1
ch0pl:
	bra	finalwaveform
ch0p1:
	cmpi.w	#1,channelwaveform(a1)
	bne	ch0p2
	move.w	channelvolume(a1),d1
	subq.w	#1,d1
	cmpi.w	#0,d1
	bge	ch0pu
	moveq	#0,d1
ch0pu:
	bra	finalwaveform
ch0p2:
	cmpi.w	#2,channelwaveform(a1)
	bne	ch0p3
	move.w	channelvolume(a1),d1
	move.w	channelvel(a1),d2
	add.w	d2,d1
	cmpi.w	#0,d1
	bgt	ch0saw1
	neg.w	channelvel(a1)
	bra	ch0saw2
ch0saw1:
	cmpi.w	#14,d1
	blt	ch0saw2
	neg.w	channelvel(a1)
ch0saw2:
	bra	finalwaveform
ch0p3:
	cmpi.w	#3,channelwaveform(a1)
	bne	ch0p4
	move.w	channelvolume(a1),d1
	addq.w	#1,d1
	cmpi.w	#15,d1
	blt.s	ch0p3b
	moveq	#0,d1
ch0p3b:
	bra	finalwaveform
ch0p4:
	move.w	channelvolume(a1),d1
	subq.w	#1,d1
	bpl	finalwaveform
	moveq	#14,d1
finalwaveform:
	move.w	d1,channelvolume(a1)
	move.w	channelvolreg(a1),d0
	bsr	writedata
skip0waveforms:
	moveq	#0,d7
	move.w	channelreg(a1),d7
	bmi	noch0
	move.w	channelreg2(a1),d2
	move.w	(a1,d2.w),d1
	add.w	channeladd(a1),d1
	cmp.w	channelcmp(a1),d1
	bne	not0end
	move.w	#-1,channelprocess(a1)
	bsr	stopsound0
not0end:
	move.w	d1,(a1,d2.w)
	move.w	d7,d0
	bsr	writedata
noch0:
	rts
stopsound0:
	moveq	#0,d1
	move.w	channelvolreg(a1),d0
	bsr	writedata
	move.b	mymixer,d1
	or.w	channeloff(a1),d1	;reg
	move.b	d1,mymixer
	move.b	#7,d0
	bsr	writedata
	rts


writedata:
	move.b	d0,$ff8800
	cmp.b	#7,d0
	bne	wd2
	and.b	#$3f,d1
	move.b	$ff8800,d0
	and.b	#$c0,d0
	or.b	d0,d1
wd2:
	move.b	d1,$ff8802
	rts
*****************************************
*	Pass ad of soundata in a1	*
*****************************************
startsound:
	movem.l	d0-d1/a0,-(sp)
	cmpi.w	#0,channelprocess(a1)
	bne	start1
	lea	channel0params,a0
	bra	startit
start1:
	cmpi.w	#1,channelprocess(a1)
	bne	start2
	lea	channel1params,a0
	bra	startit
start2:
	lea	channel2params,a0
startit:
	move.l	a0,-(sp)
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.w	#-1,(a0)+
	addq.l	#2,a1		;skip channelprocess
	move.w	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(sp)+,a0
	move.w	channelfine(a0),d1
	move.w	channelfinereg(a0),d0
	bsr	writedata
	move.w	channelcoarse(a0),d1
	move.w	channelcoarsereg(a0),d0
	bsr	writedata
	move.w	channelvolume(a0),d1
	move.w	channelvolreg(a0),d0
	bsr	writedata
	move.w	channelnoise(a0),d1
	beq.s	nonoise
	moveq	#6,d0
	bsr	writedata
	move.w	channelmixa(a0),d1
	bclr	d1,mymixer
	bra.s	skipkl
nonoise:
	move.w	channelmixa(a0),d1
	bset	d1,mymixer
skipkl:
	move.w	channelmixb(a0),d1
	bclr	d1,mymixer
	move.b	mymixer,d1
	moveq	#7,d0
	bsr	writedata
	move.w	#1,channelprocess(a0)
	movem.l	(sp)+,d0-d1/a0
	rts

***************************************
docorriboom:
	move.l	location,a0	;if dest this way gone for ever
	move.w	#nodefence,defences(a0)
	move.w	#-1,dontpulse
	lea	pexp1,a0
	move.w	#-1,boomframe(a0)
	lea	pexp2,a0
	move.w	#-1,boomframe(a0)
	lea	pexp3,a0
	move.w	#-1,boomframe(a0)
	move	#90,d7
dcorl:
	move.w	d7,-(sp)
	lea	pexp1,a0
	tst.w	boomframe(a0)
	bpl	docor2a
	bsr	dorandbstuff
	tst.w	d0
	bmi.s	docor2
docor2a:
	jsr	parra1expansion
docor2:
	lea	pexp2,a0
	tst.w	boomframe(a0)
	bpl	docor3a
	bsr	dorandbstuff
	tst.w	d0
	bmi.s	docor3
docor3a:
	jsr	parra1expansion
docor3:
	lea	pexp3,a0
	tst.w	boomframe(a0)
	bpl	docor4a
	bsr	dorandbstuff
	tst.w	d0
	bmi.s	docor4
docor4a:
	jsr	parra1expansion
docor4:
	jsr	flip_scrdock
	move.w	(sp)+,d7
	dbf	d7,dcorl

	move.w	shipenergy,d7
	asr.w	#2,d7
	sub.w	d7,shipsfuel

	move.w	#0,myviewx
	move.w	#0,myviewy
	lea	ship3s,a0
	move.w	#0,obx(a0)
	move.w	#60,oby(a0)
	move.w	#-1,activeflag(a0)
	move.l	obviewpb(a0),a1
	move.w	#10,phi(a1)
	move.w	#128,rho(a1)
	move.w	#64,theta(a1)
	move.w	#6000,obz(a0)

	lea	multideck,a0
	move.w	#0,obx(a0)
	move.w	#0,oby(a0)
	move.w	#100,obz(a0)
	move.l	obviewpb(a0),a1
	move.w	#128,phi(a1)
	move.w	#0,rho(a1)
	move.w	#0,theta(a1)
	move.l	#bluepalette,whichpalette
	move.w	#0,battlespeed
	move.w	#0,battlespeed2
	lea	multi1sound,a1
	jsr	startsound
	lea	multi2sound,a1
	jsr	startsound
leavedeckloop1:
	lea	multideck,a0
	add.w	#50,obz(a0)
	cmpi.w	#5000,obz(a0)
	bge.s	dloopover1
	jsr	drawdeckleave
	jsr	dospacestars2
	jsr	dodeck
	jsr	sortndrawlist
	jsr	doradar
	jsr	flip_scr
	bra.s	leavedeckloop1
dloopover1:
	cmpi.w	#20,shipsfuel
	blt	dloopover
	lea	leavemultisound,a1
	jsr	startsound
	lea	ship3s,a0
	move.w	#1,activeflag(a0)
leavedeckloop:
	lea	ship3s,a0
	move.l	obviewpb(a0),a1
	addq.w	#6,theta(a1)
	sub.w	#100,obz(a0)
	cmpi.w	#0,obz(a0)
	ble.s	dloopover
	jsr	drawdeckleave
	jsr	dospacestars2
	jsr	dodeck
	jsr	sortndrawlist
	jsr	doradar
	jsr	flip_scr
	bra.s	leavedeckloop
dloopover:
	jmp	dodeckboom

dorandbstuff:
	moveq	#100,d0
	jsr	random
	tst.w	d0
	bmi.s	bbackc
	lea	tubeexplodesound,a1
	jsr	startsound
	move.w	#165,boomx(a0)
	move.w	#65,boomy(a0)
	moveq	#5,d0
	jsr	random
	add.w	d0,boomy(a0)
	moveq	#3,d0
	jsr	randomplus
	addq.w	#1,d0
	move.w	d0,boomexp(a0)
	move.w	#13,boomframe(a0)
	moveq	#1,d0
bbackc:
	rts
***************************************
dodecksight:
	tst.w	changestate
	bpl	putdecksight
	tst.w	buttondat
	beq	putdecksight
	lea	meshootdecksound,a1
	jsr	startsound
	move.w	mx,d0
	move.w	my,d1
	move.w	#16,x1
	move.w	#123,y1
	move.w	d0,x2
	move.w	d1,y2
	addq.w	#7,x2
	addq.w	#8,y2
	move.w	#14,linecolor
	jsr	clipit
	move.w	#320-16,x1
	move.w	#123,y1
	move.w	d0,x2
	move.w	d1,y2
	add.w	#9,x2
	addq.w	#8,y2
	jsr	clipit
	move.w	d0,d2
	move.w	d1,d3
	addq.w	#8,d2
	addq.w	#8,d3
	cmpi.w	#151,d2
	ble.w	nohitdoor
	cmpi.w	#53,d3
	ble.w	nohitdoor
	cmpi.w	#169,d2
	bge.w	nohitdoor
	cmpi.w	#84,d3
	bge	nohitdoor
	lea	hitdoorsound,a1
	jsr	startsound
	addq.w	#1,doorhits
	cmpi.w	#10,doorhits
	bne.s	morethan10
	movem.w	d0-d1,-(sp)
	move.l	screen3,whichscreen
	lea	doorsp,a0
	move.w	#155,(a0)
	move.w	#55,2(a0)
	jsr	putsprite
	movem.w	(sp)+,d0-d1
	bra.s	nohitdoor
morethan10:
	cmpi.w	#25,doorhits
	bne.s	morethan20
	movem.w	d0-d1,-(sp)
	move.l	screen3,whichscreen
	lea	doorsp,a0
	move.w	#153,(a0)
	move.w	#55,2(a0)
	jsr	putsprite
	movem.w	(sp)+,d0-d1
	bra.s	nohitdoor
morethan20:
	cmpi.w	#50,doorhits
	bne.s	nohitdoor
	bra	docorriboom

nohitdoor:
	tst.w	doingman
	bmi	putdecksight
	tst.w	dltframe
	beq	putdecksight
	cmpi.w	#10,dltframe
	bge	putdecksight
	addq.w	#8,d0
	addq.w	#8,d1
	move.l	whichman,a0
	move.w	dltframe,d2
	asl.w	#3,d2
	move.w	(a0,d2.w),d3	;get ulx
	move.w	2(a0,d2.w),d4	;get uly
	move.w	4(a0,d2.w),d5	;get brx
	move.w	6(a0,d2.w),d6	;get bry
	cmp.w	d0,d3
	bge.w	putdecksight
	cmp.w	d1,d4
	bge.w	putdecksight
	cmp.w	d0,d5
	ble.s	putdecksight
	cmp.w	d1,d6
	ble.s	putdecksight
	move.w	d0,pixelx
	move.w	d1,pixely
	jsr	mygetpix
	subq.w	#2,d0
	bmi.s	putdecksight
	cmpi.w	#4,d0
	bgt.s	putdecksight
	lea	exploparasound,a1
	jsr	startsound
	move.w	#-1,doingman
	bsr	finishman
	
putdecksight:
	move.l	hiden,whichscreen
	lea	sightsp,a0
	move.w	mx,d0
	cmpi.w	#320-16-15,d0
	ble.s	ddsok1
	move.w	#320-16-15,d0
	move.w	d0,mx
ddsok1:
	move.w	my,d1
	cmpi.w	#123-15,d1
	ble.s	ddsok2
	move.w	#123-15,d1
	move.w	d1,my
ddsok2:
	move.w	d0,(a0)
	move.w	d1,2(a0)
	jsr	putsprite
	rts

	
***************************************
dodeckmen:
	tst.w	doingman
	bpl.s	continueman
	move.w	#100,d0
	jsr	randomplus
	cmpi.w	#5,d0
	bge.s	noman
	lea	manlist,a0
	moveq	#6,d0
	jsr	randomplus
	asl.w	#2,d0
	move.l	(a0,d0.w),a0
	move.l	a0,whichman
	move.l	dltad(a0),dltmemcount
	move.l	dltmemcount,dltsave
	move.w	#1,doingman
	move.w	#0,dltframe
	move.w	#1,dltdelay
*	move.w	#1,manhits
	rts
noman:
	move.w	#-1,doingman
	rts
continueman:
	bsr	dodltd
	rts


dodltd:
	subq.w	#1,dltdelay
	bpl.s	nodltd
	move.w	#6,dltdelay
	addq.w	#1,dltframe
	cmpi.w	#5,dltframe
	bne	dltsht
	move.w	#20,dltdelay
dltsht:
	move.l	dltmemcount,a0
	move.l	screen3,a1
	move.w	(a0)+,d0
	beq.s	dltoverd
	subq.w	#1,d0
dodltloopd:
	move.w	(a0)+,d1
	move.l	(a0)+,d2
	eor.l	d2,(a1,d1.w)
	dbf	d0,dodltloopd
	move.l	a0,dltmemcount
	rts
nodltd:
	cmpi.w	#5,dltframe
	beq	dltshooting
	rts
dltoverd:
	move.w	#-1,doingman
	rts

dltshooting:
	lea	robotshootsound,a1
	jsr	startsound
	move.l	whichman,a0
	move.w	dltshootx(a0),x1
	move.w	dltshooty(a0),y1
	move.w	#122,y2
	move.w	#320-32,d0
	jsr	randomplus
	add.w	#16,d0
	move.w	d0,x2
	move.w	#15,linecolor
	jsr	clipit
	addq.w	#1,shipenergy
	rts


finishman:
	move.l	dltmemcount,a0
	move.l	screen3,a1
	move.w	(a0)+,d0
	beq.s	dltfin
	subq.w	#1,d0
finloop:
	move.w	(a0)+,d1
	move.l	(a0)+,d2
	eor.l	d2,(a1,d1.w)
	dbf	d0,finloop
	move.l	a0,dltmemcount
	bra	finishman
dltfin:
	rts
*********************************************************
* Inter solar flight stuff, called after planetary	*
* course set.information for dest in planetdestination	*
*********************************************************
intersol:
	tst.l	planetdestination
	bmi	donosetmsg
	move.w	#1,dontpulse
	move.l	planetdestination,a0
	cmpi.b	#0,planetgraphic(a0)
	bne	it2
	move.l	#plan1file,filename
	bra	it4
it2:
	cmpi.b	#1,planetgraphic(a0)
	bne	it3
	move.l	#plan2file,filename
	bra	it4
it3:
	move.l	#plan3file,filename
it4:
	move.l	#planetpalette,whichpalette
	move.l	generalstore,wheretoload
	add.l	#81000,wheretoload
	move.l	#14400,lengthtoread
	jsr	loadfile
	move.l	wheretoload,planetmem2
	move.l	planetmem2,planetmem1
	add.l	#14400,planetmem1
	bsr	preplanet
	bsr	prepstars
	bsr	prepath
intersoloop:
	jsr	joydir4
	jsr	domyview2
	bsr	planet
	bsr	pstars
	bsr	dopath
	jsr	drawsol
	jsr	dosight
	jsr	flip_scrsol
	jsr	keyboard
	bra	intersoloop
*	NOTE should reset dontpulse to -1 before returning	*

drawsol:
	lea	drawlist,a0
	move.w	#6,(a0)+
	move.l	#path0,(a0)+
	move.l	#path1,(a0)+
	move.l	#path2,(a0)+
	move.l	#path3,(a0)+
	move.l	#path4,(a0)+
	move.l	#path5,(a0)+
	jmp	sortndrawlist2


donosetmsg:
	lea	errorsound,a1
	jsr	startsound
	jsr	cleartext
	jsr	flip_scr2
	jsr	flip_scr2
	lea	nosetmsg,a0
	jsr	printmany	
	jsr	flip_scr2
	jsr	flip_scr2
	move.l	#1000000,d7
	jsr	generaldelay
	jmp	shipscomputer

************************************************
prepath:
	lea	path0,a0
	move.w	#7000,obz(a0)
	bsr	doprepath
	lea	path1,a0
	move.w	#8000,obz(a0)
	bsr	doprepath
	lea	path2,a0
	move.w	#9000,obz(a0)
	bsr	doprepath
	lea	path3,a0
	move.w	#10000,obz(a0)
	bsr	doprepath
	lea	path4,a0
	move.w	#11000,obz(a0)
	bsr	doprepath
	lea	path5,a0
	move.w	#12000,obz(a0)
	bsr	doprepath
	move.w	#0,myviewx
	move.w	#0,myviewy
	move.w	#20,pathcount	;number to go through
	move.w	#0,pathx
	moveq	#120,d0
	jsr	random
	move.w	d0,trendxwhere
	move.w	#0,trendx
	move.w	#0,pathy
	moveq	#120,d0
	jsr	random
	move.w	d0,trendywhere
	move.w	#0,trendy
	move.w	#20,wobblecount
	rts

doprepath:
	move.w	#0,obx(a0)
	move.w	#0,oby(a0)
	move.w	#1,activeflag(a0)
	rts
dopath:
	lea	path0,a0
	bsr	dopathstuff
	lea	path1,a0
	bsr	dopathstuff
	lea	path2,a0
	bsr	dopathstuff
	lea	path3,a0
	bsr	dopathstuff
	lea	path4,a0
	bsr	dopathstuff
	lea	path5,a0
	bsr	dopathstuff
	rts

dopathstuff:
	tst.w	activeflag(a0)
	bmi	dpsback
	cmpi.w	#1200+4*80,obz(a0)
	bne	dpns
	lea	passingsound,a1
	jsr	startsound
dpns:	sub.w	#80,obz(a0)
	bpl	dpsback
	subq.w	#1,pathcount
	bmi	pathsuccess
	cmpi.w	#5,pathcount
	bge	notnear
	move.w	#-1,activeflag(a0)
notnear:
	bsr	pathtest
	subq.w	#1,wobblecount
	bpl	justreset
	move.w	#10,d0
	jsr	randomplus
	move.w	d0,wobblecount
	move.w	pathx,trendxwhere
	move.w	pathy,trendywhere
	move.w	#80,d0
	jsr	random
	move.w	d0,trendx
	move.w	#80,d0
	jsr	random
	move.w	d0,trendy
justreset:
	move.w	#6000,obz(a0)
	move.w	trendx,d0
	add.w	d0,pathx
	move.w	pathx,obx(a0)
	move.w	trendy,d0
	add.w	d0,pathy
	move.w	pathy,oby(a0)
	move.w	trendxwhere,d0
	cmp.w	pathx,d0
	bgt.s	jr1
	sub.w	#15,trendx
	bra.s	jr2
jr1:
	add.w	#15,trendx
jr2:
	move.w	trendywhere,d0
	cmp.w	pathy,d0
	bgt.s	jr3
	sub.w	#15,trendy
	bra.s	jr4
jr3:
	add.w	#15,trendy
jr4:
dpsback:
	rts

putpsearch:
	move.l	generalstore,a0
	add.l	#81000,a0
	move.l	seen,a1
	lea	4216(a1),a1
	moveq	#83,d0
ppschl:
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	lea	112(a1),a1
	dbf	d0,ppschl
	rts
pathsuccess:
	addq.l	#8,sp	;kick out 2 return addresses
	lea	shiptrade1,a1
	bsr	startsound
	move.w	#0,myviewx
	move.w	#0,myviewy
	lea	ship3,a0
	move.w	#0,obx(a0)
	move.w	#0,oby(a0)
	move.w	#1,activeflag(a0)
	move.l	obviewpb(a0),a1
	move.w	#20,phi(a1)
	move.w	#0,rho(a1)
	move.w	#64,theta(a1)
	move.l	a0,whichob
	move.w	#0,obz(a0)
	move.w	#-30,ycurve
pathsloop:
	lea	channel0params,a0
	tst.w	channelprocess(a0)
	bpl	skipsoundp
	lea	shiptrade2,a1
	jsr	startsound
skipsoundp:
	lea	ship3,a0
	move.l	a0,whichob
	addq.w	#1,ycurve
	move.w	ycurve,d0
	sub.w	d0,oby(a0)
	move.l	obviewpb(a0),a1
	subq.w	#1,phi(a1)
	add.w	#300,obz(a0)
	cmpi.w	#30000,obz(a0)
	bge	pslover
	bsr	planet
	bsr	pstars
	jsr	dobefore2
	jsr	dosight
	jsr	flip_scrsol
	jsr	keyboard
	bra	pathsloop
pslover:
	jsr	flip_scr
	jsr	flip_scr		;clear it
	move.w	#-1,dontpulse
	move.l	planetdestination,a0
isnogame:
	cmpi.w	#nogame,gametype(a0)
	bne	isparra1a
	jsr	cleartext
	jsr	flip_scr2
	jsr	flip_scr2
	lea	searchmsg,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	move.l	#psearchfile1,filename
	move.l	generalstore,a0 	;load in raw prerotated data
	add.l	#81000,a0		;for scroll
	move.l	a0,wheretoload
	move.l	#5000,lengthtoread
	jsr	loadfile
	lea	tradesound,a1
	jsr	startsound
	lea	searchsound,a1
	jsr	startsound
	move.w	#1,dontpulse
	move.l	#psearchpalette,whichpalette
	bsr	putpsearch
	move.l	#psearchfile2,filename
	move.l	generalstore,a0 	;load in raw prerotated data
	add.l	#81000,a0		;for scroll
	move.l	a0,wheretoload
	move.l	a0,dltmemcount
	move.l	#29620,lengthtoread
	jsr	loadfile
	move.l	dltmemcount,dltsave
	move.w	#1,d3
	move.w	#17000,d7
	bsr	dodlt
	move.l	#bluepalette,whichpalette
	move.w	#-1,dontpulse
	jsr	stopallsound
	jsr	cleartext
	jsr	flip_scr2
	jsr	flip_scr2
	jsr	interference
	lea	nofindmsg,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	move.l	#2500000,d7
	jsr	generaldelay
	jmp	shipscomputer
isparra1a:
	cmpi.w	#parralax1a,(a0)
	bne	isparra1b
	sub.w	#20,shipsfuel
	cmpi.w	#20,shipsfuel
	bgt	die1
	move.l	planetattacklist(a0),atlist
	bsr	resetsprites2
	move.l	#parra1afile,filename
	bsr	dogenstuff
	move.l	#spritefile,filename
	jsr	setupclippedsprite
	move.l	#parra1apalette,whichpalette
	move.l	#-1,savepalette
	move.w	#2,shipenergy
	move.w	#-1,loadflag
	jmp	parra1loop
isparra1b:
	cmpi.w	#parralax1b,(a0)
	bne	isparra1c
	sub.w	#20,shipsfuel
	cmpi.w	#20,shipsfuel
	bgt	die1
	move.l	planetattacklist(a0),atlist
	bsr	resetsprites2
	move.l	#parra1bfile,filename
	bsr	dogenstuff
	move.l	#spritefile,filename
	jsr	setupclippedsprite
	move.l	#parra1apalette,whichpalette
	move.l	#-1,savepalette
	move.w	#2,shipenergy
	move.w	#-1,loadflag
	jmp	parra1loop
isparra1c:
	cmpi.w	#parralax1c,(a0)
	bne	isparra2a
	sub.w	#20,shipsfuel
	cmpi.w	#20,shipsfuel
	bgt	die1
	move.l	planetattacklist(a0),atlist
	bsr	resetsprites2
	move.l	#parra1cfile,filename
	bsr	dogenstuff
	move.l	#spritefile,filename
	jsr	setupclippedsprite
	move.l	#parra1apalette,whichpalette
	move.l	#-1,savepalette
	move.w	#2,shipenergy
	move.w	#-1,loadflag
	jmp	parra1loop
isparra2a:
	cmpi.w	#parralax2a,(a0)
	bne	isparra2b
	sub.w	#20,shipsfuel
	cmpi.w	#20,shipsfuel
	bgt	die1
	move.l	planetattacklist(a0),atlist
	bsr	resetsprites2
	jsr	setupscrolla
	move.l	#spritefile2,filename
	jsr	setupclippedsprite
	bsr	preparra2stars
	move.w	#2,shipenergy
	move.l	whichpalette,savepalette
	move.w	#1,loadflag
	jmp	parra2loop
isparra2b:
	cmpi.w	#parralax2b,(a0)
	bne	isparra2c
	sub.w	#20,shipsfuel
	cmpi.w	#20,shipsfuel
	bgt	die1
	move.l	planetattacklist(a0),atlist
	bsr	resetsprites2
	jsr	setupscrollb
	move.l	#spritefile2,filename
	jsr	setupclippedsprite
	bsr	preparra2stars
	move.w	#2,shipenergy
	move.l	whichpalette,savepalette
	move.w	#1,loadflag
	jmp	parra2loop
isparra2c:
	cmpi.w	#parralax2c,(a0)
	bne	isscrollera
	sub.w	#20,shipsfuel
	cmpi.w	#20,shipsfuel
	bgt	die1
	move.l	planetattacklist(a0),atlist
	bsr	resetsprites2
	jsr	setupscrollc
	move.l	#spritefile2,filename
	jsr	setupclippedsprite
	bsr	preparra2stars
	move.w	#2,shipenergy
	move.l	whichpalette,savepalette
	move.w	#1,loadflag
	jmp	parra2loop
isscrollera:
	cmpi.w	#scrollera,(a0)
	bne	isscrollerb
	sub.w	#20,shipsfuel
	cmpi.w	#20,shipsfuel
	bgt	die1
	move.l	#-1,savepalette
*	move.l	planetattacklist(a0),atlist
	bsr	resetsprites2
	bsr	resetshots2
	move.l	#backfile1,filename
	jsr	setup8way
	move.l	#spritefile3,filename
	jsr	setupclippedsprite2
	lea	obj1sp,a0
	move.w	#1600,d0
	jsr	random
	move.w	d0,cspritex2(a0)
	move.w	#1600,d0
	jsr	random
	move.w	d0,cspritey2(a0)
	move.w	#20,objhitcount(a0)
	move.w	#200,shipenergy
	move.w	#0,scrollx
	move.w	#0,scrolly
	move.w	#100,boom8delay
	move.w	#1,loadflag
	move.l	#way8palette,whichpalette
	jmp	scroll8wayloop
isscrollerb:
	cmpi.w	#scrollerb,(a0)
	bne	isscrollerc
	sub.w	#20,shipsfuel
	cmpi.w	#20,shipsfuel
	bgt	die1
*	move.l	planetattacklist(a0),atlist
	move.l	#-1,savepalette
	bsr	resetsprites2
	bsr	resetshots2
	move.l	#backfile2,filename
	jsr	setup8way
	move.l	#spritefile3,filename
	jsr	setupclippedsprite2
	lea	obj1sp,a0
	move.w	#1600,d0
	jsr	random
	move.w	d0,cspritex2(a0)
	move.w	#1600,d0
	jsr	random
	move.w	d0,cspritey2(a0)
	move.w	#20,objhitcount(a0)
	move.w	#200,shipenergy
	move.w	#100,boom8delay
	move.w	#0,scrollx
	move.w	#0,scrolly
	move.w	#1,loadflag
	move.l	#way8palette,whichpalette
	jmp	scroll8wayloop
isscrollerc:
	cmpi.w	#scrollerc,(a0)
	bne	istrading
	sub.w	#20,shipsfuel
	cmpi.w	#20,shipsfuel
	bgt	die1
	move.l	#-1,savepalette
*	move.l	planetattacklist(a0),atlist
	bsr	resetsprites2
	bsr	resetshots2
	move.l	#backfile3,filename
	jsr	setup8way
	move.l	#spritefile3,filename
	jsr	setupclippedsprite2
	lea	obj1sp,a0
	move.w	#1600,d0
	jsr	random
	move.w	d0,cspritex2(a0)
	move.w	#1600,d0
	jsr	random
	move.w	d0,cspritey2(a0)
	move.w	#20,objhitcount(a0)
	move.w	#200,shipenergy
	move.w	#100,boom8delay
	move.w	#0,scrollx
	move.w	#0,scrolly
	move.w	#1,loadflag
	jmp	scroll8wayloop
istrading:
	sub.w	#20,shipsfuel
	cmpi.w	#20,shipsfuel
	bgt	die1
	move.l	#cityfile,filename
	move.l	#solmapmem,wheretoload
	move.l	#15984,lengthtoread
	jsr	loadfile
	move.w	#0,myviewx
	move.w	#0,myviewy
	lea	ship3,a0
	move.l	a0,whichob
	move.w	#-100,obx(a0)
	move.w	#-140,oby(a0)
	move.w	#100,obz(a0)
	move.w	#1,activeflag(a0)
	move.l	obviewpb(a0),a1
	move.w	#0,phi(a1)
	move.w	#0,rho(a1)
	move.w	#-64,theta(a1)
	move.w	#0,obz(a0)
	move.w	#-30,ycurve
	move.l	#citypalette,whichpalette
	move.w	#1,dontpulse
	lea	shiptrade1,a1
	bsr	startsound
	bsr 	cityloop
	move.w	#0,myviewx
	move.w	#0,myviewy
*	bsr	doworld
	move.w	#1,specialprsp
	lea	penta1,a0
	move.w	#1,activeflag(a0)
	move.w	#0,obx(a0)
	move.w	#0,oby(a0)
	move.w	#1500,obz(a0)
	move.l	#tradefile,filename
	move.l	#solmapmem,wheretoload
	move.l	#15984,lengthtoread
	jsr	loadfile
	move.l	#tradecfile,filename
	move.l	generalstore,wheretoload
	add.l	#83000,wheretoload
	move.l	#2560,lengthtoread
	jsr	loadfile
	lea	tcursorsprite,a0
	move.l	wheretoload,cspritead(a0)	;put right address in
	move.l	#bluepalette,whichpalette
	move.w	#-1,dontpulse
	move.w	#-1,lastitem
	move.w	#-1,whichitem
	lea	tradesound,a1
	bsr	startsound
	jmp	dotrading

die1:
	jsr	cleartext
	move.w	#0,shipsfuel
	lea	death1msg,a0
	jmp	imdead1


setup8way:
	move.l	#compscreenmem,wheretoload
	move.l	#128*5,lengthtoread
	jsr	loadfile
	jsr	rotateback
	move.l	#mainfile,filename
	move.l	generalstore,wheretoload
	move.l	#3360,lengthtoread
	jsr	loadfile
	rts
dogenstuff:
	move.l	generalstore,a0 	;load in raw prerotated data
	add.l	#81000,a0		;for scroll
	move.l	a0,wheretoload
	move.l	a0,scrolltated1
	add.l	#704*2,a0
	move.l	a0,scrolltated2 
	add.l	#384*2,a0
	move.l	a0,scrolltated3
	add.l	#192*2,a0
	move.l	a0,scrolltated4
	add.l	#128*2,a0
	move.l	a0,scrolltated5
	move.l	#7296,lengthtoread
	jsr	loadfile
	rts

resetsprites:
	move.w	#0,shootstate
	move.w	#5,shotxvelp
	lea	addon1,a0
	move.w	#-1,cactive(a0)
	lea	addon2,a0
	move.w	#-1,cactive(a0)
	lea	package2,a0
	move.w	#-1,whatwep(a0)
	move.w	#-1,cactive(a0)
	lea	package,a0
	move.w	#-1,whatwep(a0)
	move.w	#-1,cactive(a0)
resetsprites2:
	move.w	#0,released
	move.w	#0,deceased
	move.w	#-1,whichattack
	lea	shotsprite1,a0
	move.w	#-1,cactive(a0)
	lea	shotsprite2,a0
	move.w	#-1,cactive(a0)
	lea	shotsprite3,a0
	move.w	#-1,cactive(a0)
	lea	shotsprite4,a0
	move.w	#-1,cactive(a0)
	lea	laser1,a0
	move.w	#-1,laserlife(a0)
	lea	laser2,a0
	move.w	#-1,laserlife(a0)
	lea	laser3,a0
	move.w	#-1,laserlife(a0)
	bsr	resetenemy
	lea	shipsprite0,a0
	move.w	#1,cactive(a0)
	move.w	#50,cspritex(a0)
	move.w	#50,cspritey(a0)	
	lea	shipsprite1,a0
	move.w	#1,cactive(a0)
	lea	pexp1,a0
	move.w	#-1,boomframe(a0)
	lea	pexp2,a0
	move.w	#-1,boomframe(a0)
	lea	pexp3,a0
	move.w	#-1,boomframe(a0)
	rts

resetenemy:
	lea	enemy1,a0
	move.w	#-1,cactive(a0)
	lea	enemy2,a0
	move.w	#-1,cactive(a0)
	lea	enemy3,a0
	move.w	#-1,cactive(a0)
	lea	enemy4,a0
	move.w	#-1,cactive(a0)
	lea	enemy5,a0
	move.w	#-1,cactive(a0)
	lea	enemy6,a0
	move.w	#-1,cactive(a0)
	lea	enemy7,a0
	move.w	#-1,cactive(a0)
	lea	enemy8,a0
	move.w	#-1,cactive(a0)
	lea	enemy9,a0
	move.w	#-1,cactive(a0)
	lea	enemy10,a0
	move.w	#-1,cactive(a0)
	rts

resetshots2:
	lea	shotsprite1,a0
	move.w	#-1,cactive(a0)
	move.w	#4,cspritewidth(a0)
	lea	shotsprite2,a0
	move.w	#-1,cactive(a0)
	move.w	#4,cspritewidth(a0)
	lea	shotsprite3,a0
	move.w	#-1,cactive(a0)
	move.w	#4,cspritewidth(a0)
	lea	shotsprite4,a0
	move.w	#-1,cactive(a0)
	move.w	#4,cspritewidth(a0)
	rts

pathtest:
	move.w	myviewx,d0
	move.w	myviewy,d1
	neg.w	d0
	neg.w	d1
	subi.w	#50,d0		;sub width of square
	subi.w	#50,d1		;ditto for height
	cmp.w	obx(a0),d0
	bgt	outsidepath
	cmp.w	oby(a0),d1
	bgt	outsidepath
	addi.w	#100,d0 	;sub width of square
	addi.w	#100,d1 	;ditto for height
	cmp.w	obx(a0),d0
	blt	outsidepath
	cmp.w	oby(a0),d1
	blt	outsidepath
	rts
outsidepath:
	add.l	#12,sp		;get rid of 3 return addresses
	move.l	#bluepalette,whichpalette
	jsr	cleartext
	jsr	flip_scr2
	jsr	flip_scr2
	jsr	stopallsound
	bsr	interference
	lea	missedpathmsg,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	move.l	#1000000,d7
	jsr	generaldelay
	bsr	interference
	move.w	#-1,dontpulse
	move.l	#-1,planetdestination
	subi.w	#20,shipsfuel
	cmpi.w	#20,shipsfuel
	bgt	die1
	jmp	shipscomputer

cityloop:
	lea	channel0params,a0
	tst.w	channelprocess(a0)
	bpl	skipsoundc
	lea	shiptrade2,a1
	jsr	startsound
skipsoundc:
	jsr	copysolar
	lea	ship3,a0
	move.l	a0,whichob
	addq.w	#8,obx(a0)
	move.l	obviewpb(a0),a1
	addq.w	#1,theta(a1)
	add.w	#200,obz(a0)
	cmpi.w	#30000,obz(a0)
	bge	cslover
	jsr	dobefore2
	jsr	flip_scr3
	jsr	keyboard
	bra	cityloop
cslover:
	rts


************************************************
prepstars:
	lea	spacestarsvrt,a0
	addq.l	#2,a0
	moveq	#19,d7
ppsl:
	move.w	#288,d0
	jsr	randomplus
	add.w	#16,d0
	move.w	d0,(a0)+
	move.w	#55,d0
	jsr	randomplus
	add.w	#68,d0
	move.w	d0,(a0)+
	move.w	#3,d0
	jsr	randomplus
	addq.w	#7,d0
	move.w	d0,(a0)+
	dbf	d7,ppsl
	rts
pstars:
	lea	spacestarsvrt,a0
	addq.l	#2,a0
	moveq	#19,d7
psl2:
	move.w	(a0)+,pixelx
	addq.w	#1,(a0)
	move.w	(a0)+,pixely
	move.w	(a0)+,pixelcolor
	moveq	#0,d0
	jsr	singleplot3
	tst.w	d0
	bpl	pok
	move.w	#66,-4(a0)
pok:
	dbf	d7,psl2
	rts
************************************************
preparra2stars:
	lea	spacestarsvrt,a0
	addq.l	#2,a0
	moveq	#9,d7
pp2sl:
	move.w	#288,d0
	jsr	randomplus
	add.w	#16,d0
	move.w	d0,(a0)+
	move.w	#82,d0
	jsr	randomplus
	add.w	#13,d0
	move.w	d0,(a0)+
	move.w	#3,d0
	jsr	randomplus
	tst.w	d0
	bne	dpc1
	move.w	#4,(a0)+
	bra.s	dpc4
dpc1:	cmpi.w	#1,d0
	bne	dpc2
	move.w	#8,(a0)+
	bra.s	dpc4
dpc2:	cmpi.w	#2,d0
	bne	dpc3
	move.w	#12,(a0)+
	bra.s	dpc4
dpc3:
	move.w	#10,(a0)+
dpc4:	dbf	d7,pp2sl
	rts

p2stars:
	lea	spacestarsvrt,a0
	addq.l	#2,a0
	moveq	#9,d7
p2sl2:
	subq.w	#1,(a0)
	move.w	(a0)+,pixelx
	move.w	(a0)+,pixely
	move.w	(a0)+,pixelcolor
	moveq	#0,d0
	jsr	singleplot3
	tst.w	d0
	bpl	pok2
	move.w	#320-16,-6(a0)
pok2:
	dbf	d7,p2sl2
	rts
*********************************************************
* Planet routine. Simulates a huge planet rotating	*
* just above line of sight. Random surface soon to be	*
* added.						*
*********************************************************
planet:
	move.l	planetmem1,a0
	move.l	a0,a1
*	addi.l	#144,a1
	lea	144(a1),a1
	moveq	#98,d0
planetscroll:
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	dbf	d0,planetscroll
	bra	terrainline1
	rts


*********************************************************
*	first set up mem for it 			*
*********************************************************
preplanet:
	move.l	planetmem1,a0
	move.w	#7199,d0
	move.l	planetmem2,a1
	move.l	a1,terrainwhere
pploop:
	move.w	(a1)+,(a0)+
	dbf	d0,pploop
	rts
	
terrainline1:
	move.l	terrainwhere,a6
ter1:
	rept	36
	move.l	(a6)+,(a0)+
	endr
	move.l	planetmem2,a1
	lea	14400(a1),a1
	cmp.l	a1,a6
	beq.s	rest
	move.l	a6,terrainwhere
	rts
rest:
	move.l	planetmem2,terrainwhere
	rts
*****************************************
deckend:
	lea	multideck,a0
	tst.w	activeflag(a0)
	bpl	deb
	move.w	#50,finalcount
deloop:
	jsr	drawpart4
	jsr	dospacestars2
	jsr	dodeck
	jsr	doworld2
	jsr	moveeverything
	jsr	battleshoot
	jsr	movebattleshots
	jsr	battleshotcollisions
	jsr	battlemecollisions
	jsr	sortndrawlist
	jsr	doradar
	jsr	dosight
	jsr	flip_scr
	jsr	keysbattle
	subq.w	#1,finalcount
	bpl	deloop
	jsr	cleartext
	jsr	flip_scr2
	jsr	flip_scr2
	bsr	interference
	lea	finished3dtext,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	move.l	#1000000,d7
	jsr	generaldelay
	bsr	interference
	addq.l	#4,sp
	jmp	shipscomputer
deb:
	rts

deckshoot:
	lea	multideck,a0
	tst.w	hostile
	bpl	doitanyway
	tst.w	cloakingdevice		;check to see if player
	bpl	decksb			;has cloaking device
	cmpi.w	#2000,obx(a0)		;see if it's within range
	bgt	decksb
	cmpi.w	#-2000,obx(a0)
	blt	decksb
	cmpi.w	#2000,oby(a0)
	bgt	decksb
	cmpi.w	#-2000,oby(a0)
	blt	decksb
	cmpi.w	#2000,obz(a0)
	bgt	decksb
	cmpi.w	#-2000,obz(a0)
	blt	decksb
	tst.w	donewarn
	bpl	doitanyway
	move.l	a0,-(sp)
	move.w	#1,donewarn
	bsr	dowarnmsg
	move.l	(sp)+,a0
doitanyway:
	lea	warp1shot,a2
	tst.w	activeflag(a2)		;see if it has a shot active
	bpl	deckshot
	move.w	#1000,d0
	jsr	randomplus
	cmpi.w	#55,d0
	bgt	nonewdshot
	move.w	#1,activeflag(a2)		;life of shot
	move.w	#80,obint(a2)
	move.w	obx(a0),d0
	move.w	d0,obx(a2)
	asr.w	#6,d0
	neg.w	d0
	move.w	d0,obxvel(a2)
	move.w	oby(a0),d0
	move.w	d0,oby(a2)
	asr.w	#6,d0
	neg.w	d0
	move.w	d0,obyvel(a2)
	move.w	obz(a0),d0
	move.w	d0,obz(a2)
	asr.w	#6,d0
	neg.w	d0
	move.w	d0,obzvel(a2)
deckshot:
	subq.w	#1,obint(a2)		;life of shot
	bmi	nonewdshot
	move.w	obxvel(a2),d0
	add.w	d0,obx(a2)
	move.w	obyvel(a2),d0
	add.w	d0,oby(a2)
	move.w	obzvel(a2),d0
	add.w	d0,obz(a2)
	move.l	obviewpb(a2),a1
	add.w	#28,theta(a1)
	add.w	#42,phi(a1)
decksb:
*	move.w	#-1,donewarn
	rts
nonewdshot:
	move.w	#-1,activeflag(a2)
	rts

dowarnmsg:
	jsr	cleartext
	lea	warnmsg,a0
	jsr	printmany
	move.w	#40,flipwithtext
	rts

*******************************************
autodeckdock:
	tst.w	adsoftware
	bmi	noads
	beq	noads
	move.w	#0,battlespeed2
	move.w	#0,battlespeed
	subq.w	#1,adsoftware
	bgt	noads
	move.w	#1,dpressed
noads:
	rts
*******************************************
dodeck:
	lea	multideck,a0
	move.w	battlespeed2,d0
	sub.w	d0,obz(a0)
	bsr	checkbounds
	move.l	obviewpb(a0),a1
	move.w	multirot,d0
	add.w	myrot,d0
	add.w	d0,theta(a1)
dock:
	tst.w	dpressed
	bmi	ddb
	tst.w	d0
	bne	donotrotmsg
	tst.w	hostile
	bpl	dohmsg
	move.w	#-1,dpressed
	jsr	cleartext
	jsr	flip_scr
	jsr	flip_scr
	bsr	interference
	lea	multideck,a0
	cmpi.w	#1000,obz(a0)
	bgt	notyetmsg
	cmpi.w	#-50,obx(a0)
	blt	notyetmsg
	cmpi.w	#50,obx(a0)
	bgt	notyetmsg
	cmpi.w	#-50,oby(a0)
	blt	notyetmsg
	cmpi.w	#50,oby(a0)
	bgt	notyetmsg
	tst.w	cloakingdevice
	bpl	okcloak
	jsr	cleartext
	lea	nocloakmsg,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	move.l	#800000,d7
	jsr	generaldelay
	rts
okcloak:
	jsr	cleartext
	jsr	interference
	lea	dockmsg,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	addq.l	#4,sp		;take care of return address
	bra	docking
notyetmsg:
	jsr	cleartext
	jsr	interference
	lea	nodockmsg,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	move.l	#600000,d7
	jsr	generaldelay
ddb:	rts

dohmsg:
	move.w	#-1,dpressed
	jsr	cleartext
	jsr	flip_scr
	jsr	flip_scr
	jsr	interference
	lea	hostilemsg,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	move.l	#600000,d7
	jsr	generaldelay
	rts
donotrotmsg:
	move.w	#-1,dpressed
	jsr	cleartext
	jsr	flip_scr
	jsr	flip_scr
	jsr	interference
	lea	rotmsg,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	move.l	#600000,d7
	jsr	generaldelay
	rts

******************************************************
docking:
	move.l	#d1file,filename
	move.l	generalstore,wheretoload
	move.l	#57528,lengthtoread
	jsr	loadfile
	move.l	#d2file,filename
	move.l	generalstore,wheretoload
	add.l	#57528,wheretoload
	move.l	#2454,lengthtoread
	jsr	loadfile
	jsr	cleartext
	jsr	flip_scr2
	jsr	flip_scr2
	move.l	#greypalette,whichpalette
	move.l	generalstore,dltmemcount
	move.l	dltmemcount,dltsave
	move.w	#0,d3
	move.w	#15000,d7
	lea	dooropensound,a1
	jsr	startsound
	bsr	dodlt
	jsr	stopallsound
	move.l	generalstore,dltmemcount
	addi.l	#57528,dltmemcount
	move.l	dltmemcount,dltsave
	move.w	#1,d3
	move.w	#13000,d7
	bsr	dodlt
	jsr	copyseento3
	move.w	#0,myviewx
	move.w	#0,myviewy
	lea	ship3,a0
	move.w	#0,obx(a0)
	move.w	#60,oby(a0)
	move.w	#1,activeflag(a0)
	move.l	obviewpb(a0),a1
	move.w	#-10,phi(a1)
	move.w	#0,rho(a1)
	move.w	#64,theta(a1)
	move.l	a0,whichob
	move.w	#0,obz(a0)
	move.w	#100,ycurve
	lea	shiptrade1,a1
	jsr	startsound
dockloop:
	lea	channel0params,a0
	tst.w	channelprocess(a0)
	bpl	skipsoundd
	lea	shiptrade2,a1
	jsr	startsound
skipsoundd:
	lea	ship3,a0
	move.l	a0,whichob
	add.w	#5,ycurve
	move.w	ycurve,d0
	add.w	d0,obz(a0)
	cmpi.w	#30000,obz(a0)
	bge	dockover
	jsr	dobefore2
	jsr	flip_scrdock
	bra	dockloop
dockover:
	lea	dockedmsg,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	move.l	#deckfile,filename
	jsr	loadscr
	bsr	copyscr3tomem
	jsr	copyseento3all
	move.l	#deckfightpalette,whichpalette
	move.w	#1,dontpulse
	bsr	copycorto3
	jsr	copyintoboth
	move.l	generalstore,a0
	add.l	#20000,a0	;point to end of screen
	move.l	a0,wheretoload
	move.l	#100722,lengthtoread
	move.l	#deckfile2,filename
	jsr	loadfile
	move.l	wheretoload,a0
	move.l	a0,man1ldlt
	add.l	#34270,a0
	move.l	a0,man1rdlt
	add.l	#33982,a0
	move.l	a0,man2ldlt
	add.l	#12262,a0
	move.l	a0,man2rdlt
	add.l	#13006,a0
	move.l	a0,man3ldlt
	add.l	#3100,a0
	move.l	a0,man3rdlt
	bsr	copycorto3
	move.w	#-1,doingman
	move.w	#0,dltframe
	move.w	#0,shipenergy
	move.w	#0,doorhits
	jmp	deckfightloop
copyscr3tomem:
	move.l	generalstore,a0
	move.l	screen3,a1
	moveq	#110,d0
cp3l:
	rept	36
	move.l	(a1)+,(a0)+
	endr
	lea	16(a1),a1
	dbf	d0,cp3l	
	rts

copycorto3:
	move.l	generalstore,a1
	move.l	screen3,a0
	lea	2088(a0),a0
	moveq	#110,d0
cp3lc:
	rept	36
	move.l	(a1)+,(a0)+
	endr
	lea	16(a0),a0
	dbf	d0,cp3lc
	rts

dodeckboom:
	move.l	#bbfile,filename
	move.l	generalstore,wheretoload
	move.l	#128794,lengthtoread
	jsr	loadfile
	move.l	#bbpalette,whichpalette
	move.l	generalstore,dltmemcount
	move.l	dltmemcount,dltsave
	jsr	flip_scr
	jsr	flip_scr
	move.w	#0,d3
	move.w	#20000,d7
	lea	mehitsound,a1
	jsr	startsound
	bsr	dodlt
	move.l	#bluepalette,whichpalette
	cmpi.w	#20,shipsfuel
	bgt	die3
	lea	deckdeadmsg,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	move.l	#planetfile,filename
	move.l	generalstore,wheretoload
	move.l	#80752,lengthtoread
	jsr	loadfile
	jmp	shipscomputer

die3:
	jsr	cleartext
	lea	death3msg,a0
	jmp	imdead2

dodlt:
	subq.w	#1,dltdelay
	bpl	nodlt
	move.w	d7,dltdelay
	move.l	dltmemcount,a0
	move.l	seen,a1
	move.l	hiden,a2
	move.w	(a0)+,d0
	beq	dltover
	subq.w	#1,d0
dodltloop:
	move.w	(a0)+,d1
	move.l	(a0)+,d2
	eor.l	d2,(a1,d1.w)
	eor.l	d2,(a2,d1.w)
	dbf	d0,dodltloop
	move.l	a0,dltmemcount
nodlt:
	bra	dodlt

dltover:
	move.l	dltsave,dltmemcount
	dbf	d3,dodlt
	rts

dodltt:
	subq.w	#1,dltdelay
	bpl	nodltt
	move.w	d7,dltdelay
	move.l	dltmemcount,a0
	move.l	seen,a1
	move.w	(a0)+,d0
	beq	dltovert
	subq.w	#1,d0
dodltloopt:
	move.w	(a0)+,d1
	move.l	(a0)+,d2
	eor.l	d2,(a1,d1.w)
	dbf	d0,dodltloopt
	move.l	a0,dltmemcount
nodltt:
	bra	dodltt

dltovert:
	move.l	dltsave,dltmemcount
	dbf	d3,dodltt
	rts
*****************************************
setupscrolla:
	move.l	#filepara1,filename
	jsr	loadscr
	jsr	copyintoboth
	move.l	#parra2apalette,whichpalette
	move.l	#pscrollfile1,filename
	move.l	generalstore,wheretoload
	move.l	#50000,lengthtoread
	jsr	loadfile
	move.l	generalstore,dltmemcount
	move.l	dltmemcount,dltsave
	rts
setupscrollb:
	move.l	#filepara2,filename
	jsr	loadscr
	jsr	copyintoboth
	move.l	#parra2apalette,whichpalette
	move.l	#pscrollfile2,filename
	move.l	generalstore,wheretoload
	move.l	#50000,lengthtoread
	jsr	loadfile
	move.l	generalstore,dltmemcount
	move.l	dltmemcount,dltsave
	rts
setupscrollc:
	move.l	#filepara3,filename
	jsr	loadscr
	jsr	copyintoboth
	move.l	#parra2apalette,whichpalette
	move.l	#pscrollfile3,filename
	move.l	generalstore,wheretoload
	move.l	#50000,lengthtoread
	jsr	loadfile
	move.l	generalstore,dltmemcount
	move.l	dltmemcount,dltsave
	rts

parralaxscroll2:
ps2:	move.l	dltmemcount,a0
	move.l	screen3,a1
	move.w	(a0)+,d0
	beq.s	dltover2
	subq.w	#1,d0
dodltloop2:
	move.w	(a0)+,d1
	move.l	(a0)+,d2
	eor.l	d2,(a1,d1.w)
	dbf	d0,dodltloop2
	move.l	a0,dltmemcount
nodlt2:
	rts
dltover2:
	move.l	dltsave,dltmemcount
	bra.s	ps2
*****************************************
dosight:
	tst.w	sightavail
	bmi.s	nosight
	tst.w	sightflag
	bmi.s	nosight
	lea	sightdata,a0
	lea	sightmask,a1
	move.l	hiden,a2
	lea	9512(a2),a2
	move.l	a2,a3
	moveq	#14,d7
dsil:
	move.w	(a1)+,d0	;mask
	eor.w	#-1,d0
	and.w	d0,(a3)
	and.w	d0,2(a3)
	and.w	d0,4(a3)
	and.w	d0,6(a3)
	move.l	(a0)+,d0
	eor.l	d0,(a3)+
	move.l	(a0)+,d0
	eor.l	d0,(a3)+
	move.w	(a1)+,d0
	eor.w	#-1,d0
	and.w	d0,(a3)
	and.w	d0,2(a3)
	and.w	d0,4(a3)
	and.w	d0,6(a3)
	move.l	(a0)+,d0
	eor.l	d0,(a3)+
	move.l	(a0)+,d0
	eor.l	d0,(a3)+
	lea	160(a2),a2
	move.l	a2,a3
	dbf	d7,dsil
nosight:
	rts
*******************
doradar8:
	bsr.w	clearradar
	move.w	#10,pixelcolor
	lea	obj1sp,a0
	move.w	cspritex2(a0),d0
	move.w	cspritey2(a0),d1
	bsr.s	plotenemy2

	move.w	#5,pixelcolor
	move.w	scrollx,d0
	move.w	scrolly,d1
	neg.w	d1
	bsr.s	plotenemy2

	move.w	#3,pixelcolor
	lea	enemy1,a0
	bsr.s	plotenemy
	lea	enemy2,a0
	bsr.s	plotenemy
	lea	enemy3,a0
	bsr.s	plotenemy
	lea	enemy4,a0
	bsr.s	plotenemy
	lea	enemy5,a0
	bsr.s	plotenemy
	rts

plotenemy:
	tst.w	cactive(a0)
	bmi.s	noen
	move.w	cspritex2(a0),d0
	move.w	cspritey2(a0),d1
plotenemy2:
	sub.w	scrollx,d0
	add.w	scrolly,d1
	jsr	bound82
	moveq	#0,d2
	move.w	radarmag,d2
	asr.w	d2,d0
	asr.w	d2,d1
	add	#159,d0
	add	#173,d1
	move.w	d0,pixelx
	move.w	d1,pixely
	jsr	singleplotr
noen:	rts
*****************************************
clearradar:
	move.l	hiden,a0
	lea	23904(a0),a0
	move.l	a0,a1
	moveq	#48,d0
	moveq	#-1,d1
	moveq	#0,d2
	moveq	#0,d3
	moveq	#0,d4
drclear:
	move.w	d1,(a1)+
	move.w	d2,(a1)+
	move.w	d3,(a1)+
	move.w	d4,(a1)+
	move.w	d1,(a1)+
	move.w	d2,(a1)+
	move.w	d3,(a1)+
	move.w	d4,(a1)+
	move.w	d1,(a1)+
	move.w	d2,(a1)+
	move.w	d3,(a1)+
	move.w	d4,(a1)+
	move.w	d1,(a1)+
	move.w	d2,(a1)+
	move.w	d3,(a1)+
	move.w	d4,(a1)+
	lea	160(a0),a0
	move.l	a0,a1
	dbf	d0,drclear
	rts
doradar:
	bsr	clearradar
	lea	drawlist,a0
	move.w	(a0)+,d6
	subq.w	#1,d6
	lea	radarvpb,a5
drloop:
	move.l	(a0)+,a6
	tst.w	activeflag(a6)
	bmi	drb
	move.w	numdots(a6),d0
	cmpi.w	#15,d0
	bne	skcols
	moveq	#12,d0
skcols:
	move.w	d0,pixelcolor
	move.w	obx(a6),d0
	move.w	oby(a6),d1
	move.w	obz(a6),d2
	bsr	view_trans
	asr.w	#4,d3
	asr.w	#4,d4
	add.w	#10000,d5
	swap	d3		;Calculate Xs
	clr	d3		
	asr.l	#7,d3	  
	divs	d5,d3
	swap	d4		;Calculate Ys
	clr	d4
	asr.l	#7,d4
	divs	d5,d4
	add	#159,d3 	;Adjust for centre of screen
	add	#173,d4
	move.w	d3,pixelx
	move.w	d4,pixely
	jsr	singleplotr
drb:
	dbf	d6,drloop
	move.w	#2,pixelcolor
	move.w	#159,pixelx
	move.w	#173,pixely
	jsr	singleplotr
	rts
*****************************************
moveeverything:
	move.w	xvel,d0
	bge	me1
	move.w	#254,d0
me1:
	move.w	d0,myrho
	move.w	yvel,d0
	bge	me2
	move.w	#254,d0
me2:
	move.w	d0,myphi
	move.w	#0,mytheta
	lea	worldvpb,a5
	lea	drawlist,a0
	move.w	(a0)+,d6
	subq.w	#1,d6
mveloop:
	move.l	(a0)+,a6
	tst.w	activeflag(a6)
	bmi	mvb
	move.w	obx(a6),d0
	move.w	oby(a6),d1
	move.w	obz(a6),d2
	bsr	worldview_trans
	move.w	d3,obx(a6)
	move.w	d4,oby(a6)
	move.w	d5,obz(a6)
mvb:
	dbf	d6,mveloop
	lea	shot1vels,a6
	lea	shot1,a0
	tst.w	activeflag(a0)
	bmi	s1n
	move.w	shotxvel(a6),d0
	move.w	shotyvel(a6),d1
	move.w	shotzvel(a6),d2
	bsr	worldview_trans
	move.w	d3,shotxvel(a6)
	move.w	d4,shotyvel(a6)
	move.w	d5,shotzvel(a6)
s1n:
	lea	shot2vels,a6
	lea	shot2,a0
	tst.w	activeflag(a0)
	bmi	s2n
	move.w	shotxvel(a6),d0
	move.w	shotyvel(a6),d1
	move.w	shotzvel(a6),d2
	bsr	worldview_trans
	move.w	d3,shotxvel(a6)
	move.w	d4,shotyvel(a6)
	move.w	d5,shotzvel(a6)
s2n:
	lea	shot3vels,a6
	lea	shot3,a0
	tst.w	activeflag(a0)
	bmi	s3n
	move.w	shotxvel(a6),d0
	move.w	shotyvel(a6),d1
	move.w	shotzvel(a6),d2
	bsr	worldview_trans
	move.w	d3,shotxvel(a6)
	move.w	d4,shotyvel(a6)
	move.w	d5,shotzvel(a6)
s3n:
	lea	shot4vels,a6
	lea	shot4,a0
	tst.w	activeflag(a0)
	bmi	s4n
	move.w	shotxvel(a6),d0
	move.w	shotyvel(a6),d1
	move.w	shotzvel(a6),d2
	bsr	worldview_trans
	move.w	d3,shotxvel(a6)
	move.w	d4,shotyvel(a6)
	move.w	d5,shotzvel(a6)
s4n:
	rts
*****************************************
dowarp:
	moveq	#0,d7
	lea	warp1,a0
	lea	warp1shot,a2
	bsr	dowarpbattle
	lea	warp2,a0
	lea	warp2shot,a2
	bsr	dowarpbattle
	lea	warp3,a0
	lea	warp3shot,a2
	bsr	dowarpbattle
	lea	warp4,a0
	lea	warp4shot,a2
	bsr	dowarpbattle
	lea	warp5,a0
	lea	warp5shot,a2
	bsr	dowarpbattle
	cmpi.w	#5,d7
	blt	morewarps
	cmpi.w	#-999,finalcount
	bne	mw2
	move.w	#50,finalcount
mw2:	subq.w	#1,finalcount
	bpl	morewarps
	move.w	#-999,finalcount
	bsr	cleartext
	jsr	flip_scr2
	jsr	flip_scr2
	bsr	interference
	lea	finished3dtext,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	move.l	#1000000,d7
	bsr	generaldelay
	bsr	interference
	addq.l	#4,sp
	bra	shipscomputer
morewarps:
	rts


doobian:
	moveq	#0,d7
	lea	obian1,a0
	lea	warp1shot,a2
	bsr	dowarpbattle
	lea	obian2,a0
	lea	warp2shot,a2
	bsr	dowarpbattle
	lea	obian3,a0
	lea	warp3shot,a2
	bsr	dowarpbattle
	lea	obian4,a0
	lea	warp4shot,a2
	bsr	dowarpbattle
	lea	obian5,a0
	lea	warp5shot,a2
	bsr	dowarpbattle
	cmpi.w	#5,d7
	blt	moreobians
	cmpi.w	#-999,finalcount
	bne	mo2
	move.w	#50,finalcount
mo2:	subq.w	#1,finalcount
	bpl	moreobians
	move.w	#-999,finalcount
	bsr	cleartext
	jsr	flip_scr2
	jsr	flip_scr2
	bsr	interference
	lea	finished3dtext,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	move.l	#1000000,d7
	bsr	generaldelay
	bsr	interference
	addq.l	#4,sp
	bra	shipscomputer
moreobians:
	rts

dowarpbattle:
	tst.w	activeflag(a0)
	bmi	dwb
	move.w	battlespeed2,d0
	sub.w	d0,obz(a0)
	move.l	obviewpb(a0),a1
	addq.w	#6,theta(a1)
	addq.w	#1,phi(a1)
	subq.w	#1,obint(a0)
	bpl	dwba
	move.w	#100,d0
	jsr	randomplus
	move.w	d0,obint(a0)
	move.w	dodge,d0
	jsr	randomplus
	tst.w	obx(a0)
	bgt	di1
	move.w	d0,obxvel(a0)
	bra	di2
di1:
	neg.w	d0
	move.w	d0,obxvel(a0)
di2:
	move.w	dodge,d0
	jsr	randomplus
	tst.w	oby(a0)
	bgt	di3
	move.w	d0,obyvel(a0)
	bra	di4
di3:
	neg.w	d0
	move.w	d0,obyvel(a0)
di4:
	move.w	dodge,d0
	jsr	randomplus
	asl.w	#3,d0
	tst.w	obz(a0)
	bgt	di5
	move.w	d0,obzvel(a0)
	bra	dwba
di5:
	neg.w	d0
	move.w	d0,obzvel(a0)
dwba:
	move.w	obxvel(a0),d0
	add.w	d0,obx(a0)
	move.w	obyvel(a0),d0
	add.w	d0,oby(a0)
	move.w	obzvel(a0),d0
	add.w	d0,obz(a0)

	bsr	checkbounds

	tst.w	activeflag(a2)		;see if it has a shot active
	bpl	mbatshot
	move.w	#1000,d0
	jsr	randomplus
	cmpi.w	#5,d0
	bgt	nonewshot
	move.w	#1,activeflag(a2)		;life of shot
	move.w	#80,obint(a2)
	move.w	obx(a0),d0
	move.w	d0,obx(a2)
	asr.w	#6,d0
	neg.w	d0
	move.w	d0,obxvel(a2)
	move.w	oby(a0),d0
	move.w	d0,oby(a2)
	asr.w	#6,d0
	neg.w	d0
	move.w	d0,obyvel(a2)
	move.w	obz(a0),d0
	move.w	d0,obz(a2)
	asr.w	#6,d0
	neg.w	d0
	move.w	d0,obzvel(a2)
mbatshot:
	subq.w	#1,obint(a2)		;life of shot
	bmi	nonewshot
	move.w	obxvel(a2),d0
	add.w	d0,obx(a2)
	move.w	obyvel(a2),d0
	add.w	d0,oby(a2)
	move.w	obzvel(a2),d0
	add.w	d0,obz(a2)
	move.l	obviewpb(a2),a1
	add.w	#28,theta(a1)
*	add.w	#8,rho(a1)
	add.w	#42,phi(a1)
	rts
dwb:
	move.w	#-1,activeflag(a2)
	addq.w	#1,d7
	rts

nonewshot:
	move.w	#-1,activeflag(a2)
	rts

checkbounds:
ub0:	cmpi.w	#12000,obx(a0)
	blt	ub1
	move.w	#-11000,obx(a0)
	bra	ub2
ub1:
	cmpi.w	#-12000,obx(a0)
	bgt	ub2
	move.w	#11000,obx(a0)

ub2:	cmpi.w	#12000,oby(a0)
	blt	ub3
	move.w	#-11000,oby(a0)
	bra	ub4
ub3:
	cmpi.w	#-12000,oby(a0)
	bgt	ub4
	move.w	#11000,oby(a0)

ub4:	cmpi.w	#12000,obz(a0)
	blt	ub5
	move.w	#-11000,obz(a0)
	bra	ub6
ub5:
	cmpi.w	#-12000,obz(a0)
	bgt	ub6
	move.w	#11000,obz(a0)
ub6:
	rts
****************************************
dorandomwarps:
	moveq	#1,d7
	lea	warp1,a0
	lea	warp1shot,a1
	bsr	warpappear
	lea	warp2,a0
	lea	warp2shot,a1
	bsr	warpappear
	lea	warp3,a0
	lea	warp3shot,a1
	bsr	warpappear
	lea	warp4,a0
	lea	warp4shot,a1
	bsr	warpappear
	lea	warp5,a0
	lea	warp5shot,a1
	bsr	warpappear
	rts
dorandomobians:
	moveq	#4,d7
	lea	obian1,a0
	lea	warp1shot,a1
	bsr	warpappear
	lea	obian2,a0
	lea	warp2shot,a1
	bsr	warpappear
	lea	obian3,a0
	lea	warp3shot,a1
	bsr	warpappear
	lea	obian4,a0
	lea	warp4shot,a1
	bsr	warpappear
	lea	obian5,a0
	lea	warp5shot,a1
	bsr	warpappear
	rts

warpappear:
	move.w	d7,canitbehit(a0)
	move.w	#100,d0
	jsr	randomplus
	cmpi.w	#50,d0
	bge	warpnotappear
	move.w	#1,activeflag(a0)
	move.w	#8000,d0
	jsr	random
	move.w	d0,obx(a0)
	move.w	#8000,d0
	jsr	random
	move.w	d0,oby(a0)
	move.w	#8000,d0
	jsr	random
	move.w	d0,obz(a0)
	move.w	#500,d0
	jsr	randomplus
	move.w	d0,obint(a0)
	rts
warpnotappear:
	move.w	#-1,activeflag(a0)
	move.w	#-1,activeflag(a1)
	rts
****************************************
drawpart2:
	lea	drawlist,a0
	move.w	#14,(a0)+
	move.l	#shot1,(a0)+
	move.l	#shot2,(a0)+
	move.l	#shot3,(a0)+
	move.l	#shot4,(a0)+
	move.l	#warp1,(a0)+
	move.l	#warp2,(a0)+
	move.l	#warp3,(a0)+
	move.l	#warp4,(a0)+
	move.l	#warp5,(a0)+
	move.l	#warp1shot,(a0)+
	move.l	#warp2shot,(a0)+
	move.l	#warp3shot,(a0)+
	move.l	#warp4shot,(a0)+
	move.l	#warp5shot,(a0)+
	rts
drawpart3:
	lea	drawlist,a0
	move.w	#14,(a0)+
	move.l	#shot1,(a0)+
	move.l	#shot2,(a0)+
	move.l	#shot3,(a0)+
	move.l	#shot4,(a0)+
	move.l	#obian1,(a0)+
	move.l	#obian2,(a0)+
	move.l	#obian3,(a0)+
	move.l	#obian4,(a0)+
	move.l	#obian5,(a0)+
	move.l	#warp1shot,(a0)+
	move.l	#warp2shot,(a0)+
	move.l	#warp3shot,(a0)+
	move.l	#warp4shot,(a0)+
	move.l	#warp5shot,(a0)+
	rts
drawpart4:
	lea	drawlist,a0
	move.w	#6,(a0)+
	move.l	#shot1,(a0)+
	move.l	#shot2,(a0)+
	move.l	#shot3,(a0)+
	move.l	#shot4,(a0)+
	move.l	#multideck,(a0)+
	move.l	#warp1shot,(a0)+
	rts
drawdeckleave:
	lea	drawlist,a0
	move.w	#2,(a0)+
	move.l	#multideck,(a0)+
	move.l	#ship3s,(a0)+
	rts
drawpart5:
	lea	drawlist,a0
	move.w	#1,(a0)+
	move.l	#box,(a0)+
	rts
******************************************
dospacestars:
	move.w	#7,pixelcolor
	lea	spacestarsvrt,a0
	move.w	(a0)+,d7
	move.w	xvel,d5
	move.w	yvel,d6
	neg.w	d5
	asl.w	#7,d5
	asl.w	#7,d6
	subq.w	#1,d7
hyplops:
	tst.w	4(a0)
	bmi	skiphl
	move.w	battlespeed,d3
	sub.w	d3,4(a0)
	bmi	hok2
	add.w	d5,(a0)
	add.w	d6,2(a0)
	move.w	(a0),d0
	move.w	2(a0),d1
	move.w	4(a0),d2
	bsr	a3dmath2
	move.w	d0,pixelx
	move.w	d1,pixely
	jsr	singleplot3
	tst.w	d0
	bmi	hok2
	addq.l	#6,a0
	dbf	d7,hyplops
	rts	
hok2:
	move.w	#9000,d0
	jsr	random
	move.w	d0,(a0)
	move.w	#9000,d0
	jsr	random
	move.w	d0,2(a0)
	move.w	#14000,4(a0)
	addq.l	#6,a0
	dbf	d7,hyplops
	rts
dospacestars2:
	move.w	#7,pixelcolor
	lea	starrotvpb,a5
	lea	spacestarsvrt,a0
	move.w	(a0)+,d7
	move.w	xvel,d5
	move.w	yvel,d6
	neg.w	d5
	asl.w	#7,d5
	asl.w	#7,d6
	subq.w	#1,d7
hyplops2:
	tst.w	4(a0)
	bmi	skiphl
	move.w	battlespeed,d3
	sub.w	d3,4(a0)
	bmi	hok2b
	add.w	d5,(a0)
	add.w	d6,2(a0)

	move.w	(a0),d0
	move.w	2(a0),d1
	move.w	4(a0),d2
	move.w	d0,d3			;get x
	muls	c_theta(a5),d3
	move.w	d1,d4			;get y
	muls	s_theta(a5),d4
	add.l	d4,d3
	swap	d3
	rol.l	#1,d3			;thats	x
	move.w	d1,d4			;get y
	muls	c_theta(a5),d4
	muls	s_theta(a5),d0		;x
	sub.l	d0,d4
	swap	d4
	rol.l	#1,d4			;thats	y
	move.w	d4,d1			;x
	move.w	d3,d0			;y
	bsr	a3dmath2
	move.w	d0,pixelx
	move.w	d1,pixely
	jsr	singleplot3
	cmpi.w	#-2,d0
	beq	hok2b
	addq.l	#6,a0
	dbf	d7,hyplops2
	rts	
hok2b:
	move.w	#9000,d0
	jsr	random
	move.w	d0,(a0)
	move.w	#9000,d0
	jsr	random
	move.w	d0,2(a0)
	move.w	#14000,4(a0)
	addq.l	#6,a0
	dbf	d7,hyplops2
	rts
******************************************
initmulti:
	lea	multideck,a0
	move.w	#10,d0
	jsr	random
	move.w	d0,multirot		;random amount of rotation
	move.l	obviewpb(a0),a1
	move.w	#128,phi(a1)
	move.w	#0,rho(a1)
	move.w	#0,theta(a1)
	move.w	#25,canitbehit(a0)	;may be higher
	move.w	#6000,d0
	jsr	random
	move.w	d0,obx(a0)
	move.w	#6000,d0
	jsr	random
	move.w	d0,oby(a0)
	move.w	#6000,d0
	jsr	random
	move.w	d0,obz(a0)
	move.w	#1,activeflag(a0)
	move.w	#0,myrot
	lea	warp1shot,a0
	move.w	#-1,activeflag(a0)
	rts

******************************************
tunnelover:
	move.w	#0,xvel
	move.w	#0,yvel
	jsr	domyview
	jsr	doworld
	jsr	dostartube
	jsr	dometeors
	jsr	moveshots
	jsr	drawpart1
	jsr	mecollisions
	jsr	shotcollisions
	jsr	flip_scr
	jsr	keyboard
	tst.w	hypercount
	bmi	tunnelstop
	bra	tunnelover
tunnelstop:
	jsr	stopallsound
	jsr	flip_scr
	jsr	flip_scr
	jsr	interference
	jsr	cleartext
	lea	hyperendtext,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	move.l	#600000,d7
	jsr	generaldelay
	cmpi.w	#20,shipsfuel
	bgt	okf
	jsr	cleartext
	move.w	#0,shipsfuel
	lea	death4msg,a0
	jmp	imdead1

okf:	move.l	#-1,planetdestination
	move.l	location,a0
	tst.w	defences(a0)
	beq	tsbb
	cmpi.w	#fighter1,defences(a0)
	bne	ts1
	lea	worldvpb,a1
	move.w	#0,theta(a1)
	move.w	#0,phi(a1)
	move.w	#0,rho(a1)
	move.l	#fighter1loop,whichbattle
	bsr	dorandomwarps
	bsr	initstars3
	move.w	#0,myrot
	move.w	#20,battlespeed2
	move.w	#40,battlespeed
	move.w	#0,myviewx
	move.w	#0,myviewy
	move.w	#7,dodge
	bsr	clearshots
	bra	domsg
ts1:
	cmpi.w	#fighter2,defences(a0)
	bne	ts2
	lea	worldvpb,a1
	move.w	#0,theta(a1)
	move.w	#0,phi(a1)
	move.w	#0,rho(a1)
	move.l	#fighter2loop,whichbattle
	bsr	dorandomobians
	move.w	#0,myrot
	bsr	initstars3
	move.w	#20,battlespeed2
	move.w	#40,battlespeed
	move.w	#0,myviewx
	move.w	#0,myviewy
	move.w	#5,dodge
	bsr	clearshots
	bra	domsg
ts2:
	cmpi.w	#multidek,defences(a0)
	bne	ts3
	lea	worldvpb,a1
	move.w	#0,theta(a1)
	move.w	#0,phi(a1)
	move.w	#0,rho(a1)
	move.l	#multideckloop,whichbattle
	bsr	initmulti
	move.w	#0,myrot
	bsr	initstars3
	move.w	#-1,hostile		;flag for deck shooting
	move.w	#-1,donewarn
	move.w	#20,battlespeed2
	move.w	#40,battlespeed
	move.w	#0,myviewx
	move.w	#0,myviewy
	tst.w	adsoftware
	bmi.s	nad
	move.w	#0,adsoftware
nad:
	bsr	clearshots
	bra	domsg
ts3:
	cmpi.w	#node,defences(a0)
	bne	tsbb
	move.w	#nodefence,defences(a0)
	addq.w	#1,evidence
	lea	worldvpb,a1
	move.w	#0,theta(a1)
	move.w	#0,phi(a1)
	move.w	#0,rho(a1)
	move.w	#0,myrot
	bsr	initstars3
	move.w	#0,myviewx
	move.w	#0,myviewy
	lea	box,a0
	move.w	#8000,obz(a0)
	move.w	#0,obx(a0)
	move.w	#0,oby(a0)
	move.w	#1,activeflag(a0)
	move.w	#20,battlespeed2
	move.w	#40,battlespeed
	bsr	clearshots
	bra	domsg2
tsbb:	jmp	shipscomputer

clearshots:
	lea	shot1,a0
	move.w	#-1,activeflag(a0)
	lea	shot2,a0
	move.w	#-1,activeflag(a0)
	lea	shot3,a0
	move.w	#-1,activeflag(a0)
	lea	shot4,a0
	move.w	#-1,activeflag(a0)
	rts
domsg:
	jsr	cleartext
	jsr	flip_scr
	jsr	flip_scr
	bsr	interference
	lea	dmsg1,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	move.l	#600000,d7
	jsr	generaldelay
	move.l	whichbattle,a0
	jmp	(a0)

domsg2:
	jsr	cleartext
	jsr	flip_scr
	jsr	flip_scr
	bsr	interference
	lea	dmsg2,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	move.l	#600000,d7
	jsr	generaldelay
dm2loop:
	jsr	drawpart5
	jsr	dospacestars
	lea	box,a0
	sub.w	#40,obz(a0)
	cmpi.w	#200,obz(a0)
	ble	dm2over
	move.l	obviewpb(a0),a1
	addq.w	#3,theta(a1)
	addq.w	#1,phi(a1)
	jsr	sortndrawlist
	jsr	flip_scr
	bra.s	dm2loop
dm2over:
	jsr	cleartext
	jsr	flip_scr2
	jsr	flip_scr2
	jsr	interference
	lea	datamsg,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	move.l	#500000,d7
	jsr	generaldelay
	jsr	flip_scr
	jsr	flip_scr
	move.w	#100,d7
dm3loop:
	move.w	d7,-(sp)	;save counter
	bsr	putdatastream
	move.w	(sp)+,d7
	dbf	d7,dm3loop
	jsr	cleartext
	jsr	interference
	lea	datamsg2,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	move.l	#500000,d7
	jsr	generaldelay
	jsr	interference
	lea	datamsg3,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	move.l	#900000,d7
	jsr	generaldelay
	jsr	cleartext
	jsr	interference
	lea	datamsg4,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	move.l	#800000,d7
	jsr	generaldelay
	jsr	cleartext
	jsr	interference
	lea	datamsg5,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	move.l	#800000,d7
	jsr	generaldelay
	jmp	shipscomputer
interference:
	move.l	a1,-(sp)
	lea	interferencesound,a1
	jsr	startsound
	move.l	(sp)+,a1
	move.l	#50000,d0
ifloop:
	nop
	nop
	nop
	nop
	nop
	move.w	#$0556,$ff8242
	move.w	#$0000,$ff8242
	subq.l	#1,d0
	bpl	ifloop
	rts

putdatastream:
	move.l	seen,a0
	lea	3216(a0),a0
	move.l	a0,a1
	move.w	#45,d7
pdsloop:
	moveq	#15,d6
pdsloop2:
	move	#32000,d0
	jsr	random
	move.w	d0,(a0)+
	move.w	d0,(a0)+
	move.w	d0,(a0)+
	move.w	d0,(a0)+
	dbf	d6,pdsloop2
	lea	320(a1),a1
	move.l	a1,a0
	dbf	d7,pdsloop
	rts
******************************************
hyperstars:
	jsr	interference
	move.l	destination,d0
	cmp.l	location,d0
	beq	hypererror
	jsr	initstars
	move.w	fuelminus,d0
	sub.w	d0,shipsfuel
	mulu	#5,d0
	move.w	d0,hypercount
	move.l	destination,location
	jsr	flip_scr
	jsr	flip_scr
	move.w	#0,myviewx
	move.w	#0,myviewy
	lea	met1,a0
	move.w	#-1,activeflag(a0)
	lea	met2,a0
	move.w	#-1,activeflag(a0)
	lea	met3,a0
	move.w	#-1,activeflag(a0)
	lea	met4,a0
	move.w	#-1,activeflag(a0)
	lea	met5,a0
	move.w	#-1,activeflag(a0)
	bsr	clearshots
	move.w	#7,pixelcolor
	move.w	#1,paused
	move.w	#0,hspeed
	jsr	initstars2
	bsr	hyploops
	move.l	#800000,d0
dlh:
	subq.l	#1,d0
	bpl	dlh

	bsr	reorg
	lea	starthypersound,a1
	jsr	startsound
	move.w	#170,hspeed
	move.w	#70,d7
hlop1:
	move.w	d7,-(sp)
	bsr	hyploops
	move.w	(sp)+,d7
	dbf	d7,hlop1

	move.w	#1,pixelcolor
	bsr	reorg
	lea	endhypersound,a1
	jsr	startsound
	move.w	#0,hspeed
	bsr	hyploops
	move.w	#170,hspeed
	move.w	#70,d7
hlop2:
	move.w	d7,-(sp)
	bsr	hyploops
	move.w	(sp)+,d7
	dbf	d7,hlop2
	move.w	#-1,paused
	lea	tubeconstantsound,a1
	jsr	startsound
	bra	tunnelloop

hyploops:
	lea	hyperstarsvrt,a0
	move.w	(a0)+,d7
	move.w	hspeed,d6
	subq.w	#1,d7
hyplop:
	tst.w	4(a0)
	bmi	skiphl
	sub.w	d6,4(a0)
	bmi	skiphl
	move.w	(a0)+,d0
	move.w	(a0)+,d1
	move.w	(a0)+,d2
	bsr	a3dmath
	move.w	d0,pixelx
	move.w	d1,pixely
	jsr	singleplot2
	tst.w	d0
	bpl	hok
	move.w	d7,-2(a0)
hok:	dbf	d7,hyplop
	rts	
skiphl:
	addq.l	#6,a0
	dbf	d7,hyplop
	rts


reorg:
	lea	hyperstarsvrt,a0
	move.w	(a0)+,d7
	subq.w	#1,d7
rlop:
	addq.l	#4,a0
	move.w	#12000,(a0)+
	dbf	d7,rlop
reb:	rts

hypererror:
	jsr	cleartext
	lea	errorsound,a1
	bsr	startsound
	lea	hyptext,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	move.l	#500000,d7
	jsr	generaldelay
	jmp	shipscomputer
*****************************************
*	give x,y,z in d0,d1,d2		*
*	returns onscreen coords in	*
*	d0,d1				*
*****************************************
a3dmath:
	moveq	#0,d3
	move.w	d0,d3		;get x
	ext.l	d3
	asl.l	#7,d3
	divs	d2,d3
	add.w	#159,d3 	;adjust for centre of screen
	move.w	d3,d0		;return screenx in d6

	moveq	#0,d3		;get y
	move.w	d1,d3
	ext.l	d3
	asl.l	#7,d3
	divs	d2,d3
	add.w	#67,d3		;adjust for centre
	move.w	d3,d1		;return screeny in d7
	rts
a3dmath2:
	moveq	#0,d3
	move.w	d0,d3		;get x
	ext.l	d3
	asl.l	#7,d3
	divs	d2,d3
	add.w	#159,d3 	;adjust for centre of screen
	move.w	d3,d0		;return screenx in d6

	moveq	#0,d3		;get y
	move.w	d1,d3
	ext.l	d3
	asl.l	#7,d3
	divs	d2,d3
	add.w	#67,d3		;adjust for centre
	move.w	d3,d1		;return screeny in d7
	rts
math3:
	moveq	#0,d3
	move.w	d0,d3		;get x
	ext.l	d3
	asl.l	#7,d3
	divs	d2,d3
	add.w	#159,d3 	;adjust for centre of screen
	move.w	d3,d0		;return screenx in d6

	moveq	#0,d3		;get y
	move.w	d1,d3
	ext.l	d3
	asl.l	#7,d3
	divs	d2,d3
	add.w	#67,d3		;adjust for centre
	move.w	d3,d1		;return screeny in d7
	rts
*******************************
parra1expansion:
	move.w	boomexp(a0),d7		;expansion factor 0-15
	move.w	d7,expansion
	move.w	expansion,d7		;expansion factor 0-15
	cmpi.w	#15,d7
	ble	ddddd2
	move.w	#15,d7
	move.w	d7,expansion
ddddd2:
	add.w	d7,d7
	lea	endmask,a1
	lea	addlist1,a2
	lea	addlist2,a3
	move.w	(a2,d7.w),d5		;mask
	move.w	(a3,d7.w),d6		;mask
	move.w	(a1,d7.w),d7		;mask

	move.w	boomframe(a0),d0
	subq.w	#1,boomframe(a0)
	bmi	noexpand
	move.w	boomx(a0),spritex
	move.w	boomy(a0),spritey
	bra	expandhere
noexpand:
	rts


*****************************************
doexptest:
	move.w	obx(a0),d7		;expansion factor 0-15
	move.w	d7,expansion
	cmpi.w	#15,d7
	ble	ddddd
	move.w	#15,d7
	move.w	d7,expansion
ddddd:
*	asl.w	#1,d7
	add.w	d7,d7
	lea	endmask,a1
	lea	addlist1,a2
	lea	addlist2,a3
	move.w	(a2,d7.w),d5		;mask
	move.w	(a3,d7.w),d6		;mask
	move.w	(a1,d7.w),d7		;mask

	move.w	activeflag(a0),d0
	addq.w	#1,activeflag(a0)
	neg	d0
	subq.w	#2,d0
expandhere:
	lea	explosionlist,a1
	asl.w	#2,d0
	move.l	(a1,d0.w),a0		;a0 necessary
	sub.w	d5,spritex
	sub.w	d6,spritey
	move.w	spritex,d0
	move.w	spritey,d1
	bsr	calcvsah
	move.l	a6,a4

	move.w	(a0)+,height		;height
	subq.w	#1,height
	move.w	(a0)+,width		;width
	subq.w	#2,width
del1:
	move.w	spritex,pixelx
	move.w	width,d0		;get width
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3
	moveq	#0,d4
	move.w	(a0),d1
	move.w	2(a0),d2
	move.w	4(a0),d3
	move.w	6(a0),d4
	and.w	d7,d1
	and.w	d7,d2
	and.w	d7,d3
	and.w	d7,d4
	swap	d1
	swap	d2
	swap	d3
	swap	d4
	moveq	#16,d5
	sub.w	expansion,d5
del2:
	moveq	#0,d6
	move.w	8(a0),d6
	and.w	d7,d6		;should be looked up depending on exp.
	lsl.l	d5,d6
	eor.l	d6,d1
	moveq	#0,d6
	move.w	10(a0),d6
	and.w	d7,d6		;should be looked up depending on exp.
	lsl.l	d5,d6
	eor.l	d6,d2
	moveq	#0,d6
	move.w	12(a0),d6
	and.w	d7,d6		;should be looked up depending on exp.
	lsl.l	d5,d6
	eor.l	d6,d3
	moveq	#0,d6
	move.w	14(a0),d6
	and.w	d7,d6		;should be looked up depending on exp.
	lsl.l	d5,d6
	eor.l	d6,d4
	sub.w	expansion,d5
	addq.l	#8,a0
	tst.w	d5
	ble	oneword
	dbf	d0,del2

hert:	addq.l	#8,a0

	swap	d1
	swap	d2
	swap	d3
	swap	d4
	moveq	#0,d6
	or.w	d1,d6		;calc mask
	or.w	d2,d6
	or.w	d3,d6
	or.w	d4,d6
	eor.w	#-1,d6
	move.w	expansion,d5
	move.l	a4,a5
	subq.w	#1,d5
	move.w	spritey,pixely
pil2:
	cmpi.w	#cymin,pixely
	blt	clt1
	cmpi	#cymax,pixely
	bgt	clt2
	cmpi.w	#cxmin,pixelx
	blt	clt2
	cmpi.w	#cxmax,pixelx
	bgt	clt2

	and.w	d6,(a5)
	and.w	d6,2(a5)
	and.w	d6,4(a5)
	and.w	d6,6(a5)
	eor.w	d1,(a5)
	eor.w	d2,2(a5)
	eor.w	d3,4(a5)
	eor.w	d4,6(a5)
clt1:
*	addi.l	#160,a5
	lea	160(a5),a5
	addq.w	#1,pixely
	dbf	d5,pil2
clt2:
	move.w	expansion,d5
	add.w	d5,spritey
	mulu	#160,d5
	add.w	d5,a6
	move.l	a6,a4
	subq.w	#1,height
	bpl	del1
none:	rts

oneword:
	neg.w	d5
	move.w	d5,-(sp)
	moveq	#16,d5
	sub.w	(sp)+,d5

	move.w	d5,-(sp)
	swap	d1
	swap	d2
	swap	d3
	swap	d4
	moveq	#0,d6
	or.w	d1,d6		;calc mask
	or.w	d2,d6
	or.w	d3,d6
	or.w	d4,d6
	eor.w	#-1,d6
	move.w	expansion,d5
	move.l	a4,a5
	subq.w	#1,d5
	move.w	spritey,pixely
pil:
	cmpi.w	#cymin,pixely
	blt	aclt1
	cmpi.w	#cymax,pixely
	bgt	aclt2
	cmpi.w	#cxmin,pixelx
	blt	aclt2
	cmpi.w	#cxmax,pixelx
	bgt	aclt2
	and.w	d6,(a5)
	and.w	d6,2(a5)
	and.w	d6,4(a5)
	and.w	d6,6(a5)
	eor.w	d1,(a5)
	eor.w	d2,2(a5)
	eor.w	d3,4(a5)
	eor.w	d4,6(a5)
aclt1:
*	addi.l	#160,a5
	lea	160(a5),a5
	addq.w	#1,pixely
	dbf	d5,pil
aclt2:
	move.w	(sp)+,d5
	move.w	#0,d1
	move.w	#0,d2
	move.w	#0,d3
	move.w	#0,d4

	addq.l	#8,a4
	add.w	#16,pixelx
	dbf	d0,del2
	bra	hert

*****************************************
drawcircle:
	moveq	#0,d0		;x
	moveq	#0,d1
	move.w	radius,d1	;y=rad
	moveq	#1,d2		;xupdate
	move.l	d1,d3		;yupdate
*	asl.w	#1,d3		;-2*r+1
	add.w	d3,d3
	neg.w	d3
	addq.w	#1,d3
	move.w	d2,d4
	add.w	d3,d4		;dump=d4=xupdate+yupdate
	lea	circlecoords,a0
dcloop:
	move.w	ycentre,pixely
	move.w	xcentre,pixelx
	add.w	d1,pixelx
	add.w	d0,pixely
*	bsr	putcoords
	move.w	ycentre,pixely
	move.w	xcentre,pixelx
	add.w	d0,pixelx
	sub.w	d1,pixely
	jsr	putcoords
	move.w	ycentre,pixely
	move.w	xcentre,pixelx
	sub.w	d0,pixely
	sub.w	d1,pixelx
*	bsr	putcoords
	move.w	ycentre,pixely
	move.w	xcentre,pixelx
	sub.w	d0,pixelx
	add.w	d1,pixely
	jsr	putcoords
	tst.w	d4
	bge	dca
	addq.w	#3,d0		;x=x+1
	addq.w	#5,d2		;xupdate=xupdate+2
	add.w	d2,d4		;dump=dump+xupdate
dca:
	tst.w	d4
	blt	dcb
	subq.w	#3,d1		;y=y-1
	addq.w	#5,d3		;yupdate=yupdate+2
	add.w	d3,d4		;dump=dump+yupdate
dcb:
	move.w	ycentre,pixely
	move.w	xcentre,pixelx
	add.w	d0,pixelx
	add.w	d1,pixely
	jsr	putcoords
	move.w	ycentre,pixely
	move.w	xcentre,pixelx
	add.w	d1,pixelx
	sub.w	d0,pixely
*	bsr	putcoords
	move.w	ycentre,pixely
	move.w	xcentre,pixelx
	sub.w	d0,pixelx
	sub.w	d1,pixely
	jsr	putcoords
	move.w	ycentre,pixely
	move.w	xcentre,pixelx
	sub.w	d1,pixelx
	add.w	d0,pixely
*	bsr	putcoords
	cmp.w	d0,d1
	bgt	dcloop
	move.l	a0,circ
	rts
*****************************************
initstars2:
	lea	hyperstarsvrt,a0
	move.w	(a0)+,d7		;numstars
	subq.w	#1,d7
inhsloop:
	move.w	#14000,d0
	jsr	random
	move.w	d0,(a0)+		;x
	move.w	#5000,d0
	jsr	random
	move.w	d0,(a0)+		;y
	move.w	#12000,d0
	move.w	d0,(a0)+		;z
	dbf	d7,inhsloop
	rts
*****************************************
initstars3:
	lea	starrotvpb,a0
	move.w	#0,theta(a0)
	move.w	#0,phi(a0)
	move.w	#0,rho(a0)
	lea	spacestarsvrt,a0
	move.w	(a0)+,d7		;numstars
	subq.w	#1,d7
inhsloop2:
	move.w	#9000,d0
	jsr	random
	move.w	d0,(a0)+		;x
	move.w	#9000,d0
	jsr	random
	move.w	d0,(a0)+		;y
	move.w	#14000,d0
	jsr	randomplus
	move.w	d0,(a0)+		;z
	dbf	d7,inhsloop2
	rts
*****************************************
initstars:
	lea	startvrt,a0
	move.w	(a0)+,d7	;skip numvrts
	subq.w	#1,d7
	lea	circlecoords,a1
inloop:
	move.w	#1128,d0
	jsr	randomplus
	add.w	d0,d0
	move.w	(a1,d0.w),(a0)+ 	;x
	move.w	2(a1,d0.w),(a0)+	;y
	move.w	#15360,d0
	jsr	randomplus
	move.w	d0,(a0)+		;z
	dbf	d7,inloop
	rts

*****************************************
clip_poly:
	move.l	a0,a1
	move.w	d7,d0
	lsl	#2,d0
	lea	-4(a1,d0.w),a2
	movem	(a2)+,d0/d1
	move	d0,d2
	move.w	d1,d3

*	move.w	2(a6),d6
	move.w	#cymin,d6
	cmp.w	d6,d3
	bge.s	next_cp1_t
	bra.s	next_cp2_t
cp_lp1_t:
	movem	(a1)+,d0/d1
	cmp.w	d6,d1
	bge.s	cp1_t
	bsr	horiz_cross
	moveq	#-1,d4
	bra.s	next_cp2_t
cp3_t:
	bsr	horiz_cross
cp1_t:
	move.w	d0,(a2)+
	move.w	d1,(a2)+
	move.w	d0,d2
	move.w	d1,d3
next_cp1_t:
	dbra	d7,cp_lp1_t
	bra.s	cp5_t
cp_lp2_t:
	move.w	d0,d2
	move.w	d1,d3
	movem	(a1)+,d0/d1
	cmp.w	d6,d1
next_cp2_t:
	dbge	d7,cp_lp2_t
	beq.s	cp1_t
	bgt.s	cp3_t

cp5_t:
	subq.l	#4,a2
	move.w	(a2)+,d0
	move.w	(a2)+,d1
	move.w	d0,d2
	move.w	d1,d3
	move.l	a2,d7
	sub.l	a1,d7
	beq	cp_off
	lsr	#2,d7
*	move.w	(a6),d6
	move.w	#cxmin,d6
	cmp.w	d6,d2
	bge.s	next_cp1_l
	bra.s	next_cp2_l
cp_lp1_l:
	movem	(a1)+,d0/d1
	cmp.w	d6,d0
	bge.s	cp1_l
	bsr	vert_cross
	moveq	#-1,d4
	bra.s	next_cp2_l
cp3_l:
	bsr	vert_cross
cp1_l:
	move.w	d0,(a2)+
	move.w	d1,(a2)+
	move.w	d0,d2
	move.w	d1,d3
next_cp1_l:
	dbra	d7,cp_lp1_l
	bra	cp5_l
cp_lp2_l:
	move.w	d0,d2
	move.w	d1,d3
	movem	(a1)+,d0/d1
	cmp	d6,d0
next_cp2_l:
	dbge	d7,cp_lp2_l
	beq.s	cp1_l
	bgt.s	cp3_l

cp5_l:
	subq.l	#4,a2
	move.w	(a2)+,d0
	move.w	(a2)+,d1
	move.w	d0,d2
	move.w	d1,d3
	move.l	a2,d7
	sub.l	a1,d7
	beq	cp_off
	lsr	#2,d7
*	move.w	(a6),d6
	move.w	#cymax,d6
	cmp.w	d6,d3
	ble.s	next_cp1_b
	bra.s	next_cp2_b
cp_lp1_b:
	movem	(a1)+,d0/d1
	cmp.w	d6,d1
	ble.s	cp1_b
	bsr	horiz_cross
	moveq	#1,d4
	bra.s	next_cp2_b
cp3_b:
	bsr	horiz_cross
cp1_b:
	move.w	d0,(a2)+
	move.w	d1,(a2)+
	move.w	d0,d2
	move.w	d1,d3
next_cp1_b:
	dbra	d7,cp_lp1_b
	bra	cp5_b
cp_lp2_b:
	move.w	d0,d2
	move.w	d1,d3
	movem	(a1)+,d0/d1
	cmp	d6,d1
next_cp2_b:
	dble	d7,cp_lp2_b
	beq.s	cp1_b
	blt.s	cp3_b

cp5_b:
	subq.l	#4,a2
	move.w	(a2)+,d0
	move.w	(a2)+,d1
	move.w	d0,d2
	move.w	d1,d3
	move.l	a2,d7
	sub.l	a1,d7
	beq	cp_off
	lsr	#2,d7
*	move.w	(a6),d6
	move.l	a0,a2
	move.w	#cxmax,d6
	cmp.w	d6,d2
	ble.s	next_cp1_r
	bra.s	next_cp2_r
cp_lp1_r:
	movem	(a1)+,d0/d1
	cmp.w	d6,d0
	ble.s	cp1_r
	bsr	vert_cross
	moveq	#1,d4
	bra.s	next_cp2_r
cp3_r:
	bsr.s	vert_cross
cp1_r:
	move.w	d0,(a2)+
	move.w	d1,(a2)+
	move.w	d0,d2
	move.w	d1,d3
next_cp1_r:
	dbra	d7,cp_lp1_r
	bra	cp5_r
cp_lp2_r:
	move.w	d0,d2
	move.w	d1,d3
	movem	(a1)+,d0/d1
	cmp	d6,d0
next_cp2_r:
	dble	d7,cp_lp2_r
	beq.s	cp1_r
	blt.s	cp3_r
cp5_r:
	move.l	a2,d7
	sub.l	a0,d7
	beq.s	cp_off
	lsr.w	#2,d7
	moveq	#0,d0
	rts
cp_off:
	moveq	#-1,d0
	rts
horiz_cross:
	move.w	d0,d4
	sub.w	d2,d4
	move.w	d1,d5
	sub.w	d6,d5
	muls	d5,d4
	move	d1,d5
	sub.w	d3,d5
	divs	d5,d4
	neg	d4
	add	d0,d4
	move.w	d4,(a2)+
	move.w	d6,(a2)+
	rts
vert_cross:
	move.w	d1,d4
	sub.w	d3,d4
	move.w	d0,d5
	sub.w	d6,d5
	muls	d5,d4
	move	d0,d5
	sub.w	d2,d5
	divs	d5,d4
	neg	d4
	add	d1,d4
	move.w	d6,(a2)+
	move.w	d4,(a2)+
	rts

*****************************************
*	my own personal poly draw	*
*****************************************
draw_polygon3:
	movem.l d0-d7/a0-a6,-(sp)
	move.w	surfacedfn,d7		;color
	move.w	surfacedfn+2,d5
	bsr	init_hcol2
	lea	surfacevrt,a0
	move.w	(a0)+,d7		;count
	addq.w	#1,d7
	move.w	d0,-(sp)
	bsr	clip_poly
	move	(sp)+,a1
	bmi	abort_poly

	move.w	d7,d0
	move.w	d0,d2
	move.w	d2,d6
	lsl.w	#2,d0
	lea	(a0,d0.w),a1
	lea	(a1,d0.w),a2
	move.l	a1,a4
	move.w	#$8000,d0
	move.w	#$7fff,d1
	bra.s	next_coord
coord_lp:
	move.l	(a0)+,d3
	cmp.w	d3,d0
	bge.s	check_low_y
	move.w	d3,d0
check_low_y:
	cmp.w	d3,d1
	ble.s	coord_trans
	move.w	d3,d1
	move.l	a1,a4
coord_trans:
	move.l	d3,(a1)+
	move.l	d3,(a2)+
next_coord:
	dbra	d6,coord_lp

	move.w	d0,d7
	sub.w	d1,d7

	move.l	a4,a3
	move.l	(a4),d0
	addq.w	#1,d7
flat_tp_lp1:
	addq.l	#4,a4
	subq.w	#1,d7
	bmi	abort_poly
	cmp	2(a4),d0
	beq.s	flat_tp_lp1
	bra.s	look_back
flat_tp_lp2:
	subq.l	#4,a3
look_back:
	cmp.w	-2(a3),d0
	beq.s	flat_tp_lp2

	move.l	hiden,a6
	lsl.w	#5,d0
	add.w	d0,a6
	lsl.w	#2,d0
	add.w	d0,a6
	lea	fcoltable1,a5
	pea	fcoltable2
	moveq	#0,d6
	bra	start_poly

polyfill_lp:
	move.l	d3,d0
	swap	d0
	bpl.s	no_rnd_1
	addq.w	#1,d0
no_rnd_1:
	move.l	d4,d1
	swap	d1
	bpl.s	no_rnd_r
	addq.w	#1,d1
no_rnd_r:
	add.l	a1,d3
	add.l	a2,d4

	exg	d0,d1
v_order_ok:
	move.w	d0,d2
	sub.w	d0,d1
	lsr.w	#1,d2
	and.w	#$fff8,d2
	lea	(a6,d2.w),a0
	and.w	#$f,d0
	moveq	#-1,d2
	lsr	d0,d2
	add.w	d1,d0
	sub.w	#16,d0
	bpl	multi_span
	addq.w	#1,d0
	neg.w	d0
	moveq	#-1,d1
	lsl.w	d0,d1
	and.w	d1,d2
*	move.w	d2,d1
	bsr	myputline
	bra.s	row_done
multi_span:
*	move.w	d2,d1
	bsr	myputline
	addq.w	#1,d0
	move.w	d0,d1
	lsr.w	#4,d0
	and.w	#$f,d1
	move.w	d1,-(sp)
	bra.s	next_p_row
p_row_lp:
	move.w	(a5),(a0)+
	move.w	2(a5),(a0)+
	move.w	4(a5),(a0)+
	move.w	6(a5),(a0)+
next_p_row:
	dbra	d0,p_row_lp
	move.w	(sp)+,d1
	moveq	#-1,d2
	lsr.w	d1,d2
	bsr	myputline2
row_done:
	tst.w	d7
	beq.s	poly_done
	subq.w	#1,d5
	bpl.s	more_rows_1
start_poly:
	sub.l	a2,d4
	moveq	#0,d3
	move.w	(a3),d3
	swap	d3
	move.w	-(a3),d5
	sub	4(a3),d5
	moveq	#0,d0
	move.w	d5,d0
	moveq	#0,d1
	move.w	-(a3),d1
	sub.w	4(a3),d1

	bsr.s	get_grad
	move.l	d0,a1
	cmpi.w	#1,d6
	bmi.s	two_verts
	addq.w	#1,d7
	bra.s	next_scan
more_rows_1:
	subq.w	#1,d6
	bpl.s	more_rows_r
	addq.w	#1,d5
	sub.l	a1,d3
two_verts:
	moveq	#0,d4
	move.w	-4(a4),d4
	swap	d4
	moveq	#0,d1
	move.w	(a4)+,d1
	move.w	(a4)+,d6
	sub.w	-6(a4),d6
	moveq	#0,d0
	move.w	d6,d0
	sub.w	-8(a4),d1

	bsr.s	get_grad
	move.l	d0,a2
	addq.w	#1,d7
	bra.s	next_scan
more_rows_r:
	lea	160(a6),a6
	move.l	(sp)+,d1
	exg	d1,a5
	move.l	d1,-(sp)
next_scan:
	dbra	d7,polyfill_lp
poly_done:
	addq.l	#4,sp
*	move.l	(sp)+,a6
abort_poly:
	movem.l (sp)+,d0-d7/a0-a6
	rts
get_grad:
	beq.s	vert_grad
	bmi.s	neg_grad

	divu	d0,d1
	swap	d0
	move.w	d1,d0
	swap	d0
	clr	d1
	divu	d0,d1
	move.w	d1,d0
	rts
vert_grad:
	moveq	#0,d0
	rts
neg_grad:
	neg.w	d1
	divu	d0,d1
	swap	d0
	move.w	d1,d0
	swap	d0
	clr	d1
	divu	d0,d1
	move.w	d1,d0
	neg.l	d0
	rts




myputline:
	not	d2
	and.w	d2,(a0)
	and.w	d2,2(a0)
	and.w	d2,4(a0)
	and.w	d2,6(a0)
	not	d2
	move.w	(a5),d1
	and.w	d2,d1
	or.w	d1,(a0)+
	move.w	2(a5),d1
	and.w	d2,d1
	or.w	d1,(a0)+
	move.w	4(a5),d1
	and.w	d2,d1
	or.w	d1,(a0)+
	move.w	6(a5),d1
	and.w	d2,d1
	or.w	d1,(a0)+
	rts
myputline2:
*	not	d2
	and.w	d2,(a0)
	and.w	d2,2(a0)
	and.w	d2,4(a0)
	and.w	d2,6(a0)
	not	d2
	move.w	(a5),d1
	and.w	d2,d1
	or.w	d1,(a0)+
	move.w	2(a5),d1
	and.w	d2,d1
	or.w	d1,(a0)+
	move.w	4(a5),d1
	and.w	d2,d1
	or.w	d1,(a0)+
	move.w	6(a5),d1
	and.w	d2,d1
	or.w	d1,(a0)+
	rts


init_hcol2:
		asl.w	#3,D7		;index a3 table
		asl.w	#3,D5		;index a3 table
		lea	col_table,a4
		lea	(a4,D7.w),a4 
		lea	fcoltable1,a3
		move.w	(a4)+,d0
		move.w	(a4)+,d1
		move.w	(a4)+,d2
		move.w	(a4)+,d3
		lea	col_table2,a4
		lea	(a4,d5.w),a4
		or.w	(a4)+,d0
		or.w	(a4)+,d1
		or.w	(a4)+,d2
		or.w	(a4)+,d3
		lea	fcoltable2,a2
		move.w	d0,(a3)
		move.w	d1,2(a3)
		move.w	d2,4(a3)
		move.w	d3,6(a3)
		ror.w	#1,d0
		ror.w	#1,d1
		ror.w	#1,d2
		ror.w	#1,d3
		move.w	d0,(a2)
		move.w	d1,2(a2)
		move.w	d2,4(a2)
		move.w	d3,6(a2)
		rts

***************************************
dobaddies:
	move.w	released,d1
	cmp.w	deceased,d1
	beq	newbaddies
	cmpi.w	#0,whichattack
	bne	baddies2
	moveq	#5,d0		;maxnumber
	sub.w	d1,d0
	asl.w	#3,d0		;*8 to give instruction offset
	lea	baddies1tower,a0
	add.w	d0,a0
	jmp	(a0)
baddies1tower:
	lea	enemy5,a0
	bsr.s	dobads1
	lea	enemy4,a0
	bsr.s	dobads1
	lea	enemy3,a0
	bsr.s	dobads1
	lea	enemy2,a0
	bsr.s	dobads1
	lea	enemy1,a0
	bsr.s	dobads1
	rts
dobads1:
	tst.w	cactive(a0)
	bmi	nobads1
swingin:
	move.w	scrollx2,d0
	move.w	scrolly2,d1
	move.w	cspritexvel(a0),d2
	asr.w	#4,d2
	add.w	d2,cspritex2(a0)
	move.w	cspriteyvel(a0),d2
	asr.w	#4,d2
	add.w	d2,cspritey2(a0)
	move.w	cspritex2(a0),d2
	move.w	cspritey2(a0),d3
	add.w	d0,d2
	add.w	d1,d3
	move.w	d2,cspritex(a0)
	move.w	d3,cspritey(a0)

	move.w	scrollx,d4
	cmp.w	cspritex2(a0),d4
	bgt.s	db1
	beq.s	db2
	subq.w	#4,cspritexvel(a0)	;easy intelligence
	bra.s	db2
db1:
	addq.w	#4,cspritexvel(a0)
db2:
	move.w	scrolly,d4
	neg.w	d4
	cmp.w	cspritey2(a0),d4
	bgt.s	db3
	beq.s	db4
	subq.w	#4,cspriteyvel(a0)	;easy intelligence
	bra.s	db4
db3:
	addq.w	#4,cspriteyvel(a0)
db4:
	cmpi.w	#4*16,cspritexvel(a0)
	ble.s	vb1
	move.w	#4*16,cspritexvel(a0)
	bra.s	vb2
vb1:
	cmpi.w	#-4*16,cspritexvel(a0)
	bge.s	vb2
	move.w	#-4*16,cspritexvel(a0)
vb2:
	cmpi.w	#4*16,cspriteyvel(a0)
	ble.s	vb3
	move.w	#4*16,cspriteyvel(a0)
	bra.s	vb4
vb3:
	cmpi.w	#-4*16,cspriteyvel(a0)
	bge.s	vb4
	move.w	#-4*16,cspriteyvel(a0)
vb4:
	bsr	drawclipped
nobads1:
	rts


baddies2:
	cmpi.w	#1,whichattack
	bne	newbaddies
	lea	enemy1,a0
	bsr.w	dobads1
	lea	enemy1,a0
	move.l	spritechain,a1
	move.w	cattackcount(a0),d0
	asl.w	#2,d0
	add.w	d0,a1
	move.w	cspritex2(a0),(a1)+
	move.w	cspritey2(a0),(a1)+
	addq.w	#1,cattackcount(a0)
	move.w	maxchain,d0
	cmp.w	cattackcount(a0),d0
	bge	notendofchain
	move.w	#0,cattackcount(a0)
notendofchain:
	move.l	spritechain,a1
	move.w	maxchain,d7
	lea	enemy2,a0
	bsr.s	dobads2
	lea	enemy3,a0
	bsr.s	dobads2
	lea	enemy4,a0
	bsr.s	dobads2
	lea	enemy5,a0
	bsr.s	dobads2
	rts

dobads2:	
	tst.w	cactive(a0)
	bmi	nodbad2
	move.w	cattackcount(a0),d0
	asl.w	#2,d0
	move.w	(a1,d0.w),d1
	move.w	2(a1,d0.w),d2
	move.w	d1,cspritex2(a0)
	move.w	d2,cspritey2(a0)
	add.w	scrollx2,d1
	add.w	scrolly2,d2
	move.w	d1,cspritex(a0)
	move.w	d2,cspritey(a0)
	addq.w	#1,cattackcount(a0)
	cmp.w	cattackcount(a0),d7
	bge	notendofchain2
	move.w	#0,cattackcount(a0)
notendofchain2:
	movem.l	d7/a1,-(sp)
	bsr	drawclipped
	movem.l	(sp)+,d7/a1
nodbad2:
	rts

newbaddies:
	move.w	#-1,whichattack
	move.w	#100,d0
	bsr	randomplus
	cmpi.w	#10,d0
	bgt	nonewat
	move.w	#0,whichattack
	move.w	#5,d0
	bsr	randomplus
	addq.w	#1,d0
	move.w	#0,deceased
	move.w	d0,released
	move.w	#100,d0
	bsr	random
	tst.w	d0
	bmi	badimage1
	move.l	enemyad1,a0		;which image
	bra	bad1
badimage1:
	move.l	enemyad2,a0
bad1:
	move.w	#100,d0
	bsr	random
	tst.w	d0
	bmi.w	bad2
	bsr.s	setbad1
	bra	dobaddies
setbad1:
	move.w	scrollx,d6
	move.w	scrolly,d7
	lea	enlist,a1
	move.w	released,d5
	subq.w	#1,d5
bad1loop:
	move.l	(a1)+,a2
	move.l	a0,cspritead(a2)
	move.w	#1,cactive(a2)
	move.w	#16,cspriteheight(a2)
	move.w	#100,d0
	bsr	random
	move.w	d0,d4
	move.w	#200,d0
	bsr	randomplus
	add.w	#300,d0
bd1la:
	tst.w	d4
	bge.s	bd1lb
	add.w	d6,d0
	move.w	d0,cspritey2(a2)
	bra.s	bd1lc
bd1lb:
	sub.w	d6,d0
	move.w	d0,cspritey2(a2)
bd1lc:
	move.w	#100,d0
	bsr	random
	move.w	d0,d4
	move.w	#200,d0
	bsr	randomplus
	add.w	#300,d0
	tst.w	d4
	bge.s	bd1ld
	add.w	d7,d0
	move.w	d0,cspritex2(a2)
	bra.s	bd1le
bd1ld:
	sub.w	d7,d0
	move.w	d0,cspritey2(a2)
bd1le:
	move.w	#4*16,d0
	bsr	random
	move.w	d0,cspritexvel(a2)
	move.w	#4*16,d0
	bsr	random
	move.w	d0,cspriteyvel(a2)
	dbf	d5,bad1loop
nonewat:
	rts
bad2:
	move.w	#1,whichattack
	move.w	scrollx,d6
	move.w	scrolly,d7
	lea	enlist,a1
	move.w	#5,released
	moveq	#0,d5
	move.l	enemyad1,a0
	bsr	bad1loop
	move.w	#10,d0
	bsr	randomplus
	add.w	#5,d0
	moveq	#0,d1
	move.l	enemyad2,a3
	lea	enemy1,a0
	move.w	#0,cattackcount(a0)
	lea	enemy2,a1
	bsr.s	putbad2
	lea	enemy1,a0
	lea	enemy3,a1
	bsr.s	putbad2
	lea	enemy1,a0
	lea	enemy4,a1
	bsr.s	putbad2
	lea	enemy1,a0
	lea	enemy5,a1
	bsr.s	putbad2
	add.w	d0,d1
	move.w	d1,maxchain
	move.w	cspritex2(a0),d0
	move.w	cspritey2(a0),d1
	move.l	generalstore,a0
	add.l	#80000,a0
	move.l	a0,spritechain
	move.w	#999,d7
putchl:
	move.w	d0,(a0)+
	move.w	d1,(a0)+
	dbf	d7,putchl
	bra	dobaddies

putbad2:
	add.w	d0,d1
	move.w	d1,cattackcount(a1)		;where in chain
	move.w	cspritex2(a0),cspritex2(a1)
	move.w	cspritey2(a0),cspritey2(a1)
	move.w	#1,cactive(a1)
	move.l	a3,cspritead(a1)
	move.w	#16,cspriteheight(a1)
	rts
*****************************************
doobjective:
	lea	obj1sp,a0
	move.w	cspritex2(a0),d0
	move.w	cspritey2(a0),d1
	add.w	scrollx2,d0
	add.w	scrolly2,d1
	move.w	d0,cspritex(a0)
	move.w	d1,cspritey(a0)
	lea	obj2sp,a1
	lea	obj3sp,a2
	lea	obj4sp,a3
	move.w	cspritex(a0),cspritex(a1)
	move.w	cspritey(a0),cspritey(a1)
	add.w	#16,cspritex(a1)
	move.w	cspritex(a0),cspritex(a2)
	move.w	cspritey(a0),cspritey(a2)
	add.w	#16,cspritey(a2)
	move.w	cspritex(a0),cspritex(a3)
	move.w	cspritey(a2),cspritey(a3)
	add.w	#16,cspritex(a3)
	bsr	drawclipped
	lea	obj2sp,a0
	bsr	drawclipped
	lea	obj3sp,a0
	bsr	drawclipped
	lea	obj4sp,a0
	bsr	drawclipped
	rts


*********************************************************
drawshots8way:
	lea	shotsprite1,a0
	bsr	dodrawshots8way
	lea	shotsprite2,a0
	bsr	dodrawshots8way
	lea	shotsprite3,a0
	bsr	dodrawshots8way
	lea	shotsprite4,a0
	bsr	dodrawshots8way
	rts

dodrawshots8way:
	tst.w	cactive(a0)
	bmi	noshot8way
	move.w	cspritexvel(a0),d0
	move.w	cspriteyvel(a0),d1
	add.w	d0,cspritex(a0)
	add.w	d1,cspritey(a0)
	cmpi.w	#cxmin,cspritex(a0)
	bge	dds81
	move.w	#-1,cactive(a0)
	rts
dds81:	cmpi.w	#cxmax,cspritex(a0)
	ble	dds82
	move.w	#-1,cactive(a0)
	rts
dds82:	cmpi.w	#cymin,cspritey(a0)
	bge	dds83
	move.w	#-1,cactive(a0)
	rts
dds83:	cmpi.w	#cymax,cspritey(a0)
	ble	dds84
	move.w	#-1,cactive(a0)
	rts
dds84:
	bsr	drawclipped
noshot8way:
	rts
*********************************************************
domeshoot8way:
	tst.w	changestate
	bpl.s	dms8b
	tst.w	buttondat
	beq.s	dms8b
	lea	shotsprite1,a0
	tst.w	cactive(a0)
	bmi.s	domes8
	lea	shotsprite2,a0
	tst.w	cactive(a0)
	bmi.s	domes8
*	cmpi.w	#1,shootstate2
*	bne.s	dms8b
	lea	shotsprite3,a0
	tst.w	cactive(a0)
	bmi.s	domes8
	lea	shotsprite4,a0
	tst.w	cactive(a0)
	bmi.s	domes8
dms8b:
	rts

domes8:
	lea	meshoot2sound,a1
	jsr	startsound
	move.w	shotxvel8joy,cspritexvel(a0)
	move.w	shotyvel8joy,cspriteyvel(a0)
	move.w	#158,cspritex(a0)
	move.w	#67,cspritey(a0)
	move.w	#1,cactive(a0)
	rts
*********************************************************
dome8way:
	tst.w	shipenergy
	bmi	domeboom
	move.l	hiden,a6
	lea	9352(a6),a6
	move.l	generalstore,a1
	add.w	whichme,a1
	moveq	#20,d7
meloop8way:
	move.w	(a6),d0 	;get 4 screen words
	move.w	2(a6),d1
	move.w	4(a6),d2
	move.w	6(a6),d3
	and.w	(a1),d0 	;mask word
	and.w	(a1),d1 	;mask word
	and.w	(a1),d2 	;mask word
	and.w	(a1)+,d3	;mask word
	or.w	(a1)+,d0	;or the sprite image in the hole
	or.w	(a1)+,d1	;we just cut
	or.w	(a1)+,d2
	or.w	(a1)+,d3
	move.w	d0,(a6)+	;put the picture in th picture
	move.w	d1,(a6)+
	move.w	d2,(a6)+
	move.w	d3,(a6)+
	move.w	(a6),d0 	;get 4 screen words
	move.w	2(a6),d1
	move.w	4(a6),d2
	move.w	6(a6),d3
	and.w	(a1),d0 	;mask word
	and.w	(a1),d1 	;mask word
	and.w	(a1),d2 	;mask word
	and.w	(a1)+,d3	;mask word
	or.w	(a1)+,d0	;or the sprite image in the hole
	or.w	(a1)+,d1	;we just cut
	or.w	(a1)+,d2
	or.w	(a1)+,d3
	move.w	d0,(a6)+	;put the picture in th picture
	move.w	d1,(a6)+
	move.w	d2,(a6)+
	move.w	d3,(a6)+
	lea	144(a6),a6
	dbf	d7,meloop8way
	rts
domeboom:
	bra	blowingup2
*	rts

*************************************************
pdoexplosions:
	lea	enemy10,a0
	cmpi.w	#-1,cactive(a0)
	bge.s	pde2
	bsr	dopexp
pde2:
	lea	enemy9,a0
	cmpi.w	#-1,cactive(a0)
	bge.s	pde3
	bsr	dopexp
pde3:
	lea	enemy8,a0
	cmpi.w	#-1,cactive(a0)
	bge.s	pde4
	bsr	dopexp
pde4:
	lea	enemy7,a0
	cmpi.w	#-1,cactive(a0)
	bge.s	pde5
	bsr	dopexp
pde5:
	lea	enemy6,a0
	cmpi.w	#-1,cactive(a0)
	bge.s	pde6
	bsr	dopexp
pde6:
	lea	enemy5,a0
	cmpi.w	#-1,cactive(a0)
	bge.s	pde7
	bsr	dopexp
pde7:
	lea	enemy4,a0
	cmpi.w	#-1,cactive(a0)
	bge.s	pde8
	bsr	dopexp
pde8:
	lea	enemy3,a0
	cmpi.w	#-1,cactive(a0)
	bge.s	pde9
	bsr	dopexp
pde9:
	lea	enemy2,a0
	cmpi.w	#-1,cactive(a0)
	bge.s	pde10
	bsr	dopexp
pde10:
	lea	enemy1,a0
	cmpi.w	#-1,cactive(a0)
	bge.s	pde11
	bsr	dopexp
pde11:	rts

dopexp:
	addq.w	#1,cactive(a0)
	cmpi.w	#-1,cactive(a0)
	bne	dddexp
	addq.w	#1,deceased
dddexp:
	move.w	cactive(a0),d0
	add.w	#20,d0
	moveq	#0,d7
	lsl.w	#5,d0		;*128
	move.w	d0,d7
	lsl.w	#2,d0
	add.w	d0,d7		;=*160 gives line add

	move.w	cspritex(a0),d0
	cmpi.w	#cxmin,d0
	blt	noexp
	cmpi.w	#cxmax,d0
	bgt	noexp
	move.w	cspritey(a0),d1
	bmi	noexp
	addq.w	#3,d1
	lsl.w	#2,d1
	lsr.w	#1,d0
	and.w	#$00f8,d0
	move.l	#0,a2
	move.w	d0,a2
	move.l	ytable,a3
	adda.l	(a3,d1.w),a2

	moveq	#10,d1		;counter
	move.l	a2,a1
	lea	160(a1),a1
	move.l	hiden,a4
	move.l	a4,a3
	lea	19680-160(a4),a4
	lea	2080+160(a3),a3
	moveq	#-1,d0
explodeloop:
	cmp.l	a4,a2
	bgt	eskip1
	cmp.l	a3,a2
	blt	eskip1a
	move.l	d0,(a2)
	move.l	d0,4(a2)
	move.l	d0,160(a2)
	move.l	d0,164(a2)
eskip1a:
	add.w	d7,a2
eskip1:
	cmp.l	a3,a1
	blt	eskip2
	cmp.l	a4,a1
	bgt	eskip2a
	move.l	d0,(a1)
	move.l	d0,4(a1)
	move.l	d0,160(a1)
	move.l	d0,164(a1)
eskip2a:
	sub.w	d7,a1
eskip2:
	dbf	d1,explodeloop
noexp:	rts

*************************************************
randomexp:
	move.w	cspritex(a0),d5
	move.w	cspritey(a0),d6
	addq.w	#8,d5
	addq.w	#3,d6
	asl.w	#3,d5
	asl.w	#3,d6
	move.l	generalstore,a0
	add.l	#90000+3360+37120,a0
	move.l	a0,expstars
	move.w	#30,d7		;number of explosion points
rdeloop:
	move.w	d5,(a0)+	;x
	move.w	d6,(a0)+	;y
	moveq	#40,d0
	bsr	random
	move.w	d0,(a0)+	;random xvel
	moveq	#80,d0
	bsr	randomplus
	neg.w	d0
	move.w	d0,(a0)+	;random yvel
	dbf	d7,rdeloop
	rts
*************************************************
pdocollisions:
	lea	shipsprite0,a0
	tst.w	cactive(a0)
	bmi	nocollisions
	lea	shipsprite1,a0
	tst.w	cactive(a0)
	bmi	nocollisions

	lea	addon1,a0
	move.w	cactive(a0),d6
	bsr.w	checkallenemy
	lea	addon2,a0
	move.w	cactive(a0),d6
	bsr.w	checkallenemy

	lea	shipsprite0,a0
	moveq	#-40,d6
	bsr.w	checkallenemy
	tst.w	d0
	bmi.s	noexpship1
	lea	mehitsound,a1
	jsr	startsound
	bra	randomexp
noexpship1:
	lea	shipsprite1,a0
	moveq	#-40,d6
	bsr.w	checkallenemy
	tst.w	d0
	bmi.s	noexpship2
	lea	mehitsound,a1
	jsr	startsound
	bra	randomexp
noexpship2:
	cmpi.w	#3,shootstate
	beq	dolaserhit
	lea	shotsprite1,a0
	moveq	#-1,d6
	bsr.w	checkallenemy
	lea	shotsprite2,a0
	moveq	#-1,d6
	bsr.w	checkallenemy
	lea	shotsprite3,a0
	moveq	#-1,d6
	bsr.w	checkallenemy
	lea	shotsprite4,a0
	moveq	#-1,d6
	bsr.w	checkallenemy
nocollisions:
	rts

explodechain:
	lea	enemy5,a0
	tst.w	cactive(a0)
	bmi	ec1
	move.w	#-21,cactive(a0)
ec1:
	lea	enemy4,a0
	tst.w	cactive(a0)
	bmi	ec2
	move.w	#-21,cactive(a0)
ec2:
	lea	enemy3,a0
	tst.w	cactive(a0)
	bmi	ec3
	move.w	#-21,cactive(a0)
ec3:
	lea	enemy2,a0
	tst.w	cactive(a0)
	bmi	ec4
	move.w	#-21,cactive(a0)
ec4:
	rts
collisions8:
	lea	dummyship,a0
	move.w	#1,cactive(a0)
	moveq	#-1,d6
	bsr.w	cha6b
	tst.w	d0
	bmi.s	colover
	lea	channel1params,a1
	move.w	#-1,channelprocess(a1)
	jsr	stopsound0	
*	move.l	a1,-(sp)
	lea	energydrainsound,a1
	jsr	startsound
*	move.l	(sp)+,a1
colover:
	lea	shotsprite1,a0
	moveq	#-1,d6
	bsr.w	cha6
	tst.w	d6
	bmi.s	c82
	cmpi.w	#1,whichattack
	bne.s	c82
	bra	explodechain
c82:
	lea	shotsprite2,a0
	moveq	#-1,d6
	bsr.w	cha6
	tst.w	d6
	bmi.s	c83
	cmpi.w	#1,whichattack
	bne.s	c83
	bra	explodechain
c83:
	lea	shotsprite3,a0
	moveq	#-1,d6
	bsr.w	cha6
	tst.w	d6
	bmi.s	c84
	cmpi.w	#1,whichattack
	bne.s	c84
	bra	explodechain
c84:
	lea	shotsprite4,a0
	moveq	#-1,d6
	bsr.w	cha6
	tst.w	d6
	bmi.s	c85
	cmpi.w	#1,whichattack
	bne.s	c85
	bra	explodechain
c85:
	lea	shotsprite1,a0
	bsr.s	checkobjective
	lea	shotsprite2,a0
	bsr.s	checkobjective
	lea	shotsprite3,a0
	bsr.s	checkobjective
	lea	shotsprite4,a0
	bsr.s	checkobjective
	rts

checkobjective:
	tst.w	cactive(a0)
	bmi	noobjhit
	lea	obj1sp,a1
	move.w	cspritex(a1),d0
	move.w	cspritey(a1),d1
	move.w	cspritex(a0),d2
	move.w	cspritey(a0),d3
	cmp.w	d0,d2
	blt	noobjhit
	cmp.w	d1,d3
	blt	noobjhit
	add.w	#32,d0
	add.w	#32,d1
	cmp.w	d0,d2
	bgt	noobjhit
	cmp.w	d1,d3
	bgt	noobjhit
	move.w	#-1,cactive(a0)		;sound
	move.l	a1,-(sp)
	lea	exploparasound,a1
	jsr	startsound
	move.l	(sp)+,a1
	subq.w	#1,objhitcount(a1)
	bmi	wayover
noobjhit:
	rts

wayover:
	addq.l	#8,sp		;remove two return ads
	lea	obj1sp,a0
	move.w	cspritex(a0),d0
	move.w	cspritey(a0),d1
	add.w	#16,d0
	add.w	#16,d1
	lea	enemy1,a0
	move.w	#-30,cactive(a0)
	move.w	d1,cspritey(a0)
	move.w	d0,cspritex(a0)
	lea	enemy2,a0
	move.w	#-29,cactive(a0)
	move.w	d1,cspritey(a0)
	move.w	d0,cspritex(a0)
	sub.w	#16,cspritex(a0)
	lea	enemy3,a0
	move.w	#-29,cactive(a0)
	move.w	d1,cspritey(a0)
	move.w	d0,cspritex(a0)
	add.w	#16,cspritex(a0)
	lea	enemy4,a0
	move.w	#-28,cactive(a0)
	move.w	d1,cspritey(a0)
	move.w	d0,cspritex(a0)
	sub.w	#32,cspritex(a0)
	lea	enemy5,a0
	move.w	#-28,cactive(a0)
	move.w	d1,cspritey(a0)
	move.w	d0,cspritex(a0)
	add.w	#32,cspritex(a0)
	lea	enemy6,a0
	move.w	#-27,cactive(a0)
	move.w	d1,cspritey(a0)
	move.w	d0,cspritex(a0)
	sub.w	#48,cspritex(a0)
	lea	enemy7,a0
	move.w	#-27,cactive(a0)
	move.w	d1,cspritey(a0)
	move.w	d0,cspritex(a0)
	add.w	#48,cspritex(a0)
	lea	enemy8,a0
	move.w	#-26,cactive(a0)
	move.w	d1,cspritey(a0)
	move.w	d0,cspritex(a0)
	sub.w	#64,cspritex(a0)
	lea	enemy9,a0
	move.w	#-26,cactive(a0)
	move.w	d1,cspritey(a0)
	move.w	d0,cspritex(a0)
	add.w	#64,cspritex(a0)
	move.l	#45,d0
	move.w	#0,xvel
	move.w	#0,yvel
	lea	mehitsound,a1
	jsr	startsound
wayol:
	move.l	d0,-(sp)
	jsr	scroll8way
*	jsr	doobjective
	jsr	dome8way
	jsr	pde6		;halfway through pdoexplosions
	jsr	doradar8
	jsr	flip_scr3
	jsr	keysbattle
	move.w	#20000,d0
wd:
	dbf	d0,wd
	move.l	(sp)+,d0
	dbf	d0,wayol
	jmp	pfover2



checkallenemy:
	tst.w	cactive(a0)
	bmi	cha11
	lea	enemy10,a1
	bsr	spritehit
	tst.w	d0
	bmi	cha2
	move.w	#-21,cactive(a1)
	move.w	d6,cactive(a0)
	rts
cha2:
	lea	enemy9,a1
	bsr	spritehit
	tst.w	d0
	bmi.s	cha3
	move.w	#-21,cactive(a1)
	move.w	d6,cactive(a0)
	rts
cha3:
	lea	enemy8,a1
	bsr	spritehit
	tst.w	d0
	bmi.s	cha4
	move.w	#-21,cactive(a1)
	move.w	d6,cactive(a0)
	rts
cha4:
	lea	enemy7,a1
	bsr	spritehit
	tst.w	d0
	bmi.s	cha5
	move.w	#-21,cactive(a1)
	move.w	d6,cactive(a0)
	rts
cha5:
	lea	enemy6,a1
	bsr	spritehit
	tst.w	d0
	bmi.s	cha6
	move.w	#-21,cactive(a1)
	move.w	d6,cactive(a0)
	rts
cha6:
	tst.w	cactive(a0)
	bmi	cha11
	lea	enemy5,a1
	bsr	spritehit
	tst.w	d0
	bmi.s	cha7
	move.w	#-21,cactive(a1)
	move.w	d6,cactive(a0)
	rts
cha7:
	lea	enemy4,a1
	bsr	spritehit
	tst.w	d0
	bmi.s	cha8
	move.w	#-21,cactive(a1)
	move.w	d6,cactive(a0)
	rts
cha8:
	lea	enemy3,a1
	bsr	spritehit
	tst.w	d0
	bmi.s	cha9
	move.w	#-21,cactive(a1)
	move.w	d6,cactive(a0)
	rts
cha9:
	lea	enemy2,a1
	bsr	spritehit
	tst.w	d0
	bmi.s	cha10
	move.w	#-21,cactive(a1)
	move.w	d6,cactive(a0)
	rts
cha10:
	lea	enemy1,a1
	bsr	spritehit
	tst.w	d0
	bmi.s	cha11
	move.w	#-21,cactive(a1)
	move.w	d6,cactive(a0)
	moveq	#1,d6
cha11:	rts

cha6b:
	lea	enemy5,a1
	bsr	spritehit
	tst.w	d0
	bmi.s	cha7b
*	move.w	#-21,cactive(a1)
	subq.w	#1,shipenergy
	rts
cha7b:
	lea	enemy4,a1
	bsr	spritehit
	tst.w	d0
	bmi.s	cha8b
*	move.w	#-21,cactive(a1)
	subq.w	#1,shipenergy
	rts
cha8b:
	lea	enemy3,a1
	bsr	spritehit
	tst.w	d0
	bmi.s	cha9b
*	move.w	#-21,cactive(a1)
	subq.w	#1,shipenergy
	rts
cha9b:
	lea	enemy2,a1
	bsr	spritehit
	tst.w	d0
	bmi.s	cha10b
*	move.w	#-21,cactive(a1)
	subq.w	#1,shipenergy
	rts
cha10b:
	lea	enemy1,a1
	bsr	spritehit
	tst.w	d0
	bmi.s	cha11b
*	move.w	#-21,cactive(a1)
	subq.w	#1,shipenergy
	moveq	#1,d6
cha11b:	rts


dolaserhit:
	lea	laser1,a0
	tst.w	laserlife(a0)
	bmi	dlh2
	move.w	laserx(a0),d2
	move.w	lasery(a0),d3
	bsr	checklaser
dlh2:
	lea	laser2,a0
	tst.w	laserlife(a0)
	bmi	dlh3
	move.w	laserx(a0),d2
	move.w	lasery(a0),d3
	bsr	checklaser
dlh3:
	lea	laser3,a0
	tst.w	laserlife(a0)
	bmi	dlh4
	move.w	laserx(a0),d2
	move.w	lasery(a0),d3
	bsr	checklaser
dlh4:
	moveq	#-1,d0
	rts


checklaser:
	lea	enemy1,a1
	bsr	laserhit
	tst.w	d0
	bmi	chl2
	rts
chl2:
	lea	enemy2,a1
	bsr	laserhit
	tst.w	d0
	bmi	chl3
	rts
chl3:
	lea	enemy3,a1
	bsr	laserhit
	tst.w	d0
	bmi	chl4
	rts
chl4:
	lea	enemy4,a1
	bsr	laserhit
	tst.w	d0
	bmi	chl5
	rts
chl5:
	lea	enemy5,a1
	bsr	laserhit
	tst.w	d0
	bmi	chl6
	rts
chl6:
	lea	enemy6,a1
	bsr	laserhit
	tst.w	d0
	bmi	chl7
	rts
chl7:
	lea	enemy7,a1
	bsr	laserhit
	tst.w	d0
	bmi	chl8
	rts
chl8:
	lea	enemy8,a1
	bsr	laserhit
	tst.w	d0
	bmi	chl9
	rts
chl9:
	lea	enemy9,a1
	bsr	laserhit
	tst.w	d0
	bmi	chl10
	rts
chl10:
	lea	enemy10,a1
	bsr	laserhit
chl11:	rts

laserhit:
	tst.w	cactive(a1)
	bmi	nolaserhit
	move.w	cspritex(a1),d0
	move.w	cspritey(a1),d1
	cmpi.w	#cxmax,d0
	bgt	nolaserhit
	cmp.w	d0,d2
	bgt	nolaserhit
	cmp.w	d3,d1
	bgt	nolaserhit
	add.w	cspriteheight(a1),d1
	cmp.w	d3,d1
	blt	nolaserhit
	move.w	#-21,cactive(a1)
	moveq	#1,d0
	move.l	a1,-(sp)
	lea	exploparasound,a1
	jsr	startsound
	move.l	(sp)+,a1
	rts
nolaserhit:
	moveq	#-1,d0
	rts
*************************************************
doattack:
	cmpi.w	#0,whichattack
	bne	dat2
	move.w	released,d1
	cmp.w	deceased,d1
	beq	newattack
	moveq	#10,d0
	sub.w	d1,d0
	asl.w	#3,d0		;*8 to give instruction offset
	lea	tower1,a0
	add.w	d0,a0
	jmp	(a0)
tower1:
	lea	enemy10,a0
	bsr.s	dostrat1
	lea	enemy9,a0
	bsr.s	dostrat1
	lea	enemy8,a0
	bsr.s	dostrat1
	lea	enemy7,a0
	bsr.s	dostrat1
	lea	enemy6,a0
	bsr.s	dostrat1
	lea	enemy5,a0
	bsr.s	dostrat1
	lea	enemy4,a0
	bsr.s	dostrat1
	lea	enemy3,a0
	bsr.s	dostrat1
	lea	enemy2,a0
	bsr.s	dostrat1
	lea	enemy1,a0
	bsr.s	dostrat1
	rts
dostrat1:
	tst.w	cactive(a0)
	bmi	strat1back
	move.w	cspriteyvel(a0),d0
	add.w	d0,cspritey(a0)
	move.w	cspritexvel(a0),d0
	sub.w	d0,cspritex(a0)
	cmpi.w	#cxmin-36,cspritex(a0)
	bgt	drawstrat1
	addq.w	#1,deceased
	move.w	#-1,cactive(a0)
	rts
drawstrat1:
	sub.w	d0,cattackcount(a0)
	bpl	drawstrat2
	lea	shipsprite1,a1
	move.w	cspritey(a1),d1
	cmp.w	cspritey(a0),d1
	bgt	dst1
	move.w	#-1,cspriteyvel(a0)
	move.w	#420,cattackcount(a0)	;reset so it don't happen again
	bra	drawstrat2
dst1:
	move.w	#1,cspriteyvel(a0)
	move.w	#420,cattackcount(a0)
drawstrat2:
	bsr	drawclipped
strat1back:
	rts

dat2:
	cmpi.w	#1,whichattack
	bne	dat3
	move.w	released,d1
	cmp.w	deceased,d1
	beq	newattack
	lea	enlist,a1
	lea	circcoords,a6
	moveq	#9,d0
dat2loop:
	move.l	(a1)+,a0
	tst.w	cactive(a0)
	bmi	dat2fin2
	move.w	cspritexvel(a0),d1
	sub.w	d1,cspritex2(a0)
	cmpi.w	#cxmin-36,cspritex2(a0)
	bgt	dat2ok
	addq.w	#1,deceased
	move.w	#-1,cactive(a0)
	bra	dat2fin2
dat2ok:
	move.w	cattackcount(a0),d2
	add.w	d2,d2			;*2
	move.b	(a6,d2.w),d3
	move.b	1(a6,d2.w),d4
	ext.w	d3
	ext.w	d4
	move.w	cspritex2(a0),d1
	move.w	cspritey2(a0),d2
	add.w	d3,d1
	add.w	d4,d2
	move.w	d1,cspritex(a0)
	move.w	d2,cspritey(a0)
	move.w	cspriteyvel(a0),d1
	sub.w	d1,cattackcount(a0)
	tst.w	cattackcount(a0)
	bge	dat2fin
	move.w	#88,cattackcount(a0)
dat2fin:
	movem.l d0/a1/a6,-(sp)
	bsr	drawclipped
	movem.l (sp)+,d0/a1/a6
dat2fin2:
	dbf	d0,dat2loop
	rts

dat3:
	cmpi.w	#2,whichattack
	bne	dat4
	move.w	released,d1
	cmp.w	deceased,d1
	beq	newattack
	lea	enlist,a1
	lea	circcoords,a6
	move.w	released,d0
	subq.w	#1,d0
dat3loop:
	move.l	(a1)+,a0
	tst.w	cactive(a0)
	bmi	dat3fin2
	move.w	cspritexvel(a0),d1
	sub.w	d1,cspritex2(a0)
	cmpi.w	#cxmin-36,cspritex2(a0)
	bgt	dat3ok
	addq.w	#1,deceased
	move.w	#-1,cactive(a0)
	bra	dat3fin2
dat3ok:
	move.w	cattackcount(a0),d2
	add.w	d2,d2			;*2
	move.b	(a6,d2.w),d3
	move.b	1(a6,d2.w),d4
	ext.w	d3
	ext.w	d4
	move.w	cspritex2(a0),d1
	move.w	cspritey2(a0),d2
	add.w	d3,d1
	add.w	d4,d2
	move.w	d1,cspritex(a0)
	move.w	d2,cspritey(a0)
	subq.w	#2,cattackcount(a0)
	tst.w	cattackcount(a0)
	bge	dat3fin
	move.w	#88,cattackcount(a0)
dat3fin:
	movem.l d0/a1/a6,-(sp)
	bsr	drawclipped
	movem.l (sp)+,d0/a1/a6
dat3fin2:
	dbf	d0,dat3loop
	rts


dat4:
	cmpi.w	#3,whichattack
	bne	dat5
	move.w	released,d1
	cmp.w	deceased,d1
	beq	newattack
	lea	enlist,a1
	lea	circcoords,a6
	moveq	#9,d0
dat4loop:
	move.l	(a1)+,a0
	tst.w	cactive(a0)
	bmi	dat4fin2
	move.w	cspritexvel(a0),d1
	sub.w	d1,cspritex2(a0)
	cmpi.w	#cxmin-36,cspritex2(a0)
	bgt	dat4ok
	addq.w	#1,deceased
	move.w	#-1,cactive(a0)
	bra	dat4fin2
dat4ok:
	move.w	cattackcount(a0),d2
	add.w	d2,d2			;*2
	move.b	1(a6,d2.w),d4
	ext.w	d4
	move.w	cspritex2(a0),d1
	move.w	cspritey2(a0),d2
	add.w	d4,d2
	move.w	d1,cspritex(a0)
	move.w	d2,cspritey(a0)
	move.w	cspriteyvel(a0),d1
	sub.w	d1,cattackcount(a0)
	tst.w	cattackcount(a0)
	bge	dat4fin
	move.w	#88,cattackcount(a0)
dat4fin:
	movem.l d0/a1/a6,-(sp)
	bsr	drawclipped
	movem.l (sp)+,d0/a1/a6
dat4fin2:
	dbf	d0,dat4loop
	rts

dat5:
	bra	newattack
	rts

newattack:
	move.w	#500,d0
	bsr	randomplus
	cmpi.w	#5,d0
	bge	nonewattack
	moveq	#0,d0
	move.l	atlist,a0
	move.b	(a0)+,d0
	bmi	planetfinished
	move.l	a0,atlist
	move.w	d0,whichattack
	beq	strat1setup
	cmpi.w	#1,d0
	beq	strat2setup
	cmpi.w	#2,d0
	beq	strat3setup
	cmpi.w	#3,d0
	beq	strat2setup
nonewattack:
	rts

planetfinished:
	lea	endofparasound,a1
	jsr	startsound
	addq.l	#4,sp
	cmpi.b	#-2,d0
	beq	finwithload
pfloop1:
	bsr	parralaxscroll
	lea	shipsprite0,a0
	addq.w	#5,cspritex(a0)
	cmpi.w	#500,cspritex(a0)
	bge	pfover
	jsr	pmyship2
	jsr	flip_scr3
	bra.s	pfloop1
pfover:
	move.l	#bluepalette,whichpalette
	bsr	doresult
	jmp	shipscomputer
finwithload:
pfloop2:
	bsr	parralaxscroll2
	lea	shipsprite0,a0
	addq.w	#5,cspritex(a0)
	cmpi.w	#500,cspritex(a0)
	bge	pfover2
	jsr	p2stars
	jsr	pmyship2
	jsr	flip_scr4
	bra.s	pfloop2
pfover2:
	move.l	#planetfile,filename
	move.l	generalstore,wheretoload
	move.l	#80752,lengthtoread
	jsr	loadfile
	move.l	#fileshipcomp,filename
	jsr	loadscr
	jsr	copyintoboth
	move.l	#bluepalette,whichpalette
	bsr	doresult
	jmp	shipscomputer

doresult:
	bsr	cleartext
	jsr	flip_scr2
	jsr	flip_scr2
	move.l	planetdestination,a6
	move.w	prize(a6),d0		;what was there
	move.w	#notn,prize(a6)		;clear it out for later
	cmpi.w	#notn,d0
	bne.s	dr1
	lea	nothingmsg,a0
	move.l	#-1,whichob
	bra.w	printresult
dr1:
	cmpi.w	#evd,d0
	bne.s	dr2
	addq.w	#1,evidence
	lea	evidencemsg,a0
	move.l	#eviob,whichob
	bra.s	printresult
dr2:
	cmpi.w	#cred,d0
	bne.s	dr3
	add.w	#1000,credits
	lea	credmsg,a0
	move.l	#credob,whichob
	bra.s	printresult
dr3:
	cmpi.w	#wep,d0
	bne.s	dr4
	addq.w	#1,amat
	lea	wepmsg,a0
	move.l	#amatob,whichob
	bra.s	printresult
dr4:
	cmpi.w	#fuel,d0
	bne.s	dr5
	add.w	#250,shipsfuel
	lea	fuelmsg,a0
	move.l	#fuelob,whichob
	bra.s	printresult
dr5:
	cmpi.w	#bub,d0
	bne.s	dr6
	lea	bubmsg,a0
	move.l	#bubob,whichob
*	bra.s	printresult	;special	!!!!!!!!!!!!!
dr6:

printresult:
	jsr	interference
	jsr	printmany	
pranim:
	tst.l	whichob
	bmi	skipob
	lea	worldvpb,a6
	move.w	#0,theta(a6)
	move.w	#0,phi(a6)
	move.l	whichob,a0
	move.l	obviewpb(a0),a0
	addq.w	#2,theta(a0)
	addq.w	#2,phi(a0)
	subq.w	#1,rho(a0)
	bsr	dobefore
skipob:
	jsr	flip_scr2
	move.l	keybuf,a0
	move.w	6(a0),d0
	cmp.w	8(a0),d0
	beq	pranim
	lea	keyclicksound,a1	;soundhere
	jsr	startsound
	move.w	#2,-(sp)
	move.w	#2,-(sp)
	trap	#13
	addq.l	#4,sp
	swap	d0
spa:	cmpi.w	#$39,d0
	bne	co
	rts
co:
	cmpi.w	#$2e,d0
	bne	cont
	rts
cont:
	bra.s	pranim

strat3setup:
	bsr	dovarious
	move.w	d0,released
	move.w	#0,deceased
	move.w	#5,d0
	jsr	randomplus
	addq.w	#2,d0
	move.w	d0,d4		;xvel
	move.w	#40,d0
	jsr	randomplus
	add.w	#10,d0
	move.w	d0,d5		;dist apart
	lea	enlist,a0
	move.w	released,d6		;loop counter
	subq.w	#1,d6
	moveq	#0,d2		;circle counter
strat3loop:
	move.l	(a0)+,a2	;get ad of enemy struct
	move.w	#1,cactive(a2)
	move.w	d2,cattackcount(a2)
	move.l	a1,cspritead(a2)
	move.w	d7,cspriteheight(a2)
	move.w	#100,d0
	jsr	randomplus
	add.w	#13,d0
	move.w	d0,cspritey2(a2)
	move.w	d0,cspritey(a2)
	move.w	#250,d0
	jsr	randomplus
	add.w	#320,d0
	move.w	d0,cspritex2(a2)
	move.w	d0,cspritex(a2)
	move.w	#0,cspriteyvel(a2)
	move.w	d4,cspritexvel(a2)
	addq.w	#8,d2
	dbf	d6,strat3loop
	rts

strat2setup:
	move.w	#10,released
	move.w	#0,deceased
	bsr	dovarious
	move.w	#2,d0
	jsr	randomplus
	addq.w	#1,d0
	move.w	d0,d6
	move.w	#5,d0
	jsr	randomplus
	addq.w	#2,d0
	move.w	d0,d4
	move.w	#40,d0
	jsr	randomplus
	add.w	#10,d0
	move.w	d0,d5
	move.w	#100,d0
	jsr	randomplus
	add.w	#13,d0
	move.w	d0,d3		;y value
	lea	enlist,a0
	moveq	#9,d0		;loop counter
	move.w	#320,d1 	;x counter
	moveq	#0,d2		;circle counter
strat2loop:
	move.l	(a0)+,a2	;get ad of enemy struct
	move.w	#1,cactive(a2)
	move.w	d2,cattackcount(a2)
	move.l	a1,cspritead(a2)
	move.w	d7,cspriteheight(a2)
	move.w	d1,cspritex2(a2)
	move.w	d3,cspritey2(a2)
	move.w	d1,cspritex(a2)
	move.w	d3,cspritey(a2)
	move.w	d6,cspriteyvel(a2)
	move.w	d4,cspritexvel(a2)
	addq.w	#8,d2
	add.w	d5,d1
	dbf	d0,strat2loop
	rts

strat1setup:
	move.w	#5,d0
	bsr	random
	tst.w	d0
	bpl	nointelli
	move.w	#200,d0
	bsr	randomplus
	add.w	#100,d0
	move.w	d0,d6
	bra	intelli
nointelli:
	move.w	#600,d6
intelli:
	bsr	dovarious	;returns with heigh/d7 num rel d0
	move.w	d0,released	;and add of sprite data in a1
	move.w	#0,deceased
	moveq	#10,d1
	sub.w	d0,d1
	asl.w	#3,d1
	lea	towera,a0
	add.w	d1,a0
	jmp	(a0)
towera:
	lea	enemy10,a0
	bsr.s	strat1rand
	lea	enemy9,a0
	bsr.s	strat1rand
	lea	enemy8,a0
	bsr.s	strat1rand
	lea	enemy7,a0
	bsr.s	strat1rand
	lea	enemy6,a0
	bsr.s	strat1rand
	lea	enemy5,a0
	bsr.s	strat1rand
	lea	enemy4,a0
	bsr.s	strat1rand
	lea	enemy3,a0
	bsr.s	strat1rand
	lea	enemy2,a0
	bsr.s	strat1rand
	lea	enemy1,a0
	bsr.s	strat1rand
	rts

strat1rand:
	move.l	a1,cspritead(a0)
	move.w	d7,cspriteheight(a0)
	move.w	#1,cactive(a0)
	move.w	#170,d0
	jsr	randomplus
	add.w	#320,d0
	move.w	d0,cspritex(a0)
	move.w	#100,d0
	jsr	randomplus
	add.w	#13,d0
	move.w	d0,cspritey(a0)
	move.w	#5,d0
	jsr	randomplus
	addq.w	#2,d0
	move.w	d0,cspritexvel(a0)
	move.w	#0,cspriteyvel(a0)
	move.w	d6,cattackcount(a0)
	rts

dovarious:
	lea	enemyadlist,a0
	lea	enemyheightlist,a2
	moveq	#7,d0
	jsr	randomplus
	move.w	d0,d1
	move.w	d1,d2
	asl.w	#2,d1
	add.w	d2,d2		;*2
	move.l	(a0,d1.w),a0
	move.w	(a2,d2.w),d7	;get height
	move.l	(a0),a1 	;sprite data add
	moveq	#10,d0
	jsr	randomplus
	addq.w	#1,d0
	rts

*************************************************
*	Routine to check any sprite against	*
*	any other sprite. give addresses in	*
*	a0,a1. Returns -1 in d0 for no coll	*
*	ision, or 1 in d0 for collision.	*
*************************************************
spritehit:
	tst.w	cactive(a0)
	bmi	nohit
	tst.w	cactive(a1)
	bmi	nohit
	move.w	cspritex(a0),d0
	move.w	cspritey(a0),d1
	move.w	cspritex(a1),d2
	move.w	cspritey(a1),d3
	move.w	cspriteheight(a0),d4
	move.w	cspriteheight(a1),d5
	add.w	d5,d3
	add.w	cspritewidth(a1),d2
	cmp.w	d0,d2
	blt	nohit
	cmp.w	d1,d3
	blt	nohit
	sub.w	cspritewidth(a1),d2
	sub.w	d5,d3
	add.w	d4,d1
	add.w	cspritewidth(a0),d0
	cmp.w	d0,d2
	bgt	nohit
	cmp.w	d1,d3
	bgt	nohit
	moveq	#1,d0
	move.l	a1,-(sp)
	lea	exploparasound,a1
	jsr	startsound
	move.l	(sp)+,a1
	rts
nohit:
	moveq	#-1,d0
	rts
*********************************************************
checkwep:
	lea	package,a0
	tst.w	cactive(a0)
	bmi	nocheckwep
	lea	shipsprite0,a1
	bsr	spritehit
	tst.w	d0
	bmi	nocheckwep
	lea	extrawepsound,a1
	jsr	startsound
	move.w	#-1,cactive(a0)
	cmpi.w	#0,whatwep(a0)
	bne	chw1
	move.w	#10,shotxvelp	;it was a shot speed up
	rts
chw1:
	cmpi.w	#1,whatwep(a0)
	bne	chw2
	move.w	#1,shootstate	;it was more shots
	rts
chw2:
	cmpi.w	#2,whatwep(a0)
	bne	chw3
	move.w	#2,shootstate	;it was 1st addon
	lea	addon1,a0
	move.w	#0,cactive(a0)
	rts
chw3:
	cmpi.w	#3,whatwep(a0)
	bne	chw4
	move.w	#2,shootstate	;it was second addon
	lea	addon1,a0
	move.w	#0,cactive(a0)
	lea	addon2,a0
	move.w	#44,cactive(a0)
	rts
chw4:
	cmpi.w	#4,whatwep(a0)
	bne	chw5
	move.w	#3,shootstate	;it was 1 laser
	lea	addon1,a0
	move.w	#-1,cactive(a0)
	lea	addon2,a0
	move.w	#-1,cactive(a0)
	lea	shotsprite1,a0
	move.w	#-1,cactive(a0)
	lea	shotsprite2,a0
	move.w	#-1,cactive(a0)
	lea	shotsprite3,a0
	move.w	#-1,cactive(a0)
	lea	shotsprite4,a0
	move.w	#-1,cactive(a0)
	rts
chw5:
	cmpi.w	#5,whatwep(a0)
	bne	chw6
	move.w	#3,shootstate	;it was 2 laser
	lea	addon1,a0
	move.w	#0,cactive(a0)
	lea	addon2,a0
	move.w	#-1,cactive(a0)
	rts

chw6:
	cmpi.w	#6,whatwep(a0)
	bne	nocheckwep
	move.w	#3,shootstate	;it was 2 laser
	lea	addon1,a0
	move.w	#0,cactive(a0)
	lea	addon2,a0
	move.w	#44,cactive(a0)
	rts

nocheckwep:
	rts

pweppack:
	subq.w	#1,wepdelay
	bpl	pwepback
	move.w	#400,wepdelay
	lea	package,a0
	cmpi.w	#6,whatwep(a0)
	blt	pwok
	move.w	#-1,cactive(a0)
	rts
pwok:
	move.w	#1,cactive(a0)
	move.w	#100,d0
	bsr	randomplus
	add.w	#13,d0
	move.w	d0,cspritey(a0)
	move.w	#319,cspritex(a0)
	addq.w	#1,whatwep(a0)
pwepback:
	lea	package,a0
	tst.w	cactive(a0)
	bmi	pwrb
	subq.w	#1,cspritex(a0)
	cmpi.w	#cxmin-16,cspritex(a0)
	bgt	drawwep
	subq.w	#1,whatwep(a0)		;reset if not collected
	move.w	#-1,cactive(a0)
	rts
drawwep:
	bsr	drawclipped
pwrb:
	rts
pmyship2:
	lea	shipsprite0,a0
	bra.s	pm4
*********************************************************
pmyship:
	lea	shipsprite0,a0
	move.w	cactive(a0),d0
	bmi	blowingup
	lea	shipsprite1,a0
	move.w	cactive(a0),d0
	bmi	blowingup

	lea	shipsprite0,a0
	move.w	xvel,d0
	add.w	d0,cspritex(a0)
	move.w	yvel,d0
	add.w	d0,cspritey(a0)

pm0:	cmpi.w	#cymin,cspritey(a0)
	bge	pm1
	move.w	#cymin,cspritey(a0)
	bra	pm2
pm1:	cmpi.w	#cymax-12,cspritey(a0)
	ble	pm2
	move.w	#cymax-12,cspritey(a0)
pm2:	cmpi.w	#cxmin,cspritex(a0)
	bge	pm3
	move.w	#cxmin,cspritex(a0)
	bra	pm4
pm3:	cmpi.w	#cxmax-32,cspritex(a0)
	ble	pm4
	move.w	#cxmax-32,cspritex(a0)
pm4:
	bsr	drawclipped
	lea	shipsprite0,a1
	lea	shipsprite1,a0
	move.w	cspritex(a1),cspritex(a0)
	add.w	#16,cspritex(a0)
	move.w	cspritey(a1),cspritey(a0)
	bsr	drawclipped
doaddons:
	lea	addon1,a0
	move.w	cactive(a0),d2
	bmi	noaddons
	lea	circcoords,a1
	lea	shipsprite1,a2
	move.w	cspritex(a2),d0
	move.w	cspritey(a2),d1
	addq.w	#3,d1		;adjust for centre
	subq.w	#7,d0
	add.w	d2,d2
	move.b	(a1,d2.w),d3
	move.b	1(a1,d2.w),d4
	ext.w	d3
	ext.w	d4
	add.w	d3,d0
	add.w	d4,d1
	move.w	d0,cspritex(a0)
	move.w	d1,cspritey(a0)
	addq.w	#2,cactive(a0)
	cmpi.w	#88,cactive(a0)
	ble	doaddon2
	move.w	#0,cactive(a0)
doaddon2:
	lea	addon2,a0
	move.w	cactive(a0),d2
	bmi	drawaddon1
	move.w	cspritex(a2),d0
	move.w	cspritey(a2),d1
	addq.w	#3,d1		;adjust for centre
	subq.w	#7,d0
	add.w	d2,d2
	move.b	(a1,d2.w),d3
	move.b	1(a1,d2.w),d4
	ext.w	d3
	ext.w	d4
	add.w	d3,d0
	add.w	d4,d1
	move.w	d0,cspritex(a0)
	move.w	d1,cspritey(a0)
	addq.w	#2,cactive(a0)
	cmpi.w	#88,cactive(a0)
	ble	drawaddon
	move.w	#0,cactive(a0)
drawaddon:
	bsr	drawclipped
drawaddon1:
	lea	addon1,a0
	bsr	drawclipped
noaddons:
	rts

blowingup2:
*	move.l	#bluepalette,whichpalette
	lea	dummyship,a1
	subq.w	#1,boom8delay
	bmi	endofplanet
	bra.w	bup
blowingup:
	tst.l	savepalette
	bmi	nopal
	move.l	#p2specpalette,whichpalette
nopal:
	addq.w	#1,cactive(a0)
	bpl	donewship
	move.l	a0,-(sp)

	move.w	#15,pixelcolor
	move.l	expstars,a0
	move.w	#30,d7
buploop:
	move.w	4(a0),d0	;get xvel
	add.w	d0,(a0) 	;add to x
	move.w	6(a0),d0
	add.w	d0,2(a0)	;likewise for y
	addq.w	#8,6(a0)	;gravity
	move.w	(a0),d0
	move.w	2(a0),d1
	asr.w	#3,d0
	asr.w	#3,d1
	cmpi.w	#cymax,d1
	blt	drawpix
	neg.w	6(a0)		;bounce
	add.w	#16,6(a0)
drawpix:
	move.w	d0,pixelx
	move.w	d1,pixely
	jsr	doubleplot
	addq.w	#1,pixely
	jsr	doubleplot
	addq.l	#8,a0
	dbf	d7,buploop

	move.l	(sp)+,a1
bup:
	lea	pexp1,a0
	tst.w	boomframe(a0)
	bpl	drawframe1
	moveq	#100,d0
	bsr	randomplus
	cmpi.w	#20,d0
	bgt	noexp1
	move.w	#13,boomframe(a0)
	moveq	#15,d0
	bsr	random
	add.w	cspritex(a1),d0
	move.w	d0,boomx(a0)
	moveq	#5,d0
	bsr	random
	add.w	cspritey(a1),d0
	move.w	d0,boomy(a0)
	moveq	#5,d0
	bsr	randomplus
	addq.w	#1,d0
	move.w	d0,boomexp(a0)
	move.l	a1,-(sp)
	lea	mehitsound,a1
	jsr	startsound
	move.l	(sp)+,a1
drawframe1:
	move.l	a1,-(sp)
	jsr	parra1expansion
	move.l	(sp)+,a1
noexp1:
	lea	pexp2,a0
	tst.w	boomframe(a0)
	bpl	drawframe2
	moveq	#100,d0
	bsr	randomplus
	cmpi.w	#20,d0
	bgt	noexp2

	move.w	#13,boomframe(a0)
	moveq	#15,d0
	bsr	random
	add.w	cspritex(a1),d0
	move.w	d0,boomx(a0)
	moveq	#5,d0
	bsr	random
	add.w	cspritey(a1),d0
	move.w	d0,boomy(a0)
	moveq	#5,d0
	bsr	randomplus
	addq.w	#1,d0
	move.w	d0,boomexp(a0)
drawframe2:
	move.l	a1,-(sp)
	jsr	parra1expansion
	move.l	(sp)+,a1
noexp2:
	lea	pexp3,a0
	tst.w	boomframe(a0)
	bpl	drawframe3
	moveq	#100,d0
	bsr	randomplus
	cmpi.w	#20,d0
	bgt	noexp3
	move.w	#13,boomframe(a0)
	moveq	#15,d0
	bsr	random
	add.w	cspritex(a1),d0
	move.w	d0,boomx(a0)
	moveq	#5,d0
	bsr	random
	add.w	cspritey(a1),d0
	move.w	d0,boomy(a0)
	moveq	#5,d0
	bsr	randomplus
	addq.w	#1,d0
	move.w	d0,boomexp(a0)
drawframe3:
	jsr	parra1expansion
noexp3:
	rts
donewship:
	tst.l	savepalette
	bmi	palok
	move.l	savepalette,whichpalette
palok:
	move.w	deceased,d0
	cmp.w	released,d0
	bne	nonews
	bsr	resetsprites
	subq.w	#1,shipenergy
	bmi.s	endofplanet
*	bsr	resetsprites
	rts
nonews:
	lea	shipsprite0,a0
	move.w	#-1,cactive(a0)
	rts

endofplanet:
	addq.l	#4,sp
	jsr	cleartext
	jsr	flip_scr2
	jsr	flip_scr2
	jsr	interference
	lea	deadremotemsg,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	move.l	#1000000,d7
	jsr	generaldelay
	tst.w	loadflag
	bmi	straightback
	move.l	#planetfile,filename
	move.l	generalstore,wheretoload
	move.l	#80752,lengthtoread
	bsr	loadfile
	move.l	#fileshipcomp,filename
	jsr	loadscr
	jsr	copyintoboth
straightback:
	move.l	#bluepalette,whichpalette
	jmp	shipscomputer
*********************************************************
pshoot:
	tst.w	changestate
	bpl	pmoveshots
	tst.w	buttondat
	beq	pmoveshots
	lea	shipsprite0,a0
	tst.w	cactive(a0)
	bmi	pmoveshots
	lea	shipsprite1,a0
	tst.w	cactive(a0)
	bmi	pmoveshots
	cmpi.w	#1,shootstate
	bgt	isaddons
normalshoot:
	lea	shipsprite1,a1
	lea	shotsprite1,a0
	tst.w	cactive(a0)
	bpl	nextps1
	move.l	a1,-(sp)
	lea	meshoot2sound,a1
	jsr	startsound
	move.l	(sp)+,a1
	move.w	#1,cactive(a0)
	move.w	cspritex(a1),cspritex(a0)
	move.w	cspritey(a1),cspritey(a0)
	bra	pmoveshots
nextps1:
	lea	shotsprite2,a0
	tst.w	cactive(a0)
	bpl	nextps2
	move.l	a1,-(sp)
	lea	meshoot2sound,a1
	jsr	startsound
	move.l	(sp)+,a1
	move.w	#1,cactive(a0)
	move.w	cspritex(a1),cspritex(a0)
	move.w	cspritey(a1),cspritey(a0)
	bra	pmoveshots
nextps2:
	cmpi.w	#1,shootstate
	bne	pmoveshots
	lea	shotsprite3,a0
	tst.w	cactive(a0)
	bpl	nextps3
	move.l	a1,-(sp)
	lea	meshoot2sound,a1
	jsr	startsound
	move.l	(sp)+,a1
	move.w	#1,cactive(a0)
	move.w	cspritex(a1),cspritex(a0)
	move.w	cspritey(a1),cspritey(a0)
	bra	pmoveshots
nextps3:
	lea	shotsprite4,a0
	tst.w	cactive(a0)
	bpl	pmoveshots
	move.l	a1,-(sp)
	lea	meshoot2sound,a1
	jsr	startsound
	move.l	(sp)+,a1
	move.w	#1,cactive(a0)
	move.w	cspritex(a1),cspritex(a0)
	move.w	cspritey(a1),cspritey(a0)
	bra	pmoveshots
isaddons:
	cmpi.w	#2,shootstate
	bne	islaser
	lea	shipsprite1,a1
	lea	shotsprite1,a0
	tst.w	cactive(a0)
	bpl	nextps1a
	move.l	a1,-(sp)
	lea	meshoot2sound,a1
	jsr	startsound
	move.l	(sp)+,a1
	move.w	#1,cactive(a0)
	move.w	cspritex(a1),cspritex(a0)
	move.w	cspritey(a1),cspritey(a0)
	bra	pmoveshots
nextps1a:
	lea	shotsprite2,a0
	tst.w	cactive(a0)
	bpl	nextps2a
	move.l	a1,-(sp)
	lea	meshoot2sound,a1
	jsr	startsound
	move.l	(sp)+,a1
	move.w	#1,cactive(a0)
	move.w	cspritex(a1),cspritex(a0)
	move.w	cspritey(a1),cspritey(a0)
	bra	pmoveshots
nextps2a:
	lea	addon1,a1
	lea	shotsprite3,a0
	tst.w	cactive(a0)
	bpl	nextps3a
	move.l	a1,-(sp)
	lea	meshoot2sound,a1
	jsr	startsound
	move.l	(sp)+,a1
	move.w	#1,cactive(a0)
	move.w	cspritex(a1),cspritex(a0)
	move.w	cspritey(a1),cspritey(a0)
	bra	pmoveshots
nextps3a:
	lea	addon2,a1
	tst.w	cactive(a1)
	bpl	isad
	lea	addon1,a1
isad:	lea	shotsprite4,a0
	tst.w	cactive(a0)
	bpl	pmoveshots
	move.l	a1,-(sp)
	lea	meshoot2sound,a1
	jsr	startsound
	move.l	(sp)+,a1
	move.w	#1,cactive(a0)
	move.w	cspritex(a1),cspritex(a0)
	move.w	cspritey(a1),cspritey(a0)
	bra	pmoveshots
	
islaser:
	cmpi.w	#3,shootstate
	bne	islaser2
	move.l	a1,-(sp)
	lea	laser1sound,a1
	jsr	startsound
	lea	laser2sound,a1
	jsr	startsound
	move.l	(sp)+,a1

	lea	laser1,a0
	move.w	#20,laserlife(a0)
	lea	addon1,a1
	tst.w	cactive(a1)
	bmi	drawlasers
	lea	laser2,a0
	move.w	#20,laserlife(a0)

	lea	addon2,a1
	tst.w	cactive(a1)
	bmi	drawlasers
	lea	laser3,a0
	move.w	#20,laserlife(a0)
	bra	drawlasers

islaser2:
	cmpi.w	#4,shootstate
	bne	issomethingelse
issomethingelse:
	rts

pmoveshots:
	cmpi.w	#3,shootstate
	beq	drawlasers
	lea	shotsprite1,a0
	bsr	pshotmath
	lea	shotsprite2,a0
	bsr	pshotmath
	lea	shotsprite3,a0
	bsr	pshotmath
	lea	shotsprite4,a0
	bsr	pshotmath
	rts
pshotmath:
	tst.w	cactive(a0)
	bmi	psmb
	move.w	shotxvelp,d0
	add.w	d0,cspritex(a0)
	cmpi.w	#cxmax,cspritex(a0)
	blt	pshotdraw
	move.w	#-1,cactive(a0)
	rts
pshotdraw:
	bsr	drawclipped
psmb:	rts

drawlasers:
	lea	laser1,a0
	lea	shipsprite1,a1
	bsr	dolaser
	lea	laser2,a0
	lea	addon1,a1
	bsr	dolaser
	lea	laser3,a0
	lea	addon2,a1
	bsr	dolaser
	rts


dolaser:
	subq.w	#1,laserlife(a0)
	bmi	laserfin
	move.w	cspritex(a1),d0
	move.w	cspritey(a1),d1
	addq.w	#3,d1
	add.w	#16,d0
	cmpi.w	#cymin,d1
	bgt	dlt1
	move.w	d1,lasery(a0)
	move.w	d0,laserx(a0)
	bra	nolaser
dlt1:
	cmpi.w	#cymax,d1
	blt	dlt2
	move.w	d1,lasery(a0)
	move.w	d0,laserx(a0)
	bra	nolaser
dlt2:
	cmpi.w	#cxmin,d0
	bgt	dlt3
	move.w	#cxmin,d0
dlt3:
	move.w	d1,lasery(a0)
	move.w	d0,laserx(a0)
	lsl.w	#2,d1	       ;mult by 4 for index
	lsr.w	#1,d0		  ;x coord / 2
	and.w	#$00f8,d0      ;strip lower 3 bits
	move.w	d0,a2	     ;move x offset to A0
	move.l	ytable,a3   ;get y table addr
	adda.l	(a3,d1.w),a2 ;got final pixel addr!
	move.l	(a3,d1.w),a3
	adda.l	#152,a3
	move.l	a2,a6
	suba.l	a2,a3
	move.w	a3,d0
	asr.w	#3,d0			;div by 8
	bmi	nolaser
*	subq.w	#1,d0
	moveq	#18,d2
	sub.w	d0,d2
	asl.w	#4,d2
	moveq	#-1,d1		;mask
	lea	drawlaser,a0
	add.w	d2,a0
	jmp	(a0)
drawlaser:
	rept	18
	move.l	d1,(a6) 	;mask out 3 lines worth
	move.l	d1,4(a6)
	move.l	d1,160(a6)
	move.l	d1,164(a6)
	addq.l	#8,a6
	endr
nolaser:
	rts
laserfin:
	move.w	#-1,laserlife(a0)
	rts

*********************************************************
*	setup sprites for cliped routine		*
*********************************************************
setupclippedsprite:
	move.l	generalstore,wheretoload
	add.l	#90000+3360,wheretoload 	;don't tromp on planetd8a
	move.l	#37120,lengthtoread
	jsr	loadfile
	lea	shipsprite0,a0
	move.l	wheretoload,cspritead(a0)	;put right address in
	add.l	#(5120*3),cspritead(a0)
	lea	shipsprite1,a0
	move.l	wheretoload,cspritead(a0)	;put right address in
	add.l	#(5120*3)+2560,cspritead(a0)
	lea	shotsprite1,a0
	move.l	wheretoload,cspritead(a0)	;put right address in
	add.l	#(5120*3)+(2560*8),cspritead(a0)
	lea	shotsprite2,a0
	move.l	wheretoload,cspritead(a0)	;put right address in
	add.l	#(5120*3)+(2560*8),cspritead(a0)
	lea	shotsprite3,a0
	move.l	wheretoload,cspritead(a0)	;put right address in
	add.l	#(5120*3)+(2560*8),cspritead(a0)
	lea	shotsprite4,a0
	move.l	wheretoload,cspritead(a0)	;put right address in
	add.l	#(5120*3)+(2560*8),cspritead(a0)
	lea	addon1,a0
	move.l	wheretoload,cspritead(a0)	;put right address in
	add.l	#(5120*3)+(2*2560),cspritead(a0)
	lea	addon2,a0
	move.l	wheretoload,cspritead(a0)	;put right address in
	add.l	#(5120*3)+(2560*2),cspritead(a0)
	lea	package,a0
	move.l	wheretoload,cspritead(a0)	;put right address in
	add.l	#(5120*3)+(2560*4),cspritead(a0)

	move.l	wheretoload,enemyad1		;put right address in
	add.l	#(5120*3)+(2560*3),enemyad1
	move.l	wheretoload,enemyad2		;put right address in
	add.l	#(5120*3)+(2560*5),enemyad2
	move.l	wheretoload,enemyad3		;put right address in
	add.l	#(5120*3)+(2560*6),enemyad3
	move.l	wheretoload,enemyad4		;put right address in
	add.l	#(5120*3)+(2560*7),enemyad4
	move.l	wheretoload,enemyad5		;put right address in
	move.l	wheretoload,enemyad6		;put right address in
	add.l	#(5120),enemyad6
	move.l	wheretoload,enemyad7		;put right address in
	add.l	#(5120*2),enemyad7
	rts

*********************************************************
*	setup sprites for cliped routine		*
*********************************************************
setupclippedsprite2:
	move.l	generalstore,wheretoload
	add.l	#40000,wheretoload 	;don't tromp on planetd8a
	move.l	#37120,lengthtoread
	jsr	loadfile
	lea	shotsprite1,a0
	move.l	wheretoload,cspritead(a0)	;put right address in
	add.l	#17920*2,cspritead(a0)
	lea	shotsprite2,a0
	move.l	wheretoload,cspritead(a0)	;put right address in
	add.l	#17920*2,cspritead(a0)
	lea	shotsprite3,a0
	move.l	wheretoload,cspritead(a0)	;put right address in
	add.l	#17920*2,cspritead(a0)
	lea	shotsprite4,a0
	move.l	wheretoload,cspritead(a0)	;put right address in
	add.l	#17920*2,cspritead(a0)
	lea	package2,a0
	move.l	wheretoload,cspritead(a0)	;put right address in

	move.l	wheretoload,enemyad1		;put right address in
	add.l	#(5*2560*2),enemyad1
	move.l	wheretoload,enemyad2		;put right address in
	add.l	#(6*2560*2),enemyad2

	lea	obj1sp,a0
	move.l	wheretoload,cspritead(a0)	;put right address in
	add.l	#1*5120,cspritead(a0)
	lea	obj2sp,a0
	move.l	wheretoload,cspritead(a0)	;put right address in
	add.l	#2*5120,cspritead(a0)
	lea	obj3sp,a0
	move.l	wheretoload,cspritead(a0)	;put right address in
	add.l	#3*5120,cspritead(a0)
	lea	obj4sp,a0
	move.l	wheretoload,cspritead(a0)	;put right address in
	add.l	#4*5120,cspritead(a0)
	rts
*********************************************************
*	draw prerotated and clippped sprite		*
*	pass address of sprite header in a0		*
*********************************************************
drawclipped:
	cmpi.w	#0,cspritex(a0)
	ble	nosprite
	cmpi.w	#cxmax,cspritex(a0)
	bgt	nosprite
	move.w	cspritex(a0),d2 	;get x
	move.w	d2,d0
	move.w	d0,d4
	move.w	cspritey(a0),d1 ;get y
	move.w	d1,d5
	and.w	#15,d2		;get last 4 bits=offset
	move.w	d2,d3		;get a copy of last 4 bits

	move	cspriteheight(a0),d7		;counter before clipping
	move.w	#cymin,d6	;is it above cymin
	cmp.w	d6,d5
	bge	spcl1
	sub.w	d5,d6		;gives number of lines missing
	sub.w	d6,d7		;for counter
	mulu	#20,d6		;for add to sprite data address
	move.l	hiden,a6
	lea	cymin*160(a6),a6
	bra	spcl2
spcl1:
	moveq	#0,d6
	move.l	hiden,a6
	lsl.w	#5,d1		;*128
	add.w	d1,a6
	lsl.w	#2,d1
	add.w	d1,a6		;=*160 gives line add
spcl2:
	and.w	#$fff0,d0	;word
	lsr.w	#1,d0
	add.w	d0,a6		;a6 has actual screen address

	move.w	#cymax,d1
	sub.w	cspriteheight(a0),d1
	cmp.w	d1,d5
	ble	spcl3
	sub.w	d1,d5
	sub.w	d5,d7

spcl3:
	cmpi.w	#4,cspriteheight(a0)
	bne	spcl4
	move.l	cspritead(a0),a1
	lsl.w	#4,d3		;*16
	add.w	d3,a1		;a1 has ad of final sprite data
	lsl.w	#2,d3
	add.w	d3,a1
	add.w	d6,a1		;adjust for top yclip
	bra	extrastuff
spcl4:
	cmpi.w	#8,cspriteheight(a0)
	bne	spcl5
	move.l	cspritead(a0),a1
	lsl.w	#5,d3		;*16
	add.w	d3,a1		;a1 has ad of final sprite data
	lsl.w	#2,d3
	add.w	d3,a1
	add.w	d6,a1		;adjust for top yclip
	bra	extrastuff

spcl5:
	move.l	cspritead(a0),a1
	lsl.w	#6,d3		;*128
	add.w	d3,a1		;a1 has ad of final sprite data
	lsl.w	#2,d3
	add.w	d3,a1
	add.w	d6,a1		;adjust for top yclip

extrastuff:
	cmpi.w	#cxmin,d4
	bge	spcl6
	bra	clipleftsprite
spcl6:
	cmpi.w	#cxmax-16,d4
	ble	doallsprite
*	fall through

cliprightsprite:
	subq.w	#1,d7
	bmi	nosprite
crightloop:
	move.w	(a6),d0 	;get 4 screen words
	move.w	2(a6),d1
	move.w	4(a6),d2
	move.w	6(a6),d3
	and.w	(a1),d0 	;mask word
	and.w	(a1),d1 	;mask word
	and.w	(a1),d2 	;mask word
	and.w	(a1)+,d3	;mask word
	or.w	(a1)+,d0	;or the sprite image in the hole
	or.w	(a1)+,d1	;we just cut
	or.w	(a1)+,d2
	or.w	(a1)+,d3
	move.w	d0,(a6)+	;put the picture in th picture
	move.w	d1,(a6)+
	move.w	d2,(a6)+
	move.w	d3,(a6)+

*	 add.l	 #10,a1
	lea	10(a1),a1
*	 add.l	 #144+8,a6		 ;move to next screen line
	lea	144+8(a6),a6
	dbf	d7,crightloop
	rts

clipleftsprite:
	subq.w	#1,d7
	bmi	nosprite
cleftloop:
*	 add.l	 #10,a1
	lea	10(a1),a1
*	 addq.l  #8,a6
	lea	8(a6),a6
	move.w	(a6),d0 	;get 4 screen words
	move.w	2(a6),d1
	move.w	4(a6),d2
	move.w	6(a6),d3
	and.w	(a1),d0 	;mask word
	and.w	(a1),d1 	;mask word
	and.w	(a1),d2 	;mask word
	and.w	(a1)+,d3	;mask word
	or.w	(a1)+,d0	;or the sprite image in the hole
	or.w	(a1)+,d1	;we just cut
	or.w	(a1)+,d2
	or.w	(a1)+,d3
	move.w	d0,(a6)+	;put the picture in th picture
	move.w	d1,(a6)+
	move.w	d2,(a6)+
	move.w	d3,(a6)+
*	 add.l	 #144,a6	 ;move to next screen line
	lea	144(a6),a6
	dbf	d7,cleftloop
nosprite:
	rts
doallsprite:
	subq.w	#1,d7
	bmi	nosprite
doallloop:
	move.w	(a6),d0 	;get 4 screen words
	move.w	2(a6),d1
	move.w	4(a6),d2
	move.w	6(a6),d3
	and.w	(a1),d0 	;mask word
	and.w	(a1),d1 	;mask word
	and.w	(a1),d2 	;mask word
	and.w	(a1)+,d3	;mask word
	or.w	(a1)+,d0	;or the sprite image in the hole
	or.w	(a1)+,d1	;we just cut
	or.w	(a1)+,d2
	or.w	(a1)+,d3
	move.w	d0,(a6)+	;put the picture in th picture
	move.w	d1,(a6)+
	move.w	d2,(a6)+
	move.w	d3,(a6)+

	move.w	(a6),d0 	;get 4 screen words
	move.w	2(a6),d1
	move.w	4(a6),d2
	move.w	6(a6),d3
	and.w	(a1),d0 	;mask word
	and.w	(a1),d1 	;mask word
	and.w	(a1),d2 	;mask word
	and.w	(a1)+,d3	;mask word
	or.w	(a1)+,d0	;or the sprite image in the hole
	or.w	(a1)+,d1	;we just cut
	or.w	(a1)+,d2
	or.w	(a1)+,d3
	move.w	d0,(a6)+	;put the picture in th picture
	move.w	d1,(a6)+
	move.w	d2,(a6)+
	move.w	d3,(a6)+
	lea	144(a6),a6
	dbf	d7,doallloop
	rts
************************************************
rotateback:
	move.l	generalstore,a6
	add.l	#4000,a6
	move.l	a6,scrollwhere
	moveq	#15,d7		;up down counter
	lea	compscreenmem,a0
	move.l	a0,a1
	add.l	#128*2,a1
rtbloop1:
	moveq	#0,d6		;left right counter
rtbloop2:
	moveq	#15,d4
	move.l	a0,a2		;copy top
	move.l	a1,a3		;copy bot
	move.w	d6,d5
	lsr.w	#1,d5		;halve the rotation
rtbloop3:
	move.w	(a2),d0		;first make mask from top
	or.w	2(a2),d0
	or.w	4(a2),d0
	or.w	6(a2),d0
	eor.w	#-1,d0		;invertit
	ror.w	d6,d0		;rotate mask

	move.w	(a3)+,d1
	ror.w	d5,d1		;rotate backgr
	and.w	d0,d1		;cut hole
	move.w	(a2)+,d2	;get top
	ror.w	d6,d2		;rotate it
	or.w	d2,d1		;put it in the hole
	move.w	d1,(a6)+

	move.w	(a3)+,d1
	ror.w	d5,d1		;rotate backgr
	and.w	d0,d1		;cut hole
	move.w	(a2)+,d2
	ror.w	d6,d2
	or.w	d2,d1
	move.w	d1,(a6)+

	move.w	(a3)+,d1
	ror.w	d5,d1		;rotate backgr
	and.w	d0,d1		;cut hole
	move.w	(a2)+,d2
	ror.w	d6,d2
	or.w	d2,d1
	move.w	d1,(a6)+

	move.w	(a3)+,d1
	ror.w	d5,d1		;rotate backgr
	and.w	d0,d1		;cut hole
	move.w	(a2)+,d2
	ror.w	d6,d2
	or.w	d2,d1
	move.w	d1,(a6)+
	addq.l	#8,a3

	dbf	d4,rtbloop3
	addq.w	#1,d6
	cmpi.w	#16,d6
	blt	rtbloop2
	addq.l	#8,a0		;scroll down 1 line
	addq.l	#8,a1
	dbf	d7,rtbloop1
	rts
***************************
bound82:
	cmpi.w	#2000,d0
	blt.s	b81b
	sub.w	#4000,d0
	bra.s	b82b
b81b:
	cmpi.w	#-2000,d0
	bgt.s	b82b
	add.w	#4000,d0
b82b:
	cmpi.w	#1700,d1
	blt.s	b83b
	sub.w	#3400,d1
	bra.s	b84b
b83b:
	cmpi.w	#-1700,d1
	bgt.s	b84b
	add.w	#3400,d1
b84b:
	rts

bound8:
	cmpi.w	#2000,d0
	blt.s	b81
	move.w	#-2000,d0
	bra.s	b82
b81:
	cmpi.w	#-2000,d0
	bgt.s	b82
	move.w	#2000,d0
b82:
	cmpi.w	#1700,d1
	blt.s	b83
	move.w	#-1700,d1
	bra.s	b84
b83:
	cmpi.w	#-1700,d1
	bgt.s	b84
	move.w	#1700,d1
b84:
	rts

***************************
scroll8way:
	move.w	xvel,d0
	move.w	yvel,d1
	cmpi.w	#maxinertia,d0
	blt	s81
	move.w	#maxinertia,xvel
s81:
	cmpi.w	#-maxinertia,d0
	bgt	s82
	move.w	#-maxinertia,xvel
s82:
	asr.w	#3,d0
	ext.w	d0
	cmpi.w	#maxinertia,d1
	blt	s83
	move.w	#maxinertia,yvel
s83:
	cmpi.w	#-maxinertia,d1
	bgt	s84
	move.w	#-maxinertia,yvel
s84:
	asr.w	#3,d1
	ext.w	d1
	add.w	d0,scrollx
	add.w	d1,scrolly
	tst.w	channel2params+channelprocess
	bmi	sksh
	moveq	#4,d0
	jsr	random
	add.w	d0,scrollx
	moveq	#4,d0
	jsr	random
	add.w	d0,scrolly
sksh:
	moveq	#0,d0
	moveq	#0,d1
	move.w	scrollx,d0
	move.w	scrolly,d1
	bsr	bound8
	move.w	d0,scrollx
	move.w	d1,scrolly
	neg.w	d0
	move.w	d0,scrollx2
	move.w	d1,scrolly2
	add.w	#159,scrollx2
	add.w	#68,scrolly2
	neg.w	d1
	move.l	scrollwhere,a0
	moveq	#11,d7
	and.w	#15,d0
	and.w	#15,d1
	asl.l	d7,d1		;get the y amount to add
	asl.l	#7,d0		;and the x amount
	add.l	d1,a0		;should be ad of shifted s data
	add.l	d0,a0
put8way:
	move.l	hiden,a6
	move.l	a6,a1
	lea	2088(a6),a6
	moveq	#6,d7			;number of rows
p8loop1:
	move.l	a0,a2
	moveq	#15,d6
p8loop2:
	move.l	(a2),(a6)+
	move.l	4(a2),(a6)+		;four words
	move.l	(a2),(a6)+
	move.l	4(a2),(a6)+		;four words
	move.l	(a2),(a6)+
	move.l	4(a2),(a6)+		;four words
	move.l	(a2),(a6)+
	move.l	4(a2),(a6)+		;four words
	move.l	(a2),(a6)+
	move.l	4(a2),(a6)+		;four words
	move.l	(a2),(a6)+
	move.l	4(a2),(a6)+		;four words
	move.l	(a2),(a6)+
	move.l	4(a2),(a6)+		;four words
	move.l	(a2),(a6)+
	move.l	4(a2),(a6)+		;four words
	move.l	(a2),(a6)+
	move.l	4(a2),(a6)+		;four words

	move.l	(a2),(a6)+
	move.l	4(a2),(a6)+		;four words
	move.l	(a2),(a6)+
	move.l	4(a2),(a6)+		;four words
	move.l	(a2),(a6)+
	move.l	4(a2),(a6)+		;four words
	move.l	(a2),(a6)+
	move.l	4(a2),(a6)+		;four words
	move.l	(a2),(a6)+
	move.l	4(a2),(a6)+		;four words
	move.l	(a2),(a6)+
	move.l	4(a2),(a6)+		;four words
	move.l	(a2),(a6)+
	move.l	4(a2),(a6)+		;four words
	move.l	(a2),(a6)+
	move.l	4(a2),(a6)+		;four words
	move.l	(a2)+,(a6)+
	move.l	(a2)+,(a6)+		;four words
	lea	16(a6),a6
	dbf	d6,p8loop2	
	dbf	d7,p8loop1
	rts

************************************************
parralaxscroll:
	sub.w	#8,scrollamount
	sub.w	#7,scrollamount2
	sub.w	#6,scrollamount3
	sub.w	#5,scrollamount4
	sub.w	#4,scrollamount5

	move.l	scrolltated1,a0
	move.w	scrollamount,d0
	asr.w	#2,d0
	and.w	#15,d0
*	asl.w	#7,d0			;*64
	mulu	#88,d0
	add.w	d0,a0			;should be ad of shifted s data
	moveq	#10,d0			;number of lines to out
	move.l	#2088,d1		;y ad to add=107
	bsr	putscroll

	move.l	scrolltated2,a0
	move.w	scrollamount2,d0
	asr.w	#2,d0
	and.w	#15,d0
	asl.w	#4,d0			;*64
	add.w	d0,a0			;should be ad of shifted s data
*	asl.w	#1,d0
	add.w	d0,d0
	add.w	d0,a0
	moveq	#5,d0			;number of lines to out
	move.l	#3848,d1		;y ad to add=97
	bsr	putscroll

	move.l	scrolltated3,a0
	move.w	scrollamount3,d0
	asr.w	#2,d0
	and.w	#15,d0
	asl.w	#3,d0			;*64
	add.w	d0,a0			;should be ad of shifted s data
*	asl.w	#1,d0
	add.w	d0,d0
	add.w	d0,a0
	moveq	#2,d0			;number of lines to out
	move.l	#4808,d1		;y ad to add
	bsr	putscroll

	move.l	scrolltated4,a0
	move.w	scrollamount4,d0
	asr.w	#2,d0
	and.w	#15,d0
	asl.w	#4,d0			;*64
	add.w	d0,a0			;should be ad of shifted s data
	moveq	#1,d0			;number of lines to out
	move.l	#5288,d1		;y ad to add
	bsr	putscroll

	move.l	scrolltated5,a0
	move.w	scrollamount5,d0
	asr.w	#2,d0
	and.w	#15,d0
*	asl.w	#7,d0			;*64
	mulu	#280,d0
	add.w	d0,a0			;should be ad of shifted s data
	moveq	#34,d0			;number of lines to out
	move.l	#5608,d1		;y ad to add
	bsr	putscroll


copytoptobot:
	move.l	hiden,a0
*	adda.l	#11048,a0	;start of area to copy from
	lea	11048(a0),a0
	move.l	a0,a1
*	adda.l	#160,a1 	;next line down 
	lea	160(a1),a1
	moveq	#54,d0
	move.l	a0,a2
cbtloop:
	rept	36
	move.l	(a0)+,(a1)+
	endr
	lea	16(a1),a1
	lea	-304(a0),a0
	dbf	d0,cbtloop
	rts
*****************************************
*	has in a0 ad of data		*
*	in d0 number of lines to output *
*	in d1	screen y		*
*****************************************
putscroll:
	move.l	hiden,a1
	add.l	d1,a1
	move.l	a1,a2
psloop:
	move.l	(a0),(a2)+
	move.l	4(a0),(a2)+
	move.l	(a0),(a2)+
	move.l	4(a0),(a2)+
	move.l	(a0),(a2)+
	move.l	4(a0),(a2)+
	move.l	(a0),(a2)+
	move.l	4(a0),(a2)+
	move.l	(a0),(a2)+
	move.l	4(a0),(a2)+
	move.l	(a0),(a2)+
	move.l	4(a0),(a2)+
	move.l	(a0),(a2)+
	move.l	4(a0),(a2)+
	move.l	(a0),(a2)+
	move.l	4(a0),(a2)+
	move.l	(a0),(a2)+
	move.l	4(a0),(a2)+

	move.l	(a0),(a2)+
	move.l	4(a0),(a2)+
	move.l	(a0),(a2)+
	move.l	4(a0),(a2)+
	move.l	(a0),(a2)+
	move.l	4(a0),(a2)+
	move.l	(a0),(a2)+
	move.l	4(a0),(a2)+
	move.l	(a0),(a2)+
	move.l	4(a0),(a2)+
	move.l	(a0),(a2)+
	move.l	4(a0),(a2)+
	move.l	(a0),(a2)+
	move.l	4(a0),(a2)+
	move.l	(a0),(a2)+
	move.l	4(a0),(a2)+
	move.l	(a0)+,(a2)+
	move.l	(a0)+,(a2)+
*	addi.l	#16,a2		;jump down to next line
	lea	16(a2),a2
	dbf	d0,psloop
	rts

*****************************************
*	text output routine for ship	*
*	computer .pass cursor x,y	*
*	and ad of text string in a0	*
*****************************************
text:
	movem.l d0-d7/a0-a6,-(sp)
	move.w	cursorx,d4
	move.w	d4,d5
*	lsl.w	#1,d4		;*6
	add.w	d4,d4
	lsl.w	#2,d5
	add.w	d5,d4
*	mulu	#6,d4

	move.w	cursory,d5
	mulu	#7,d5
	lea	font,a5
	move.w	d4,d2
	move.w	d2,d0
	move.w	d5,d1		;get y
	and.w	#15,d2		;get last 4 bits=offset
	lea	compscreenmem,a6
	move.w	d1,d3
	lsl.w	#5,d3
	lsl.w	#2,d1
	add.w	d3,d1

*	mulu	#36,d1		;*36
	add.w	d1,a6		;=*160 gives line add
	and.w	#$fff0,d0	;word
	asr.w	#3,d0
	add.w	d0,a6		;a6 has actual screen address
	moveq	#0,d1
	move.b	char,d1
tspec1: cmpi.b	#' ',d1
	bne	tls
	lea	blank,a4
	bra	itb
tls:	subi.w	#46,d1		;for offsett
	mulu	#12,d1		;*12 for offsett into table
	move.l	a5,a4
	add.w	d1,a4		;actual ad of character
itb:	moveq	#5,d0
	move.l	a6,a1
textloop2:
	moveq	#0,d1
	moveq	#0,d3
	move.l	#%11111111111111110000011111111111,d3
	move.w	(a4)+,d1
	ror.l	d2,d1
	ror.l	d2,d3
	and.w	d3,(a1)
	or.w	d1,(a1)
	swap	d1
	swap	d3
	and.w	d3,2(a1)
	or.w	d1,2(a1)
*	 add.l	 #36,a1 	 ;move to next line
	lea	36(a1),a1
	dbf	d0,textloop2
endtext:
	movem.l (sp)+,d0-d7/a0-a6
	rts
******************************************
setuphbl:
	move.w	#$2700,sr
	move.l	#hbllist,hblsave
	move.b	ieb,oldieb
	move.b	iea,oldiea
	move.b	ima,oldima
	move.l	key_vec,oldkeyvec
	move.l	key_vec,keyt+2
	move.l	#key_handler,key_vec		;put new key stuff in
	move.l	hbl_vec,oldhblvec

	move.b	#%01000000,ieb
	and.b	#$fe,iea	;stop hblank
	move.l	hbl_vec,oldhblvec
	move.l	#hblhandler1,hbl_vec
	move.b	#%00000001,iea
	or.b	#1,ima

	move.l	vbl_vec,oldvblvec
	move.l	#vbl_handler,vbl_vec
	move.b	#0,tbcr
	move.b	#5,tbdr
	move.b	#8,tbcr
	move.w	#$2300,sr
	rts

hblhandler1:
	movem.l d0/a0,-(sp)
	move.l	hblsave,a0
	move.w	(a0)+,d0
	bmi	endlist
	move.w	d0,$ff8240
	move.b	#0,tbcr
	move.w	(a0)+,d0
	move.l	a0,hblsave
	move.b	d0,tbdr
	move.b	#8,tbcr
	bclr	#0,isra
	movem.l (sp)+,d0/a0
	rte
endlist:
	movem.l a0/a1,-(sp)
	move.l	#$ff8240,a0
	lea	palette2,a1
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	movem.l (sp)+,a0/a1
	move.b	#0,tbcr
	move.w	(a0)+,d0
	move.l	a0,hblsave
	move.b	d0,tbdr
	move.b	#8,tbcr
	bclr	#0,isra
	movem.l (sp)+,d0/a0
	rte
vbl_handler:
	move.l	#hbllist,hblsave
	move.b	#0,tbcr
	move.b	#5,tbdr
	move.b	#8,tbcr
vblt:
	movem.l d0-d7/a0-a6,-(sp)
	bsr	framevbl
	movem.l (sp)+,d0-d7/a0-a6
	rte

key_handler:
	move.w	#$2500,sr
keyt:	jmp	$0

restoremfp:
	move.b	oldieb,ieb
	move.b	oldiea,iea
	move.b	oldima,ima
	move.l	oldkeyvec,key_vec
	move.l	oldhblvec,hbl_vec
	move.l	oldvblvec,vbl_vec
	rts
**********************************************************
analyser:
	move.w	#0,xvel
	move.w	#0,yvel
	bsr	cleartext
	cmpi.w	#0,evidence
	bgt	evi2
	lea	starcubeob,a0
	move.w	#50,numdots(a0)
	move.l	obvert(a0),a0
	move.w	#50,(a0)
	jsr	starcube
	lea	evitext1,a0
	bsr	printmany
	bsr	flip_scr2
	bsr	flip_scr2
	lea	starcubeob,a0
	move.w	#0,obx(a0)
	move.w	#0,oby(a0)
	move.w	#900,obz(a0)
	move.l	obviewpb(a0),a0
	move.w	#0,theta(a0)
	move.w	#0,phi(a0)
	move.w	#0,rho(a0)
	lea	starcubeob2,a0
	move.w	#0,obx(a0)
	move.w	#0,oby(a0)
	move.w	#900,obz(a0)
	move.l	obviewpb(a0),a0
	move.w	#0,theta(a0)
	move.w	#0,phi(a0)
	move.w	#0,rho(a0)
	lea	square,a0
	move.w	#0,obx(a0)
	move.w	#0,oby(a0)
	move.w	#900,obz(a0)
	move.l	obviewpb(a0),a0
	move.w	#0,theta(a0)
	move.w	#0,phi(a0)
	move.w	#0,rho(a0)
eviloop1:
	move.w	#0,myviewx
	move.w	#25,myviewy
	bsr	domyview
	bsr	doworld
	lea	starcubeob,a0
	move.l	a0,whichob
	move.l	obviewpb(a0),a0
	addq.w	#1,theta(a0)
	addq.w	#2,phi(a0)
	addq.w	#2,rho(a0)
	bsr	dobefore
	lea	starcubeob2,a0
	move.l	a0,whichob
	move.l	obviewpb(a0),a0
	addq.w	#1,theta(a0)
	addq.w	#2,phi(a0)
	addq.w	#2,rho(a0)
	bsr	dobefore
	bsr	flip_scr2
	bsr	eviwait
	cmpi.w	#$39,d0
	bne	eviloop1

	bsr	cleartext
	lea	evitext2,a0
	bsr	printmany
	bsr	flip_scr2
	bsr	flip_scr2
	lea	starcubeob,a0
	move.w	#0,obx(a0)
	move.w	#0,oby(a0)
	move.w	#900,obz(a0)
	move.l	obviewpb(a0),a0
	move.w	#54,theta(a0)
	move.w	#-10,phi(a0)
	move.w	#-32,rho(a0)
	lea	starcubeob2,a0
	move.w	#0,obx(a0)
	move.w	#0,oby(a0)
	move.w	#900,obz(a0)
	move.l	obviewpb(a0),a0
	move.w	#54,theta(a0)
	move.w	#-10,phi(a0)
	move.w	#-32,rho(a0)
	lea	square,a0
	move.w	#0,obx(a0)
	move.w	#0,oby(a0)
	move.w	#900,obz(a0)
	move.l	obviewpb(a0),a0
	move.w	#54,theta(a0)
	move.w	#-10,phi(a0)
	move.w	#-32,rho(a0)
	move.w	#0,myviewx
	move.w	#20,myviewy
	move.w	#4,sqvel
	jsr	domyview
eviloop2:
	lea	starcubeob,a0
	move.l	a0,whichob
	bsr	dobefore
	lea	square,a0
	move.l	a0,whichob
	move.w	sqvel,d0
	add.w	d0,oby(a0)
	cmpi.w	#45,oby(a0)
	ble	ev2
	neg.w	sqvel
ev2:
	cmpi.w	#-45,oby(a0)
	bge	ev3
	neg.w	sqvel
ev3:
	bsr	dobefore
	lea	starcubeob2,a0
	move.l	a0,whichob
	bsr	dobefore
	bsr	flip_scr2
	bsr	eviwait
	cmpi.w	#$39,d0
	bne	eviloop2

	lea	starcubeob,a0
	move.w	#12,numdots(a0)
	move.l	obvert(a0),a0
	move.w	#12,(a0)
	jsr	starcube2
	bsr	cleartext
	lea	evitext3,a0
	bsr	printmany
	bsr	flip_scr2
	bsr	flip_scr2
	lea	square,a0
	move.w	#0,obx(a0)
	move.w	#0,oby(a0)
	move.w	#900,obz(a0)
	move.l	obviewpb(a0),a0
	move.w	#0,theta(a0)
	move.w	#0,phi(a0)
	move.w	#0,rho(a0)
	lea	starcubeob,a0
	move.w	#0,obx(a0)
	move.w	#0,oby(a0)
	move.w	#900,obz(a0)
	move.l	obviewpb(a0),a0
	move.w	#0,theta(a0)
	move.w	#0,phi(a0)
	move.w	#0,rho(a0)
	move.w	#0,myviewx
	move.w	#20,myviewy
	jsr	domyview
eviloop3:
	lea	starcubeob,a0
	move.l	a0,whichob
	move.l	obviewpb(a0),a0
	addq.w	#1,theta(a0)
	addq.w	#1,phi(a0)
	bsr	dobefore
	lea	square,a0
	move.l	a0,whichob
	move.l	obviewpb(a0),a0
	addq.w	#1,theta(a0)
	addq.w	#1,phi(a0)
	bsr	dobefore
	bsr	flip_scr2
	bsr	eviwait
	cmpi.w	#$39,d0
	bne	eviloop3
	bsr	cleartext
	lea	evitext5,a0
	bsr	printmany
	bsr	flip_scr2
	bsr	flip_scr2
	move.l	#mapfile1,filename
	move.l	#mapmem,wheretoload
	move.l	#15984,lengthtoread
	bsr	loadfile
	move.l	#planetfile,filename
	move.l	generalstore,wheretoload
	move.l	#80752,lengthtoread
	bsr	loadfile
	move.w	#1,anaflag
	bra	shipscomputer
eviwait:
	move.l	keybuf,a0
	move.w	6(a0),d0
	cmp.w	8(a0),d0
	beq	ewait2
	lea	keyclicksound,a1	;soundhere
	jsr	startsound
	move.w	#2,-(sp)
	move.w	#2,-(sp)
	trap	#13
	addq.l	#4,sp
	swap	d0
	cmpi.w	#$2e,d0
	bne	ewait2
	addq.l	#4,sp
	bra	shipscomputer
ewait2:
	rts
evi2:
	cmpi.w	#1,evidence
	bne	evi3
	bsr	cleartext
	lea	evitext4,a0
	bsr	printmany
	bsr	flip_scr2
	bsr	flip_scr2
ev5:	bsr	eviwait
	cmpi.w	#$39,d0
	bne	ev5
	bra	shipscomputer
evi3:
	cmpi.w	#2,evidence
	bne	evi4
	bsr	cleartext
	lea	evitext6,a0
	bsr	printmany
	bsr	flip_scr2
	bsr	flip_scr2
ev6:	bsr	eviwait
	cmpi.w	#$39,d0
	bne	ev6
	bra	shipscomputer
evi4:
	cmpi.w	#3,evidence
	bne	evi5
	bsr	cleartext
	lea	evitext7,a0
	bsr	printmany
	lea	square2,a0
	move.w	#0,obx(a0)
	move.w	#0,oby(a0)
	move.w	#900,obz(a0)
	move.l	obviewpb(a0),a0
	move.w	#0,theta(a0)
	move.w	#0,phi(a0)
	move.w	#0,rho(a0)
	lea	starcubeob,a0
	move.w	#0,obx(a0)
	move.w	#0,oby(a0)
	move.w	#900,obz(a0)
	move.l	obviewpb(a0),a0
	move.w	#0,theta(a0)
	move.w	#0,phi(a0)
	move.w	#0,rho(a0)
	move.w	#0,myviewx
	move.w	#20,myviewy
	jsr	domyview
eviloop4:
	lea	starcubeob,a0
	move.l	a0,whichob
	move.l	obviewpb(a0),a0
	addq.w	#1,theta(a0)
	addq.w	#1,phi(a0)
	bsr	dobefore
	lea	square2,a0
	move.l	a0,whichob
	move.l	obviewpb(a0),a0
	addq.w	#1,theta(a0)
	addq.w	#1,phi(a0)
	bsr	dobefore
	bsr	flip_scr2
	bsr	eviwait
	cmpi.w	#$39,d0
	bne	eviloop4
	bsr	cleartext
	lea	evitext5,a0
	bsr	printmany
	bsr	flip_scr2
	bsr	flip_scr2
	move.l	#mapfile2,filename
	move.l	#mapmem,wheretoload
	move.l	#15984,lengthtoread
	bsr	loadfile
	bra	shipscomputer
evi5:
	bra	shipscomputer
*************************************
dopointer:
	move.l	hiden,whichscreen
	lea	planet14sp,a0
	move.w	mx,(a0)
	move.w	my,2(a0)
	bra	putsprite
	rts

**************************************
starcube:
	lea	starcubeob,a6
	move.l	obvert(a6),a6
	move.w	(a6)+,d7	;number of them
	subq.w	#1,d7
scloop:
	move.w	#50,d0
	bsr	random
	move.w	d0,(a6)+	;x
	move.w	#50,d0
	bsr	random
	move.w	d0,(a6)+	;y
	move.w	#50,d0
	bsr	random
	move.w	d0,(a6)+	;z
	dbf	d7,scloop
	rts
starcube2:
	lea	starcubeob,a6
	move.l	obvert(a6),a6
	move.w	(a6)+,d7	;number of them
	subq.w	#1,d7
scloop2:
*	move.w	#50,d0
*	bsr	random
	move.w	#0,(a6)+	;x
	move.w	#50,d0
	bsr	random
	move.w	d0,(a6)+	;y
	move.w	#50,d0
	bsr	random
	move.w	d0,(a6)+	;z
	dbf	d7,scloop2
	rts
**********************************
clearboth:
	move.l	seen,a0
	move.l	hiden,a1
	move.w	#15999,d0
cbl:
	move.w	#0,(a0)+
	move.w	#0,(a1)+
	dbf	d0,cbl
	rts
*****************************************
copyintoboth:
	move.l	screen3,a0
	move.l	hiden,a1
	move.l	seen,a2
	move.w	#7999,d0
cibloop:
	move.l	(a0),(a1)+
	move.l	(a0)+,(a2)+
	dbf	d0,cibloop
	rts
*****************************************
copyseento3all:
	move.l	screen3,a1
	move.l	seen,a0
	move.w	#7999,d0
cibloop3:
	move.l	(a0)+,(a1)+
	dbf	d0,cibloop3
	rts
*****************************************
bslaser:
	move.w	#5,battlelaser
	rts
*****************************************
battleshoot:
	tst.w	changestate
	bpl	bsb
	tst.w	buttondat
	beq	bsb
	move.w	#1,hostile
	tst.w	laser
	bpl	bslaser
	lea	shot1,a0
	lea	shot1vels,a6
	bsr	dobshot
	lea	shot2,a0
	lea	shot2vels,a6
	bsr	dobshot
	lea	shot3,a0
	lea	shot3vels,a6
	bsr	dobshot
	lea	shot4,a0
	lea	shot4vels,a6
	bsr	dobshot
bsb:
	rts

dobshot:
	tst.w	activeflag(a0)
	bpl	dbsb
	lea	standardlasersound,a1
	jsr	startsound
	move.w	#100,obz(a0)
	move.w	#0,obx(a0)
	move.w	#0,oby(a0)
	move.w	sidesx,d0
	neg.w	sidesx
	sub.w	d0,obx(a0)
	move.w	#1,activeflag(a0)
	move.w	#80,shotlife(a6)
	move.w	#0,shotxvel(a6)
	move.w	#0,shotyvel(a6)
	move.w	#bshotspeed,shotzvel(a6)
	addq.l	#4,sp
	subq.w	#1,shipsfuel
	rts
dbsb:
	rts




dobslaser:
	subq.w	#1,battlelaser
	bmi	nobslaseract
	move.w	#15,linecolor
	move.w	#16,x1
	move.w	#48,y1
	move.w	#160,x2
	move.w	#68,y2
	bsr	clipit
	move.w	#303,x1
	move.w	#48,y1
	move.w	#160,x2
	move.w	#68,y2
	bsr	clipit
	move.w	#64,x1
	move.w	#123,y1
	move.w	#160,x2
	move.w	#68,y2
	bsr	clipit
	move.w	#256,x1
	move.w	#123,y1
	move.w	#160,x2
	move.w	#68,y2
	bsr	clipit
	rts

nobslaseract:
	move.w	#-1,battlelaser
	rts
dobslaser2:
	rts

movebattleshots:
	tst.w	laser
	bpl	dobslaser2
	lea	shot1,a0
	lea	shot1vels,a6
	bsr	movebshot
	lea	shot2,a0
	lea	shot2vels,a6
	bsr	movebshot
	lea	shot3,a0
	lea	shot3vels,a6
	bsr	movebshot
	lea	shot4,a0
	lea	shot4vels,a6
	bsr	movebshot
	rts
movebshot:
	tst.w	activeflag(a0)
	bmi	mbsb
	move.l	obviewpb(a0),a1
	add.w	#10,theta(a1)
	move.w	#0,phi(a1)
	move.w	#0,rho(a1)
	move.w	shotxvel(a6),d0
	asr.w	#3,d0
	add.w	d0,obx(a0)
	move.w	shotyvel(a6),d0
	asr.w	#3,d0
	add.w	d0,oby(a0)
	move.w	shotzvel(a6),d0
	asr.w	#3,d0
	add.w	d0,obz(a0)
	subq.w	#1,shotlife(a6)
	bpl	mbsb
	move.w	#-1,activeflag(a0)
mbsb:	rts

bslasercol:
	tst.w	battlelaser
	bmi	nobsl
	lea	drawlist,a6
	move.w	(a6)+,d7	;number of things in the list
	moveq	#0,d0
	moveq	#0,d1
	subq.w	#1,d7
dbhloopl:
	move.l	(a6)+,a1
	tst.w	activeflag(a1)
	bmi.w	nextbhl
	tst.w	canitbehit(a1)	;see if it can be hit
	bmi.w	nextbhl
	move.w	obx(a1),d3
	move.w	oby(a1),d4
	movem.w d3-d4,-(sp)
	sub.w	obw(a1),d3	;subtract its width
	sub.w	obw(a1),d4	;likewise for its height
	cmp.w	d3,d0
	blt.s	pnextbhl
	cmp.w	d4,d1
	blt.s	pnextbhl
	movem.w (sp)+,d3-d4
	add.w	obw(a1),d3
	add.w	obw(a1),d4
	cmp.w	d3,d0
	bgt.s	nextbhl
	cmp.w	d4,d1
	bgt.s	nextbhl
	subq.w	#1,canitbehit(a1)
	move.w	#-1,activeflag(a0)
	cmpi.w	#1,canitbehit(a1)
	bgt.s	nextbhl
	move.w	#1,canitbehit(a1)
	move.w	#-15,activeflag(a1)	;set frame for explosion
	move.w	#-1,activeflag(a0)
	moveq	#0,d0
	move.w	obz(a1),d0
	add.w	#2000,d0
	cmpi.w	#8192,d0
	blt.s	exexbl
	move.w	#8192,d0
exexbl:
	moveq	#9,d1
	asr.w	d1,d0
	moveq	#15,d1
	sub.w	d0,d1
	bgt.s	expokbl
	moveq	#1,d1
expokbl:
	move.w	d1,obx(a1)
	bra.s	nextbhl
pnextbhl:
	addq.l	#4,sp	
nextbhl:
	dbf	d7,dbhloopl
nobsl:
	rts

battleshotcollisions:
	tst.w	laser
	bpl	bslasercol
	lea	shot1,a0
	bsr	dobhits
	lea	shot2,a0
	bsr	dobhits
	lea	shot3,a0
	bsr	dobhits
	lea	shot4,a0
	bsr	dobhits
	rts
dobhits:
	tst.w	activeflag(a0)
	bmi	nbh
	lea	drawlist,a6
	move.w	(a6)+,d7	;number of things in the list
	move.w	obx(a0),d0
	move.w	oby(a0),d1
	move.w	obz(a0),d2
	move.w	d2,d6
	add.w	#shotspeed,d6	
	subq.w	#1,d7
dbhloop:
	move.l	(a6)+,a1
	tst.w	activeflag(a1)
	bmi	nextbh
	tst.w	canitbehit(a1)	;see if it can be hit
	bmi	nextbh
	move.w	obx(a1),d3
	move.w	oby(a1),d4
	move.w	obz(a1),d5
	movem.w d3-d5,-(sp)
	sub.w	obw(a1),d3	;subtract its width
	sub.w	obw(a1),d4	;likewise for its height
	sub.w	obw(a1),d5	;and depth
	cmp.w	d3,d0
	blt	pnextbh
	cmp.w	d4,d1
	blt	pnextbh
	cmp.w	d5,d2
	blt	pnextbh
	movem.w (sp)+,d3-d5
	add.w	obw(a1),d3
	add.w	obw(a1),d4
	add.w	obw(a1),d5
	cmp.w	d3,d0
	bgt	nextbh
	cmp.w	d4,d1
	bgt	nextbh
	cmp.w	d5,d2
	bgt	nextbh
	subq.w	#1,canitbehit(a1)
	move.w	#-1,activeflag(a0)
	cmpi.w	#1,canitbehit(a1)
	bgt	nextbh
	move.l	a1,-(sp)
	lea	tubeexplodesound,a1
	jsr	startsound
	move.l	(sp)+,a1
	move.w	#1,canitbehit(a1)
	move.w	#-15,activeflag(a1)	;set frame for explosion
	move.w	#-1,activeflag(a0)
	moveq	#0,d0
	move.w	obz(a1),d0
	add.w	#2000,d0
	cmpi.w	#8192,d0
	blt	exexb
	move.w	#8192,d0
exexb:
	moveq	#9,d1
	asr.w	d1,d0
	moveq	#15,d1
	sub.w	d0,d1
	bgt	expokb
	moveq	#1,d1
expokb:
	move.w	d1,obx(a1)
	bra	nextbh
pnextbh:
	addq.l	#6,sp	
nextbh:
	dbf	d7,dbhloop
nbh:	rts
*****************************************
explodeamat:
	lea	drawlist,a0
	move.w	(a0)+,d7
	subq.w	#1,d7
exlopa:
	move.l	(a0)+,a1
	tst.w	canitbehit(a1)
	bmi	nohita
	tst.w	activeflag(a1)
	bmi	nohita
	move.w	#1,canitbehit(a1)
	move.w	#-15,activeflag(a1)	;set frame for explosion
	moveq	#0,d0
	move.w	obz(a1),d0
	add.w	#2000,d0
	cmpi.w	#8192,d0
	blt	exexbam
	move.w	#8192,d0
exexbam:
	moveq	#9,d1
	asr.w	d1,d0
	moveq	#15,d1
	sub.w	d0,d1
	bgt	expokbam
	moveq	#1,d1
expokbam:
	move.w	d1,obx(a1)
nohita:
	dbf	d7,exlopa
	rts


*****************************************
tubeshoot:
	tst.w	changestate
	bpl	tsb
	tst.w	buttondat
	beq	tsb
	lea	shot1,a0
	bsr	doshot
	lea	shot2,a0
	bsr	doshot
	lea	shot3,a0
	bsr	doshot
	lea	shot4,a0
	bsr	doshot
tsb:
	rts

doshot:
	tst.w	activeflag(a0)
	bpl	dsb
	lea	standardlasersound,a1
	jsr	startsound
	move.w	#100,obz(a0)
	move.w	myviewx,obx(a0)
	move.w	myviewy,oby(a0)
	neg	oby(a0)
	neg	obx(a0)
	move.w	sidesx,d0
	neg.w	sidesx
	sub.w	d0,obx(a0)
	move.w	#1,activeflag(a0)
	addq.l	#4,sp
	subq.w	#1,shipsfuel
	rts
dsb:
	rts
moveshots:
	lea	shot1,a0
	bsr	moveshot
	lea	shot2,a0
	bsr	moveshot
	lea	shot3,a0
	bsr	moveshot
	lea	shot4,a0
	bsr	moveshot
	rts

moveshot:
	tst.w	activeflag(a0)
	bmi	msb
	move.l	obviewpb(a0),a1
	add.w	#10,theta(a1)
	move.w	#0,phi(a1)
	move.w	#0,rho(a1)
	addi.w	#shotspeed,obz(a0)
	cmpi.w	#12000,obz(a0)
	blt	msb
	move.w	#-1,activeflag(a0)
msb:	rts

*****************************************
movestars:
	lea	startvrt,a6
	move.w	(a6)+,d7	;number ofem
	subq.w	#1,d7
	move.w	#speed,d6	
msloop:
	sub.w	d6,4(a6)
*	cmpi.w	#zclip,4(a6)
	ble	newstar
	addq.l	#6,a6
	dbf	d7,msloop
	rts

newstar:
	cmpi.w	#100,hypercount
	ble	newstar2
	move.w	#12000,4(a6)
	addq.l	#6,a6
	dbf	d7,msloop
	rts
newstar2:
	move.w	#0,4(a6)
	addq.l	#6,a6
	dbf	d7,msloop
	rts
doworld:
	lea	worldvpb,a5
	move.w	mytheta,theta(a5)
	move.w	myphi,phi(a5)
	move.w	myrho,rho(a5)
	bsr	initworldtrans
	lea	radarvpb,a5
	bsr	initworldtrans
	rts
doworld2:
	lea	worldvpb,a5
	move.w	mytheta,theta(a5)
	move.w	myrot,d0
	sub.w	d0,theta(a5)
	move.w	myphi,phi(a5)
	move.w	myrho,rho(a5)
	bsr	initworldtrans
	lea	starrotvpb,a5
	move.w	myrot,d0
	sub.w	d0,theta(a5)
	bsr	initworldtrans
	lea	radarvpb,a5
	bsr	initworldtrans
	rts


domyview:
	lea	worldvpb,a6
	move.w	xvel,d0
	add.w	d0,myviewx
	move.w	yvel,d0
	add.w	d0,myviewy
	cmpi.w	#420,myviewx
	blt	dmv1
	move.w	#420,myviewx
	bra	dmv2
dmv1:
	cmpi.w	#-420,myviewx
	bgt	dmv2
	move.w	#-420,myviewx
dmv2:
	cmpi.w	#420,myviewy
	blt	dmv3
	move.w	#420,myviewy
	bra	dmv4
dmv3:
	cmpi.w	#-420,myviewy
	bgt	dmv4
	move.w	#-420,myviewy
dmv4:
	subq.w	#1,tiltadd
	ble	dmv2b
	move.w	#30,d0
	bsr	random
	add.w	d0,myviewx
	move.w	#30,d0
	bsr	random
	add.w	d0,myviewy
	rts
dmv2b:
	move.w	#0,tilt
	move.w	#0,tiltadd
	rts

domyview2:
	lea	worldvpb,a6
	move.w	xvel,d0
	add.w	d0,myviewx
	move.w	yvel,d0
	add.w	d0,myviewy
	rts
dostartube:
	bsr	movestars
	lea	startube,a5
	move.l	obviewpb(a5),a6
	move.w	#0,theta(a6)
	move.w	#0,phi(a6)
	move.w	#0,rho(a6)
	move.w	obx(a5),plx
	move.w	oby(a5),ply
	move.w	obz(a5),plz
	bsr	init_vtrans
	lea	startube,a3
	bsr	trans_vert	;Transform verticies
	lea	startube,a5
	move.w	numdots(a5),d7
	lea	ptrans_vrt,a6
	lea	vtrans_vrt,a5
	subq.w	#1,d7
dsloop:
	moveq	#0,d0
	addq.l	#4,a5
	moveq	#0,d0
	move.w	(a5)+,d0
*	neg.w	d0
	move.w	d0,d1
	asr.w	#8,d0
	asr.w	#3,d0
	add.w	#6,d0
	cmpi.w	#10,d0
	ble	dsss
	moveq	#10,d0
dsss:	move.w	d0,pixelcolor
	move.w	(a6)+,pixelx
	move.w	(a6)+,pixely
	cmpi.w	#8000,d1
	blt	dblp
	bsr	singleplot
	dbf	d7,dsloop
	rts
dblp:	bsr	doubleplot
	dbf	d7,dsloop
	rts

dometeors:
	lea	met1,a0
	bsr	domet
	lea	met2,a0
	bsr	domet
	lea	met3,a0
	bsr	domet
	lea	met4,a0
	bsr	domet
	lea	met5,a0
	bsr	domet
	rts

domet:
	tst.w	activeflag(a0)
	bmi	activerand
	sub.w	#speed,obz(a0)
	cmpi.w	#2100,obz(a0)
	bgt	noadsp
	tst.w	channel1params+channelprocess
	bpl	noadsp
	lea	passingsound,a1
	jsr	startsound
noadsp:
	cmpi.w	#200,obz(a0)
	bgt	dmh
	move.w	#-1,activeflag(a0)
	rts
dmh:	move.l	a0,whichob
	move.l	obviewpb(a0),a0
	addq.w	#4,theta(a0)
	addq.w	#4,phi(a0)
	rts

activerand:
	cmpi.w	#100,hypercount
	ble	acrb
	cmpi.w	#-2,activeflag(a0)
	ble	acrb
	move.w	#100,d0
	bsr	randomplus
	cmpi.w	#1,d0
	bge	acrb
	move.w	#1,activeflag(a0)
	move.w	#500,d0
	bsr	randomplus
	add.w	#100,d0
	move.w	d0,d6
	move.w	#500,d0
	bsr	randomplus
	add.w	#100,d0
	move.w	d0,d7

	lea	circlecoords,a1
	move.w	#1128,d0
	bsr	randomplus
*	asl.w	#1,d0			;*2
	add.w	d0,d0
	move.w	(a1,d0.w),d1		;x
	bmi	ac1
	sub.w	d6,d1
	move.w	2(a1,d0.w),d2		;y
	bmi	ac3
	sub.w	d7,d2
	bra	acb
ac1:
	add.w	d6,d1			;thats x
	move.w	2(a1,d0.w),d2		;y
	bmi	ac3
	sub.w	d7,d2
	bra	acb
ac3:	add.w	d7,d2
acb:
	move.w	d1,obx(a0)
	move.w	d2,oby(a0)
	move.w	#25000,obz(a0)
acrb:
	rts
***************************************
battlemecollisions:
	lea	drawlist,a0
	move.w	(a0)+,d7	;number of things in the list
	subq.w	#1,d7
bmcloop:
	move.l	(a0)+,a1
	tst.w	activeflag(a1)
	bmi	bmclnext
	tst.w	canitbehit(a1)
	bmi	bmclnext
	cmpi.w	#80,obx(a1)
	bgt	bmclnext
	cmpi.w	#-80,obx(a1)
	blt	bmclnext
	cmpi.w	#80,oby(a1)
	bgt	bmclnext
	cmpi.w	#-80,oby(a1)
	blt	bmclnext
	cmpi.w	#80,obz(a1)
	bgt	bmclnext
	cmpi.w	#-80,obz(a1)
	blt	bmclnext
	move.w	#-1,activeflag(a1)
	subq.w	#5,shipsfuel
	bmi	die2
	lea	mehitsound,a1
	jsr	startsound
bmclnext:
	dbf	d7,bmcloop
	rts
die2:
	addq.l	#4,sp		;remove return
	jsr	cleartext
	move.w	#0,shipsfuel
	lea	death2msg,a0
	jmp	imdead2


mecollisions:
	lea	drawlist,a0
	move.w	(a0)+,d7	;number of things in the list
	subq.w	#1,d7
	move.w	myviewx,d0
	move.w	myviewy,d1
	neg.w	d1
	neg.w	d0
mcloop:
	move.l	(a0)+,a1
	tst.w	activeflag(a1)
	bmi	mclnext
	tst.w	canitbehit(a1)
	bmi	mclnext
	cmpi.w	#500,obz(a1)
	bgt	mclnext
	move.w	obx(a1),d2
	move.w	oby(a1),d3
	sub.w	obw(a1),d2
	sub.w	obw(a1),d3
	cmp.w	d2,d0
	blt	mclnext
	cmp.w	d3,d1
	blt	mclnext
	add.w	obw(a1),d2
	add.w	obw(a1),d3
	add.w	obw(a1),d2
	add.w	obw(a1),d3
	cmp.w	d2,d0
	bgt	mclnext
	cmp.w	d3,d1
	bgt	mclnext
	move.w	#20,tiltadd
	move.w	#-1,activeflag(a1)
	subq.w	#3,shipsfuel
	move.l	a1,-(sp)
	lea	mehitsound,a1
	jsr	startsound
	move.l	(sp)+,a1
mclnext:
	dbf	d7,mcloop
	rts


shotcollisions:
	lea	shot1,a0
	bsr	dohits
	lea	shot2,a0
	bsr	dohits
	lea	shot3,a0
	bsr	dohits
	lea	shot4,a0
	bsr	dohits
	rts
dohits:
	tst.w	activeflag(a0)
	bmi	nh
	lea	drawlist,a6
	move.w	(a6)+,d7	;number of things in the list
	move.w	obx(a0),d0
	move.w	oby(a0),d1
	move.w	obz(a0),d2
	move.w	d2,d6
	add.w	#shotspeed,d6	
	subq.w	#1,d7
dhloop:
	move.l	(a6)+,a1
	tst.w	activeflag(a1)
	bmi	nexth
	tst.w	canitbehit(a1)	;see if it can be hit
	bmi	nexth
	move.w	obx(a1),d3
	move.w	oby(a1),d4
	move.w	obz(a1),d5
	movem.w d3-d5,-(sp)
	sub.w	obw(a1),d3	;subtract its width
	sub.w	obw(a1),d4	;likewise for its height
	add.w	obw(a1),d5	;and depth
	cmp.w	d3,d0
	blt	pnexth
	cmp.w	d4,d1
	blt	pnexth
	cmp.w	d5,d2
	blt	pnexth
	movem.w (sp)+,d3-d5
	add.w	obw(a1),d3
	add.w	obw(a1),d4
	sub.w	obw(a1),d5
	cmp.w	d3,d0
	bgt	nexth
	cmp.w	d4,d1
	bgt	nexth
	move.l	a1,-(sp)
	lea	tubeexplodesound,a1
	jsr	startsound
	move.l	(sp)+,a1
	addq.w	#5,credits
	move.w	#-15,activeflag(a1)	;set frame for explosion
	move.w	#-1,activeflag(a0)
	moveq	#0,d0
	move.w	obz(a1),d0
	add.w	#2000,d0
	cmpi.w	#8192,d0
	blt	exex
	move.w	#8192,d0
exex:
	moveq	#9,d1
	asr.w	d1,d0
	moveq	#15,d1
	sub.w	d0,d1
	bgt	expok
	moveq	#1,d1
expok:
	move.w	d1,obx(a1)
	bra	nexth
pnexth:
	addq.l	#6,sp	
nexth:
	dbf	d7,dhloop
nh:	rts
	

drawpart1:
	lea	drawlist,a0
	move.w	#9,(a0)+
	move.l	#met1,(a0)+
	move.l	#met2,(a0)+
	move.l	#met3,(a0)+
	move.l	#met4,(a0)+
	move.l	#met5,(a0)+
	move.l	#shot1,(a0)+
	move.l	#shot2,(a0)+
	move.l	#shot3,(a0)+
	move.l	#shot4,(a0)+
	bra	sortndrawlist
*********************************
* Version for planet sequence	*
*********************************
sortndrawlist2:
	lea	drawlist,a6
	move	(a6)+,d6		;number of em
	subq.w	#2,d6
	bmi.s	putobjectsp
sortobsp:
	moveq	#0,d4
	move.w	d6,d7			;number of obs-2?
	lea	drawlist,a6
	addq.l	#2,a6
soloopp:
	move.l	(a6),a0
	move.l	4(a6),a1
	move.w	obz(a0),d0
	cmp.w	obz(a1),d0
	blt	swapemp
	addq.l	#4,a6
	dbf	d7,soloopp
	tst.w	d4
	beq.s	putobjectsp
	bra.s	sortobsp
swapemp:
	moveq	#1,d4
	move.l	a1,(a6)
	move.l	a0,4(a6)
	addq.l	#4,a6
	dbf	d7,soloopp
	bra.s	sortobsp
putobjectsp:
	lea	drawlist,a5
	move.w	(a5)+,d7
	subq.w	#1,d7
droloopp:
	move.l	(a5)+,a0
	movem.l d7/a5,-(sp)
	tst.w	activeflag(a0)
	bmi	rm3p
	move.w	obz(a0),d6
	bmi	rm3p
	move.w	#11,d5
	lsr.w	d5,d6
	addq.w	#4,d6
	move.w	d6,linecolinfo(a0)
	move.l	a0,whichob
	bsr	dobefore
rm3p:	movem.l (sp)+,d7/a5
	dbf	d7,droloopp
	rts

*********************************
*	preload all this stuff	*
*********************************
sortndrawlist:
	lea	drawlist,a6
	move	(a6)+,d6		;number of em
	subq.w	#2,d6
	bmi.s	putobjects
sortobs:
	moveq	#0,d4
	move.w	d6,d7			;number of obs-2?
	lea	drawlist,a6
	addq.l	#2,a6
soloop:
	move.l	(a6),a0
	move.l	4(a6),a1
	move.w	obz(a0),d0
	cmp.w	obz(a1),d0
	blt	swapem
	addq.l	#4,a6
	dbf	d7,soloop
	tst.w	d4
	beq.s	putobjects
	bra.s	sortobs
swapem:
	moveq	#1,d4
	move.l	a1,(a6)
	move.l	a0,4(a6)
	addq.l	#4,a6
	dbf	d7,soloop
	bra.s	sortobs
putobjects:
	lea	drawlist,a5
	move.w	(a5)+,d7
	subq.w	#1,d7
droloop:
	move.l	(a5)+,a0
	movem.l d7/a5,-(sp)
	tst.w	activeflag(a0)
	bmi	rm2
	tst.w	obz(a0)
	bmi	rm2
	move.l	a0,whichob
	bsr	dobefore
	bra	rm3
rm2:
	cmpi.w	#-2,activeflag(a0)
	bgt	rm3
	move.w	onscreenx(a0),spritex
	move.w	onscreeny(a0),spritey
	jsr	doexptest	
rm3:	movem.l (sp)+,d7/a5
	dbf	d7,droloop
	tst.w	laser
	bpl	dobslaser
	rts

infodraw:
	lea	worldvpb,a6
	move.w	#0,theta(a6)
	move.w	#0,phi(a6)
	move.w	#0,rho(a6)
	move.l	whichob,a0
	move.l	obviewpb(a0),a0
	addq.w	#2,theta(a0)
	addq.w	#2,phi(a0)
	subq.w	#1,rho(a0)
	bra	dobefore


testdraw:
	lea	path0,a0
	move.l	a0,whichob
	move.w	mx,obx(a0)
	move.w	my,oby(a0)
	move.l	obviewpb(a0),a0
	move.w	#0,theta(a0)
	move.w	#0,phi(a0)
	move.w	#0,rho(a0)
	bsr	dobefore
	lea	path1,a0
	move.w	mx,obx(a0)
	move.w	my,oby(a0)
	move.l	a0,whichob
	bsr	dobefore
	lea	path2,a0
	move.w	mx,obx(a0)
	move.w	my,oby(a0)
	move.l	a0,whichob
	bsr	dobefore
	lea	path3,a0
	move.w	mx,obx(a0)
	move.w	my,oby(a0)
	move.l	a0,whichob
	bsr	dobefore
	lea	path4,a0
	move.w	mx,obx(a0)
	move.w	my,oby(a0)
	move.l	a0,whichob
	bsr	dobefore
	lea	path5,a0
	move.w	mx,obx(a0)
	move.w	my,oby(a0)
	move.l	a0,whichob
dobefore2:
	move.l	whichob,a5
	move.w	obx(a5),plx
	cmpi.w	#-1000,plx
	blt	dbback
	cmpi.w	#1000,plx
	bgt	dbback
	move.w	oby(a5),ply
	move.w	obz(a5),plz
	cmpi.w	#zclip,plz
	bgt	drawobject
dbback2:	rts


dobefore:
	move.l	whichob,a5
	move.w	obx(a5),plx
	cmpi.w	#-1000,plx
	blt	dbback
	cmpi.w	#1000,plx
	bgt	dbback
	move.w	oby(a5),ply
	cmpi.w	#-800,ply
	blt	dbback
	cmpi.w	#800,ply
	bgt	dbback
	move.w	obz(a5),plz
	cmpi.w	#zclip,plz
	bgt	drawobject
dbback: rts
	
drawobject:
	bsr	init_vtrans
	move.l	whichob,a3	;Point to verticies
	bsr	trans_vert	;Transform verticies
	move.l	whichob,a0
	move.w	d3,onscreenx(a0)
	move.w	d4,onscreeny(a0)
	lea	vtrans_vrt,a1	;list of transformed vertices
	lea	ptrans_vrt,a2	;list of onscreen coords
	move.w	linecolinfo(a0),linecolor
	cmpi.w	#dots,style(a0)
	beq	objectisdots
	move.w	hidenflag(a0),hdf
	move.l	obcolors(a0),a6 	;face color list
	move.l	obfacelist(a0),a0
	move.w	(a0)+,d0	;number of faces
	subq	#1,d0
tdloop:
	move.w	(a0)+,numfacesave	;number of points in face
	move.w	(a6)+,facecolor1
	move.w	(a6)+,facecolor2
	tst.w	hdf
	bmi	pdt
	move.w	(a0),d2 	;offset of face point
	move.w	2(a0),d3	;second point
	move.w	4(a0),d4	;third point

	move.w	d2,d5		;simulate mulu #6 only faster
*	lsl.w	#1,d2
	add.w	d2,d2
	lsl.w	#2,d5
	add.w	d5,d2

	move.w	d3,d5		;simulate mulu #6 only faster
*	lsl.w	#1,d3
	add.w	d3,d3
	lsl.w	#2,d5
	add.w	d5,d3

	move.w	d4,d5		;simulate mulu #6 only faster
*	lsl.w	#1,d4
	add.w	d4,d4
	lsl.w	#2,d5
	add.w	d5,d4

	move.w	(a1,d3.w),d5	;get x2
	move.w	d5,kx
	sub.w	(a1,d2.w),d5	;x2-x1
	move.w	d5,px
	move.w	2(a1,d3.w),d5	;get y2
	move.w	d5,ky
	sub.w	2(a1,d2.w),d5	;y2-y1
	move.w	d5,py
	move.w	4(a1,d3.w),d5	;get z2
	move.w	d5,kz
	sub.w	4(a1,d2.w),d5	;z2-z1
	move.w	d5,pz

	move.w	(a1,d4.w),d5	;x3
	sub.w	(a1,d2.w),d5	;x3-x1
	move.w	2(a1,d4.w),d6	;y3
	sub.w	2(a1,d2.w),d6	;y3-y1
	move.w	4(a1,d4.w),d7	;z3
	sub.w	4(a1,d2.w),d7	;z3-z1

	move.w	d5,d1
	move.w	d6,d2
	move.w	d7,d3

	muls	py,d3
	muls	pz,d2
	sub.w	d2,d3
	move.w	d3,rx
	muls	pz,d1
	muls	px,d7
	sub.w	d7,d1
	move.w	d1,ry
	muls	px,d6
	muls	py,d5
	sub.w	d5,d6
	move.w	d6,rz

	moveq	#0,d1		;projection centre x
	sub.w	kx,d1
	moveq	#0,d2		;projection centre y
	sub.w	ky,d2
	moveq	#0,d3		;projection centre z
	sub.w	kz,d3
	muls	rx,d1
	muls	ry,d2
	muls	rz,d3
	add.l	d1,d2
	add.l	d2,d3
	ble	notvisible
pdt:
	move.w	numfacesave,d1
	move.l	whichob,a5
	cmpi.w	#filled,style(a5)
	beq	drawfilled
	move.w	(a0),d2
	asl.w	#2,d2		;*4 for offsett
	move.w	(a2,d2.w),x1s
	move.w	2(a2,d2.w),y1s
	subq.w	#1,d1
	bpl.s	visible
	addq.w	#1,d1
visible:
	move.w	(a0),d2
	asl.w	#2,d2		;*4 for offsett
	move.w	(a2,d2.w),x1
	move.w	2(a2,d2.w),y1
	move.w	2(a0),d2
	asl.w	#2,d2		;*4 for offsett
	move.w	(a2,d2.w),x2
	move.w	2(a2,d2.w),y2
	move.w	x2,x2s
	move.w	y2,y2s
	bsr	clipit
	addq.l	#2,a0
	dbf	d1,visible
	move.w	x1s,x1
	move.w	y1s,y1
	move.w	x2s,x2
	move.w	y2s,y2
	bsr	clipit
	addq.l	#2,a0
	dbf	d0,tdloop
	rts

drawfilled:
	move.w	facecolor1,surfacedfn	;color
	move.w	facecolor2,surfacedfn+2
	lea	surfacevrt,a5
	move.w	d1,(a5)+		;number of points
dfloop:
	move.w	(a0)+,d2
	asl.w	#2,d2		;*4 for offsett
	move.w	(a2,d2.w),(a5)+
	move.w	2(a2,d2.w),(a5)+
	dbf	d1,dfloop
	bsr	draw_polygon3
	dbf	d0,tdloop
	rts

notvisible:
	move.w	numfacesave,d1
	addq.w	#1,d1
*	asl.w	#1,d1
	add.w	d1,d1
	add.w	d1,a0	
*	addq.l	#2,a0
	dbf	d0,tdloop
	rts

objectisdots:
	move.w	#11,pixelcolor
	lea	ptrans_vrt,a1	;list of onscreen coords
	move.w	numdots(a0),d0	;get the number of points
	subq.w	#1,d0
dotloop:
	move.w	(a1)+,pixelx
	move.w	(a1)+,pixely
	bsr	singleplot
	dbf	d0,dotloop
	rts

*******************************
*	expects x in d2
calcvsa:
	move.w	d0,d2
	and.w	#15,d2
	lsl.w	#2,d1	       ;mult by 4 for index
	lsr.w	#1,d0		  ;x coord / 2
	and.w	#$00f8,d0      ;strip lower 3 bits
	move.w	d0,a0	     ;move x offset to A0
	move.l	sytable,a1   ;get y table addr
	adda.l	(a1,d1.w),a0 ;got final pixel addr!
	rts
calcvsah:
	tst.w	d0
	bge	cv1
	moveq	#0,d0
cv1:
	tst.w	d1
	bge	cv2
	moveq	#0,d1
cv2:
	move.w	d0,spritex
	move.w	d1,spritey
	move.w	d0,d2
	and.w	#15,d2
	lsl.w	#2,d1	       ;mult by 4 for index
	lsr.w	#1,d0		  ;x coord / 2
	and.w	#$00f8,d0      ;strip lower 3 bits
	move.w	d0,a6	     ;move x offset to A0
	move.l	ytable,a1   ;get y table addr
	adda.l	(a1,d1.w),a6 ;got final pixel addr!
	rts
*******************************
*/**//*/*//*//*/*//*//*/*/*//*/*/*/*//*/*/*/*//*//*//*///*/*/
bitcode:clr.l	d4
	cmpi.w	#cxmin,d0
	bge	b1
	or.b	#8,d4
b1:	cmpi.w	#cxmax,d0
	ble	b2
	or.b	#4,d4
b2:	cmpi.w	#cymin,d1
	bge	b3
	or.b	#1,d4
b3:	cmpi.w	#cymax,d1
	ble	b4
	or.b	#2,d4
b4:	move.w	d4,cbits
	rts
*****
bitc2:	 clr.l	 d5
	cmpi.w	#cxmin,d2
	bge	b5
	or.b	#8,d5
b5:	cmpi.w	#cxmax,d2
	ble	b6
	or.b	#4,d5
b6:	cmpi.w	#cymin,d3
	bge	b7
	or.b	#1,d5
b7:	cmpi.w	#cymax,d3
	ble	b8
	or.b	#2,d5
b8:	move.w	d5,cbits2
	rts
********************************************************
clipit:
	movem.l d0-d7/a0,-(sp)
	move.w	x1,d0
	move.w	y1,d1
	move.w	x2,d2
	move.w	y2,d3

	bsr	bitcode
	bsr	bitc2
clipit2:or.b	d4,d5
	tst.b	d5
	beq	cliphome	;finish if
	move.w	cbits,d4
	move.w	d2,xsav
	move.w	d3,ysav
	move.w	cbits2,d5
clip1:	and.b	d4,d5
	tst.b	d5
	bgt	clipb		;home if line completely out
	move.w	cbits,d4
	move.w	cbits2,d5
	sub.w	d0,d2		;d1 has dx
	move.w	d2,dx
	sub.w	d1,d3		;d3 has dy
	move.w	d3,dy
	move.w	xsav,d2
	move.w	ysav,d3
	tst.w	d4
	beq	clip2		;if x1<xmin
	cmpi.w	#cxmin,d0	;y1=y1+dy*(xmin-x1)/dx
	bge	c1	
	move.w	#cxmin,d7	  ;put xmin in d7
	sub.w	d0,d7
	muls	dy,d7		;multiply by dy
	divs	dx,d7
	add.w	d1,d7
	move.w	d7,d1
	move.w	#cxmin,d0	  ;x1=xmin
	bra	c4
c1:	cmpi.w	#cxmax,d0	  ;if x1>xmax
	ble	c2		;y1=y1+dy*(xmax-x1)/dx
	move.w	#cxmax,d7	  ;put xmax in d7
	sub.w	d0,d7
	muls	dy,d7		;multiply by dy
	divs	dx,d7
	add.w	d1,d7
	move.w	d7,d1
	move.w	#cxmax,d0	  ;x1=xmax
	bra	c4
c2:	cmpi.w	#cymin,d1	  ;if y1<ymin
	bge	c3
	move.w	#cymin,d7	  ;put ymin in d7
	sub.w	d1,d7
	muls	dx,d7		;multiply by dx
	divs	dy,d7
	add.w	d0,d7
	move.w	d7,d0
	move.w	#cymin,d1	  ;y1=ymin
	bra	c4
c3:	cmpi.w	#cymax,d1	  ;if y1>xmax
	ble	c4
	move.w	#cymax,d7	  ;put ymax in d7
	sub.w	d1,d7
	muls	dx,d7		;multiply by dy
	divs	dy,d7
	add.w	d0,d7
	move.w	d7,d0
	move.w	#cymax,d1	  ;y1=ymax
c4:	bsr	bitcode
	bra	cliploop
******
clip2:	cmpi.w	#cxmin,d2 ;	y1=y1+dy*(xmin-x1)/dx
	bge	cc1	
	move.w	#cxmin,d7	  ;put xmin in d7
	sub.w	d2,d7
	muls	dy,d7		;multiply by dy
	divs	dx,d7
	add.w	d3,d7
	move.w	d7,d3
	move.w	#cxmin,d2	  ;x2=xmin
	bra	cc4
cc1:	cmpi.w	#cxmax,d2	  ;if x2>xmax
	ble	cc2
	move.w	#cxmax,d7	  ;put xmax in d7
	sub.w	d2,d7
	muls	dy,d7		;multiply by dy
	divs	dx,d7
	add.w	d3,d7
	move.w	d7,d3
	move.w	#cxmax,d2	  ;x1=xmax
	bra	cc4
cc2:	cmpi.w	#cymin,d3	  ;if y1<ymin
	bge	cc3
	move.w	#cymin,d7	  ;put ymin in d7
	sub.w	d3,d7
	muls	dx,d7		;multiply by dx
	divs	dy,d7
	add.w	d2,d7
	move.w	d7,d2
	move.w	#cymin,d3	  ;y1=ymin
	bra	cc4
cc3:	cmpi.w	#cymax,d3	  ;if y1>xmax
	ble	cc4
	move.w	#cymax,d7	  ;put ymax in d7
	sub.w	d3,d7
	muls	dx,d7		;multiply by dy
	divs	dy,d7
	add.w	d2,d7
	move.w	d7,d2
	move.w	#cymax,d3	  ;y1=ymax
cc4:	bsr	bitc2
	bra	cliploop

cliploop:
	bra	clipit2
cliphome:
	move.w	d0,x1
	move.w	d1,y1
	move.w	d2,x2
	move.w	d3,y2
	bsr	myline
	movem.l (sp)+,d0-d7/a0
	rts
clipb:
	movem.l (sp)+,d0-d7/a0
	rts
***********************************************
*	lets plot a fucking line
*	but lets do it fast
*	first some conventions
*	draws line on hiden screen
*	between x1,y1,x2,y2 
***********************************************
myline:
*	movem.l d4-d7/a0,-(sp)
calcdx:
	move.w	x2,d0
	sub.w	x1,d0	;x2-x1
	move.w	d0,dx	;d0 is dx
	bpl	calcdy
	neg	d0
calcdy:
	move.w	y2,d1
	sub.w	y1,d1	;y2-y1	
	move.w	d1,dy	;d6 is dy
	bpl	cmparedxdy
	neg	d1
cmparedxdy:
	cmp.w	d0,d1
	bgt	ymajor	;if dy is greater then ymajor
xmajor:
*	tst.w	dy
*	beq	horizontal	;special case
	tst.w	dx
	bpl	noswapx
	move.w	x2,d0
	move.w	x1,x2
	move.w	d0,x1
	move.w	y2,d0
	move.w	y1,y2
	move.w	d0,y1
	neg	dx
	neg	dy
noswapx:
	moveq	#0,d0
	move.w	dx,d0
	divs	dy,d0
	bmi	xpositive

xnegative:
	move.l	hiden,a0	;screen ad
	move.w	dx,d0
	move.w	d0,d7	;counter is d7
	subq.w	#1,d7
	asr.w	#1,d0	;div by 2
	move.w	d0,d6	;dump is d6
	move.w	x1,d0	;will hold bitpattern
	move.w	d0,d2
	move.w	y1,d1
	lsl.w	#5,d1	;mult y by 128
	adda.w	d1,a0	;add it to screen address
	lsl.w	#2,d1	;mult by 32 makes mult by 160
	adda.w	d1,a0	;a0 now has start screen address
	and.w	#$fff0,d0	;mask off last 4 bits gives word across
	lsr.w	#1,d0
	add.w	d0,a0
	moveq	#0,d4
	tst.w	d7
	bmi	specxneg
	move.w	d2,d3
	and.w	#15,d3
	bne	xmnloop
	subq.l	#8,a0
xmnloop:
	move.w	d2,d3
	and.w	#15,d3
	bne	xmnla
	bsr	putlinein
	moveq	#0,d4
	addq.l	#8,a0
xmnla:	sub.w	#15,d3
	neg	d3
	bset	d3,d4
	sub.w	dy,d6	;sub dy from dump
	bpl	xmn
	add.w	dx,d6
	bsr	putlinein
	adda.l	#160,a0 	;moveit to next line
	moveq	#0,d4
xmn:
	addq.w	#1,d2
	dbf	d7,xmnloop
specxneg:
	move.w	d2,d3
	and.w	#15,d3
	bne	spct1
	bra	putlinein
spct1:	sub.w	#15,d3
	neg	d3
	bset	d3,d4
	bsr	putlinein
	rts

putlinein:
	move.w	d4,d5
	eor.w	#$ffff,d5
	and.w	d5,(a0) 	;clearout old pixels
	and.w	d5,2(a0)
	and.w	d5,4(a0)
	and.w	d5,6(a0)
	move.w	linecolor,d5
plane1:
	btst	#0,d5
	beq	plane2
	or.w	d4,(a0)
plane2:
	btst	#1,d5
	beq	plane3
	or.w	d4,2(a0)
plane3:
	btst	#2,d5
	beq	plane4
	or.w	d4,4(a0)
plane4:
	btst	#3,d5
	beq	plane5
	or.w	d4,6(a0)
plane5:
	rts

xpositive:
	move.l	hiden,a0	;screen ad
	move.w	dx,d0
	move.w	d0,d7	;counter is d7
	subq.w	#1,d7
	asr.w	#1,d0	;div by 2
	move.w	d0,d6	;dump is d6
	move.w	x1,d0	;will hold bitpattern
	move.w	d0,d2
	move.w	y1,d1
	lsl.w	#5,d1	;mult y by 128
	adda.w	d1,a0	;add it to screen address
	lsl.w	#2,d1	;mult by 32 makes mult by 160
	add.w	d1,a0	;a0 now has start screen address
	and.w	#$fff0,d0	;mask off last 4 bits gives word across
	lsr.w	#1,d0
	add.w	d0,a0
	moveq	#0,d4
	move.w	d2,d3
	and.w	#15,d3
	bne	xmploop
	subq.l	#8,a0
xmploop:
	move.w	d2,d3
	and.w	#15,d3
	bne	xmpla
	bsr	putlinein
	moveq	#0,d4
	addq.l	#8,a0
xmpla:	sub.w	#15,d3
	neg	d3
	bset	d3,d4
	add.w	dy,d6	;sub dy from dump
	bpl	xmp
	add.w	dx,d6
	bsr	putlinein
	moveq	#0,d4
	suba.l	#160,a0 	;moveit to next line
xmp:
	addq.w	#1,d2
	dbf	d7,xmploop
	move.w	d2,d3
	and.w	#15,d3
	bne	spct2
	bra	putlinein
spct2:	sub.w	#15,d3
	neg	d3
	bset	d3,d4
	bsr	putlinein
	rts

ymajor:
	tst.w	dy
	bpl	noswapy
	move.w	x2,d0
	move.w	x1,x2
	move.w	d0,x1
	move.w	y2,d0
	move.w	y1,y2
	move.w	d0,y1
	neg	dx
	neg	dy
noswapy:
	moveq	#0,d0
	move.w	dy,d0
	divs	dx,d0
	bmi	ypositive
ynegative:
	tst.w	dx
	beq	straightup1	;special case vertical line
	move.l	hiden,a0	;screen ad
	move.w	dy,d0
	move.w	d0,d7	;counter is d7
*	subq.w	#1,d7
	asr.w	#1,d0	;div by 2
	move.w	d0,d6	;dump is d6
	move.w	x1,d0	;will hold bitpattern
	move.w	d0,d3
	move.w	y1,d1
	move.w	d1,d2
	lsl.w	#5,d1	;mult y by 128
	adda.w	d1,a0	;add it to screen address
	lsl.w	#2,d1	;mult by 32 makes mult by 160
	add.w	d1,a0	;a0 now has start screen address
	and.w	#$fff0,d0	;mask off last 4 bits gives word across
	lsr.w	#1,d0
	add.w	d0,a0
	move.w	d3,d0	;x
	moveq	#0,d4
	move.w	d0,d3
	and.w	#15,d3
	move.w	#$8000,d4
	lsr.w	d3,d4
ymnloop:
	bsr	putlinein
	add.w	#160,a0 	;y+1
	sub.w	dx,d6		;sub dy from dump
	bpl	ymn
	add.w	dy,d6
	addq.w	#1,d0		;x+1
	move.w	d0,d3
	and.w	#15,d3
	bne	ymnla
	addq.l	#8,a0
ymnla:	move.w	#$8000,d4
	lsr.w	d3,d4
ymn:
	dbf	d7,ymnloop
*	movem.l (sp)+,d4-d7/a0
	rts

ypositive:
	tst.w	dx
	beq	straightup	;special case vertical line
	move.l	hiden,a0	;screen ad
	move.w	dy,d0
	move.w	d0,d7	;counter is d7
	subq.w	#1,d7
	asr.w	#1,d0	;div by 2
	move.w	d0,d6	;dump is d6
	move.w	x1,d0	;will hold bitpattern
	move.w	d0,d3
	move.w	y1,d1
	move.w	d1,d2
	lsl.w	#5,d1	;mult y by 128
	adda.w	d1,a0	;add it to screen address
	lsl.w	#2,d1	;mult by 32 makes mult by 160
	add.w	d1,a0	;a0 now has start screen address
	and.w	#$fff0,d0	;mask off last 4 bits gives word across
	lsr.w	#1,d0
	add.w	d0,a0
	move.w	d3,d0	;x
	moveq	#0,d4
*	move.w	d0,d3
	and.w	#15,d3
	move.w	#$8000,d4
	lsr.w	d3,d4

ymploop:
	bsr	putlinein
	add.w	#160,a0 ;y+1
	add.w	dx,d6	;sub dy from dump
	bpl	ymp
	add.w	dy,d6
	subq.w	#1,d0	;x+1
	move.w	d0,d3
	and.w	#15,d3
	cmpi.w	#15,d3
	bne	ympla
	subq.l	#8,a0
ympla:	move.w	#$8000,d4
	lsr.w	d3,d4
ymp:
	dbf	d7,ymploop
*	movem.l (sp)+,d4-d7/a0
	rts

straightup:
	move.l	hiden,a0	;screen ad
	move.w	dy,d7
	move.w	x1,d0	;will hold bitpattern
	move.w	d0,d3
	move.w	y1,d1
	lsl.w	#5,d1	;mult y by 128
	adda.w	d1,a0	;add it to screen address
	lsl.w	#2,d1	;mult by 32 makes mult by 160
	add.w	d1,a0	;a0 now has start screen address
	and.w	#$fff0,d0	;mask off last 4 bits gives word across
	lsr.w	#1,d0
	add.w	d0,a0	;now a0 is ready
	moveq	#0,d4
	and.w	#15,d3
	move.w	#$8000,d4
	lsr.w	d3,d4	;d4 has proper bit pattern
*	 add.l	 #160,a0
	lea	160(a0),a0
	addq.w	#1,d7
stuploop:
	bsr	putlinein
*	 add.l	 #160,a0
	lea	160(a0),a0
	dbf	d7,stuploop
*	movem.l (sp)+,d4-d7/a0
	rts	

straightup1:
	move.l	hiden,a0	;screen ad
	move.w	dy,d7
	move.w	x1,d0	;will hold bitpattern
	move.w	d0,d3
	move.w	y1,d1
	lsl.w	#5,d1	;mult y by 128
	adda.w	d1,a0	;add it to screen address
	lsl.w	#2,d1	;mult by 32 makes mult by 160
	add.w	d1,a0	;a0 now has start screen address
	and.w	#$fff0,d0	;mask off last 4 bits gives word across
	lsr.w	#1,d0
	add.w	d0,a0	;now a0 is ready
	moveq	#0,d4
	and.w	#15,d3
	move.w	#$8000,d4
	lsr.w	d3,d4	;d4 has proper bit pattern
*	 add.l	 #160,a0
	lea	160(a0),a0
	addq.w	#1,d7
stuploop1:
	bsr	putlinein
*	 sub.l	 #160,a0
	lea	-160(a0),a0
	dbf	d7,stuploop
*	movem.l (sp)+,d4-d7/a0
	rts	

***************************************************************************
*		TRANSFORM A LIST OF VERTICIES
*		On entry,   d6 = number of verticies
*			    a3 = pointer to verticies
*		On exit , a0 = pointer to transformed verticies
*	Transform a list of verticies in 3-D space according to the
*	viewing transformation.
trans_vert:
	lea.l	vtrans_vrt,a1	;Point to vertex tables
	lea.l	ptrans_vrt,a0
	move.l	a0,-(SP)
	move.l	obviewpb(a3),a5
	move.l	obvert(a3),a3
	move.w	(a3)+,d6	;get number of verts
	subq	#1,d6		;Pre-decrement vertex counter
trans_vert0:
	move	(a3)+,d0		;Get x-coordinate of vertex
	move	(a3)+,d1	;Get y-coordinate
	move	(a3)+,d2	;Get z-coordinate
	bsr	view_trans	;Apply view transformatrmed coordinates
	add.w	plx,d3
	add.w	ply,d4
	add.w	plz,d5
	add.w	myviewx,d3
	add.w	myviewy,d4
	move.w	d3,(a1)+
	move	d4,(a1)+
	move	d5,(a1)+
okz:	bsr	prsp_trans	;Apply perspective transformation
	move	d3,(a0)+	;Save transformed x-coordinate		
	move	d4,(a0)+	;Save transformed y-coordinate
	dbf	d6,trans_vert0
	move.l	(SP)+,a0	;Restore transformed vertex pointer
	rts

*******************************
*		VIEW TRANSFORM ON A VERTEX
*		On entry, d0 = x-coordinate of vertex
*			  d1 = y-coordinate of vertex
*			  d2 = z-coordinate of vertex
*		On exit , d3 = x-coordinate view transformed
*			  d4 = y-coordinate view transformed
*			  d5 = z-coordinate view transformed
*	Apply the view transform to a vertex.
view_trans:
	move.w	d0,d3			;get x
	muls	c_theta(a5),d3
	move.w	d1,d4			;get y
	muls	s_theta(a5),d4
	add.l	d4,d3
	swap	d3
	rol.l	#1,d3			;thats	x
	move.w	d1,d4			;get y
	muls	c_theta(a5),d4
	muls	s_theta(a5),d0		;x
	sub.l	d0,d4
	swap	d4
	rol.l	#1,d4			;thats	y
	move.w	d4,d1			;x
	move.w	d3,d0			;y

	move.w	d1,d3			;get y
	muls	c_phi(a5),d3
	move.w	d2,d4			;get z
	muls	s_phi(a5),d4
	add.l	d4,d3
	swap	d3
	rol.l	#1,d3			;thats	y
	move.w	d2,d4			;thats z
	muls	c_phi(a5),d4
	muls	s_phi(a5),d1		;y
	sub.l	d1,d4
	swap	d4
	rol.l	#1,d4			;thats	z
	move.w	d4,d2			;y

	move.w	d0,d4			;x
	muls	c_rho(a5),d4
	move.w	d2,d5
	muls	s_rho(a5),d5		;z
	sub.l	d5,d4
	swap	d4
	rol.l	#1,d4			;thats	x
	move.w	d4,d5
	muls	s_rho(a5),d0
	muls	c_rho(a5),d2
	add.l	d0,d2
	swap	d2
	rol.l	#1,d2		;thats	z
	move.w	d2,d5
	move.w	d3,d7
	move.w	d4,d3
	move.w	d7,d4
	rts

worldview_trans:
	tst.w	theta(a5)
	beq	skiptheta
	move.w	d0,d3			;get x
	muls	c_theta(a5),d3
	move.w	d1,d4			;get y
	muls	s_theta(a5),d4
	add.l	d4,d3
	swap	d3
	rol.l	#1,d3			;thats	y
	move.w	d1,d4			;get y
	muls	c_theta(a5),d4
	muls	s_theta(a5),d0		;x
	sub.l	d0,d4
	swap	d4
	rol.l	#1,d4			;thats	x
	move.w	d4,d1			;x
	move.w	d3,d0			;y

skiptheta:
	tst.w	rho(a5)
	beq	skiprho
	move.w	d0,d4			;x
	muls	c_rho(a5),d4
	move.w	d2,d5
	muls	s_rho(a5),d5		;z
	sub.l	d5,d4
	swap	d4
	rol.l	#1,d4			;thats	z
	move.w	d4,d7
	move.w	d0,d4
	muls	s_rho(a5),d4
	move.w	d2,d3
	muls	c_rho(a5),d3
	add.l	d4,d3
	swap	d3
	rol.l	#1,d3		;thats	x
	move.w	d3,d2
	move.w	d7,d0
skiprho:
	tst.w	phi(a5)
	beq	skipphi
	move.w	d1,d3			;get y
	muls	c_phi(a5),d3
	move.w	d2,d4			;get z
	muls	s_phi(a5),d4
	add.l	d4,d3
	swap	d3
	rol.l	#1,d3			;thats	z
	move.w	d2,d4			;thats z
	muls	c_phi(a5),d4
	muls	s_phi(a5),d1		;y
	sub.l	d1,d4
	swap	d4
	rol.l	#1,d4			;thats	y
	move.w	d4,d2			;y
	move.w	d3,d1
skipphi:
	move.w	d0,d3
	move.w	d1,d4
	move.w	d2,d5
	rts
***************************************************************************
*		PERSPECTIVE TRANSFORM
*		On entry, d3 = view transformed x-coordinate
*			  d4 = view transformed y-coordinate
*			  d5 = view transformed z-coordinate
*		On exit , d3 = screen x-coordinate ( Xe )
*			  d4 = screen y-coordinate ( Ye )
*	Calculate the screen coordinates of the vertex. The coordinates are
* centered about the centre of the screen.
*	Note, the distance to the screen is 2048.

prsp_trans:
	swap	d3		;Calculate Xs
	clr	d3		
	asr.l	#7,d3	  
	divs	d5,d3
	
	swap	d4		;Calculate Ys
	clr	d4
	asr.l	#7,d4
	divs	d5,d4

	tst.w	specialprsp
	bpl.s	sppok
	add	#159,d3 	;Adjust for centre of screen
	add	#67,d4
	rts
sppok:
	add	#255,d3 	;Adjust for centre of screen
	add	#57,d4
	rts

***************************************************************************
*		INITIALISE VIEW TRANSFORM
*	Initialise the viewing transformation.
*	expects address of object data in a5
init_vtrans:
	move.l	obviewpb(a5),a5
	move	theta(a5),d3		;Calculate SIN amd COS theta
	bsr	trig
	move	d4,s_theta(a5)
	move	d5,c_theta(a5)
	
	move	phi(a5),d3	;Calculate SIN and COS phi
	bsr	trig
	move	d4,s_phi(a5)
	move	d5,c_phi(a5)

	move	rho(a5),d3	;Calculate Vl
	bsr	trig
	move.w	d4,s_rho(a5)
	move.w	d5,c_rho(a5)
	rts
*****************************************
*	now do world stuff		*
*****************************************
initworldtrans:
*	lea	worldvpb,a5
	move	theta(a5),d3		;Calculate SIN amd COS theta
	bsr	trig
	move	d4,s_theta(a5)
	move	d5,c_theta(a5)

	move	phi(a5),d3	;Calculate SIN and COS phi
	bsr	trig
	move	d4,s_phi(a5)
	move	d5,c_phi(a5)

	move	rho(a5),d3	;Calculate Vl
	bsr	trig
	move.w	d4,s_rho(a5)
	move.w	d5,c_rho(a5)
	rts

***************************************************************************
*		CALCULATE SINE AND COSINE OF ANGLE
*		On entry, d3 = angle
*		On exit ,   d4 = sine of angle
*			    d5 = cosine of angle
*	Find the sine and cosine of an angle.

trig:	addi.w	#$40,d3 	;Find cCOS of angle
	bsr	find_sin
	move	d4,d5
	subi.w	#$40,d3 	;Find SIN of angle
	bsr	find_sin
	rts

***************************************************************************
*		FIND SINE OF AN ANGLE
*		On entry, d3 = angle
*		On exit ,   d5 = cosine of angle 
*	Find the cosine of an angle. The value of the sign is a 16 bit
* signed number.
*	Note, to scale down, divide by 15 bits, ie &8000.
find_cos:
	move	d4,-(SP)	;Save SIN
	move	d3,-(SP)	;Save angle
	addi.w	#$40,d3 	;Find COS of angle
	bsr	find_sin
	move	d4,d5
		
	move	(SP)+,d3	;Restore angle
	move	(SP)+,d4	;Restore SIN
		
	rts	

***************************************************************************
*		FIND THE SIN OF AN ANGLE
*		On entry, d3 = angle
*		On exit ,   d4 = SIN of angle
*	Find the SIN of an angle. The value of the sign is a 16 bit
* signed number.
*	Note, to scale down, divide by 15 bits, ie &8000.

find_sin:
	move	d3,-(SP)	;Save angle	

	and.l	#$7F,d3 	;Move to quadrants 1 and 2
	btst	#6,d3		;Test if in 1st quadrant
	beq	quad0		;Branch if in 1st quadrant
	bclr	#6,d3		;Reflect angle into 1st quadrant
	subi.b	#$3F,d3
	neg.b	d3
		
quad0:
*	asl	#1,d3		;Get value of SIN from table
	add.w	d3,d3
	lea.l	sin_vt,a6
	move	0(a6,d3),d4
		
	move	(SP)+,d3

	btst	#7,d3		;Adjust value if 3rd or 4th quadrant
	beq	quad1
	neg	d4		;Negate SIN value
		
quad1:	rts

cleartext:
	lea	compscreenmem,a0
	move.w	#1980+18,d0
	moveq	#0,d1
ctloop:
	move.w	d1,(a0)+
	dbf	d0,ctloop
	rts
****************************************
shipscomputer:
	jsr	clearradar
	bsr	flip_scr
	jsr	clearradar
	bsr	flip_scr
	move.l	#bluepalette,whichpalette
this:
	move.w	#1,cursoronoff
	bsr	cleartext
	bsr	flip_scr2
	bsr	flip_scr2
	move.w	#1,cursorx
	move.w	#2,cursory
	moveq	#20,d7
	bsr	inputstring
	lea	commandlevel1,a1
	move.l	#this,-(sp)
	bra	processstring
	bra	shipscomputer

*****************************************
*	a1 has current command level	*
*	commands			*
*****************************************
processstring:
	lea	branches,a2
	moveq	#0,d7			;counter for commands
	move.b	(a1)+,d7
	subq.w	#1,d7
prsloop:
	lea	linebuffer,a0
	bsr	comparestrings
	cmpi.w	#3,d2
	bge	cop
	moveq	#0,d3
	addq.l	#4,sp			;account for return ad on stack
	move.b	(a1)+,d3
	asl.w	#2,d3
	move.l	(a2,d3.w),a0
	move.w	#-1,cursoronoff
	jmp	(a0)
cop:
	addq.l	#1,a1			;jump past jump
	dbf	d7,prsloop
	move.w	#14,cursorx
	move.w	#6,cursory
	lea	errorstring1,a0
	bsr	putstring
	move.w	#14,cursorx
	move.w	#7,cursory
	lea	errorstring2,a0
	bsr	putstring
	bsr	flip_scr2
	bsr	flip_scr2
	lea	errorsound,a1
	jsr	startsound
	move.l	#400000,d7
	bsr	generaldelay
	move.l	(sp)+,a0
	jmp	(a0)
	
generaldelay:
	subq.l	#1,d7
	bpl	generaldelay
	rts

comparestrings:
	moveq	#0,d0
	move.b	(a1)+,d0
	moveq	#0,d2
cmploop:
	move.b	(a1)+,d1
	cmp.b	(a0)+,d1
	bne	cmpsb
	dbf	d0,cmploop
	rts	
cmpsb:
	addq.w	#1,d2		;intelligent compare
	dbf	d0,cmploop
	moveq	#1,d0
noway:
	rts



***************************************************
help:
	bsr	cleartext
	bsr	flip_scr2
	bsr	flip_scr2
	jsr	interference
	lea	helptext,a0
	bsr	printmany
	bsr	flip_scr2
	bsr	flip_scr2
helploop:
	bsr	keyboard
	bra	helploop

***************************************************
shipstats:
	move.w	#200,myviewx
	move.w	#0,myviewy
	move.w	#0,my
	move.w	#-200,mx
	bsr	doworld
	bsr	cleartext
	move.l	#ship3,whichob
	lea	ship3,a0
	move.w	#0,obx(a0)
	move.w	#0,oby(a0)
	move.w	#1200,obz(a0)
	jsr	interference
	lea	shipstatstext,a0
	bsr	printmany
	tst.w	sightavail
	bmi.s	statsnosight
	lea	sightmsg,a0
	bsr	printmany
statsnosight:
	tst.w	laser
	bmi.s	statsnolaser
	lea	fastlasermsg,a0
	bsr	printmany
statsnolaser:
	tst.w	orbitsoftware
	bmi.s	statsnoireg
	lea	iregmsg,a0
	bsr	printmany
statsnoireg:
	tst.w	adsoftware
	bmi	statsnoauto
	lea	automsg,a0
	bsr	printmany
statsnoauto:
	tst.w	amat
	bmi.s	statsnocloak
	lea	amatmsg,a0
	bsr	printmany
statsnocloak:
	tst.w	cloakingdevice
	bmi.s	shipstatsloop
	lea	cloakmsg,a0
	bsr	printmany
shipstatsloop:
	bsr	infodraw
	bsr	keyboard
	bsr	flip_scr2
	bra	shipstatsloop
enemyinfo:
	move.w	#0,myviewx
	move.w	#0,myviewy
	move.w	#0,my
	move.w	#-200,mx
	bsr	doworld
	lea	enemylist,a6
	move.w	(a6)+,d7		;number of enemy craft
	subq.w	#1,d7
enemyloop:
	bsr	cleartext
	jsr	interference
	move.l	(a6)+,a0	;get the text for this enemy
	bsr	printmany
	move.l	(a6)+,a0	;get enemy
	move.l	a0,whichob
	move.w	(a6)+,obx(a0)
	move.w	#0,oby(a0)
	move.w	(a6)+,obz(a0)
	movem.l d7/a6,-(sp)
	bsr	rotob
	movem.l (sp)+,d7/a6
	dbf	d7,enemyloop
	bra	enemyinfo

rotob:
	bsr	infodraw
	bsr	flip_scr2
	move.l	keybuf,a0
	move.w	6(a0),d0
	cmp.w	8(a0),d0
	beq	rotob
	lea	keyclicksound,a1	;soundhere
	jsr	startsound
	move.w	#2,-(sp)
	move.w	#2,-(sp)
	trap	#13
	addq.l	#4,sp
	swap	d0
	cmpi.w	#$39,d0
	bne	bc
	rts
bc:	cmpi.w	#$2e,d0
	beq	pshipscomputer
	bra	rotob

pshipscomputer:
	add.l	#12,sp
	bra	shipscomputer

diskstuff:
	jsr	cleartext
	jsr	interference
	jsr	flip_scr2	;clear screen and text
	lea	diskmsg1,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	bsr	getakey
	cmpi.w	#$1f,d0		;is it S
	beq	savegame
	cmpi.w	#$26,d0		;is it L
	beq	loadgame
	cmpi.w	#$2e,d0
	beq	shipscomputer
	bra.s	diskstuff
loadgame:
	jsr	cleartext
	jsr	interference
	lea	loadmsg1,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	jsr	getakey
	cmpi.w	#$2e,d0
	beq	diskstuff

	move.l	#saveend,d7
	sub.l	#savestart,d7
	move.b	oldieb,ieb
	move	#0,-(SP)
	move.l	#gamefile,-(SP)
	move	#$3D,-(SP)
	trap	#1
	addq.l	#8,SP
	tst.w	d0
	bpl	okload
	bra	loaderror
okload:
	move.w	d0,-(sp)
	move.l	#savestart,-(SP)
	move.l	d7,-(SP)
	move	D0,-(SP)
	move	#$3F,-(SP)
	trap	#1
	add.l	 #12,SP

	move	#$3E,-(SP)
	trap	#1
	addq.l	#4,SP
	and.b	#$df,ieb
	jsr	cleartext
	jsr	interference
	lea	loadmsg2,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	jsr	getakey
	jmp	shipscomputer
	
loaderror:
	and.b	#$df,ieb

	jsr	cleartext

	lea	errorsound,a1
	jsr	startsound
	lea	loaderrormsg,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	jsr	getakey
	bra	diskstuff
savegame:
	jsr	cleartext
	jsr	interference
	lea	diskmsg2,a0
	bsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	jsr	getakey
	cmpi.w	#$2e,d0
	beq	diskstuff
	move.b	oldieb,ieb
*	move    #1,-(SP)        ;Open file for write
*	move.l  #gamefile,-(SP) ;Address of filename
*	move    #$3d,-(SP)
*	trap    #1              ;Get handle number in D0
*	addq.l  #8,SP
*	cmpi.w	#-33,d0		;doesn't exist
*	beq	create
*	tst.w	d0		;other error
*	bmi	docn
*	move.w	d0,-(sp)
*cb:


create:
	move.w	#$02,-(sp)		;create a hidden file
	move.l	#gamefile,-(sp)
	move.w	#$3c,-(sp)
	trap	#1
	addq.l	#8,sp
	tst.w	d0
	bmi.s	docn
	move.w	d0,-(sp)	;put the handle on the stack

	move.l	#saveend,d7
	sub.l	#savestart,d7
	move.w	(sp),d0
	move.l  #savestart,-(SP)
	move.l  d7,-(SP)	;length to write in
	move    D0,-(SP)	;Handle
	move    #$40,-(SP)	;bios number
	trap    #1		;write file
	add.l  	#12,SP
	move    #$3E,-(SP)      ;Handle already on stack
	trap    #1              ;Close file
	addq.l  #4,SP
	and.b	#$df,ieb
	jsr	interference
	jsr	cleartext
	lea	savedmsg,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	bsr	getakey
	jmp	shipscomputer

docn:
	and.b	#$df,ieb
	jsr	cleartext
	lea	errorsound,a1
	jsr	startsound
	lea	diskerror1msg,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	jsr	getakey
	bra	diskstuff



getakey:
	move.l	keybuf,a0
	move.w	6(a0),d0
	cmp.w	8(a0),d0
	beq	getakey
	lea	keyclicksound,a1	;soundhere
	jsr	startsound
	move.w	#2,-(sp)
	move.w	#2,-(sp)
	trap	#13
	addq.l	#4,sp
	swap	d0
	rts



dolocation:
	move.l	hiden,whichscreen
	move.l	location,a6
	lea	cursorsp,a0
	move.w	solcx(a6),(a0)
	move.w	solcy(a6),2(a0)
	jsr	putsprite
	rts
mapping:
	tst.w	anaflag
	bmi	noana
mapping1loop:
	bsr	copymap
	bsr	dolocation
	bsr	docrosshairs
	bsr	dombutton
	bsr	flip_scr3
	bsr	keyboard
	cmpi.w	#2,buttondat
	bne	mapping1loop
	lea	keyclicksound,a1
	jsr	startsound
	bra	shipscomputer	

mapping2:
	jmp	shipscomputer
noana:
	lea	errorsound,a1
	jsr	startsound
	jsr	cleartext
	lea	nanatext,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	move.l	#500000,d7
	jsr	generaldelay
	jmp	shipscomputer
dombutton:
	tst.w	buttondat
	beq	nodb
	cmpi.w	#2,buttondat
	beq	nodb
	lea	keyclicksound,a1
	jsr	startsound
	move.w	mx,d0
	move.w	my,d1
	lea	solarlist,a0
	moveq	#11,d7		;number of star systems
dmbloop:
	move.w	(a0),d2
	cmp.w	d0,d2
	bgt	nodbf
	move.w	2(a0),d2
	cmp.w	d1,d2
	bgt	nodbf
	move.w	4(a0),d2
	cmp.w	d0,d2
	blt	nodbf
	move.w	6(a0),d2
	cmp.w	d1,d2
	blt	nodbf
	move.w	8(a0),whichsol
	addq.l	#4,sp
	bra	preparesolarmap
nodbf:
	lea	10(a0),a0
	dbf	d7,dmbloop
nodb:
	rts
preparesolarmap:
	move.l	screen3,whichscreen
	lea	solmaplist,a0
	moveq	#0,d0
	move.w	whichsol,d0
	asl.w	#2,d0			;*4
	move.l	(a0,d0.w),a6		;get ad of solmap
	move.l	(a6)+,whichsollist
	move.l	(a6)+,whichsoltextlist
	move.l	a6,-(sp)
	bsr	cleartext
	bsr	flip_scr
	bsr	flip_scr
	move.l	(sp),a6
	move.l	(a6),a0
	bsr	printmany
	bsr	flip_scr2
	bsr	flip_scr2
	bsr	dosomestars
	bsr	copytext
	move.l	(sp)+,a6
	addq.l	#4,a6
	move.l	(a6)+,whichsolinfo
	move.w	(a6)+,d0
	subq.w	#1,d0
putplanetsloop:
	move.w	(a6)+,d1
	move.w	(a6)+,d2
	move.l	(a6)+,a0
	move.w	d1,(a0)
	move.w	d2,2(a0)
	movem.l d0/a6,-(sp)
	bsr	putsprite
	movem.l (sp)+,d0/a6
	dbf	d0,putplanetsloop
	bsr	copysintomem
solarloop:
	bsr	copysolar
	bsr	docrosshairs
	bsr	flip_scr3
	bsr	dombutton2
	bsr	keys
	bra	solarloop

keys:
	move.l	keybuf,a0
	move.w	6(a0),d0
	cmp.w	8(a0),d0
	bne	ischar3
	rts
ischar3:
	lea	keyclicksound,a1	;soundhere
	jsr	startsound
	move.w	#2,-(sp)
	move.w	#2,-(sp)
	trap	#13
	addq.l	#4,sp
	swap	d0
cc:	cmpi.w	#$2e,d0
	bne	set
	addq.l	#4,sp
	jmp	shipscomputer
set:
	cmpi.w	#$1f,d0
	bne	keysb
	move.l	whichsolinfo,destination
	bsr	printset
	rts
keysb:
	rts	
printset:
	lea	curloc,a0
	lea	desloc,a1
	moveq	#22,d0
cllocs: move.b	#' ',(a0)+
	move.b	#' ',(a1)+
	dbf	d0,cllocs
	bsr	cleartext
	move.l	location,a6
	lea	curloc,a0
	add.l	#solname,a6
psl:
	move.b	(a6)+,(a0)+
	bpl	psl
	move.b	#'.',-1(a0)
	move.l	destination,a6
	lea	desloc,a0
	add.l	#solname,a6
psl1:
	move.b	(a6)+,(a0)+
	bpl	psl1
	move.b	#'.',-1(a0)
	move.l	location,a0
	move.l	destination,a1
	moveq	#0,d6
	moveq	#0,d7
	move.w	solx(a0),d6
	move.w	soly(a0),d7
	sub.w	solx(a1),d6
	sub.w	soly(a1),d7
	and.l	#$0000ffff,d6
	and.l	#$0000ffff,d7
	mulu	d6,d6
	mulu	d7,d7
	add.l	d7,d6
	moveq	#0,d0
	move.w	d6,d0
	bsr	sqrt
	move.w	d1,number
	jsr	prtnum2
	lea	lineout,a0
	lea	dist,a1
	move.b	(a0)+,(a1)+
	move.b	(a0)+,(a1)+
	move.b	(a0)+,(a1)+
	move.b	(a0)+,(a1)+
	move.b	(a0)+,(a1)+
	move.w	d1,d0
	move.w	number,d0
	mulu.w	#3,d0
	move.w	d0,number
	move.w	d0,fuelminus
	jsr	prtnum2
	lea	lineout,a0
	lea	fueln,a1
	move.b	(a0)+,(a1)+
	move.b	(a0)+,(a1)+
	move.b	(a0)+,(a1)+
	move.b	(a0)+,(a1)+
	move.b	(a0)+,(a1)+
	jsr	interference
	lea	settext,a0
	bsr	printmany
	bsr	flip_scr2
	bsr	flip_scr2
	move.l	#1000000,d0
dldl:
	subq.l	#1,d0
	bpl	dldl
	rts	
*************************************************
*	Sqroot routine courtesy of Armin	*
*	Input:	d0.l	number to get root of	*
*		d1	answer			*
*************************************************
sqrt:
	moveq	#20,d4
	lsr.l	#1,d0
	move.l	d0,d1
	lsr.l	#1,d1
sqloop:
	move.w	d1,d2
	lsr.l	#1,d2
	move.l	d0,d3
	divu	d1,d3
	sub.l	d2,d1
	add.w	d3,d1
	dbf	d4,sqloop
	and.l	#$0000ffff,d1
	rts
dombutton2:
	tst.w	buttondat
	beq	nodb2
	cmpi.w	#2,buttondat
	beq	rb2
	lea	keyclicksound,a1
	jsr	startsound
	move.w	mx,d0
	move.w	my,d1
	move.l	whichsollist,a0
	move.w	(a0)+,d7
	subq.w	#1,d7
dmbloop2:
	move.w	(a0),d2
	cmp.w	d0,d2
	bgt	nodbf2
	move.w	2(a0),d2
	cmp.w	d1,d2
	bgt	nodbf2
	move.w	4(a0),d2
	cmp.w	d0,d2
	blt	nodbf2
	move.w	6(a0),d2
	cmp.w	d1,d2
	blt	nodbf2
	move.w	8(a0),whichsol
	move.w	10(a0),whichplanet
	move.l	12(a0),planetdestination
	addq.l	#4,sp
	bra	displayplanet
nodbf2:
	lea	16(a0),a0
	dbf	d7,dmbloop2
nodb2:
	rts
rb2:
	addq.l	#4,sp
	lea	keyclicksound,a1
	jsr	startsound
	move.w	#0,buttondat
	bra	mapping1loop

displayplanet:
	lea	navsound,a1
	jsr	startsound
	bsr	cleartext
	move.l	whichsoltextlist,a6
	moveq	#0,d0
	move.w	whichsol,d0
	move.l	d0,d1
	asl.w	#2,d0
	move.l	(a6,d0.w),a0
	bsr	printmany
	bsr	flip_scr2
	bsr	flip_scr2
	bsr	putplanet
	move.w	#0,buttondat
dpl:
	bsr	keys2
	cmpi.w	#2,buttondat
	bne	dpl
	lea	keyclicksound,a1
	jsr	startsound
	move.w	#0,buttondat
	move.l	#-1,planetdestination
	bra	solarloop

keys2:
	move.l	keybuf,a0
	move.w	6(a0),d0
	cmp.w	8(a0),d0
	bne	ischar4
	rts
ischar4:
	lea	keyclicksound,a1	;soundhere
	jsr	startsound
	move.w	#2,-(sp)
	move.w	#2,-(sp)
	trap	#13
	addq.l	#4,sp
	swap	d0
	cmpi.w	#$2e,d0
	bne	set2
	addq.l	#4,sp
	jmp	shipscomputer
set2:
	cmpi.w	#$1f,d0
	bne	keysb2
	move.l	whichsolinfo,d0
	cmp.l	location,d0
	bne	printplaneterror
	bra	printcourse
keysb2:
	rts	

printcourse:
	jsr	cleartext
	move.l	location,a0
	cmpi.w	#irregular,orbittype(a0)
	bne	nosporbit2
specialorbit:
	tst.w	orbitsoftware
	bpl	nosporbit
	jsr	cleartext
	jsr	interference
	lea	spmsg2,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	move.l	#600000,d7
	jsr	generaldelay
	move.l	#-1,planetdestination
	addq.l	#4,sp
	bra	solarloop
nosporbit:
	jsr	interference
	lea	spmsg3,a0
	bsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	move.l	#600000,d7
	jsr	generaldelay
nosporbit2:
	lea	plan,a0
	moveq	#22,d0
prtcs:	move.b	#' ',(a0)+		;clear out last name
	dbf	d0,prtcs
	lea	plan,a0
	move.l	planetdestination,a6
	add.l	#planetname,a6
ppn:
	move.b	(a6)+,(a0)+
	bpl	ppn
	move.b	#' ',-1(a0)
	jsr	interference
	lea	spmsg1,a0
	bsr	printmany
gb:	jsr	flip_scr2
	jsr	flip_scr2
	move.l	#600000,d7
	jsr	generaldelay
	addq.l	#4,sp
	bra	solarloop
printplaneterror:
	lea	errorsound,a1
	jsr	startsound
	jsr	cleartext
	lea	plertext,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	move.l	#800000,d7
	jsr	generaldelay
	addq.l	#4,sp
	bra	solarloop
putplanet:
	moveq	#0,d0
	move.w	whichplanet,d0
	mulu	#5768,d0
	move.l	generalstore,a0
	add.l	d0,a0
	moveq	#51,d7
	move.l	seen,a1
	add.l	#2656,a1
	bsr	pplop

	moveq	#0,d0
	move.w	whichplanet,d0
	mulu	#5768,d0
	move.l	generalstore,a0
	add.l	d0,a0
	add.l	#56,a0
	moveq	#50,d7
	move.l	seen,a1
	add.l	#2816,a1
pplop:
	rept	14
	move.l	(a0)+,(a1)+
	endr
	lea	56(a0),a0
*	 add.l	 #104+160,a1
	lea	104+160(a1),a1
	move.l	#3000,d0
clined:
	subq.l	#1,d0
	bpl	clined
	dbf	d7,pplop
	rts

dosomestars:
	move.w	#220,d7
dssl:
	move.w	#288,d0
	bsr	randomplus
	add.w	#16,d0
	move.w	d0,pixelx
	move.w	#110,d0
	bsr	randomplus
	add.w	#13,d0
	move.w	d0,pixely
	move.w	#3,d0
	bsr	randomplus
	add.w	#7,d0
	move.w	d0,pixelcolor
	bsr	singleplot
	dbf	d7,dssl
	rts


docrosshairs:
	move.w	#7,linecolor
	move.w	mx,x1
	move.w	mx,x2
	move.w	#mminy,y1
	move.w	#mmaxy,y2
	bsr	clipit
	move.w	my,y1
	move.w	my,y2
	move.w	#mminx,x1
	move.w	#mmaxx,x2
	bsr	clipit
	rts

copytext:
	move.l	hiden,a0
	add.l	#2088,a0
	move.l	screen3,a1
	add.l	#2088,a1
	moveq	#109,d0
copymloop2:
	rept	36
	move.l	(a0)+,(a1)+
	endr
	lea	16(a0),a0
	lea	16(a1),a1
	dbf	d0,copymloop2
	rts
copysolar2:
	lea	solmapmem,a0
	move.l	hiden,a1
	lea	2088(a1),a1
	moveq	#82,d0
	bra.s	copymloop
copysolar:
	lea	solmapmem,a0
	move.l	hiden,a1
	lea	2088(a1),a1
	moveq	#109,d0
	bra.s	copymloop
copymap:
	lea	mapmem,a0
	move.l	hiden,a1
	lea	2088(a1),a1
	moveq	#109,d0
copymloop:
	rept	36
	move.l	(a0)+,(a1)+
	endr
	lea	16(a1),a1
	dbf	d0,copymloop
	rts

copysintomem:
	lea	solmapmem,a1
	move.l	screen3,a0
	add.l	#2088,a0
	moveq	#109,d0
copymloop3:
	rept	36
	move.l	(a0)+,(a1)+
	endr
	lea	16(a0),a0
	dbf	d0,copymloop3
	rts
printmany:
	moveq	#0,d0
	moveq	#0,d1
	move.b	(a0)+,d0
	move.b	(a0)+,d1
	move.w	d0,cursorx
	move.w	d1,cursory
	bsr	putstring
	tst.b	(a0)+
	bpl	printmany
	rts
copyseento3:
	move.l	screen3,a1
	move.l	seen,a0
	add.l	#2088,a1
	add.l	#2088,a0
	moveq	#110,d0
	bra.s	copymloopp
copy3tohid:
	move.l	hiden,a1
	move.l	screen3,a0
	add.l	#2088,a1
	add.l	#2088,a0
	moveq	#110,d0
	bra.s	copymloopp
copypara:
	bsr	clearquickparra
	move.l	screen3,a0
	move.l	hiden,a1
	add.l	#15368,a1
	add.l	#15368,a0
	moveq	#27,d0
copymloopp:
	rept	36
	move.l	(a0)+,(a1)+
	endr
	lea	16(a1),a1
	lea	16(a0),a0
	dbf	d0,copymloopp
	rts
*****************************************
*	input and print entered string	*
*	of d7 chars at current cursor	*
*	location			*
*****************************************
inputstring:
	movem.l d0-d7/a0-a6,-(sp)
	move.w	cursorx,cxsave
	lea	linebuffer,a1
	subq.w	#1,d7		;for dbf
	move.w	d7,d7save
inpsloop:
	bsr	gkey2		;get a key stroke
	tst.b	d0
	bmi	inpsloop
	cmpi.b	#bs,d0
	bne	tcr
	subq.w	#1,cursorx
	move.w	cxsave,d1
	cmp.w	cursorx,d1
	ble	bs1
	move.w	cxsave,cursorx
	lea	linebuffer,a1
	addq.l	#1,a1
	move.w	d7save,d7
	subq.w	#1,d7
bs1:
*	move.b	' ',d0
	subq.l	#1,a1
	move.b	#' ',char
	bsr	text
	addq.w	#2,d7
	bra	bst
tcr:	cmpi.w	#13,d0		;check for carriage return
	beq	inpback
okinp:
	move.b	d0,char
	move.b	d0,(a1)+
	bsr	text
	bsr	advancecursor
bst:	movem.l d0-d7/a0-a6,-(sp)
	bsr	flip_scr2
	bsr	flip_scr2
	movem.l (sp)+,d0-d7/a0-a6
	dbf	d7,inpsloop
inpback:
	move.b	#0,(a1)+		;end string with null
	movem.l (sp)+,d0-d7/a0-a6
	rts

*****************************************
*	puts null terminated string	*
*	into the text mem at cx,cy	*
*****************************************
putstring:
	movem.l d0-d1/a6,-(sp)
putsloop:
	move.b	(a0)+,char
	beq	putsback
ptsl2:
	bsr	text
	bsr	advancecursor
	bra	putsloop
putsback:
	movem.l (sp)+,d0-d1/a6
	rts

*****************************************
*	puts null terminated string	*
*	into the text mem at cx,cy	*
*****************************************
putcharacter:
	movem.l d0-d1/a6,-(sp)
	move.w	cursorx,d0
	bmi	putcback
	move.w	cursory,d1
	bmi	putcback
	cmpi.w	#17,d1
	bge	putcback
	mulu	#47,d1
	add.w	d1,d0		;pos in comptextmem
	lea	computertextmem,a6
	add.w	d0,a6
putcloop:
	move.b	(a0),(a6)
	bsr	advancecursor
putcback:
	movem.l (sp)+,d0-d1/a6
	rts

advancecursor:
	addq.w	#1,cursorx
	cmpi.w	#48,cursorx	;boundry checking and word wrap
	blt	acback
	addq.w	#1,cursory
	move.w	#0,cursorx
	cmpi.w	#17,cursory
	blt	acback
	move.w	#16,cursory
*	bsr	scrollup
acback:
	rts
keysbattle:
	move.l	keybuf,a0
	move.w	6(a0),d0
	cmp.w	8(a0),d0
	bne	ischar2
	rts
ischar2:
	lea	keyclicksound,a1	;soundhere
	jsr	startsound
	move.w	#2,-(sp)
	move.w	#2,-(sp)
	trap	#13
	addq.l	#4,sp
	swap	d0
quit2:
	cmpi.w  #$10,d0
	bne	space2
	bra	gem
space2:
	cmpi.w	#$39,d0
	bne	speed1
	move.w	#1,paused
	bra	pause
speed1:
	cmpi.w	#$3b,d0
	bne	speed2
	move.w	#0,battlespeed
	move.w	#0,battlespeed2
	rts
speed2:
	cmpi.w	#$3c,d0
	bne	speed3
	move.w	#40,battlespeed
	move.w	#10,battlespeed2
	rts
speed3:
	cmpi.w	#$3d,d0
	bne	speed4
	move.w	#80,battlespeed
	move.w	#20,battlespeed2
	rts
speed4:
	cmpi.w	#$3e,d0
	bne	speed5
	move.w	#160,battlespeed
	move.w	#40,battlespeed2
	rts
speed5:
	cmpi.w	#$3f,d0
	bne	ksight
	move.w	#320,battlespeed
	move.w	#80,battlespeed2
	rts
ksight:
	cmpi.w	#$1f,d0
	bne	addrot
	neg.w	sightflag
	rts
addrot:
	cmpi.w	#$4b,d0
	bne	subrot
	addq.w	#1,myrot
	rts
subrot:
	cmpi.w	#$4d,d0
	bne	dkey
	subq.w	#1,myrot
	rts
dkey:
	cmpi.w	#$20,d0
	bne	fwt2
	move.w	#1,dpressed
	rts
fwt2:
	cmpi.w	#$14,d0
	bne	radmagp
	neg.w	flipwithtext
	rts
radmagp:
	cmpi.w	#$4e,d0
	bne	radmagm
	addq.w	#1,radarmag
	rts
radmagm:
	cmpi.w	#$4a,d0
	bne	autodock
	subq.w	#1,radarmag
	rts
autodock:
	cmpi.w	#$1e,d0
	bne	doamat
	cmp.l	#multideckloop,whichbattle
	bne	bkeysb
	tst.w	adsoftware
	bmi.s	bkeysb2
	jsr	cleartext
	jsr	interference
	lea	autodockmsg,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	move.l	#500000,d7
	jsr	generaldelay
	lea	multideck,a0
	move.w	#0,obx(a0)
	move.w	#0,oby(a0)
	move.w	#1000,obz(a0)
	move.w	multirot,d0
	neg.w	d0
	move.w	d0,myrot
	move.w	#1,dpressed
	rts
bkeysb2:
	jsr	cleartext
	jsr	interference
	lea	autodockmsg1,a0
	jsr	printmany
	jsr	flip_scr2
	jsr	flip_scr2
	move.l	#500000,d7
	jsr	generaldelay
	rts

doamat:
	cmpi.w	#$44,d0
	bne	bkeysb
	tst.w	amat
	bmi	bkeysb
	subq.w	#1,amat
	bsr	explodeamat
	rts
bkeysb:
	rts

****************************************
keyboard:
	move.l	keybuf,a0
	move.w	6(a0),d0
	cmp.w	8(a0),d0
	bne	ischar
	rts
ischar:
	lea	keyclicksound,a1	;soundhere
	jsr	startsound
	move.w	#2,-(sp)
	move.w	#2,-(sp)
	trap	#13
	addq.l	#4,sp
	swap	d0
quit:	cmpi.w	#$10,d0
	bne	space
	bra	gem
space:
	cmpi.w	#$39,d0
	bne	c
	move.w	#1,paused
	bra	pause
c:
	cmpi.w	#$2e,d0
	bne	fwt
	addq.l	#4,sp
	bra	shipscomputer
	rts
fwt:
	cmpi.w	#$14,d0
	bne	ksight2
	neg.w	flipwithtext
	rts
ksight2:
	cmpi.w	#$1f,d0
	bne	keyback
	neg.w	sightflag
	rts
keyback:
	move.w	#-1,paused
	rts

*****************************
pause:	
	move.l	keybuf,a0
	move.w	6(a0),d0
	cmp.w	8(a0),d0
	beq	pause
	lea	keyclicksound,a1	;soundhere
	jsr	startsound
	move.w	#2,-(sp)
	move.w	#2,-(sp)
	trap	#13
	addq.l	#4,sp
	swap	d0
	cmpi.w	#$1e,d0
	bne	keyback 
	bsr	gkey
	cmpi.w	#$32,d0
	bne	keyback
	bsr	gkey
	cmpi.w	#$1e,d0
	bne	keyback
	bsr	gkey
	cmpi.w	#$31,d0
	bne	keyback
	bsr	gkey
	cmpi.w	#$20,d0
	bne	keyback
	bsr	gkey
	cmpi.w	#$1e,d0
	bne	keyback
	move.w	#1,cheat
	rts

gkey:
	move.l	keybuf,a0
	move.w	6(a0),d0
	cmp.w	8(a0),d0
	beq	gkey
	lea	keyclicksound,a1	;soundhere
	jsr	startsound
	move.w	#2,-(sp)
	move.w	#2,-(sp)
	trap	#13
	addq.l	#4,sp
	swap	d0
	rts
gkey2:
	movem.l d1-d7/a0-a6,-(sp)
gk3:
	move.l	keybuf,a0
	move.w	6(a0),d0
	cmp.w	8(a0),d0
	beq	gk3
	lea	keyclicksound,a1	;soundhere
	jsr	startsound
	move.w	#2,-(sp)
	move.w	#2,-(sp)
	trap	#13
	addq.l	#4,sp
	swap	d0
	bsr	fitcode
	movem.l (sp)+,d1-d7/a0-a6
	rts
*****************************************
*	massage keyscan codes to fit	*
*	my asscii setup 		*
*****************************************
fitcode:
	lea	mykeys,a0
	subq.w	#1,d0
	moveq	#0,d1
	move.b	(a0,d0.w),d1
	moveq	#0,d0
	move.b	d1,d0
	rts
***********************************
mydocolors:
	move.l	#$ff8240,a1
	rept	8
	move.l	(a0)+,(a1)+
	endr
	rts

*******************************************************************
randomseed:	ADD.L	D0,D1
		MOVEM.L D0/D1,RND
LongRnd:	MOVEM.L D1-D3,-(SP)	
		MOVEM.L RND,D0/D1
		ANDI.B	#$0E,D0
		ORI.B	#$20,D0
		MOVE.L	D0,D2
		MOVE.L	D1,D3
		ADD.L	D2,D2
		ADDX.L	D3,D3
		ADD.L	D2,D0
		ADDX.L	D3,D1
		SWAP	D3
		SWAP	D2
		MOVE.W	D2,D3
		CLR.W	D2
		ADD.L	D2,D0
		ADDX.L	D3,D1
		MOVEM.L D0/D1,RND
		MOVE.L	D1,D0
		MOVEM.L (SP)+,D1-D3
		RTS
random: 	MOVE.w	D2,-(SP)
		MOVE.W	D0,D2
		BEQ.S	r1
		BSR.S	LongRnd
		CLR.W	D0
		SWAP	D0
		ext.l	d0
		DIVs	D2,D0
		CLR.W	D0
		SWAP	D0
r1:		MOVE.w	(SP)+,D2
		RTS

randomplus:	MOVE.w	D2,-(SP)
		MOVE.W	D0,D2
		BEQ.S	r2
		BSR.S	LongRnd
		CLR.W	D0
		SWAP	D0
		DIVu	D2,D0
		CLR.W	D0
		SWAP	D0
r2:		MOVE.w	(SP)+,D2
		RTS
********************************
joydir:
	tst.b	joyport1
	beq	jdback
	move.b	joyport1,d0
north:	cmpi.b	#1,d0
	bne	neast
	move.w	#-nsamount,yvel
	move.w	#0,xvel
	rts
neast:	cmpi.b	#9,d0
	bne	east
	move.w	#-nsamount,yvel
	move.w	#-nsamount,xvel
	rts
east:	cmpi.b	#8,d0
	bne	seast
	move.w	#-nsamount,xvel
	move.w	#0,yvel
	rts
seast:	cmpi.b	#10,d0
	bne	south
	move.w	#nsamount,yvel
	move.w	#-nsamount,xvel
	rts
south:	cmpi.b	#2,d0
	bne	swest
	move.w	#nsamount,yvel
	move.w	#0,xvel
	rts
swest:	cmpi.b	#6,d0
	bne	west
	move.w	#nsamount,yvel
	move.w	#nsamount,xvel
	rts
west:	cmpi.b	#4,d0
	bne	nwest
	move.w	#nsamount,xvel
	move.w	#0,yvel
	rts
nwest:	cmpi.b	#5,d0
	bne	jdback
	move.w	#-nsamount,yvel
	move.w	#nsamount,xvel
	rts
jdback:
	move.w	#0,xvel
	move.w	#0,yvel
	rts
********************************
joydir4:
	tst.b	joyport1
	beq	jdback4
	move.b	joyport1,d0
north4: cmpi.b	#1,d0
	bne	neast4
	move.w	#-nsamount4,yvel
	move.w	#0,xvel
	rts
neast4: cmpi.b	#9,d0
	bne	east4
	move.w	#-nsamount4,yvel
	move.w	#-nsamount4,xvel
	rts
east4:	cmpi.b	#8,d0
	bne	seast4
	move.w	#-nsamount4,xvel
	move.w	#0,yvel
	rts
seast4: cmpi.b	#10,d0
	bne	south4
	move.w	#nsamount4,yvel
	move.w	#-nsamount4,xvel
	rts
south4: cmpi.b	#2,d0
	bne	swest4
	move.w	#nsamount4,yvel
	move.w	#0,xvel
	rts
swest4: cmpi.b	#6,d0
	bne	west4
	move.w	#nsamount4,yvel
	move.w	#nsamount4,xvel
	rts
west4:	cmpi.b	#4,d0
	bne	nwest4
	move.w	#nsamount4,xvel
	move.w	#0,yvel
	rts
nwest4: cmpi.b	#5,d0
	bne	jdback4
	move.w	#-nsamount4,yvel
	move.w	#nsamount4,xvel
	rts
jdback4:
	move.w	#0,xvel
	move.w	#0,yvel
	rts

********************************
joydir2:
	tst.b	joyport1
	beq	jdback2a
	move.b	joyport1,d0
north2: cmpi.b	#1,d0
	bne	neast2
	add.w	#nsamount2,yvel
	move.w	#-yv8,shotyvel8joy
	move.w	#0,shotxvel8joy
	move.w	#0,whichme
	bra.w	jdback2
neast2: cmpi.b	#9,d0
	bne	east2
	add.w	#nsamount2,yvel
	add.w	#nsamount2,xvel
	move.w	#-yv8,shotyvel8joy
	move.w	#xv8,shotxvel8joy
	move.w	#420,whichme
	bra.w	jdback2
east2:	cmpi.b	#8,d0
	bne	seast2
	add.w	#nsamount2,xvel
	move.w	#0,shotyvel8joy
	move.w	#xv8,shotxvel8joy
	move.w	#840,whichme
	bra.w	jdback2
seast2: cmpi.b	#10,d0
	bne	south2
	sub.w	#nsamount2,yvel
	add.w	#nsamount2,xvel
	move.w	#yv8,shotyvel8joy
	move.w	#xv8,shotxvel8joy
	move.w	#1260,whichme
	bra.w	jdback2
south2: cmpi.b	#2,d0
	bne	swest2
	sub.w	#nsamount2,yvel
	move.w	#yv8,shotyvel8joy
	move.w	#0,shotxvel8joy
	move.w	#1680,whichme
	bra.w	jdback2
swest2: cmpi.b	#6,d0
	bne	west2
	sub.w	#nsamount2,yvel
	sub.w	#nsamount2,xvel
	move.w	#yv8,shotyvel8joy
	move.w	#-xv8,shotxvel8joy
	move.w	#2100,whichme
	bra.s	jdback2
west2:	cmpi.b	#4,d0
	bne	nwest2
	sub.w	#nsamount2,xvel
	move.w	#0,shotyvel8joy
	move.w	#-xv8,shotxvel8joy
	move.w	#2520,whichme
	bra.s	jdback2
nwest2: cmpi.b	#5,d0
	bne	jdback2
	add.w	#nsamount2,yvel
	sub.w	#nsamount2,xvel
	move.w	#-yv8,shotyvel8joy
	move.w	#-xv8,shotxvel8joy
	move.w	#2940,whichme
jdback2:
	rts

jdback2a:
	tst.w	xvel
	bmi.s	jdb1
	beq.s	jdb2
	subq.w	#1,xvel
	bra.s	jdb2
jdb1:
	addq.w	#1,xvel
jdb2:
	tst.w	yvel
	bmi.s	jdb3
	beq.s	jdbb
	subq.w	#1,yvel
	rts
jdb3:
	addq.w	#1,yvel
jdbb:
	rts
********************************
joydir3:
	tst.w	adsoftware
	bgt	noneed
	tst.b	joyport1
	beq	jdback3
	move.b	joyport1,d0
north3: cmpi.b	#1,d0
	bne	neast3
	move.w	#-nsamount2,yvel
	move.w	#0,xvel
	rts
neast3: cmpi.b	#9,d0
	bne	east3
	move.w	#-nsamount2,yvel
	move.w	#ewamount2,xvel
	rts
east3:	cmpi.b	#8,d0
	bne	seast3
	move.w	#ewamount2,xvel
	move.w	#0,yvel
	rts
seast3: cmpi.b	#10,d0
	bne	south3
	move.w	#nsamount2,yvel
	move.w	#ewamount2,xvel
	rts
south3: cmpi.b	#2,d0
	bne	swest3
	move.w	#nsamount2,yvel
	move.w	#0,xvel
	rts
swest3: cmpi.b	#6,d0
	bne	west3
	move.w	#nsamount2,yvel
	move.w	#-ewamount2,xvel
	rts
west3:	cmpi.b	#4,d0
	bne	nwest3
	move.w	#-ewamount2,xvel
	move.w	#0,yvel
	rts
nwest3: cmpi.b	#5,d0
	bne	jdback3
	move.w	#-nsamount2,yvel
	move.w	#-ewamount2,xvel
	rts
jdback3:
	move.w	#0,xvel
	move.w	#0,yvel
noneed:
	rts
*****************************************
*	set up joystick handler 	*
*****************************************
joystuff:
	move.w	#34,-(sp)
	trap	#14
	addq.l	#2,sp
	move.l	d0,a0
	adda.l	#24,a0
	move.l	(a0),old_packh		;save the old handler
	move.l	#joy_packet,(a0)	;put in mine
	rts
*****************************************	
*	this is the joy pak handler	*
*****************************************
joy_packet:
	movem.l a0/a1,-(sp)
	lea	joyport0,a1
	move.b	1(a0),(a1)
	move.b	2(a0),1(a1)
	movem.l (sp)+,a0/a1
	rts
res_mouse:
	move.w	#34,-(sp)
	trap	#14
	addq.l	#2,sp
	move.l	d0,a0
	adda.l	#24,a0
	move.l	old_packh,(a0)

rs2:	move.w	#128,-(sp)
	move.w	#4,-(sp)
	move.w	#3,-(sp)
	trap	#13
	addq.l	#6,sp

	move.w	#1,-(sp)
	move.w	#4,-(sp)
	move.w	#3,-(sp)
	trap	#13
	addq.l	#6,sp
	rts
************get screen address***************
getscrn:move.w	#2,-(sp)
	trap	#14
	addq.l	#2,sp
	move.l	d0,screen
	move.l	d0,screen1
	move.l	d0,screen2
	subi.l	#$8000,screen2
	move.l	screen1,seen
	move.l	screen2,hiden
	move.l	screen2,screen3
	subi.l	#$8000,screen3
	move.l	screen3,generalstore
	subi.l	#200000,generalstore
	move.l	#ytable2,ytable
	move.l	#ytable1,sytable
	rts
********************************************
* Atari ST hi-speed plotting subroutine    *
* For Low-resolution mode only		   *
********************************************
plotinit:
	move.l	seen,a0
	move.b	#200,d1
	lea	ytable1,a1
iloop:
	move.l	a0,(a1)+
	adda.w	#160,a0
	subq.b	#1,d1
	bne	iloop

	move.l	hiden,a0
	move.b	#200,d1
	lea	ytable2,a1

iloop2:
	move.l	a0,(a1)+
	adda.w	#160,a0
	subq.b	#1,d1
	bne	iloop2
	rts
*********************************************************
mygetpix:
*	movem.l	d1-d3/a1,-(sp)
	move.w	pixelx,d0
	move.w	d0,d3
	andi.w	#15,d3
	move.w	pixely,d1
	lsl.w	#2,d1
	lsr.w	#1,d0
	and.w	#$00f8,d0
	move.w	d0,a0
	move.l	ytable,a1
	adda.l	(a1,d1.w),a0

	move.w #$8000,d1
	lsr.w d3,d1
	moveq	#0,d0		;zero result register
	move.w	(a0),d3
	and.w	d1,d3
	beq.s	bit0b
	move.w	#1,d0
bit0b:
	move.w	2(a0),d3
	and.w	d1,d3
	beq.s	bit0c
	or.w	#2,d0
bit0c:
	move.w	4(a0),d3
	and.w	d1,d3
	beq.s	bit0d
	or.w	#4,d0
bit0d:
	move.w	6(a0),d3
	and.w	d1,d3
	beq.s	getx0
	or.w	#8,d0
getx0:
*	movem.l	(sp)+,d1-d3/a1
	rts


**********************************************
putcoords:
	move.w	pixelx,(a0)+
	move.w	pixely,(a0)+
	rts

singleplot3:
	movem.l d0-d5/a0-a1,-(sp)
	move.w	pixelx,d0
	cmp.w	#cxmax,d0
	bgt	pltxit3
	cmpi.w	#cxmin,d0
	blt	pltxit3
	move.w	d0,d3
	andi.w	#15,d3
	move.w	pixely,d1
	cmp.w	#cymax,d1
	bgt	pltxit2
	cmpi.w	#cymin,d1
	blt	pltxit2
	lsl.w	#2,d1
	move.w	pixelcolor,d2

	lsr.w	#1,d0
	and.w	#$00f8,d0
	move.w	d0,a0
	move.l	ytable,a1
	adda.l	(a1,d1.w),a0

	move.w #$8000,d4
	lsr.w d3,d4
	move.l #$80008000,d5
	lsr.l d3,d5
	eor.l #$ffffffff,d5
	bra	myphere

singleplot2:
	movem.l d0-d5/a0-a1,-(sp)
	move.w	pixelx,d0
	cmp.w	#cxmax,d0
	bgt	pltxit2
	cmpi.w	#cxmin,d0
	blt	pltxit2
	move.w	d0,d3
	andi.w	#15,d3
	move.w	pixely,d1
	cmp.w	#cymax,d1
	bgt	pltxit2
	cmpi.w	#cymin,d1
	blt	pltxit2
	lsl.w	#2,d1
	move.w	pixelcolor,d2

	lsr.w	#1,d0
	and.w	#$00f8,d0
	move.w	d0,a0
	move.l	sytable,a1
	adda.l	(a1,d1.w),a0

	move.w #$8000,d4
	lsr.w d3,d4
	move.l #$80008000,d5
	lsr.l d3,d5
	eor.l #$ffffffff,d5
	bra	myphere

**********************************************
singleplotr:
	movem.l d0-d5/a0-a1,-(sp)
	move.w	pixelx,d0
	cmp.w	#191,d0
	bgt	pltxit
	cmpi.w	#128,d0
	blt	pltxit
	move.w	d0,d3
	andi.w	#15,d3
	move.w	pixely,d1
	cmp.w	#197,d1
	bgt	pltxit
	cmpi.w	#149,d1
	blt	pltxit
	lsl.w	#2,d1
	move.w	pixelcolor,d2

	lsr.w	#1,d0
	and.w	#$00f8,d0
	move.w	d0,a0
	move.l	ytable,a1
	adda.l	(a1,d1.w),a0

	move.w #$8000,d4
	lsr.w d3,d4
	move.l #$80008000,d5
	lsr.l d3,d5
	eor.l #$ffffffff,d5
	bra	myphere
**********************************************
singleplot:
	movem.l d0-d5/a0-a1,-(sp)
	move.w	pixelx,d0
	cmp.w	#cxmax,d0
	bgt	pltxit
	cmpi.w	#cxmin,d0
	blt	pltxit
	move.w	d0,d3
	andi.w	#15,d3
	move.w	pixely,d1
	cmp.w	#cymax,d1
	bgt	pltxit
	cmpi.w	#cymin,d1
	blt	pltxit
	lsl.w	#2,d1
	move.w	pixelcolor,d2

	lsr.w	#1,d0
	and.w	#$00f8,d0
	move.w	d0,a0
	move.l	ytable,a1
	adda.l	(a1,d1.w),a0

	move.w #$8000,d4
	lsr.w d3,d4
	move.l #$80008000,d5
	lsr.l d3,d5
	eor.l #$ffffffff,d5
	bra	myphere

**************************************
* PLOT A PIXEL WITH MY ROUTINE	     *
*				     *
* CALL WITH:			     *
* myplot(X,Y,COLOR)		     *
**************************************
doubleplot:
	movem.l d0-d5/a0-a1,-(sp)
	move.w	pixelx,d0
	cmp.w	#cxmax-1,d0
	bcc	pltxit
	cmpi.w	#cxmin+1,d0
	blt	pltxit
	move.w	d0,d3
	andi.w	#15,d3
	move.w	pixely,d1
	cmp.w	#cymax,d1
	bgt	pltxit
	cmpi.w	#cymin,d1
	blt	pltxit
	lsl.w	#2,d1
	move.w	pixelcolor,d2

	lsr.w	#1,d0
	and.w	#$00f8,d0
	move.w	d0,a0
	move.l	ytable,a1
	adda.l	(a1,d1.w),a0
	cmpi.w	#15,d3
	beq	singlepix
	move.w	#$c000,d4
	lsr.w	d3,d4
	move.l	#$c000c000,d5
	lsr.l	d3,d5
	eor.l	#$ffffffff,d5
	bra	myphere

singlepix:
	move.w #$8000,d4
	lsr.w d3,d4
	move.l #$80008000,d5
	lsr.l d3,d5
	eor.l #$ffffffff,d5
	and.l d5,(a0)
	and.l d5,4(a0)
spec2:
	btst #0,d2
	beq bbit2
	or.w d4,(a0)
bbit2:
	btst #1,d2
	beq bbit4
	or.w d4,2(a0)
bbit4:
	btst #2,d2
	beq bbit8
	or.w d4,4(a0)
bbit8:
	btst #3,d2
	beq mysec
	or.w d4,6(a0)

mysec:
	addq.l	#8,a0
	move.w #$8000,d4
	move.l #$80008000,d5
	eor.l #$ffffffff,d5
******************************
*    Turn off old pixel!     *
******************************
myphere:
	and.l d5,(a0)	     ;turn off old pixel
	and.l d5,4(a0)	     ;(both longwords)

******************************
* Now turn on the new pixel! *
******************************
	btst #0,d2
	beq bit2
	or.w d4,(a0)
bit2:
	btst #1,d2
	beq bit4
	or.w d4,2(a0)
bit4:
	btst #2,d2
	beq bit8
	or.w d4,4(a0)
bit8:
	btst #3,d2
	beq pltxit
	or.w d4,6(a0)
pltxit:
	movem.l (sp)+,d0-d5/a0-a1
	rts
pltxit2:
	movem.l (sp)+,d0-d5/a0-a1
	moveq	#-1,d0
	rts
pltxit3:
	movem.l (sp)+,d0-d5/a0-a1
	moveq	#-2,d0
	rts

*************************************
clearquickparra:
	move.l	hiden,a0
	adda.l	#2088,a0
	moveq	#82,d0
	move.l	#$ffff0000,d7
	moveq	#0,d6
	bra.s	cl2loop
clearquick:
	move.l	hiden,a0
	adda.l	#2088,a0
	moveq	#110,d0
	move.l	#$ffff0000,d7
	moveq	#0,d6
cl2loop:
	rept	18
	move.l	d7,(a0)+
	move.l	d6,(a0)+
	endr
	lea	16(a0),a0
	dbf	d0,cl2loop
cqb:	rts

copytextbit:
	move.l	hiden,a0
	lea	15368(a0),a0
	lea	compscreenmem,a1
	lea	3024(a1),a1
	moveq	#27,d0
	moveq	#0,d6
	bra.s	cl2loop2
clearquick2:
	move.l	hiden,a0
	adda.l	#2088,a0
	lea	compscreenmem,a1
	moveq	#111,d0
	moveq	#0,d6
cl2loop2:
	rept	18
	move.w	(a1)+,d5
	moveq	#-1,d7
	or.w	d5,d7
	move.w	d7,(a0)+	;text plane
	move.w	d5,(a0)+
	move.w	d6,(a0)+
	move.w	d5,(a0)+
	endr
	lea	16(a0),a0
	dbf	d0,cl2loop2
	rts


flip_scr4:
	move.l	seen,d1
	move.l	d1,d2
	add.l	#4000,d1
	add.l	#18000,d2
skloop4:
	move.l	#$ff8205,a0
	moveq	#0,d0
	move.b	(a0),d0
	asl.l	#8,d0
	addq.l	#2,a0
	move.b	(a0),d0
	asl.l	#8,d0
	addq.l	#2,a0
	move.b	(a0),d0
	cmp.l	d1,d0
	blt.s	skloop4
	cmp.l	d2,d0
	bgt.s	skloop4

	move.l	seen,A6
	move.l	hiden,seen
	move.l	A6,hiden
	move.l	sytable,A6
	move.l	ytable,sytable
	move.l	A6,ytable
	bsr	copypara
	move.b	seen+1,$ff8201
	move.b	seen+2,$ff8203
	rts
flip_scrdock:
	move.l	seen,d1
	move.l	d1,d2
	add.l	#4000,d1
	add.l	#18000,d2
skloopd:
	move.l	#$ff8205,a0
	moveq	#0,d0
	move.b	(a0),d0
	asl.l	#8,d0
	addq.l	#2,a0
	move.b	(a0),d0
	asl.l	#8,d0
	addq.l	#2,a0
	move.b	(a0),d0
	cmp.l	d1,d0
	blt.s	skloopd
	cmp.l	d2,d0
	bgt.s	skloopd

	move.l	seen,A6
	move.l	hiden,seen
	move.l	A6,hiden
	move.l	sytable,A6
	move.l	ytable,sytable
	move.l	A6,ytable
	bsr	copy3tohid
	move.b	seen+1,$ff8201
	move.b	seen+2,$ff8203
	rts
flip_scr:
	tst.w	flipwithtext
	bpl	flip_scr2
	move.l	seen,d1
	move.l	d1,d2
	add.l	#8000,d1
	add.l	#24000,d2
skloop:
	move.l	#$ff8205,a0
	moveq	#0,d0
	move.b	(a0),d0
	asl.l	#8,d0
	addq.l	#2,a0
	move.b	(a0),d0
	asl.l	#8,d0
	addq.l	#2,a0
	move.b	(a0),d0
	cmp.l	d1,d0
	blt.s	skloop
	cmp.l	d2,d0
	bgt.s	skloop
	move.l	seen,A6
	move.l	hiden,seen
	move.l	A6,hiden
	move.l	sytable,A6
	move.l	ytable,sytable
	move.l	A6,ytable
	bsr	clearquick
	move.b	seen+1,$ff8201
	move.b	seen+2,$ff8203
	rts
flip_scr3:
	move.l	seen,d1
	move.l	d1,d2
	add.l	#4000,d1
	add.l	#18000,d2
skloop3:
	move.l	#$ff8205,a0
	moveq	#0,d0
	move.b	(a0),d0
	asl.l	#8,d0
	addq.l	#2,a0
	move.b	(a0),d0
	asl.l	#8,d0
	addq.l	#2,a0
	move.b	(a0),d0
	cmp.l	d1,d0
	blt.s	skloop3
	cmp.l	d2,d0
	bgt.s	skloop3

	move.l	seen,A6
	move.l	hiden,seen
	move.l	A6,hiden
	move.l	sytable,A6
	move.l	ytable,sytable
	move.l	A6,ytable
	move.b	seen+1,$ff8201
	move.b	seen+2,$ff8203
	rts



flip_scr2:
	subq.w	#1,flipwithtext
	move.l	seen,d1
	move.l	d1,d2
	add.l	#4000,d1
	add.l	#8000,d2
skloop2:
	move.l	#$ff8205,a0
	moveq	#0,d0
	move.b	(a0),d0
	asl.l	#8,d0
	addq.l	#2,a0
	move.b	(a0),d0
	asl.l	#8,d0
	addq.l	#2,a0
	move.b	(a0),d0
	cmp.l	d1,d0
	blt.s	skloop2
	cmp.l	d2,d0
	bgt.s	skloop2
	move.l	seen,A6
	move.l	hiden,seen
	move.l	A6,hiden
	bsr	clearquick2
	move.l	sytable,A6
	move.l	ytable,sytable
	move.l	A6,ytable
	move.b	seen+1,$ff8201
	move.b	seen+2,$ff8203
	rts
flip_scrsol:
	move.l	seen,d1
	move.l	d1,d2
	add.l	#8000,d1
	add.l	#14000,d2
skloopsol:
	move.l	#$ff8205,a0
	moveq	#0,d0
	move.b	(a0),d0
	asl.l	#8,d0
	addq.l	#2,a0
	move.b	(a0),d0
	asl.l	#8,d0
	addq.l	#2,a0
	move.b	(a0),d0
	cmp.l	d1,d0
	blt.s	skloopsol
	cmp.l	d2,d0
	bgt.s	skloopsol
	move.l	seen,A6
	move.l	hiden,seen
	move.l	A6,hiden
	move.l	sytable,A6
	move.l	ytable,sytable
	move.l	A6,ytable
	bsr.s	copyplanet
	move.b	seen+1,$ff8201
	move.b	seen+2,$ff8203
	rts

copyplanet:
	move.l	planetmem1,a0
	move.l	hiden,a1
	lea	2088(a1),a1
	moveq	#20,d0		;number of lines to copy
	moveq	#0,d1		;amount to add to a0(ie number of lines
	bsr	copyplanetline	;to skip)
	moveq	#10,d0
	move.w	#144,d1
	bsr	copyplanetline
	moveq	#5,d0
	move.w	#144*2,d1
	bsr	copyplanetline
	moveq	#3,d0
	move.w	#144*3,d1
	bsr	copyplanetline
	moveq	#2,d0
	move.w	#144*4,d1
	bsr	copyplanetline
	moveq	#1,d0
	move.w	#144*5,d1
	bsr	copyplanetline
	bra	doover
copyplanetline:
	rept	36
	move.l	(a0)+,(a1)+
	endr
	add.w	d1,a0
	lea	16(a1),a1
	dbf	d0,copyplanetline
	rts
*****************************************
*  Now we put the curvy bit over it	*
*****************************************
doover:
	lea	planetoverlay,a0
	lea	planetmask,a1
	move.l	hiden,a2
	add.l	#8808,a2
	moveq	#4,d7
overlay:
	rept	18
	move.w	(a1)+,d0
	eor.w	#-1,d0
	move.w	(a2),d1
	move.w	2(a2),d2
	move.w	4(a2),d3
	move.w	6(a2),d4
	and.w	d0,d1
	and.w	d0,d2
	and.w	d0,d3
	and.w	d0,d4
	or.w	(a0)+,d1
	or.w	(a0)+,d2
	or.w	(a0)+,d3
	or.w	(a0)+,d4
	move.w	d1,(a2)+
	move.w	d2,(a2)+
	move.w	d3,(a2)+
	move.w	d4,(a2)+
	endr

	lea	16(a2),a2
	dbf	d7,overlay
	moveq	#7,d7
cploop2:
	rept	36
	move.l	(a0)+,(a2)+
	endr
	lea	16(a2),a2
	dbf	d7,cploop2
	move.l	a2,a0
	move.l	#$ffff0000,d7
	moveq	#0,d6
	moveq	#55,d0
	bra	cl2loop
	rts


framevbl:
	tst.w	paused
	bpl.s	nosubhyp
	subq.w	#1,hypercount
nosubhyp:
	move.l	whichpalette,a0
	bsr	mydocolors
	bsr	dovblcolors
	bsr	flashcursor
	subq.w	#1,prtdelay
	bpl.s	noprt
	move.w	#3,prtdelay
	bsr	doreadouts
noprt:
	jmp	dosound	
	rts
doreadouts:
	move.w	shipsfuel,number
	move.w	#24968,numwhere
	bsr	prtnumboth
	move.w	credits,number
	move.w	#29160,numwhere
	bsr	prtnumboth
	move.w	amat,number
	addq.w	#1,number
	move.w	#25064,numwhere
	bsr	prtnumboth
	rts

stch:
	move.w	buttondat,d0
	cmp.w	lastb,d0
	beq	nochange
	move.w	#-1,changestate
	move.w	d0,lastb
	rts
nochange:
	move.w	#1,changestate
	rts
flashcursor:
	tst.w	cursoronoff
	bmi	fcb
	subq.w	#1,cfdelay
	bpl	fcb
	move.w	#12,cfdelay
	move.w	cursorx,d0
	move.w	cursory,d1
	move.w	d0,d2
	add.w	d0,d0
	lsl.w	#2,d2
	add.w	d2,d0
	add.w	#16,d0		;gives actual screen coord
	mulu	#7,d1
	add.w	#13,d1
	and.l	#$ffff,d0
	and.l	#$ffff,d1
	bsr	calcvsa
	moveq	#6,d0
	lea	cursor,a1
floop:
	moveq	#0,d3
	move.w	(a1)+,d3
	ror.l	d2,d3
	eor	d3,2(a0)
	eor	d3,6(a0)
	swap	d3
	eor	d3,10(a0)
	eor	d3,14(a0)
	lea	160(a0),a0
	dbf	d0,floop
fcb:
	rts
dovblcolors:
	tst.w	dontpulse
	bpl	dvbc3
	lea	pulsecolors,a0
	move.w	pulsecount1,d0
	move.w	(a0,d0.w),$ff825e
	addq.w	#2,pulsecount1
	cmpi.w	#2,pulsecount1
	ble	dvbc2
	move.w	#0,pulsecount1
dvbc2:
	lea	pulsecolors2,a0
	move.w	pulsecount2,d0
	move.w	(a0,d0.w),$ff825c
	addq.w	#2,pulsecount2
	cmpi.w	#26,pulsecount2
	ble	dvbc3
	move.w	#0,pulsecount2
dvbc3:
	rts
*****************************************
prtnumboth:
	movem.l d0/d6/d7/a0/a5/a1/a2,-(sp)
	move.w	#0,times
	moveq	#0,d7
	moveq	#4,d0
	move.w	number,d7
	bge.s	numok
	moveq	#0,d7
numok:	andi.l	#$ffff,d7
	lea	lineout,a5
dodecb:
	move.l	d7,d6
	divu	#10,d6
	move.w	d6,d7
	swap	d6
	move.b	d6,(a5)+
	subq.w	#1,d0
	tst.w  d7
	bne	dodecb
	tst.w	d0
	bmi	outb
blankloopb:
	move.b	#10,(a5)+
	dbf	d0,blankloopb
outb:
	cmpa.l	#lineout,a5
	beq	decbackb
	moveq	#0,d7
	move.b	-(a5),d7
	subq.w	#1,d6
	lea	smallnumbers,a0
	mulu	#44,d7
	add.w	d7,a0
	moveq	#10,d0
	move.l	seen,a1
	move.l	hiden,a2
	adda.w	numwhere,a1
	adda.w	numwhere,a2
oloopb:
	move.b	(a0),(a1)
	move.b	(a0)+,(a2)
	move.b	(a0),2(a1)
	move.b	(a0)+,2(a2)
	move.b	(a0),4(a1)
	move.b	(a0)+,4(a2)
	move.b	(a0),6(a1)
	move.b	(a0)+,6(a2)
	lea	160(a1),a1
	lea	160(a2),a2
	dbf	d0,oloopb
	addq.w	#1,times
	cmpi.w	#2,times
	blt	ohb
	move.w	#0,times
	addq.w	#6,numwhere
ohb:	addq.w	#1,numwhere
	bra	outb
decbackb:
	movem.l (sp)+,d0/d6/d7/a0/a5/a1/a2
	rts
*****************************************
prtnum: 
	movem.l d0/d6/d7/a0/a5/a1,-(sp)
	move.w	#0,times
	moveq	#0,d7
	moveq	#4,d0
	move.w	number,d7
	andi.l	#$ffff,d7
	lea	lineout,a5
dodec2:
	move.l	d7,d6
	divu	#10,d6
	move.w	d6,d7
	swap	d6
	move.b	d6,(a5)+
	subq.w	#1,d0
	tst.w  d7
	bne	dodec2
	tst.w	d0
	bmi	out2
blankloop:
	move.b	#10,(a5)+
	dbf	d0,blankloop
out2:
	cmpa.l	#lineout,a5
	beq	decback2
	moveq	#0,d7
	move.b	-(a5),d7
	subq.w	#1,d6
*	 andi.w  #$ff,d7
	lea	smallnumbers,a0
	mulu	#44,d7
	add.w	d7,a0
	moveq	#10,d0
	move.l	hiden,a1
	adda.w	numwhere,a1
oloop2:
	move.b	(a0)+,(a1)
	move.b	(a0)+,2(a1)
	move.b	(a0)+,4(a1)
	move.b	(a0)+,6(a1)
*	 add.l	 #160,a1
	lea	160(a1),a1
	dbf	d0,oloop2
	addq.w	#1,times
	cmpi.w	#2,times
	blt	oh2
	move.w	#0,times
	addq.w	#6,numwhere
oh2:	addq.w	#1,numwhere
	bra	out2
decback2:
	movem.l (sp)+,d0/d6/d7/a0/a5/a1
	rts

prtnum2:
	movem.l d0-d7/a0-a6,-(sp)
	moveq	#0,d7
	move.w	number,d7
	andi.l	#$ffff,d7
	lea	lineout,a5
	move.b	#32,(a5)
	move.b	#32,1(a5)
	move.b	#32,2(a5)
	move.b	#32,3(a5)
	move.b	#32,4(a5)
	move.b	#32,5(a5)
	cmpi.w	#10,d7
	bge	prtn2
	addq.l	#1,a5
	bra	dodec22
prtn2:
	cmpi.w	#100,d7
	bge	prtn3
	addq.l	#2,a5
	bra	dodec22
prtn3:
	cmpi.w	#1000,d7
	bge	prtn4
	addq.l	#3,a5
	bra	dodec22
prtn4:
	cmpi.w	#10000,d7
	bge	prtn5
	addq.l	#4,a5
	bra	dodec22
prtn5:
	addq.l	#5,a5
dodec22:
	move.l	d7,d6
	divu	#10,d6
	move.w	d6,d7
	swap	d6
	add.b	#48,d6
	move.b	d6,-(a5)
	tst.w	d7
	bne	dodec22
	movem.l (sp)+,d0-d7/a0-a6
	rts

******************************************
*		RETURN TO GEM
gem:
	bsr	restoremfp
gem2:
	move.b	#%11111110,$ff820a
	move.w	#$0777,$ff8240
	move.w	#$0000,$ff8242
	move.w	#$0000,$ff8244
	move.w	#$0000,$ff8246

	jsr	res_mouse
	move.b	save484,$484

	move.w	#34,-(sp)
	trap	#14
	addq.l	#2,sp
	move.l	d0,a0
	move.l	oldmouse,16(a0)

	move.w	ressave,-(sp)
	move.l	screen,-(sp)
	move.l	screen,-(sp)
	move.w	#5,-(sp)
	trap	#14
	add.l	#12,sp

*	move.l	rvsave,$426
*	move.l	resave,$42a
	move.l	trappoke+2,$84

keyover:
	move.l	savesup,-(SP)	 ;Back to user mode
	move.w	#$20,-(SP)
	trap	#1
	addq.l	#6,(SP)

	clr.w	-(sp)
	trap	#1

*********************************************************
*	my routines for loading in the screens		*
*********************************************************
loadscr:
	move.b	oldieb,ieb
	move	#0,-(SP)
	move.l	filename,-(SP)
	move	#$3D,-(SP)
	trap	#1
	addq.l	#8,SP
	tst.w	d0
	bmi	nofile
	move.l	hiden,-(SP)
	move.l	#32000,-(SP)
	move	D0,-(SP)
	move	#$3F,-(SP)
	trap	#1
	add.l	 #12,SP
	move	#$3E,-(SP)
	trap	#1
	addq.l	#2,SP
	and.b	#$df,ieb
	move.l	hiden,a0
	move.l	a0,a1
stl:
	move.b	(a1)+,d0
	bne	stl
	move.l	screen3,a2	;where to put it
decom:
	move.l	a2,a3
	moveq	#39,d0
	move.l	#199,d1
	moveq	#0,d2
	move.b	(a0)+,d2
	subq.l	#1,d2
	move.b	(a1)+,d3
	lsl.l	#8,d3
	move.b	(a1)+,d3
	lsl.l	#8,d3
	move.b	(a1)+,d3
	lsl.l	#8,d3
	move.b	(a1)+,d3
	moveq	#4,d7
boucle:
	move.l	d3,(a2)
	dbra	d2,encore
	moveq	#0,d2
	move.b	(a0)+,d2
	subq.l	#1,d2
	move.b	(a1)+,d3
	lsl.l	#8,d3
	move.b	(a1)+,d3
	lsl.l	#8,d3
	move.b	(a1)+,d3
	lsl.l	#8,d3
	move.b	(a1)+,d3
encore:
	lea	160(a2),a2
	dbra	d1,boucle
	adda.l	d7,a3
	move.l	a3,a2
	move.l	#199,d1
	dbra	d0,boucle
nofile:
	rts
********************************************************
loadfile:
	move.b	oldieb,ieb
	move	#0,-(SP)
	move.l	filename,-(SP)
	move	#$3D,-(SP)
	trap	#1
	addq.l	#8,SP
		
	move.w	d0,-(sp)
	move.l	wheretoload,-(SP)
	move.l	lengthtoread,-(SP)
	move	D0,-(SP)
	move	#$3F,-(SP)
	trap	#1
	add.l	 #12,SP

	move	#$3E,-(SP)
	trap	#1
	addq.l	#4,SP
	and.b	#$df,ieb
	rts

loadfilep:
	move	#0,-(SP)
	move.l	filename,-(SP)
	move	#$3D,-(SP)
	trap	#1
	addq.l	#8,SP
		
	move.w	d0,-(sp)
	move.l	wheretoload,-(SP)
	move.l	lengthtoread,-(SP)
	move	D0,-(SP)
	move	#$3F,-(SP)
	trap	#1
	add.l	 #12,SP

	move	#$3E,-(SP)
	trap	#1
	addq.l	#4,SP
	rts


mytrap:
l0006:	movea.l	sp,a0
	btst	#$0d-8,(sp)
	bne.s	l0007
	move	usp,a0
	subq.l	#6,a0
l0007:	addq.l	#6,a0
	cmpi.w	#$3f,(a0)
	beq.s	l000a
trappoke:
l0008:	jmp	$00
l000a:	move.l	8(a0),freespace+$78
	move.l	2(sp),l000c+2
	move.l	#l000b,2(sp)
	bra.s	l0008
l000b:	tst.w	2(sp)
	bmi.s	l000c
	movea.l	freespace+$78(pc),a0
	bsr.s	l000e
l000c:	jmp	$00
l000e:	movem.l	d0-a6,-(sp)

	lea	0(a0,d0.l),a5
	bsr.s	l0017
	cmpi.l	#'SYSJ',d7
	bne.s	l0012
	adda.w	#$78,a0
	bsr.s	l0017
	move.l	d7,(sp)
	lea	0(a0,d7.l),a6
	movea.l	a6,a3
	movea.l	a6,a1
	lea	freespace+$78(pc),a2
	moveq	#$77,d0
l000f:	move.b	-(a1),-(a2)
	dbra	d0,l000f
	bsr.s	l0017
	bsr.s	l0013
	move.l	(sp),d0
	lea	-120(a0),a1
l0010:	move.b	(a0)+,(a1)+
	dbra	d0,l0010
	subi.l	#$010000,d0
	bpl.s	l0010
	moveq	#$77,d0
	lea	freespace+$78(pc),a2
l0011:	move.b	-(a2),-(a3)
	dbra	d0,l0011
l0012:	movem.l	(sp)+,d0-a6
	rts
l0013:	bsr.s	l001b
	bcc.s	l0016
	moveq	#0,d1
	bsr.s	l001b
	bcc.s	l0015
	lea	l0028(pc),a1
	moveq	#3,d3
l0014:	move.l	-(a1),d0
	bsr.s	l001e
	swap	d0
	cmp.w	d0,d1
	dbne	d3,l0014
	add.l	16(a1),d1
l0015:	move.b	-(a5),-(a6)
	dbra	d1,l0015
l0016:
	cmpa.l	a0,a6
	bgt.s	l0020
	rts
l0017:	moveq	#3,d0
l0018:	move.b	-(a5),d7
	ror.l	#8,d7
	dbra	d0,l0018
	rts
l0019:	move.w	a5,d7
	btst	#0,d7
	bne.s	l001a
	move.l	-(a5),d7
	addx.l	d7,d7
	addx.w	d1,d1
	dbra	d0,l001f
	rts
l001a:	move.l	-5(a5),d7
	lsl.l	#8,d7
	move.b	-(a5),d7
	subq.l	#3,a5
	add.l	d7,d7
	bset	#0,d7
	addx.w	d1,d1
	dbra	d0,l001f
	rts
l001b:	add.l	d7,d7
	beq.s	l001c
	rts
l001c:	move.w	a5,d7
	btst	#0,d7
	bne.s	l001d
	move.l	-(a5),d7
	addx.l	d7,d7
	rts
l001d:	move.l	-5(a5),d7
	lsl.l	#8,d7
	move.b	-(a5),d7
	subq.l	#3,a5
	add.l	d7,d7
	bset	#0,d7
	rts
l001e:	moveq	#0,d1
l001f:	add.l	d7,d7
	beq.s	l0019
	addx.w	d1,d1
	dbra	d0,l001f
	rts
l0020:	lea	l0029(pc),a1
	moveq	#3,d2
l0021:	bsr.s	l001b
	dbcc	d2,l0021
	moveq	#0,d4
	moveq	#0,d1
	move.b	1(a1,d2.w),d0
	ext.w	d0
	bmi.s	l0022
	bsr.s	l001e
l0022:	move.b	6(a1,d2.w),d4
	add.w	d1,d4
	beq.s	l0024
	lea	l002a(pc),a1
	moveq	#1,d2
l0023:	bsr.s	l001b
	dbcc	d2,l0023
	moveq	#0,d1
	move.b	1(a1,d2.w),d0
	ext.w	d0
	bsr.s	l001e
	add.w	d2,d2
	add.w	6(a1,d2.w),d1
	bra.s	l0026
l0024:	moveq	#0,d1
	moveq	#5,d0
	moveq	#0,d2
	bsr.s	l001b
	bcc.s	l0025
	moveq	#8,d0
	moveq	#$40,d2
l0025:	bsr.s	l001e
	add.w	d2,d1
l0026:	lea	2(a6,d4.w),a1
	adda.w	d1,a1
	move.b	-(a1),-(a6)
l0027:	move.b	-(a1),-(a6)
	dbra	d4,l0027
	bra	l0013



*************puts my mouse interupt in***************** 
putrout:move.w	#34,-(sp)
	trap	#14
	addq.l	#2,sp
	move.l	d0,a0
	move.l	16(a0),oldmouse
	move.l	#myrout,16(a0)
	rts

**************my ubeut mouse interupt*******************
myrout:
	movem.l d0-d2/a0-a1,-(sp)
	moveq	#0,d0	
	move.b	(a0),d0
	cmpi.b	#$fa,d0
	bne	myr1
	move.w	#1,buttondat
	bra	myrxy
myr1:
	cmpi.b	#$f9,d0
	bne	myr2
	move.w	#2,buttondat
	bra	myrxy
myr2:
	cmpi.b	#$fb,d0
	bne	myr3
	move.w	#3,buttondat
	bra	myrxy
myr3:
	move.w	#0,buttondat

myrxy:
	moveq	#0,d0
	move.b	1(a0),d0
	ext.w	d0
	moveq	#0,d1
	move.b	2(a0),d1
	ext.w	d1
	add.w	d0,mx
	add.w	d1,my
myr4:	move.w	mx,d0
	move.w	my,d1
	bsr	extra
	move.w	d0,mx
	move.w	d1,my
	movem.l (sp)+,d0-d2/a0-a1
	rts

extra:	cmpi.w	#mminx,d0
	bge	extra1
	move.w	#mminx,d0
	bra	extra2
extra1: cmpi.w	 #mmaxx,d0
	ble	extra2
	move.w	#mmaxx,d0
extra2: cmpi.w	#mminy,d1
	bge	extra3
	move.w	#mminy,d1
	bra	extra4
extra3: cmpi.w	 #mmaxy,d1
	ble	extra4
	move.w	#mmaxy,d1
extra4:
	rts

*********************************************************
*	New sprite routine				*
*	New version give ad of sprite structure in A0	*
*********************************************************
putsprite:
	move.w	(a0),d2
	move.w	d2,d0
	move.w	2(a0),d1
	and.w	#15,d2
	move.l	whichscreen,a6
	lsl.w	#5,d1
	add.w	d1,a6
	lsl.w	#2,d1
	add.w	d1,a6
	and.w	#$fff0,d0
	lsr.w	#1,d0
	add.w	d0,a6
	move.l	a6,a2
*************CODE TO ROTATE A SPRITE IMAGE***********************
shiftimages:
	move.w	4(a0),d1
	move.l	10(a0),a1
	lea	gtemp,a2
ssi1:
	move.w	6(a0),d0
	clr.l	(a2)
	clr.l	4(a2)
ssi0:	
	moveq	#0,d4
	moveq	#0,d5
	moveq	#0,d6
	moveq	#0,d7
	move.w	(a1)+,d4
	move.w	(a1)+,d5
	move.w	(a1)+,d6
	move.w	(a1)+,d7
	ror.l	d2,d4
	ror.l	d2,d5
	ror.l	d2,d6
	ror.l	d2,d7
	or.w	d4,(a2)+
	or.w	d5,(a2)+
	or.w	d6,(a2)+
	or.w	d7,(a2)+
	swap	d4
	swap	d5
	swap	d6
	swap	d7
	move.w	d4,(a2)
	move.w	d5,2(a2)
	move.w	d6,4(a2)
	move.w	d7,6(a2)
	dbf	d0,ssi0
	addq.l	#8,a2
	dbf	d1,ssi1

smake_mask:
	move.w	4(a0),d1
	lea	gtemp,a1
	lea	gmask,a2
smm1:
	move.w	6(a0),d0
	addq.w	#1,d0
smm0:	move.w	(a1)+,d2
	or.w	(a1)+,d2
	or.w	(a1)+,d2
	or.w	(a1)+,d2
	move.w	d2,d3
	swap	d2
	move.w	d3,d2
	eor.l	#-1,d2
	move.l	d2,(a2)+
	dbf	d0,smm0
	dbf	d1,smm1

*********code to put sprite on screen********************
sdraw:
	move.w	4(a0),d1
	lea	gtemp,a1
	lea	gmask,a2
	move.l	a6,a3
sdi1:	move.w	6(a0),d0
	addq.w	#1,d0
	move.l	a6,a5
sdi0:	move.l	(a2)+,d3
	move.l	(a1)+,d6
	move.l	(a1)+,d7
	move.l	(a3)+,d4
	move.l	(a3)+,d5
	and.l	d3,d4
	and.l	d3,d5
	or.l	d6,d4
	or.l	d7,d5
	move.l	d4,(a5)+
	move.l	d5,(a5)+
	dbf	d0,sdi0
	lea	160(a6),a6
	add.w	8(a0),a3
	dbf	d1,sdi1
	rts

*****************************************
*	neg means char unavailable	*
*****************************************
mykeys:
	dc.b	-1,'1','2','3','4','5','6','7','8','9','0'
	dc.b	-1,-1,bs,-1,'Q','W','E','R','T','Y','U','I'
	dc.b	'O','P',-1,-1,13,-1,'A','S','D','F','G','H'
	dc.b	'J','K','L',';',-1,-1,-1,-1,'Z','X','C','V'
	dc.b	'B','N','M',-1,'.','/',-1,-1,-1,' ',-1,-1
	dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
	dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
	dc.b	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
	dc.b	-1,-1,-1,'/',-1,'7','8','9','4','5','6','1','2','3','0','.'
	dc.b	13,-1,-1,-1
mon:	dc.b	$08
moff:	dc.b	$12
otherscreen1:	dc.b	0
otherscreen2:	dc.b	0
shiftsave:
	dc.b	0
	even
specscreen1:	dc.l	0
specscreen2:	dc.l	0
colortable1:	dc.l	0
colortable2:	dc.l	0

thisis26a:
	dc.l	0,0
thisis272:
	dc.l	0,0
vblsave:
	dc.l	0,0
savecolors:
	dc.w	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
otherpalette:	dc.l	0

hr:		dc.w	-1	;once only
currentsad:	dc.l	0
soundend:	dc.l	0
soundstart:	dc.l	0
mysr:
	dc.w	0

SND_OUT:
	DC.W	$80C,$90B,$A09,0,$80C,$90B,$A09,0
	DC.W	$80D,$908,$A08,0,$80B,$90B,$A0B,0
	DC.W	$80D,$909,$A05,0,$80C,$90B,$A08,0
	DC.W	$80D,$909,$A02,0,$80D,$908,$A06,0
	DC.W	$80C,$90B,$A07,0,$80D,$907,$A07,0
	DC.W	$80C,$90B,$A06,0,$80C,$90A,$A09,0
	DC.W	$80B,$90B,$A0A,0,$80C,$90B,$A02,0
	DC.W	$80C,$90B,$A00,0,$80C,$90A,$A08,0

	DC.W	$80D,$906,$A04,0,$80D,$905,$A05,0
	DC.W	$80D,$905,$A04,0,$80C,$909,$A09,0
	DC.W	$80D,$904,$A03,0,$80B,$90B,$A09,0
	DC.W	$80C,$90A,$A05,0,$80B,$90A,$A0A,0
	DC.W	$80C,$909,$A08,0,$80B,$90B,$A08,0
	DC.W	$80C,$90A,$A00,0,$80C,$90A,$A00,0
	DC.W	$80C,$909,$A07,0,$80B,$90B,$A07,0
	DC.W	$80C,$909,$A06,0,$80B,$90B,$A06,0

	DC.W	$80B,$90A,$A09,0,$80B,$90B,$A05,0
	DC.W	$80A,$90A,$A0A,0,$80B,$90B,$A02,0
	DC.W	$80B,$90A,$A08,0,$80C,$907,$A07,0
	DC.W	$80C,$908,$A04,0,$80C,$907,$A06,0
	DC.W	$80B,$909,$A09,0,$80C,$906,$A06,0
	DC.W	$80A,$90A,$A09,0,$80C,$907,$A03,0
	DC.W	$80B,$90A,$A05,0,$80B,$909,$A08,0
	DC.W	$80B,$90A,$A03,0,$80A,$90A,$A08,0

	DC.W	$80B,$90A,$A00,0,$80B,$909,$A07,0
	DC.W	$80B,$908,$A08,0,$80A,$90A,$A07,0
	DC.W	$80A,$909,$A09,0,$80C,$901,$A01,0
	DC.W	$80A,$90A,$A06,0,$80B,$908,$A07,0
	DC.W	$80A,$90A,$A05,0,$80A,$909,$A08,0
	DC.W	$80A,$90A,$A02,0,$80A,$90A,$A01,0
	DC.W	$80A,$90A,$A00,0,$809,$909,$A09,0
	DC.W	$80A,$908,$A08,0,$80B,$908,$A01,0

	DC.W	$80A,$909,$A06,0,$80B,$907,$A04,0
	DC.W	$80A,$909,$A05,0,$809,$909,$A08,0
	DC.W	$80A,$909,$A03,0,$80A,$908,$A06,0
	DC.W	$80A,$909,$A00,0,$809,$909,$A07,0
	DC.W	$809,$908,$A08,0,$80A,$908,$A04,0
	DC.W	$809,$909,$A06,0,$80A,$908,$A01,0
	DC.W	$809,$909,$A05,0,$809,$908,$A07,0
	DC.W	$808,$908,$A08,0,$809,$909,$A02,0

	DC.W	$809,$908,$A06,0,$809,$909,$A00,0
	DC.W	$809,$907,$A07,0,$808,$908,$A07,0
	DC.W	$809,$907,$A06,0,$809,$908,$A02,0
	DC.W	$808,$908,$A06,0,$809,$906,$A06,0
	DC.W	$808,$907,$A07,0,$808,$908,$A04,0
	DC.W	$808,$907,$A06,0,$808,$908,$A02,0
	DC.W	$807,$907,$A07,0,$808,$906,$A06,0
	DC.W	$808,$907,$A04,0,$807,$907,$A06,0

	DC.W	$808,$906,$A05,0,$808,$906,$A04,0
	DC.W	$807,$906,$A06,0,$807,$907,$A04,0
	DC.W	$808,$905,$A04,0,$806,$906,$A06,0
	DC.W	$807,$906,$A04,0,$807,$905,$A05,0
	DC.W	$806,$906,$A05,0,$806,$906,$A04,0
	DC.W	$806,$905,$A05,0,$806,$906,$A02,0
	DC.W	$806,$905,$A04,0,$805,$905,$A05,0
	DC.W	$806,$905,$A02,0,$805,$905,$A04,0

	DC.W	$805,$904,$A04,0,$805,$905,$A02,0
	DC.W	$804,$904,$A04,0,$804,$904,$A03,0
	DC.W	$804,$904,$A02,0,$804,$903,$A03,0
	DC.W	$803,$903,$A03,0,$803,$903,$A02,0
	DC.W	$803,$902,$A02,0,$802,$902,$A02,0
	DC.W	$802,$902,$A01,0,$801,$901,$A01,0
	DC.W	$802,$901,$A00,0,$801,$901,$A00,0
	DC.W	$801,$900,$A00,0,$800,$900,$A00,0

	DC.W	$80E,$90D,$A0C,0,$80F,$903,$A00,0
	DC.W	$80F,$903,$A00,0,$80F,$903,$A00,0
	DC.W	$80F,$903,$A00,0,$80F,$903,$A00,0
	DC.W	$80F,$903,$A00,0,$80E,$90D,$A0B,0
	DC.W	$80E,$90D,$A0B,0,$80E,$90D,$A0B,0
	DC.W	$80E,$90D,$A0B,0,$80E,$90D,$A0B,0
	DC.W	$80E,$90D,$A0B,0,$80E,$90D,$A0B,0
	DC.W	$80E,$90D,$A0A,0,$80E,$90D,$A0A,0

	DC.W	$80E,$90D,$A0A,0,$80E,$90D,$A0A,0
	DC.W	$80E,$90C,$A0C,0,$80E,$90D,$A00,0
	DC.W	$80D,$90D,$A0D,0,$80D,$90D,$A0D,0
	DC.W	$80D,$90D,$A0D,0,$80D,$90D,$A0D,0
	DC.W	$80D,$90D,$A0D,0,$80D,$90D,$A0D,0
	DC.W	$80E,$90C,$A0B,0,$80E,$90C,$A0B,0
	DC.W	$80E,$90C,$A0B,0,$80E,$90C,$A0B,0
	DC.W	$80E,$90C,$A0B,0,$80E,$90C,$A0B,0

	DC.W	$80E,$90C,$A0B,0,$80E,$90C,$A0B,0
	DC.W	$80E,$90C,$A0A,0,$80E,$90C,$A0A,0
	DC.W	$80E,$90C,$A0A,0,$80E,$90C,$A0A,0
	DC.W	$80D,$90D,$A0C,0,$80D,$90D,$A0C,0
	DC.W	$80E,$90C,$A09,0,$80E,$90C,$A09,0
	DC.W	$80E,$90C,$A05,0,$80E,$90C,$A00,0
	DC.W	$80E,$90C,$A00,0,$80E,$90B,$A0B,0
	DC.W	$80E,$90B,$A0B,0,$80E,$90B,$A0B,0

	DC.W	$80E,$90B,$A0B,0,$80E,$90B,$A0A,0
	DC.W	$80E,$90B,$A0A,0,$80E,$90B,$A0A,0
	DC.W	$80D,$90D,$A0B,0,$80D,$90D,$A0B,0
	DC.W	$80D,$90D,$A0B,0,$80E,$90B,$A09,0
	DC.W	$80E,$90B,$A09,0,$80E,$90B,$A09,0
	DC.W	$80D,$90C,$A0C,0,$80D,$90D,$A0A,0
	DC.W	$80E,$90B,$A07,0,$80E,$90B,$A00,0
	DC.W	$80E,$90B,$A00,0,$80D,$90D,$A09,0

	DC.W	$80D,$90D,$A09,0,$80E,$90A,$A09,0
	DC.W	$80D,$90D,$A08,0,$80D,$90D,$A07,0
	DC.W	$80D,$90D,$A04,0,$80D,$90D,$A00,0
	DC.W	$80E,$90A,$A04,0,$80E,$909,$A09,0
	DC.W	$80E,$909,$A09,0,$80D,$90C,$A0B,0
	DC.W	$80E,$909,$A08,0,$80E,$909,$A08,0
	DC.W	$80E,$909,$A07,0,$80E,$908,$A08,0
	DC.W	$80E,$909,$A01,0,$80C,$90C,$A0C,0

	DC.W	$80D,$90C,$A0A,0,$80E,$908,$A06,0
	DC.W	$80E,$907,$A07,0,$80E,$908,$A00,0
	DC.W	$80E,$907,$A05,0,$80E,$906,$A06,0
	DC.W	$80D,$90C,$A09,0,$80E,$905,$A05,0
	DC.W	$80E,$904,$A04,0,$80D,$90C,$A08,0
	DC.W	$80D,$90B,$A0B,0,$80E,$900,$A00,0
	DC.W	$80D,$90C,$A06,0,$80D,$90C,$A05,0
	DC.W	$80D,$90C,$A02,0,$80C,$90C,$A0B,0

	DC.W	$80C,$90C,$A0B,0,$80D,$90B,$A0A,0
	DC.W	$80D,$90B,$A0A,0,$80D,$90B,$A0A,0
	DC.W	$80D,$90B,$A0A,0,$80C,$90C,$A0A,0
	DC.W	$80C,$90C,$A0A,0,$80C,$90C,$A0A,0
	DC.W	$80D,$90B,$A09,0,$80D,$90B,$A09,0
	DC.W	$80D,$90A,$A0A,0,$80D,$90A,$A0A,0
	DC.W	$80D,$90A,$A0A,0,$80C,$90C,$A09,0
	DC.W	$80C,$90C,$A09,0,$80C,$90C,$A09,0

	DC.W	$80D,$90B,$A06,0,$80C,$90B,$A0B,0
	DC.W	$80C,$90C,$A08,0,$80D,$90B,$A00,0
	DC.W	$80D,$90B,$A00,0,$80C,$90C,$A07,0
	DC.W	$80C,$90C,$A06,0,$80C,$90C,$A05,0
	DC.W	$80C,$90C,$A03,0,$80C,$90C,$A01,0
	DC.W	$80C,$90B,$A0A,0,$80D,$90A,$A05,0
	DC.W	$80D,$90A,$A04,0,$80D,$90A,$A02,0
	DC.W	$80D,$909,$A08,0,$80D,$909,$A08,0

**************************************
*       MFP/FREQUENCY TABLE          *
**************************************
	EVEN
FREQTAB:
	DC.W	$0506	;4.9 KHZ
	DC.W	$0505	;7.68 KHZ
	DC.W	$0405	;9.6 KHZ
	DC.W	$2901	;14.99 KHZ
	DC.W	$1F01	;19.8 KHZ
	DC.W	$0802	;30.7 KHZ
	DC.W	$0106	;DUMMY	
	DC.W	$0106	;DUMMY

**************************************
*	DEFINE PROGRAM STORAGE       *
**************************************
MFPMEM:	
	dc.l	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
old200:	dc.l	0


keyclicksound:
	dc.w	$000E,$FFF2,$0001,$FFFF,$FFFF
	dc.w	$0080,$0000,$0000,$0000,$0001
	dc.w	$0000,$0000,$000A,$0001,$0003
	dc.w	$0008,$0000,$0001,$0009,$0000
errorsound:
	dc.w	$000E,$FFF2,$000F,$FFFF,$FFFF
	dc.w	$0000,$000B,$0003,$001C,$0001
	dc.w	$0001,$0000,$000C,$0000,$0004
	dc.w	$0009,$0002,$0003,$0012,$0001
navsound:
	dc.w	$0009,$FFF3,$002d,$FFFF,$FFFF
	dc.w	$0000,$0002,$0002,$00E0,$0001
	dc.w	$0001,$0000,$000A,$0000,$0004
	dc.w	$0009,$0002,$0003,$0012,$0001
tradesound:
	dc.w	$0007,$FFF1,$001F,$0002,$0002
	dc.w	$0000,$0001,$0004,$00A2,$0000
	dc.w	$0002,$0000,$000A,$0000,$0005
	dc.w	$000A,$0004,$0005,$0024,$0002
shiptrade1:
	dc.w	$0000,$0000,$001F,$0000,$0000
	dc.w	$0000,$0000,$0006,$0078,$0001
	dc.w	$0000,$008F,$0016,$0001,$0003
	dc.w	$0008,$0000,$0001,$0009,$0000
shiptrade2:
	dc.w	$000E,$0001,$00FC,$000a,$000a
	dc.w	$0000,$0000,$0006,$0078,$0001
	dc.w	$0000,$008F,$0016,$0001,$0003
	dc.w	$0008,$0000,$0001,$0009,$0000
starthypersound:
	dc.w	$000a,$FFF1,$0081,$FFFF,$FFFF
	dc.w	$0000,$0000,$0000,$0055,$0001
	dc.w	$0000,$0000,$000A,$0000,$0003
	dc.w	$0008,$0000,$0001,$0009,$0000
endhypersound:
	dc.w	$000a,$FFF1,$0081,$FFFF,$FFFF
	dc.w	$0000,$0000,$0000,$0056,$0001
	dc.w	$0000,$0000,$000A,$0000,$0003
	dc.w	$0008,$0000,$0001,$0009,$0000
standardlasersound:
	dc.w	$000E,$0001,$001F,$0002,$0002
	dc.w	$0080,$0001,$0000,$008E,$0001
	dc.w	$0000,$0000,$000A,$0000,$0003
	dc.w	$0008,$0000,$0001,$0009,$0000
tubeexplodesound:
	dc.w	$000E,$0001,$0040,$0006,$0006
	dc.w	$0044,$000F,$0003,$007A,$0001
	dc.w	$0001,$009A,$000C,$0000,$0004
	dc.w	$0009,$0002,$0003,$0012,$0001
tubeconstantsound:
	dc.w	$0009,$FFF1,$0000,$FFFF,$FFFF
	dc.w	$0000,$0008,$0005,$000C,$0000
	dc.w	$0002,$0000,$000C,$0001,$0005
	dc.w	$000A,$0004,$0005,$0024,$0002
mehitsound:
	dc.w	$000E,$0001,$007E,$000E,$000E
	dc.w	$00C0,$0000,$0003,$000D,$0001
	dc.w	$0001,$0090,$000C,$0000,$0004
	dc.w	$0009,$0002,$0003,$0012,$0001
meshoot2sound:
	dc.w	$000E,$0001,$000E,$0001,$0001
	dc.w	$0060,$0000,$0000,$0096,$0080
	dc.w	$0000,$0000,$000A,$0000,$0003
	dc.w	$0008,$0000,$0001,$0009,$0000
exploparasound:
	dc.w	$000E,$0001,$003F,$0006,$0006
	dc.w	$00FE,$0000,$0003,$0001,$0080
	dc.w	$0001,$0000,$000C,$0000,$0004
	dc.w	$0009,$0002,$0003,$0012,$0001
laser1sound:
	dc.w	$000D,$FFF1,$0019,$FFFF,$FFFF
	dc.w	$00A0,$000F,$0000,$0000,$0001
	dc.w	$0000,$0000,$000A,$0001,$0003
	dc.w	$0008,$0000,$0001,$0009,$0000
laser2sound:
	dc.w	$000D,$FFF1,$0019,$FFFF,$FFFF
	dc.w	$0080,$000F,$0004,$0000,$0001
	dc.w	$0002,$0000,$000A,$0001,$0005
	dc.w	$000A,$0004,$0005,$0024,$0002
passingsound:
	dc.w	$0000,$0002,$001F,$FFFF,$FFFF
	dc.w	$0000,$0000,$0006,$0001,$0080
	dc.w	$0001,$0001,$0016,$0001,$0004
	dc.w	$0009,$0002,$0003,$0012,$0001
extrawepsound:
	dc.w	$000E,$0001,$003F,$0005,$0005
	dc.w	$0039,$0000,$0004,$0040,$0050
	dc.w	$0002,$0000,$000A,$0000,$0005
	dc.w	$000A,$0004,$0005,$0024,$0002
endofparasound:
	dc.w	$000E,$0001,$00FF,$000E,$000E
	dc.w	$00FF,$0001,$0000,$00F6,$0088
	dc.w	$0000,$0000,$000A,$0001,$0003
	dc.w	$0008,$0000,$0001,$0009,$0000
searchsound:
	dc.w	$0009,$FFF1,$0000,$0000,$0000
	dc.w	$0000,$0000,$0006,$005B,$0000
	dc.w	$0000,$0015,$0016,$0001,$0003
	dc.w	$0008,$0000,$0001,$0009,$0000
interferencesound:
	dc.w	$000E,$FFF2,$000F,$FFFF,$FFFF
	dc.w	$0000,$0000,$0002,$0000,$0001
	dc.w	$0001,$0001,$000A,$0000,$0004
	dc.w	$0009,$0002,$0003,$0012,$0001
energydrainsound:
	dc.w	$000C,$FFF3,$001F,$FFFF,$FFFF
	dc.w	$0000,$0000,$0006,$005B,$0001
	dc.w	$0002,$0015,$0016,$0000,$0005
	dc.w	$000A,$0004,$0005,$0024,$0002
hitdoorsound:
	dc.w	$000E,$0001,$000F,$0000,$0000
	dc.w	$0000,$0000,$0004,$0042,$0040
	dc.w	$0002,$0000,$000A,$FFFF,$0005
	dc.w	$000A,$0004,$0005,$0024,$0002
robotshootsound:
	dc.w	$000E,$0001,$001F,$0002,$0002
	dc.w	$0010,$0000,$0002,$0003,$0005
	dc.w	$0001,$0001,$000A,$0000,$0004
	dc.w	$0009,$0002,$0003,$0012,$0001
meshootdecksound:
	dc.w	$000E,$0001,$000F,$0002,$0002
	dc.w	$0000,$0000,$0000,$000A,$0001
	dc.w	$0000,$0001,$000A,$0001,$0003
	dc.w	$0008,$0000,$0001,$0009,$0000
dooropensound:
	dc.w	$0009,$FFF1,$0000,$FFFF,$FFFF
	dc.w	$0000,$0000,$0003,$000C,$0000
	dc.w	$0001,$0000,$000C,$0001,$0004
	dc.w	$0009,$0002,$0003,$0012,$0001
multi1sound:
	dc.w	$000E,$0001,$00FF,$000D,$000D
	dc.w	$0000,$0000,$0006,$0039,$00C0
	dc.w	$0001,$0021,$0016,$0001,$0004
	dc.w	$0009,$0002,$0003,$0012,$0001
multi2sound:
	dc.w	$000E,$0001,$007F,$000E,$000E
	dc.w	$0000,$0001,$0000,$00C1,$0000
	dc.w	$0000,$0000,$000A,$0000,$0003
	dc.w	$0008,$0000,$0001,$0009,$0000
leavemultisound:
	dc.w	$0000,$0002,$00FF,$0008,$0008
	dc.w	$0000,$0000,$0006,$0091,$0080
	dc.w	$0000,$0080,$0016,$0001,$0003
	dc.w	$0008,$0000,$0001,$0009,$0000



channel0params:
		rept	20
		dc.w	0
		endr
channel1params:
		rept	20
		dc.w	0
		endr
channel2params:
		rept	20
		dc.w	0
		endr

enemylist:
	dc.w	10		;number of enemies
	dc.l	ship1text,obian1
	dc.w	150,900
	dc.l	boxtext,box
	dc.w	200,1200
	dc.l	mettext,met1
	dc.w	250,1300
	dc.l	minetext,warp1
	dc.w	150,750
	dc.l	mine2text,multideck
	dc.w	220,1500
	dc.l	credtext,credob
	dc.w	150,900
	dc.l	fueltext,fuelob
	dc.w	150,800
	dc.l	evitext,eviob
	dc.w	150,800
	dc.l	bubtext,bubob
	dc.w	150,800
	dc.l	amattext,amatob
	dc.w	150,800

commandlevel1:
		dc.b	16
		dc.b	16,'ANALYSE EVIDENCE',0,0
		DC.B	4,'ANEV',0,0
		dc.b	10,'SHIP STATS',0,1
		DC.B	4,'SHIP',0,1
		DC.B	5,'ENEMY',0,2
		dc.b	11,'ENEMY STATS',0,2
		dc.b	15,'STORAGE OPTIONS',0,3
		DC.B	4,'DISK',0,3
		DC.B	7,'NAVCOMP',0,4
		dc.b	15,'NAVIGATION COMP',0,4
		dc.b	4,'QUIT',0,5
		DC.B	15,'HYPERSPACE JUMP',0,6
		DC.B	5,'HYPER',0,6
		dc.b	4,'HELP',0,7
		DC.B	19,'INTERPSYSTEM FLIGHT',0,8
		DC.B	8,'INTERSYS',0,8
errorstring1:	dc.b	'OPTION  NOT AVAILABLE',0
errorstring2:	dc.b	'AT THIS COMMAND LEVEL',0
	even
branches:
		dc.l	analyser
		dc.l	shipstats
		dc.l	enemyinfo
		dc.l	diskstuff
		dc.l	mapping
		dc.l	gem
		DC.L	hyperstars
		dc.l	help
		dc.l	intersol

prtdelay:	dc.w	0
donewarn:	dc.w	-1
hostile:	dc.w	-1
dltframe:	dc.w	0
doorhits:	dc.w	0
dltsave:	dc.l	0
dltdelay:	dc.w	0
dltmemcount:	dc.l	0
wheretoload:	dc.l	0
lengthtoread:	dc.l	0
dpressed:	dc.w	-1
battlespeed2:	dc.w	0
radarvpb:	ds.w	20
finalcount:	dc.w	-999
multirot:	dc.w	0
myrot:		dc.w	0
starcount:	dc.w	0
hspeed: 	dc.w	0
whichrout:	dc.l	hyploops
hypercount:	dc.w	1000
whichbattle:	dc.l	0
explosionframe: 	dc.w	1
explosionlist:
		dc.l	explosion14,explosion13,explosion12,explosion11
		dc.l	explosion10,explosion9,explosion8,explosion7
		dc.l	explosion6,explosion5,explosion4,explosion3
		dc.l	explosion2,explosion1
addlist1:
	dc.w	0,-3,10,17,22,28,33,39,44,50,55,61,67,72,78,83
addlist2:
	dc.w	0,2,7,11,14,18,21,25,28,32,35,39,42,46,49,53

pexp1:	dc.w	0,0	;x,y
	dc.w	0	;expansion
	dc.w	0	;frame
pexp2:	dc.w	0,0	;x,y
	dc.w	0	;expansion
	dc.w	0	;frame
pexp3:	dc.w	0,0	;x,y
	dc.w	0	;expansion
	dc.w	0	;frame
startmask:
	dc.w	$ffff,$7fff,$3fff,$1fff
	dc.w	$0fff,$07ff,$03ff,$01ff
	dc.w	$00ff,$007f,$003f,$001f
	dc.w	$000f,$0007,$0003,$0001
	dc.w	$0000
endmask:
	dc.w	$0000,$8000,$c000,$e000
	dc.w	$f000,$f800,$fc00,$fe00
	dc.w	$ff00,$ff80,$ffc0,$ffe0
	dc.w	$fff0,$fff8,$fffc,$fffe
	dc.w	$ffff
savesup:	dc.l	0
ressave:	dc.w	0
filename:	dc.l	0
expansion:	dc.w	1
spritex:	dc.w	160
spritey:	dc.w	50
fcoltable1:
	dc.w	0,0,0,0
fcoltable2:
	dc.w	0,0,0,0
col_table:
		DC.w	  00,00,00,00	  ;Colour 0
		DC.w	  $aaaa,00,00,00     ;Colour 1
		DC.w	  00,$aaaa,00,00     ;Colour 2
		DC.w	  $aaaa,$aaaa,00,00	;Colour 3
		DC.w	  00,00,$aaaa,00     ;Colour 4	      
		DC.w	  $aaaa,00,$aaaa,00	;Colour 5	 
		DC.w	  00,$aaaa,$aaaa,00	;Colour 6	 
		DC.w	  $aaaa,$aaaa,$aaaa,00	   ;Colour 7	    
		DC.w	  00,00,00,$aaaa     ;Colour 8	      
		DC.w	  $aaaa,00,00,$aaaa	;Colour 9
		DC.w	  00,$aaaa,00,$aaaa	;Colour 10
		DC.w	  $aaaa,$aaaa,00,$aaaa	   ;Colour 11
		DC.w	  00,00,$aaaa,$aaaa	;Colour 12
		DC.w	  $aaaa,00,$aaaa,$aaaa	   ;Colour 13
		DC.w	  00,$aaaa,$aaaa,$aaaa	   ;Colour 14	    
		DC.w	  $aaaa,$aaaa,$aaaa,$aaaa     ;Colour 15
col_table2:
		DC.w	  00,00,00,00	  ;Colour 0
		DC.w	  $5555,00,00,00     ;Colour 1
		DC.w	  00,$5555,00,00     ;Colour 2
		DC.w	  $5555,$5555,00,00	;Colour 3
		DC.w	  00,00,$5555,00     ;Colour 4	      
		DC.w	  $5555,00,$5555,00	;Colour 5	 
		DC.w	  00,$5555,$5555,00	;Colour 6	 
		DC.w	  $5555,$5555,$5555,00	   ;Colour 7	    
		DC.w	  00,00,00,$5555     ;Colour 8	      
		DC.w	  $5555,00,00,$5555	;Colour 9
		DC.w	  00,$5555,00,$5555	;Colour 10
		DC.w	  $5555,$5555,00,$5555	   ;Colour 11
		DC.w	  00,00,$5555,$5555	;Colour 12
		DC.w	  $5555,00,$5555,$5555	   ;Colour 13
		DC.w	  00,$5555,$5555,$5555	   ;Colour 14	    
		DC.w	  $5555,$5555,$5555,$5555     ;Colour 15
whichme:	dc.w	0
shot18way:	dc.w	-1	;active
		dc.w	0,0	;x,y
		dc.w	0,0	;xvel,yvel
shotxvel8joy:	dc.w	4
shotyvel8joy:	dc.w	4
expstars:	dc.l	0
enlist:
	dc.l	enemy1,enemy2,enemy3,enemy4,enemy5
	dc.l	enemy6,enemy7,enemy8,enemy9,enemy10
whichattack:	dc.w	0
released:	dc.w	0
deceased:	dc.w	0
enemyadlist:
	dc.l	enemyad1,enemyad2,enemyad3,enemyad4
	dc.l	enemyad5,enemyad6,enemyad7
enemyheightlist:
	dc.w	8,8,8,8,16,16,16
wepdelay:	dc.w	0
laser1: 	dc.w	0,0	;laser x y
		dc.w	-1	;laserlife
laser2: 	dc.w	0,0	;laser x y
		dc.w	-1	;laserlife
laser3: 	dc.w	0,0	;laser x y
		dc.w	-1	;laserlife
enemyad1:	dc.l	0
enemyad2:	dc.l	0
enemyad3:	dc.l	0
enemyad4:	dc.l	0
enemyad5:	dc.l	0
enemyad6:	dc.l	0
enemyad7:	dc.l	0
*********************************************************
*	clipped sprite header				*
*********************************************************
obj1sp:
	dc.w	50,50
	dc.l	0
	dc.w	16
	dc.w	16
	dc.w	-1
	dc.w	0,0
	dc.w	20
	dc.w	0,0
obj2sp:
	dc.w	50,50
	dc.l	0
	dc.w	16
	dc.w	16
	dc.w	-1
obj3sp:
	dc.w	50,50
	dc.l	0
	dc.w	16
	dc.w	16
	dc.w	-1
obj4sp:
	dc.w	50,50
	dc.l	0
	dc.w	16
	dc.w	16
	dc.w	-1

dummyship:
	dc.w	160-8,58-8
	dc.l	0
	dc.w	16
	dc.w	16
	dc.w	1

shipsprite0:
	dc.w	50,50
	dc.l	0
	dc.w	8
	dc.w	16
	dc.w	-1
shipsprite1:
	dc.w	0,0
	dc.l	0
	dc.w	8
	dc.w	16
	dc.w	-1
shotsprite1:
	dc.w	0,0
	dc.l	0
	dc.w	4
	dc.w	16
	dc.w	-1
	dc.w	0,0
shotsprite2:
	dc.w	0,0
	dc.l	0
	dc.w	4
	dc.w	16
	dc.w	-1
	dc.w	0,0
shotsprite3:
	dc.w	0,0
	dc.l	0
	dc.w	4
	dc.w	16
	dc.w	-1
	dc.w	0,0
shotsprite4:
	dc.w	0,0
	dc.l	0
	dc.w	4
	dc.w	16
	dc.w	-1
	dc.w	0,0
package2:
	dc.w	0,0
	dc.l	0
	dc.w	16
	dc.w	16
	dc.w	-1
	dc.w	0
enemy1:
	dc.w	0,0
	dc.l	0
	dc.w	8
	dc.w	16
	dc.w	-1
	dc.w	0,0
	dc.w	0
	dc.w	0,0
enemy2:
	dc.w	0,0
	dc.l	0
	dc.w	8
	dc.w	16
	dc.w	-1
	dc.w	0,0
	dc.w	0
	dc.w	0,0
enemy3:
	dc.w	0,0
	dc.l	0
	dc.w	8
	dc.w	16
	dc.w	-1
	dc.w	0,0
	dc.w	0
	dc.w	0,0
enemy4:
	dc.w	0,0
	dc.l	0
	dc.w	8
	dc.w	16
	dc.w	-1
	dc.w	0,0
	dc.w	0
	dc.w	0,0
enemy5:
	dc.w	0,0
	dc.l	0
	dc.w	8
	dc.w	16
	dc.w	-1
	dc.w	0,0
	dc.w	0
	dc.w	0,0
enemy6:
	dc.w	0,0
	dc.l	0
	dc.w	8
	dc.w	16
	dc.w	-1
	dc.w	0,0
	dc.w	0
	dc.w	0,0
enemy7:
	dc.w	0,0
	dc.l	0
	dc.w	8
	dc.w	16
	dc.w	-1
	dc.w	0,0
	dc.w	0
	dc.w	0,0
enemy8:
	dc.w	0,0
	dc.l	0
	dc.w	8
	dc.w	16
	dc.w	-1
	dc.w	0,0
	dc.w	0
	dc.w	0,0
enemy9:
	dc.w	0,0
	dc.l	0
	dc.w	8
	dc.w	16
	dc.w	-1
	dc.w	0,0
	dc.w	0
	dc.w	0,0
enemy10:
	dc.w	0,0
	dc.l	0
	dc.w	8
	dc.w	16
	dc.w	-1
	dc.w	0,0
	dc.w	0
	dc.w	0,0

tcursorsprite:
	dc.w	50,50
	dc.l	0
	dc.w	8
	dc.w	16
	dc.w	-1

scrollx:	dc.w	0
scrolly:	dc.w	0
scrollx2:	dc.w	0
scrolly2:	dc.w	0
scrollamount:	dc.w	0
scrollamount2:	dc.w	4
scrollamount3:	dc.w	14
scrollamount4:	dc.w	8
scrollamount5:	dc.w	8
cursorx:	dc.w	0
cursory:	dc.w	0
hbllist:
	dc.w	$0007,1,$0005,6,$0007,1,$0005,110,$0004
	dc.w	4,$0005,3,$0004,1,$0333,2,$0555,13,-1,200
	dc.w	$0444,1,$0666,1,$0777,1,$0555,1,$0444
	dc.w	1,$0333,1,$0555,1,$0333,6,$0555,9,$0444
	dc.w	1,$0666,1,$0777,1,$0555,1,$0444,1,$0333
	dc.w	1,$0555,1,$0333,6,$0555,13
hblsave:	dc.l	0
oldvblvec:	dc.l	0
oldkeyvec:	dc.l	0
oldhblvec:	dc.l	0
sqvel:	dc.w	0
battlelaser:	dc.w	0
shot1vels:	dc.w	0,0,bshotspeed,0
shot2vels:	dc.w	0,0,bshotspeed,0
shot3vels:	dc.w	0,0,bshotspeed,0
shot4vels:	dc.w	0,0,bshotspeed,0
sidesx: 	dc.w	-50
shotdelay:	dc.w	2
xvel:		dc.w	0
yvel:		dc.w	0
tilt:		dc.w	0
yoffs:		dc.w	560
whichman:
whichob:	dc.l	ship3
ox:	dc.w	0
oy:	dc.w	0
oz:	dc.w	0
ox2:	dc.w	0
oy2:	dc.w	0
oz2:	dc.w	0
tiltadd:	dc.w	0
mytheta:	dc.w	0
myphi:		dc.w	0
myrho:		dc.w	0
kx:	dc.w	0
px:	dc.w	0
ky:	dc.w	0
py:	dc.w	0
kz:	dc.w	0
pz:	dc.w	0
rx:	dc.w	0
ry:	dc.w	0
rz:	dc.w	0
hdf:		dc.w	0
numfacesave:	dc.w	0
facepoints:	dc.w	0
facecolor1:	dc.w	0
facecolor2:	dc.w	0
cbits:		dc.w	0
cbits2: 	dc.w	0
xsav:		dc.w	0
ysav:		dc.w	0
dump:		dc.w	0
gradient:
	dc.w	0
x1:	dc.w	0
x2:	dc.w	0
y1:	dc.w	0
y2:	dc.w	0
dx:	dc.w	0
dy:	dc.w	0
plx:	dc.w	0
ply:	dc.w	0
plz:	dc.w	0
myviewx:	dc.w	0
myviewy:	dc.w	0
sin_vt: dc.w	0,804,1608,2411
	dc.w	3212,4011,4808,5602
	dc.w	6393,7180,7962,8740
	dc.w	9512,10279,11039,11793
	dc.w	12540,13279,14010,14733
	dc.w	15447,16151,16846,17531
	dc.w	18205,18868,19520,20160
	dc.w	20788,21403,22006,22595
	dc.w	23170,23732,24279,24812
	dc.w	25330,25832,26320,26791
	dc.w	27246,27684,28106,28511
	dc.w	28899,29269,29622,29957
	dc.w	30274,30572,30853,31114
	dc.w	31357,31581,31786,31972
	dc.w	32138,32286,32413,32522
	dc.w	32610,32679,32729,32758
whichscreen:		dc.l	0
planetdestination:	dc.l	-1
cursoronoff:	dc.w	-1
cxsave: 	dc.w	0
d7save: 	dc.w	0
cldelay:	dc.w	-1
rcldelay:	dc.w	-0
wx:		dc.w	0
wy:		dc.w	0
wz:		dc.w	0
proz:		dc.w	1000
mspeed: 	dc.w	0
flipwithtext:	dc.w	-1
radarmag:	dc.w	6
cheat:		dc.w	-1
screen1:	dc.l	0
screen2:	dc.l	0
screen3:	dc.l	0
generalstore:	dc.l	0
seen:	dc.l	0
hiden:	dc.l	0
screen: dc.l	0
changestate:	dc.w	-1
cursor:
	dc.w	0,0,0,0,0,0
	dc.w	%1111110000000000
cfdelay:	dc.w	0
dontpulse:	dc.w	-1
pulsecount1:	dc.w	0
pulsecount2:	dc.w	0
pulsecolors:
	dc.w	$0007,$0077
pulsecolors2:
	dc.w	$0007,$0017,$0027,$0037,$0047,$0057,$0067
	dc.w	$0077,$0067,$0057,$0047,$0037,$0027,$0017
framess:	dc.w	0
	dc.b $03,$ff,$00,$09,$00,$07,$00,$02
	dc.b $00,$03,$00,$01,$00,$03,$00,$01
l0028:	dc.b $00,$00
	dc.b $00,$0e,$00,$00,$00,$07,$00,$00
	dc.b $00,$04,$00,$00,$00,$01
l0029:	dc.b $09,$01,$00,$ff,$ff,$08,$04,$02
	dc.b $01,$00
l002a:	dc.b $0b,$04,$07,$00,$01,$20,$00,$00
	dc.b $00,$20
*	section	bss
freespace:	ds.b 644

***************************************
safe:		dc.w	0
lineout:	ds.l	5
times:		dc.w	0
number: 	dc.w	0
numwhere:	dc.w	0
rvsave: 	dc.l	0
resave: 	dc.l	0
length: 	dc.w	0
oldmouse:	dc.l	0
lastb:		dc.w	-1

planet1sp:
	dc.w	0,0
	dc.w	$18,1
	dc.w	136
	dc.l	planet1
	dc.l	gtemp
	dc.l	gsave
planet2sp:
	dc.w	0,0
	dc.w	$12,1
	dc.w	136
	dc.l	planet2
	dc.l	gtemp
	dc.l	gsave
planet3sp:
	dc.w	0,0
	dc.w	$c,0
	dc.w	144
	dc.l	planet3
	dc.l	gtemp
	dc.l	gsave
planet4sp:
	dc.w	0,0
	dc.w	$10,1
	dc.w	136
	dc.l	planet4
	dc.l	gtemp
	dc.l	gsave
planet5sp:
	dc.w	0,0
	dc.w	$14,1
	dc.w	136
	dc.l	planet5
	dc.l	gtemp
	dc.l	gsave
planet6sp:
	dc.w	0,0
	dc.w	$10,1
	dc.w	136
	dc.l	planet6
	dc.l	gtemp
	dc.l	gsave
planet7sp:
	dc.w	0,0
	dc.w	$10,1
	dc.w	136
	dc.l	planet7
	dc.l	gtemp
	dc.l	gsave
planet8sp:
	dc.w	0,0
	dc.w	$9,0
	dc.w	144
	dc.l	planet8
	dc.l	gtemp
	dc.l	gsave
planet9sp:
	dc.w	0,0
	dc.w	$c,0
	dc.w	144
	dc.l	planet9
	dc.l	gtemp
	dc.l	gsave
planet10sp:
	dc.w	0,0
	dc.w	$10,1
	dc.w	136
	dc.l	planet10
	dc.l	gtemp
	dc.l	gsave
planet11sp:
	dc.w	0,0
	dc.w	$c,0
	dc.w	144
	dc.l	planet11
	dc.l	gtemp
	dc.l	gsave
planet12sp:
	dc.w	0,0
	dc.w	$14,1
	dc.w	136
	dc.l	planet12
	dc.l	gtemp
	dc.l	gsave
planet13sp:
	dc.w	0,0
	dc.w	$14,1
	dc.w	136
	dc.l	planet13
	dc.l	gtemp
	dc.l	gsave
planet14sp:
	dc.w	0,0
	dc.w	$10,1
	dc.w	136
	dc.l	planet14
	dc.l	gtemp
	dc.l	gsave
cursorsp:
	dc.w	0,0
	dc.w	15,0
	dc.w	144
	dc.l	cursordat
	dc.l	gtemp
	dc.l	gsave
sightsp:
	dc.w	0,0
	dc.w	14,0
	dc.w	144
	dc.l	sightdat
	dc.l	gtemp
	dc.l	gsave
doorsp:
	dc.w	0,0
	dc.w	0,0
	dc.w	144
	dc.l	doordat
	dc.l	gtemp
	dc.l	gsave
doordat:
	dc.w	%1000000000000000,%1000000000000000
	dc.w	%1000000000000000,%1000000000000000
linecolor:	dc.w	0
drawlist:	ds.l	20
starrotvpb:	ds.w	20
linebuffer:	ds.w	100
rnd:		ds.l	5
firebutton:	dc.w	-1
old_packh:	dc.l	0
pixelx: 	dc.w	0
pixely: 	dc.w	0
pixelcolor:	dc.w	0
ytable1:	ds.l	200
ytable2:	ds.l	200
ytable: 	dc.l	0
sytable:	dc.l	0
expanding:	dc.w	-8
specialprsp:	dc.w	-1
whichitem:	dc.w	-1
lastitem:	dc.w	-1
death2palette:
	dc.w	$0000,$0760,$0750,$0640,$0520,$0410,$0300,$0077
	dc.w	$0066,$0055,$0044,$0022,$0011,$0006,$0004,$0002
bluepalette:
	dc.w	$0555,$0000,$0555,$0333,$0507,$0406,$0305,$0007
	dc.w	$0006,$0005,$0004,$0070,$0040,$0020,$0057,$0027
greypalette:
	dc.w	$0555,$0000,$0555,$0333,$0555,$0444,$0660,$0007
	dc.w	$0006,$0005,$0004,$0070,$0050,$0030,$0040,$0007
palette2:
*	dc.w	$0555,$0000,$0777,$0666,$0555,$0444,$0333,$0443
*	dc.w	$0332,$0732,$0700,$0124,$0740,$0077,$0066,$0055
	dc.w	$0555,$0000,$0777,$0666,$0444,$0333,$0222,$0443
	dc.w	$0222,$0700,$0500,$0400,$0077,$0055,$0033,$0300
bbpalette:
	dc.w	$0555,$0000,$0555,$0333,$0557,$0446,$0335,$0007
	dc.w	$0006,$0005,$0004,$0224,$0113,$0112,$0077,$0055
planetpalette:
	dc.w	$0555,$0000,$0555,$0333,$0507,$0406,$0305,$0007
	dc.w	$0006,$0005,$0004,$0050,$0040,$0030,$0057,$0037
parra1apalette:
	dc.w	$0555,$0000,$0555,$0333,$0507,$0406,$0305,$0007
	dc.w	$0006,$0005,$0004,$0445,$0334,$0223,$0077,$0055
parra2apalette:
	dc.w	$0555,$0000,$0555,$0333,$0007,$0305,$0103,$0507
	dc.w	$0006,$0050,$0004,$0070,$0005,$0030,$0077,$0055
p2specpalette:
	dc.w	$0555,$0000,$0555,$0333,$0007,$0305,$0103,$0007
	dc.w	$0006,$0005,$0004,$0070,$0005,$0030,$0077,$0055
psearchpalette:
	dc.w	$0555,$0000,$0555,$0333,$0077,$0066,$0055,$0007
	dc.w	$0006,$0005,$0004,$0044,$0033,$0022,$0011,$0007
deckfightpalette:
	dc.w	$0555,$0000,$0555,$0333,$0222,$0444,$0777,$0007
	dc.w	$0006,$0005,$0004,$0407,$0305,$0204,$0270,$0700
citypalette:
	dc.w	$0666,$0000,$0666,$0445,$0223,$0556,$0777,$0007
	dc.w	$0006,$0005,$0004,$0334,$0112,$0036,$0567,$0256
way8palette:
	dc.w	$0555,$0000,$0555,$0333,$0507,$0406,$0305,$0007
	dc.w	$0006,$0005,$0004,$0445,$0334,$0223,$0077,$0055
titlepalette:
	dc.w	$0777,$0000,$0007,$0555,$0222,$0444,$0333,$0666
	dc.w	$0227,$0557,$0111,$0337,$0447,$0117,$0667,$0005
titlepalette1:
	dc.w	$0666,$0000,$0006,$0444,$0111,$0333,$0222,$0555
	dc.w	$0116,$0446,$0000,$0226,$0336,$0006,$0556,$0004
titlepalette2:
	dc.w	$0555,$0000,$0005,$0333,$0000,$0222,$0111,$0444
	dc.w	$0005,$0335,$0000,$0115,$0225,$0005,$0445,$0003
titlepalette3:
	dc.w	$0444,$0000,$0004,$0222,$0000,$0111,$0000,$0333
	dc.w	$0004,$0224,$0000,$0004,$0114,$0004,$0334,$0002
titlepalette4:
	dc.w	$0333,$0000,$0003,$0111,$0000,$0000,$0000,$0222
	dc.w	$0003,$0113,$0000,$0003,$0003,$0003,$0223,$0001
titlepalette5:
	dc.w	$0222,$0000,$0002,$0000,$0000,$0000,$0000,$0111
	dc.w	$0002,$0002,$0000,$0002,$0002,$0002,$0112,$0000
titlepalette6:
	dc.w	$0111,$0000,$0001,$0000,$0000,$0000,$0000,$0000
	dc.w	$0001,$0001,$0000,$0001,$0001,$0001,$0001,$0000

titlepalette7:
	dc.w	$0000,$0777,$0666,$0555,$0444,$0444,$0333,$0222
	dc.w	$0047,$0057,$0077,$0050,$0760,$0320,$0700,$0705
blackpal:
	dc.w	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

gtemp:	ds.w	500
gmask:	ds.w	300
gsave:	ds.w	500
smallnumbers:
	dc.b	$87,$87,$87,$78,$7B,$7B,$7B,$84
	dc.b	$7B,$7B,$7B,$84,$7B,$7B,$7B,$84
	dc.b	$7B,$7B,$7B,$84,$87,$87,$FF,$00
	dc.b	$7B,$7B,$7B,$84,$7B,$7B,$7B,$84
	dc.b	$7B,$7B,$7B,$84,$7B,$7B,$7B,$84
	dc.b	$87,$87,$87,$78,$87,$87,$FF,$00
	dc.b	$7B,$7B,$FB,$04,$7B,$7B,$FB,$04
	dc.b	$7B,$7B,$FB,$04,$7B,$7B,$FB,$04
	dc.b	$87,$87,$FF,$00,$7B,$7B,$FB,$04
	dc.b	$7B,$7B,$FB,$04,$7B,$7B,$FB,$04
	dc.b	$7B,$7B,$FB,$04,$87,$87,$FF,$00
	dc.b	$87,$87,$87,$78,$7B,$7B,$FB,$04
	dc.b	$7B,$7B,$FB,$04,$7B,$7B,$FB,$04
	dc.b	$7B,$7B,$FB,$04,$87,$87,$87,$78
	dc.b	$7B,$7B,$7F,$80,$7B,$7B,$7F,$80
	dc.b	$7B,$7B,$7F,$80,$7B,$7B,$7F,$80
	dc.b	$87,$87,$87,$78,$87,$87,$87,$78
	dc.b	$7B,$7B,$FB,$04,$7B,$7B,$FB,$04
	dc.b	$7B,$7B,$FB,$04,$7B,$7B,$FB,$04
	dc.b	$87,$87,$87,$78,$7B,$7B,$FB,$04
	dc.b	$7B,$7B,$FB,$04,$7B,$7B,$FB,$04
	dc.b	$7B,$7B,$FB,$04,$87,$87,$87,$78
	dc.b	$87,$87,$FF,$00,$7B,$7B,$7B,$84
	dc.b	$7B,$7B,$7B,$84,$7B,$7B,$7B,$84
	dc.b	$7B,$7B,$7B,$84,$87,$87,$87,$78
	dc.b	$7B,$7B,$FB,$04,$7B,$7B,$FB,$04
	dc.b	$7B,$7B,$FB,$04,$7B,$7B,$FB,$04
	dc.b	$87,$87,$FF,$00,$87,$87,$87,$78
	dc.b	$7B,$7B,$7F,$80,$7B,$7B,$7F,$80
	dc.b	$7B,$7B,$7F,$80,$7B,$7B,$7F,$80
	dc.b	$87,$87,$87,$78,$7B,$7B,$FB,$04
	dc.b	$7B,$7B,$FB,$04,$7B,$7B,$FB,$04
	dc.b	$7B,$7B,$FB,$04,$87,$87,$87,$78
	dc.b	$87,$87,$87,$78,$7B,$7B,$7F,$80
	dc.b	$7B,$7B,$7F,$80,$7B,$7B,$7F,$80
	dc.b	$7B,$7B,$7F,$80,$87,$87,$87,$78
	dc.b	$7B,$7B,$7B,$84,$7B,$7B,$7B,$84
	dc.b	$7B,$7B,$7B,$84,$7B,$7B,$7B,$84
	dc.b	$87,$87,$87,$78,$87,$87,$87,$78
	dc.b	$7B,$7B,$FB,$04,$7B,$7B,$FB,$04
	dc.b	$7B,$7B,$FB,$04,$7B,$7B,$FB,$04
	dc.b	$87,$87,$FF,$00,$7B,$7B,$FB,$04
	dc.b	$7B,$7B,$FB,$04,$7B,$7B,$FB,$04
	dc.b	$7B,$7B,$FB,$04,$87,$87,$FF,$00
	dc.b	$87,$87,$87,$78,$7B,$7B,$7B,$84
	dc.b	$7B,$7B,$7B,$84,$7B,$7B,$7B,$84
	dc.b	$7B,$7B,$7B,$84,$87,$87,$87,$78
	dc.b	$7B,$7B,$7B,$84,$7B,$7B,$7B,$84
	dc.b	$7B,$7B,$7B,$84,$7B,$7B,$7B,$84
	dc.b	$87,$87,$87,$78,$87,$87,$87,$78
	dc.b	$7B,$7B,$7B,$84,$7B,$7B,$7B,$84
	dc.b	$7B,$7B,$7B,$84,$7B,$7B,$7B,$84
	dc.b	$87,$87,$87,$78,$7B,$7B,$FB,$04
	dc.b	$7B,$7B,$FB,$04,$7B,$7B,$FB,$04
	dc.b	$7B,$7B,$FB,$04,$87,$87,$87,$78
	dc.b	$87,$87,$FF,$00,$7B,$7B,$FF,$00
	dc.b	$7B,$7B,$FF,$00,$7B,$7B,$FF,$00
	dc.b	$7B,$7B,$FF,$00,$87,$87,$FF,$00
	dc.b	$7B,$7B,$FF,$00,$7B,$7B,$FF,$00
	dc.b	$7B,$7B,$FF,$00,$7B,$7B,$FF,$00
	dc.b	$87,$87,$FF,$00


	even
pointer:
	 dc.w	$8000,$0000,$F01E,$0000,$0000,$8000,$8002,$0000
	 dc.w	$0000,$8000,$8002,$0000,$0000,$8000,$8002,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0100,$0100,$0100,$0100,$0280,$0380,$0380,$0380
	 dc.w	$0100,$0100,$0100,$0100,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$8000,$8002,$0000
	 dc.w	$0000,$8000,$8002,$0000,$0000,$8000,$8002,$0000
	 dc.w	$0002,$F01C,$F01E,$0000
font:
	 dc.w	$0000,$0000,$0000,$0000,$0000,$1000,$0000,$0800
	 dc.w	$1000,$2000,$4000,$8000,$E000,$9000,$A800,$C800
	 dc.w	$8800,$F800,$1000,$1000,$1000,$1000,$1000,$3000
	 dc.w	$E000,$1000,$0800,$F800,$8000,$F800,$F000,$0800
	 dc.w	$3800,$0800,$0800,$F800,$1000,$2800,$4800,$F800
	 dc.w	$0800,$0800,$F000,$8000,$7800,$0800,$0800,$F800
	 dc.w	$E000,$8000,$F000,$8800,$8800,$F800,$F000,$0800
	 dc.w	$0800,$0800,$0800,$0800,$F000,$8800,$F800,$8800
	 dc.w	$8800,$F800,$F000,$8800,$F800,$0800,$0800,$0800
	 dc.w	$0000,$1000,$0000,$0000,$1000,$0000,$0000,$1000
	 dc.w	$0000,$1000,$1000,$2000,$1000,$2000,$4000,$4000
	 dc.w	$2000,$1000,$0000,$0000,$7800,$0000,$7800,$0000
	 dc.w	$2000,$1000,$0800,$0800,$1000,$2000,$6000,$5000
	 dc.w	$0800,$3800,$0000,$2000,$E000,$9000,$A800,$B800
	 dc.w	$8000,$F800
	 dc.w	$C000,$A000,$9000,$F800,$8800,$8800,$C000,$A000
	 dc.w	$9000,$F800,$8800,$F800,$E000,$8000,$8000,$8000
	 dc.w	$8000,$F800,$C000,$A000,$9000,$8800,$8800,$F800
	 dc.w	$C000,$8000,$F000,$8000,$8000,$F800,$F000,$8000
	 dc.w	$F800,$8000,$8000,$8000,$C000,$A000,$8000,$9800
	 dc.w	$8800,$F800,$8000,$8800,$F800,$8800,$8800,$8800
	 dc.w	$7000,$2000,$2000,$2000,$2000,$7800,$7000,$0800
	 dc.w	$0800,$0800,$8800,$F000,$8000,$9000,$E000,$9000
	 dc.w	$8800,$8800,$8000,$8000,$8000,$8000,$8000,$F800
	 dc.w	$8000,$C800,$B800,$A800,$8800,$8800,$8000,$C800
	 dc.w	$A800,$9800,$8800,$8800,$F000,$8800,$8800,$8800
	 dc.w	$8800,$F800,$E000,$9000,$8800,$F800,$8000,$8000
	 dc.w	$E000,$9000,$8800,$A800,$9800,$F800,$E000,$9000
	 dc.w	$8800,$F800,$9000,$8800,$E000,$8000,$F800,$0800
	 dc.w	$0800,$F800,$F800,$1000,$1000,$1000,$1000,$1000
	 dc.w	$8000,$8000,$8800,$8800,$8800,$F800,$8000,$8800
	 dc.w	$8800,$8800,$4800,$3000,$8000,$8000,$8800,$A800
	 dc.w	$D800,$8800,$8000,$8800,$8800,$7000,$8800,$8800
	 dc.w	$8000,$8800,$8800,$7000,$2000,$2000,$F000,$0800
	 dc.w	$1000,$2000,$4000,$F800
blank:	 dc.w	0,0,0,0,0,0
	 dc.w	$ff00,$ff00,$ff00,$ff00,$ff00,$ff00

compscreenmem:
	ds.w	1980
	ds.w	36
vtrans_vrt:	ds.w	500
ptrans_vrt:	ds.w	500
***************************************************************************
worldvpb:	ds.w	20
boxvpb: 	ds.w	20
startvpb:	ds.w	20
template:
	dc.l	met1vpb 	;pointer to the vpb
	dc.w	0,0,-1500	;overall object x,y,z
	dc.l	met1vrt 	;pointer to its vertices
	dc.l	met1face	;pointer to faces
	dc.w	filled		;filled or line or dots
	dc.w	11		;when line becomes color info or numdots
	dc.l	met1colors	;face color pointer
	dc.w	1		;hidden line removal flag
	dc.w	-1		;activeflag
	dc.w	1		;can it be hit
	dc.w	100		;obwidth,height,depth for collision
	dc.w	0,0		;onscreenx,y
startube:
	dc.l	startvpb
	dc.w	0,0,0
	dc.l	startvrt
	dc.l	0
	dc.w	dots
	dc.w	45
	dc.l	0
	dc.w	1
	dc.w	0
	dc.w	0
	dc.w	0
	dc.w	0,0
startvrt:
	dc.w	45
	rept	45
*	ds.w	45*3
	dc.w	0,0,0
	endr
spacestarsvrt:
	dc.w	20
	ds.w	20*3
box:
	dc.l	boxvpb
	dc.w	0,0,1500
	dc.l	boxvrt
	dc.l	boxface
	dc.w	line
	dc.w	15
	dc.l	0
	dc.w	1
	dc.w	1
	dc.w	1
	dc.w	120
	dc.w	0,0
boxvrt:
	dc.w	9
	dc.w	 -60,60,59
	dc.w	60,60,59
	dc.w	60,60,-59
	dc.w	-60,60,-59
	dc.w	-60,-60,59
	dc.w	60,-60,59
	dc.w	60,-60,-59
	dc.w	-60,-60,-59
	dc.w	0,0,0
boxface:
	dc.w	6
	dc.w	3,0,4,5,1
	dc.w	3,1,5,6,2
	dc.w	3,2,6,7,3
	dc.w	3,3,7,4,0
	dc.w	3,0,1,2,3
	dc.w	3,4,7,6,5

pentavpb:	ds.w	20
penta1:
	dc.l	pentavpb
	dc.w	300,-20,1800		;overall object x,y,z
	dc.l	pentavrt
	dc.l	pentaface
	dc.w	filled		;filled or line or dots
	dc.w	0		;number of dots
	dc.l	pentacolors		;face color list
	dc.w	1		;1 is do hiden line removal
	dc.w	1
	dc.w	-1
	dc.w	120
	dc.w	0,0		;onscreenx,y
pentacolors:
	dc.w	7,7,8,8,9,9,10,10
	dc.w	8,8,8,8,8,8
	dc.w	9,9,9,9,9,9
	dc.w	10,10,10,10,10,10
pentavrt:
	dc.w  4
	dc.w	49,-30,-25
	dc.w	-00,56,-25
	dc.w	00,-01,56
	dc.w	-49,-29,-25

pentaface:
	dc.w	4
	dc.w	2,0,2,1
	dc.w	2,2,0,3
	dc.w	2,1,3,0
	dc.w	2,1,2,3

credvpb:	ds.w	20
credob:
	dc.l	credvpb
	dc.w	150,0,900
	dc.l	credvrt
	dc.l	credface
	dc.w	filled
	dc.w	15
	dc.l	credcolors
	dc.w	1
	dc.w	-1
	dc.w	1
	dc.w	120
	dc.w	0,0
credcolors:
	dc.w	4,4,11,11,5,5,5,5,5,5,5,5,12,12,12,12
	dc.w	12,12,12,12
credvrt:
	dc.w	8
	dc.w	0,40,-5
	dc.w	40,0,-5
	dc.w	0,-40,-5
	dc.w	-40,0,-5
	dc.w	30,30,5
	dc.w	30,-30,5
	dc.w	-30,-30,5
	dc.w	-30,30,5
credface:
	dc.w	10
	dc.w	3,0,1,2,3
	dc.w	3,7,6,5,4
	dc.w	2,7,0,3
	dc.w	2,0,4,1
	dc.w	2,1,5,2
	dc.w	2,2,6,3
	dc.w	2,7,4,0
	dc.w	2,4,5,1
	dc.w	2,5,6,2
	dc.w	2,6,7,3

evivpb:	ds.w	20
eviob:
	dc.l	evivpb
	dc.w	150,0,800
	dc.l	evivrt
	dc.l	eviface
	dc.w	filled
	dc.w	15
	dc.l	evicolors
	dc.w	1
	dc.w	-1
	dc.w	1
	dc.w	120
	dc.w	0,0
evicolors:
	dc.w	7,7,8,8,9,9,5,5,5,6,4,4,4,7,4,8
	dc.w	6,8,4,7,4,8,5,8
evivrt:
	dc.w	8
	dc.w	-40,40,-40
	dc.w	40,40,-40
	dc.w	40,-40,-40
	dc.w	-40,-40,-40
	dc.w	-40,40,40
	dc.w	40,40,40
	dc.w	40,-40,40
	dc.w	-40,-40,40
eviface:
	dc.w	12
	dc.w	2,0,1,2
	dc.w	2,5,1,0
	dc.w	2,1,5,2
	dc.w	2,3,6,7
	dc.w	2,4,3,7
	dc.w	2,4,7,6
	dc.w	2,0,2,3
	dc.w	2,2,6,3
	dc.w	2,2,5,6
	dc.w	2,5,4,6
	dc.w	2,4,5,0
	dc.w	2,4,0,3

bubvpb:	ds.w	20
bubob:
	dc.l	bubvpb
	dc.w	150,0,800
	dc.l	bubvrt
	dc.l	bubface
	dc.w	filled
	dc.w	15
	dc.l	bubcolors
	dc.w	1
	dc.w	-1
	dc.w	1
	dc.w	120
	dc.w	0,0
bubcolors:
	dc.w	7,7,10,10,8,8,8,9,9,9,10,9,4,4,4,5
	dc.w	5,5,5,6,4,5,5,5
	dc.w	5,6,6,6
bubvrt:
	dc.w	24
	dc.w	-10,30,-30
	dc.w	10,30,-30
	dc.w	30,10,-30
	dc.w	30,-10,-30
	dc.w	10,-30,-30
	dc.w	-10,-30,-30
	dc.w	-30,-10,-30
	dc.w	-30,10,-30

	dc.w	30,30,-10
	dc.w	30,-30,-10
	dc.w	-30,-30,-10
	dc.w	-30,30,-10

	dc.w	-10,30,30
	dc.w	10,30,30
	dc.w	30,10,30
	dc.w	30,-10,30
	dc.w	10,-30,30
	dc.w	-10,-30,30
	dc.w	-30,-10,30
	dc.w	-30,10,30

	dc.w	30,30,10
	dc.w	30,-30,10
	dc.w	-30,-30,10
	dc.w	-30,30,10


bubface:
	dc.w	14		;13
	dc.w	7,0,1,2,3,4,5,6,7
	dc.w	7,19,18,17,16,15,14,13,12
	dc.w	7,2,8,20,14,15,21,9,3
	dc.w	7,0,11,23,12,13,20,8,1
	dc.w	7,11,7,6,10,22,18,19,23
	dc.w	7,10,5,4,9,21,16,17,22

	dc.w	2,1,8,2
	dc.w	2,3,9,4
	dc.w	2,6,5,10
	dc.w	2,11,0,7

	dc.w	2,13,14,20
	dc.w	2,15,16,21
	dc.w	2,22,17,18
	dc.w	2,12,23,19

amatvpb:	ds.w	20
amatob:
	dc.l	amatvpb
	dc.w	150,0,800
	dc.l	amatvrt
	dc.l	amatface
	dc.w	line
	dc.w	15
	dc.l	0
	dc.w	-1
	dc.w	-1
	dc.w	1
	dc.w	120
	dc.w	0,0
amatvrt:
	dc.w	16
	dc.w	-40,40,40
	dc.w	40,40,40
	dc.w	40,40,-40
	dc.w	-40,40,-40
	dc.w	-40,-40,40
	dc.w	40,-40,40
	dc.w	40,-40,-40
	dc.w	-40,-40,-40
	dc.w	-60,60,60
	dc.w	60,60,60
	dc.w	60,60,-60
	dc.w	-60,60,-60
	dc.w	-60,-60,60
	dc.w	60,-60,60
	dc.w	60,-60,-60
	dc.w	-60,-60,-60
amatface:
	dc.w	14
	dc.w	3,4,5,1,0
	dc.w	3,1,5,6,2
	dc.w	3,2,6,7,3
	dc.w	3,3,7,4,0
	dc.w	3,0,1,2,3
	dc.w	3,4,7,6,5
	dc.w	0,0,8
	dc.w	0,1,9
	dc.w	0,2,10
	dc.w	0,3,11
	dc.w	0,4,12
	dc.w	0,5,13
	dc.w	0,6,14
	dc.w	0,7,15


fuelvpb:	ds.w	20
fuelob:
	dc.l	fuelvpb
	dc.w	150,0,800
	dc.l	fuelvrt
	dc.l	fuelface
	dc.w	filled
	dc.w	15
	dc.l	fuelcolors
	dc.w	1
	dc.w	-1
	dc.w	1
	dc.w	120
	dc.w	0,0
fuelcolors:
	dc.w	7,7,8,8,5,5,15,15,9,10,8,9,8,9,8,9
	dc.w	8,9,10,10,6,6,6,6
	dc.w	15,14
fuelvrt:
	dc.w	14
	dc.w	-10,40,-10
	dc.w	30,40,-10
	dc.w	30,-20,-10
	dc.w	30,-40,-10
	dc.w	10,-40,-10
	dc.w	-30,-40,-10
	dc.w	-30,20,-10
	dc.w	-10,40,10
	dc.w	30,40,10
	dc.w	30,-20,10
	dc.w	30,-40,10
	dc.w	10,-40,10
	dc.w	-30,-40,10
	dc.w	-30,20,10
fuelface:
	dc.w	12
	dc.w	3,0,7,8,1
	dc.w	3,1,8,9,2
	dc.w	3,2,9,10,3
	dc.w	3,7,0,6,13
	dc.w	3,13,6,5,12
	dc.w	2,0,1,2
	dc.w	2,9,8,7
	dc.w	2,6,4,5
	dc.w	2,12,11,13
	dc.w	3,3,10,12,5
	dc.w	4,0,2,3,4,6
	dc.w	4,13,11,10,9,7

mine2vpb:
	ds.w	20
multideck:
	dc.l	mine2vpb
	dc.w	0,0,1150
	dc.l	mine2vrt
	dc.l	mine2face
	dc.w	filled
	dc.w	0
	dc.l	mine2colors
	dc.w	1
	dc.w	-1
	dc.w	20
	dc.w	300
	dc.w	0,0
mine2colors:
	dc.w	14,14,4,4,10,10,4,7,4,4,4,7
	dc.w	4,4,4,7,4,4,4,7
mine2vrt:
	dc.w	18
	dc.w	55,00,26
	dc.w	135,01,-44
	dc.w	39,39,26
	dc.w	95,97,-44
	dc.w	00,55,26
	dc.w	-01,135,-44
	dc.w	-39,39,26
	dc.w	-97,95,-44
	dc.w	-55,00,26
	dc.w	-135,-01,-44
	dc.w	-39,-39,26
	dc.w	-95,-96,-44
	dc.w	00,-55,26
	dc.w	01,-135,-44
	dc.w	00,00,26
	dc.w	39,-39,26
	dc.w	96,-95,-44
	dc.w	00,00,-44
 mine2face:
	dc.w	10
	dc.w	7,00,02,04,06,08,10,12,15
	dc.w	3,00,01,03,02
	dc.w	7,16,13,11,09,07,05,03,01
	dc.w	3,02,03,05,04
	dc.w	3,04,05,07,06
	dc.w	3,06,07,09,08
	dc.w	3,08,09,11,10
	dc.w	3,10,11,13,12
	dc.w	3,12,13,16,15
	dc.w	3,15,16,01,00
obian1vpb:
	ds.w	20
obian1:
	dc.l	obian1vpb
	dc.w	0,0,1000
	dc.l	obianvrt
	dc.l	obianface
	dc.w	filled
	dc.w	10
	dc.l	obiancolors
	dc.w	1
	dc.w	-1
	dc.w	3
	dc.w	80
	dc.w	0,0
	dc.w	0,0,0,0
obian2vpb:
	ds.w	20
obian2:
	dc.l	obian2vpb
	dc.w	0,0,1000
	dc.l	obianvrt
	dc.l	obianface
	dc.w	filled
	dc.w	10
	dc.l	obiancolors
	dc.w	1
	dc.w	-1
	dc.w	3
	dc.w	80
	dc.w	0,0
	dc.w	0,0,0,0
obian3vpb:
	ds.w	20
obian3:
	dc.l	obian3vpb
	dc.w	0,0,1000
	dc.l	obianvrt
	dc.l	obianface
	dc.w	filled
	dc.w	10
	dc.l	obiancolors
	dc.w	1
	dc.w	-1
	dc.w	3
	dc.w	80
	dc.w	0,0
	dc.w	0,0,0,0
obian4vpb:
	ds.w	20
obian4:
	dc.l	obian4vpb
	dc.w	0,0,1000
	dc.l	obianvrt
	dc.l	obianface
	dc.w	filled
	dc.w	10
	dc.l	obiancolors
	dc.w	1
	dc.w	-1
	dc.w	3
	dc.w	80
	dc.w	0,0
	dc.w	0,0,0,0
obian5vpb:
	ds.w	20
obian5:
	dc.l	obian5vpb
	dc.w	0,0,1000
	dc.l	obianvrt
	dc.l	obianface
	dc.w	filled
	dc.w	10
	dc.l	obiancolors
	dc.w	1
	dc.w	-1
	dc.w	3
	dc.w	80
	dc.w	0,0
	dc.w	0,0,0,0

obiancolors:
	dc.w	7,7,8,8,7,7,8,8,7,7,8,8,9,9,10,10
	dc.w	9,9,10,10,9,9,10,10
	dc.w	15,14
obianvrt:
	dc.w	14
	dc.w	159/2,01/2,00/2
	dc.w	39/2,00/2,-44/2
	dc.w	78/2,139/2,00/2
	dc.w	19/2,34/2,-44/2
	dc.w	-81/2,137/2,00/2
	dc.w	-20/2,34/2,-44/2
	dc.w	-159/2,-01/2,00/2
	dc.w	-39/2,-00/2,-44/2
	dc.w	-78/2,-139/2,00/2
	dc.w	-19/2,-34/2,-44/2
	dc.w	00/2,00/2,61/2
	dc.w	80/2,-137/2,00/2
	dc.w	20/2,-34/2,-44/2
	dc.w	00/2,00/2,-44/2
obianface:
	dc.w	13
	dc.w	2,02,10,00
	dc.w	2,04,10,02
	dc.w	2,06,10,04
	dc.w	2,08,10,06
	dc.w	2,11,10,08
	dc.w	2,00,10,11
	dc.w	3,03,02,00,01
	dc.w	3,05,04,02,03
	dc.w	3,07,06,04,05
	dc.w	3,09,08,06,07
	dc.w	3,12,11,08,09
	dc.w	3,01,00,11,12
	dc.w	5,12,09,07,05,03,01


minevpb:
	ds.w	20
warp1:
	dc.l	minevpb
	dc.w	0,0,1000
	dc.l	minevrt
	dc.l	mineface
	dc.w	filled
	dc.w	9
	dc.l	minecolors
	dc.w	1
	dc.w	-1
	dc.w	1
	dc.w	60
	dc.w	0,0
	dc.w	0,0,0,0

minevpb2:	ds.w	20
warp2:
	dc.l	minevpb2
	dc.w	100,100,1000
	dc.l	minevrt
	dc.l	mineface
	dc.w	filled
	dc.w	9
	dc.l	minecolors
	dc.w	1
	dc.w	-1
	dc.w	1
	dc.w	60
	dc.w	0,0
	dc.w	0,0,0,0
minevpb3:	ds.w	20
warp3:
	dc.l	minevpb3
	dc.w	100,100,1000
	dc.l	minevrt
	dc.l	mineface
	dc.w	filled
	dc.w	9
	dc.l	minecolors
	dc.w	1
	dc.w	-1
	dc.w	1
	dc.w	60
	dc.w	0,0
	dc.w	0,0,0,0
minevpb4:	ds.w	20
warp4:
	dc.l	minevpb4
	dc.w	100,100,1000
	dc.l	minevrt
	dc.l	mineface
	dc.w	filled
	dc.w	9
	dc.l	minecolors
	dc.w	1
	dc.w	-1
	dc.w	1
	dc.w	60
	dc.w	0,0
	dc.w	0,0,0,0
minevpb5:	ds.w	20
warp5:
	dc.l	minevpb5
	dc.w	100,100,1000
	dc.l	minevrt
	dc.l	mineface
	dc.w	filled
	dc.w	9
	dc.l	minecolors
	dc.w	1
	dc.w	-1
	dc.w	1
	dc.w	60
	dc.w	0,0
	dc.w	0,0,0,0
minecolors:
	dc.w	14,14,4,4,4,5,15,8,4,5,5,5
	dc.w	5,5,5,6,5,6,6,6,4,5,5,5
minevrt:
	dc.w	17
	dc.w	47/2,00/2,44/2
	dc.w	87/2,00/2,00/2
	dc.w	47/2,00/2,-44/2
	dc.w	14/2,45/2,44/2
	dc.w	26/2,83/2,00/2
	dc.w	14/2,45/2,-44/2
	dc.w	-39/2,27/2,44/2
	dc.w	-71/2,51/2,00/2
	dc.w	-39/2,27/2,-44/2
	dc.w	-38/2,-28/2,44/2
	dc.w	-70/2,-52/2,00/2
	dc.w	-38/2,-28/2,-44/2
	dc.w	00/2,00/2,44/2
	dc.w	15/2,-45/2,44/2
	dc.w	27/2,-83/2,00/2
	dc.w	15/2,-45/2,-44/2
	dc.w	00/2,00/2,-44/2
 mineface:
	dc.w	12
	dc.w	4,00,03,06,09,13
	dc.w	3,00,01,04,03
	dc.w	3,01,02,05,04
	dc.w	4,15,11,08,05,02
	dc.w	3,03,04,07,06
	dc.w	3,04,05,08,07
	dc.w	3,06,07,10,09
	dc.w	3,07,08,11,10
	dc.w	3,09,10,14,13
	dc.w	3,10,11,15,14
	dc.w	3,13,14,01,00
	dc.w	3,14,15,02,01

ship3vpb:	ds.w	20
ship3s:
	dc.l	ship3vpb
	dc.w	0,0,0
	dc.l	ship3vrts
	dc.l	ship3face
	dc.w	filled
	dc.w	0
	dc.l	ship3colors
	dc.w	1
	dc.w	-1
	dc.w	-1
	dc.w	0
	dc.w	0,0
ship3:
	dc.l	ship3vpb
	dc.w	0,0,0
	dc.l	ship3vrt
	dc.l	ship3face
	dc.w	filled
	dc.w	0
	dc.l	ship3colors
	dc.w	1
	dc.w	-1
	dc.w	-1
	dc.w	0
	dc.w	0,0
ship3colors:
	dc.w	7,7,7,8,8,9,14,14,1,9,1,8,1,9
	dc.w	15,14,7,8,8,9,9,10,14,14,7,5,7,4
ship3vrts:
	dc.w	17
	dc.w	47/2,00/2,00/2
	dc.w	51/2,01/2,-70/2
	dc.w	31/2,00/2,-114/2
	dc.w	-24/2,82/2,00/2
	dc.w	-26/2,89/2,-70/2
	dc.w	-16/2,55/2,-114/2
	dc.w	00/2,00/2,158/2
	dc.w	-23/2,-83/2,00/2
	dc.w	-25/2,-90/2,-70/2
	dc.w	-15/2,-55/2,-114/2
	dc.w	00/2,00/2,-149/2
	dc.w	00/2,-20/2,98/2
	dc.w	-6/2,-60/2,10/2
	dc.w	26/2,-20/2,10/2
	dc.w	00/2,20/2,98/2
	dc.w	-6/2,60/2,10/2
	dc.w	26/2,20/2,10/2

ship3vrt:
	dc.w	17
	dc.w	47,00,00
	dc.w	51,01,-70
	dc.w	31,00,-114
	dc.w	-24,82,00
	dc.w	-26,89,-70
	dc.w	-16,55,-114
	dc.w	00,00,158
	dc.w	-23,-83,00
	dc.w	-25,-90,-70
	dc.w	-15,-55,-114
	dc.w	00,00,-149
	dc.w	00,-20,98
	dc.w	-6,-60,10
	dc.w	26,-20,10
	dc.w	00,20,98
	dc.w	-6,60,10
	dc.w	26,20,10
ship3face:
	dc.w	14
	dc.w	2,06,00,03
	dc.w	3,00,01,04,03
	dc.w	3,01,02,05,04
	dc.w	2,02,10,05
	dc.w	2,06,03,07
	dc.w	3,03,04,08,07
	dc.w	3,04,05,09,08
	dc.w	2,05,10,09
	dc.w	2,06,07,00
	dc.w	3,07,08,01,00
	dc.w	3,08,09,02,01
	dc.w	2,09,10,02
	dc.w	2,11,12,13
	dc.w	2,16,15,14
starcubevpb:	ds.w	20
starcubeob:
	dc.l	starcubevpb
	dc.w	0,0,0
	dc.l	starcubevrt
	dc.l	0
	dc.w	dots
	dc.w	50
	dc.l	0
	dc.w	-1
	dc.w	-1
	dc.w	-1
	dc.w	0
	dc.w	0,0
starcubevrt:
	dc.w	50
	ds.w	50*3
starcubevpb2:	ds.w	40
starcubeob2:
	dc.l	starcubevpb2
	dc.w	0,0,0
	dc.l	starcubevrt2
	dc.l	starcubeface2
	dc.w	line
	dc.w	7
	dc.l	0
	dc.w	1
	dc.w	-1
	dc.w	-1
	dc.w	0
	dc.w	0,0
starcubevrt2:
	dc.w	8
	dc.w	-50,50,50
	dc.w	50,50,50
	dc.w	50,50,-50
	dc.w	-50,50,-50
	dc.w	-50,-50,50
	dc.w	50,-50,50
	dc.w	50,-50,-50
	dc.w	-50,-50,-50
starcubeface2:
	dc.w	6
	dc.w	3,0,4,5,1
	dc.w	3,1,5,6,2
	dc.w	3,2,6,7,3
	dc.w	3,3,7,4,0
	dc.w	3,0,1,2,3
	dc.w	3,4,7,6,5
starsquarevpb:	ds.w	20
square:
	dc.l	starsquarevpb
	dc.w	0,0,0
	dc.l	starsquarevrt
	dc.l	starsquareface
	dc.w	line
	dc.w	4
	dc.l	0
	dc.w	-1
	dc.w	-1
	dc.w	-1
	dc.w	0
	dc.w	0,0
starsquarevrt:
	dc.w	4
	dc.w	0,-50,50
	dc.w	0,50,50
	dc.w	0,50,-50
	dc.w	0,-50,-50
starsquareface:
	dc.w	1
	dc.w	3,0,1,2,3
square2:
	dc.l	starsquarevpb
	dc.w	0,0,0
	dc.l	starsquarevrt2
	dc.l	starsquareface2
	dc.w	line
	dc.w	4
	dc.l	0
	dc.w	-1
	dc.w	-1
	dc.w	-1
	dc.w	0
	dc.w	0,0
starsquarevrt2:
	dc.w	6
	dc.w	0,-50,50
	dc.w	0,50,50
	dc.w	0,50,-50
	dc.w	0,-50,-50
	dc.w	0,0,50
	dc.w	0,0,-50

starsquareface2:
	dc.w	2
	dc.w	3,0,1,2,3
	dc.w	1,4,5

met1vpb:	ds.w	20
met1:
	dc.l	met1vpb
	dc.w	0,0,-1500
	dc.l	met1vrt
	dc.l	met1face
	dc.w	filled
	dc.w	11
	dc.l	met1colors
	dc.w	1
	dc.w	-1
	dc.w	1
	dc.w	110
	dc.w	0,0
met2vpb:	ds.w	20
met2:
	dc.l	met2vpb
	dc.w	0,0,-1500
	dc.l	met1vrt
	dc.l	met1face
	dc.w	filled
	dc.w	11
	dc.l	met1colors
	dc.w	1
	dc.w	-1
	dc.w	1
	dc.w	110
	dc.w	0,0
met3vpb:	ds.w	20
met3:
	dc.l	met3vpb
	dc.w	0,0,-1500
	dc.l	met1vrt
	dc.l	met1face
	dc.w	filled
	dc.w	11
	dc.l	met1colors
	dc.w	1
	dc.w	-1
	dc.w	1
	dc.w	110
	dc.w	0,0
met4vpb:	ds.w	20
met4:
	dc.l	met4vpb
	dc.w	0,0,-1500
	dc.l	met1vrt
	dc.l	met1face
	dc.w	filled
	dc.w	11
	dc.l	met1colors
	dc.w	1
	dc.w	-1
	dc.w	1
	dc.w	110
	dc.w	0,0
met5vpb:	ds.w	20
met5:
	dc.l	met5vpb
	dc.w	0,0,-1500
	dc.l	met1vrt
	dc.l	met1face
	dc.w	filled
	dc.w	11
	dc.l	met1colors
	dc.w	1
	dc.w	-1
	dc.w	1
	dc.w	110
	dc.w	0,0
met1colors:
	dc.w	4,4,5,5,4,5,5,6,5,5,6,6
met1vrt:
	dc.w	6
	dc.w	99,00,00
	dc.w	-60,88,00
	dc.w	00,00,90
	dc.w	-59,-89,00
	dc.w	00,00,-90
	dc.w	0,0,0 
met1face:
	dc.w	6
	dc.w	2,02,00,01
	dc.w	2,00,04,01
	dc.w	2,02,01,03
	dc.w	2,01,04,03
	dc.w	2,02,03,00
	dc.w	2,03,04,00

shot1vpb:	ds.w	20
shot1:
	dc.l	shot1vpb
	dc.w	0,0,-200
	dc.l	shot1vrt
	dc.l	shot1face
	dc.w	line
	dc.w	15
	dc.l	shot1colors
	dc.w	-1
	dc.w	-1
	dc.w	-1
	dc.w	0
	dc.w	0,0
shot2vpb:	ds.w	20
shot2:
	dc.l	shot2vpb
	dc.w	0,0,-100
	dc.l	shot1vrt
	dc.l	shot1face
	dc.w	line
	dc.w	15
	dc.l	shot1colors
	dc.w	-1
	dc.w	-1
	dc.w	-1
	dc.w	0
	dc.w	0,0
shot3vpb:	ds.w	20
shot3:
	dc.l	shot3vpb
	dc.w	0,0,-100
	dc.l	shot1vrt
	dc.l	shot1face
	dc.w	line
	dc.w	15
	dc.l	shot1colors
	dc.w	-1
	dc.w	-1
	dc.w	-1
	dc.w	0
	dc.w	0,0
shot4vpb:	ds.w	20
shot4:
	dc.l	shot4vpb
	dc.w	0,0,-100
	dc.l	shot1vrt
	dc.l	shot1face
	dc.w	line
	dc.w	15
	dc.l	shot1colors
	dc.w	-1
	dc.w	-1
	dc.w	-1
	dc.w	0
	dc.w	0,0
shot1colors:
	dc.w	14,14,15,15
shot1vrt:
	dc.w	7
	dc.w	0,0,100
	dc.w	10,0,0
	dc.w	0,0,-20
	dc.w	-10,0,0
	dc.w	0,10,0
	dc.w	0,-10,0
	dc.w	0,0,0
shot1face:
	dc.w	2
	dc.w	3,1,2,3,0
	dc.w	3,0,4,2,5
wp1vpb: ds.w	20
warp1shot:
	dc.l	wp1vpb
	dc.w	0,0,0
	dc.l	warpshotvrt
	dc.l	warpshotface
	dc.w	line
	dc.w	15
	dc.l	0
	dc.w	-1
	dc.w	-1
	dc.w	1
	dc.w	0
	dc.w	0,0
	dc.w	0,0,0,0
wp2vpb: ds.w	20
warp2shot:
	dc.l	wp2vpb
	dc.w	0,0,0
	dc.l	warpshotvrt
	dc.l	warpshotface
	dc.w	line
	dc.w	15
	dc.l	0
	dc.w	-1
	dc.w	-1
	dc.w	1
	dc.w	0
	dc.w	0,0
	dc.w	0,0,0,0
wp3vpb: ds.w	20
warp3shot:
	dc.l	wp3vpb
	dc.w	0,0,0
	dc.l	warpshotvrt
	dc.l	warpshotface
	dc.w	line
	dc.w	15
	dc.l	0
	dc.w	-1
	dc.w	-1
	dc.w	1
	dc.w	0
	dc.w	0,0
	dc.w	0,0,0,0
wp4vpb: ds.w	20
warp4shot:
	dc.l	wp4vpb
	dc.w	0,0,0
	dc.l	warpshotvrt
	dc.l	warpshotface
	dc.w	line
	dc.w	15
	dc.l	0
	dc.w	-1
	dc.w	-1
	dc.w	1
	dc.w	0
	dc.w	0,0
	dc.w	0,0,0,0
wp5vpb: ds.w	20
warp5shot:
	dc.l	wp5vpb
	dc.w	0,0,0
	dc.l	warpshotvrt
	dc.l	warpshotface
	dc.w	line
	dc.w	15
	dc.l	0
	dc.w	-1
	dc.w	-1
	dc.w	1
	dc.w	0
	dc.w	0,0
	dc.w	0,0,0,0
warpshotvrt:
	dc.w	6
	dc.w	-10,0,0
	dc.w	10,0,0
	dc.w	0,-10,0
	dc.w	0,10,0
	dc.w	0,0,-10
	dc.w	0,0,10
warpshotface:
	dc.w	3
	dc.w	1,0,1
	dc.w	1,2,3
	dc.w	1,4,5

pathvpb:
	ds.w	20
path0:
	dc.l	pathvpb
	dc.w	0,0,1000
	dc.l	pathvrt
	dc.l	pathface
	dc.w	line
	dc.w	5
	dc.l	0
	dc.w	-1
	dc.w	-1
	dc.w	1
	dc.w	0
	dc.w	0,0
	dc.w	0,0,0,0
path1:
	dc.l	pathvpb
	dc.w	0,0,2000
	dc.l	pathvrt
	dc.l	pathface
	dc.w	line
	dc.w	5
	dc.l	0
	dc.w	-1
	dc.w	-1
	dc.w	1
	dc.w	0
	dc.w	0,0
	dc.w	0,0,0,0
path2:
	dc.l	pathvpb
	dc.w	0,0,3000
	dc.l	pathvrt
	dc.l	pathface
	dc.w	line
	dc.w	5
	dc.l	0
	dc.w	-1
	dc.w	-1
	dc.w	1
	dc.w	0
	dc.w	0,0
	dc.w	0,0,0,0
path3:
	dc.l	pathvpb
	dc.w	0,0,4000
	dc.l	pathvrt
	dc.l	pathface
	dc.w	line
	dc.w	5
	dc.l	0
	dc.w	-1
	dc.w	-1
	dc.w	1
	dc.w	0
	dc.w	0,0
	dc.w	0,0,0,0
path4:
	dc.l	pathvpb
	dc.w	0,0,5000
	dc.l	pathvrt
	dc.l	pathface
	dc.w	line
	dc.w	5
	dc.l	0
	dc.w	-1
	dc.w	-1
	dc.w	1
	dc.w	0
	dc.w	0,0
	dc.w	0,0,0,0
path5:
	dc.l	pathvpb
	dc.w	0,0,6000
	dc.l	pathvrt
	dc.l	pathface
	dc.w	line
	dc.w	5
	dc.l	0
	dc.w	-1
	dc.w	-1
	dc.w	1
	dc.w	0
	dc.w	0,0
	dc.w	0,0,0,0
pathvrt:
	dc.w	4
	dc.w	-50,50,0
	dc.w	50,50,0
	dc.w	50,-50,0
	dc.w	-50,-50,0
pathface:
	dc.w	1
	dc.w	3,0,1,2,3

explosion1:
	dc.w	6,6
	 dc.w	$0000,$0000,$0000,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$0000,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$0000
explosion2:
	dc.w	9,11
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$0000,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$0000,$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$0000,$0000,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000
explosion3:
	dc.w	9,13
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF
	 dc.w	$0000,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$0000,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$0000,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF
	 dc.w	$0000,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000
explosion4:
	dc.w	10,15
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF
	 dc.w	$0000,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$0000,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$0000,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$0000,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$0000,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$0000,$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
explosion5:
	dc.w	10,16
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$0000,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$0000,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$0000,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$0000,$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
explosion6:
	dc.w	9,14
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$0000,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$0000,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$0000,$0000,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$0000,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
explosion7:
	dc.w	8,13
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$0000,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
explosion8:
	dc.w	8,11
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
explosion9:
	dc.w	7,11
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000
explosion10:
	dc.w	6,11
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
explosion11:
	dc.w	5,10
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
explosion12:
	dc.w	5,6
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
explosion13:
	dc.w	5,6
	 dc.w	$0000,$0000,$0000,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$0000,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
explosion14:
	dc.w	5,5
	 dc.w	$0000,$0000,$0000,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$0000

planet1:
	 dc.w	$0000,$007F,$007F,$0000,$0000,$0000,$0000,$0000
	 dc.w	$002D,$01C0,$01FF,$0000,$8000,$4000,$C000,$0000
	 dc.w	$0078,$0780,$07FF,$0000,$E000,$1000,$F000,$0000
	 dc.w	$00F0,$0F00,$0FFF,$0000,$3000,$0800,$F800,$0000
	 dc.w	$0174,$1E00,$1FFF,$0000,$4800,$0400,$FC00,$0000
	 dc.w	$07B0,$3800,$3FFF,$0000,$4400,$0200,$FE00,$0000
	 dc.w	$03DC,$3C00,$3FFF,$0000,$0400,$0200,$FE00,$0000
	 dc.w	$07FC,$7800,$7FFF,$0000,$0600,$0100,$FF00,$0000
	 dc.w	$07E0,$7800,$7FFF,$0000,$0600,$0100,$FF00,$0000
	 dc.w	$17C0,$E800,$FFFF,$0000,$1B00,$0080,$FF80,$0000
	 dc.w	$1FE4,$E000,$FFFF,$0000,$1300,$0080,$FF80,$0000
	 dc.w	$07B4,$F800,$FFFF,$0000,$1300,$0080,$FF80,$0000
	 dc.w	$0730,$F800,$FFFF,$0000,$B700,$0080,$FF80,$0000
	 dc.w	$0FB7,$F000,$FFFF,$0000,$B600,$0180,$FF80,$0000
	 dc.w	$1FFC,$E000,$FFFF,$0000,$D400,$0180,$FF80,$0000
	 dc.w	$0BFD,$F400,$FFFF,$0000,$7F00,$0080,$FF80,$0000
	 dc.w	$07FD,$7800,$7FFF,$0000,$3E00,$0100,$FF00,$0000
	 dc.w	$07DF,$7800,$7FFF,$0000,$3E00,$0100,$FF00,$0000
	 dc.w	$05FD,$3A00,$3FFF,$0000,$3C00,$0200,$FE00,$0000
	 dc.w	$0DDB,$3200,$3FFF,$0000,$FC00,$0200,$FE00,$0000
	 dc.w	$05FF,$1A00,$1FFF,$0000,$E000,$1C00,$FC00,$0000
	 dc.w	$00FF,$0F00,$0FFF,$0000,$E000,$1800,$F800,$0000
	 dc.w	$009F,$0760,$07FF,$0000,$8000,$7000,$F000,$0000
	 dc.w	$001F,$01E0,$01FF,$0000,$0000,$C000,$C000,$0000
	 dc.w	$0006,$0079,$007F,$0000,$0000,$0000,$0000,$0000
planet2:
	 dc.w	$0190,$0248,$0000,$03F8,$0000,$0000,$0000,$0000
	 dc.w	$0002,$0FF8,$0000,$0FFE,$0000,$0000,$0000,$0000
	 dc.w	$0C00,$1177,$0000,$1FFF,$0000,$0000,$0000,$0000
	 dc.w	$0840,$35D3,$0040,$3FBF,$0000,$8000,$0000,$8000
	 dc.w	$04A8,$7BBE,$00A8,$7F57,$0000,$4000,$0000,$C000
	 dc.w	$2043,$5CFB,$0043,$7FBC,$0000,$4000,$0000,$C000
	 dc.w	$001F,$FD7F,$001F,$FFE0,$0000,$6000,$0000,$E000
	 dc.w	$400F,$BFBF,$000F,$FFF0,$2000,$C000,$0000,$E000
	 dc.w	$1C86,$E3AF,$0086,$FF79,$0000,$2000,$0000,$E000
	 dc.w	$1A00,$E5A7,$0000,$FFFF,$A000,$8000,$8000,$6000
	 dc.w	$121C,$ECFF,$001C,$FFE3,$0000,$2000,$0000,$E000
	 dc.w	$0F0C,$F0BD,$000C,$FFF3,$2000,$C000,$0000,$E000
	 dc.w	$2906,$D43F,$0006,$FFF9,$0000,$2000,$0000,$E000
	 dc.w	$0600,$78E8,$0000,$7FFF,$0000,$4000,$0000,$C000
	 dc.w	$1300,$6CE4,$0000,$7FFF,$0000,$C000,$0000,$C000
	 dc.w	$0D80,$3265,$0000,$3FFF,$0000,$8000,$0000,$8000
	 dc.w	$04C1,$1B24,$0000,$1FFF,$0000,$0000,$0000,$0000
	 dc.w	$0560,$0A8E,$0000,$0FFE,$0000,$0000,$0000,$0000
	 dc.w	$0108,$02F0,$0000,$03F8,$0000,$0000,$0000,$0000
planet3:
	 dc.w	$0000,$0F80,$0980,$0600,$0200,$39A0,$0B80,$3460
	 dc.w	$5250,$2920,$0B60,$7490,$1920,$6050,$3FB0,$4040
	 dc.w	$21A0,$DD98,$2DA0,$D258,$0420,$ED08,$CFE0,$3018
	 dc.w	$8590,$6FF8,$2FD0,$D028,$0030,$FF58,$3DF8,$C200
	 dc.w	$1280,$CCF8,$DFF0,$2008,$2880,$4D70,$49D0,$3620
	 dc.w	$0080,$7FD0,$3F80,$4070,$0600,$32A0,$1680,$2960
	 dc.w	$0180,$0F00,$0500,$0A80

planet4:
	 dc.w	$00C0,$03A0,$03E0,$0000,$0000,$0000,$0000,$0000
	 dc.w	$00E8,$0860,$0068,$0F90,$0000,$0000,$0000,$0000
	 dc.w	$0800,$150C,$0000,$1FFC,$0000,$0000,$0000,$0000
	 dc.w	$0AC8,$3516,$22E4,$1D1A,$0000,$0000,$0000,$0000
	 dc.w	$3760,$48A3,$3F3E,$40C1,$0000,$0000,$0000,$0000
	 dc.w	$2444,$5849,$5D74,$228B,$0000,$0000,$0000,$0000
	 dc.w	$3F81,$C000,$FFFE,$0001,$0000,$8000,$8000,$0000
	 dc.w	$7F88,$80A1,$7FDE,$8021,$0000,$8000,$0000,$8000
	 dc.w	$1243,$E620,$0215,$FDEA,$0000,$8000,$8000,$0000
	 dc.w	$50A1,$A0A2,$80A0,$7F5F,$8000,$0000,$0000,$8000
	 dc.w	$3009,$C008,$0008,$FFF7,$8000,$0000,$0000,$8000
	 dc.w	$0139,$70AC,$002A,$7FD5,$0000,$0000,$0000,$0000
	 dc.w	$0582,$7A01,$6DF3,$120C,$0000,$0000,$0000,$0000
	 dc.w	$1D8E,$2010,$2DB8,$1246,$0000,$0000,$0000,$0000
	 dc.w	$0C90,$1294,$18F4,$0708,$0000,$0000,$0000,$0000
	 dc.w	$0778,$0830,$0078,$0F80,$0000,$0000,$0000,$0000
	 dc.w	$0180,$0260,$0260,$0180,$0000,$0000,$0000,$0000
planet5:
	 dc.w	$0000,$01FC,$0000,$01FC,$0000,$0000,$0000,$0000
	 dc.w	$02E2,$0401,$0000,$07FF,$0000,$0000,$0000,$0000
	 dc.w	$048C,$0A08,$0008,$0FF7,$0000,$8000,$0000,$8000
	 dc.w	$1FB5,$0014,$0014,$1FEB,$4000,$0000,$0000,$C000
	 dc.w	$0D04,$3004,$0004,$3FFB,$2000,$0000,$0000,$E000
	 dc.w	$3C5F,$411F,$001F,$7FE0,$1000,$0000,$0000,$F000
	 dc.w	$1C7F,$607F,$007F,$7F80,$0000,$1000,$0000,$F000
	 dc.w	$306F,$C06F,$006F,$FF90,$9000,$8800,$8000,$7800
	 dc.w	$796F,$806F,$006F,$FF90,$0000,$0800,$0000,$F800
	 dc.w	$501F,$A01F,$001F,$FFE0,$B800,$A000,$A000,$5800
	 dc.w	$325D,$C05D,$005D,$FFA2,$A800,$8000,$8000,$7800
	 dc.w	$D809,$2009,$0009,$FFF6,$9000,$8800,$8000,$7800
	 dc.w	$001F,$D81F,$001F,$FFE0,$D000,$8800,$8000,$7800
	 dc.w	$2607,$D807,$0007,$FFF8,$0800,$1000,$0000,$F800
	 dc.w	$081C,$7014,$0014,$7FEB,$4000,$3000,$0000,$F000
	 dc.w	$0900,$7000,$0000,$7FFF,$4000,$3000,$0000,$F000
	 dc.w	$0B00,$3400,$0000,$3FFF,$0000,$E000,$0000,$E000
	 dc.w	$0700,$1800,$0000,$1FFF,$0000,$4000,$0000,$C000
	 dc.w	$0367,$0C80,$0000,$0FFF,$0000,$8000,$0000,$8000
	 dc.w	$01AE,$0601,$0000,$07FF,$0000,$0000,$0000,$0000
	 dc.w	$00D8,$0124,$0000,$01FC,$0000,$0000,$0000,$0000
planet6:
	 dc.w	$0280,$0160,$0200,$03E0,$0000,$0000,$0000,$0000
	 dc.w	$0720,$0A08,$0180,$0FF8,$0000,$0000,$0000,$0000
	 dc.w	$0F84,$1180,$02A0,$1F7C,$0000,$0000,$0000,$0000
	 dc.w	$0576,$3070,$0420,$3FDE,$0000,$0000,$0000,$0000
	 dc.w	$3879,$4078,$0878,$7F87,$0000,$0000,$0000,$0000
	 dc.w	$28FE,$40FD,$00E0,$7F1F,$0000,$0000,$0000,$0000
	 dc.w	$21BF,$C3BF,$018C,$FE73,$0000,$0000,$8000,$8000
	 dc.w	$01F8,$EDF8,$01B8,$FE47,$0000,$8000,$0000,$8000
	 dc.w	$60B7,$80B5,$4134,$FFCB,$8000,$0000,$0000,$8000
	 dc.w	$DCB8,$00B9,$DEB8,$FF47,$0000,$8000,$0000,$8000
	 dc.w	$207F,$C07E,$007C,$FF83,$0000,$8000,$0000,$8000
	 dc.w	$0472,$6871,$0070,$7F8F,$0000,$0000,$0000,$0000
	 dc.w	$101C,$6817,$1014,$7FEB,$0000,$0000,$0000,$0000
	 dc.w	$3D00,$0002,$2800,$3FFE,$0000,$0000,$0000,$0000
	 dc.w	$0F24,$1000,$0304,$1FFC,$0000,$0000,$0000,$0000
	 dc.w	$02E8,$0C40,$0208,$0FF8,$0000,$0000,$0000,$0000
	 dc.w	$01C0,$0260,$0000,$03E0,$0000,$0000,$0000,$0000
planet7:
	 dc.w	$0380,$0060,$03E0,$0280,$0000,$0000,$0000,$0000
	 dc.w	$05D0,$0A08,$0FF8,$00E0,$0000,$0000,$0000,$0000
	 dc.w	$0550,$1A84,$1FFC,$0528,$0000,$0000,$0000,$0000
	 dc.w	$1BEE,$2500,$3EFE,$1338,$0000,$0000,$0000,$0000
	 dc.w	$1738,$4A01,$7DFF,$262E,$0000,$0000,$0000,$0000
	 dc.w	$6D8A,$1381,$7E7F,$698E,$0000,$0000,$0000,$0000
	 dc.w	$2BE2,$C500,$FEFF,$1BE3,$0000,$8000,$8000,$0000
	 dc.w	$43E2,$A400,$FFFF,$1AC3,$0000,$8000,$8000,$0000
	 dc.w	$7EEF,$8040,$FFBF,$08E8,$0000,$0000,$8000,$8000
	 dc.w	$35D1,$C810,$FFEF,$3210,$0000,$8000,$8000,$0000
	 dc.w	$329F,$C010,$FFEF,$1F18,$0000,$0000,$8000,$8000
	 dc.w	$1E36,$6110,$7FEF,$18B1,$0000,$0000,$0000,$0000
	 dc.w	$3FBE,$4005,$7FFB,$25CC,$0000,$0000,$0000,$0000
	 dc.w	$213C,$1E08,$3FF6,$21EA,$0000,$0000,$0000,$0000
	 dc.w	$0F38,$100C,$1FF4,$02C8,$0000,$0000,$0000,$0000
	 dc.w	$02D8,$0D10,$0FE8,$0070,$0000,$0000,$0000,$0000
	 dc.w	$0100,$02A0,$03E0,$0140,$0000,$0000,$0000,$0000
planet8:
	 dc.w	$0800,$1000,$1000,$0E00,$2000,$0900,$0900,$3600
	 dc.w	$2100,$4180,$4380,$3C00,$8500,$6E80,$2F80,$D000
	 dc.w	$C240,$0200,$0200,$FDC0,$C300,$0740,$0700,$F8C0
	 dc.w	$4100,$8D00,$0D00,$F280,$3180,$4C00,$0C00,$7380
	 dc.w	$3300,$0000,$0000,$3F00,$0C00,$0000,$0000,$0C00
planet9:
	 dc.w	$0000,$0F80,$0F80,$0000,$0240,$3F60,$3F60,$0080
	 dc.w	$4000,$2090,$7FF0,$0000,$20C0,$5C10,$7FF0,$0000
	 dc.w	$8DE0,$7218,$FFF8,$0000,$0FF0,$F008,$FFF8,$0000
	 dc.w	$5010,$AFE8,$FFF8,$0000,$94D0,$6B28,$6B78,$94D0
	 dc.w	$DDE8,$2210,$EFD8,$DDE8,$17A0,$6850,$5DD0,$37A0
	 dc.w	$4B50,$34A0,$14E0,$6B50,$04C0,$3B20,$1980,$26E0
	 dc.w	$0980,$0600,$0400,$0B80
planet10:
	 dc.w	$0180,$0260,$0180,$0260,$0000,$0000,$0000,$0000
	 dc.w	$0070,$0C08,$0390,$0C68,$0000,$0000,$0000,$0000
	 dc.w	$0A14,$1008,$04C4,$1B38,$0000,$0000,$0000,$0000
	 dc.w	$14A6,$2808,$0152,$3EAC,$0000,$0000,$0000,$0000
	 dc.w	$6D00,$1003,$401C,$3FE3,$0000,$0000,$0000,$0000
	 dc.w	$05D0,$78D7,$00D0,$7F2F,$0000,$0000,$0000,$0000
	 dc.w	$9CB6,$6031,$8030,$7FCF,$0000,$8000,$0000,$8000
	 dc.w	$3C3C,$C038,$1C3B,$E3C4,$0000,$8000,$0000,$8000
	 dc.w	$6EF8,$90FA,$ECF9,$1306,$0000,$8000,$0000,$8000
	 dc.w	$B461,$4060,$A060,$5F9F,$0000,$8000,$0000,$8000
	 dc.w	$2205,$D002,$A000,$5FFF,$0000,$8000,$0000,$8000
	 dc.w	$162E,$6801,$5020,$2FDF,$0000,$0000,$0000,$0000
	 dc.w	$1D0C,$6001,$0800,$77FF,$0000,$0000,$0000,$0000
	 dc.w	$0FB0,$304E,$0000,$3FFE,$0000,$0000,$0000,$0000
	 dc.w	$09C8,$1604,$0080,$1F7C,$0000,$0000,$0000,$0000
	 dc.w	$00D0,$0E08,$0480,$0B78,$0000,$0000,$0000,$0000
	 dc.w	$0080,$0320,$0080,$0360,$0000,$0000,$0000,$0000
planet11:
	 dc.w	$0000,$0F80,$0000,$0F80,$1480,$2260,$1C00,$3FE0
	 dc.w	$0980,$7630,$0040,$7FF0,$38E0,$41D0,$0000,$7FF0
	 dc.w	$3BD0,$C468,$03C0,$FFB8,$2590,$C188,$0C00,$FFF8
	 dc.w	$27D0,$C5C8,$33C0,$FE38,$00D0,$E0C8,$04C0,$FF38
	 dc.w	$3888,$C080,$1480,$FF78,$0820,$7010,$0000,$7FF0
	 dc.w	$3240,$4810,$3000,$7FF0,$1420,$2B00,$1020,$3FE0
	 dc.w	$0480,$0800,$0080,$0F80
planet12:
	 dc.w	$01F8,$0004,$01D8,$01FC,$0000,$0000,$0000,$0000
	 dc.w	$0769,$0060,$077D,$079F,$0000,$0000,$0000,$0000
	 dc.w	$0F4B,$0100,$0F9E,$0EFF,$8000,$0000,$8000,$8000
	 dc.w	$11D2,$0100,$13EE,$1EFF,$C000,$0000,$C000,$C000
	 dc.w	$340A,$000A,$27F4,$3FFF,$E000,$0000,$E000,$E000
	 dc.w	$7A8F,$000E,$7EF7,$7FF9,$D000,$8000,$F000,$7000
	 dc.w	$518C,$000C,$5773,$7FFF,$1000,$0000,$F000,$F000
	 dc.w	$D87F,$003F,$1FCC,$FFF3,$1800,$0000,$F800,$F800
	 dc.w	$FAFF,$007F,$6FD4,$FFAB,$8000,$8000,$7800,$F800
	 dc.w	$FC6F,$006F,$F674,$FF9B,$7800,$4000,$B800,$F800
	 dc.w	$FA3E,$003E,$FA61,$FFDF,$C800,$8000,$7800,$F800
	 dc.w	$E96E,$006E,$FFD1,$FFBF,$9800,$0000,$E800,$F800
	 dc.w	$F90D,$000D,$FBF2,$FFFF,$2800,$0000,$D800,$F800
	 dc.w	$FC11,$0011,$FCEE,$FFFF,$A800,$0000,$D800,$F800
	 dc.w	$7F07,$0001,$67FD,$7FFE,$3000,$0000,$D000,$F000
	 dc.w	$7320,$0020,$6BD8,$7FFF,$9000,$0000,$7000,$F000
	 dc.w	$3D93,$0012,$3F5A,$3FED,$2000,$0000,$6000,$E000
	 dc.w	$1EA3,$0000,$17FC,$1FFF,$C000,$0000,$C000,$C000
	 dc.w	$0F49,$0000,$0FB3,$0FFF,$8000,$0000,$8000,$8000
	 dc.w	$03EB,$0420,$0377,$07DF,$0000,$0000,$0000,$0000
	 dc.w	$0188,$000C,$01E8,$01F4,$0000,$0000,$0000,$0000
planet13:
	 dc.w	$0048,$01B4,$0020,$01DC,$0000,$0000,$0000,$0000
	 dc.w	$0154,$0681,$0204,$05FB,$0000,$0000,$0000,$0000
	 dc.w	$0221,$0D88,$0211,$0DEE,$0000,$8000,$0000,$8000
	 dc.w	$0841,$16A0,$0440,$1BBF,$8000,$4000,$0000,$C000
	 dc.w	$0108,$3600,$0100,$3EFF,$C000,$2000,$0000,$E000
	 dc.w	$0ED8,$7018,$1E98,$6167,$1000,$A000,$0000,$F000
	 dc.w	$3DCE,$400E,$184E,$67B1,$6000,$1000,$1000,$E000
	 dc.w	$1C1E,$E11E,$181E,$E7E1,$3000,$0800,$0800,$F000
	 dc.w	$2E1E,$D01E,$203E,$DFC1,$B000,$0800,$0000,$F800
	 dc.w	$288F,$C70F,$001F,$FFE0,$A000,$0800,$0000,$F800
	 dc.w	$0435,$F014,$441C,$BBE3,$3000,$0800,$0000,$F800
	 dc.w	$0758,$F818,$041C,$FBE3,$5000,$0800,$0000,$F800
	 dc.w	$1C00,$E000,$7C00,$83FF,$1000,$0800,$0000,$F800
	 dc.w	$1FF1,$E000,$7FE2,$801D,$1000,$4800,$0800,$F000
	 dc.w	$129C,$6000,$421E,$3DE1,$8000,$1000,$0000,$F000
	 dc.w	$3098,$4C02,$4001,$3FFE,$C000,$3000,$8000,$7000
	 dc.w	$0F80,$3000,$0100,$3EFF,$8000,$2000,$8000,$6000
	 dc.w	$0BA7,$1410,$0400,$1BFF,$0000,$4000,$0000,$C000
	 dc.w	$0003,$0B0C,$0002,$0FFD,$0000,$8000,$8000,$0000
	 dc.w	$0244,$05A1,$0000,$07FF,$0000,$0000,$0000,$0000
	 dc.w	$0028,$01C4,$0000,$01FC,$0000,$0000,$0000,$0000
planet14:
	 dc.w	$0300,$0060,$0280,$0160,$0000,$0000,$0000,$0000
	 dc.w	$0720,$0258,$0360,$0C98,$0000,$0000,$0000,$0000
	 dc.w	$0FD2,$1304,$17F0,$080E,$0000,$0000,$0000,$0000
	 dc.w	$17F1,$2222,$1FEC,$2013,$0000,$0000,$0000,$0000
	 dc.w	$53F8,$2449,$34F8,$4B07,$0000,$0000,$0000,$0000
	 dc.w	$386C,$4402,$3E2D,$41D2,$0000,$8000,$0000,$8000
	 dc.w	$9668,$2880,$2431,$DBCE,$4000,$0000,$8000,$4000
	 dc.w	$1884,$F322,$73BF,$8C40,$C000,$0000,$0000,$C000
	 dc.w	$1118,$E65C,$857F,$7A80,$C000,$0000,$0000,$C000
	 dc.w	$6215,$CC88,$C77A,$3885,$4000,$0000,$8000,$4000
	 dc.w	$E4A5,$189A,$9394,$6C6B,$4000,$0000,$8000,$4000
	 dc.w	$2946,$5324,$5D35,$22CA,$0000,$8000,$0000,$8000
	 dc.w	$52AC,$2D40,$2B21,$54DE,$8000,$0000,$0000,$8000
	 dc.w	$1074,$2191,$0856,$37A9,$0000,$0000,$0000,$0000
	 dc.w	$04B9,$1202,$149C,$0B63,$0000,$0000,$0000,$0000
	 dc.w	$0622,$01C4,$0358,$0CA6,$0000,$0000,$0000,$0000
	 dc.w	$0188,$0200,$00F0,$0308,$0000,$0000,$0000,$0000
solmaplist:
	dc.l	solmap0
	dc.l	solmap1,solmap2,solmap3,solmap4,solmap5,solmap6
	dc.l	solmap7,solmap8,solmap9,solmap10,solmap11
solmap0:
	dc.l	sollist0
	dc.l	soltextlist0
	dc.l	smap0text	;text for system
	dc.l	sol0info
	dc.w	5		;number of planets	
	dc.w	52,65		;xy of planet
	dc.l	planet8sp	;which one
	dc.w	86,64		;xy of planet
	dc.l	planet3sp	;which one
	dc.w	112,61		;xy of planet
	dc.l	planet2sp	;which one
	dc.w	151,59		;xy of planet
	dc.l	planet1sp	;which one
	dc.w	249,62		;xy of planet
	dc.l	planet13sp	;which one
sollist0:
	dc.w	5
	dc.w	52,65,62,75,0,7
	dc.l	p0000info
	dc.w	86,64,99,77,1,2
	dc.l	p0001info
	dc.w	112,61,112+19,61+19,2,1
	dc.l	p0002info
	dc.w	151,59,151+$19,59+$19,3,0
	dc.l	p0003info
	dc.w	249,62,249+$15,62+$15,4,12
	dc.l	p0004info
	even
sol0info:
	dc.w	0
	dc.w	-117,44 		;solar coords
	dc.w	5			;number of planets
	dc.w	regular 		;type of orbits
	dc.w	36,17
	dc.w	fighter1			;type of 3d bit at start
	dc.b	'LISTER',-1
	even
soltextlist0:
	dc.l	stl00,stl01,stl02,stl03,stl04
smap0text:
	DC.B	20,0,'LISTER',0,0
	DC.B	7,1,'5 PLANET SYSTEMS IN REGULAR ORBITS',0,0
	dc.b	40,14,'GI00RE',0,-1,-1
stl00:
	DC.B	20,0,'DRAXOL',0,0
	DC.B	1,2,'UNINHABITED PLANET CLOSEST',0,0
	DC.B	1,3,'TO THE LISTER SYSTEM SUN.',0,0
	DC.B	1,4,'UNEXPLORED AND CONSIDERED',0,0
	DC.B	1,5,'WORTHLESS FOR ANY PURPOSE.',0,0
	DC.B	1,6,'GLACTIC MASS 1.3',0,0
	DC.B	1,8,'NSUSNTNA0000',0,-1,-1
	
stl01:
	DC.B	20,0,'LANTH',0,0
	DC.B	1,2,'MINING PLANET HONEYCOMBED',0,0
	DC.B	1,3,'TUNNELS. ABANDONED IN 2525',0,0
	DC.B	1,4,'FOR UNKNOWN REASONS.',0,0
	DC.B	1,5,'CONSIDERED DANGEROUS.',0,0
	DC.B	1,6,'GLACTIC MASS 1.0',0,0
	DC.B	1,8,'NSUSNTNA0001',0,-1,-1
stl02:
	DC.B	20,0,'ZALOR',0,0
	DC.B	1,2,'NO INFORMATION IN DATA TANK.',0,0
	DC.B	1,3,'GLACTIC MASS 1.78',0,0
	DC.B	1,5,'NSUSNTAT0002',0,-1,-1
stl03:
	DC.B	17,0,'RAZORS WAY',0,0
	DC.B	1,2,'DISCOVERED BY RAZOR IN 2004',0,0
	DC.B	1,3,'HE PERISHED IN AN ATTEMPT TO',0,0
	DC.B	1,4,'COLONISE THE PLANET WHICH IS',0,0
	DC.B	1,5,'NOW ABANDONED AND DERELICT.',0,0
	DC.B	1,6,'GLACTIC MASS 1.44',0,0
	DC.B	1,8,'LSUSNTAT0003',0,-1,-1
stl04:
	DC.B	20,0,'TRAXL',0,0
	DC.B	1,2,'COLDEST AND FURTHEST FROM',0,0
	DC.B	1,3,'THE LISTER SUN. NOT CHARTED',0,0
	DC.B	1,4,'UNTIL LATE IN THE',0,0
	DC.B	1,5,'EPLORATION OF THE SYSTEM',0,0
	DC.B	1,6,'DUE TO AN UNEXPLAINED RADAR.',0,0
	DC.B	1,7,'INVISIBILITY.',0,0
	DC.B	1,8,'GLACTIC MASS 0.56',0,0
	DC.B	1,10,'NSUSNTAT0004',0,-1,-1
	even
solmap1:
	dc.l	sollist1
	dc.l	soltextlist1
	dc.l	smap1text	;text for system
	dc.l	sol1info
	dc.w	3		;number of planets	
	dc.w	51,56		;xy of planet
	dc.l	planet12sp	;which one
	dc.w	133,56		;xy of planet
	dc.l	planet5sp	;which one
	dc.w	249,63		;xy of planet
	dc.l	planet8sp	;which one
sollist1:
	dc.w	3
	dc.w	51,56,71,76,0,11
	dc.l	p0100info
	dc.w	133,56,153,76,1,4
	dc.l	p0101info
	dc.w	249,63,258,72,2,7
	dc.l	p0102info
sol1info:
	dc.w	1
	dc.w	-108,-38		;solar coords
	dc.w	3			;number of planets
	dc.w	regular 		;type of orbits
	dc.w	44,97
	dc.w	fighter1			;type of 3d bit at start
	dc.b	'WARDEN',-1
	even
soltextlist1:
	dc.l	stl10,stl11,stl12
smap1text:
	DC.B	20,0,'WARDEN',0,0
	DC.B	7,1,'3 PLANET SYSTEMS IN REGULAR ORBITS',0,0
	dc.b	40,14,'GI01RE',0,-1,-1
stl10:
	DC.B	20,0,'LOCKERS',0,0
	DC.B	1,2,'PART OF SYSTEMS',0,0
	DC.B	1,3,'PRISON SYSTEM. RECORDS',0,0
	DC.B	1,4,'SHOW NO SUCCESSFUL ESCAPES.',0,0
	DC.B	1,5,'HEAVILY GUARDED AND',0,0
	DC.B	1,6,'POLLUTED.',0,0
	DC.B	1,7,'GLACTIC MASS 2.3',0,0
	DC.B	1,9,'LSSELTAT0100',0,-1,-1
stl11:
	DC.B	17,0,'PAPILLON',0,0
	DC.B	1,2,'GUARD PLANET FOR LOCKERS.',0,0
	DC.B	1,3,'COLD SLOWLY ROTATING',0,0
	DC.B	1,4,'PLANET. SECOND FUNCTION AS',0,0
	DC.B	1,5,'TRADE AND SUPPLY DEPOT.',0,0
	DC.B	1,6,'GLACTIC MASS 1.98',0,0
	DC.B	1,8,'LSSEHTAT0101',0,-1,-1
stl12:
	DC.B	20,0,'KEY',0,0
	DC.B	1,2,'QUARRANTINE PLANET FOR',0,0
	DC.B	1,3,'ENTIRE SYSTEM. ENTRY INTO',0,0
	DC.B	1,4,'SYSTEM WITHOUT PROPER',0,0
	DC.B	1,5,'PAPERS ILLEGAL AND',0,0
	DC.B	1,6,'DANGEROUS.',0,0
	DC.B	1,7,'GLACTIC MASS 2.1',0,0
	DC.B	1,9,'NSSEHTNA0102',0,-1,-1
	even
solmap2:
	dc.l	sollist2
	dc.l	soltextlist2
	dc.l	smap2text	;text for system
	dc.l	sol2info
	dc.w	6		;number of planets	
	dc.w	54,58		;xy of planet
	dc.l	planet11sp	;which one
	dc.w	96,58		;xy of planet
	dc.l	planet7sp	;which one
	dc.w	129,56		;xy of planet
	dc.l	planet13sp	;which one
	dc.w	164,55
	dc.l	planet1sp
	dc.w	220,60
	dc.l	planet14sp
	dc.w	264,62
	dc.l	planet3sp
sollist2:
	dc.w	6
	dc.w	54,58,70,74,0,10
	dc.l	p0200info
	dc.w	96,58,112,74,1,6
	dc.l	p0201info
	dc.w	129,56,149,76,2,12
	dc.l	p0202info
	dc.w	164,55,188,79,3,0
	dc.l	p0203info
	dc.w	220,60,235,76,4,13
	dc.l	p0204info
	dc.w	264,62,276,74,5,2
	dc.l	p0205info
sol2info:
	dc.w	2
	dc.w	-84,4
	dc.w	6
	dc.w	regular
	dc.w	68,57
	dc.w	nodefence
	dc.b	'CURSOR',-1
	even
soltextlist2:
	dc.l	stl20,stl21,stl22,stl23,stl24,stl25
smap2text:
	DC.B	20,0,'CURSOR',0,0
	DC.B	6,1,'6 PLANET SYSTEMS IN REGULAR ORBITS',0,0
	dc.b	40,14,'GI02RE',0,-1,-1
stl20:
	DC.B	20,0,'SAZOL',0,0
	DC.B	1,2,'SMALL UNINHABITED PLANET',0,0
	DC.B	1,3,'NO DISTINGUISHING',0,0
	DC.B	1,4,'FEATURES EXCEPT FOR',0,0
	DC.B	1,5,'UNUSUALLY HIGH GRAVITY',0,0
	DC.B	1,6,'FOR A PLANET OF THIS SIZE.',0,0
	DC.B	1,7,'GLACTIC MASS 2.93',0,0
	DC.B	1,9,'LSUSNTAT0200',0,-1,-1
stl21:
	DC.B	17,0,'DRALION',0,0
	DC.B	1,2,'SYSTEMS GOVERNMENT',0,0
	DC.B	1,3,'TRAINING BASE.',0,0
	DC.B	1,4,'HEAVILY GUARDED.',0,0
	DC.B	1,5,'GLACTIC MASS 2.04',0,0
	DC.B	1,7,'LSSEHTAT0201',0,-1,-1
stl22:
	DC.B	20,0,'WARTRAX',0,0
	DC.B	1,2,'FIRING RANGE FOR TRAINING',0,0
	DC.B	1,3,'TROUPS. AVOID.',0,0
	DC.B	1,4,'GLACTIC MASS 2.76',0,0
	DC.B	1,6,'NSUSNTNA0202',0,-1,-1
stl23:
	DC.B	20,0,'SCAR',0,0
	DC.B	1,2,'BARREN PLANET INCAPABLE OF',0,0
	DC.B	1,3,'SUPPORTING LIFE. HEAVILY',0,0
	DC.B	1,4,'CRATERED SURFACE DUE TO',0,0
	DC.B	1,5,'LACK OF ATMOSPHERE.',0,0
	DC.B	1,6,'GLACTIC MASS 0.69',0,0
	DC.B	1,8,'NSUSNTNA0203',0,-1,-1
stl24:
	DC.B	20,0,'AXIS',0,0
	DC.B	1,2,'CLOUD COVERED PLANET',0,0
	DC.B	1,3,'SURFACE UNMAPPED.',0,0
	DC.B	1,4,'GLACTIC MASS 0.56',0,0
	DC.B	1,6,'NSUNNTAT0204',0,-1,-1
stl25:
	DC.B	20,0,'TINY',0,0
	DC.B	1,2,'COLDEST PLANET OF THE',0,0
	DC.B	1,3,'SYSTEM. VERY LOW GRAVITY',0,0
	DC.B	1,4,'AND VERY FAST ROTATION',0,0
	DC.B	1,5,'GIVING IT UNUSUALLY HIGH',0,0
	DC.B	1,6,'MAGNETIC FIELD.',0,0
	DC.B	1,7,'GLACTIC MASS 0.12',0,0
	DC.B	1,9,'NSUSNTNA0205',0,-1,-1
	even
solmap3:
	dc.l	sollist3
	dc.l	soltextlist3
	dc.l	smap3text
	dc.l	sol3info
	dc.w	4
	dc.w	65,61
	dc.l	planet11sp
	dc.w	109,59
	dc.l	planet4sp
	dc.w	160,60
	dc.l	planet7sp
	dc.w	243,62
	dc.l	planet9sp
sollist3:
	dc.w	4
	dc.w	65,61,77,73,0,10
	dc.l	p0300info
	dc.w	109,59,125,75,1,3
	dc.l	p0301info
	dc.w	160,60,176,76,2,6
	dc.l	p0302info
	dc.w	243,62,255,74,3,8
	dc.l	p0303info
sol3info:
	dc.w	3
	dc.w	-44,36
	dc.w	4
	dc.w	regular
	dc.w	108,25
	dc.w	multidek
	dc.b	'KOTTERS WAY',-1
	even
soltextlist3:
	dc.l	stl30,stl31,stl32,stl33
smap3text:
	DC.B	17,0,'KOTTERS WAY',0,0
	DC.B	6,1,'4 PLANET SYSTEMS IN REGULAR ORBITS',0,0
	dc.b	40,14,'GI03RE',0,-1,-1
stl30:
	DC.B	20,0,'LANKER',0,0
	DC.B	1,2,'FAST SPINNING EARTH LIKE',0,0
	DC.B	1,3,'PLANET. COLONISED IN 2100',0,0
	DC.B	1,4,'ADOPTED COMMUNIST SYSTEMS',0,0
	DC.B	1,5,'RULES FROM INCEPTION.',0,0
	DC.B	1,6,'GALACTIC MASS 0.8',0,0
	DC.B	1,8,'LSSEHTAT0300',0,-1,-1
stl31:
	DC.B	20,0,'STRODAS',0,0
	DC.B	1,2,'MORE A GAS CLOUD THAN A',0,0
	DC.B	1,3,'PLANET. NO EXPLORATION',0,0
	DC.B	1,4,'TAKEN PLACE SINCE',0,0
	DC.B	1,5,'INITIAL DISCOVERY.',0,0
	DC.B	1,6,'GALACTIC MASS 0.3',0,0
	DC.B	1,8,'NSUSNTAT0301',0,-1,-1
stl32:
	DC.B	20,0,'PORTVAY',0,0
	DC.B	1,2,'HUGE BALL OF CHLORINE',0,0
	DC.B	1,3,'ICE. NO OTHER',0,0
	DC.B	1,4,'INFORMATION AVAILABLE.',0,0
	DC.B	1,5,'GALACTIC MASS 2.7',0,0
	DC.B	1,7,'NSUSNTNA0302',0,-1,-1
stl33:
	DC.B	20,0,'DASCAR',0,0
	DC.B	1,2,'SCIENTIFIC OBSERVATION',0,0
	DC.B	1,3,'BASE. RESEARCH INTO',0,0
	DC.B	1,4,'EXTREMEME COLD, AND',0,0
	DC.B	1,5,'DARKNESS.',0,0
	DC.B	1,6,'GALACTIC MASS 1.02',0,0
	DC.B	1,8,'NSSEHTNA0303',0,-1,-1
	even
solmap4:
	dc.l	sollist4
	dc.l	soltextlist4
	dc.l	smap4text
	dc.l	sol4info
	dc.w	4
	dc.w	53,59
	dc.l	planet10sp
	dc.w	122,60
	dc.l	planet6sp
	dc.w	165,56
	dc.l	planet1sp
	dc.w	253,62
	dc.l	planet14sp
sollist4:
	dc.w	4
	dc.w	53,59,69,75,0,9
	dc.l	p0400info
	dc.w	122,60,138,76,1,5
	dc.l	p0401info
	dc.w	165,56,189,80,2,0
	dc.l	p0402info
	dc.w	253,62,268,78,3,13
	dc.l	p0403info
sol4info:
	dc.w	4
	dc.w	6,36
	dc.w	4
	dc.w	irregular
	dc.w	156,25
	dc.w	multidek
	dc.b	'BRAXTER',-1
	even
soltextlist4:
	dc.l	stl40,stl41,stl42,stl43
smap4text:
	DC.B	17,0,'BRAXTER',0,0
	DC.B	6,1,'4 PLANET SYSTEMS IN IRREGULAR ORBITS',0,0
	dc.b	40,14,'GI04IR',0,-1,-1
stl40:
	DC.B	20,0,'HOCKER',0,0
	DC.B	1,2,'LIQUID COVERED PLANET',0,0
	DC.B	1,3,'WITH AN APPARENTLY',0,0
	DC.B	1,4,'METAL CORE. HIGHLY',0,0
	DC.B	1,5,'MAGNETIC.',0,0
	DC.B	1,6,'GALACTIC MASS 0.8',0,0
	DC.B	1,8,'NSUSNTAT0400',0,-1,-1
stl41:
	DC.B	20,0,'LITHNODE',0,0
	DC.B	1,2,'BARREN PLANET AS',0,0
	DC.B	1,3,'YET UNEXPLORED.',0,0
	DC.B	1,4,'GALACTIC MASS 2.3',0,0
	DC.B	1,6,'NSUSNTNA0401',0,-1,-1
stl42:
	DC.B	20,0,'CINTRAX',0,0
	DC.B	1,2,'NO INFORMATION IN',0,0
	DC.B	1,3,'COMP MEM.',0,0
	DC.B	1,4,'GALACTIC MASS 2.7',0,0
	DC.B	1,6,'NSUSNTNA0402',0,-1,-1
stl43:
	DC.B	20,0,'DRISCOL',0,0
	DC.B	1,2,'LAST PLANET IN THIS',0,0
	DC.B	1,3,'UNSETTLED SYSTEM.',0,0
	DC.B	1,4,'EXTREMEMELY COLD AND',0,0
	DC.B	1,5,'DARK.',0,0
	DC.B	1,6,'GALACTIC MASS 0.52',0,0
	DC.B	1,8,'NSUSNTAT0403',0,-1,-1
	even
solmap5:
	dc.l	sollist5
	dc.l	soltextlist5
	dc.l	smap5text
	dc.l	sol5info
	dc.w	4
	dc.w	47,55
	dc.l	planet13sp
	dc.w	119,63
	dc.l	planet8sp
	dc.w	164,57
	dc.l	planet12sp
	dc.w	203,58
	dc.l	planet2sp
sollist5:
	dc.w	4
	dc.w	47,55,67,75,0,12
	dc.l	p0500info
	dc.w	119,63,128,72,1,7
	dc.l	p0501info
	dc.w	164,57,184,77,2,11
	dc.l	p0502info
	dc.w	203,58,221,76,3,1
	dc.l	p0503info
sol5info:
	dc.w	5
	dc.w	6,20
	dc.w	4
	dc.w	irregular
	dc.w	156,41
	dc.w	fighter2
	dc.b	'CELESTA',-1
	even
soltextlist5:
	dc.l	stl50,stl51,stl52,stl53
smap5text:
	DC.B	17,0,'CELESTA',0,0
	DC.B	6,1,'4 PLANET SYSTEMS IN IRREGULAR ORBITS',0,0
	dc.b	40,14,'GI05IR',0,-1,-1
stl50:
	DC.B	20,0,'KULA',0,0
	DC.B	1,2,'DRY PLANET BAKED',0,0
	DC.B	1,3,'DUE TO ITS',0,0
	DC.B	1,4,'PROXIMITY TO THE',0,0
	DC.B	1,5,'CELESTA SUN.',0,0
	DC.B	1,6,'GALACTIC MASS 1.34',0,0
	DC.B	1,8,'NSUSNTAT0500',0,-1,-1
stl51:
	DC.B	20,0,'LOMA',0,0
	DC.B	1,2,'TINY SUPER DENSE',0,0
	DC.B	1,3,'PLANET WITH GRAVITY',0,0
	DC.B	1,4,'5 TIMES AS GREAT',0,0
	DC.B	1,5,'AS THAT ON EARTH.',0,0
	DC.B	1,6,'GALACTIC MASS 2.3',0,0
	DC.B	1,8,'LSUSNTAT0501',0,-1,-1
stl52:
	DC.B	20,0,'ZODAPH',0,0
	DC.B	1,2,'GREENHOUSE PLANET',0,0
	DC.B	1,3,'WITH 90 PERCENT',0,0
	DC.B	1,4,'THICK RAINFOREST',0,0
	DC.B	1,5,'COVERAGE.',0,0
	DC.B	1,6,'GALACTIC MASS 2.0',0,0
	DC.B	1,8,'LSSELTAT0502',0,-1,-1
stl53:
	DC.B	20,0,'KODAXIL',0,0
	DC.B	1,2,'COLD PLANET DUE',0,0
	DC.B	1,3,'NOT TO ITS DISTANCE.',0,0
	DC.B	1,4,'FROM THE SUN BUT',0,0
	DC.B	1,5,'BECAUSE IT IS IN THE',0,0
	DC.B	1,6,'SHADOW OF ZODAPH',0,0
	DC.B	1,7,'FOR ITS ENTIRE',0,0
	DC.B	1,8,'ORBIT.',0,0
	DC.B	1,9,'GALACTIC MASS 1.02',0,0
	DC.B	1,11,'NSUSNTNA0503',0,-1,-1
	even
solmap6:
	dc.l	sollist6
	dc.l	soltextlist6
	dc.l	smap6text
	dc.l	sol6info
	dc.w	6
	dc.w	44,60
	dc.l	planet10sp
	dc.w	79,58
	dc.l	planet5sp
	dc.w	136,57
	dc.l	planet1sp
	dc.w	189,62
	dc.l	planet6sp
	dc.w	233,62
	dc.l	planet13sp
	dc.w	271,62
	dc.l	planet13sp
sollist6:
	dc.w	6
	dc.w	44,60,60,76,0,9
	dc.l	p0600info
	dc.w	79,58,99,78,1,4
	dc.l	p0601info
	dc.w	136,57,160,81,2,0
	dc.l	p0602info
	dc.w	189,62,205,78,3,5
	dc.l	p0603info
	dc.w	233,62,253,82,4,12
	dc.l	p0604info
	dc.w	271,62,291,82,5,12
	dc.l	p0605info
sol6info:
	dc.w	6
	dc.w	6,-14
	dc.w	6
	dc.w	irregular
	dc.w	156,73
	dc.w	fighter2
	dc.b	'ROSEBUD',-1
	even
soltextlist6:
	dc.l	stl60,stl61,stl62,stl63,stl64,stl65
smap6text:
	DC.B	17,0,'ROSEBUD',0,0
	DC.B	6,1,'6 PLANET SYSTEMS IN IRREGULAR ORBITS',0,0
	dc.b	40,14,'GI06IR',0,-1,-1
stl60:
	DC.B	20,0,'JANZOR',0,0
	DC.B	1,2,'UNEXPLORED AND',0,0
	DC.B	1,3,'UNCHARTED PLANET',0,0
	DC.B	1,4,'IN CLOSE PROXIMITY',0,0
	DC.B	1,5,'TO THE ROSEBUD SUN.',0,0
	DC.B	1,6,'GALACTIC MASS 1.97',0,0
	DC.B	1,8,'NSUSNTNA0600',0,-1,-1
stl61:
	DC.B	20,0,'TULAPI',0,0
	DC.B	1,2,'SYSTEMS GOVERNMENT',0,0
	DC.B	1,3,'ADMINISTRATION',0,0
	DC.B	1,4,'CENTRE FOR LOCAL.',0,0
	DC.B	1,5,'REGION.',0,0
	DC.B	1,6,'GALACTIC MASS 2.0',0,0
	DC.B	1,8,'LSSEHTAT0601',0,-1,-1
stl62:
	DC.B	20,0,'RAZARE',0,0
	DC.B	1,2,'LARGE BARREN PLANET',0,0
	DC.B	1,3,'UNSETTLED AND',0,0
	DC.B	1,4,'CONSIDERED OF',0,0
	DC.B	1,5,'LITTLE IMPORTANCE.',0,0
	DC.B	1,6,'GALACTIC MASS 2.44',0,0
	DC.B	1,8,'NSUSNTAT0602',0,-1,-1
stl63:
	DC.B	20,0,'REVASH',0,0
	DC.B	1,2,'SMALLER LICHEN',0,0
	DC.B	1,3,'COVERED PLANET WITH',0,0
	DC.B	1,4,'LOW AVERAGE TEMP.',0,0
	DC.B	1,5,'AND ATMOSPHERE TOO',0,0
	DC.B	1,6,'THIN TO SUPPORT LIFE',0,0
	DC.B	1,7,'FORMS LARGER THAN',0,0
	DC.B	1,8,'A VIRUS.',0,0
	DC.B	1,9,'GALACTIC MASS 1.67',0,0
	DC.B	1,11,'NSUSNTNA0603',0,-1,-1
stl64:
	DC.B	20,0,'SORT',0,0
	DC.B	1,2,'THE FIRST PLANET ',0,0
	DC.B	1,3,'OF A FREAK TWIN',0,0
	DC.B	1,4,'PLANET ORBIT.',0,0
	DC.B	1,5,'VERY COLD AND DARK.',0,0
	DC.B	1,6,'GALACTIC MASS 1.57',0,0
	DC.B	1,8,'NSUSNTNA0604',0,-1,-1
stl65:
	DC.B	20,0,'OVERLAX',0,0
	DC.B	1,2,'THE SECOND PLANET ',0,0
	DC.B	1,3,'OF A FREAK TWIN',0,0
	DC.B	1,4,'PLANET ORBIT.',0,0
	DC.B	1,5,'VERY COLD AND DARK.',0,0
	DC.B	1,6,'GALACTIC MASS 1.55',0,0
	DC.B	1,8,'NSUSNTNA0605',0,-1,-1
	even
solmap7:
	dc.l	sollist7
	dc.l	soltextlist7
	dc.l	smap7text
	dc.l	sol7info
	dc.w	5
	dc.w	44,59
	dc.l	planet6sp
	dc.w	91,62
	dc.l	planet9sp
	dc.w	137,60
	dc.l	planet14sp
	dc.w	180,61
	dc.l	planet4sp
	dc.w	241,64
	dc.l	planet11sp
sollist7:
	dc.w	5
	dc.w	44,59,60,75,0,5
	dc.l	p0700info
	dc.w	91,62,103,74,1,8
	dc.l	p0701info
	dc.w	137,60,151,76,2,13
	dc.l	p0702info
	dc.w	180,61,196,77,3,3
	dc.l	p0703info
	dc.w	241,64,253,76,4,10
	dc.l	p0704info
sol7info:
	dc.w	7
	dc.w	6,-46
	dc.w	5
	dc.w	irregular
	dc.w	156,105
	dc.w	node
	dc.b	'KESSLERS SUN',-1
	even
soltextlist7:
	dc.l	stl70,stl71,stl72,stl73,stl74
smap7text:
	DC.B	17,0,'KESSLERS SUN',0,0
	DC.B	6,1,'5 PLANET SYSTEMS IN IRREGULAR ORBITS',0,0
	dc.b	40,14,'GI07IR',0,-1,-1
stl70:
	DC.B	20,0,'GRAZE',0,0
	DC.B	1,2,'WARM GRASSY PLANET',0,0
	DC.B	1,3,'WITH A PLEASANT',0,0
	DC.B	1,4,'CLIMATE DESPITE ITS',0,0
	DC.B	1,5,'CLOSE PROXIMITY TO',0,0
	DC.B	1,6,'THE KESSLER SUN. A',0,0
	DC.B	1,7,'RESULT OF THE SUNS',0,0
	DC.B	1,8,'SMALL SIZE.',0,0
	DC.B	1,9,'GALACTIC MASS 1.11',0,0
	DC.B	1,11,'LSSELTAT0700',0,-1,-1
stl71:
	DC.B	20,0,'BANDROX',0,0
	DC.B	1,2,'SMALL SETTLEMENT',0,0
	DC.B	1,3,'PLANET BASICALLY',0,0
	DC.B	1,4,'FORMING A SUPPLY',0,0
	DC.B	1,5,'CENTRE FOR GRAZE.',0,0
	DC.B	1,6,'GALACTIC MASS 1.0',0,0
	DC.B	1,8,'LSSEHTAT0701',0,-1,-1
stl72:
	DC.B	20,0,'DIAGER',0,0
	DC.B	1,2,'COOLER PLANET',0,0
	DC.B	1,3,'WITH SOME SETTLEMENT',0,0
	DC.B	1,4,'BUT NO REAL WORTH.',0,0
	DC.B	1,5,'GALACTIC MASS 2.02',0,0
	DC.B	1,7,'LSSELTAT0702',0,-1,-1
stl73:
	DC.B	20,0,'DYNAPRAC',0,0
	DC.B	1,2,'COLD SMALL PLANET',0,0
	DC.B	1,3,'COVERED IN BANDS',0,0
	DC.B	1,4,'OF METHANE AND',0,0
	DC.B	1,5,'CHLORINE.',0,0
	DC.B	1,6,'GALACTIC MASS 2.25',0,0
	DC.B	1,8,'NSUSNTNA0703',0,-1,-1
stl74:
	DC.B	20,0,'BYRNAZ',0,0
	DC.B	1,2,'NO DATA IN COMP MEM.',0,0
	DC.B	1,3,'GALACTIC MASS 1.83',0,0
	DC.B	1,5,'NSUSNTNA0704',0,-1,-1
	even
solmap8:
	dc.l	sollist8
	dc.l	soltextlist8
	dc.l	smap8text
	dc.l	sol8info
	dc.w	3
	dc.w	58,57
	dc.l	planet5sp
	dc.w	134,56
	dc.l	planet1sp
	dc.w	176,60
	dc.l	planet2sp
sollist8:
	dc.w	3
	dc.w	58,57,78,77,0,4
	dc.l	p0800info
	dc.w	134,56,158,80,1,0
	dc.l	p0801info
	dc.w	176,60,194,78,2,1
	dc.l	p0802info
sol8info:
	dc.w	8
	dc.w	38,20
	dc.w	3
	dc.w	regular
	dc.w	188,41
	dc.w	nodefence
	dc.b	'FLIP',-1
	even
soltextlist8:
	dc.l	stl80,stl81,stl82
smap8text:
	DC.B	17,0,'FLIP',0,0
	DC.B	6,1,'3 PLANET SYSTEMS IN REGULAR ORBITS',0,0
	dc.b	40,14,'GI08RE',0,-1,-1
stl80:
	DC.B	20,0,'TWEEDY',0,0
	DC.B	1,2,'DEAD PLANET WHOSE',0,0
	DC.B	1,3,'ATMOSPHERE HAS BOILED',0,0
	DC.B	1,4,'OFF DUE TO ITS',0,0
	DC.B	1,5,'PROXIMITY TO THE FLIP',0,0
	DC.B	1,6,'SUN.',0,0
	DC.B	1,7,'GALACTIC MASS 0.82',0,0
	DC.B	1,9,'NSUSNTNA0800',0,-1,-1
stl81:
	DC.B	20,0,'YPRESS',0,0
	DC.B	1,2,'SECOND OF THE THREE',0,0
	DC.B	1,3,'NON LIFE SUPPORTING',0,0
	DC.B	1,4,'PLANETS IN THIS',0,0
	DC.B	1,5,'DEAD SYSTEM.',0,0
	DC.B	1,6,'GALACTIC MASS 2.6',0,0
	DC.B	1,8,'NSUSNTNA0801',0,-1,-1
stl82:
	DC.B	20,0,'QUEST',0,0
	DC.B	1,2,'ALTHOUGH THE',0,0
	DC.B	1,3,'FURTHEST FROM THE',0,0
	DC.B	1,4,'FLIP SUN THIS PLANET',0,0
	DC.B	1,5,'IS STILL WARM ENOUGH',0,0
	DC.B	1,6,'TO SUPPORT LIFE.',0,0
	DC.B	1,7,'A LACK OF ATMOSPHERE',0,0
	DC.B	1,8,'HOWEVER PREVENTS',0,0
	DC.B	1,9,'THIS.',0,0
	DC.B	1,10,'GALACTIC MASS 2.13',0,0
	DC.B	1,12,'NSUSNTNA0802',0,-1,-1
	even
solmap9:
	dc.l	sollist9
	dc.l	soltextlist9
	dc.l	smap9text
	dc.l	sol9info
	dc.w	4
	dc.w	42,58
	dc.l	planet7sp
	dc.w	80,57
	dc.l	planet12sp
	dc.w	150,60
	dc.l	planet6sp
	dc.w	219,63
	dc.l	planet11sp
sollist9:
	dc.w	4
	dc.w	42,58,58,74,0,6
	dc.l	p0900info
	dc.w	80,57,100,77,1,11
	dc.l	p0901info
	dc.w	150,60,166,76,2,5
	dc.l	p0902info
	dc.w	219,63,231,75,3,10
	dc.l	p0903info
sol9info:
	dc.w	9
	dc.w	86,36
	dc.w	4
	dc.w	regular
	dc.w	236,25
	dc.w	nodefence
	dc.b	'CRAFT',-1
	even
soltextlist9:
	dc.l	stl90,stl91,stl92,stl93
smap9text:
	DC.B	17,0,'CRAFT',0,0
	DC.B	6,1,'4 PLANET SYSTEMS IN REGULAR ORBITS',0,0
	dc.b	40,14,'GI09RE',0,-1,-1
stl90:
	DC.B	20,0,'RAIN',0,0
	DC.B	1,2,'HOT MOIST PLANET',0,0
	DC.B	1,3,'RESULTING IN CONSTANT',0,0
	DC.B	1,4,'PRECIPITATION.',0,0
	DC.B	1,5,'GALACTIC MASS 1.34',0,0
	DC.B	1,7,'LSUSNTAT0900',0,-1,-1
stl91:
	DC.B	20,0,'LUSH',0,0
	DC.B	1,2,'SECOND OF THE FOUR',0,0
	DC.B	1,3,'TROPICAL CLIMATE',0,0
	DC.B	1,4,'PLANETS IN THIS',0,0
	DC.B	1,5,'SYSTEM.',0,0
	DC.B	1,6,'GALACTIC MASS 2.09',0,0
	DC.B	1,8,'LSUSNTAT0901',0,-1,-1
stl92:
	DC.B	20,0,'FERN',0,0
	DC.B	1,2,'ONLY SETTLED PLANET',0,0
	DC.B	1,3,'IN THIS SYSTEM.',0,0
	DC.B	1,4,'RAMPANT VEGETATION ON',0,0
	DC.B	1,5,'THIS PLANET IS',0,0
	DC.B	1,6,'HARVESTED AND USED',0,0
	DC.B	1,7,'FOR VARIOUS PRODUCTS.',0,0
	DC.B	1,8,'GALACTIC MASS 1.63',0,0
	DC.B	1,10,'LSSELTAT0902',0,-1,-1
stl93:
	DC.B	20,0,'CANOPY',0,0
	DC.B	1,2,'ALTHOUGH FARTHEST',0,0
	DC.B	1,3,'FROM THIS SYSTEMS',0,0
	DC.B	1,4,'SUN THIS PLANET STILL',0,0
	DC.B	1,5,'HAS A THICK VEGETATION',0,0
	DC.B	1,6,'COVERAGE.',0,0
	DC.B	1,7,'GALACTIC MASS 0.92',0,0
	DC.B	1,9,'LSUSNTAT0903',0,-1,-1
	even
solmap10:
	dc.l	sollist10
	dc.l	soltextlist10
	dc.l	smap10text
	dc.l	sol10info
	dc.w	5
	dc.w	49,56
	dc.l	planet13sp
	dc.w	97,62
	dc.l	planet3sp
	dc.w	145,65
	dc.l	planet8sp
	dc.w	177,57
	dc.l	planet1sp
	dc.w	247,61
	dc.l	planet4sp
sollist10:
	dc.w	5
	dc.w	49,56,69,76,0,12
	dc.l	p1000info
	dc.w	97,62,109,74,1,2
	dc.l	p1001info
	dc.w	145,65,154,74,2,7
	dc.l	p1002info
	dc.w	177,57,201,81,3,0
	dc.l	p1003info
	dc.w	247,61,263,77,4,3
	dc.l	p1004info
sol10info:
	dc.w	10
	dc.w	62,-46
	dc.w	5
	dc.w	regular
	dc.w	212,105
	dc.w	node
	dc.b	'BASSKERS STAR',-1
	even
soltextlist10:
	dc.l	stl100,stl101,stl102,stl103,stl104
smap10text:
	DC.B	17,0,'BASSKERS STAR',0,0
	DC.B	6,1,'5 PLANET SYSTEMS IN REGULAR ORBITS',0,0
	dc.b	40,14,'GI10RE',0,-1,-1
stl100:
	DC.B	20,0,'TROLLITH',0,0
	DC.B	1,2,'HOT UNEXPLORED PLANET',0,0
	DC.B	1,3,'WITH NO SETTLEMENT.',0,0
	DC.B	1,4,'GALACTIC MASS 2.64',0,0
	DC.B	1,7,'NSUSNTNA1000',0,-1,-1
stl101:
	DC.B	20,0,'COLPA',0,0
	DC.B	1,2,'SMALL PLANET WITH',0,0
	DC.B	1,3,'HIGH ROTATIONAL SPEED',0,0
	DC.B	1,4,'AND VERY SHORT SOLAR',0,0
	DC.B	1,5,'YEAR.',0,0
	DC.B	1,6,'GALACTIC MASS 0.49',0,0
	DC.B	1,8,'NSUSNTNA1001',0,-1,-1
stl102:
	DC.B	20,0,'THIBAN',0,0
	DC.B	1,2,'VERY SMALL PLANET',0,0
	DC.B	1,3,'WHOSE GRAVITATIONAL',0,0
	DC.B	1,4,'PULL IS TO LOW TO',0,0
	DC.B	1,5,'HOLD AN ATMOSPHERE.',0,0
	DC.B	1,6,'POSSIBLY A MOON THAT',0,0
	DC.B	1,7,'ESCAPED ORBIT FROM',0,0
	DC.B	1,8,'LIQUE.',0,0
	DC.B	1,9,'GALACTIC MASS 0.27',0,0
	DC.B	1,11,'NSUSNTNA1002',0,-1,-1
stl103:
	DC.B	20,0,'LIQUE',0,0
	DC.B	1,2,'LARGEST PLANET IN',0,0
	DC.B	1,3,'THIS SYSTEM. MOSTLY',0,0
	DC.B	1,4,'DESERT WITH SOME',0,0
	DC.B	1,5,'MOISTURE IN SOLID',0,0
	DC.B	1,6,'FORM AT THE POLES.',0,0
	DC.B	1,7,'GALACTIC MASS 2.92',0,0
	DC.B	1,9,'NSUSNTAT1003',0,-1,-1
stl104:
	DC.B	20,0,'INSTAX',0,0
	DC.B	1,2,'A COLD DESERT PLANET.',0,0
	DC.B	1,3,'VERY THIN ATMOSPHERE',0,0
	DC.B	1,4,'CONTAINING WISPY',0,0
	DC.B	1,5,'CLOUDS OF AMMONIA.',0,0
	DC.B	1,6,'GALACTIC MASS 1.28',0,0
	DC.B	1,8,'NSUSNTAT1004',0,-1,-1
	even
solmap11:
	dc.l	sollist11
	dc.l	soltextlist11
	dc.l	smap11text
	dc.l	sol11info
	dc.w	4
	dc.w	67,56
	dc.l	planet1sp
	dc.w	113,60
	dc.l	planet4sp
	dc.w	176,61
	dc.l	planet6sp
	dc.w	247,60
	dc.l	planet13sp
sollist11:
	dc.w	4
	dc.w	67,56,91,80,0,0
	dc.l	p1100info
	dc.w	113,60,129,76,1,3
	dc.l	p1101info
	dc.w	176,61,192,77,2,5
	dc.l	p1102info
	dc.w	247,60,267,80,3,12
	dc.l	p1103info
sol11info:
	dc.w	11
	dc.w	110,-30
	dc.w	4
	dc.w	regular
	dc.w	260,89
	dc.w	fighter1
	dc.b	'OFLISS',-1
	even
soltextlist11:
	dc.l	stl110,stl111,stl112,stl113
smap11text:
	DC.B	17,0,'OFLISS',0,0
	DC.B	6,1,'4 PLANET SYSTEMS IN REGULAR ORBITS',0,0
	dc.b	40,14,'GI11RE',0,-1,-1
stl110:
	DC.B	20,0,'TWILLSWAY',0,0
	DC.B	1,2,'HOT PLANET CLOSEST TO OFLISS',0,0
	DC.B	1,3,'SUN. NO SETTLEMENT.',0,0
	DC.B	1,4,'GALACTIC MASS 1.64',0,0
	DC.B	1,6,'NSUSNTNA1100',0,-1,-1
stl111:
	DC.B	20,0,'SLOTAS',0,0
	DC.B	1,2,'SMALL PLANET WITH ARID',0,0
	DC.B	1,3,'BANDS OF DESERT ON A',0,0
	DC.B	1,4,'MOSTLY LIQUID SUFACE',0,0
	DC.B	1,5,'SOME SETTLEMENT WITH LITTLE',0,0
	DC.B	1,6,'SUCCESS.',0,0
	DC.B	1,7,'GALACTIC MASS 1.49',0,0
	DC.B	1,9,'LSSELTAT1101',0,-1,-1
stl112:
	DC.B	20,0,'DREQUE',0,0
	DC.B	1,2,'JUNGLE STRIPED PLANET',0,0
	DC.B	1,3,'WHOSE LOW GRAVITATIONAL',0,0
	DC.B	1,4,'PULL RESULTS IN UNUSUALLY',0,0
	DC.B	1,5,'TALL VEGETATION.',0,0
	DC.B	1,6,'GALACTIC MASS 0.44',0,0
	DC.B	1,8,'LSUSNTAT1102',0,-1,-1
stl113:
	DC.B	20,0,'YANUX',0,0
	DC.B	1,2,'DISTANT COLD PLANET',0,0
	DC.B	1,3,'RESPONSIBLE FOR',0,0
	DC.B	1,4,'SLIGHT WOBBLE IN',0,0
	DC.B	1,5,'DREQUE ORBIT.',0,0
	DC.B	1,6,'GALACTIC MASS 2.92',0,0
	DC.B	1,8,'NSUSNTAT1103',0,-1,-1
	even
whichsollist:		dc.l	0
whichsoltextlist:	dc.l	0
whichsol:		dc.w	0
whichsolinfo:		dc.l	0
whichplanet:		dc.w	0
solarlist:
	dc.w	40,21,48,29,0
	dc.w	48,101,56,109,1
	dc.w	72,61,80,69,2
	dc.w	112,29,120,37,3
	dc.w	160,29,168,37,4
	dc.w	160,45,168,53,5
	dc.w	160,77,168,85,6
	dc.w	160,109,168,117,7
	dc.w	192,45,200,53,8
	dc.w	240,29,248,37,9
	dc.w	216,109,224,117,10
	dc.w	264,93,272,101,11

manhits:	dc.w	0
doingman:	dc.w	-1
manlist:
	dc.l	man1l,man1r,man2l,man2r,man3l,man3r
man1l:
	dc.w	68,42,104,123		;top left x,y bot right x,y
	dc.w	68,42,122,123
	dc.w	68,42,138,123
	dc.w	68,42,138,123
	dc.w	68,42,138,123
	dc.w	68,42,138,123
	dc.w	68,42,138,123
	dc.w	68,42,122,123
	dc.w	68,42,104,123
man1ldlt:
	dc.l	0		;address
	dc.w	130,76		;x,y for shoot
man1r:
	dc.w	210,42,252,123		;top left x,y bot right x,y
	dc.w	199,42,252,123
	dc.w	182,42,252,123
	dc.w	182,42,252,123
	dc.w	182,42,252,123
	dc.w	182,42,252,123
	dc.w	182,42,252,123
	dc.w	199,42,252,123
	dc.w	210,42,252,123
man1rdlt:
	dc.l	0		;address
	dc.w	190,76
man2l:
	dc.w	127,58,144,105		;top left x,y bot right x,y
	dc.w	127,58,152,105
	dc.w	127,58,160,105
	dc.w	127,58,160,105
	dc.w	127,58,160,105
	dc.w	127,58,160,105
	dc.w	127,58,160,105
	dc.w	127,58,152,105
	dc.w	127,58,144,105
man2ldlt:
	dc.l	0		;address
	dc.w	156,75
man2r:
	dc.w	176,58,193,105		;top left x,y bot right x,y
	dc.w	168,58,193,105
	dc.w	160,58,193,105
	dc.w	160,58,193,105
	dc.w	160,58,193,105
	dc.w	160,58,193,105
	dc.w	160,58,193,105
	dc.w	168,58,193,105
	dc.w	176,58,193,105
man2rdlt:
	dc.l	0		;address
	dc.w	164,75
man3l:
	dc.w	144,67,152,89		;top left x,y bot right x,y
	dc.w	144,67,156,89
	dc.w	144,67,160,89
	dc.w	144,67,160,89
	dc.w	144,67,160,89
	dc.w	144,67,160,89
	dc.w	144,67,160,89
	dc.w	144,67,156,89
	dc.w	144,67,152,89
man3ldlt:
	dc.l	0		;address
	dc.w	159,74
man3r:
	dc.w	168,67,176,89		;top left x,y bot right x,y
	dc.w	164,67,176,89
	dc.w	160,67,176,89
	dc.w	160,67,176,89
	dc.w	160,67,176,89
	dc.w	160,67,176,89
	dc.w	160,67,176,89
	dc.w	164,67,176,89
	dc.w	168,67,176,89
man3rdlt:
	dc.l	0		;address
	dc.w	161,74

cursordat:
	 dc.w	$0000,$0180,$0180,$0180,$0000,$0180,$0180,$0180
	 dc.w	$0000,$0000,$0000,$0000,$0180,$0180,$0180,$0180
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0180,$0180,$0180
	 dc.w	$0000,$0000,$0000,$0000,$1008,$D42B,$D42B,$D42B
	 dc.w	$1008,$D42B,$D42B,$D42B,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0180,$0180,$0180,$0000,$0000,$0000,$0000
	 dc.w	$0180,$0180,$0180,$0180,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0180,$0180,$0180,$0000,$0180,$0180,$0180
sightdat:
	 dc.w	$0380,$0000,$0000,$0000,$0000,$0000,$0280,$0000
	 dc.w	$0280,$0280,$0000,$0000,$0280,$0000,$0280,$0000
	 dc.w	$0000,$0280,$0000,$0000,$0000,$0280,$0280,$0000
	 dc.w	$B01A,$2C68,$5454,$0000,$8002,$0100,$0100,$0100
	 dc.w	$B01A,$2C68,$5454,$0000,$0000,$0280,$0280,$0000
	 dc.w	$0000,$0280,$0000,$0000,$0280,$0000,$0280,$0000
	 dc.w	$0280,$0280,$0000,$0000,$0000,$0000,$0280,$0000
	 dc.w	$0380,$0000,$0000,$0000
sightdata:
	 dc.w	$00FF,$00FF,$0100,$01FF,$FE00,$FE00,$0100,$FF00
	 dc.w	$0100,$0100,$0000,$0100,$0100,$0100,$0000,$0100
	 dc.w	$0000,$0000,$0080,$0080,$0000,$0000,$0200,$0200
	 dc.w	$0040,$0000,$0040,$0040,$0400,$0000,$0400,$0400
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0040,$0000,$0040,$0040,$0400,$0000,$0400,$0400
	 dc.w	$0000,$0000,$0080,$0080,$0000,$0000,$0200,$0200
	 dc.w	$0100,$0100,$0000,$0100,$0100,$0100,$0000,$0100
	 dc.w	$00FF,$00FF,$0100,$01FF,$FE00,$FE00,$0100,$FF00
sightmask:
	 dc.w	$01FF,$FF00,$0100,$0100,$0080,$0200,$0040,$0400
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0040,$0400
	 dc.w	$0080,$0200,$0100,$0100,$01FF,$FF00

hyperstarsvrt:
	dc.w	300
	ds.w	300*3
mapmem:
	ds.b	15984
solmapmem:
	ds.b	15984

circlecoords:	ds.w	5664
circ:	dc.l	0
radius: dc.w	600
circx:	dc.w	0
circy:	dc.w	0
xcentre:	dc.w	0
ycentre:	dc.w	0
width:		dc.w	0
height: 	dc.w	0
dodge:		dc.w	0
x1s:	dc.w	0
y1s:	dc.w	0
x2s:	dc.w	0
y2s:	dc.w	0
yadd:	dc.l	0
whichpalette:	dc.l	0
planetoverlay:
	 dc.w	$AA00,$0000,$0000,$AA00,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0015,$0000,$0000,$0015
	 dc.w	$FFAA,$0000,$0000,$FFAA,$AA80,$0000,$0000,$AA80
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0015,$0000,$0000,$0015,$557F,$0000,$0000,$557F
	 dc.w	$00FF,$0000,$0000,$FFFF,$FFAA,$0000,$0000,$FFAA
	 dc.w	$AAAA,$0000,$0000,$AAAA,$8000,$0000,$0000,$8000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0AAA,$0000,$0000,$0AAA
	 dc.w	$AABF,$0000,$0000,$AABF,$FFC0,$0000,$0000,$FFFF
	 dc.w	$FF00,$FF00,$FF00,$00FF,$007F,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$EAAA,$0000,$0000,$EAAA
	 dc.w	$AAAA,$0000,$0000,$AAAA,$AA80,$0000,$0000,$AA80
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0002,$0000,$0000,$0002,$AAAA,$0000,$0000,$AAAA
	 dc.w	$AAAA,$0000,$0000,$AAAA,$BFFF,$0000,$0000,$BFFF
	 dc.w	$FFC0,$0000,$0000,$FFFF,$003F,$003F,$003F,$FFC0
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FF80,$FF80,$FF80,$007F
	 dc.w	$0000,$0000,$0000,$FFFF,$3FFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFEA,$0000,$0000,$FFEA
	 dc.w	$AAAA,$0000,$0000,$AAAA,$AAAA,$0000,$0000,$AAAA
	 dc.w	$AAAA,$0000,$0000,$AAAA,$AAAA,$0000,$0000,$AAAA
	 dc.w	$AAAA,$0000,$0000,$AAAA,$AAAA,$0000,$0000,$AAAA
	 dc.w	$AAAB,$0000,$0000,$AAAB,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$E000,$0000,$0000,$FFFF
	 dc.w	$003F,$003F,$003F,$FFC0,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$FF00,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$C000,$C000,$C000,$3FFF
	 dc.w	$0000,$0000,$0000,$FFFF,$003F,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFC,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$1FFF,$1FFF,$1FFF,$E000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$003F
	 dc.w	$00FF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FF80
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFC0,$FFC0,$FFC0,$003F
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$0003,$0003,$0003,$FFFC,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$003F,$FFC0,$FFFF,$FFFF,$FFFF
	 dc.w	$CF00,$0FFF,$0FFF,$F3FF,$007F,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$C000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$1FFF
	 dc.w	$FFC0,$FFFF,$FFFF,$FFFF,$003C,$FFFC,$FFFC,$FFF3
	 dc.w	$5500,$AAFF,$0000,$AAFF,$6780,$87FF,$07FF,$F9FF
	 dc.w	$0000,$FFFF,$FFFF,$FFFF,$3FFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFC0
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0003,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$E000,$FFFF,$FFFF,$FFFF
	 dc.w	$003C,$FFFC,$FFFC,$FFF3,$C015,$3FEA,$0000,$FFEA
	 dc.w	$FEAA,$0155,$0000,$0155,$AA80,$557F,$0000,$557F
	 dc.w	$0033,$FFC3,$0003,$FFFC,$C000,$FFFF,$FFFF,$FFFF
	 dc.w	$0000,$FFFF,$FFFF,$FFFF,$003F,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFC,$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF
	 dc.w	$0000,$FFFF,$FFFF,$FFFF,$1E60,$FE1F,$FE00,$F9FF
	 dc.w	$002A,$FFD5,$0000,$FFD5,$AAAF,$5550,$0000,$5550
	 dc.w	$FFFF,$0000,$0000,$0000,$FF55,$00AA,$0000,$00AA
	 dc.w	$5555,$AAAA,$0000,$AAAA,$4000,$BFFF,$0000,$BFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$33C0,$C3FF,$03FF,$FCFF
	 dc.w	$0000,$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF
	 dc.w	$0000,$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF
	 dc.w	$0000,$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF
	 dc.w	$0003,$FFFF,$FFFF,$FFFF,$CC00,$C3FF,$C000,$3FFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$1555,$EAAA,$0000,$EAAA
	 dc.w	$555F,$AAA0,$0000,$AAA0,$FFFF,$0000,$0000,$0000
	 dc.w	$FFFF,$0000,$0000,$0000,$FFFF,$0000,$0000,$0000
	 dc.w	$FFFF,$0000,$0000,$0000,$AAAA,$5555,$0000,$5555
	 dc.w	$AAAA,$5555,$0000,$5555,$AA80,$557F,$0000,$557F
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0002,$FFFD,$0000,$FFFD,$AAAA,$5555,$0000,$5555
	 dc.w	$AAAA,$5555,$0000,$5555,$AFFF,$5000,$0000,$5000
	 dc.w	$FFFF,$0000,$0000,$0000,$FFFF,$0000,$0000,$0000
	 dc.w	$FFFF,$0000,$0000,$0000,$FFFF,$0000,$0000,$0000
	 dc.w	$FFFF,$0000,$0000,$0000,$FFFF,$0000,$0000,$0000
	 dc.w	$FFFF,$0000,$0000,$0000,$FF55,$00AA,$0000,$00AA
	 dc.w	$5555,$AAAA,$0000,$AAAA,$5555,$AAAA,$0000,$AAAA
	 dc.w	$5555,$AAAA,$0000,$AAAA,$5555,$AAAA,$0000,$AAAA
	 dc.w	$5555,$AAAA,$0000,$AAAA,$5555,$AAAA,$0000,$AAAA
	 dc.w	$5555,$AAAA,$0000,$AAAA,$FFFF,$0000,$0000,$0000
	 dc.w	$FFFF,$0000,$0000,$0000,$FFFF,$0000,$0000,$0000
	 dc.w	$FFFF,$0000,$0000,$0000,$FFFF,$0000,$0000,$0000

planetmask:
	 dc.w	$AA00,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0015,$FFAA,$AA80,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0015,$557F,$FFFF,$FFAA,$AAAA,$8000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0AAA,$AABF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$EAAA,$AAAA,$AA80,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0002,$AAAA,$AAAA,$BFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFEA,$AAAA,$AAAA
	 dc.w	$AAAA,$AAAA,$AAAA,$AAAA,$AAAB,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF
circcoords:
 dc.b	27-27,0-27,29-27,0-27,31-27,0-27,33-27,1-27,35-27,1-27
 dc.b	36-27,2-27,38-27,2-27,40-27,3-27,41-27,4-27,43-27,5-27
 dc.b	44-27,6-27,46-27,8-27,47-27,9-27,49-27,11-27,49-27,12-27
 dc.b	51-27,14-27,51-27,15-27,52-27,17-27,53-27,19-27,53-27,21-27
 dc.b	54-27,23-27,54-27,25-27,54-27,27-27,54-27,29-27,54-27,31-27
 dc.b	53-27,33-27,53-27,35-27,52-27,36-27,52-27,38-27,51-27,40-27
 dc.b	50-27,41-27,49-27,43-27,48-27,44-27,46-27,46-27,45-27,47-27
 dc.b	44-27,48-27,42-27,49-27,40-27,51-27,39-27,51-27,37-27,52-27
 dc.b	35-27,53-27,33-27,53-27,32-27,54-27,30-27,54-27,28-27,54-27
 dc.b	26-27,54-27,24-27,54-27,22-27,54-27,20-27,53-27,18-27,52-27
 dc.b	16-27,52-27,15-27,51-27,13-27,50-27,12-27,49-27,10-27,48-27
 dc.b	9-27,47-27,7-27,45-27,6-27,44-27,5-27,42-27,4-27,41-27,3-27,39-27
 dc.b	2-27,37-27,2-27,36-27,1-27,34-27,0-27,32-27,0-27,30-27,0-27,28-27
 dc.b	0-27,26-27,0-27,24-27,0-27,22-27,1-27,21-27,1-27,19-27,2-27,17-27
 dc.b	3-27,15-27,3-27,14-27,5-27,12-27,5-27,11-27,7-27,9-27,8-27,8-27
 dc.b	10-27,6-27,11-27,5-27,13-27,4-27,14-27,3-27,16-27,2-27
 dc.b	18-27,2-27,20-27,1-27,21-27,1-27,23-27,0-27,25-27,0-27
	even
scrolltated1:	dc.l	0
scrolltated2:	dc.l	0
scrolltated3:	dc.l	0
scrolltated4:	dc.l	0
scrolltated5:	dc.l	0
atlist:		dc.l	0
surfacedfn:	dc.w	0	;color
		dc.l	surfacevrt
surfacevrt:	dc.w	0	;number of points
		ds.w	200
scrollwhere:	dc.l	0
savepalette:	dc.l	0
boom8delay:	dc.w	0
keybuf:		dc.l	0
paused:		dc.w	-1
spritechain:	dc.l	0
maxchain:	dc.l	0
fuelminus:	dc.w	0
loadflag:	dc.w	-1
shipenergy:	dc.l	0
buttondat:	dc.w	0
mx:		dc.w	160
my:		dc.w	100
ycurve: 	dc.w	0
pathcount:	dc.w	20
wobblecount:	dc.w	-1
trendx: 	dc.w	0
trendy: 	dc.w	0
trendxwhere:	dc.w	0
pathx:		dc.w	0
trendywhere:	dc.w	0
pathy:		dc.w	0
terrainwhere:	dc.l	0
planetmem1:	dc.l	0
planetmem2:	dc.l	0
battlespeed:	dc.w	50
sightflag:	dc.w	-1
tradelist:
	dc.w	21,17,60,50,0
	dc.l	sightinfomsg
	dc.w	69,17,108,50,1
	dc.l	laserinfomsg
	dc.w	117,17,156,50,2
	dc.l	docksoftmsg
	dc.w	165,17,204,50,3
	dc.l	cloakinfomsg
	dc.w	21,57,60,90,4
	dc.l	amatinfomsg
	dc.w	69,57,108,90,5
	dc.l	orbitsoftmsg
	dc.w	117,57,156,90,6
	dc.l	fuelinfomsg
	dc.w	165,57,204,71,7
	dc.l	tradetrademsg
	dc.w	165,76,204,90,8
	dc.l	exittrademsg

computertextmem:
	ds.b	752
	dc.b	' '
	even
zalorlist:
	dc.b	0,0,0,3,0,0,0,3,0,0,2,-1
razorlist:
	dc.b	0,0,0,0,1,3,0,0,0,0,0,-2
traxllist:
	dc.b	3,3,1,0,0,0,0,0,0,0,-1
sazollist:
	dc.b	0,0,1,3,1,3,0,0,0,0,-2
wartraxlist:
	dc.b	3,1,0,0,0,0,2,0,0,0,0,3,-2
axislist:
	dc.b	0,0,1,0,0,0,3,0,0,1,-1
hockerlist:
	dc.b	0,0,1,3,0,2,0,0,2,2,-1
driscollist:
	dc.b	1,0,0,0,1,0,0,0,3,3,-1
kulalist:
	dc.b	1,1,1,0,0,0,0,0,3,3,-1
lomalist:
	dc.b	3,0,3,0,1,0,3,0,0,3,-2
razarelist:
	dc.b	1,2,0,2,1,0,0,0,3,3,-1
grazelist:
	dc.b	1,0,0,0,1,0,0,0,3,3,-2
diagerlist:
	dc.b	1,1,1,0,1,3,3,0,0,0,-2
rainlist:
	dc.b	1,0,0,0,1,0,0,0,3,3,-2
canopylist:
	dc.b	1,3,3,3,1,2,0,0,0,0,-1
liquelist:
	dc.b	1,3,2,0,1,3,2,2,1,1,-1
instaxlist:
	dc.b	1,0,0,0,1,0,0,0,3,3,-1
drequelist:
	dc.b	0,1,1,1,2,3,3,0,3,0,3,-2
colpalist:
	dc.b	0,3,1,1,1,1,3,0,3,1,1,-2
slotaslist:
	dc.b	0,0,3,1,2,1,3,1,3,0,3,-1
death1msg:
	dc.b	2,4,'YOUR CRAFTS LAST REMAINING ENERGY RESERVES',0,0
	DC.B	2,5,' WERE USED LAUNCHING THE REMOTES FOR THIS',0,0
	DC.B	2,6,'           PLANET EXPLORATION.',0,0
	DC.B	2,8,'YOU DRIFT ENDLESSLY IN YOUR DARK COLD SHIP',0,-1,-1
death2msg:
	DC.B	2,4,'ONE TOO MANY OF THE SYSTEMS FLEETS SHOTS',0,0
	DC.B	2,5,'         SMACK YOUR SHIPS HULL',0,0
	DC.B	2,6,'YOUR CRAFTS ENERGY  RESERVES ARE DRAINED',0,0
	DC.B	2,7,'   TO ZERO AND NO LONGER MAINTAIN THE',0,0
	DC.B	2,8,'  SHEILDS. THE VERY NEXT BOLT FROM AN',0,0
	DC.B	2,9,'ATTACKER RESULTS IN A  BLINDING FLASH AS',0,0
	DC.B	2,10,' YOU BECOME LITTLE  MORE THAN A MEMORY',0,-1,-1
death3msg:
	dc.b	2,4,'THE ENERGY DRAINS ON YOUR SHIP DURING YOUR',0,0
	DC.B	2,5,'   ATTACK HAVE LEFT YOUR CRAFT POWERLESS.',0,0
	DC.B	2,6,'YOU CAN NOT LEAVE THE  MULTIDECK BEFORE IT',0,0
	DC.B	2,7,'                   BLOWS.',0,0
	DC.B	2,9,'  YOU BECOME LITTLE  MORE THAN A MEMORY',0,-1,-1
death4msg:
	DC.B	2,4,'YOU EXIT THE TUNNEL WITH TOO LITTLE ENERGY',0,0
	DC.B	2,5,'             TO LAND OR FIGHT.',0,0
	DC.B	2,7,'YOU DRIFT ENDLESSLY IN YOUR DARK COLD SHIP',0,-1,-1

nosetmsg:
	dc.b	9,7,'NO INTERPLANETARY COURSE SET.',0,-1,-1
searchmsg:
	dc.b	12,0,'       SEARCHCOMP',0,0
	DC.B	12,1,'INITIATING PLANET SEARCH',0,-1,-1
nofindmsg:
	DC.B	2,4,'   SEARCHCOMP HAS COMPLETED SCAN OF PLANET',0,0
	DC.B	2,5,'          AND CAN FIND NO ACTIVITY.',0,0
	DC.B	2,6,'THIS DATA HAS BEEN TRANSFERRED TO THE NAVCOMP',0,0
	DC.B	2,7,'  WHICH HAS RETURNED THE CRAFT TO PLANETARY',0,0
	DC.B	2,8,'                    ORBIT',0,-1,-1
missedpathmsg:	dc.b	9,7,'YOU HAVE MISSED THE ENTRY WINDOW',0,0
		DC.B	9,8,'         ENTRY ABORTED.',0,-1,-1
deadremotemsg:
	dc.b	8,6,'YOUR REMOTE HAS BEEN DESTROYED.',0,0
	DC.B	8,7,'RETURNING  CONTROL TO SHIPCOMP.',0,-1,-1
boxtext:
	dc.b	15,0,'SYSTEMS REMOTE',0,0
	DC.B	1,2,'REMOTE TRANCEIVER FOR RECONNAISSANCE',0,0
	DC.B	1,3,'RELAYS INTELLIGENCE INFOMATION',0,0
	DC.B	1,4,'GATHERED BY OBIAN',0,0
	DC.B	1,5,'CRUISERS. ALSO USED',0,0
	DC.B	1,6,'AS GENERAL SECURITY',0,0
	DC.B	1,7,'INFO NETWORK NODE.',0,0
	DC.B	1,8,'USEFUL TO GAIN INFO',0,0
	DC.B	1,9,'BUT ALWAYS DESTROY.',0,0
	DC.B	13,14,'SPACE BAR TO CONTINUE',0,-1,-1
mettext:
	DC.B	18,0,'HYPEROID',0,0
	DC.B	1,2,'HYPERSPACE ASTEROID EXISTS ONLY',0,0
	DC.B	1,3,'IN HYPERSPACE TUNNELS.',0,0
	DC.B	1,4,'NO EXPLANATION FOR EXISTANCE',0,0
	DC.B	1,5,'AVAILABLE. POSSIBLE QUARK',0,0
	DC.B	1,6,'ARTIFACT.',0,0
	DC.B	1,7,'DESTROY TO GET CREDITS',0,0
	DC.B	1,8,'FROM THE SYSTEMS GOVERNMENT',0,0
	DC.B	1,9,'FOR CLEARING SPACEWAYS.',0,0
	DC.B	1,10,'OTHERWISE AVOID.',0,0
	DC.B	13,14,'SPACE BAR TO CONTINUE',0,-1,-1
minetext:
	DC.B	15,0,'WARP FIGHTER',0,0
	DC.B	1,2,'VERY SMALL AND FAST CRAFT FORMING',0,0
	DC.B	1,3,'THE FRONTLINE HIT COR OF',0,0
	DC.B	1,4,'THE SYSTEMS GOVERNMENT.',0,0
	DC.B	1,5,'IMPOSSIBLE TO OUTRUN',0,0
	DC.B	1,6,'AND DIFFICULT TO DESTROY',0,0
	DC.B	1,7,'WITHOUT WEAPONS ENHANCEMENTS.',0,0
	DC.B	13,14,'SPACE BAR TO CONTINUE',0,-1,-1
mine2text:
	DC.B	15,0,'JOVANE MULTI DECK',0,0
	DC.B	1,2,'MOBILE LAUNCHING/REFUELING',0,0
	DC.B	1,3,'DECK AND TROUP CARRIER',0,0
	DC.B	1,4,'REQUIRES A GREAT DEAL OF',0,0
	DC.B	1,5,'FIRE POWER TO DESTROY',0,0
	DC.B	13,14,'SPACE BAR TO CONTINUE',0,-1,-1
ship1text:
	dc.b	15,0,'OBIAN CRUISER',0,0
	DC.B	1,2,'LARGE BUT MANOUVERABLE SYSTEMS',0,0
	DC.B	1,3,'CRAFT. LIMITED WEAPONS ',0,0
	DC.B	1,4,'CAPABILITY BUT PACKED WITH',0,0
	DC.B	1,5,'SENSORS FOR RECONNAISSANCE',0,0
	DC.B	1,6,'WORK. AVOID.',0,0
	DC.B	13,14,'SPACE BAR TO CONTINUE',0,-1,-1
credtext:
	dc.b	15,0,'CREDIT',0,0
	DC.B	1,2,'THE BASIS OF THE SYSTEMS',0,0
	DC.B	1,3,'GOVERNMENT ECONOMY.',0,0
	DC.B	1,4,'ITS VALUE IS CAREFULLY',0,0
	DC.B	1,5,'REGULATED THROUGHOUT THE',0,0
	DC.B	1,6,'EXPLORED UNIVERSE.',0,0
	DC.B	13,14,'SPACE BAR TO CONTINUE',0,-1,-1
fueltext:
	dc.b	15,0,'FUEL CELL',0,0
	DC.B	1,2,'USED BY MOST CRAFT IN THE',0,0
	DC.B	1,3,'KNOWN UNIVERSE. GENERATES',0,0
	DC.B	1,4,'HUGE AMOUNTS OF CURRENT',0,0
	DC.B	1,5,'THROUGH THE DECAY OF A FORM',0,0
	DC.B	1,6,'OF CRYSTALISED RADIOACTIVE',0,0
	DC.B	1,7,'HYDRAZINE.',0,0
	DC.B	13,14,'SPACE BAR TO CONTINUE',0,-1,-1
evitext:
	dc.b	13,0,'EVIDENCE CUBE',0,0
	DC.B	1,2,'STANDARD EVIDENCE STORAGE',0,0
	DC.B	1,3,'DEVICE. RECORDS AND MAINTAINS',0,0
	DC.B	1,4,'GOVERNMENTS EVIDENCE IN ALL',0,0
	DC.B	1,5,'LEGAL CASES. CAN HOLD HOLOGRAPHS',0,0
	DC.B	1,6,'OF PHYSICAL EVIDENCE AS WELL AS',0,0
	DC.B	1,7,'TEXT AND SOUND. CANNOT BE WIPED.',0,0
	DC.B	13,14,'SPACE BAR TO CONTINUE',0,-1,-1
bubtext:
	dc.b	13,0,'BUBBLECORDER',0,0
	DC.B	1,2,'FLIGHT RECORDER FOR ALL',0,0
	DC.B	1,3,'TRANSPORT CRAFT.ABLE TO',0,0
	DC.B	1,4,'WITHSTAND THE HARSHEST ABUSE',0,0
	DC.B	1,5,'COMMON IN INTERSTELLAR ACCIDENTS.',0,0
	DC.B	1,6,'STRENGTH ACHIEVED BY A CASE MADE',0,0
	DC.B	1,7,'OF SUPER DENSE MATTER SIMILAR TO',0,0
	DC.B	1,8,'THAT OF COLLAPSED STARS. FITTED',0,0
	DC.B	1,9,'ANTIGRAV DEVICE TO COUNTERACT',0,0
	DC.B	1,10,'THE ENORMOUS WEIGHT OF SUCH',0,0
	DC.B	1,11,'MATERIAL.',0,0
	DC.B	13,14,'SPACE BAR TO CONTINUE',0,-1,-1
amattext:
	dc.b	9,0,'AMATT EXPANSION BOMB',0,0
	DC.B	1,2,'THE PRINCIPLE OF AN ANTIMATTER',0,0
	DC.B	1,3,'BOMB WAS KNOWN BUT NOT USED',0,0
	DC.B	1,4,'FOR CENTURIES. THE HIGH COST',0,0
	DC.B	1,5,'OF PRODUCING THE MATERIAL WAS',0,0
	DC.B	1,6,'PROHIBITIVE UNTIL AN ANTIMATTER',0,0
	DC.B	1,7,'ORGANISM WAS DEVELOPED WHICH',0,0
	DC.B	1,8,'ENABLED THE SUBSTANCE TO BE GROWN',0,0
	DC.B	1,9,'CHEAPLY.THE BOMB EXPANDS IN A',0,0
	DC.B	1,10,'SPHERE FROM ITS POINT OF DETONATION',0,0
	DC.B	1,11,'DESTROYING EVERTHING IT CONTACTS',0,0
	DC.B	1,12,'IN A 1000 LIGHTSEC RANGE.',0,0
	DC.B	13,14,'SPACE BAR TO CONTINUE',0,-1,-1
nanatext:
	dc.b	11,7,'STAR CHARTS NOT AVAILABLE.',0,0
	DC.B	11,8,'  NO EVIDENCE ANALYSED.',0,-1,-1
settext:
	DC.B	15,0,'COURSE SETTING',0,0
	DC.B	1,2,'CURRENT LOCATION     : '
curloc: DC.B	'                       ',0,0
	DC.B	1,3,'DESTINATION SELECTED : '
desloc: DC.B	'                       ',0,0
	DC.B	1,4,'DISTANCE IS '
dist:	dc.b	'      LIGHT YEARS',0,0
	dc.b	1,5,'REQUIRING '
fueln:
	DC.B	'      UNITS OF ACTIVE HYDRAZINE.',0,-1,-1
shipstatstext:
	dc.b	8,0,'CLASS 2 EXMILITARY PROTEK FIGHTER',0,0
	dc.b	1,2,'HEAVILY MODIFIED TO PROVIDE LONG',0,0
	dc.b	1,3,'DISTANCE CAPABILITY. EXTERNAL',0,0
	dc.b	1,4,'STRENGTHENING TO ALLOW ATMOSPHERIC',0,0
	dc.b	1,5,'ENTRY AND MANOUVERABILITY.',0,0
	dc.b	1,6,'CURRENT CRAFT ENHANCEMENTS:',0,0
	dc.b	3,8,'SLOW SHOT PARTICLE LASER   ',0,-1,-1
sightmsg:
	dc.b	3,9,'ENEMY SIGHTING SYSTEM',0,-1,-1
fastlasermsg:
	dc.b	3,10,'FAST PULSE LASERS',0,-1,-1
iregmsg:
	dc.b	3,11,'IRREGULAR ORBIT SOFTWARE',0,-1,-1
automsg:
	dc.b	3,12,'AUTOMATIC DOCKING SOFTWARE',0,-1,-1
amatmsg:
	dc.b	3,13,'AMAT EXPANSION BOMB',0,-1,-1
cloakmsg:
	dc.b	3,14,'SHIP CLOAKING DEVICE',0,-1,-1
sightinfomsg:
	dc.b	2,13,'WEAPONS SIGHTING SYSTEM.',0,0
	DC.B	2,14,'WORKS WITH ALL WEAPONS.',0,0
	DC.B	2,15,'500 CREDITS.',0,-1,-1
laserinfomsg:
	DC.B	2,13,'FAST PULSE CRAYNAX CRYSTAL LASER.',0,0
	DC.B	2,14,'REPLACES SLOW SHOT PARTICLE LASER.',0,0
	DC.B	2,15,'3500 CREDITS.',0,-1,-1
docksoftmsg:
	DC.B	2,13,'AUTOMATIC DOCKING TWINDISK SOFTWARE.',0,0
	DC.B	2,14,'COMPUTER CONTROLLED MULTIDECK DOCKING.',0,0
	DC.B	2,15,'2000 CREDITS.',0,-1,-1
cloakinfomsg:
	dc.b	2,13,'CLOAKING DEVICE. DISGUISES SHIP AS SYSTEMS',0,0
	DC.B	2,14,'GOVERNMENT VEHICLE. ONLY FOOLS MULTIDECK ',0,0
	DC.B	2,15,'SENSORS. 500 CREDITS.',0,-1,-1
amatinfomsg:
	DC.B	2,13,'AMAT EXPANSION BOMB. HIGHLY EFFECTIVE',0,0
	DC.B	2,14,'WEAPON AGAINST ANY ENEMY.',0,0
	DC.B	2,15,'500 CREDITS.',0,-1,-1
orbitsoftmsg:
	dc.b	2,13,'IRREGULAR ORBIT TWINDISK SOFTWARE. ALLOWS',0,0
	DC.B	2,14,'NAVCOMP CALCULATIONS FOR COMPLEX ORBITS.',0,0
	DC.B	2,15,'5500 CREDITS.',0,-1,-1
fuelinfomsg:
	dc.b	2,13,'RADIOACTIVE HYDRAZINE FUEL CELL.',0,0
	DC.B	2,14,'EASY STORAGE ENERGY PACK.',0,0
	DC.B	2,15,'1000 CREDITS.',0,-1,-1
exittrademsg:
	dc.b	2,13,'COMMUNICATIONS LINK BROKEN.',0,0
	DC.B	2,14,'NAVCOMP RETURNING CRAFT TO PLANET ORBIT.',0,-1,-1
tradetrademsg:
	dc.b	2,13,'AUTOMATIC FUNDS TRANSFER INITIATED.',0,0
	DC.B	2,14,'ITEM INSTALLED BY TRADEBOTS. THANKYOU.',0,-1,-1
nomoneymsg:
	dc.b	2,13,'YOUR ACCOUNT SHOWS INSUFFICIENT FUNDS TO',0,0
	DC.B	2,14,'COMPLETE THIS TRANSACTION.',0,-1,-1
alreadymsg:
	dc.b	2,13,'THIS ITEM IS ALREADY INSTALLED IN YOUR',0,0
	DC.B	2,14,'CRAFT. TRANSACTION CANCELLED.',0,-1,-1
autodockmsg1:
	dc.b	5,7,'AUTO DOCKING SOFTWARE NOT INSTALLED.',0,-1,-1
autodockmsg:
	dc.b	5,7,'       AUTO DOCKING INITIATED.',0,-1,-1
warnmsg:
	DC.B	1,0,'WARNING',0,0
	DC.B	1,1,'ENTERING MULTIDECK SENSOR',0,0
	DC.B	1,2,'RANGE WITHOUT CLOAKING DEVICE',0,-1,-1

nocloakmsg:
	DC.B	8,6,'MULTIDECK TRAFFIC CONTROL CAN NOT',0,0
	DC.B	8,7,'IDENTIFY CRAFT AS SYSTEMS VEHICLE',0,0
	DC.B	8,8,'  CLOAKING DEVICE NECESSARY FOR',0,0
	DC.B	8,9,'       DOCKING TO PROCEED',0,-1,-1
rotmsg:
	DC.B	10,6,'DOCKING CAN NOT PROCEED UNTIL',0,0
	DC.B	10,7,'  ROTATIONAL SPEEDS OF BOTH',0,0
	DC.B	10,8,'         CRAFT MATCH.',0,-1,-1
hostilemsg:
	DC.B	10,6,'YOU ARE REFUSED DOCKING ACCESS',0,0
	DC.B	10,7,'  DUE TO HOSTILE ACTIVITIES.',0,-1,-1
dockmsg:
	DC.B	10,6,'DOCKING PROCEDURE INITIATED',0,-1,-1
nodockmsg:
	DC.B	10,5,'MULTIDECK NOT IN RANGE FOR',0,0
	DC.B	10,6,'    DOCKING PROCEDURE.',0,-1,-1
dockedmsg:
	DC.B	18,7,'SHIP DOCKED',0,-1,-1
deckdeadmsg:
	DC.B	14,7,'MULTIDECK DESTROYED',0,-1,-1
finished3dtext:
	DC.B	10,6,'SYSTEMS SQUADRON DESTROYED.',0,0
	DC.B	10,7,'  SWITCHING TO COMPUTER.',0,-1,-1

dmsg1:	DC.B	7,6,'SYSTEMS GOVERNMENT ACTIVITY DETECTED',0,0
	DC.B	7,7,'    IN SOLAR SYSTEM. SWITCHING TO',0,0
	DC.B	7,8,'         BATTLE SCREEN NOW.',0,-1,-1
dmsg2:	DC.B	5,6,'COMMUNICATIONS NODE DETECTED AND LOCATED',0,0
	DC.B	5,7,'       NAVCOMP DOCKING WITH NODE',0,-1,-1
datamsg:
	DC.B	8,6,'COMMUNICATIONS DATA STREAM BEING',0,0
	DC.B	8,7,'           INTERCEPTED.',0,-1,-1
datamsg2:
	DC.B	7,6,'         UNSCRAMBLING DATA.',0,-1,-1
datamsg3:
	DC.B	7,7,'  COMMUNICATIONS COMP SUGGESTS DATA',0,0
	DC.B	7,8,'    BE ANALYSED BY SHIPS COMPUTER',0,-1,-1
datamsg4:
	DC.B	7,7,'SHIP COMP UPLOADING HIGH VOLTAGE SPIKE',0,0
	DC.B	7,8,'           TO DESTROY NODE',0,-1,-1
datamsg5:
	DC.B	7,7,'           NODE DESTROYED',0,0
	DC.B	7,8,'   RETURNING CONTROL TO SHIP COMP',0,-1,-1
hyperendtext:
	DC.B	13,7,'DESTINATION  REACHED',0,0
	DC.B	13,8,' JUMP TUNNEL EXITED ',0,-1,-1
hyptext:
	DC.B	15,7,'SHIP IS CURRENTLY',0,0
	DC.B	13,8,'IN DESTINATION GALAXY',0,-1,-1
nothingmsg:
	DC.B	1,1,'SEARCH COMP HAS COMPLETED ITS',0,0
	DC.B	1,2,'ANALYSIS OF THE PLANET SURFACE',0,0
	DC.B	1,3,'AND CAN FIND NOTHING OF USE.',0,0
	DC.B	1,5,'NAVCOMP RETURNING CRAFT TO',0,0
	DC.B	1,6,'PLANETARY ORBIT.',0,0
	DC.B	13,14,'SPACEBAR TO CONTINUE',0,-1,-1
evidencemsg:
	DC.B	1,1,'SEARCH COMP HAS LOCATED THE',0,0
	DC.B	1,2,'RADIATION SEEPAGE PATTERN OF',0,0
	DC.B	1,3,'AN EVIDENCE CUBE.',0,0
	DC.B	1,5,'NAVCOMP HAS TRACKED CRAFT TO',0,0
	DC.B	1,6,'SOURCE AND RETREIVED CUBE.',0,0
	DC.B	1,8,'NAVCOMP RETURNING CRAFT TO',0,0
	DC.B	1,9,'PLANETARY ORBIT.',0,0
	DC.B	13,14,'SPACEBAR TO CONTINUE',0,-1,-1
credmsg:
	DC.B	1,1,'SEARCH COMP HAS COMPLETED ITS',0,0
	DC.B	1,2,'ANALYSIS OF THE PLANET SURFACE',0,0
	DC.B	1,3,'AND CAN FIND NOTHING OF USE.',0,0
	DC.B	1,4,'COMMUNICATIONS CONSOLE REPORTS',0,0
	DC.B	1,5,'THAT A 1000 CRED BOUNTY HAS',0,0
	DC.B	1,6,'BEEN DEPOSITED INTO YOUR',0,0
	DC.B	1,7,'ACCOUNT FOR CLEARING RENEGADES',0,0
	DC.B	1,8,'FROM PLANET SURFACE. THE SYSTEMS',0,0
	DC.B	1,9,'GOVERNMENT APPRECIATES YOUR',0,0
	DC.B	1,10,'ASSISTANCE.',0,0
	DC.B	1,11,'NAVCOMP RETURNING CRAFT TO',0,0
	DC.B	1,12,'PLANETARY ORBIT.',0,0
	DC.B	13,14,'SPACEBAR TO CONTINUE',0,-1,-1
wepmsg:
	DC.B	1,1,'SEARCH COMP HAS LOCATED A',0,0
	DC.B	1,2,'WEAPONS STORE.',0,0
	DC.B	1,4,'MAINTENECE COMP IS INSTALLING',0,0
	DC.B	1,5,'WEAPONS NOW.',0,0
	DC.B	1,7,'NAVCOMP RETURNING CRAFT TO',0,0
	DC.B	1,8,'PLANETARY ORBIT.',0,0
	DC.B	13,14,'SPACEBAR TO CONTINUE',0,-1,-1
fuelmsg:
	DC.B	1,1,'SEARCH COMP HAS LOCATED A',0,0
	DC.B	1,2,'FUEL STORE.',0,0
	DC.B	1,4,'TANKS HAVE BEEN REFUELED.',0,0
	DC.B	1,6,'NAVCOMP RETURNING CRAFT TO',0,0
	DC.B	1,7,'PLANETARY ORBIT.',0,0
	DC.B	13,14,'SPACEBAR TO CONTINUE',0,-1,-1
bubmsg:
	DC.B	1,1,'SEARCH COMP HAS DETECTED THE',0,0
	DC.B	1,2,'FAINT SIGNAL OF A FLIGHT',0,0
	DC.B	1,3,'BUBBLECORDER.',0,0
	DC.B	1,5,'NAVCOMP RETURNING CRAFT TO',0,0
	DC.B	1,6,'PLANETARY ORBIT.',0,0
	DC.B	13,14,'SPACEBAR TO CONTINUE',0,-1,-1
evitext1:
	DC.B	1,1,'THE PROPULSION SYSTEM OF THE CRUISER',0,0
	DC.B	1,2,'WAS OF A LIMITED RANGE IN ALL 3 AXIS.',0,0
	DC.B	1,3,'GIVING A STARCUBE OF POSSIBLE LOCATIONS',0,0
	DC.B	1,4,'AS SHOWN HERE.',0,0
	DC.B	13,14,'SPACEBAR TO CONTINUE',0,-1,-1
evitext2:
	DC.B	1,1,'THE EVIDENCE CUBE SUGGESTS THAT THE CRUISER',0,0
	DC.B	1,2,'HAD ALREADY REACHED ITS Y AXIS.',0,0
	DC.B	13,14,'SPACEBAR TO CONTINUE',0,-1,-1
evitext3:
	DC.B	1,1,'LEAVING ONLY A SINGLE PLANE OF 12 STAR SYSTEMS',0,0
	DC.B	1,2,'ALL OF WHICH ARE POSSIBLE LOCATIONS OF THE',0,0
	DC.B	1,3,'CRUISECORDER.',0,0
	DC.B	13,14,'SPACEBAR TO CONTINUE',0,-1,-1
evitext4:
	DC.B	1,1,'THE CRUISECORDER WAS INSTALLED WITH A MASS',0,0
	DC.B	1,2,'TRACKING DEVICE THAT WILL AUTOMATICALLY TRACK ',0,0
	DC.B	1,3,'IT TO OBJECTS WITH A GALACTIC MASS GREATER',0,0
	DC.B	1,4,'THAN OR EQUAL TO 2.00 .',0,0
	DC.B	13,14,'SPACEBAR TO CONTINUE',0,-1,-1
evitext6:
	DC.B	1,1,'PROJECTING FROM THE TIME SINCE THE EXPLOSION',0,0
	DC.B	1,2,'AND THE AMOUNT OF MATTER IN THIS REGION OF ',0,0
	DC.B	1,3,'SPACE IT IS HIGHLY LIKELY THAT THE CRUISECORDER',0,0
	DC.B	1,4,'WILL HAVE ALREADY SETTLED ON AN OBJECT WITH',0,0
	DC.B	1,5,'A GALACTIC MASS GREATER THAN 2.00 .',0,0
	DC.B	13,14,'SPACEBAR TO CONTINUE',0,-1,-1
evitext7:
	DC.B	1,1,'THE SHIP HAD ALREADY REACHED ITS X AXIS AS WELL',0,0
	DC.B	1,2,'AS ITS Y AXIS. THEREFORE THE CRUISECORDERS',0,0
	DC.B	1,3,'LOCATION MUST BE SOMWHERE ALONG THE LINE OF',0,0
	DC.B	1,4,'SYSTEMS AS SHOWN.',0,0
	DC.B	13,14,'SPACEBAR TO CONTINUE',0,-1,-1
evitext5:
	DC.B	1,1,'PREPARING STAR CHARTS FROM EVIDENCE PROVIDED',0,0
	DC.B	17,2,'PLEASE WAIT',0,-1,-1
helptext:
	DC.B	15,0,'AVAILABLE COMMANDS',0,0
	DC.B	5,2,'    COMMAND         : ABBREVIATION',0,0
	DC.B	5,4,'NAVIGATION COMPUTER : NAVCOMP',0,0
	DC.B	5,5,'ANALYSE EVIDENCE    : ANEV',0,0
	DC.B	5,6,'SHIP STATS          : SHIP',0,0
	DC.B	5,7,'ENEMY STATS         : ENEMY',0,0
	DC.B	5,8,'HYPERSPACE JUMP     : HYPER',0,0
	DC.B	5,9,'STORAGE OPTIONS     : DISK',0,0
	DC.B	5,10,'HELP                : HELP',0,0
	DC.B	5,11,'INTERSYSTEM FLIGHT  : INTERSYS',0,-1,-1
spmsg1:
	DC.B	17,0,'COURSE SETTING',0,0
	DC.B	1,2,'INTERSOLAR COURSE SET FOR : '
plan:	DC.B	'                       ',0,-1,-1
spmsg2:
	DC.B	7,7,'IRREGULAR ORBIT SOFTWARE REQUIRED',0,0
	DC.B	8,8,'     TO LAND ON THIS PLANET.',0,0
	DC.B	9,10,'        UNABLE TO LAND.',0,-1,-1
spmsg3:
	DC.B	8,7,'BOOTING AND RUNNING IRREGULAR',0,0
	DC.B	8,8,'        ORBIT SOFTWARE.',0,-1,-1
plertext:
	DC.B	7,7,'   THIS PLANET IS NOT PART OF',0,0
	DC.B	7,8,'SOLAR SYSTEM YOU ARE CURRENTLY IN.',0,-1,-1

loaderrormsg:
	DC.B	1,1,'DISK ERROR',0,0
	DC.B	1,3,'PLEASE MAKE SURE THE CORRECT DISK IS IN',0,0
	DC.B	1,4,'DRIVE A:',0,0
	DC.B	1,6,'ANY KEY TO CONTINUE.',0,-1,-1
loadmsg2:
	dc.b	1,1,'GAME LOADED SUCCESSFULLY.',0,0
	DC.B	13,14,'ANY KEY TO CONTINUE.',0,-1,-1
loadmsg1:
	DC.B	1,1,'PLEASE INSERT THE DISK WITH YOUR SAVED',0,0
	DC.B	1,2,'GAME IN DRIVE A:',0,0
	DC.B	1,4,'ANY KEY TO CONTINUE OR C TO CANCEL.',0,-1,-1

diskerror1msg:
	DC.B	1,1,'DISK ERROR',0,0
	DC.B	1,3,'MAKE SURE THE DISK IN A: IS FORMATTED',0,0
	DC.B	1,4,'WRITE ENABLED AND HAS ENOUGH ROOM FOR',0,0
	DC.B	1,5,'THE GAME FILE.',0,0
	DC.B	1,6,'ANY KEY TO CONTINUE',0,-1,-1

diskmsg1:
	dc.b	5,0,'LOAD OR SAVE GAME',0,0
	DC.B	1,3,'WOULD YOU LIKE TO LOAD',0,0
	DC.B	1,4,'OR SAVE GAME ?',0,0
	DC.B	1,5,'L/S ?',0,-1,-1
savedmsg:
	dc.b	1,1,'GAME SAVED SUCCESSFULLY.',0,0
	DC.B	13,14,'ANY KEY TO CONTINUE',0,-1,-1
diskmsg2:
	DC.B	1,1,'PLEASE MAKE SURE THERE IS A FORMATTED',0,0
	DC.B	1,2,'WRITE ENABLED DISK IN DRIVE A:',0,0
	DC.B	1,3,'ANY KEY TO CONTINUE OR C TO CANCEL.',0,-1,-1

gamefile:
	dc.b	'A:SYSJ.GAM',0

death1file:	dc.b	'death1.d2',0
death2file:	dc.b	'death2.d2',0
death3file:	dc.b	'death3.d2',0
death4file:	dc.b	'death4.d2',0
success1file:	dc.b	'intplan1.d2',0
success2file:	dc.b	'intplan2.d2',0
backfile1:	dc.b	'backgr1.d2',0
backfile2:	dc.b	'backgr2.d2',0
backfile3:	dc.b	'backgr3.d2',0
parra1afile:	dc.b	'back1.d2',0
parra1bfile:	dc.b	'back2.d2',0
parra1cfile:	dc.b	'back3.d2',0
psearchfile1:	dc.b	'psearch.d2',0
psearchfile2:	dc.b	'psearch.dl2',0
plan1file:	dc.b	'plan1.d2',0
plan2file:	dc.b	'plan2.d2',0
plan3file:	dc.b	'plan3.d2',0
deckfile:	dc.b	'cor.c2',0
deckfile2:	dc.b	'deckdlt.dl2',0
d1file: 	dc.b	'dopen2.dl2',0
d2file: 	dc.b	'lightsfi.dl2',0
bbfile: 	dc.b	'bb.dlt',0
pscrollfile1:	dc.b	'np1.dlt',0
filepara1:	dc.b	'np1.c2',0
pscrollfile2:	dc.b	'np2.dlt',0
filepara2:	dc.b	'np2.c2',0
pscrollfile3:	dc.b	'np3.dlt',0
filepara3:	dc.b	'np3.c2',0
spritefile:	dc.b	'spritall.d2',0
spritefile2:	dc.b	'sprite2.d2',0
spritefile3:	dc.b	'sprite3.d2',0
mainfile:	dc.b	'mainsp.d2',0
mapfile1:	dc.b	'map1.d2',0
mapfile2:	dc.b	'map2.d2',0
planetfile:	dc.b	'planets.d2',0
fileshipcomp:	dc.b	'front.c2',0
tradefile:	dc.b	'trade.c2',0
tradecfile:	dc.b	'tradecrs.d2',0
cityfile:	dc.b	'city.d2',0
title1file:	dc.b	'tintro.d2',0
title2file:	dc.b	'tintro.dl2',0
title3file:	dc.b	'sysjtit.d2',0
title4file:	dc.b	'tintros.d2',0
char:		dc.b	0
oldieb: 	dc.b	0
oldiea: 	dc.b	0
oldima: 	dc.b	0
cursorsave:	dc.b	92
save484:	dc.b	0
joyport0:	dc.b	0
joyport1:	dc.b	0
mymixer:	dc.b	%00111111
	even
*****************************************************************
*	These are the things we definitely want to save		*
*****************************************************************
savestart:
laser:		dc.w	-1
adsoftware:	dc.w	-1
amat:		dc.w	-1
sightavail:	dc.w	-1
orbitsoftware:	dc.w	-1	;plus yes -1 no
cloakingdevice:	dc.w	-1
shotxvelp:	dc.w	5
anaflag:	dc.w	-1
evidence:	dc.w	0	;no evidence to begin with
credits:	dc.w	2000
shootstate:	dc.w	0
shipsfuel:	dc.w	250
destination:	dc.l	0
location:	dc.l	0
package:
	dc.w	0,0
	dc.l	0
	dc.w	8
	dc.w	16
	dc.w	-1
	dc.w	0

addon1:
	dc.w	0,0
	dc.l	0
	dc.w	8
	dc.w	16
	dc.w	0
addon2:
	dc.w	0,0
	dc.l	0
	dc.w	8
	dc.w	16
	dc.w	44

p0000info:
	dc.w	trading		;type of game
	dc.w	notn		;whats on there (evd,cred,wep,fuel,notn)
	dc.l	0		;attacklist, or other dep on game
	dc.b	0		;blue planet d8a
	dc.b	'DRAXOL',-1	;planet name
	even
p0001info:
	dc.w	nogame		;type of game
	dc.w	notn		;whats on there (evd,cred,wep,fuel,notn)
	dc.l	0		;attacklist, or other dep on game
	dc.b	1		;blue planet d8a
	dc.b	'LANTH',-1	;planet name
	even
p0002info:
	dc.w	parralax1a	;type of game
	dc.w	cred		;whats on there (evd,cred,wep,fuel,notn)
	dc.l	zalorlist	;attacklist, or other dep on game
	dc.b	0		;blue planet d8a
	dc.b	'ZALOR',-1	;planet name
	even
p0003info:
	dc.w	parralax2a	;type of game
	dc.w	notn		;whats on there (evd,cred,wep,fuel,notn)
	dc.l	razorlist	;attacklist, or other dep on game
	dc.b	1		;blue planet d8a
	dc.b	'RAZORS WAY',-1 ;planet name
	even
p0004info:
	dc.w	parralax1b	;type of game
	dc.w	fuel		;whats on there (evd,cred,wep,fuel,notn)
	dc.l	traxllist	;attacklist, or other dep on game
	dc.b	0
	dc.b	'TRAXL',-1	;planet name
	even
p0100info:
	dc.w	scrollera	;type of game
	dc.w	notn		;whats on there (evd,cred,wep,fuel,notn)
	dc.l	0		;attacklist, or other dep on game
	dc.b	2
	dc.b	'LOCKERS',-1	;planet name
	even
p0101info:
	dc.w	nogame	 	;type of game
	dc.w	notn		;whats on there (evd,cred,wep,fuel,notn)
	dc.l	0		;attacklist, or other dep on game
	dc.b	0
	dc.b	'PAPILLON',-1	;planet name
	even
p0102info:
	dc.w	scrollerb	;type of game
	dc.w	evd		;whats on there (evd,cred,wep,fuel,notn)
	dc.l	0		;attacklist, or other dep on game
	dc.b	0
	dc.b	'KEY',-1	;planet name
	even
p0200info:
	dc.w	parralax2b
	dc.w	notn
	dc.l	sazollist
	dc.b	0
	dc.b	'SAZOL',-1
	even
p0201info:
	dc.w	parralax2c
	dc.w	wep
	dc.l	wartraxlist
	dc.b	1
	dc.b	'DRALION',-1
	even
p0202info:
	dc.w	nogame
	dc.w	notn
	dc.l	0
	dc.b	0
	dc.b	'WARTRAX',-1
	even
p0203info:
	dc.w	trading
	dc.w	notn
	dc.l	0
	dc.b	1
	dc.b	'SCAR',-1
	even
p0204info:
	dc.w	parralax1c
	dc.w	cred
	dc.l	axislist
	dc.b	1
	dc.b	'AXIS',-1
	even
p0205info:
	dc.w	nogame
	dc.w	notn
	dc.l	0
	dc.b	1
	dc.b	'TINY',-1
	even
p0300info:
	dc.w	scrollera
	dc.w	cred
	dc.l	0
	dc.b	0
	dc.b	'LANKER',-1
	even
p0301info:
	dc.w	nogame
	dc.w	notn
	dc.l	0
	dc.b	1
	dc.b	'STRODAS',-1
	even
p0302info:
	dc.w	nogame
	dc.w	notn
	dc.l	0
	dc.b	1
	dc.b	'PORTVAY',-1
	even
p0303info:
	dc.w	scrollerc
	dc.w	notn
	dc.l	0
	dc.b	1
	dc.b	'DASCAR',-1
	even
p0400info:
	dc.w	parralax1a
	dc.w	wep
	dc.l	hockerlist
	dc.b	0
	dc.b	'HOCKER',-1
	even
p0401info:
	dc.w	nogame
	dc.w	notn
	dc.l	0
	dc.b	0
	dc.b	'LITHNODE',-1
	even
p0402info:
	dc.w	nogame
	dc.w	notn
	dc.l	0
	dc.b	1
	dc.b	'CINTRAX',-1
	even
p0403info:
	dc.w	parralax1b
	dc.w	notn
	dc.l	driscollist
	dc.b	1
	dc.b	'DRISCOL',-1
	even
p0500info:
	dc.w	parralax1c
	dc.w	notn
	dc.l	kulalist
	dc.b	0
	dc.b	'KULA',-1
	even
p0501info:
	dc.w	parralax2b
	dc.w	fuel
	dc.l	lomalist
	dc.b	0
	dc.b	'LOMA',-1
	even
p0502info:
	dc.w	scrollerb
	dc.w	cred
	dc.l	0
	dc.b	1
	dc.b	'ZODAPH',-1
	even
p0503info:
	dc.w	nogame
	dc.w	notn
	dc.l	0
	dc.b	0
	dc.b	'KODAXIL',-1
	even
p0600info:
	dc.w	nogame
	dc.w	notn
	dc.l	0
	dc.b	0
	dc.b	'JANZOR',-1
	even
p0601info:
	dc.w	trading
	dc.w	bub
	dc.l	0
	dc.b	0
	dc.b	'TULAPI',-1
	even
p0602info:
	dc.w	parralax1a
	dc.w	cred
	dc.l	razarelist
	dc.b	1
	dc.b	'RAZARE',-1
	even
p0603info:
	dc.w	nogame
	dc.w	notn
	dc.l	0
	dc.b	0
	dc.b	'REVASH',-1
	even
p0604info:
	dc.w	nogame
	dc.w	notn
	dc.l	0
	dc.b	0
	dc.b	'SORT',-1
	even
p0605info:
	dc.w	nogame
	dc.w	notn
	dc.l	0
	dc.b	0
	dc.b	'OVERLAX',-1
	even
p0700info:
	dc.w	parralax2a
	dc.w	notn
	dc.l	grazelist
	dc.b	0
	dc.b	'GRAZE',-1
	even
p0701info:
	dc.w	trading
	dc.w	notn
	dc.l	0
	dc.b	1
	dc.b	'BANDROX',-1
	even
p0702info:
	dc.w	parralax2b
	dc.w	wep
	dc.l	diagerlist
	dc.b	1
	dc.b	'DIAGER',-1
	even
p0703info:
	dc.w	nogame
	dc.w	notn
	dc.l	0
	dc.b	1
	dc.b	'DYNAPRAC',-1
	even
p0704info:
	dc.w	nogame
	dc.w	notn
	dc.l	0
	dc.b	0
	dc.b	'BYRNAZ',-1
	even

p0800info:
	dc.w	nogame
	dc.w	notn
	dc.l	0
	dc.b	0
	dc.b	'TWEEDY',-1
	even
p0801info:
	dc.w	nogame
	dc.w	notn
	dc.l	0
	dc.b	1
	dc.b	'YPRESS',-1
	even
p0802info:
	dc.w	nogame
	dc.w	notn
	dc.l	0
	dc.b	0
	dc.b	'QUEST',-1
	even

p0900info:
	dc.w	parralax2c
	dc.w	notn
	dc.l	rainlist
	dc.b	1
	dc.b	'RAIN',-1
	even
p0901info:
	dc.w	scrollerc
	dc.w	notn
	dc.l	0
	dc.b	2
	dc.b	'LUSH',-1
	even
p0902info:
	dc.w	trading
	dc.w	notn
	dc.l	0
	dc.b	0
	dc.b	'FERN',-1
	even
p0903info:
	dc.w	parralax1b
	dc.w	evd
	dc.l	canopylist
	dc.b	0
	dc.b	'CANOPY',-1
	even

p1000info:
	dc.w	nogame
	dc.w	notn
	dc.l	0
	dc.b	0
	dc.b	'TROLLITH',-1
	even
p1001info:
	dc.w	parralax2c
	dc.w	cred
	dc.l	colpalist
	dc.b	1
	dc.b	'COLPA',-1
	even
p1002info:
	dc.w	nogame
	dc.w	notn
	dc.l	0
	dc.b	0
	dc.b	'THIBAN',-1
	even
p1003info:
	dc.w	parralax1b
	dc.w	wep
	dc.l	liquelist
	dc.b	1
	dc.b	'LIQUE',-1
	even
p1004info:
	dc.w	parralax1b
	dc.w	notn
	dc.l	instaxlist
	dc.b	0
	dc.b	'INSTAX',-1
	even

p1100info:
	dc.w	nogame
	dc.w	notn
	dc.l	0
	dc.b	1
	dc.b	'TWILLSWAY',-1
	even
p1101info:
	dc.w	parralax1c
	dc.w	wep
	dc.l	slotaslist
	dc.b	0
	dc.b	'SLOTAS',-1
	even
p1102info:
	dc.w	parralax2c
	dc.w	cred
	dc.l	drequelist
	dc.b	0
	dc.b	'DREQUE',-1
	even
p1103info:
	dc.w	nogame
	dc.w	notn
	dc.l	0
	dc.b	0
	dc.b	'YANUX',-1
	even
saveend:

