spritex:	equ	0
spritey:	equ	2
spritead:	equ	4
iea:	equ	$fffa07
ieb:	equ	$fffa09
isra:	equ	$fffa0f
ima:	equ	$fffa13
tbcr:	equ	$fffa1b
tbdr:	equ	$fffa21
vbl_vec:	equ	$70
key_vec:	equ	$118
hbl_vec:	equ	$120
magic:		equ	1650
numstars:	equ	12
speed:		equ	350
zclip:		equ	100
start:
	clr.l   -(SP)           ;Go into supervisor mode
        move.w  #$20,-(SP)
        trap    #1
        addq.l  #6,SP
        move.l  D0,savesup
*	move.b	#0,$484
	move.l	$426,rvsave
	move.l	$42a,resave
	move.l	#$31415926,$426	;set reset vector valid
	move.l	#myreset,$42a
	move.w	#4,-(sp)
	trap	#14
	addq.l	#2,sp
	move.w	d0,ressave

	move.w	#0,-(sp)	;set to low res
	move.l	#-1,-(sp)
	move.l	#-1,-(sp)
	move.w	#5,-(sp)
	trap	#14
	add.l	#12,sp

	move.w	#-1,firebutton
	lea	bluepalette,a0
	jsr	mydocolors
	jsr	joystuff
	jsr	putrout
	jsr	getscrn
	jsr	plotinit
	jsr	clearboth
	move.l	#fileshipcomp,filename
	jsr	loadscr
	move.l	#fileplan,filename
	jsr	loadplan
	move.l	#12345,d0
	jsr	randomseed
	move.w	#-1,firebutton
	lea	framevbl,a1
	jsr	putvbl
	move.l	a0,oldvbl1
	jsr	copyintoboth
	jsr	preplanet

mainloop:
	jsr	planet
	jsr	flip_scr
	jsr	keyboard
	bra	mainloop

*********************************************************
* Planet routine. Simulates a huge planet rotating	*
* just above line of sight. Random surface soon to be	*
* added.						*
*********************************************************
planet:
	lea	planetmem,a0
	move.l	a0,a1
	addi.l	#144,a1
	moveq	#98,d0
planetscroll:
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	dbf	d0,planetscroll
	bra	terrainline1
	rts


*********************************************************
*	first set up mem for it				*
*********************************************************
preplanet:
	lea	planetmem,a0
	move.w	#7199,d0
	lea	planetmem2,a1
	move.l	a1,terrainwhere
pploop:
	move.w	(a1)+,(a0)+
	rts
	
*********************************************************
*********************************************************
terrainline1:
	move.l	terrainwhere,a6
	moveq	#17,d0
ter1:
	move.w	(a6)+,(a0)+
	move.w	(a6)+,(a0)+
	move.w	(a6)+,(a0)+
	move.w	(a6)+,(a0)+
	dbf	d0,ter1
	lea	planetmem2,a1
	addi.l	#14400,a1
	cmp.l	a1,a6
	beq	rest
	move.l	a6,terrainwhere
	rts
rest:
	move.l	#planetmem2,terrainwhere
	rts

terrainwhere:	dc.l	0
planetmem:	blk.w	72*100,0	;mem 100 lines high
planetmem2:	blk.w	72*100,0	;mem 100 lines high
*****************************************
*	my own personal poly draw	*
*****************************************
draw_polygon2:
	movem.l	d0-d7/a0-a6,-(sp)
	lea	surfacevrt,a6
	move.w	(a6)+,d7		;get number
	subq.w	#2,d7
	move.w	#1024,d2		;lowest poss x,y
getminloop:
	cmp.w	(a6),d2
	blt	gmm1
	move.w	(a6),d2		;becomes new max
gmm1:
	addq.l	#4,a6
	dbf	d7,getminloop
	lea	surfacevrt,a6
	move.w	(a6)+,d7		;get number
	subq.w	#2,d7
	move.w	#-1024,d3		;lowest poss x,y
getmaxloop:
	cmp.w	(a6),d3
	bgt	gmm2
	move.w	(a6),d3		;becomes new max
gmm2:
	addq.l	#4,a6
	dbf	d7,getmaxloop

	cmpi.w	#cxmax,d2
	bge	nono
	cmpi.w	#cxmin,d3
	ble	nono
	
	lea	surfacevrt,a0
	move.w	(a0)+,d7		;number of vertices
	subq.w	#1,d7
	moveq	#0,d6
	move.w	#1024,d0
getl:
	cmp.w	2(a0),d0
	bge	swappeml
	addq.l	#4,a0
	addq.w	#1,d6
	dbf	d7,getl
	bra	rotatelist
swappeml:
	move.w	2(a0),d0
	move.w	d6,lowestpair
	addq.l	#1,d6		;count how far in
	addq.l	#4,a0
	dbf	d7,getl		;note that is highest on screen

rotatelist:
	cmpi.w	#cymax,d0	;check if lowest y is above clipy
	bge	nono
	move.w	lowestpair,d0
	beq	noneedtorot
	lea	surfacevrt,a0
	move.l	a0,a1
	subq.w	#1,d0
rtloop:
	move.l	a1,a0
	move.w	(a0)+,d1		;number of em
	subq.w	#2,d1
	move.w	(a0),d2
	move.w	2(a0),d3
rtloop2:
	move.w	4(a0),(a0)
	move.w	6(a0),2(a0)
	addq.l	#4,a0
	dbf	d1,rtloop2
	move.w	d2,(a0)
	move.w	d3,2(a0)
	dbf	d0,rtloop
noneedtorot:
gethighest:
	lea	surfacevrt,a0
	move.w	(a0)+,d7		;number of vertices
	subq.w	#1,d7
	moveq	#0,d6
	move.w	#-1024,d0
geth:
	cmp.w	2(a0),d0
	blt	swappemh
	addq.l	#4,a0
	addq.w	#1,d6
	dbf	d7,geth
	bra	seperateleftright
swappemh:
	move.w	2(a0),d0
	move.w	d6,highestpair
	addq.l	#1,d6		;count how far in
	addq.l	#4,a0
	dbf	d7,geth		;note that is highest on screen

seperateleftright:
	cmpi.w	#cymin,d0
	ble	nono
	lea	surfacevrt,a0
	move.w	(a0)+,d3
	lea	rightlist,a1
	move.w	highestpair,d0
	beq	nono
	move.w	d0,(a1)+	;number of points
sprloop:
	move.w	(a0)+,(a1)+
	move.w	(a0)+,(a1)+
	dbf	d0,sprloop

	lea	surfacevrt,a3
	move.w	highestpair,d0
	sub.w	d0,d3		;overall number of points -highest
	lea	leftlist,a1
	move.w	d3,(a1)+	;number of points
	move.w	(a3)+,d4	;get number
	move.w	(a3),(a1)+	;top point
	move.w	2(a3),(a1)+
	asl.w	#2,d4		;*4
	add.w	d4,a3		;should now point at bottom of list
	subq.w	#1,d3
splloop:
	move.w	-(a3),2(a1)	;y
	move.w	-(a3),(a1)	;x	
	addq.l	#4,a1
	dbf	d3,splloop

calculatecoords:
	lea	lxylist,a6
	addq.l	#2,a6		;fill in number later
	lea	leftlist,a0
	moveq	#0,d6		;counter for Ys
	bsr	calccoords
	lea	lxylist,a0
	move.w	d6,(a0)		;count of y's
	ble	nono

	lea	rxylist,a6
	addq.l	#2,a6		;fill in number later
	lea	rightlist,a0
	moveq	#0,d6		;counter for Ys
	bsr	calccoords
	lea	rxylist,a0
	move.w	d6,(a0)		;count of y's
	ble	nono
	bra	drawitin

calccoords:
	move.w	(a0)+,d7	;number of line segs
	subq.w	#1,d7
ccloop1:
	moveq	#0,d0
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3
	move.w	(a0),d0		;x1
	move.w	2(a0),d1	;y1
	move.w	4(a0),d2	;x2
	move.w	6(a0),d3	;y2
	sub.w	d1,d3		;y2-y1	gives number of y's
	ble	skipthis
	sub.w	d0,d2		;x2-x1
	asl.l	#4,d2		;scale up
	ext.l	d2
	divs	d3,d2		;div by y
	ext.l	d2
	asl.l	#4,d0
	ext.l	d0
	subq.w	#1,d3
*	cmpi.w	#250,d3
*	blt	ccloop1in
*	addq.l	#4,sp
*	bra	nono
ccloop1in:
	move.l	d0,d4
	cmpi.w	#cymin,d1
	bge	clp3
	bra	clp5
clp3:
	cmpi.w	#cymax,d1
	ble	clp4
	bra	clp5
clp4:
	asr.l	#4,d4		;scale down
	cmpi.w	#cxmin,d4
	bge	clp1
	move.w	#cxmin,d4
	bra	clp2
clp1:
	cmpi.w	#cxmax,d4
	ble	clp2
	move.w	#cxmax,d4
clp2:
	move.w	d4,(a6)+	;x
	move.w	d1,(a6)+	;y
	addq.w	#1,d6
clp5:	add.l	d2,d0		;add xamount
	addq.w	#1,d1		;next y
	dbf	d3,ccloop1in
skipthis:
	addq.l	#4,a0		;move to next coords
	dbf	d7,ccloop1
	asr.l	#4,d0
	move.w	d0,(a6)+	;spit the last out
	move.w	d1,(a6)+
skt:	rts

drawitin:
	lea	surfacedfn,a0
	move.w	(a0)+,d7
	move.w	(a0)+,d5		;secondcol
	bsr	init_hcol2
	lea	lxylist,a5
	lea	rxylist,a6
	move.w	(a5)+,d6	;count of y's
	subq.w	#1,d6
*	bmi	nono
	addq.l	#2,a6
diiloop:
	move.w	(a5)+,d2	;x1
	move.w	(a6)+,d4	;x2
	move.w	(a5)+,d0	;y1
	addq.l	#2,a6		;no need for extra y
	bsr	drawtheline
	dbf	d6,diiloop
nono:	movem.l	(sp)+,d0-d7/a0-a6
	rts

surfacedfn:	dc.w	0	;color
		dc.l	surfacevrt
surfacevrt:	dc.w	0	;number of points
		blk.w	64,0

******************************************
*	d0=y1  d2=x1  d4=x2
drawtheline:
	exg	a3,a2
	cmpi.w	#cxmax,d2
	bgt	noline		;totally off screen
	cmpi.w	#cxmin,d4
	blt	noline		;totally off screen
dlt4:
*	cmpi.w	#cymin,d0
*	blt	noline
*dlt5:
*	cmpi.w	#cymax,d0
*	bgt	noline

	cmp.w	d2,d4
	blt	noline
	move.w	d2,x1
	move.w	d4,x2
	move.l	ytable,a0	;add of tab with y addresses
*	move.w	d0,d1		;get a copy of it
	lsl.w	#2,d0		;mult by 4
	move.l	(a0,d0.w),a0	;a0 has add of start of line
	move.w	d2,d3		;make a copy x1
	and.w	#$fff0,d2
	lsr.w	#1,d2	
	add.w	d2,a0		;a0 has add of start of line
	move.w	d4,d5		;d5 has x2
	and.w	#$fff0,d4
	lsr.w	#4,d4
	move.w	d3,d2
	and.w	#$fff0,d2
	lsr.w	#4,d2
	sub.w	d2,d4		;gives number of words across
	lea	endmask,a1
	and.w	#15,d3
	lsl.w	#1,d3
	move.w	(a1,d3.w),d0	;d0 start mask
	lea	startmask,a1
	and.w	#15,d5
	lsl.w	#1,d5
	move.w	(a1,d5.w),d1	;d1 end mask
	bra	drawhline
noline:
	rts

drawhline:
	cmpi.w	#1,d4
	blt	allline
	beq	spechline
	bsr	drawstart
	bsr	drawmid
	bsr	drawend
	rts

spechline:
	bsr	drawstart
	bsr	drawend
	rts

drawstart:
	move.w	d0,d7
	not	d7
	and.w	d0,(a0)
	move.w	(a3),d5
	and.w	d7,d5
	or	d5,(a0)+

	and.w	d0,(a0)
	move.w	2(a3),d5
	and.w	d7,d5
	or	d5,(a0)+

	and.w	d0,(a0)
	move.w	4(a3),d5
	and.w	d7,d5
	or	d5,(a0)+

	and.w	d0,(a0)
	move.w	6(a3),d5
	and.w	d7,d5
	or	d5,(a0)+
	rts
*******************
*	d0=start mask
*	d1=end mask
*	d4=words across may have to sub 1 or 2 ????
*	d6=number of y positions
*	a0=start address
*	a1=copy of a0
*	a3=color table
*******************
drawmid:
	move.w	d4,d2	;copy width
	subq.w	#2,d2
dml:
	move.w	(a3),(a0)+
	move.w	2(a3),(a0)+
	move.w	4(a3),(a0)+
	move.w	6(a3),(a0)+
	dbf	d2,dml
	rts
drawend:
	move.w	d1,d7
	not	d7
	and.w	d1,(a0)
	move.w	(a3),d5
	and.w	d7,d5
	or	d5,(a0)+

	and.w	d1,(a0)
	move.w	2(a3),d5
	and.w	d7,d5
	or	d5,(a0)+

	and.w	d1,(a0)
	move.w	4(a3),d5
	and.w	d7,d5
	or	d5,(a0)+

	and.w	d1,(a0)
	move.w	6(a3),d5
	and.w	d7,d5
	or	d5,(a0)+
	rts
drhs:
	bsr	drawstart
	bra	drawend

allline:
*	move.w	$cccc,(a0)
*	rts
	move.w	x1,d2	;x1
	and.w	#15,d2
	move.w	x2,d5
	and.w	#15,d5
*	addq.w	#1,d5
	add.w	d2,d2
	add.w	d5,d5
*	cmp.w	d2,d5
*	bmi	drhs

	move.l	#startmask,a4
	move.w	(a4,d2.w),d0	
	move.l	#endmask,a4
	and.w	(a4,d5.w),d0	
	move.w	d0,d7
	not	d7

	and.w	d7,(a0)
	move.w	(a3),d5
	and.w	d0,d5
	or	d5,(a0)+

	and.w	d7,(a0)
	move.w	2(a3),d5
	and.w	d0,d5
	or	d5,(a0)+

	and.w	d7,(a0)
	move.w	4(a3),d5
	and.w	d0,d5
	or	d5,(a0)+

	and.w	d7,(a0)
	move.w	6(a3),d5
	and.w	d0,d5
	or	d5,(a0)+
	rts

startmask:
	dc.w	$ffff,$7fff,$3fff,$1fff
	dc.w	$0fff,$07ff,$03ff,$01ff
	dc.w	$00ff,$007f,$003f,$001f
	dc.w	$000f,$0007,$0003,$0001
	dc.w	$0000
endmask:
	dc.w	$0000,$8000,$c000,$e000
	dc.w	$f000,$f800,$fc00,$fe00
	dc.w	$ff00,$ff80,$ffc0,$ffe0
	dc.w	$fff0,$fff8,$fffc,$fffe
	dc.w	$ffff


init_hcol2:
		asl.w   #3,D7		;index a3 table
		asl.w   #3,D5		;index a3 table
                lea     col_table,a4
                lea     (a4,D7.w),a4 
		lea	finalcoltable,a3
		move.w	(a4)+,d0
		move.w	(a4)+,d1
		move.w	(a4)+,d2
		move.w	(a4)+,d3
		lea	col_table2,a4
		lea	(a4,d5.w),a4
		or.w	(a4)+,d0
		or.w	(a4)+,d1
		or.w	(a4)+,d2
		or.w	(a4)+,d3
		lea	altcoltable,a2
		move.w	d0,(a3)
		move.w	d1,2(a3)
		move.w	d2,4(a3)
		move.w	d3,6(a3)
		ror.w	#1,d0
		ror.w	#1,d1
		ror.w	#1,d2
		ror.w	#1,d3
		move.w	d0,(a2)
		move.w	d1,2(a2)
		move.w	d2,4(a2)
		move.w	d3,6(a2)
                rts
finalcoltable:
	dc.w	0,0,0,0
altcoltable:
	dc.w	0,0,0,0

col_table:
		DC.w      00,00,00,00     ;Colour 0
                DC.w      $aaaa,00,00,00     ;Colour 1
                DC.w      00,$aaaa,00,00     ;Colour 2
                DC.w      $aaaa,$aaaa,00,00     ;Colour 3
                DC.w      00,00,$aaaa,00     ;Colour 4        
                DC.w      $aaaa,00,$aaaa,00     ;Colour 5        
                DC.w      00,$aaaa,$aaaa,00     ;Colour 6        
                DC.w      $aaaa,$aaaa,$aaaa,00     ;Colour 7        
                DC.w      00,00,00,$aaaa     ;Colour 8        
                DC.w      $aaaa,00,00,$aaaa     ;Colour 9
                DC.w      00,$aaaa,00,$aaaa     ;Colour 10
                DC.w      $aaaa,$aaaa,00,$aaaa     ;Colour 11
                DC.w      00,00,$aaaa,$aaaa     ;Colour 12
                DC.w      $aaaa,00,$aaaa,$aaaa     ;Colour 13
                DC.w      00,$aaaa,$aaaa,$aaaa     ;Colour 14       
                DC.w      $aaaa,$aaaa,$aaaa,$aaaa     ;Colour 15
col_table2:
		DC.w      00,00,00,00     ;Colour 0
                DC.w      $5555,00,00,00     ;Colour 1
                DC.w      00,$5555,00,00     ;Colour 2
                DC.w      $5555,$5555,00,00     ;Colour 3
                DC.w      00,00,$5555,00     ;Colour 4        
                DC.w      $5555,00,$5555,00     ;Colour 5        
                DC.w      00,$5555,$5555,00     ;Colour 6        
                DC.w      $5555,$5555,$5555,00     ;Colour 7        
                DC.w      00,00,00,$5555     ;Colour 8        
                DC.w      $5555,00,00,$5555     ;Colour 9
                DC.w      00,$5555,00,$5555     ;Colour 10
                DC.w      $5555,$5555,00,$5555     ;Colour 11
                DC.w      00,00,$5555,$5555     ;Colour 12
                DC.w      $5555,00,$5555,$5555     ;Colour 13
                DC.w      00,$5555,$5555,$5555     ;Colour 14       
                DC.w      $5555,$5555,$5555,$5555     ;Colour 15



lxylist:	blk.w	500,0		;space for 123 coord pairs
rxylist:	blk.w	500,0
highestpair:	dc.w	0
lowestpair:	dc.w	0
leftlist:	blk.w	500,0
rightlist:	blk.w	500,0

******************************************
setuphbl:
	move.w	#$2700,sr
	move.l	#hbllist,hblsave
	move.b	ieb,oldieb
	move.b	iea,oldiea
	move.b	ima,oldima
	move.l	key_vec,oldkeyvec
	move.l	key_vec,keyt+2
	move.l	#key_handler,key_vec		;put new key stuff in
	move.l	hbl_vec,oldhblvec

	and.b	#$df,ieb	;stop 200hz timer
	and.b	#$fe,iea	;stop hblank
	move.l	hbl_vec,oldhblvec
	move.l	#hblhandler1,hbl_vec
	or.b	#1,iea			;enable hblank
	or.b	#1,ima
	move.l	vbl_vec,vblt+2		;set up vbl handler
	move.l	vbl_vec,oldvblvec
	move.l	#vbl_handler,vbl_vec
	move.b	#0,tbcr
	move.b	#5,tbdr
	move.b	#8,tbcr
	move.w	#$2300,sr
	rts

hblhandler2:
	movem.l	a0/a1,-(sp)
	move.l	#$ff8240,a0
	lea	palette2,a1
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	movem.l	(sp)+,a0/a1
	move.b	#0,tbcr
	move.b	#100,tbdr
	move.b	#8,tbcr
	bclr	#0,isra
	rte
hblhandler1:
	movem.l	d0/a0,-(sp)
	move.l	hblsave,a0
	move.w	(a0)+,d0
	bmi	endlist
	move.w	d0,$ff8240
	move.b	#0,tbcr
	move.w	(a0)+,d0
	move.l	a0,hblsave
	move.b	d0,tbdr
	move.b	#8,tbcr
	bclr	#0,isra
	movem.l	(sp)+,d0/a0
	rte
endlist:
	movem.l	a0/a1,-(sp)
	move.l	#$ff8240,a0
	lea	palette2,a1
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	movem.l	(sp)+,a0/a1
	move.b	#0,tbcr
	move.w	(a0)+,d0
	move.l	a0,hblsave
	move.b	d0,tbdr
	move.b	#8,tbcr
	bclr	#0,isra
	movem.l	(sp)+,d0/a0
	rte
	

hbllist:
	dc.w	$0007,1,$0005,6,$0007,1,$0005,110,$0004
	dc.w	4,$0005,3,$0004,1,$0333,2,$0555,13,-1,11
	dc.w	$0444,1,$0666,1,$0777,1,$0555,1,$0444
	dc.w	1,$0333,1,$0555,1,$0333,6,$0555,9,$0444
	dc.w	1,$0666,1,$0777,1,$0555,1,$0444,1,$0333
	dc.w	1,$0555,1,$0333,6,$0555,13

hblsave:	dc.l	0
	
vbl_handler:
	move.l	#hbllist,hblsave
	move.b	#0,tbcr
	move.b	#5,tbdr
	move.b	#8,tbcr
*	move.l	#hblhandler1,hbl_vec
vblt:	jmp	$0

key_handler:
	move.w	#$2500,sr
keyt:	jmp	$0


oldvblvec:	blk.l	1,0
oldkeyvec:	blk.l	1,0
oldhblvec:	blk.l	1,0
oldieb:		blk.b	1,0
oldiea:		blk.b	1,0
oldima:		blk.b	1,0
even

restoremfp:
	move.b	oldieb,ieb
	move.b	oldiea,iea
	move.b	oldima,ima
	move.l	oldkeyvec,key_vec
	move.l	oldhblvec,hbl_vec
	move.l	oldvblvec,vbl_vec
	rts


my400save:	dc.l	0

*************************************
leftbutton:	equ	1
rightbutton:	equ	2
bothbuttons:	equ	3
*************************************
dopointer:
	lea	ship1sp,a0
	move.w	mx,(a0)
	move.w	my,2(a0)
	bsr	putsprite
	rts
**********************************
clearboth:
	move.l	seen,a0
	move.l	hiden,a1
	move.w	#15999,d0
cbl:
	move.w	#0,(a0)+
	move.w	#0,(a1)+
	dbf	d0,cbl
	rts
*****************************************
copyintoboth:
	move.l	screen3,a0
	move.l	hiden,a1
	move.l	seen,a2
	move.w	#7999,d0
cibloop:
	move.l	(a0),(a1)+
	move.l	(a0)+,(a2)+
	dbf	d0,cibloop
	rts
xvel:		dc.w	0
yvel:		dc.w	0
tilt:		dc.w	0
yoffs:		dc.w	560
calcvsa:
*	move.w	x1,d0
*	move.w	y1,d1
	move.w	d0,d2
	and.w	#15,d2
	lsl.w	#2,d1          ;mult by 4 for index
	lsr.w	#1,d0             ;x coord / 2
	and.w	#$00f8,d0      ;strip lower 3 bits
	move.w	d0,a0        ;move x offset to A0
	move.l	sytable,a1   ;get y table addr
	adda.l	(a1,d1.w),a0 ;got final pixel addr!
	rts
calcvsah:
*	move.w	x1,d0
*	move.w	y1,d1
	move.w	d0,d2
	and.w	#15,d2
	lsl.w	#2,d1          ;mult by 4 for index
	lsr.w	#1,d0             ;x coord / 2
	and.w	#$00f8,d0      ;strip lower 3 bits
	move.w	d0,a6        ;move x offset to A0
	move.l	ytable,a1   ;get y table addr
	adda.l	(a1,d1.w),a6 ;got final pixel addr!
	rts
*******************************
cxmin:		equ	16
cxmax:		equ	303
cymin:		equ	13
cymax:		equ	122
cbits:	blk.w	1,0
cbits2:	blk.w	1,0
xsav:	blk.w	1,0
ysav:	blk.w	1,0
*/**//*/*//*//*/*//*//*/*/*//*/*/*/*//*/*/*/*//*//*//*///*/*/
bitcode:clr.l   d4
        cmpi.w  #cxmin,d0
        bge     b1
        or.b    #8,d4
b1:     cmpi.w  #cxmax,d0
        ble     b2
        or.b    #4,d4
b2:     cmpi.w  #cymin,d1
        bge     b3
        or.b    #1,d4
b3:     cmpi.w  #cymax,d1
        ble     b4
        or.b    #2,d4
b4:     move.w  d4,cbits
        rts
*****
bitc2:   clr.l   d5
        cmpi.w  #cxmin,d2
        bge     b5
        or.b    #8,d5
b5:     cmpi.w  #cxmax,d2
        ble     b6
        or.b    #4,d5
b6:     cmpi.w  #cymin,d3
        bge     b7
        or.b    #1,d5
b7:     cmpi.w  #cymax,d3
        ble     b8
        or.b    #2,d5
b8:     move.w  d5,cbits2
        rts
********************************************************
clipit:
	movem.l	d0-d7/a0,-(sp)
	move.w	x1,d0
	move.w	y1,d1
	move.w	x2,d2
	move.w	y2,d3

	bsr     bitcode
        bsr     bitc2
clipit2:or.b    d4,d5
        tst.b   d5
        beq     cliphome        ;finish if
        move.w  cbits,d4
        move.w  d2,xsav
        move.w  d3,ysav
        move.w  cbits2,d5
clip1:  and.b   d4,d5
        tst.b   d5
        bgt     clipb           ;home if line completely out
        move.w  cbits,d4
        move.w  cbits2,d5
        sub.w   d0,d2           ;d1 has dx
        move.w  d2,dx
        sub.w   d1,d3           ;d3 has dy
        move.w  d3,dy
        move.w  xsav,d2
        move.w  ysav,d3
        tst.w   d4
        beq     clip2   	;if x1<xmin
        cmpi.w  #cxmin,d0 	;y1=y1+dy*(xmin-x1)/dx
        bge     c1      
        move.w  #cxmin,d7         ;put xmin in d7
        sub.w   d0,d7
        muls    dy,d7           ;multiply by dy
        divs    dx,d7
        add.w   d1,d7
        move.w  d7,d1
        move.w  #cxmin,d0         ;x1=xmin
        bra     c4
c1:     cmpi.w  #cxmax,d0         ;if x1>xmax
        ble     c2              ;y1=y1+dy*(xmax-x1)/dx
        move.w  #cxmax,d7         ;put xmax in d7
        sub.w   d0,d7
        muls    dy,d7           ;multiply by dy
        divs    dx,d7
        add.w   d1,d7
        move.w  d7,d1
        move.w  #cxmax,d0         ;x1=xmax
        bra     c4
c2:     cmpi.w  #cymin,d1         ;if y1<ymin
        bge     c3
        move.w  #cymin,d7         ;put ymin in d7
        sub.w   d1,d7
        muls    dx,d7           ;multiply by dx
        divs    dy,d7
        add.w   d0,d7
        move.w  d7,d0
        move.w  #cymin,d1         ;y1=ymin
        bra     c4
c3:     cmpi.w  #cymax,d1         ;if y1>xmax
        ble     c4
        move.w  #cymax,d7         ;put ymax in d7
        sub.w   d1,d7
        muls    dx,d7           ;multiply by dy
        divs    dy,d7
        add.w   d0,d7
        move.w  d7,d0
        move.w  #cymax,d1         ;y1=ymax
c4:     bsr     bitcode
        bra     cliploop
******
clip2:  cmpi.w  #cxmin,d2 ;	y1=y1+dy*(xmin-x1)/dx
        bge     cc1     
        move.w  #cxmin,d7         ;put xmin in d7
        sub.w   d2,d7
        muls    dy,d7           ;multiply by dy
        divs    dx,d7
        add.w   d3,d7
        move.w  d7,d3
        move.w  #cxmin,d2         ;x2=xmin
        bra     cc4
cc1:    cmpi.w  #cxmax,d2         ;if x2>xmax
        ble     cc2
        move.w  #cxmax,d7         ;put xmax in d7
        sub.w   d2,d7
        muls    dy,d7           ;multiply by dy
        divs    dx,d7
        add.w   d3,d7
        move.w  d7,d3
        move.w  #cxmax,d2         ;x1=xmax
        bra     cc4
cc2:    cmpi.w  #cymin,d3         ;if y1<ymin
        bge     cc3
        move.w  #cymin,d7         ;put ymin in d7
        sub.w   d3,d7
        muls    dx,d7           ;multiply by dx
        divs    dy,d7
        add.w   d2,d7
        move.w  d7,d2
        move.w  #cymin,d3         ;y1=ymin
        bra     cc4
cc3:    cmpi.w  #cymax,d3         ;if y1>xmax
        ble     cc4
        move.w  #cymax,d7         ;put ymax in d7
        sub.w   d3,d7
        muls    dx,d7           ;multiply by dy
        divs    dy,d7
        add.w   d2,d7
        move.w  d7,d2
        move.w  #cymax,d3         ;y1=ymax
cc4:    bsr     bitc2
        bra     cliploop

cliploop:
        bra     clipit2
cliphome:
        move.w  d0,x1
        move.w  d1,y1
        move.w  d2,x2
        move.w  d3,y2
	bsr	myline
	movem.l	(sp)+,d0-d7/a0
	rts
clipb:
	movem.l	(sp)+,d0-d7/a0
	rts
*********************************************************
linecolor:
	blk.w	1,0
***********************************************
*	lets plot a fucking line
*	but lets do it fast
*	first some conventions
*	draws line on hiden screen
*	between x1,y1,x2,y2 
***********************************************
myline:
*	movem.l	d4-d7/a0,-(sp)
calcdx:
	move.w	x2,d0
	sub.w	x1,d0	;x2-x1
	move.w	d0,dx	;d0 is dx
	bpl	calcdy
	neg	d0
calcdy:
	move.w	y2,d1
	sub.w	y1,d1	;y2-y1	
	move.w	d1,dy	;d6 is dy
	bpl	cmparedxdy
	neg	d1
cmparedxdy:
	cmp.w	d0,d1
	bgt	ymajor	;if dy is greater then ymajor
xmajor:
*	tst.w	dy
*	beq	horizontal	;special case
	tst.w	dx
	bpl	noswapx
	move.w	x2,d0
	move.w	x1,x2
	move.w	d0,x1
	move.w	y2,d0
	move.w	y1,y2
	move.w	d0,y1
	neg	dx
	neg	dy
noswapx:
	moveq	#0,d0
	move.w	dx,d0
	divs	dy,d0
	bmi	xpositive

xnegative:
	move.l	hiden,a0	;screen ad
	move.w	dx,d0
	move.w	d0,d7	;counter is d7
	subq.w	#1,d7
	asr.w	#1,d0	;div by 2
	move.w	d0,d6	;dump is d6
	move.w	x1,d0	;will hold bitpattern
	move.w	d0,d2
	move.w	y1,d1
	lsl.w	#5,d1	;mult y by 128
	adda.w	d1,a0	;add it to screen address
	lsl.w	#2,d1	;mult by 32 makes mult by 160
	adda.w	d1,a0	;a0 now has start screen address
	and.w	#$fff0,d0	;mask off last 4 bits gives word across
	lsr.w	#1,d0
	add.w	d0,a0
	moveq	#0,d4
	tst.w	d7
	bmi	specxneg
xmnloop:
	addq.w	#1,d2
	move.w	d2,d3
	and.w	#15,d3
	bne	xmnla
	bsr	putlinein
	moveq	#0,d4
	addq.l	#8,a0
xmnla:	sub.w	#15,d3
	neg	d3
	bset	d3,d4
	sub.w	dy,d6	;sub dy from dump
	bpl	xmn
	add.w	dx,d6
	bsr	putlinein
	adda.l	#160,a0		;moveit to next line
	moveq	#0,d4
xmn:
	dbf	d7,xmnloop
specxneg:
	move.w	d2,d3
	and.w	#15,d3
	sub.w	#14,d3
	neg	d3
	bset	d3,d4
	bsr	putlinein
	rts

putlinein:
	move.w	d4,d5
	eor.w	#$ffff,d5
	and.w	d5,(a0)		;clearout old pixels
	and.w	d5,2(a0)
	and.w	d5,4(a0)
	and.w	d5,6(a0)
	move.w	linecolor,d5
plane1:
	btst	#0,d5
	beq	plane2
	or.w	d4,(a0)
plane2:
	btst	#1,d5
	beq	plane3
	or.w	d4,2(a0)
plane3:
	btst	#2,d5
	beq	plane4
	or.w	d4,4(a0)
plane4:
	btst	#3,d5
	beq	plane5
	or.w	d4,6(a0)
plane5:
	rts

xpositive:
	move.l	hiden,a0	;screen ad
	move.w	dx,d0
	move.w	d0,d7	;counter is d7
	subq.w	#1,d7
	asr.w	#1,d0	;div by 2
	move.w	d0,d6	;dump is d6
	move.w	x1,d0	;will hold bitpattern
	move.w	d0,d2
	move.w	y1,d1
	lsl.w	#5,d1	;mult y by 128
	adda.w	d1,a0	;add it to screen address
	lsl.w	#2,d1	;mult by 32 makes mult by 160
	add.w	d1,a0	;a0 now has start screen address
	and.w	#$fff0,d0	;mask off last 4 bits gives word across
	lsr.w	#1,d0
	add.w	d0,a0
	moveq	#0,d4
xmploop:
	addq.w	#1,d2
	move.w	d2,d3
	and.w	#15,d3
	bne	xmpla
	bsr	putlinein
	moveq	#0,d4
	addq.l	#8,a0
xmpla:	sub.w	#15,d3
	neg	d3
	bset	d3,d4
	add.w	dy,d6	;sub dy from dump
	bpl	xmp
	add.w	dx,d6
	bsr	putlinein
	moveq	#0,d4
	suba.l	#160,a0		;moveit to next line
xmp:
	dbf	d7,xmploop
	move.w	d2,d3
	and.w	#15,d3
	sub.w	#14,d3
	neg	d3
	bset	d3,d4
	bsr	putlinein
	rts

ymajor:
	tst.w	dy
	bpl	noswapy
	move.w	x2,d0
	move.w	x1,x2
	move.w	d0,x1
	move.w	y2,d0
	move.w	y1,y2
	move.w	d0,y1
	neg	dx
	neg	dy
noswapy:
	moveq	#0,d0
	move.w	dy,d0
	divs	dx,d0
	bmi	ypositive
ynegative:
	tst.w	dx
	beq	straightup1	;special case vertical line
	move.l	hiden,a0	;screen ad
	move.w	dy,d0
	move.w	d0,d7	;counter is d7
*	subq.w	#1,d7
	asr.w	#1,d0	;div by 2
	move.w	d0,d6	;dump is d6
	move.w	x1,d0	;will hold bitpattern
	move.w	d0,d3
	move.w	y1,d1
	move.w	d1,d2
	lsl.w	#5,d1	;mult y by 128
	adda.w	d1,a0	;add it to screen address
	lsl.w	#2,d1	;mult by 32 makes mult by 160
	add.w	d1,a0	;a0 now has start screen address
	and.w	#$fff0,d0	;mask off last 4 bits gives word across
	lsr.w	#1,d0
	add.w	d0,a0
	move.w	d3,d0	;x
	moveq	#0,d4
	move.w	d0,d3
	and.w	#15,d3
	move.w	#$8000,d4
	lsr.w	d3,d4
ymnloop:
	bsr	putlinein
	add.w	#160,a0	;y+1
	sub.w	dx,d6	;sub dy from dump
	bpl	ymn
	add.w	dy,d6
	addq.w	#1,d0	;x+1
	move.w	d0,d3
	and.w	#15,d3
	bne	ymnla
	addq.l	#8,a0
ymnla:	move.w	#$8000,d4
	lsr.w	d3,d4
ymn:
	dbf	d7,ymnloop
*	movem.l	(sp)+,d4-d7/a0
	rts

ypositive:
	tst.w	dx
	beq	straightup	;special case vertical line
	move.l	hiden,a0	;screen ad
	move.w	dy,d0
	move.w	d0,d7	;counter is d7
	subq.w	#1,d7
	asr.w	#1,d0	;div by 2
	move.w	d0,d6	;dump is d6
	move.w	x1,d0	;will hold bitpattern
	move.w	d0,d3
	move.w	y1,d1
	move.w	d1,d2
	lsl.w	#5,d1	;mult y by 128
	adda.w	d1,a0	;add it to screen address
	lsl.w	#2,d1	;mult by 32 makes mult by 160
	add.w	d1,a0	;a0 now has start screen address
	and.w	#$fff0,d0	;mask off last 4 bits gives word across
	lsr.w	#1,d0
	add.w	d0,a0
	move.w	d3,d0	;x
	moveq	#0,d4
*	move.w	d0,d3
	and.w	#15,d3
	move.w	#$8000,d4
	lsr.w	d3,d4

ymploop:
	bsr	putlinein
	add.w	#160,a0	;y+1
	add.w	dx,d6	;sub dy from dump
	bpl	ymp
	add.w	dy,d6
	subq.w	#1,d0	;x+1
	move.w	d0,d3
	and.w	#15,d3
	cmpi.w	#15,d3
	bne	ympla
	subq.l	#8,a0
ympla:	move.w	#$8000,d4
	lsr.w	d3,d4
ymp:
	dbf	d7,ymploop
*	movem.l	(sp)+,d4-d7/a0
	rts

straightup:
	move.l	hiden,a0	;screen ad
	move.w	dy,d7
	move.w	x1,d0	;will hold bitpattern
	move.w	d0,d3
	move.w	y1,d1
	lsl.w	#5,d1	;mult y by 128
	adda.w	d1,a0	;add it to screen address
	lsl.w	#2,d1	;mult by 32 makes mult by 160
	add.w	d1,a0	;a0 now has start screen address
	and.w	#$fff0,d0	;mask off last 4 bits gives word across
	lsr.w	#1,d0
	add.w	d0,a0	;now a0 is ready
	moveq	#0,d4
	and.w	#15,d3
	move.w	#$8000,d4
	lsr.w	d3,d4	;d4 has proper bit pattern
	add.l	#160,a0
stuploop:
	bsr	putlinein
	add.l	#160,a0
	dbf	d7,stuploop
*	movem.l	(sp)+,d4-d7/a0
	rts	

straightup1:
	move.l	hiden,a0	;screen ad
	move.w	dy,d7
	move.w	x1,d0	;will hold bitpattern
	move.w	d0,d3
	move.w	y1,d1
	lsl.w	#5,d1	;mult y by 128
	adda.w	d1,a0	;add it to screen address
	lsl.w	#2,d1	;mult by 32 makes mult by 160
	add.w	d1,a0	;a0 now has start screen address
	and.w	#$fff0,d0	;mask off last 4 bits gives word across
	lsr.w	#1,d0
	add.w	d0,a0	;now a0 is ready
	moveq	#0,d4
	and.w	#15,d3
	move.w	#$8000,d4
	lsr.w	d3,d4	;d4 has proper bit pattern
	add.l	#160,a0

stuploop1:
	bsr	putlinein
	sub.l	#160,a0
	dbf	d7,stuploop
*	movem.l	(sp)+,d4-d7/a0
	rts	


dump:	blk.w	1,0
gradient:	blk.w	1,0
x1:	blk.w	1,0
x2:	blk.w	1,0
y1:	blk.w	1,0
y2:	blk.w	1,0
dx:	blk.w	1,0
dy:	blk.w	1,0
plx:	dc.w	0
ply:	dc.w	0
plz:	dc.w	0
myviewx:	dc.w	0
myviewy:	dc.w	0
***************************************************************************
*		FIND SINE OF AN ANGLE
*		On entry, d3 = angle
*		On exit ,   d5 = cosine of angle 
*	Find the cosine of an angle. The value of the sign is a 16 bit
* signed number.
*	Note, to scale down, divide by 15 bits, ie &8000.
find_cos:
	move	d4,-(SP)	;Save SIN
	move	d3,-(SP)	;Save angle
	addi.w	#$40,d3		;Find COS of angle
	bsr	find_sin
	move	d4,d5
		
	move	(SP)+,d3	;Restore angle
	move	(SP)+,d4	;Restore SIN
		
	rts	

***************************************************************************
*		FIND THE SIN OF AN ANGLE
*		On entry, d3 = angle
*		On exit ,   d4 = SIN of angle
*	Find the SIN of an angle. The value of the sign is a 16 bit
* signed number.
*	Note, to scale down, divide by 15 bits, ie &8000.

find_sin:
	move	d3,-(SP)	;Save angle	

	and.l	#$7F,d3		;Move to quadrants 1 and 2
	btst	#6,d3		;Test if in 1st quadrant
	beq	quad0		;Branch if in 1st quadrant
	bclr	#6,d3		;Reflect angle into 1st quadrant
	subi.b	#$3F,d3
	neg.b	d3
		
quad0:	asl	#1,d3		;Get value of SIN from table
	lea.l	sin_vt,a6
	move	0(a6,d3),d4
		
	move	(SP)+,d3

	btst	#7,d3		;Adjust value if 3rd or 4th quadrant
	beq	quad1
	neg	d4		;Negate SIN value
		
quad1:	rts

***************************************************************************
*		SIN LOOK UP TABLE
*	This is the SIN value look up table. Values for the 1st quadrant
* are given only. The values range from 0 - 32758 for angles 0 - 63.
* Thus, the value of a sine in the 1st quadrant is a 15 bit number.
* Therefore, the table can be used to construct a 16 bit signed value of
* SIN for angles 0 - 255.

sin_vt:	dc.w	0,804,1608,2411
	dc.w	3212,4011,4808,5602
	dc.w	6393,7180,7962,8740
	dc.w	9512,10279,11039,11793
	dc.w	12540,13279,14010,14733
	dc.w	15447,16151,16846,17531
	dc.w	18205,18868,19520,20160
	dc.w	20788,21403,22006,22595
	dc.w	23170,23732,24279,24812
	dc.w	25330,25832,26320,26791
	dc.w	27246,27684,28106,28511
	dc.w	28899,29269,29622,29957
	dc.w	30274,30572,30853,31114
	dc.w	31357,31581,31786,31972
	dc.w	32138,32286,32413,32522
	dc.w	32610,32679,32729,32758

****************************************
keyboard:
        move.w  #$ff,-(sp)
        move.w  #6,-(sp)
        trap    #1
        addq.l  #4,sp
        tst.l   d0
        beq     keyback
        swap    d0
quit:   cmpi.w  #$10,d0
        bne     space
        bra     gem
space:
	cmpi.w	#$39,d0
	bne	up
	bra	pause
up:	cmpi.w	#$4e,d0
	bne	down
**	add.w	#1,expansion
	rts
down:	cmpi.w	#$4a,d0
	bne	keyback
*	sub.w	#1,expansion
	rts
keyback:rts

cldelay:	dc.w	-1
rcldelay:	dc.w	-0
wx:		dc.w	0
wy:		dc.w	0
wz:		dc.w	0
proz:		dc.w	0
*****************************
pause:  
        move.w  #$ff,-(sp)
        move.w  #6,-(sp)
        trap    #1
        addq.l  #4,sp
        tst.l   d0
        beq     pause
        swap    d0
        cmpi.w  #$1e,d0
        bne     keyback 
        bsr     gkey
        cmpi.w  #$32,d0
        bne     keyback
        bsr     gkey
        cmpi.w  #$1e,d0
        bne     keyback
        bsr     gkey
        cmpi.w  #$31,d0
        bne     keyback
        bsr     gkey
        cmpi.w  #$20,d0
        bne     keyback
        bsr     gkey
        cmpi.w  #$1e,d0
        bne     keyback
*	move.w	#1,cheat
	rts

gkey:
        move.w  #$ff,-(sp)
        move.w  #6,-(sp)
        trap    #1
        addq.l  #4,sp
        tst.l   d0
        beq     gkey
        swap    d0
        rts

***********************************
mydocolors:
	move.l	#$ff8240,a1
	moveq	#15,d0
mdcloop:
	move.w	(a0)+,(a1)+
	dbf	d0,mdcloop
	rts

rnd:	blk.l	5,0
*******************************************************************
randomseed:     ADD.L   D0,D1           ;user seed in d0 (d1 too)
                MOVEM.L D0/D1,RND
; drops through to the main random function (not user callable)
LongRnd:        MOVEM.L D2-D3,-(SP)     
                MOVEM.L RND,D0/D1       ;D0=LSB's, D1=MSB's of random number
                ANDI.B  #$0E,D0         ;ensure upper 59 bits are an...
                ORI.B   #$20,D0         ;...odd binary number
                MOVE.L  D0,D2
                MOVE.L  D1,D3
                ADD.L   D2,D2           ;accounts for 1 of 17 left shifts
                ADDX.L  D3,D3           ;[D2/D3] = RND*2
                ADD.L   D2,D0
                ADDX.L  D3,D1           ;[D0/D1] = RND*3
                SWAP    D3              ;shift [D2/D3] additional 16 times
                SWAP    D2
                MOVE.W  D2,D3
                CLR.W   D2
                ADD.L   D2,D0           ;add to [D0/D1]
                ADDX.L  D3,D1
                MOVEM.L D0/D1,RND       ;save for next time through
                MOVE.L  D1,D0           ;most random part to D0
                MOVEM.L (SP)+,D2-D3
                RTS
random:         MOVE.w  D2,-(SP)
                MOVE.W  D0,D2           ;save upper limit
                BEQ.S   r1              ;range of 0 returns 0 always
                BSR.S   LongRnd         ;get a longword random number
                CLR.W   D0              ;use upper word (it's most random)
                SWAP    D0
                ext.l   d0
                DIVs    D2,D0           ;divide by range...
                CLR.W   D0              ;...and use remainder for the value
                SWAP    D0              ;result in D0.W
r1:             MOVE.w  (SP)+,D2
                RTS

randomplus:     MOVE.w  D2,-(SP)
                MOVE.W  D0,D2           ;save upper limit
                BEQ.S   r2              ;range of 0 returns 0 always
                BSR.S   LongRnd         ;get a longword random number
                CLR.W   D0              ;use upper word (it's most random)
                SWAP    D0
                DIVu    D2,D0           ;divide by range...
                CLR.W   D0              ;...and use remainder for the value
                SWAP    D0              ;result in D0.W
r2:             MOVE.w  (SP)+,D2
                RTS
********************************
joydir:
	tst.b	joyport1
	beq	jdback
	move.b	joyport1,d0
	btst	#7,d0
	beq	northa
	move.w	#1,firebutton
	bclr	#7,d0
	bra	north
northa:	move.w	#-1,firebutton
north:	cmpi.b	#1,d0
	bne	neast
	move.w	#-nsamount,yvel
	move.w	#0,xvel
	rts
neast:	cmpi.b	#9,d0
	bne	east
	move.w	#-nsamount,yvel
	move.w	#nsamount,xvel
	add.w	#tiltamount,tilt
	rts
east:	cmpi.b	#8,d0
	bne	seast
	move.w	#nsamount,xvel
	move.w	#0,yvel
	add.w	#tiltamount,tilt
	rts
seast:	cmpi.b	#10,d0
	bne	south
	move.w	#nsamount,yvel
	move.w	#nsamount,xvel
	add.w	#tiltamount,tilt
	rts
south:	cmpi.b	#2,d0
	bne	swest
	move.w	#nsamount,yvel
	move.w	#0,xvel
	rts
swest:	cmpi.b	#6,d0
	bne	west
	move.w	#nsamount,yvel
	move.w	#-nsamount,xvel
	sub.w	#tiltamount,tilt
	rts
west:	cmpi.b	#4,d0
	bne	nwest
	move.w	#-nsamount,xvel
	move.w	#0,yvel
	sub.w	#tiltamount,tilt
	rts
nwest:	cmpi.b	#5,d0
	bne	jdback
	move.w	#-nsamount,yvel
	move.w	#-nsamount,xvel
	sub.w	#tiltamount,tilt
	rts
jdback:
	move.w	#0,xvel
	move.w	#0,yvel
	tst.w	tilt
	bmi	jdb2
	subq.w	#1,tilt
	rts
jdb2:
	addq.w	#1,tilt
	rts

tiltamount:	equ	0
nsamount:	equ	25
ewamount:	equ	25
firebutton:	blk.w	1,-1
*****************************************
*	set up joystick handler		*
*****************************************
joystuff:
	move.w	#34,-(sp)
	trap	#14
	addq.l	#2,sp
	move.l	d0,a0
	adda.l	#24,a0
	move.l	(a0),old_packh		;save the old handler
	move.l	#joy_packet,(a0)	;put in mine
	rts
*****************************************	
*	this is the joy pak handler	*
*****************************************
joy_packet:
	movem.l	a0/a1,-(sp)
	lea	joyport0,a1
	move.b	1(a0),(a1)
	move.b	2(a0),1(a1)
	movem.l	(sp)+,a0/a1
	rts

joyport0:	blk.b	1,0
joyport1:	blk.b	1,0
	even

res_mouse:
	move.w	#34,-(sp)
	trap	#14
	addq.l	#2,sp
	move.l	d0,a0
	adda.l	#24,a0
	move.l	old_packh,(a0)

rs2:	move.w	#128,-(sp)
	move.w	#4,-(sp)
	move.w	#3,-(sp)
	trap	#13
	addq.l	#6,sp

	move.w	#1,-(sp)
	move.w	#4,-(sp)
	move.w	#3,-(sp)
	trap	#13
	addq.l	#6,sp
	rts

old_packh:	blk.l	1,0
************get screen address***************
getscrn:move.w  #2,-(sp)
        trap    #14
        addq.l  #2,sp
        move.l  d0,screen
*	subi.l	#$9000,d0
        move.l  d0,screen1
        move.l  d0,screen2
        subi.l  #$8000,screen2
        move.l  screen1,seen
        move.l  screen2,hiden
	move.l	screen2,screen3
	subi.l	#$8000,screen3
	move.l	#ytable2,ytable
	move.l	#ytable1,sytable
	rts
screen1:	dc.l	0
screen2:	dc.l	0
screen3:	dc.l	0
seen:	dc.l	0
hiden:	dc.l	0
screen:	dc.l	0
********************************************
* Atari ST hi-speed plotting subroutine    *
* For Low-resolution mode only		   *
********************************************
plotinit:
	move.l	seen,a0		;screen addr in A0
	move.b	#200,d1		;200 Y positions
	lea	ytable1,a1	;y table address in A1

iloop:
	move.l	a0,(a1)+	;move address to table
	adda.w	#160,a0		;increment address
	subq.b	#1,d1		;1 less y position
	bne	iloop		;loop if there's more!

	move.l	hiden,a0	;screen addr in A0
	move.b	#200,d1		;200 Y positions
	lea	ytable2,a1	;y table address in A1

iloop2:
	move.l	a0,(a1)+	;move address to table
	adda.w	#160,a0		;increment address
	subq.b	#1,d1		;1 less y position
	bne	iloop2		;loop if there's more!
	rts

pixelx:	blk.w	1,0
pixely:	blk.w	1,0
pixelcolor:
	blk.w	1,0
ytable1:	blk.l	200,0
ytable2:	blk.l	200,0
ytable:		blk.l	1,0
sytable:	blk.l	1,0
**********************************************
putcoords:
	move.w	pixelx,(a0)+
	move.w	pixely,(a0)+
	rts
singleplot:
	movem.l	d0-d5/a0-a1,-(sp)
	move.w	pixelx,d0      ;x coordinate in D0
	cmp.w	#cxmax,d0
	bgt	pltxit
	cmpi.w	#cxmin,d0
	blt	pltxit
	move.w	d0,d3         ;duplicate in D3
	andi.w	#15,d3        ;mask off lower 4 bits
	move.w	pixely,d1      ;get y coordinate,
	cmp.w	#cymax,d1
	bgt	pltxit
	cmpi.w	#cymin,d1
	blt	pltxit
	lsl.w	#2,d1          ;mult by 4 for index
	move.w	pixelcolor,d2      ;get color number

	lsr.w	#1,d0             ;x coord / 2
	and.w	#$00f8,d0      ;strip lower 3 bits
	move.w	d0,a0        ;move x offset to A0
	move.l	ytable,a1   ;get y table addr
	adda.l	(a1,d1.w),a0 ;got final pixel addr!

	move.w #$8000,d4     ;set ON pixel mask
	lsr.w d3,d4          ;shift right D3 times
	move.l #$80008000,d5 ;set OFF pixel mask
	lsr.l d3,d5          ;shift right D3 times
	eor.l #$ffffffff,d5  ;toggle all bits in D5
	bra	myphere

**************************************
* PLOT A PIXEL WITH MY ROUTINE       *
*                                    *
* CALL WITH:                         *
* myplot(X,Y,COLOR)                  *
**************************************
doubleplot:
	movem.l	d0-d5/a0-a1,-(sp)
	move.w	pixelx,d0      ;x coordinate in D0
	cmp.w	#cxmax-1,d0
	bcc	pltxit
	cmpi.w	#cxmin+1,d0
	blt	pltxit
	move.w	d0,d3         ;duplicate in D3
	andi.w	#15,d3        ;mask off lower 4 bits
	move.w	pixely,d1      ;get y coordinate,
	cmp.w	#cymax,d1
	bgt	pltxit
	cmpi.w	#cymin,d1
	blt	pltxit
	lsl.w	#2,d1          ;mult by 4 for index
	move.w	pixelcolor,d2      ;get color number

	lsr.w	#1,d0             ;x coord / 2
	and.w	#$00f8,d0      ;strip lower 3 bits
	move.w	d0,a0        ;move x offset to A0
	move.l	ytable,a1   ;get y table addr
	adda.l	(a1,d1.w),a0 ;got final pixel addr!
	cmpi.w	#15,d3
	beq	singlepix
	move.w	#$c000,d4     ;set ON pixel mask
	lsr.w	d3,d4          ;shift right D3 times
	move.l	#$c000c000,d5 ;set OFF pixel mask
	lsr.l	d3,d5          ;shift right D3 times
	eor.l	#$ffffffff,d5  ;toggle all bits in D5
	bra	myphere

singlepix:
	move.w #$8000,d4     ;set ON pixel mask
	lsr.w d3,d4          ;shift right D3 times
	move.l #$80008000,d5 ;set OFF pixel mask
	lsr.l d3,d5          ;shift right D3 times
	eor.l #$ffffffff,d5  ;toggle all bits in D5
	and.l d5,(a0)        ;turn off old pixel
	and.l d5,4(a0)       ;(both longwords)
spec2:
	btst #0,d2           ;set the bit?
	beq bbit2             ;no!
	or.w d4,(a0)         ;turn it on!
bbit2:
	btst #1,d2           ;set it?
	beq bbit4             ;no!
	or.w d4,2(a0)        ;turn it on!
bbit4:
	btst #2,d2           ;set bit?
	beq bbit8             ;no!
	or.w d4,4(a0)        ;turn it on!
bbit8:
	btst #3,d2           ;set bit?
	beq mysec           ;no, exit.
	or.w d4,6(a0)        ;turn it on!

mysec:
	addq.l	#8,a0
	move.w #$8000,d4     ;set ON pixel mask
	move.l #$80008000,d5 ;set OFF pixel mask
	eor.l #$ffffffff,d5  ;toggle all bits in D5
******************************
*    Turn off old pixel!     *
******************************
myphere:
	and.l d5,(a0)        ;turn off old pixel
	and.l d5,4(a0)       ;(both longwords)

******************************
* Now turn on the new pixel! *
******************************
	btst #0,d2           ;set the bit?
	beq bit2             ;no!
	or.w d4,(a0)         ;turn it on!
bit2:
	btst #1,d2           ;set it?
	beq bit4             ;no!
	or.w d4,2(a0)        ;turn it on!
bit4:
	btst #2,d2           ;set bit?
	beq bit8             ;no!
	or.w d4,4(a0)        ;turn it on!
bit8:
	btst #3,d2           ;set bit?
	beq pltxit           ;no, exit.
	or.w d4,6(a0)        ;turn it on!
pltxit:
	movem.l	(sp)+,d0-d5/a0-a1
	rts                  ;bye!

*************************************
clearquick:
	move.l	hiden,a0
	adda.l	#2088,a0
	move	#109,d0
	move.l	#$ffff0000,d7
	moveq	#0,d6
cl2loop:
	move.l	d7,(a0)+
	move.l	d6,(a0)+
	move.l	d7,(a0)+
	move.l	d6,(a0)+
	move.l	d7,(a0)+
	move.l	d6,(a0)+
	move.l	d7,(a0)+
	move.l	d6,(a0)+
	move.l	d7,(a0)+
	move.l	d6,(a0)+
	move.l	d7,(a0)+
	move.l	d6,(a0)+
	move.l	d7,(a0)+
	move.l	d6,(a0)+
	move.l	d7,(a0)+
	move.l	d6,(a0)+
	move.l	d7,(a0)+
	move.l	d6,(a0)+
	move.l	d7,(a0)+
	move.l	d6,(a0)+
	move.l	d7,(a0)+
	move.l	d6,(a0)+
	move.l	d7,(a0)+
	move.l	d6,(a0)+
	move.l	d7,(a0)+
	move.l	d6,(a0)+
	move.l	d7,(a0)+
	move.l	d6,(a0)+
	move.l	d7,(a0)+
	move.l	d6,(a0)+
	move.l	d7,(a0)+
	move.l	d6,(a0)+
	move.l	d7,(a0)+
	move.l	d6,(a0)+
	move.l	d7,(a0)+
	move.l	d6,(a0)+
	add.l	#16,a0
	dbf	d0,cl2loop
cqb:	rts

copyplanet:
	lea	planetmem,a0
	move.l	hiden,a1
	adda.l	#2088,a1
	moveq	#20,d0		;number of lines to copy
	moveq	#0,d1		;amount to add to a0(ie number of lines
	bsr	copyplanetline	;to skip)
	moveq	#10,d0
	move.w	#144,d1
	bsr	copyplanetline
	moveq	#5,d0
	move.w	#144*2,d1
	bsr	copyplanetline
	moveq	#3,d0
	move.w	#144*3,d1
	bsr	copyplanetline
	moveq	#2,d0
	move.w	#144*4,d1
	bsr	copyplanetline
	moveq	#1,d0
	move.w	#144*5,d1
	bsr	copyplanetline
	bra	doover
copyplanetline:
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	add.w	d1,a0
	addi.l	#16,a1
	dbf	d0,copyplanetline
	rts
*****************************************
*  Now we put the curvy bit over it	*
*****************************************
doover:
	lea	planetoverlay,a0
	lea	planetmask,a1
	move.l	hiden,a2
	add.l	#8808,a2
	moveq	#12,d7
overlay:
	move.w	(a1)+,d0
	eor.w	#-1,d0
	move.w	(a2),d1
	move.w	2(a2),d2
	move.w	4(a2),d3
	move.w	6(a2),d4
	and.w	d0,d1
	and.w	d0,d2
	and.w	d0,d3
	and.w	d0,d4
	or.w	(a0)+,d1
	or.w	(a0)+,d2
	or.w	(a0)+,d3
	or.w	(a0)+,d4
	move.w	d1,(a2)+
	move.w	d2,(a2)+
	move.w	d3,(a2)+
	move.w	d4,(a2)+
	move.w	(a1)+,d0
	eor.w	#-1,d0
	move.w	(a2),d1
	move.w	2(a2),d2
	move.w	4(a2),d3
	move.w	6(a2),d4
	and.w	d0,d1
	and.w	d0,d2
	and.w	d0,d3
	and.w	d0,d4
	or.w	(a0)+,d1
	or.w	(a0)+,d2
	or.w	(a0)+,d3
	or.w	(a0)+,d4
	move.w	d1,(a2)+
	move.w	d2,(a2)+
	move.w	d3,(a2)+
	move.w	d4,(a2)+
	move.w	(a1)+,d0
	eor.w	#-1,d0
	move.w	(a2),d1
	move.w	2(a2),d2
	move.w	4(a2),d3
	move.w	6(a2),d4
	and.w	d0,d1
	and.w	d0,d2
	and.w	d0,d3
	and.w	d0,d4
	or.w	(a0)+,d1
	or.w	(a0)+,d2
	or.w	(a0)+,d3
	or.w	(a0)+,d4
	move.w	d1,(a2)+
	move.w	d2,(a2)+
	move.w	d3,(a2)+
	move.w	d4,(a2)+
	move.w	(a1)+,d0
	eor.w	#-1,d0
	move.w	(a2),d1
	move.w	2(a2),d2
	move.w	4(a2),d3
	move.w	6(a2),d4
	and.w	d0,d1
	and.w	d0,d2
	and.w	d0,d3
	and.w	d0,d4
	or.w	(a0)+,d1
	or.w	(a0)+,d2
	or.w	(a0)+,d3
	or.w	(a0)+,d4
	move.w	d1,(a2)+
	move.w	d2,(a2)+
	move.w	d3,(a2)+
	move.w	d4,(a2)+
	move.w	(a1)+,d0
	eor.w	#-1,d0
	move.w	(a2),d1
	move.w	2(a2),d2
	move.w	4(a2),d3
	move.w	6(a2),d4
	and.w	d0,d1
	and.w	d0,d2
	and.w	d0,d3
	and.w	d0,d4
	or.w	(a0)+,d1
	or.w	(a0)+,d2
	or.w	(a0)+,d3
	or.w	(a0)+,d4
	move.w	d1,(a2)+
	move.w	d2,(a2)+
	move.w	d3,(a2)+
	move.w	d4,(a2)+
	move.w	(a1)+,d0
	eor.w	#-1,d0
	move.w	(a2),d1
	move.w	2(a2),d2
	move.w	4(a2),d3
	move.w	6(a2),d4
	and.w	d0,d1
	and.w	d0,d2
	and.w	d0,d3
	and.w	d0,d4
	or.w	(a0)+,d1
	or.w	(a0)+,d2
	or.w	(a0)+,d3
	or.w	(a0)+,d4
	move.w	d1,(a2)+
	move.w	d2,(a2)+
	move.w	d3,(a2)+
	move.w	d4,(a2)+
	move.w	(a1)+,d0
	eor.w	#-1,d0
	move.w	(a2),d1
	move.w	2(a2),d2
	move.w	4(a2),d3
	move.w	6(a2),d4
	and.w	d0,d1
	and.w	d0,d2
	and.w	d0,d3
	and.w	d0,d4
	or.w	(a0)+,d1
	or.w	(a0)+,d2
	or.w	(a0)+,d3
	or.w	(a0)+,d4
	move.w	d1,(a2)+
	move.w	d2,(a2)+
	move.w	d3,(a2)+
	move.w	d4,(a2)+
	move.w	(a1)+,d0
	eor.w	#-1,d0
	move.w	(a2),d1
	move.w	2(a2),d2
	move.w	4(a2),d3
	move.w	6(a2),d4
	and.w	d0,d1
	and.w	d0,d2
	and.w	d0,d3
	and.w	d0,d4
	or.w	(a0)+,d1
	or.w	(a0)+,d2
	or.w	(a0)+,d3
	or.w	(a0)+,d4
	move.w	d1,(a2)+
	move.w	d2,(a2)+
	move.w	d3,(a2)+
	move.w	d4,(a2)+
	move.w	(a1)+,d0
	eor.w	#-1,d0
	move.w	(a2),d1
	move.w	2(a2),d2
	move.w	4(a2),d3
	move.w	6(a2),d4
	and.w	d0,d1
	and.w	d0,d2
	and.w	d0,d3
	and.w	d0,d4
	or.w	(a0)+,d1
	or.w	(a0)+,d2
	or.w	(a0)+,d3
	or.w	(a0)+,d4
	move.w	d1,(a2)+
	move.w	d2,(a2)+
	move.w	d3,(a2)+
	move.w	d4,(a2)+
	move.w	(a1)+,d0
	eor.w	#-1,d0
	move.w	(a2),d1
	move.w	2(a2),d2
	move.w	4(a2),d3
	move.w	6(a2),d4
	and.w	d0,d1
	and.w	d0,d2
	and.w	d0,d3
	and.w	d0,d4
	or.w	(a0)+,d1
	or.w	(a0)+,d2
	or.w	(a0)+,d3
	or.w	(a0)+,d4
	move.w	d1,(a2)+
	move.w	d2,(a2)+
	move.w	d3,(a2)+
	move.w	d4,(a2)+
	move.w	(a1)+,d0
	eor.w	#-1,d0
	move.w	(a2),d1
	move.w	2(a2),d2
	move.w	4(a2),d3
	move.w	6(a2),d4
	and.w	d0,d1
	and.w	d0,d2
	and.w	d0,d3
	and.w	d0,d4
	or.w	(a0)+,d1
	or.w	(a0)+,d2
	or.w	(a0)+,d3
	or.w	(a0)+,d4
	move.w	d1,(a2)+
	move.w	d2,(a2)+
	move.w	d3,(a2)+
	move.w	d4,(a2)+
	move.w	(a1)+,d0
	eor.w	#-1,d0
	move.w	(a2),d1
	move.w	2(a2),d2
	move.w	4(a2),d3
	move.w	6(a2),d4
	and.w	d0,d1
	and.w	d0,d2
	and.w	d0,d3
	and.w	d0,d4
	or.w	(a0)+,d1
	or.w	(a0)+,d2
	or.w	(a0)+,d3
	or.w	(a0)+,d4
	move.w	d1,(a2)+
	move.w	d2,(a2)+
	move.w	d3,(a2)+
	move.w	d4,(a2)+
	move.w	(a1)+,d0
	eor.w	#-1,d0
	move.w	(a2),d1
	move.w	2(a2),d2
	move.w	4(a2),d3
	move.w	6(a2),d4
	and.w	d0,d1
	and.w	d0,d2
	and.w	d0,d3
	and.w	d0,d4
	or.w	(a0)+,d1
	or.w	(a0)+,d2
	or.w	(a0)+,d3
	or.w	(a0)+,d4
	move.w	d1,(a2)+
	move.w	d2,(a2)+
	move.w	d3,(a2)+
	move.w	d4,(a2)+
	move.w	(a1)+,d0
	eor.w	#-1,d0
	move.w	(a2),d1
	move.w	2(a2),d2
	move.w	4(a2),d3
	move.w	6(a2),d4
	and.w	d0,d1
	and.w	d0,d2
	and.w	d0,d3
	and.w	d0,d4
	or.w	(a0)+,d1
	or.w	(a0)+,d2
	or.w	(a0)+,d3
	or.w	(a0)+,d4
	move.w	d1,(a2)+
	move.w	d2,(a2)+
	move.w	d3,(a2)+
	move.w	d4,(a2)+
	move.w	(a1)+,d0
	eor.w	#-1,d0
	move.w	(a2),d1
	move.w	2(a2),d2
	move.w	4(a2),d3
	move.w	6(a2),d4
	and.w	d0,d1
	and.w	d0,d2
	and.w	d0,d3
	and.w	d0,d4
	or.w	(a0)+,d1
	or.w	(a0)+,d2
	or.w	(a0)+,d3
	or.w	(a0)+,d4
	move.w	d1,(a2)+
	move.w	d2,(a2)+
	move.w	d3,(a2)+
	move.w	d4,(a2)+
	move.w	(a1)+,d0
	eor.w	#-1,d0
	move.w	(a2),d1
	move.w	2(a2),d2
	move.w	4(a2),d3
	move.w	6(a2),d4
	and.w	d0,d1
	and.w	d0,d2
	and.w	d0,d3
	and.w	d0,d4
	or.w	(a0)+,d1
	or.w	(a0)+,d2
	or.w	(a0)+,d3
	or.w	(a0)+,d4
	move.w	d1,(a2)+
	move.w	d2,(a2)+
	move.w	d3,(a2)+
	move.w	d4,(a2)+
	move.w	(a1)+,d0
	eor.w	#-1,d0
	move.w	(a2),d1
	move.w	2(a2),d2
	move.w	4(a2),d3
	move.w	6(a2),d4
	and.w	d0,d1
	and.w	d0,d2
	and.w	d0,d3
	and.w	d0,d4
	or.w	(a0)+,d1
	or.w	(a0)+,d2
	or.w	(a0)+,d3
	or.w	(a0)+,d4
	move.w	d1,(a2)+
	move.w	d2,(a2)+
	move.w	d3,(a2)+
	move.w	d4,(a2)+
	move.w	(a1)+,d0
	eor.w	#-1,d0
	move.w	(a2),d1
	move.w	2(a2),d2
	move.w	4(a2),d3
	move.w	6(a2),d4
	and.w	d0,d1
	and.w	d0,d2
	and.w	d0,d3
	and.w	d0,d4
	or.w	(a0)+,d1
	or.w	(a0)+,d2
	or.w	(a0)+,d3
	or.w	(a0)+,d4
	move.w	d1,(a2)+
	move.w	d2,(a2)+
	move.w	d3,(a2)+
	move.w	d4,(a2)+
	addi.l	#16,a2
	dbf	d7,overlay
	rts

beamer:
	move.l	#$ff8205,a0
	moveq	#0,d0
	move.b	(a0),d0
	asl.l	#8,d0
	adda.w	#2,a0
	move.b	(a0),d0
	asl.l	#8,d0
	adda.w	#2,a0
	move.b	(a0),d0
	move.l	d0,a0
	move.w	#0,(a0)
	rts
flip_scr:
	move.l	seen,d1
	move.l	d1,d2
	add.l	#4000,d1
	add.l	#18000,d2
skloop:
	move.l	#$ff8205,a0
	moveq	#0,d0
	move.b	(a0),d0
	asl.l	#8,d0
	addq.l	#2,a0
	move.b	(a0),d0
	asl.l	#8,d0
	addq.l	#2,a0
	move.b	(a0),d0
	cmp.l	d1,d0
	blt.s	skloop
	cmp.l	d2,d0
	bgt.s	skloop
        move.l  seen,A6
        move.l  hiden,seen
        move.l  A6,hiden
        move.l  sytable,A6
        move.l  ytable,sytable
        move.l  A6,ytable
	bsr	copyplanet
	move.b	seen+1,$ff8201
	move.b	seen+2,$ff8203
	addq.w	#1,frames
	rts


flip_scr3:
	move.l	seen,d1
	move.l	d1,d2
	add.l	#4000,d1
	add.l	#18000,d2
skloop3:
	move.l	#$ff8205,a0
	moveq	#0,d0
	move.b	(a0),d0
	asl.l	#8,d0
	addq.l	#2,a0
	move.b	(a0),d0
	asl.l	#8,d0
	addq.l	#2,a0
	move.b	(a0),d0
	cmp.l	d1,d0
	blt.s	skloop3
	cmp.l	d2,d0
	bgt.s	skloop3

        move.l  seen,A6
        move.l  hiden,seen
        move.l  A6,hiden
        move.l  sytable,A6
        move.l  ytable,sytable
        move.l  A6,ytable
	move.b	seen+1,$ff8201
	move.b	seen+2,$ff8203
	addq.w	#1,frames
	rts

framevbl:
	move.w	framess,number
	move.w	#29600,numwhere
	bsr	prtnum
	addq.w	#1,numvbl
	cmpi.w	#50,numvbl
	blt	fvblback
	move.w	frames,framess
	move.w	#0,numvbl
	move.w	#0,frames
fvblback:
	lea	bluepalette,a0
*	bsr	mydocolors
*	bsr	dovblcolors
*	bsr	flashcursor
	rts

stch:
	move.w	buttondat,d0
	cmp.w	lastb,d0
	beq	nochange
	move.w	#-1,changestate
	move.w	d0,lastb
	rts
nochange:
	move.w	#1,changestate
	rts

changestate:	dc.w	-1

cfdelay:	dc.w	0
cursorsave:	dc.b	92
even

numvbl:		dc.w	0
frames:		dc.w	0
framess:		dc.w	0
*****************************************
*	load a1 with routine address	*
*****************************************
vbl_list=$4ce
prt_cnt=$4ee
putvbl:
	move.l	#vbl_list,a0	; put start of vbl queue in a0
scanq:
	tst.l	(a0)		; current queue entry empty?
	beq.s	newvbl		; yes, install new vbl routine
	addq.l	#4,a0		; no, check next entry
	bra.s	scanq		; loop back

newvbl:
	move.l	a1,(a0)		; install routine in queue
	rts

oldvbl1:	dc.l	0
*****************************************
prtnum: 
	movem.l	d0/d6/d7/a0/a5/a1,-(sp)
	move.w	#10,d0
	move.l	seen,a0
	adda.w	numwhere,a0
pcl:
	move.l	#0,(a0)+
	move.l	#0,(a0)+
	move.l	#0,(a0)+
	move.l	#0,(a0)+
	move.l	#0,(a0)+
	move.l	#0,(a0)+
	add.l	#136,a0
	dbf	d0,pcl

	move.w	#0,times
        moveq  	#0,d7
        move.w  number,d7
        andi.l  #$ffff,d7
        lea	lineout,a5
dodec2:
	move.l  d7,d6
        divu    #10,d6
        move.w  d6,d7
        swap    d6
        move.b  d6,(a5)+
        cmpi.w  #0,d7
        bne     dodec2
out2:
	cmpa.l  #lineout,a5
        beq     decback2
        move.b  -(a5),d7
        andi.w  #$ff,d7
	lea	smallnumbers,a0
	mulu	#28,d7
	add.w	d7,a0
	moveq	#6,d0
	move.l	seen,a1
	adda.w	numwhere,a1
oloop2:
	move.b	(a0)+,(a1)
	move.b	(a0)+,2(a1)
	move.b	(a0)+,4(a1)
	move.b	(a0)+,6(a1)
	add.l	#160,a1
	dbf	d0,oloop2
	addq.w	#1,times
	cmpi.w	#2,times
	blt	oh2
	move.w	#0,times
	addq.w	#6,numwhere
oh2:	addq.w	#1,numwhere
	bra	out2
decback2:
	movem.l	(sp)+,d0/d6/d7/a0/a5/a1
	rts


safe:	dc.w	0
lineout:	blk.l	5
times:		dc.w	0
number:		dc.w	0
numwhere:	dc.w	0
******************************************
*               RETURN TO GEM
gem:
*	bsr	restoremfp
	move.b	#%11111110,$ff820a
	move.w	#$0777,$ff8240
	move.w	#$0000,$ff8242
	move.w	#$0000,$ff8244
	move.w	#$0000,$ff8246

	move.w	#0,$452
	move.l	oldvbl1,a0
	move.l	#0,(a0)
	move.w	#1,$452

	jsr	res_mouse
        move.b  #7,$484

	move.w  #34,-(sp)
        trap    #14
        addq.l  #2,sp
        move.l  d0,a0
	move.l	oldmouse,16(a0)

        move.w  ressave,-(sp)
        move.l  screen,-(sp)
        move.l  screen,-(sp)
        move.w  #5,-(sp)
        trap    #14
        addi.l  #12,sp

	move.l	rvsave,$426
	move.l	resave,$42a
        
        move.l  savesup,-(SP)    ;Back to user mode
        move.w  #$20,-(SP)
        trap    #1
        addq.l  #6,(SP)
illegal

rvsave:	dc.l	0
resave:	dc.l	0

*********************************************************
*	my routines for loading in the screens		*
*********************************************************
loadscr:
	move	#0,-(SP)	;Open file
	move.l	filename,-(SP) ;Address of filename
	move	#$3D,-(SP)
	trap	#1		;Get handle number in D0
	addq.l	#8,SP
	tst.w	d0
	bmi	nofile
		

	move.l	hiden,-(SP)    ;load it straight onto screen
	move.l	#32000,-(SP)		;length to read in
	move	D0,-(SP)	;Handle
	move	#$3F,-(SP)	;bios number
	trap	#1		;Read file in
	addi.l	 #12,SP

	move	#$3E,-(SP)	;Handle already on stack
	trap	#1		;Close file
	addq.l	#2,SP

	move.l	hiden,a0
	move.l	a0,a1
stl:
	move.b	(a1)+,d0
	bne	stl
	move.l	screen3,a2	;where to put it
decom:
	move.l	a2,a3		; a3 sauvegarde debut ecran
	moveq	#39,d0		; d0 indice des colonnes = 40 passages
	move.l	#199,d1 	; d1 indice des lignes	 = 200 passages
	sub.l	d2,d2		; d2 est remis a zero ...
	move.b	(a0)+,d2	; on prend le premier compteur
	subq.l	#1,d2		; decrement du compteur pour dbra
	move.b	(a1)+,d3
	lsl.l	#8,d3
	move.b	(a1)+,d3
	lsl.l	#8,d3
	move.b	(a1)+,d3
	lsl.l	#8,d3
	move.b	(a1)+,d3
	moveq	#4,d7
boucle:
	move.l	d3,(a2) 	; qu'on bazarde a l'ecran
	dbra	d2,encore	; test et decrement du compteur
	sub.l	d2,d2		; remise a zero du compteur
	move.b	(a0)+,d2	; si le compteur = 0 on rechoppe de 
	subq.l	#1,d2		; decrement de d2 (pour faire un dbra)
	move.b	(a1)+,d3
	lsl.l	#8,d3
	move.b	(a1)+,d3
	lsl.l	#8,d3
	move.b	(a1)+,d3
	lsl.l	#8,d3
	move.b	(a1)+,d3
encore:
	lea	160(a2),a2
	dbra	d1,boucle	; test pour voir si on est en bas
	adda.l	d7,a3		; un long plus loin
	move.l	a3,a2
	move.l	#199,d1 	; et c'est parti pour une nouvelle colonne
	dbra	d0,boucle
nofile:
	rts

length:		dc.w	0
*********************************************************
*       my routines for loading in the screens          *
*********************************************************
loadplan:
	move    #0,-(SP)        ;Open file
        move.l  filename,-(SP) ;Address of filename
        move    #$3D,-(SP)
        trap    #1              ;Get handle number in D0
        addq.l  #8,SP
	tst.w	d0
	ble	nogo
	move.w	d0,-(sp)

	move.l  #planetmem2,-(SP)    ;load it straight onto screen
        move.l  #14400,-(SP)    	;length to read in
        move    D0,-(SP)        ;Handle
        move    #$3F,-(SP)      ;bios number
        trap    #1              ;Read file in
        addi.l   #12,SP

        move    #$3E,-(SP)      ;Handle already on stack
        trap    #1              ;Close file
        addq.l  #4,SP
	rts
nogo:
	rts

****************************************
oldmouse:	blk.l	1,0
*************puts my mouse interupt in***************** 
putrout:move.w  #34,-(sp)
        trap    #14
        addq.l  #2,sp
        move.l  d0,a0
	move.l	16(a0),oldmouse
        move.l  #myrout,16(a0)
        rts

lastb:		dc.w	-1
**************my ubeut mouse interupt*******************
myrout:
	movem.l	d0-d2/a0-a1,-(sp)
	moveq	#0,d0	
	move.b	(a0),d0
	cmpi.b	#$fa,d0
	bne	myr1
	move.w	#1,buttondat
	bra	myrxy
myr1:
	cmpi.b	#$f9,d0
	bne	myr2
	move.w	#2,buttondat
	bra	myrxy
myr2:
	cmpi.b	#$fb,d0
	bne	myr3
	move.w	#3,buttondat
	bra	myrxy
myr3:
	move.w	#0,buttondat

myrxy:
	moveq	#0,d0
	move.b	1(a0),d0
	ext.w	d0
	moveq	#0,d1
	move.b	2(a0),d1
	ext.w	d1
	add.w	d0,mx
	add.w	d1,my
myr4:	move.w	mx,d0
	move.w	my,d1
	bsr	extra
	move.w	d0,mx
	move.w	d1,my
	movem.l	(sp)+,d0-d2/a0-a1
	rts

extra:  cmpi.w	#mminx,d0
        bge    .S extra1
        move.w	#mminx,d0
        bra    .S extra2
extra1: cmpi.w   #mmaxx,d0
        ble    .S extra2
        move.w  #mmaxx,d0
extra2:	cmpi.w  #mminy,d1
        bge    .S extra3
        move.w  #mminy,d1
        bra	extra4
extra3: cmpi.w   #mmaxy,d1
        ble    .S extra4
        move.w  #mmaxy,d1
extra4:
        rts

buttondat:	dc.w	0
mx:		dc.w	0
my:		dc.w	0

mminx:	equ	-0
mmaxx:	equ	300
mminy:	equ	-0
mmaxy:	equ	200
*****************************************
*	Example of sprite structure	*
*****************************************
*twishadsp:
*	dc.w	86,77		;x,y
*	dc.w	48,9		;h,w
*	dc.w	72
*	dc.l	twishad
pointersp:
	dc.w	0,0
	dc.w	14,0
	dc.w	144
	dc.l	pointer
	dc.l	gtemp		;last address
	dc.l	gsave
ship1sp:
	dc.w	0,0
	dc.w	6,1
	dc.w	136
*	dc.l	ship1data
	dc.l	gtemp		;last address
	dc.l	gsave

*********************************************************
*	New sprite routine				*
*	New version give ad of sprite structure in A0	*
*********************************************************
putsprite:
	bra	here
	move.w	8(a0),d2
	move.w	4(a0),d0	;height
	move.l	14(a0),a1	;last ad
	move.l	18(a0),a2	;saved background
sbloopa:
	move.w	6(a0),d1	;width
	addq.w	#1,d1
sbloopab:
	move.l	(a2)+,(a1)+
	move.l	(a2)+,(a1)+
	dbf	d1,sbloopab
	add.w	d2,a1
	dbf	d0,sbloopa

here:	move.w	(a0),d2		;get x
	move.w	d2,d0
	move.w	2(a0),d1	;get y
	and.w	#15,d2		;get last 4 bits=offset
	move.l	seen,a6
	lsl.w	#5,d1		;*128
	add.w	d1,a6
	lsl.w	#2,d1
	add.w	d1,a6		;=*160 gives line add
	and.w	#$fff0,d0	;word
	lsr.w	#1,d0
	add.w	d0,a6		;a6 has actual screen address
	move.l	a6,a2
	bra	h2
saveback:
	move.w	8(a0),d3
	move.w	4(a0),d0	;height
	move.l	18(a0),a1	;save place
sbloop:
	move.w	6(a0),d1	;width
	addq.w	#1,d1
sbloopb:
	move.l	(a2)+,(a1)+
	move.l	(a2)+,(a1)+
	dbf	d1,sbloopb
	add.w	d3,a2
	dbf	d0,sbloop
	move.l	a6,14(a0)
h2:
*************CODE TO ROTATE A SPRITE IMAGE***********************
shiftimages:
        move.w  4(a0),d1        ;height in d1
        move.l  10(a0),a1        ;object pointer to a0
	lea	gtemp,a2       ;image pointer to a1
ssi1:
        move.w  6(a0),d0       	;width - 1 = width if count starts at zero
        clr.l   (a2)            ;for each line, the first word of the
        clr.l   4(a2)           ;image must be cleared
ssi0:	
	moveq	#0,d4		;make sure that the top halves of these
	moveq	#0,d5		;registers are zeroed out
	moveq	#0,d6		;registers are zeroed out
	moveq	#0,d7		;registers are zeroed out
        move.w  (a1)+,d4        ;load in one word (four planes)
        move.w  (a1)+,d5        ;to be rotated
        move.w  (a1)+,d6
        move.w  (a1)+,d7
        ror.l   d2,d4           ;rotate all planes by the offset(d2)
        ror.l   d2,d5
        ror.l   d2,d6
        ror.l   d2,d7
        or.w    d4,(a2)+        ;add low order bits to the high order bits
        or.w    d5,(a2)+        ;stored by move instructions farther
        or.w    d6,(a2)+        ;down in this routine
        or.w    d7,(a2)+
        swap    d4              ;move high order bits into lower halves
        swap    d5              ;of the registers
        swap    d6
        swap    d7
        move.w  d4,(a2)         ;save the high orders bits to be ORed
        move.w  d5,2(a2)        ;in the loop (do not increment a1 because
        move.w  d6,4(a2)        ;the ORs in the loop must function on
        move.w  d7,6(a2)        ;the same addresses as these moves.
        dbf     d0,ssi0          ;repeat width times
        addq.l  #8,a2           ;new line, move to next word( * 4 planes = 8)
        dbf     d1,ssi1          ;repeat height times

smake_mask:
	move.w  4(a0),d1	;height in d1
	lea	gtemp,a1	;image pointer to a0
	lea	gmask,a2	;mask pointer to a1
smm1:
	move.w  6(a0),d0	;width in d0
	addq.w	#1,d0
smm0:	move.w  (a1)+,d2        ;load first plane of bit image in d2
        or.w    (a1)+,d2        ;OR it with the 3 other planes
        or.w    (a1)+,d2
        or.w    (a1)+,d2
        move.w  d2,d3           ;store inverse mask in d3 (temporary)
        swap    d2              ;move inverse mask to top half of register
        move.w  d3,d2           ;and also in bottom half
        eor.l   #-1,d2          ;mask no longer inverse
        move.l  d2,(a2)+        ;store mask in buffer
        dbf     d0,smm0          ;repeat 'width' times
        dbf     d1,smm1          ;repeat 'height' times

*********code to put sprite on screen********************
sdraw:
	move.w  4(a0),d1	;height to d1
	lea	gtemp,a1	;image pointer to a1
	lea	gmask,a2	;mask pointer to a2
	move.l  a6,a3		;screen buffer pointer to a3
sdi1:	move.w  6(a0),d0	;width to d0
	addq.w	#1,d0
	move.l  a6,a5    	;absolute screen address to a0
sdi0:	move.l  (a2)+,d3        ;load mask data into d3
        move.l  (a1)+,d6        ;load screen image into d6 and d7
        move.l  (a1)+,d7        ;2 words each covers all 4 planes
        move.l  (a3)+,d4	;do the same for the background
        move.l  (a3)+,d5        ;in d4 and d5 (from buffer, not screen)
        and.l   d3,d4           ;mask background
        and.l   d3,d5
        or.l    d6,d4           ;copy image onto background
        or.l    d7,d5           ;giving final image on top of background
        move.l  d4,(a5)+        ;copy final image into screen memory
        move.l  d5,(a5)+
        dbf     d0,sdi0		;repeat for 'width' times
        addi.l	#160,a6		;move to next screen line
        add.w  	8(a0),a3
        dbf     d1,sdi1		;repeat 'height' times
	rts



magic2:	dc.w	200
myreset:
	rts

fileshipcomp:	dc.b	'front.cmp',0
fileplan:	dc.b	'plan3a.d8a',0
even
savesup:	dc.l	0
ressave:	dc.w	0
filename:	dc.l	0
bluepalette:
	dc.w	$0555,$0000,$0555,$0333,$0507,$0406,$0305,$0007
	dc.w	$0006,$0005,$0004,$0070,$0050,$0030,$0077,$0037
palette2:
	dc.w	$0555,$0777,$0666,$0555,$0444,$0333,$0650,$0540
	dc.w	$0430,$0320,$0004,$0070,$0050
p2cyc:	dc.w	$0077,$0066,$0055


gtemp:	blk.w	500,0
gmask:	blk.w	300,0
gsave:	blk.w	500,0
smallnumbers:
	 dc.b	$C1,$C1,$FF,$FF,$9E,$9E,$FF,$FF
	 dc.b	$AE,$AE,$FF,$FF,$B6,$B6,$FF,$FF
	 dc.b	$BA,$BA,$FF,$FF
	dc.b	$BE,$BE,$FF,$FF
	dc.b	$C1,$C1,$FF,$FF
	 dc.b	$F7,$F7,$FF,$FF,$E7,$E7,$FF,$FF
	 dc.b	$F7,$F7,$FF,$FF,$F7,$F7,$FF,$FF
	 dc.b	$F7,$F7,$FF,$FF,$F7,$F7,$FF,$FF
	 dc.b	$E3,$E3,$FF,$FF,$C3,$C3,$FF,$FF
	 dc.b	$BD,$BD,$FF,$FF,$FD,$FD,$FF,$FF
	 dc.b	$C3,$C3,$FF,$FF,$BF,$BF,$FF,$FF
	 dc.b	$BF,$BF,$FF,$FF,$83,$83,$FF,$FF
	 dc.b	$C3,$C3,$FF,$FF,$BD,$BD,$FF,$FF
	 dc.b	$FD,$FD,$FF,$FF,$E3,$E3,$FF,$FF
	 dc.b	$FD,$FD,$FF,$FF,$BD,$BD,$FF,$FF
	 dc.b	$C3,$C3,$FF,$FF,$F3,$F3,$FF,$FF
	 dc.b	$EB,$EB,$FF,$FF,$DB,$DB,$FF,$FF
	 dc.b	$BB,$BB,$FF,$FF,$81,$81,$FF,$FF
	 dc.b	$FB,$FB,$FF,$FF,$FB,$FB,$FF,$FF
	 dc.b	$81,$81,$FF,$FF,$BF,$BF,$FF,$FF
	 dc.b	$C3,$C3,$FF,$FF,$FD,$FD,$FF,$FF
	 dc.b	$FD,$FD,$FF,$FF,$BD,$BD,$FF,$FF
	 dc.b	$C3,$C3,$FF,$FF,$C3,$C3,$FF,$FF
	 dc.b	$BF,$BF,$FF,$FF,$BF,$BF,$FF,$FF
	 dc.b	$83,$83,$FF,$FF,$BD,$BD,$FF,$FF
	 dc.b	$BD,$BD,$FF,$FF,$C3,$C3,$FF,$FF
	 dc.b	$C1,$C1,$FF,$FF,$FD,$FD,$FF,$FF
	 dc.b	$FD,$FD,$FF,$FF,$FB,$FB,$FF,$FF
	 dc.b	$FB,$FB,$FF,$FF,$F7,$F7,$FF,$FF
	 dc.b	$F7,$F7,$FF,$FF,$C3,$C3,$FF,$FF
	 dc.b	$BD,$BD,$FF,$FF,$BD,$BD,$FF,$FF
	 dc.b	$C3,$C3,$FF,$FF,$BD,$BD,$FF,$FF
	 dc.b	$BD,$BD,$FF,$FF,$C3,$C3,$FF,$FF
	 dc.b	$C3,$C3,$FF,$FF,$BD,$BD,$FF,$FF
	 dc.b	$BD,$BD,$FF,$FF,$C1,$C1,$FF,$FF
	 dc.b	$FD,$FD,$FF,$FF,$FD,$FD,$FF,$FF
	 dc.b	$FD,$FD,$FF,$FF
even
pointer:
	 dc.w	$8000,$0000,$F01E,$0000,$0000,$8000,$8002,$0000
	 dc.w	$0000,$8000,$8002,$0000,$0000,$8000,$8002,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0100,$0100,$0100,$0100,$0280,$0380,$0380,$0380
	 dc.w	$0100,$0100,$0100,$0100,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$8000,$8002,$0000
	 dc.w	$0000,$8000,$8002,$0000,$0000,$8000,$8002,$0000
	 dc.w	$0002,$F01C,$F01E,$0000

test1data:
	dc.w	16,16
height:	dc.w	0
width:	dc.w	0


planetpalette:
	dc.w	$0555,$0000,$0555,$0333,$0507,$0406,$0305,$0007
	dc.w	$0006,$0005,$0004,$0070,$0060,$0050,$0077,$0037
planetoverlay:
	 dc.w	$AA00,$5400,$0000,$FE00,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0015,$000A,$0000,$001F
	 dc.w	$FFAA,$0000,$0000,$FFAA,$AA80,$0000,$0000,$AA80
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0015,$0000,$0000,$0015,$557F,$0000,$0000,$557F
	 dc.w	$00FF,$0000,$0000,$FFFF,$FFAA,$0000,$0000,$FFAA
	 dc.w	$AAAA,$0000,$0000,$AAAA,$8000,$0000,$0000,$8000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0AAA,$0000,$0000,$0AAA
	 dc.w	$AABF,$0000,$0000,$AABF,$FFC0,$0000,$0000,$FFFF
	 dc.w	$FF00,$FF00,$FF00,$00FF,$007F,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$EAAA,$0000,$0000,$EAAA
	 dc.w	$AAAA,$0000,$0000,$AAAA,$AA80,$0000,$0000,$AA80
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0002,$0000,$0000,$0002,$AAAA,$0000,$0000,$AAAA
	 dc.w	$AAAA,$0000,$0000,$AAAA,$BFFF,$0000,$0000,$BFFF
	 dc.w	$FFC0,$0000,$0000,$FFFF,$003F,$003F,$003F,$FFC0
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FF80,$FF80,$FF80,$007F
	 dc.w	$0000,$0000,$0000,$FFFF,$3FFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFEA,$0000,$0000,$FFEA
	 dc.w	$AAAA,$0000,$0000,$AAAA,$AAAA,$0000,$0000,$AAAA
	 dc.w	$AAAA,$0000,$0000,$AAAA,$AAAA,$0000,$0000,$AAAA
	 dc.w	$AAAA,$0000,$0000,$AAAA,$AAAA,$0000,$0000,$AAAA
	 dc.w	$AAAB,$0000,$0000,$AAAB,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$E000,$0000,$0000,$FFFF
	 dc.w	$003F,$003F,$003F,$FFC0,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$FF00,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$C000,$C000,$C000,$3FFF
	 dc.w	$0000,$0000,$0000,$FFFF,$003F,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFF,$0000,$0000,$FFFF,$FFFF,$0000,$0000,$FFFF
	 dc.w	$FFFC,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$1FFF,$1FFF,$1FFF,$E000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$003F
	 dc.w	$00FF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FF80
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFC0,$FFC0,$FFC0,$003F
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$FFFF
	 dc.w	$0003,$0003,$0003,$FFFC,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$003F,$FFC0,$FFFF,$FFFF,$FFFF
	 dc.w	$CF00,$0FFF,$0FFF,$F3FF,$007F,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$C000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$1FFF
	 dc.w	$FFC0,$FFFF,$FFFF,$FFFF,$003C,$FFFC,$FFFC,$FFF3
	 dc.w	$0100,$AAFF,$0000,$AAFF,$6780,$87FF,$07FF,$F9FF
	 dc.w	$0000,$FFFF,$FFFF,$FFFF,$3FFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFC0
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF,$0000
	 dc.w	$FFFF,$FFFF,$FFFF,$0003,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$E000,$FFFF,$FFFF,$FFFF
	 dc.w	$003C,$FFFC,$FFFC,$FFF3,$C010,$3FEA,$0000,$FFEA
	 dc.w	$0000,$0155,$0000,$0155,$0080,$557F,$0000,$557F
	 dc.w	$0033,$FFC3,$0003,$FFFC,$C000,$FFFF,$FFFF,$FFFF
	 dc.w	$0000,$FFFF,$FFFF,$FFFF,$003F,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFC,$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF
	 dc.w	$0000,$FFFF,$FFFF,$FFFF,$1E60,$FE1F,$FE00,$F9FF
	 dc.w	$0020,$FFD5,$0000,$FFD5,$0000,$5550,$0000,$5550
	 dc.w	$0000,$0000,$0000,$0000,$0000,$00AA,$0000,$00AA
	 dc.w	$0000,$AAAA,$0000,$AAAA,$4000,$BFFF,$0000,$BFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$33C0,$C3FF,$03FF,$FCFF
	 dc.w	$0000,$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF
	 dc.w	$0000,$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF
	 dc.w	$0000,$FFFF,$FFFF,$FFFF,$0000,$FFFF,$FFFF,$FFFF
	 dc.w	$0003,$FFFF,$FFFF,$FFFF,$CC00,$C3FF,$C000,$3FFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$1000,$EAAA,$0000,$EAAA
	 dc.w	$0000,$AAA0,$0000,$AAA0,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$5555,$0000,$5555
	 dc.w	$0000,$5555,$0000,$5555,$0000,$557F,$0000,$557F
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFF,$0000,$FFFF,$0000,$FFFF,$0000,$FFFF
	 dc.w	$0000,$FFFD,$0000,$FFFD,$0000,$5555,$0000,$5555
	 dc.w	$0000,$5555,$0000,$5555,$0000,$5000,$0000,$5000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$00AA,$0000,$00AA
	 dc.w	$0000,$AAAA,$0000,$AAAA,$0000,$AAAA,$0000,$AAAA
	 dc.w	$0000,$AAAA,$0000,$AAAA,$0000,$AAAA,$0000,$AAAA
	 dc.w	$0000,$AAAA,$0000,$AAAA,$0000,$AAAA,$0000,$AAAA
	 dc.w	$0000,$AAAA,$0000,$AAAA,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
planetmask:
	 dc.w	$FE00,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$001F,$FFAA,$AA80,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0015,$557F,$FFFF,$FFAA,$AAAA,$8000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0AAA,$AABF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$EAAA,$AAAA,$AA80,$0000,$0000,$0000,$0000
	 dc.w	$0000,$0000,$0002,$AAAA,$AAAA,$BFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFEA,$AAAA,$AAAA
	 dc.w	$AAAA,$AAAA,$AAAA,$AAAA,$AAAB,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$ABFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFA,$0155,$55FF,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFF5,$5550,$0000,$00AA,$AAAA,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFF,$FAAA,$AAA0,$0000,$0000,$0000
	 dc.w	$0000,$5555,$5555,$557F,$FFFF,$FFFF,$FFFF,$FFFF
	 dc.w	$FFFF,$FFFF,$FFFD,$5555,$5555,$5000,$0000,$0000
	 dc.w	$0000,$0000,$0000,$0000,$0000,$00AA,$AAAA,$AAAA
	 dc.w	$AAAA,$AAAA,$AAAA,$AAAA,$AAAA,$0000,$0000,$0000
	 dc.w	$0000,$0000

