***************************************
initialisedigi:
	BSR	SAVEMFP
	MOVE.W	#$2700,SR
	move.l	$114,old200
	move.l	#my200,$114
	LEA	INULL,A0
	BSR	SETINT
	MOVEQ	#0,D0		;freq=5k
	BSR	SETFREQ
	BSR	ENABMFP
	BSR	SETSND
	MOVE.W	mysr,SR	;ENABLE THE INTERRUPTS
	rts
my200:
	addq.l	#1,$4ba
	rte

*****************************************************************
startsampsound:
	move.w	4(sp),hr			;get the stuff off the stack
	move.l	#moff,-(sp)
	clr.w	-(sp)
	move.w	#25,-(sp)
	trap	#14
	addq.l	#8,sp
	move.l	10(sp),currentsad
	move.l	10(sp),soundstart
	move.l	6(sp),soundend
	bsr	setsnd
	lea	ireplay,a0
	bsr	setint
	rts
stopsound:
	move.l	#mon,-(sp)
	clr.w	-(sp)
	move.w	#25,-(sp)
	trap	#14
	addq.l	#8,sp
	lea	inull,a0
	bsr	setint
	rts


****************************************
*     THE NULL INTERRUPT ROUTINE       *
****************************************
inull:
	rte		;when not playing just return
****************************************
*       REPLAY FROM MEMORY             *
****************************************
IREPLAY:
	movem.l	d0/d3/d4/d5/d7/a0/a3/a4/a6,-(sp)
	move.w	#$2500,sr
	MOVEQ	#0,D7
	move.l	currentsad,a6	;current sample address
	MOVE.B	(A6)+,D7	;get the sample
	CMP.L	soundend,A6	;is it past the end
	BGT.S	haltorrepeat	;you betcha
	move.l	a6,currentsad
	bra.s	INTOUTP		;ELSE OUTPUT IT
haltorrepeat:
	tst.w	hr		;should it stop or repeat
	bmi.s	onceonly
	move.l	soundstart,currentsad
	movem.l	(sp)+,d0/d3/d4/d5/d7/a0/a3/a4/a6
	RTE
onceonly:
	lea	inull,a0
	bsr	setint
	movem.l	(sp)+,d0/d3/d4/d5/d7/a0/a3/a4/a6
	RTE

INTOUTP:
	lea	screg,a4
	MOVE.B	#7,(a4)		;SET UP CHANNEL MIXING & PORT 'A' I/O
	MOVE.B	#$FF,SCDATA
	lea	snd_out,a3
	AND.W	#$00FF,D7	;MASK OFF RUBBISH
	ADD.B	#$80,D7		;COMPLENT VALUE
	LSL.W	#3,D7		;DOUBLE LONG WORD OFFSET
	MOVE.L	0(A3,D7.W),d5	;GET DATA #1
	MOVE.W	4(A3,D7.W),D4	;GET DATA #2
	MOVEP.L	D5,0(A4)	;PLAY #1
	MOVEP.W	D4,0(A4)	;PLAY #2
	move.w	#$2000,sr
	movem.l	(sp)+,d0/d3/d4/d5/d7/a0/a3/a4/a6
	RTE

savemfp:
	move.w	sr,mysr
	MOVE.B	IERA,MFPMEM		;save all this shit for later
	MOVE.B	IERB,MFPMEM+1
	MOVE.B	IMRA,MFPMEM+2
	MOVE.B	IMRB,MFPMEM+3
	MOVE.B	TADR,MFPMEM+4
	MOVE.B	TACR,MFPMEM+5
	MOVE.B	VECTOR,MFPMEM+6
	rts
oldmfp:
	move.l	old200,$114
	MOVE.B	MFPMEM+6,VECTOR		;put back what we found
	MOVE.B	MFPMEM+5,TACR
	MOVE.B	MFPMEM+4,TADR
	MOVE.B	MFPMEM+3,IMRB
	MOVE.B	MFPMEM+2,IMRA
	MOVE.B	MFPMEM+1,IERB
	MOVE.B	MFPMEM,IERA
	move.w	mysr,sr
	RTS

setint:
	MOVE.W	SR,D0
	MOVE.W	#$2700,SR	;interrupts begone
	MOVE.L	A0,ISRVEC
	MOVE.W	D0,SR
	RTS
setfreq:
	MOVE.B	#0,TACR
	AND.W	#7,D0
	LEA	FREQTAB,A0
	LSL.W	#1,D0
	MOVE.W	0(A0,D0.W),D0
	MOVE.B	D0,TACR
	LSR.W	#8,D0
 	MOVE.B	D0,TADR
	RTS
enabmfp:
	bset	#5,IMRA
	bset	#5,IERA
	BCLR	#3,VECTOR
	RTS
setsnd:
	MOVE.B	#0,SCREG	;CHANNEL A
	MOVE.B	#0,SCDATA
	MOVE.B	#1,SCREG
	MOVE.B	#0,SCDATA

	MOVE.B	#2,SCREG	;CHANNEL B
	MOVE.B	#0,SCDATA
	MOVE.B	#3,SCREG
	MOVE.B	#0,SCDATA

	MOVE.B	#4,SCREG	;CHANNEL C
	MOVE.B	#0,SCDATA
	MOVE.B	#5,SCREG
	MOVE.B	#0,SCDATA

	MOVE.B	#7,SCREG	;SET UP CHANNEL MIXING & PORT 'A' I/O
	MOVE.B	#$FF,SCDATA

	MOVE.B	#8,SCREG	;SET ALL VOLUMES TO ZERO
	MOVE.B	#0,SCDATA
	MOVE.B	#9,SCREG
	MOVE.B	#0,SCDATA
	MOVE.B	#10,SCREG
	MOVE.B	#0,SCDATA
	RTS
