*	sound stuff	*
soundstarth:	equ	2
soundstartm:	equ	4
soundstartl:	equ	6
soundendh:	equ	$e
soundendm:	equ	$10
soundendl:	equ	$12
soundmode:	equ	$20
sounddma:	equ	0

*	blitter stuff	*
halftone:	equ	0
src_xinc:	equ	32
src_yinc:	equ	34
src_addr:	equ	36
endmask1:	equ	40
endmask2:	equ	42
endmask3:	equ	44
dst_xinc:	equ	46
dst_yinc:	equ	48
dst_addr:	equ	50
x_count:	equ	54
y_count:	equ	56
hop:		equ	58
op:		equ	59
line_num:	equ	60
skew:		equ	61
fhop_source:	equ	1
fhop_halftone:	equ	0
fskewfxsr:	equ	7
fskewnfsr:	equ	6
flinebusy:	equ	7
flinehog:	equ	6
flinesmudge:	equ	5
mhop_source:	equ	$02
mhop_halftone:	equ	$01
mskewfxsr:	equ	$80
mskewnfsr:	equ	$40
mlinebusy:	equ	$80
mlinehog:	equ	$40
mlinesmudge:	equ	$20


cspritex:	equ	0
cspritey:	equ	2
cspriteheight:	equ	8
cspritewidth:	equ	10
cspritead:	equ	4
nsamount2:	equ	1
ewamount2:	equ	1
nsamount:	equ	25
ewamount:	equ	25
iea:	equ	$fffa07
ieb:	equ	$fffa09
isra:	equ	$fffa0f
ima:	equ	$fffa13
tbcr:	equ	$fffa1b
tbdr:	equ	$fffa21
vbl_vec:	equ	$70
key_vec:	equ	$118
hbl_vec:	equ	$120
magic:		equ	1650
magic2:		equ	1650
numstars:	equ	12
speed:		equ	350
zclip:		equ	100
start:
	clr.l   -(SP)           ;Go into supervisor mode
        move.w  #$20,-(SP)
        trap    #1
        addq.l  #6,SP
        move.l  D0,savesup
	move.b	#0,$484
	move.l	$426,rvsave
	move.l	$42a,resave
	move.w	#4,-(sp)
	trap	#14
	addq.l	#2,sp
	move.w	d0,ressave

	move.w	#0,-(sp)	;set to low res
	move.l	#-1,-(sp)
	move.l	#-1,-(sp)
	move.w	#5,-(sp)
	trap	#14
	add.l	#12,sp
	lea	palsave,a0
	move.l	#$ff8240,a1
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+

setupkey:
	move.w	#1,-(sp)
	move.w	#14,-(sp)
	trap	#14
	addq.l	#4,sp
	move.l	d0,keybuf
	move.w	#$7ff,$ff8924
	move.l	#12345,d0
	bsr	randomseed
	jsr	putrout
	jsr	getscrn
	jsr	clearboth

	move.l	vbl_vec,vblt+2		;set up vbl handler
	move.l	vbl_vec,oldvblvec
	move.l	#vbl_handler,vbl_vec
	bsr	loadscr
	bsr	pointeroff
	bsr	copyintoboth
	bsr	setupdisplay
	move.w	#-1,pointeronoff
	lea	channel0params,a0
	move.w	#%00001001,channeloff(a0)
	move.w	#-1,channelprocess(a0)
	lea	channel1params,a0
	move.w	#%00010010,channeloff(a0)
	move.w	#-1,channelprocess(a0)
	lea	channel2params,a0
	move.w	#%00100100,channeloff(a0)
	move.w	#-1,channelprocess(a0)
testloop:
	bsr	docheck
	jsr	keyboard
	move.w	#37,-(sp)
	trap	#14
	addq.l	#2,sp
*	jsr	flip_scr2
	bra	testloop


*********************************************************
*	my routines for loading in the screens		*
*********************************************************
loadscr:
	move	#0,-(SP)	;Open file
	move.l	#filescreen,-(SP) ;Address of filename
	move	#$3D,-(SP)
	trap	#1		;Get handle number in D0
	addq.l	#8,SP
	tst.w	d0
	bmi	nofile
	move.l	d0,-(sp)
	move.l	screen3,-(SP)    ;load it straight onto screen
	move.l	#128,-(SP)		;length to read in
	move	D0,-(SP)	;Handle
	move	#$3F,-(SP)	;bios number
	trap	#1		;Read file in
	addi.l	 #12,SP

	move.l	(sp)+,d0
	move.l	screen3,-(SP)    ;load it straight onto screen
	move.l	#32000,-(SP)		;length to read in
	move	D0,-(SP)	;Handle
	move	#$3F,-(SP)	;bios number
	trap	#1		;Read file in
	addi.l	 #12,SP

	move	#$3E,-(SP)	;Handle already on stack
	trap	#1		;Close file
	addq.l	#2,SP
nofile:
	rts

loadbank:
	move	#0,-(SP)	;Open file
	move.l	#filesounds,-(SP) ;Address of filename
	move	#$3D,-(SP)
	trap	#1		;Get handle number in D0
	addq.l	#8,SP
	tst.w	d0
	bmi	nofile
	move.l	#mysoundbank,-(SP)    ;load it straight onto screen
	move.l	#160,-(SP)	;length to read in
	move	D0,-(SP)	;Handle
	move	#$3F,-(SP)	;bios number
	trap	#1		;Read file in
	addi.l	 #12,SP
	move	#$3E,-(SP)	;Handle already on stack
	trap	#1		;Close file
	addq.l	#2,SP
	rts

savebank:
	move	#0,-(SP)	;Open file
	move.l	#filesounds,-(SP) ;Address of filename
	move	#$3D,-(SP)
	trap	#1		;Get handle number in D0
	addq.l	#8,SP
	tst.w	d0
	bmi	nofile
	move.l	#mysoundbank,-(SP)    ;load it straight onto screen
	move.l	#160,-(SP)	;length to read in
	move	D0,-(SP)	;Handle
	move	#$40,-(SP)	;bios number
	trap	#1		;Read file in
	addi.l	 #12,SP
	move	#$3E,-(SP)	;Handle already on stack
	trap	#1		;Close file
	addq.l	#2,SP
	rts

writeasm:
	move	#0,-(SP)	;Open file
	move.l	#fileasm,-(SP) ;Address of filename
	move	#$3D,-(SP)
	trap	#1		;Get handle number in D0
	addq.l	#8,SP
	tst.w	d0
	bmi	nofile
	move.l	#asmblock,-(SP)    ;load it straight onto screen
	move.l	#asmbend,d1
	sub.l	#asmblock,d1
	move.l	d1,-(SP)	;length to read in
	move	D0,-(SP)	;Handle
	move	#$40,-(SP)	;bios number
	trap	#1		;Read file in
	addi.l	 #12,SP
	move	#$3E,-(SP)	;Handle already on stack
	trap	#1		;Close file
	addq.l	#2,SP
	rts
filescreen:	dc.b	'sd1.neo',0
even
*********************************************************
*	clipped sprite header				*
*********************************************************
arrowsp:
	dc.w	0,0		;x,y
	dc.l	arrow		;address of bank of 16 prerotated sprites
	dc.w	16		;height
	dc.w	16
emptyhandsp:
	dc.w	0,0		;x,y
	dc.l	emptyhand		;address of bank of 16 prerotated sprites
	dc.w	16		;height
	dc.w	16
filledhandsp:
	dc.w	0,0		;x,y
	dc.l	filledhand	;address of bank of 16 prerotated sprites
	dc.w	16		;height
	dc.w	16

cxmax:		equ	320
cxmin:		equ	0
cymax:		equ	199
cymin:		equ	0
putlast:	dc.w	-1
lastbuff:	blk.w	[20*4*2]+3

specialcase:
	lea	lastbuff,a1
	move.l	(a1)+,a2
	move.w	(a1)+,d0	;height
	bmi	nolastc
	move.w	(a1)+,d1	;test the flag
	bmi	alllastc
pllc:
	move.l	(a1)+,(a2)+
	move.l	(a1)+,(a2)+
	lea	144+8(a2),a2
	dbf	d0,pllc
	bra.s	nolastc
alllastc:
	move.l	(a1)+,(a2)+
	move.l	(a1)+,(a2)+
	move.l	(a1)+,(a2)+
	move.l	(a1)+,(a2)+
	lea	144(a2),a2
	dbf	d0,alllastc
nolastc:
	move.w	#-1,putlast
	rts
*********************************************************
*	draw prerotated and clippped sprite		*
*	pass address of sprite header in a0		*
*********************************************************
drawclipped:
	tst.w	pointeronoff
	beq	nosprite2	;completely off
	blt	notnew
	move.w	#0,pointeronoff
	bra	specialcase
notnew:
	tst.w	putlast
	bmi	nolast
	lea	lastbuff,a1
	move.l	(a1)+,a2
	move.w	(a1)+,d0	;height
	bmi	nolast
	move.w	(a1)+,d1	;test the flag
	bmi	alllast
pll:
	move.l	(a1)+,(a2)+
	move.l	(a1)+,(a2)+
	lea	144+8(a2),a2
	dbf	d0,pll
	bra.s	nolast
alllast:
	move.l	(a1)+,(a2)+
	move.l	(a1)+,(a2)+
	move.l	(a1)+,(a2)+
	move.l	(a1)+,(a2)+
	lea	144(a2),a2
	dbf	d0,alllast
nolast:
	move.w	#1,putlast
	lea	lastbuff,a5
	cmpi.w	#cxmin,cspritex(a0)
	ble	nosprite
	cmpi.w	#cxmax,cspritex(a0)
	bgt	nosprite
	move.w	cspritex(a0),d2 	;get x
	move.w	d2,d0
	move.w	d0,d4
	move.w	cspritey(a0),d1 ;get y
	move.w	d1,d5
	and.w	#15,d2		;get last 4 bits=offset
	move.w	d2,d3		;get a copy of last 4 bits

	move	cspriteheight(a0),d7		;counter before clipping
	move.w	#cymin,d6	;is it above cymin
	cmpi.w	d6,d5
	bge	spcl1
	sub.w	d5,d6		;gives number of lines missing
	sub.w	d6,d7		;for counter
	mulu	#20,d6		;for add to sprite data address
	move.l	seen,a6
	lea	cymin*160(a6),a6
	bra	spcl2
spcl1:
	moveq	#0,d6
	move.l	seen,a6
	lsl.w	#5,d1		;*128
	add.w	d1,a6
	lsl.w	#2,d1
	add.w	d1,a6		;=*160 gives line add
spcl2:
	and.w	#$fff0,d0	;word
	lsr.w	#1,d0
	add.w	d0,a6		;a6 has actual screen address


	move.w	#cymax,d1
	sub.w	cspriteheight(a0),d1
	cmp.w	d1,d5
	ble	spcl3
	sub.w	d1,d5
	sub.w	d5,d7
spcl3:
	move.l	cspritead(a0),a1
	lsl.w	#6,d3		;*128
	add.w	d3,a1		;a1 has ad of final sprite data
	lsl.w	#2,d3
	add.w	d3,a1
	add.w	d6,a1		;adjust for top yclip
extrastuff:
	cmpi.w	#cxmin,d4
	bge	spcl6
	bra	clipleftsprite
spcl6:
	cmpi.w	#cxmax-16,d4
	ble	doallsprite
*	fall through

cliprightsprite:
	subq.w	#1,d7
	bmi	nosprite
	move.l	a6,(a5)+	;for restore
	move.w	d7,(a5)+	;number of lines
	move.w	#1,(a5)+	;flag for only 1*4 words to restore
crightloop:
	move.w	(a6),d0 	;get 4 screen words
	move.w	2(a6),d1
	move.w	4(a6),d2
	move.w	6(a6),d3
	move.w	(a6),(a5)+ 	;get 4 screen words
	move.w	2(a6),(a5)+
	move.w	4(a6),(a5)+
	move.w	6(a6),(a5)+
	and.w	(a1),d0 	;mask word
	and.w	(a1),d1 	;mask word
	and.w	(a1),d2 	;mask word
	and.w	(a1)+,d3	;mask word
	or.w	(a1)+,d0	;or the sprite image in the hole
	or.w	(a1)+,d1	;we just cut
	or.w	(a1)+,d2
	or.w	(a1)+,d3
	move.w	d0,(a6)+	;put the picture in th picture
	move.w	d1,(a6)+
	move.w	d2,(a6)+
	move.w	d3,(a6)+
	lea	10(a1),a1
	lea	144+8(a6),a6
	dbf	d7,crightloop
	rts

clipleftsprite:
	subq.w	#1,d7
	bmi	nosprite
	move.l	a6,(a5)+	;for restore
	move.w	d7,(a5)+	;number of lines
	move.w	#1,(a5)+	;flag for only 1*4 words to restore
cleftloop:
	lea	10(a1),a1
	lea	8(a6),a6
	move.w	(a6),d0 	;get 4 screen words
	move.w	2(a6),d1
	move.w	4(a6),d2
	move.w	6(a6),d3
	move.w	(a6),(a5)+ 	;get 4 screen words
	move.w	2(a6),(a5)+
	move.w	4(a6),(a5)+
	move.w	6(a6),(a5)+
	and.w	(a1),d0 	;mask word
	and.w	(a1),d1 	;mask word
	and.w	(a1),d2 	;mask word
	and.w	(a1)+,d3	;mask word
	or.w	(a1)+,d0	;or the sprite image in the hole
	or.w	(a1)+,d1	;we just cut
	or.w	(a1)+,d2
	or.w	(a1)+,d3
	move.w	d0,(a6)+	;put the picture in th picture
	move.w	d1,(a6)+
	move.w	d2,(a6)+
	move.w	d3,(a6)+
	lea	144(a6),a6
	dbf	d7,cleftloop
	rts

nosprite:
	move.l	a6,(a5)+	;for restore
	move.w	d7,(a5)+	;number of lines
	move.w	#-1,(a5)+	;flag for only 1*4 words to restore
nosprite2:
	rts
doallsprite:
	subq.w	#1,d7
	bmi	nosprite
	move.l	a6,(a5)+	;for restore
	move.w	d7,(a5)+	;number of lines
	move.w	#-1,(a5)+	;flag for only 1*4 words to restore
doallloop:
	move.w	(a6),d0 	;get 4 screen words
	move.w	2(a6),d1
	move.w	4(a6),d2
	move.w	6(a6),d3
	move.w	(a6),(a5)+ 	;get 4 screen words
	move.w	2(a6),(a5)+
	move.w	4(a6),(a5)+
	move.w	6(a6),(a5)+
	and.w	(a1),d0 	;mask word
	and.w	(a1),d1 	;mask word
	and.w	(a1),d2 	;mask word
	and.w	(a1)+,d3	;mask word
	or.w	(a1)+,d0	;or the sprite image in the hole
	or.w	(a1)+,d1	;we just cut
	or.w	(a1)+,d2
	or.w	(a1)+,d3
	move.w	d0,(a6)+	;put the picture in th picture
	move.w	d1,(a6)+
	move.w	d2,(a6)+
	move.w	d3,(a6)+

	move.w	(a6),d0 	;get 4 screen words
	move.w	2(a6),d1
	move.w	4(a6),d2
	move.w	6(a6),d3
	move.w	(a6),(a5)+ 	;get 4 screen words
	move.w	2(a6),(a5)+
	move.w	4(a6),(a5)+
	move.w	6(a6),(a5)+
	and.w	(a1),d0 	;mask word
	and.w	(a1),d1 	;mask word
	and.w	(a1),d2 	;mask word
	and.w	(a1)+,d3	;mask word
	or.w	(a1)+,d0	;or the sprite image in the hole
	or.w	(a1)+,d1	;we just cut
	or.w	(a1)+,d2
	or.w	(a1)+,d3
	move.w	d0,(a6)+	;put the picture in th picture
	move.w	d1,(a6)+
	move.w	d2,(a6)+
	move.w	d3,(a6)+
	lea	144(a6),a6
	dbf	d7,doallloop
	rts

vbl_handler:
	move.b	seen+1,$ff8205
	move.b	seen+2,$ff8207
	move.b	seen+3,$ff8209
	move.b	#0,tbcr
	move.b	#129,tbdr
	move.b	#8,tbcr
	movem.l	d0-d7/a0-a6,-(sp)
	lea	toppalette,a0
	lea	$ff8240,a1
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	bsr	dopointer
	tst.w	noprocess
	bpl.s	sks
	bsr	dosound
sks:
	movem.l	(sp)+,d0-d7/a0-a6
vblt:	jmp	$0
dopointer:
	move.l	whichpointer,a0
	move.w	mx,cspritex(a0)
	move.w	my,cspritey(a0)
	bsr	drawclipped
	rts

dosound:
	lea	channel0params,a1
	bsr	dosoundstuff
	lea	channel1params,a1
	bsr	dosoundstuff
	lea	channel2params,a1
dosoundstuff:
	tst.w	channelprocess(a1)
	bmi	noch0
	subq.w	#1,channellife(a1)
	bpl	still0
	move.w	#-1,channelprocess(a1)
	bra	stopsound0
still0:
	tst.w	channelwaveform(a1)	;does it need shaping
	bmi	skip0waveforms
	subq.w	#1,channelspeed2(a1)
	tst.w	channelspeed2(a1)
	bpl	skip0waveforms
	move.w	channelspeed(a1),channelspeed2(a1)
	cmpi.w	#0,channelwaveform(a1)
	bne	ch0p1
	move.w	channelvolume(a1),d1
	addq.w	#1,d1
	cmpi.w	#16,d1
	blt	ch0pl
	moveq	#15,d1
ch0pl:
	bra	finalwaveform
ch0p1:
	cmpi.w	#1,channelwaveform(a1)
	bne	ch0p2
	move.w	channelvolume(a1),d1
	subq.w	#1,d1
	cmpi.w	#0,d1
	bge	ch0pu
	moveq	#0,d1
ch0pu:
	bra	finalwaveform
ch0p2:
	cmpi.w	#2,channelwaveform(a1)
	bne	ch0p3
	move.w	channelvolume(a1),d1
	move.w	channelvel(a1),d2
	add.w	d2,d1
	cmpi.w	#0,d1
	bgt	ch0saw1
	neg.w	channelvel(a1)
	bra	ch0saw2
ch0saw1:
	cmpi.w	#15,d1
	blt	ch0saw2
	neg.w	channelvel(a1)
ch0saw2:
	bra	finalwaveform
ch0p3:
	cmpi.w	#3,channelwaveform(a1)
	bne	ch0p4
	move.w	channelvolume(a1),d1
	addq.w	#1,d1
	and.w	#$f,d1
	bra	finalwaveform
ch0p4:
	move.w	channelvolume(a1),d1
	subq.w	#1,d1
	bge	finalwaveform
	moveq	#15,d1
finalwaveform:
	move.w	d1,channelvolume(a1)
	move.w	channelvolreg(a1),d0
	bsr	writedata
skip0waveforms:
	moveq	#0,d7
	move.w	channelreg(a1),d7
	bmi	noch0
	move.w	channelreg2(a1),d2
	move.w	(a1,d2.w),d1
	add.w	channeladd(a1),d1
	cmp.w	channelcmp(a1),d1
	bne	not0end
	move.w	#-1,channelprocess(a1)
	bsr	stopsound0
not0end:
	move.w	d1,(a1,d2.w)
	move.w	d7,d0
	bsr	writedata
noch0:
	rts
stopsound0:
	move.b	mymixer,d1
	or.w	channeloff(a1),d1	;reg
	move.b	d1,mymixer
	move.b	#7,d0
	bsr	writedata
	rts

writedata:
	move.b	d0,$ff8800
	cmp.b	#7,d0
	bne	wd2
	and.b	#$3f,d1
	move.b	$ff8800,d0
	and.b	#$c0,d0
	or.b	d0,d1
wd2:
	move.b	d1,$ff8802
	rts


prepsound:
	lea	currentbytes,a0
	move.b	(a0),d7			;channel number
channel0start:
	cmpi.b	#0,d7
	bne	channel1start
	lea	channel0params,a1
	lea	ch0regs,a2
	moveq	#0,d0
	move.b	#%00001001,d0
	move.w	d0,channeloff(a1)
	bra	dochannel
channel1start:
	cmpi.b	#1,d7
	bne	channel2start
	lea	channel1params,a1
	lea	ch1regs,a2
	moveq	#0,d0
	move.b	#%00010010,d0
	move.w	d0,channeloff(a1)
	bra	dochannel
channel2start:
	lea	channel2params,a1
	lea	ch2regs,a2
	moveq	#0,d0
	move.b	#%00100100,d0
	move.w	d0,channeloff(a1)
dochannel:
	moveq	#0,d1
	move.b	1(a0),d1		;get waveform
	tst.b	d1
	bmi.s	constant0
	move.w	d1,channelwaveform(a1)
w00:	cmpi.b	#0,d1
	bne.s	w01
	moveq	#0,d1
	bra.s	setvol0
w01:	cmpi.b	#1,d1
	bne.s	w02
	moveq	#15,d1
	bra.s	setvol0
w02:	cmpi.b	#2,d1
	bne.s	w03
	moveq	#0,d1
	move.w	#1,channelvel(a1)
	bra.s	setvol0
w03:	cmpi.b	#3,d1
	bne.s	w04
	moveq	#0,d1
	bra.s	setvol0
w04:
	moveq	#15,d1
	bra.s	setvol0
constant0:
	ext.w	d1
	move.w	d1,channelwaveform(a1)
	neg.w	d1			;gives volume
setvol0:
	move.w	d1,channelvolume(a1)
	moveq	#0,d0
	move.b	(a2),d0
	move.w	d0,channelvolreg(a1)			;get volume reg for channel
dolife0:
	moveq	#0,d1
	move.b	2(a0),d1
	move.w	d1,channellife(a1)	;life
	moveq	#0,d1
	move.b	3(a0),d1
	move.w	d1,channelspeed(a1)
	move.w	d1,channelspeed2(a1)
	moveq	#0,d1
	move.b	4(a0),d1
	move.w	d1,channelfine(a1)
	moveq	#0,d0
	move.b	1(a2),d0
	move.w	d0,channelfinereg(a1);get channel fine tune reg
	moveq	#0,d1
	move.b	5(a0),d1
	move.w	d1,channelcoarse(a1)
	moveq	#0,d0
	move.b	2(a2),d0
	move.w	d0,channelcoarsereg(a1)	;coarse tune reg for chan
	moveq	#0,d1				;set up a mixer reg
	move.b	4(a2),d0
	move.w	d0,channelmixa(a1)
	move.b	6(a0),d2			;get noise
	move.w	d2,channelnoise(a1)
	moveq	#0,d0
	move.b	3(a2),d0
	move.w	d0,channelmixb(a1)
	moveq	#0,d1
	move.b	7(a0),d1
	ext.w	d1
	move.w	d1,channelreg(a1)	;actual chip register
	tst.b	7(a0)
	bmi	nofancy
	moveq	#0,d1
	move.b	8(a0),d1
	move.w	d1,channelreg2(a1)	;offset from dat start to thing
	moveq	#0,d1			;to change
	move.b	9(a0),d1
	move.w	d1,channeladd(a1)
	moveq	#0,d1
	move.b	10(a0),d1
	move.w	d1,channelcmp(a1)
nofancy:
	rts

startsound:
	cmpi.b	#0,channelbyte2
	bne	start1
	lea	channel0params,a0
	bra	startit
start1:
	cmpi.b	#1,channelbyte2
	bne	start2
	lea	channel1params,a0
	bra	startit
start2:
	lea	channel2params,a0
startit:
	move.w	channelfine(a0),d1
	move.w	channelfinereg(a0),d0
	bsr	writedata
	move.w	channelcoarse(a0),d1
	move.w	channelcoarsereg(a0),d0
	bsr	writedata
	move.w	channelvolume(a0),d1
	move.w	channelvolreg(a0),d0
	bsr	writedata
	move.w	channelnoise(a0),d1
	beq.s	nonoise
	moveq	#6,d0
	bsr	writedata
	move.w	channelmixa(a0),d1
	bclr	d1,mymixer
	bra.s	skipkl
nonoise:
	move.w	channelmixa(a0),d1
	bset	d1,mymixer
skipkl:
	move.w	channelmixb(a0),d1
	bclr	d1,mymixer
	move.b	mymixer,d1
	moveq	#7,d0
	bsr	writedata
	move.w	#1,channelprocess(a0)
	rts


ch0regs:	dc.b	8,0,1,0,3
ch1regs:	dc.b	9,2,3,1,4
ch2regs:	dc.b	10,4,5,2,5
mymixer:		dc.b	%00111111

even
channel0params:		blk.w	20,0
channel1params:		blk.w	20,0
channel2params:		blk.w	20,0

channelvolume:		equ	0
channelwaveform:	equ	2
channellife:		equ	4
channelspeed:		equ	6
channelspeed2:		equ	8
channelfine:		equ	10
channelcoarse:		equ	12
channelreg:		equ	14
channeladd:		equ	16
channelcmp:		equ	18
channelprocess:		equ	20
channelnoise:		equ	22
channelreg2:		equ	24
channelvel:		equ	26
channelmixa:		equ	28
channelvolreg:		equ	30
channelfinereg:		equ	32
channelcoarsereg:	equ	34
channeloff:		equ	36
channelmixb:		equ	38
	even
bdelay:
	dc.w	0
oldx:	dc.w	0
oldy:	dc.w	0

docheck:
*	subq.w	#1,bdelay
*	bpl	dcback
*	move.w	#115,bdelay
	tst.w	buttondat
	beq	dcback
	lea	coordlist,a0
	move.w	mx,d0
	move.w	my,d1
	cmp.w	oldx,d0
	bne.s	notsame
	cmp.w	oldy,d1
	bne.s	notsame
	bra	dcback
notsame:
	move.w	d0,oldx
	move.w	d1,oldy
	move.w	(a0)+,d7		;number to check
tcloop:
	cmp.w	(a0),d0
	blt	nomatch
	cmp.w	2(a0),d1
	blt	nomatch
	cmp.w	4(a0),d0
	bgt	nomatch
	cmp.w	6(a0),d1
	bgt	nomatch		;its a match if through here
	move.l	10(a0),a6
	jmp	(a6)
nomatch:
	lea	14(a0),a0
	dbf	d7,tcloop
dcback:
	rts

dorestore:
	move.l	screen3,a6
	move.l	seen,a5
	moveq	#7,d6
	add.l	d7,a6
	add.l	d7,a5
drl:
	move.l	(a6)+,(a5)+
	move.l	(a6)+,(a5)+
	move.l	(a6)+,(a5)+
	move.l	(a6)+,(a5)+
	move.l	(a6)+,(a5)+
	move.l	(a6)+,(a5)+
	move.l	(a6)+,(a5)+
	move.l	(a6)+,(a5)+
	lea	144-16(a6),a6
	lea	144-16(a5),a5
	dbf	d6,drl
	rts
showbyte:
	move.l	seen,a6
	lea	160(a6),a6
	add.l	d1,a6
	move.l	a6,a5
	moveq	#0,d6		;odd even counter
	moveq	#7,d7		;do 8 bits
sbl:
	btst	d7,d0
	beq.L	notset		;bit not on so next bit
	move.l	a5,a4
	eor.b	#%01111111,(a4)
	eor.b	#%01111111,2(a4)
	eor.b	#%01111111,4(a4)
	eor.b	#%01111111,6(a4)
	lea	160(a4),a4
	eor.b	#%01111111,(a4)
	eor.b	#%01111111,2(a4)
	eor.b	#%01111111,4(a4)
	eor.b	#%01111111,6(a4)
	lea	160(a4),a4
	eor.b	#%01111111,(a4)
	eor.b	#%01111111,2(a4)
	eor.b	#%01111111,4(a4)
	eor.b	#%01111111,6(a4)
	lea	160(a4),a4
	eor.b	#%01111111,(a4)
	eor.b	#%01111111,2(a4)
	eor.b	#%01111111,4(a4)
	eor.b	#%01111111,6(a4)
	lea	160(a4),a4
	eor.b	#%01111111,(a4)
	eor.b	#%01111111,2(a4)
	eor.b	#%01111111,4(a4)
	eor.b	#%01111111,6(a4)
	lea	160(a4),a4
	eor.b	#%01111111,(a4)
	eor.b	#%01111111,2(a4)
	eor.b	#%01111111,4(a4)
	eor.b	#%01111111,6(a4)
	lea	160(a4),a4
	eor.b	#%01111111,(a4)
	eor.b	#%01111111,2(a4)
	eor.b	#%01111111,4(a4)
	eor.b	#%01111111,6(a4)
	lea	160(a4),a4
notset:
	btst	#0,d6
	bne.s	evenbit
	addq.w	#1,d6
	addq.l	#1,a5
	dbf	d7,sbl
	rts
evenbit:
	addq.l	#7,a5
	addq.w	#1,d6
	dbf	d7,sbl
	rts

pointeroff:
	move.w	#1,pointeronoff
twaitr:
	tst.w	pointeronoff	;make sure background is restored
	bne	twaitr
	rts

waveformsub:
	bsr	pointeroff
	move.w	8(a0),d0
	cmpi.w	#-15,d0
	bne	wv1
	move.b	#%00100000,wavebyte
	moveq	#0,d1
	move.b	volumebyte,d1
	neg.b	d1
	move.b	d1,wavebyte2
	bra	dowave
wv1:
	cmpi.w	#0,d0
	bne	wv2
	move.b	#%00010000,wavebyte
	move.b	d0,wavebyte2
	bra	dowave
wv2:
	cmpi.w	#1,d0
	bne	wv3
	move.b	#%00001000,wavebyte
	move.b	d0,wavebyte2
	bra	dowave
wv3:
	cmpi.w	#2,d0
	bne	wv4
	move.b	#%00000100,wavebyte
	move.b	d0,wavebyte2
	bra	dowave
wv4:
	cmpi.w	#3,d0
	bne	wv5
	move.b	#%00000010,wavebyte
	move.b	d0,wavebyte2
	bra	dowave
wv5:
*	cmpi.w	#0,d0
*	bne	wv2
	move.b	#%00000001,wavebyte
	move.b	d0,wavebyte2
*	bra	dowave

dowave:
	move.l	#1280,d7	;add into screen for restore
	bsr	dorestore
	moveq	#0,d0
	move.b	wavebyte,d0
	move.l	#1280,d1
	bsr	showbyte
	moveq	#0,d0
	move.b	wavebyte2,d0
	ext.l	d0
	moveq	#16,d1
	move.w	#13,d2		;x for print
	move.w	#1,d3		;y for print
	bsr	prtnum
	move.w	#-1,pointeronoff
	rts

lifesub:
	bsr	pointeroff
	move.w	8(a0),d0	;get info word indicates bit in byte
	bchg	d0,lifebyte
dolife:
	move.l	#3840,d7	;add into screen for restore
	bsr	dorestore
	moveq	#0,d0
	move.b	lifebyte,d0
	move.l	#3840,d1
	bsr	showbyte
	moveq	#0,d0
	move.b	lifebyte,d0
	ext.l	d0
	moveq	#16,d1
	move.w	#13,d2		;x for print
	move.w	#3,d3		;y for print
	bsr	prtnum
	move.w	#-1,pointeronoff
	rts

speedsub:
	bsr	pointeroff
	move.w	8(a0),d0	;get info word indicates bit in byte
	bchg	d0,speedbyte
dospeed:
	move.l	#6400,d7	;add into screen for restore
	bsr	dorestore
	moveq	#0,d0
	move.b	speedbyte,d0
	move.l	#6400,d1
	bsr	showbyte
	moveq	#0,d0
	move.b	speedbyte,d0
	ext.l	d0
	moveq	#16,d1
	move.w	#13,d2		;x for print
	move.w	#5,d3		;y for print
	bsr	prtnum
	move.w	#-1,pointeronoff
	rts
finesub:
	bsr	pointeroff
	move.w	8(a0),d0	;get info word indicates bit in byte
	bchg	d0,finebyte
dofine:
	move.l	#8960,d7	;add into screen for restore
	bsr	dorestore
	moveq	#0,d0
	move.b	finebyte,d0
	move.l	#8960,d1
	bsr	showbyte
	moveq	#0,d0
	move.b	finebyte,d0
	ext.l	d0
	moveq	#16,d1
	move.w	#13,d2		;x for print
	move.w	#7,d3		;y for print
	bsr	prtnum
	move.w	#-1,pointeronoff
	rts
coarsesub:
	bsr	pointeroff
	move.w	8(a0),d0	;get info word indicates bit in byte
	bchg	d0,coarsebyte
docoarse:
	move.l	#11520,d7	;add into screen for restore
	bsr	dorestore
	moveq	#0,d0
	move.b	coarsebyte,d0
	move.l	#11520,d1
	bsr	showbyte
	moveq	#0,d0
	move.b	coarsebyte,d0
	ext.l	d0
	moveq	#16,d1
	move.w	#13,d2		;x for print
	move.w	#9,d3		;y for print
	bsr	prtnum
	move.w	#-1,pointeronoff
	rts
noisesub:
	bsr	pointeroff
	move.w	8(a0),d0	;get info word indicates bit in byte
	bchg	d0,noisebyte
donoise:
	move.l	#14080,d7	;add into screen for restore
	bsr	dorestore
	moveq	#0,d0
	move.b	noisebyte,d0
	move.l	#14080,d1
	bsr	showbyte
	moveq	#0,d0
	move.b	noisebyte,d0
	ext.l	d0
	moveq	#16,d1
	move.w	#13,d2		;x for print
	move.w	#11,d3		;y for print
	bsr	prtnum
	move.w	#-1,pointeronoff
	rts
regsub:
	bsr	pointeroff
	move.w	8(a0),d0
	cmpi.w	#3,d0
	bne	rv1
	move.b	#%00001000,regbyte
	move.b	#-1,regbyte2
	bra	doreg
rv1:
	cmpi.w	#2,d0
	bne	rv2
	move.b	#%00000100,regbyte
	move.b	#6,regbyte2
	move.b	#channelnoise,regbyte3
	bra	doreg
rv2:
	cmpi.w	#1,d0
	bne	rv3
	move.b	#%00000010,regbyte
	move.b	#1,regbyte2
	move.b	channelbyte2,d2
	add.b	d2,d2
	add.b	d2,regbyte2
	move.b	#channelcoarse,regbyte3
	bra	doreg
rv3:
	move.b	#%00000001,regbyte
	move.b	#0,regbyte2
	move.b	channelbyte2,d2
	add.b	d2,d2
	add.b	d2,regbyte2
	move.b	#channelfine,regbyte3
doreg:
	move.l	#16640,d7	;add into screen for restore
	bsr	dorestore
	moveq	#0,d0
	move.b	regbyte,d0
	move.l	#16640,d1
	bsr	showbyte
	moveq	#0,d0
	move.b	regbyte2,d0
	ext.l	d0
	moveq	#16,d1
	move.w	#13,d2		;x for print
	move.w	#13,d3		;y for print
	bsr	prtnum
	move.w	#-1,pointeronoff
	rts
addsub:
	bsr	pointeroff
	move.w	8(a0),d0	;get info word indicates bit in byte
	bchg	d0,addbyte
doadd:
	move.l	#19200,d7	;add into screen for restore
	bsr	dorestore
	moveq	#0,d0
	move.b	addbyte,d0
	move.l	#19200,d1
	bsr	showbyte
	moveq	#0,d0
	move.b	addbyte,d0
	ext.l	d0
	moveq	#16,d1
	move.w	#13,d2		;x for print
	move.w	#15,d3		;y for print
	bsr	prtnum
	move.w	#-1,pointeronoff
	rts
cmpsub:
	bsr	pointeroff
	move.w	8(a0),d0	;get info word indicates bit in byte
	bchg	d0,cmpbyte
docmp:
	move.l	#21760,d7	;add into screen for restore
	bsr	dorestore
	moveq	#0,d0
	move.b	cmpbyte,d0
	move.l	#21760,d1
	bsr	showbyte
	moveq	#0,d0
	move.b	cmpbyte,d0
	ext.l	d0
	moveq	#16,d1
	move.w	#13,d2		;x for print
	move.w	#17,d3		;y for print
	bsr	prtnum
	move.w	#-1,pointeronoff
	rts


playsub:
	move.w	#$0fff,$ff8240
	bsr	startsound
	rts
stopsub:
	lea	channel0params,a1
	move.w	#-1,channelprocess(a1)
	bsr	stopsound0
	lea	channel1params,a1
	move.w	#-1,channelprocess(a1)
	bsr	stopsound0
	lea	channel2params,a1
	move.w	#-1,channelprocess(a1)
	bsr	stopsound0
	rts
prepsub:
	bsr	prepsound
	rts


chansub:
	bsr	pointeroff
	move.w	8(a0),d0
	cmpi.w	#2,d0
	bne	cv1
	move.b	#%00000100,channelbyte
	move.b	#2,channelbyte2
	bra	dochan
cv1:
	cmpi.w	#1,d0
	bne	cv2
	move.b	#%00000010,channelbyte
	move.b	#1,channelbyte2
	bra	dochan
cv2:
	move.b	#%00000001,channelbyte
	move.b	#0,channelbyte2
dochan:
	move.l	#24320,d7	;add into screen for restore
	bsr	dorestore
	moveq	#0,d0
	move.b	channelbyte,d0
	move.l	#24320,d1
	bsr	showbyte
	moveq	#0,d0
	move.b	channelbyte2,d0
	ext.l	d0
	moveq	#16,d1
	move.w	#13,d2		;x for print
	move.w	#19,d3		;y for print
	bsr	prtnum
	move.w	#-1,pointeronoff
	rts

volsub:
	bsr	pointeroff
	move.w	8(a0),d0
	bchg	d0,volumebyte
	tst.b	wavebyte2
	bpl	dovol
	moveq	#0,d1
	move.b	volumebyte,d1
	neg.b	d1
	move.b	d1,wavebyte2
dovol:
	move.l	#26880,d7	;add into screen for restore
	bsr	dorestore
	moveq	#0,d0
	move.b	volumebyte,d0
	move.l	#26880,d1
	bsr	showbyte
	moveq	#0,d0
	move.b	volumebyte,d0
	ext.l	d0
	moveq	#16,d1
	move.w	#13,d2		;x for print
	move.w	#21,d3		;y for print
	bsr	prtnum
	move.w	#-1,pointeronoff
	bra	dowave
	rts
soundsub:
	bsr	pointeroff
	bsr	copytolast
	move.w	8(a0),d0
	cmpi.w	#0,d0
	bne	so1
	lea	sound0,a1
	move.l	a1,currentsound
	bsr	setupdisplay
	move.l	#80,d0
	bra	invertsquare
so1:
	cmpi.w	#1,d0
	bne	so2
	lea	sound1,a1
	move.l	a1,currentsound
	bsr	setupdisplay
	move.l	#2640,d0
	bra	invertsquare
so2:
	cmpi.w	#2,d0
	bne	so3
	lea	sound2,a1
	move.l	a1,currentsound
	bsr	setupdisplay
	move.l	#5200,d0
	bra	invertsquare
so3:
	cmpi.w	#3,d0
	bne	so4
	lea	sound3,a1
	move.l	a1,currentsound
	bsr	setupdisplay
	move.l	#7760,d0
	bra	invertsquare
so4:
	cmpi.w	#4,d0
	bne	so5
	lea	sound4,a1
	move.l	a1,currentsound
	bsr	setupdisplay
	move.l	#10320,d0
	bra	invertsquare
so5:
	cmpi.w	#5,d0
	bne	so6
	lea	sound5,a1
	move.l	a1,currentsound
	bsr	setupdisplay
	move.l	#12880,d0
	bra	invertsquare
so6:
	cmpi.w	#6,d0
	bne	so7
	lea	sound6,a1
	move.l	a1,currentsound
	bsr	setupdisplay
	move.l	#15440,d0
	bra	invertsquare
so7:
	cmpi.w	#7,d0
	bne	so8
	lea	sound7,a1
	move.l	a1,currentsound
	bsr	setupdisplay
	move.l	#18000,d0
	bra	invertsquare
so8:
	cmpi.w	#8,d0
	bne	so9
	lea	sound8,a1
	move.l	a1,currentsound
	bsr	setupdisplay
	move.l	#20560,d0
	bra	invertsquare
so9:
*	cmpi.w	#1,d0
*	bne	so1
	lea	sound9,a1
	move.l	a1,currentsound
	bsr	setupdisplay
	move.l	#23120,d0
	bra	invertsquare
savesub:
	bsr	copytolast
	move.w	#2,-(sp)	;load an entire bank 10 possible
	move.w	#2,-(sp)	;numbered 0-9
	trap	#13
	addq.l	#4,sp
	cmpi.w	#27,d0
	beq	cancells
	cmpi.w  #48,d0
	blt	loadsub
	cmpi.w	#57,d0
	bgt	loadsub
	lea	filesounds,a0
	move.b	d0,6(a0)
	bsr	savebank
	rts
loadsub:
	move.w	#2,-(sp)	;load an entire bank 10 possible
	move.w	#2,-(sp)	;numbered 0-9
	trap	#13
	addq.l	#4,sp
	cmpi.w	#27,d0
	beq	cancells
	cmpi.w  #48,d0
	blt	loadsub
	cmpi.w	#57,d0
	bgt	loadsub
	lea	filesounds,a0
	move.b	d0,6(a0)
	bsr	loadbank
	bsr	setupdisplay
cancells:
	rts
filesounds:	dc.b	'sndbnk0.dat',0
even
noprocess:	dc.w	-1
asmsavesub:
	move.w	#1,noprocess
	bsr	prepsub
	cmpi.b	#0,channelbyte2
	bne	start1a
	lea	channel0params,a6
	move.w	#0,channelprocess(a6)
	bra	startita
start1a:
	cmpi.b	#1,channelbyte2
	bne	start2a
	lea	channel1params,a6
	move.w	#1,channelprocess(a6)
	bra	startita
start2a:
	lea	channel2params,a6
	move.w	#2,channelprocess(a6)
startita:
	move.l	a6,-(sp)
	lea	bl1,a0
	addq.l	#1,a0
	move.l	a0,a1
	bsr	doasm
	lea	bl2,a0
	addq.l	#1,a0
	move.l	a0,a1
	bsr	doasm
	lea	bl3,a0
	addq.l	#1,a0
	move.l	a0,a1
	bsr	doasm
	lea	bl4,a0
	addq.l	#1,a0
	move.l	a0,a1
	bsr	doasm
wa:
	move.w	#2,-(sp)	;load an entire bank 10 possible
	move.w	#2,-(sp)	;numbered 0-9
	trap	#13
	addq.l	#4,sp
	cmpi.w	#27,d0
	beq	cancelasm
	cmpi.w  #48,d0
	blt	wa
	cmpi.w	#57,d0
	bgt	wa
	lea	fileasm,a0
	move.b	d0,6(a0)
	bsr	writeasm
cancelasm:
	move.l	(sp)+,a6
	move.w	#-1,channelprocess(a6)
	move.w	#-1,noprocess
	rts
fileasm:
	dc.b	'sndasm0.s',0
even
doasm:
	moveq	#0,d0
	move.w	(a6)+,d0
	moveq	#16,d1		;hex base
	bsr	prtnum2
	addq.l	#6,a1
	move.l	a1,a0
	moveq	#0,d0
	move.w	(a6)+,d0
	moveq	#16,d1		;hex base
	bsr	prtnum2
	addq.l	#6,a1
	move.l	a1,a0
	moveq	#0,d0
	move.w	(a6)+,d0
	moveq	#16,d1		;hex base
	bsr	prtnum2
	addq.l	#6,a1
	move.l	a1,a0
	moveq	#0,d0
	move.w	(a6)+,d0
	moveq	#16,d1		;hex base
	bsr	prtnum2
	addq.l	#6,a1
	move.l	a1,a0
	moveq	#0,d0
	move.w	(a6)+,d0
	moveq	#16,d1		;hex base
	bsr	prtnum2
	addq.l	#6,a1
	move.l	a1,a0
	rts

invertsquare:
	move.l	seen,a0
	tst.l	lastsound
	bmi	nolasti
	add.l	lastsound,a0
	bsr	doeor
nolasti:
	move.l	seen,a0
	move.l	d0,lastsound
	add.l	d0,a0
	bsr	doeor
	move.w	#-1,pointeronoff
	rts


setupdisplay:
	move.l	currentsound,a0
	lea	currentbytes,a1
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	move.l	(a0)+,(a1)+
	bsr	dowave
	bsr	dolife
	bsr	dospeed
	bsr	dofine
	bsr	docoarse
	bsr	donoise
	bsr	doreg
	bsr	doadd
	bsr	docmp
	bsr	dochan
	bsr	dovol
	rts

copytolast:
	lea	currentbytes,a2
	move.l	currentsound,a3
	move.l	(a2)+,(a3)+
	move.l	(a2)+,(a3)+
	move.l	(a2)+,(a3)+
	move.l	(a2)+,(a3)+
	rts

doeor:
	eor.l	#-1,(a0)+
	eor.l	#-1,(a0)+
	lea	160-8(a0),a0
	eor.l	#-1,(a0)+
	eor.l	#-1,(a0)+
	lea	160-8(a0),a0
	eor.l	#-1,(a0)+
	eor.l	#-1,(a0)+
	lea	160-8(a0),a0
	eor.l	#-1,(a0)+
	eor.l	#-1,(a0)+
	lea	160-8(a0),a0
	eor.l	#-1,(a0)+
	eor.l	#-1,(a0)+
	lea	160-8(a0),a0
	eor.l	#-1,(a0)+
	eor.l	#-1,(a0)+
	lea	160-8(a0),a0
	eor.l	#-1,(a0)+
	eor.l	#-1,(a0)+
	lea	160-8(a0),a0
	eor.l	#-1,(a0)+
	eor.l	#-1,(a0)+
	lea	160-8(a0),a0
	eor.l	#-1,(a0)+
	eor.l	#-1,(a0)+
	lea	160-8(a0),a0
	eor.l	#-1,(a0)+
	eor.l	#-1,(a0)+
	lea	160-8(a0),a0
	eor.l	#-1,(a0)+
	eor.l	#-1,(a0)+
	lea	160-8(a0),a0
	eor.l	#-1,(a0)+
	eor.l	#-1,(a0)+
	lea	160-8(a0),a0
	eor.l	#-1,(a0)+
	eor.l	#-1,(a0)+
	lea	160-8(a0),a0
	eor.l	#-1,(a0)+
	eor.l	#-1,(a0)+
	lea	160-8(a0),a0
	eor.l	#-1,(a0)+
	eor.l	#-1,(a0)+
	lea	160-8(a0),a0
	eor.l	#-1,(a0)+
	eor.l	#-1,(a0)+
	rts

currentbytes:
channelbyte2:	dc.b	0
wavebyte2:	dc.b	0
lifebyte:	dc.b	0
speedbyte:	dc.b	0
finebyte:	dc.b	0
coarsebyte:	dc.b	0
noisebyte:	dc.b	0
regbyte2:	dc.b	0
regbyte3:	dc.b	0
addbyte:	dc.b	0
cmpbyte:	dc.b	0
regbyte:	dc.b	0
wavebyte:	dc.b	0
channelbyte:	dc.b	0
volumebyte:	dc.b	0
pad:		dc.b	0
	even
mysoundbank:
sound0:		blk.b	16,0
sound1:		blk.b	16,0
sound2:		blk.b	16,0
sound3:		blk.b	16,0
sound4:		blk.b	16,0
sound5:		blk.b	16,0
sound6:		blk.b	16,0
sound7:		blk.b	16,0
sound8:		blk.b	16,0
sound9:		blk.b	16,0

currentsound:	dc.l	sound0
lastsound:	dc.l	-1

coordlist:
	dc.w	85-1
	dc.w	16,8,24,16	;waveform
	dc.w	-15		;first info byte
	dc.l	waveformsub	;address of rout to handle it
	dc.w	24,8,32,16
	dc.w	0		;first info byte
	dc.l	waveformsub	;address of rout to handle it
	dc.w	32,8,40,16
	dc.w	1
	dc.l	waveformsub
	dc.w	40,8,48,16
	dc.w	2
	dc.l	waveformsub
	dc.w	48,8,56,16
	dc.w	3
	dc.l	waveformsub
	dc.w	56,8,64,16
	dc.w	4
	dc.l	waveformsub

	dc.w	0,24,8,32	;life
	dc.w	7
	dc.l	lifesub
	dc.w	8,24,16,32
	dc.w	6
	dc.l	lifesub
	dc.w	16,24,24,32
	dc.w	5
	dc.l	lifesub
	dc.w	24,24,32,32
	dc.w	4
	dc.l	lifesub
	dc.w	32,24,40,32
	dc.w	3
	dc.l	lifesub
	dc.w	40,24,48,32
	dc.w	2
	dc.l	lifesub
	dc.w	48,24,56,32
	dc.w	1
	dc.l	lifesub
	dc.w	56,24,64,32
	dc.w	0
	dc.l	lifesub

	dc.w	0,40,8,48	;speed of change
	dc.w	7
	dc.l	speedsub
	dc.w	8,40,16,48
	dc.w	6
	dc.l	speedsub
	dc.w	16,40,24,48
	dc.w	5
	dc.l	speedsub
	dc.w	24,40,32,48
	dc.w	4
	dc.l	speedsub
	dc.w	32,40,40,48
	dc.w	3
	dc.l	speedsub
	dc.w	40,40,48,48
	dc.w	2
	dc.l	speedsub
	dc.w	48,40,56,48
	dc.w	1
	dc.l	speedsub
	dc.w	56,40,64,48
	dc.w	0
	dc.l	speedsub

	dc.w	0,56,8,64	;fine tune
	dc.w	7
	dc.l	finesub
	dc.w	8,56,16,64
	dc.w	6
	dc.l	finesub
	dc.w	16,56,24,64
	dc.w	5
	dc.l	finesub
	dc.w	24,56,32,64
	dc.w	4
	dc.l	finesub
	dc.w	32,56,40,64
	dc.w	3
	dc.l	finesub
	dc.w	40,56,48,64
	dc.w	2
	dc.l	finesub
	dc.w	48,56,56,64
	dc.w	1
	dc.l	finesub
	dc.w	56,56,64,64
	dc.w	0
	dc.l	finesub

	dc.w	32,72,40,80	;coarse tune
	dc.w	3
	dc.l	coarsesub
	dc.w	40,72,48,80
	dc.w	2
	dc.l	coarsesub
	dc.w	48,72,56,80
	dc.w	1
	dc.l	coarsesub
	dc.w	56,72,64,80
	dc.w	0
	dc.l	coarsesub

	dc.w	0,88,8,96	;noise
	dc.w	7
	dc.l	noisesub
	dc.w	8,88,16,96
	dc.w	6
	dc.l	noisesub
	dc.w	16,88,24,96
	dc.w	5
	dc.l	noisesub
	dc.w	24,88,32,96
	dc.w	4
	dc.l	noisesub
	dc.w	32,88,40,96
	dc.w	3
	dc.l	noisesub
	dc.w	40,88,48,96
	dc.w	2
	dc.l	noisesub
	dc.w	48,88,56,96
	dc.w	1
	dc.l	noisesub
	dc.w	56,88,64,96
	dc.w	0
	dc.l	noisesub

	dc.w	32,104,40,112	;register num
	dc.w	3
	dc.l	regsub
	dc.w	40,104,48,112
	dc.w	2
	dc.l	regsub
	dc.w	48,104,56,112
	dc.w	1
	dc.l	regsub
	dc.w	56,104,64,112
	dc.w	0
	dc.l	regsub

	dc.w	0,120,8,128	;value to add
	dc.w	7
	dc.l	addsub
	dc.w	8,120,16,128
	dc.w	6
	dc.l	addsub
	dc.w	16,120,24,128
	dc.w	5
	dc.l	addsub
	dc.w	24,120,32,128
	dc.w	4
	dc.l	addsub
	dc.w	32,120,40,128
	dc.w	3
	dc.l	addsub
	dc.w	40,120,48,128
	dc.w	2
	dc.l	addsub
	dc.w	48,120,56,128
	dc.w	1
	dc.l	addsub
	dc.w	56,120,64,128
	dc.w	0
	dc.l	addsub

	dc.w	0,136,8,144	;value to cmp
	dc.w	7
	dc.l	cmpsub
	dc.w	8,136,16,144
	dc.w	6
	dc.l	cmpsub
	dc.w	16,136,24,144
	dc.w	5
	dc.l	cmpsub
	dc.w	24,136,32,144
	dc.w	4
	dc.l	cmpsub
	dc.w	32,136,40,144
	dc.w	3
	dc.l	cmpsub
	dc.w	40,136,48,144
	dc.w	2
	dc.l	cmpsub
	dc.w	48,136,56,144
	dc.w	1
	dc.l	cmpsub
	dc.w	56,136,64,144
	dc.w	0
	dc.l	cmpsub


	dc.w	40,152,48,160		;channel
	dc.w	2
	dc.l	chansub
	dc.w	48,152,56,160
	dc.w	1
	dc.l	chansub
	dc.w	56,152,64,160
	dc.w	0
	dc.l	chansub

	dc.w	32,168,40,176	;constant volume
	dc.w	3
	dc.l	volsub
	dc.w	40,168,48,176
	dc.w	2
	dc.l	volsub
	dc.w	48,168,56,176
	dc.w	1
	dc.l	volsub
	dc.w	56,168,64,176
	dc.w	0
	dc.l	volsub

	dc.w	0,183,16,199	;play
	dc.w	0
	dc.l	playsub

	dc.w	32,183,48,199	;stop
	dc.w	7
	dc.l	stopsub

	dc.w	64,183,80,199	;stop
	dc.w	7
	dc.l	prepsub

	dc.w	160,0,176,16	;sound 1
	dc.w	0
	dc.l	soundsub
	dc.w	160,16,176,32
	dc.w	1
	dc.l	soundsub
	dc.w	160,32,176,48
	dc.w	2
	dc.l	soundsub
	dc.w	160,48,176,64
	dc.w	3
	dc.l	soundsub
	dc.w	160,64,176,80
	dc.w	4
	dc.l	soundsub
	dc.w	160,80,176,96
	dc.w	5
	dc.l	soundsub
	dc.w	160,96,176,112
	dc.w	6
	dc.l	soundsub
	dc.w	160,112,176,128
	dc.w	7
	dc.l	soundsub
	dc.w	160,128,176,144
	dc.w	8
	dc.l	soundsub
	dc.w	160,144,176,160
	dc.w	9
	dc.l	soundsub

	dc.w	208,48,224,64	;save
	dc.w	0
	dc.l	savesub
	dc.w	208,72,224,88	;load
	dc.w	0
	dc.l	loadsub
	dc.w	208,112,224,128	;load
	dc.w	0
	dc.l	asmsavesub



whichpointer:	dc.l	arrowsp
pointeronoff:	dc.w	-1
oldvblvec:	blk.l	1,0
oldkeyvec:	blk.l	1,0
even


*************************************
leftbutton:	equ	1
rightbutton:	equ	2
bothbuttons:	equ	3
**********************************
clearboth:
	move.l	seen,a0
	move.l	hiden,a1
	move.w	#15999,d0
cbl:
	move.w	#0,(a0)+
	move.w	#0,(a1)+
	dbf	d0,cbl
	rts
*****************************************
copyintoboth:
	move.w	#1,pointeronoff
twaitcb:
	tst.w	pointeronoff	;make sure background is restored
	bne	twaitcb

	move.l	screen3,a0
	move.l	hiden,a1
	move.l	seen,a2
	move.w	#7999,d0
cibloop:
	move.l	(a0),(a1)+
	move.l	(a0)+,(a2)+
	dbf	d0,cibloop
	move.w	#-1,pointeronoff
	rts
clear:	dc.w	1
****************************************
keyboard:
	move.l	keybuf,a0
	move.w	6(a0),d0
	cmp.w	8(a0),d0
	bne	ischar
	rts
ischar:
	move.w	#2,-(sp)
	move.w	#2,-(sp)
	trap	#13
	addq.l	#4,sp
	swap	d0
quit:	cmpi.w  #$10,d0
	bne	spacebar
	bra	gem
spacebar:
	cmpi.w  #$39,d0
	bne	keyplay
	addq.w	#4,pointerad
	cmpi.w	#12,pointerad
	blt	pok
	move.w	#0,pointerad
pok:
	lea	pointerlist,a0
	move.w	pointerad,d0
	move.l	(a0,d0.w),whichpointer
	rts
keyplay:
	cmpi.w	#$3b,d0
	bne	keyback
	bsr	prepsub
	bsr	playsub
	rts
keyback:
	rts

pointerlist:
	dc.l	arrowsp,emptyhandsp,filledhandsp
pointerad:	dc.w	0
***********************************
mydocolors:
	move.l	#$ff8240,a1
	moveq	#15,d0
mdcloop:
	move.w	(a0)+,(a1)+
	dbf	d0,mdcloop
	rts

************get screen address***************
getscrn:move.w  #2,-(sp)
        trap    #14
        addq.l  #2,sp
        move.l  d0,screen
        move.l  d0,screen1
        move.l  d0,screen2
        subi.l  #$8000,screen2
        move.l  screen1,seen
        move.l  screen2,hiden
	move.l	screen2,screen3
	subi.l	#$8000,screen3
	rts
screen1:	dc.l	0
screen2:	dc.l	0
screen3:	dc.l	0
generalstore:	dc.l	0
seen:	dc.l	0
hiden:	dc.l	0
screen:	dc.l	0

*************************************
clearquick:
	tst.w	clear
	bmi	noclear
	move.l	hiden,a0
	lea	2080(a0),a0
	move	#186,d0
	moveq	#0,d6
cl2loop:
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	move.l	d6,(a0)+
	dbf	d0,cl2loop
noclear:
	rts

numvbl:		dc.w	0
frames:		dc.w	0
framess:		dc.w	0
*****************************************
*	number in d0.l			*
*	d1.l is base			*
*	d2,x cursor			*
*	d3,y cursor			*
*****************************************
prtnum:
	movem.l	d0/d1,-(sp)
	lea	posstring,a0
	add.w	#32,d3
	move.b	d3,2(a0)	
	move.b	d3,8(a0)	
	add.w	#32,d2
	move.b	d2,3(a0)
	move.b	d2,9(a0)	
	move.l	a0,-(sp)
	move.w	#9,-(sp)
	trap	#1
	addq.l	#6,sp
	movem.l	(sp)+,d0/d1

	lea	linebuffer,a0
	clr.l	(a0)+
	clr.l	(a0)+
	clr.l	(a0)+
	clr.l	(a0)+
	clr.l	(a0)+
loop1:
	divu	d1,d0
	swap	d0
	addi	#'0',d0
	cmpi.w	#'9',d0
	ble.s	ok
	addq.w	#7,d0
ok:
	move.b	d0,-(a0)
	clr	d0
	swap	d0
	bne	loop1
loop2:
	move.l	a0,-(sp)
	move.w	#9,-(sp)
	trap	#1
	addq.l	#6,sp
	rts


linebuffer:
	blk.l	5,0
digits:
	dc.b	0
posstring:	dc.b	27,'Y',0,0,' ',' ',27,'Y',0,0,0
even

asmblock:
	dc.b	9,'dc.w',9,
bl1:	dc.b	'$',0,0,0,0,',','$',0,0,0,0,',','$',0,0,0,0,',',
	dc.b	'$',0,0,0,0,',','$',0,0,0,0,',',13
	dc.b	9,'dc.w',9,
bl2:	dc.b	'$',0,0,0,0,',','$',0,0,0,0,',','$',0,0,0,0,',',
	dc.b	'$',0,0,0,0,',','$',0,0,0,0,',',13
	dc.b	9,'dc.w',9,
bl3:	dc.b	'$',0,0,0,0,',','$',0,0,0,0,',','$',0,0,0,0,',',
	dc.b	'$',0,0,0,0,',','$',0,0,0,0,',',13
	dc.b	9,'dc.w',9,
bl4:	dc.b	'$',0,0,0,0,',','$',0,0,0,0,',','$',0,0,0,0,',',
	dc.b	'$',0,0,0,0,',','$',0,0,0,0,',',13
asmbend:

*****************************************
*	number in d0.l			*
*	d1.l is base			*
*	a0 is add to put chars		*
*****************************************
prtnum2:
	move.b	#'0',(a0)+
	move.b	#'0',(a0)+
	move.b	#'0',(a0)+
	move.b	#'0',(a0)+
loops:
	divu	d1,d0
	swap	d0
	addi	#'0',d0
	cmpi.w	#'9',d0
	ble.s	oks
	addq.w	#7,d0
oks:
	move.b	d0,-(a0)
	clr	d0
	swap	d0
	bne	loops
	rts

rnd:	blk.l	5,0
*******************************************************************
randomseed:     ADD.L   D0,D1           ;user seed in d0 (d1 too)
                MOVEM.L D0/D1,RND
; drops through to the main random function (not user callable)
LongRnd:        MOVEM.L D2-D3,-(SP)     
                MOVEM.L RND,D0/D1       ;D0=LSB's, D1=MSB's of random number
                ANDI.B  #$0E,D0         ;ensure upper 59 bits are an...
                ORI.B   #$20,D0         ;...odd binary number
                MOVE.L  D0,D2
                MOVE.L  D1,D3
                ADD.L   D2,D2           ;accounts for 1 of 17 left shifts
                ADDX.L  D3,D3           ;[D2/D3] = RND*2
                ADD.L   D2,D0
                ADDX.L  D3,D1           ;[D0/D1] = RND*3
                SWAP    D3              ;shift [D2/D3] additional 16 times
                SWAP    D2
                MOVE.W  D2,D3
                CLR.W   D2
                ADD.L   D2,D0           ;add to [D0/D1]
                ADDX.L  D3,D1
                MOVEM.L D0/D1,RND       ;save for next time through
                MOVE.L  D1,D0           ;most random part to D0
                MOVEM.L (SP)+,D2-D3
                RTS
random:         MOVE.w  D2,-(SP)
                MOVE.W  D0,D2           ;save upper limit
                BEQ.S   r1              ;range of 0 returns 0 always
                BSR.S   LongRnd         ;get a longword random number
                CLR.W   D0              ;use upper word (it's most random)
                SWAP    D0
                ext.l   d0
                DIVs    D2,D0           ;divide by range...
                CLR.W   D0              ;...and use remainder for the value
                SWAP    D0              ;result in D0.W
r1:             MOVE.w  (SP)+,D2
                RTS

randomplus:     MOVE.w  D2,-(SP)
                MOVE.W  D0,D2           ;save upper limit
                BEQ.S   r2              ;range of 0 returns 0 always
                BSR.S   LongRnd         ;get a longword random number
                CLR.W   D0              ;use upper word (it's most random)
                SWAP    D0
                DIVu    D2,D0           ;divide by range...
                CLR.W   D0              ;...and use remainder for the value
                SWAP    D0              ;result in D0.W
r2:             MOVE.w  (SP)+,D2
                RTS




safe:	dc.w	0
lineout:	blk.l	5
times:		dc.w	0
number:		dc.w	0
numwhere:	dc.w	0
palsave:	blk.w	16,0
******************************************
*               RETURN TO GEM
gem:

	move.b	#%11111110,$ff820a
	move.l	oldvblvec,vbl_vec
	move.l	#$ff8240,a0
	lea	palsave,a1
	moveq	#15,d7
rspl:
	move.w	(a1)+,d0
	and.w	#$0777,d0
	move.w	d0,(a0)+
	dbf	d7,rspl


        move.b  #7,$484

	move.w  #34,-(sp)
        trap    #14
        addq.l  #2,sp
        move.l  d0,a0
	move.l	oldmouse,16(a0)

        move.w  ressave,-(sp)
        move.l  screen,-(sp)
        move.l  screen,-(sp)
        move.w  #5,-(sp)
        trap    #14
        addi.l  #12,sp

	move.l	rvsave,$426
	move.l	resave,$42a
        
        move.l  savesup,-(SP)    ;Back to user mode
        move.w  #$20,-(SP)
        trap    #1
        addq.l  #6,SP
illegal
	clr.w	-(sp)
	trap	#1

rvsave:	dc.l	0
resave:	dc.l	0

***************************************
oldmouse:	blk.l	1,0
*************puts my mouse interupt in***************** 
putrout:move.w  #34,-(sp)
        trap    #14
        addq.l  #2,sp
        move.l  d0,a0
	move.l	16(a0),oldmouse
        move.l  #myrout,16(a0)
        rts
lastb:		dc.w	-1
**************my ubeut mouse interupt*******************
myrout:
	movem.l	d0-d2/a0-a1,-(sp)
	moveq	#0,d0	
	move.b	(a0),d0
	cmpi.b	#$fa,d0
	bne	myr1
	move.w	#1,buttondat
	bra	myrxy
myr1:
	cmpi.b	#$f9,d0
	bne	myr2
	move.w	#2,buttondat
	bra	myrxy
myr2:
	cmpi.b	#$fb,d0
	bne	myr3
	move.w	#3,buttondat
	bra	myrxy
myr3:
	move.w	#0,buttondat
myrxy:
	moveq	#0,d0
	move.b	1(a0),d0
	ext.w	d0
	moveq	#0,d1
	move.b	2(a0),d1
	ext.w	d1
*	lsl.w	#6,d0
*	lsl.w	#6,d1
	add.w	d0,mx
	add.w	d1,my
	sub.w	d1,my2
myr4:	move.w	mx,d0
	move.w	my,d1
	bsr	extra
	move.w	d0,mx
	move.w	d1,my
	movem.l	(sp)+,d0-d2/a0-a1
	rts

extra:  cmpi.w	#mminx,d0
        bge    .S extra1
        move.w	#mminx,d0
        bra    .S extra2
extra1: cmpi.w   #mmaxx,d0
        ble    .S extra2
        move.w  #mmaxx,d0
extra2:	cmpi.w  #mminy,d1
        bge    .S extra3
        move.w  #mminy,d1
        bra	extra4
extra3: cmpi.w   #mmaxy,d1
        ble    .S extra4
        move.w  #mmaxy,d1
extra4:
        rts

buttondat:	dc.w	0
mx:		dc.w	160
my:		dc.w	100
my2:		dc.w	0
mminx:	equ	1
mmaxx:	equ	319
mminy:	equ	0
mmaxy:	equ	199
even
savesup:	dc.l	0
ressave:	dc.w	0
filename:	dc.l	0
toppalette:
	dc.w	$0000,$0777,$0007,$0222,$0040,$0170,$0007,$0166
	dc.w	$0706,$0507,$0420,$0765,$00cc,$00bb,$0066,$00ff

smallnumbers:
	 dc.b	$00,$00,$44,$7C,$00,$00,$AA,$EE
	 dc.b	$00,$00,$54,$DE,$00,$00,$28,$BA
	 dc.b	$00,$00,$54,$F6,$00,$00,$AA,$EE
	 dc.b	$00,$00,$44,$7C,$00,$00,$20,$30
	 dc.b	$00,$00,$40,$70,$00,$00,$20,$30
	 dc.b	$00,$00,$00,$10,$00,$00,$00,$10
	 dc.b	$00,$00,$28,$38,$00,$00,$44,$7C
	 dc.b	$00,$00,$82,$FE,$00,$00,$44,$C6
	 dc.b	$00,$00,$04,$06,$00,$00,$82,$FE
	 dc.b	$00,$00,$40,$C0,$00,$00,$40,$C0
	 dc.b	$00,$00,$00,$FE,$00,$00,$82,$FE
	 dc.b	$00,$00,$44,$C6,$00,$00,$04,$06
	 dc.b	$00,$00,$22,$3E,$00,$00,$04,$06
	 dc.b	$00,$00,$44,$C6,$00,$00,$82,$FE
	 dc.b	$00,$00,$10,$1C,$00,$00,$28,$3C
	 dc.b	$00,$00,$50,$74,$00,$00,$AA,$EE
	 dc.b	$00,$00,$00,$FE,$00,$00,$0A,$0E
	 dc.b	$00,$00,$00,$04,$00,$00,$00,$FE
	 dc.b	$00,$00,$40,$C0,$00,$00,$40,$C0
	 dc.b	$00,$00,$82,$FE,$00,$00,$04,$06
	 dc.b	$00,$00,$04,$06,$00,$00,$02,$FE
	 dc.b	$00,$00,$82,$FE,$00,$00,$44,$C6
	 dc.b	$00,$00,$40,$C0,$00,$00,$02,$FE
	 dc.b	$00,$00,$44,$C6,$00,$00,$44,$C6
	 dc.b	$00,$00,$82,$FE,$00,$00,$00,$FE
	 dc.b	$00,$00,$04,$06,$00,$00,$0A,$0E
	 dc.b	$00,$00,$14,$1C,$00,$00,$28,$38
	 dc.b	$00,$00,$50,$70,$00,$00,$20,$60
	 dc.b	$00,$00,$82,$FE,$00,$00,$44,$C6
	 dc.b	$00,$00,$44,$C6,$00,$00,$82,$FE
	 dc.b	$00,$00,$44,$C6,$00,$00,$44,$C6
	 dc.b	$00,$00,$82,$FE,$00,$00,$82,$FE
	 dc.b	$00,$00,$40,$C2,$00,$00,$44,$C6
	 dc.b	$00,$00,$80,$FE,$00,$00,$04,$06
	 dc.b	$00,$00,$04,$06,$00,$00,$82,$FE

even
keybuf:	dc.l	0

arrow:
	DC.W	$7FFF,$0000,$8000,$8000,$8000,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$3FFF,$4000,$4000,$C000,$C000,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$1FFF,$A000,$6000,$E000
	DC.W	$E000,$FFFF,$0000,$0000,$0000,$0000,$0FFF,$9000
	DC.W	$3000,$F000,$F000,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$07FF,$8800,$3800,$F800,$F800,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$03FF,$8400,$1C00,$FC00,$FC00,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$01FF,$8200,$1E00,$FE00
	DC.W	$FE00,$FFFF,$0000,$0000,$0000,$0000,$00FF,$8100
	DC.W	$0F00,$FF00,$FF00,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$07FF,$8000,$0800,$F800,$F800,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$27FF,$8000,$0800,$D800,$D800,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$73FF,$8000,$0400,$8C00
	DC.W	$8C00,$FFFF,$0000,$0000,$0000,$0000,$F3FF,$0000
	DC.W	$0400,$0C00,$0C00,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$F9FF,$0000,$0200,$0600,$0600,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$F9FF,$0000,$0200,$0600,$0600,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$FFFF,$0000,$0000,$0000,$0000,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$BFFF,$0000,$4000,$4000,$4000,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$9FFF,$2000,$2000,$6000,$6000,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$8FFF,$5000,$3000,$7000
	DC.W	$7000,$FFFF,$0000,$0000,$0000,$0000,$87FF,$4800
	DC.W	$1800,$7800,$7800,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$83FF,$4400,$1C00,$7C00,$7C00,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$81FF,$4200,$0E00,$7E00,$7E00,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$80FF,$4100,$0F00,$7F00
	DC.W	$7F00,$FFFF,$0000,$0000,$0000,$0000,$807F,$4080
	DC.W	$0780,$7F80,$7F80,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$83FF,$4000,$0400,$7C00,$7C00,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$93FF,$4000,$0400,$6C00,$6C00,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$B9FF,$4000,$0200,$4600
	DC.W	$4600,$FFFF,$0000,$0000,$0000,$0000,$F9FF,$0000
	DC.W	$0200,$0600,$0600,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FCFF,$0000,$0100,$0300,$0300,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FCFF,$0000,$0100,$0300,$0300,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$FFFF,$0000,$0000,$0000,$0000,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$DFFF,$0000,$2000,$2000,$2000,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$CFFF,$1000,$1000,$3000,$3000,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$C7FF,$2800,$1800,$3800
	DC.W	$3800,$FFFF,$0000,$0000,$0000,$0000,$C3FF,$2400
	DC.W	$0C00,$3C00,$3C00,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$C1FF,$2200,$0E00,$3E00,$3E00,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$C0FF,$2100,$0700,$3F00,$3F00,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$C07F,$2080,$0780,$3F80
	DC.W	$3F80,$FFFF,$0000,$0000,$0000,$0000,$C03F,$2040
	DC.W	$03C0,$3FC0,$3FC0,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$C1FF,$2000,$0200,$3E00,$3E00,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$C9FF,$2000,$0200,$3600,$3600,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$DCFF,$2000,$0100,$2300
	DC.W	$2300,$FFFF,$0000,$0000,$0000,$0000,$FCFF,$0000
	DC.W	$0100,$0300,$0300,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FE7F,$0000,$0080,$0180,$0180,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FE7F,$0000,$0080,$0180,$0180,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$FFFF,$0000,$0000,$0000,$0000,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$EFFF,$0000,$1000,$1000,$1000,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$E7FF,$0800,$0800,$1800,$1800,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$E3FF,$1400,$0C00,$1C00
	DC.W	$1C00,$FFFF,$0000,$0000,$0000,$0000,$E1FF,$1200
	DC.W	$0600,$1E00,$1E00,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$E0FF,$1100,$0700,$1F00,$1F00,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$E07F,$1080,$0380,$1F80,$1F80,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$E03F,$1040,$03C0,$1FC0
	DC.W	$1FC0,$FFFF,$0000,$0000,$0000,$0000,$E01F,$1020
	DC.W	$01E0,$1FE0,$1FE0,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$E0FF,$1000,$0100,$1F00,$1F00,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$E4FF,$1000,$0100,$1B00,$1B00,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$EE7F,$1000,$0080,$1180
	DC.W	$1180,$FFFF,$0000,$0000,$0000,$0000,$FE7F,$0000
	DC.W	$0080,$0180,$0180,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FF3F,$0000,$0040,$00C0,$00C0,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FF3F,$0000,$0040,$00C0,$00C0,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$FFFF,$0000,$0000,$0000,$0000,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$F7FF,$0000,$0800,$0800,$0800,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$F3FF,$0400,$0400,$0C00,$0C00,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$F1FF,$0A00,$0600,$0E00
	DC.W	$0E00,$FFFF,$0000,$0000,$0000,$0000,$F0FF,$0900
	DC.W	$0300,$0F00,$0F00,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$F07F,$0880,$0380,$0F80,$0F80,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$F03F,$0840,$01C0,$0FC0,$0FC0,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$F01F,$0820,$01E0,$0FE0
	DC.W	$0FE0,$FFFF,$0000,$0000,$0000,$0000,$F00F,$0810
	DC.W	$00F0,$0FF0,$0FF0,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$F07F,$0800,$0080,$0F80,$0F80,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$F27F,$0800,$0080,$0D80,$0D80,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$F73F,$0800,$0040,$08C0
	DC.W	$08C0,$FFFF,$0000,$0000,$0000,$0000,$FF3F,$0000
	DC.W	$0040,$00C0,$00C0,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FF9F,$0000,$0020,$0060,$0060,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FF9F,$0000,$0020,$0060,$0060,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$FFFF,$0000,$0000,$0000,$0000,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FBFF,$0000,$0400,$0400,$0400,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$F9FF,$0200,$0200,$0600,$0600,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$F8FF,$0500,$0300,$0700
	DC.W	$0700,$FFFF,$0000,$0000,$0000,$0000,$F87F,$0480
	DC.W	$0180,$0780,$0780,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$F83F,$0440,$01C0,$07C0,$07C0,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$F81F,$0420,$00E0,$07E0,$07E0,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$F80F,$0410,$00F0,$07F0
	DC.W	$07F0,$FFFF,$0000,$0000,$0000,$0000,$F807,$0408
	DC.W	$0078,$07F8,$07F8,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$F83F,$0400,$0040,$07C0,$07C0,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$F93F,$0400,$0040,$06C0,$06C0,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FB9F,$0400,$0020,$0460
	DC.W	$0460,$FFFF,$0000,$0000,$0000,$0000,$FF9F,$0000
	DC.W	$0020,$0060,$0060,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FFCF,$0000,$0010,$0030,$0030,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FFCF,$0000,$0010,$0030,$0030,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$FFFF,$0000,$0000,$0000,$0000,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FDFF,$0000,$0200,$0200,$0200,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FCFF,$0100,$0100,$0300,$0300,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FC7F,$0280,$0180,$0380
	DC.W	$0380,$FFFF,$0000,$0000,$0000,$0000,$FC3F,$0240
	DC.W	$00C0,$03C0,$03C0,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FC1F,$0220,$00E0,$03E0,$03E0,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FC0F,$0210,$0070,$03F0,$03F0,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FC07,$0208,$0078,$03F8
	DC.W	$03F8,$FFFF,$0000,$0000,$0000,$0000,$FC03,$0204
	DC.W	$003C,$03FC,$03FC,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FC1F,$0200,$0020,$03E0,$03E0,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FC9F,$0200,$0020,$0360,$0360,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FDCF,$0200,$0010,$0230
	DC.W	$0230,$FFFF,$0000,$0000,$0000,$0000,$FFCF,$0000
	DC.W	$0010,$0030,$0030,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FFE7,$0000,$0008,$0018,$0018,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FFE7,$0000,$0008,$0018,$0018,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$FFFF,$0000,$0000,$0000,$0000,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FEFF,$0000,$0100,$0100,$0100,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FE7F,$0080,$0080,$0180,$0180,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FE3F,$0140,$00C0,$01C0
	DC.W	$01C0,$FFFF,$0000,$0000,$0000,$0000,$FE1F,$0120
	DC.W	$0060,$01E0,$01E0,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FE0F,$0110,$0070,$01F0,$01F0,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FE07,$0108,$0038,$01F8,$01F8,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FE03,$0104,$003C,$01FC
	DC.W	$01FC,$FFFF,$0000,$0000,$0000,$0000,$FE01,$0102
	DC.W	$001E,$01FE,$01FE,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FE0F,$0100,$0010,$01F0,$01F0,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FE4F,$0100,$0010,$01B0,$01B0,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FEE7,$0100,$0008,$0118
	DC.W	$0118,$FFFF,$0000,$0000,$0000,$0000,$FFE7,$0000
	DC.W	$0008,$0018,$0018,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FFF3,$0000,$0004,$000C,$000C,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FFF3,$0000,$0004,$000C,$000C,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$FFFF,$0000,$0000,$0000,$0000,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FF7F,$0000,$0080,$0080,$0080,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FF3F,$0040,$0040,$00C0,$00C0,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FF1F,$00A0,$0060,$00E0
	DC.W	$00E0,$FFFF,$0000,$0000,$0000,$0000,$FF0F,$0090
	DC.W	$0030,$00F0,$00F0,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FF07,$0088,$0038,$00F8,$00F8,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FF03,$0084,$001C,$00FC,$00FC,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FF01,$0082,$001E,$00FE
	DC.W	$00FE,$FFFF,$0000,$0000,$0000,$0000,$FF00,$0081
	DC.W	$000F,$00FF,$00FF,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FF07,$0080,$0008,$00F8,$00F8,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FF27,$0080,$0008,$00D8,$00D8,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FF73,$0080,$0004,$008C
	DC.W	$008C,$FFFF,$0000,$0000,$0000,$0000,$FFF3,$0000
	DC.W	$0004,$000C,$000C,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FFF9,$0000,$0002,$0006,$0006,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FFF9,$0000,$0002,$0006,$0006,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$FFFF,$0000,$0000,$0000,$0000,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FFBF,$0000,$0040,$0040,$0040,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FF9F,$0020,$0020,$0060,$0060,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FF8F,$0050,$0030,$0070
	DC.W	$0070,$FFFF,$0000,$0000,$0000,$0000,$FF87,$0048
	DC.W	$0018,$0078,$0078,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FF83,$0044,$001C,$007C,$007C,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FF81,$0042,$000E,$007E,$007E,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FF80,$0041,$000F,$007F
	DC.W	$007F,$FFFF,$0000,$0000,$0000,$0000,$FF80,$0040
	DC.W	$0007,$007F,$007F,$7FFF,$8000,$8000,$8000,$8000
	DC.W	$FF83,$0040,$0004,$007C,$007C,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FF93,$0040,$0004,$006C,$006C,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FFB9,$0040,$0002,$0046
	DC.W	$0046,$FFFF,$0000,$0000,$0000,$0000,$FFF9,$0000
	DC.W	$0002,$0006,$0006,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FFFC,$0000,$0001,$0003,$0003,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FFFC,$0000,$0001,$0003,$0003,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$FFFF,$0000,$0000,$0000,$0000,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FFDF,$0000,$0020,$0020,$0020,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FFCF,$0010,$0010,$0030,$0030,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FFC7,$0028,$0018,$0038
	DC.W	$0038,$FFFF,$0000,$0000,$0000,$0000,$FFC3,$0024
	DC.W	$000C,$003C,$003C,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FFC1,$0022,$000E,$003E,$003E,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FFC0,$0021,$0007,$003F,$003F,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FFC0,$0020,$0007,$003F
	DC.W	$003F,$7FFF,$8000,$8000,$8000,$8000,$FFC0,$0020
	DC.W	$0003,$003F,$003F,$3FFF,$4000,$C000,$C000,$C000
	DC.W	$FFC1,$0020,$0002,$003E,$003E,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FFC9,$0020,$0002,$0036,$0036,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FFDC,$0020,$0001,$0023
	DC.W	$0023,$FFFF,$0000,$0000,$0000,$0000,$FFFC,$0000
	DC.W	$0001,$0003,$0003,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FFFE,$0000,$0000,$0001,$0001,$7FFF,$0000,$8000
	DC.W	$8000,$8000,$FFFE,$0000,$0000,$0001,$0001,$7FFF
	DC.W	$0000,$8000,$8000,$8000,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$FFFF,$0000,$0000,$0000,$0000,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FFEF,$0000,$0010,$0010,$0010,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FFE7,$0008,$0008,$0018,$0018,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FFE3,$0014,$000C,$001C
	DC.W	$001C,$FFFF,$0000,$0000,$0000,$0000,$FFE1,$0012
	DC.W	$0006,$001E,$001E,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FFE0,$0011,$0007,$001F,$001F,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FFE0,$0010,$0003,$001F,$001F,$7FFF
	DC.W	$8000,$8000,$8000,$8000,$FFE0,$0010,$0003,$001F
	DC.W	$001F,$3FFF,$4000,$C000,$C000,$C000,$FFE0,$0010
	DC.W	$0001,$001F,$001F,$1FFF,$2000,$E000,$E000,$E000
	DC.W	$FFE0,$0010,$0001,$001F,$001F,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FFE4,$0010,$0001,$001B,$001B,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FFEE,$0010,$0000,$0011
	DC.W	$0011,$7FFF,$0000,$8000,$8000,$8000,$FFFE,$0000
	DC.W	$0000,$0001,$0001,$7FFF,$0000,$8000,$8000,$8000
	DC.W	$FFFF,$0000,$0000,$0000,$0000,$3FFF,$0000,$4000
	DC.W	$C000,$C000,$FFFF,$0000,$0000,$0000,$0000,$3FFF
	DC.W	$0000,$4000,$C000,$C000,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$FFFF,$0000,$0000,$0000,$0000,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FFF7,$0000,$0008,$0008,$0008,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FFF3,$0004,$0004,$000C,$000C,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FFF1,$000A,$0006,$000E
	DC.W	$000E,$FFFF,$0000,$0000,$0000,$0000,$FFF0,$0009
	DC.W	$0003,$000F,$000F,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FFF0,$0008,$0003,$000F,$000F,$7FFF,$8000,$8000
	DC.W	$8000,$8000,$FFF0,$0008,$0001,$000F,$000F,$3FFF
	DC.W	$4000,$C000,$C000,$C000,$FFF0,$0008,$0001,$000F
	DC.W	$000F,$1FFF,$2000,$E000,$E000,$E000,$FFF0,$0008
	DC.W	$0000,$000F,$000F,$0FFF,$1000,$F000,$F000,$F000
	DC.W	$FFF0,$0008,$0000,$000F,$000F,$7FFF,$0000,$8000
	DC.W	$8000,$8000,$FFF2,$0008,$0000,$000D,$000D,$7FFF
	DC.W	$0000,$8000,$8000,$8000,$FFF7,$0008,$0000,$0008
	DC.W	$0008,$3FFF,$0000,$4000,$C000,$C000,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$3FFF,$0000,$4000,$C000,$C000
	DC.W	$FFFF,$0000,$0000,$0000,$0000,$9FFF,$0000,$2000
	DC.W	$6000,$6000,$FFFF,$0000,$0000,$0000,$0000,$9FFF
	DC.W	$0000,$2000,$6000,$6000,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$FFFF,$0000,$0000,$0000,$0000,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FFFB,$0000,$0004,$0004,$0004,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FFF9,$0002,$0002,$0006,$0006,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FFF8,$0005,$0003,$0007
	DC.W	$0007,$FFFF,$0000,$0000,$0000,$0000,$FFF8,$0004
	DC.W	$0001,$0007,$0007,$7FFF,$8000,$8000,$8000,$8000
	DC.W	$FFF8,$0004,$0001,$0007,$0007,$3FFF,$4000,$C000
	DC.W	$C000,$C000,$FFF8,$0004,$0000,$0007,$0007,$1FFF
	DC.W	$2000,$E000,$E000,$E000,$FFF8,$0004,$0000,$0007
	DC.W	$0007,$0FFF,$1000,$F000,$F000,$F000,$FFF8,$0004
	DC.W	$0000,$0007,$0007,$07FF,$0800,$7800,$F800,$F800
	DC.W	$FFF8,$0004,$0000,$0007,$0007,$3FFF,$0000,$4000
	DC.W	$C000,$C000,$FFF9,$0004,$0000,$0006,$0006,$3FFF
	DC.W	$0000,$4000,$C000,$C000,$FFFB,$0004,$0000,$0004
	DC.W	$0004,$9FFF,$0000,$2000,$6000,$6000,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$9FFF,$0000,$2000,$6000,$6000
	DC.W	$FFFF,$0000,$0000,$0000,$0000,$CFFF,$0000,$1000
	DC.W	$3000,$3000,$FFFF,$0000,$0000,$0000,$0000,$CFFF
	DC.W	$0000,$1000,$3000,$3000,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$FFFF,$0000,$0000,$0000,$0000,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FFFD,$0000,$0002,$0002,$0002,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FFFC,$0001,$0001,$0003,$0003,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FFFC,$0002,$0001,$0003
	DC.W	$0003,$7FFF,$8000,$8000,$8000,$8000,$FFFC,$0002
	DC.W	$0000,$0003,$0003,$3FFF,$4000,$C000,$C000,$C000
	DC.W	$FFFC,$0002,$0000,$0003,$0003,$1FFF,$2000,$E000
	DC.W	$E000,$E000,$FFFC,$0002,$0000,$0003,$0003,$0FFF
	DC.W	$1000,$7000,$F000,$F000,$FFFC,$0002,$0000,$0003
	DC.W	$0003,$07FF,$0800,$7800,$F800,$F800,$FFFC,$0002
	DC.W	$0000,$0003,$0003,$03FF,$0400,$3C00,$FC00,$FC00
	DC.W	$FFFC,$0002,$0000,$0003,$0003,$1FFF,$0000,$2000
	DC.W	$E000,$E000,$FFFC,$0002,$0000,$0003,$0003,$9FFF
	DC.W	$0000,$2000,$6000,$6000,$FFFD,$0002,$0000,$0002
	DC.W	$0002,$CFFF,$0000,$1000,$3000,$3000,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$CFFF,$0000,$1000,$3000,$3000
	DC.W	$FFFF,$0000,$0000,$0000,$0000,$E7FF,$0000,$0800
	DC.W	$1800,$1800,$FFFF,$0000,$0000,$0000,$0000,$E7FF
	DC.W	$0000,$0800,$1800,$1800,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$FFFF,$0000,$0000,$0000,$0000,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FFFE,$0000,$0001,$0001,$0001,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FFFE,$0000,$0000,$0001,$0001,$7FFF
	DC.W	$8000,$8000,$8000,$8000,$FFFE,$0001,$0000,$0001
	DC.W	$0001,$3FFF,$4000,$C000,$C000,$C000,$FFFE,$0001
	DC.W	$0000,$0001,$0001,$1FFF,$2000,$6000,$E000,$E000
	DC.W	$FFFE,$0001,$0000,$0001,$0001,$0FFF,$1000,$7000
	DC.W	$F000,$F000,$FFFE,$0001,$0000,$0001,$0001,$07FF
	DC.W	$0800,$3800,$F800,$F800,$FFFE,$0001,$0000,$0001
	DC.W	$0001,$03FF,$0400,$3C00,$FC00,$FC00,$FFFE,$0001
	DC.W	$0000,$0001,$0001,$01FF,$0200,$1E00,$FE00,$FE00
	DC.W	$FFFE,$0001,$0000,$0001,$0001,$0FFF,$0000,$1000
	DC.W	$F000,$F000,$FFFE,$0001,$0000,$0001,$0001,$4FFF
	DC.W	$0000,$1000,$B000,$B000,$FFFE,$0001,$0000,$0001
	DC.W	$0001,$E7FF,$0000,$0800,$1800,$1800,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$E7FF,$0000,$0800,$1800,$1800
	DC.W	$FFFF,$0000,$0000,$0000,$0000,$F3FF,$0000,$0400
	DC.W	$0C00,$0C00,$FFFF,$0000,$0000,$0000,$0000,$F3FF
	DC.W	$0000,$0400,$0C00,$0C00,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$FFFF,$0000,$0000,$0000,$0000,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$FFFF,$0000,$0000,$0000,$0000

emptyhand:
	DC.W	$CFFF,$2000,$1000,$3000,$3000,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$B3FF,$4000,$0C00,$4C00,$4C00,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$DDFF,$2000,$0200,$2200
	DC.W	$2200,$FFFF,$0000,$0000,$0000,$0000,$E67F,$1800
	DC.W	$0180,$1980,$1980,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$F3BF,$0000,$0040,$0C40,$0C40,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$CD07,$2000,$00F8,$32F8,$32F8,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$D6FB,$2100,$0004,$2904
	DC.W	$2904,$FFFF,$0000,$0000,$0000,$0000,$99DB,$4220
	DC.W	$0004,$6624,$6624,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$6C3D,$83C0,$0002,$93C2,$93C2,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$30BD,$C740,$0002,$CF42,$CF42,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$83BC,$7C40,$0003,$7C43
	DC.W	$7C43,$FFFF,$0000,$0000,$0000,$0000,$DFDE,$2020
	DC.W	$0001,$2021,$2021,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$EFFE,$1000,$0001,$1001,$1001,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$F3BE,$0C40,$0001,$0C41,$0C41,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FC7F,$0380,$0000,$0380
	DC.W	$0380,$FFFF,$0000,$0000,$0000,$0000,$FF3F,$00C0
	DC.W	$0000,$00C0,$00C0,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$E7FF,$1000,$0800,$1800,$1800,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$D9FF,$2000,$0600,$2600,$2600,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$EEFF,$1000,$0100,$1100
	DC.W	$1100,$FFFF,$0000,$0000,$0000,$0000,$F33F,$0C00
	DC.W	$00C0,$0CC0,$0CC0,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$F9DF,$0000,$0020,$0620,$0620,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$E683,$1000,$007C,$197C,$197C,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$EB7D,$1080,$0002,$1482
	DC.W	$1482,$FFFF,$0000,$0000,$0000,$0000,$CCED,$2110
	DC.W	$0002,$3312,$3312,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$B61E,$41E0,$0001,$49E1,$49E1,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$985E,$63A0,$0001,$67A1,$67A1,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$C1DE,$3E20,$0001,$3E21
	DC.W	$3E21,$7FFF,$0000,$8000,$8000,$8000,$EFEF,$1010
	DC.W	$0000,$1010,$1010,$7FFF,$0000,$8000,$8000,$8000
	DC.W	$F7FF,$0800,$0000,$0800,$0800,$7FFF,$0000,$8000
	DC.W	$8000,$8000,$F9DF,$0620,$0000,$0620,$0620,$7FFF
	DC.W	$0000,$8000,$8000,$8000,$FE3F,$01C0,$0000,$01C0
	DC.W	$01C0,$FFFF,$0000,$0000,$0000,$0000,$FF9F,$0060
	DC.W	$0000,$0060,$0060,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$F3FF,$0800,$0400,$0C00,$0C00,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$ECFF,$1000,$0300,$1300,$1300,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$F77F,$0800,$0080,$0880
	DC.W	$0880,$FFFF,$0000,$0000,$0000,$0000,$F99F,$0600
	DC.W	$0060,$0660,$0660,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FCEF,$0000,$0010,$0310,$0310,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$F341,$0800,$003E,$0CBE,$0CBE,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$F5BE,$0840,$0001,$0A41
	DC.W	$0A41,$FFFF,$0000,$0000,$0000,$0000,$E676,$1088
	DC.W	$0001,$1989,$1989,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$DB0F,$20F0,$0000,$24F0,$24F0,$7FFF,$0000,$8000
	DC.W	$8000,$8000,$CC2F,$31D0,$0000,$33D0,$33D0,$7FFF
	DC.W	$0000,$8000,$8000,$8000,$E0EF,$1F10,$0000,$1F10
	DC.W	$1F10,$3FFF,$0000,$C000,$C000,$C000,$F7F7,$0808
	DC.W	$0000,$0808,$0808,$BFFF,$0000,$4000,$4000,$4000
	DC.W	$FBFF,$0400,$0000,$0400,$0400,$BFFF,$0000,$4000
	DC.W	$4000,$4000,$FCEF,$0310,$0000,$0310,$0310,$BFFF
	DC.W	$0000,$4000,$4000,$4000,$FF1F,$00E0,$0000,$00E0
	DC.W	$00E0,$FFFF,$0000,$0000,$0000,$0000,$FFCF,$0030
	DC.W	$0000,$0030,$0030,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$F9FF,$0400,$0200,$0600,$0600,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$F67F,$0800,$0180,$0980,$0980,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FBBF,$0400,$0040,$0440
	DC.W	$0440,$FFFF,$0000,$0000,$0000,$0000,$FCCF,$0300
	DC.W	$0030,$0330,$0330,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FE77,$0000,$0008,$0188,$0188,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$F9A0,$0400,$001F,$065F,$065F,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FADF,$0420,$0000,$0520
	DC.W	$0520,$7FFF,$0000,$8000,$8000,$8000,$F33B,$0844
	DC.W	$0000,$0CC4,$0CC4,$7FFF,$0000,$8000,$8000,$8000
	DC.W	$ED87,$1078,$0000,$1278,$1278,$BFFF,$0000,$4000
	DC.W	$4000,$4000,$E617,$18E8,$0000,$19E8,$19E8,$BFFF
	DC.W	$0000,$4000,$4000,$4000,$F077,$0F88,$0000,$0F88
	DC.W	$0F88,$9FFF,$0000,$6000,$6000,$6000,$FBFB,$0404
	DC.W	$0000,$0404,$0404,$DFFF,$0000,$2000,$2000,$2000
	DC.W	$FDFF,$0200,$0000,$0200,$0200,$DFFF,$0000,$2000
	DC.W	$2000,$2000,$FE77,$0188,$0000,$0188,$0188,$DFFF
	DC.W	$0000,$2000,$2000,$2000,$FF8F,$0070,$0000,$0070
	DC.W	$0070,$FFFF,$0000,$0000,$0000,$0000,$FFE7,$0018
	DC.W	$0000,$0018,$0018,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FCFF,$0200,$0100,$0300,$0300,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FB3F,$0400,$00C0,$04C0,$04C0,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FDDF,$0200,$0020,$0220
	DC.W	$0220,$FFFF,$0000,$0000,$0000,$0000,$FE67,$0180
	DC.W	$0018,$0198,$0198,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FF3B,$0000,$0004,$00C4,$00C4,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FCD0,$0200,$000F,$032F,$032F,$7FFF
	DC.W	$0000,$8000,$8000,$8000,$FD6F,$0210,$0000,$0290
	DC.W	$0290,$BFFF,$0000,$4000,$4000,$4000,$F99D,$0422
	DC.W	$0000,$0662,$0662,$BFFF,$0000,$4000,$4000,$4000
	DC.W	$F6C3,$083C,$0000,$093C,$093C,$DFFF,$0000,$2000
	DC.W	$2000,$2000,$F30B,$0C74,$0000,$0CF4,$0CF4,$DFFF
	DC.W	$0000,$2000,$2000,$2000,$F83B,$07C4,$0000,$07C4
	DC.W	$07C4,$CFFF,$0000,$3000,$3000,$3000,$FDFD,$0202
	DC.W	$0000,$0202,$0202,$EFFF,$0000,$1000,$1000,$1000
	DC.W	$FEFF,$0100,$0000,$0100,$0100,$EFFF,$0000,$1000
	DC.W	$1000,$1000,$FF3B,$00C4,$0000,$00C4,$00C4,$EFFF
	DC.W	$0000,$1000,$1000,$1000,$FFC7,$0038,$0000,$0038
	DC.W	$0038,$FFFF,$0000,$0000,$0000,$0000,$FFF3,$000C
	DC.W	$0000,$000C,$000C,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FE7F,$0100,$0080,$0180,$0180,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FD9F,$0200,$0060,$0260,$0260,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FEEF,$0100,$0010,$0110
	DC.W	$0110,$FFFF,$0000,$0000,$0000,$0000,$FF33,$00C0
	DC.W	$000C,$00CC,$00CC,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FF9D,$0000,$0002,$0062,$0062,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FE68,$0100,$0007,$0197,$0197,$3FFF
	DC.W	$0000,$C000,$C000,$C000,$FEB7,$0108,$0000,$0148
	DC.W	$0148,$DFFF,$0000,$2000,$2000,$2000,$FCCE,$0211
	DC.W	$0000,$0331,$0331,$DFFF,$0000,$2000,$2000,$2000
	DC.W	$FB61,$041E,$0000,$049E,$049E,$EFFF,$0000,$1000
	DC.W	$1000,$1000,$F985,$063A,$0000,$067A,$067A,$EFFF
	DC.W	$0000,$1000,$1000,$1000,$FC1D,$03E2,$0000,$03E2
	DC.W	$03E2,$E7FF,$0000,$1800,$1800,$1800,$FEFE,$0101
	DC.W	$0000,$0101,$0101,$F7FF,$0000,$0800,$0800,$0800
	DC.W	$FF7F,$0080,$0000,$0080,$0080,$F7FF,$0000,$0800
	DC.W	$0800,$0800,$FF9D,$0062,$0000,$0062,$0062,$F7FF
	DC.W	$0000,$0800,$0800,$0800,$FFE3,$001C,$0000,$001C
	DC.W	$001C,$FFFF,$0000,$0000,$0000,$0000,$FFF9,$0006
	DC.W	$0000,$0006,$0006,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FF3F,$0080,$0040,$00C0,$00C0,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FECF,$0100,$0030,$0130,$0130,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FF77,$0080,$0008,$0088
	DC.W	$0088,$FFFF,$0000,$0000,$0000,$0000,$FF99,$0060
	DC.W	$0006,$0066,$0066,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FFCE,$0000,$0001,$0031,$0031,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FF34,$0080,$0003,$00CB,$00CB,$1FFF
	DC.W	$0000,$E000,$E000,$E000,$FF5B,$0084,$0000,$00A4
	DC.W	$00A4,$EFFF,$0000,$1000,$1000,$1000,$FE67,$0108
	DC.W	$0000,$0198,$0198,$6FFF,$8000,$1000,$9000,$9000
	DC.W	$FDB0,$020F,$0000,$024F,$024F,$F7FF,$0000,$0800
	DC.W	$0800,$0800,$FCC2,$031D,$0000,$033D,$033D,$F7FF
	DC.W	$0000,$0800,$0800,$0800,$FE0E,$01F1,$0000,$01F1
	DC.W	$01F1,$F3FF,$0000,$0C00,$0C00,$0C00,$FF7F,$0080
	DC.W	$0000,$0080,$0080,$7BFF,$8000,$0400,$8400,$8400
	DC.W	$FFBF,$0040,$0000,$0040,$0040,$FBFF,$0000,$0400
	DC.W	$0400,$0400,$FFCE,$0031,$0000,$0031,$0031,$FBFF
	DC.W	$0000,$0400,$0400,$0400,$FFF1,$000E,$0000,$000E
	DC.W	$000E,$FFFF,$0000,$0000,$0000,$0000,$FFFC,$0003
	DC.W	$0000,$0003,$0003,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FF9F,$0040,$0020,$0060,$0060,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FF67,$0080,$0018,$0098,$0098,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FFBB,$0040,$0004,$0044
	DC.W	$0044,$FFFF,$0000,$0000,$0000,$0000,$FFCC,$0030
	DC.W	$0003,$0033,$0033,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FFE7,$0000,$0000,$0018,$0018,$7FFF,$0000,$8000
	DC.W	$8000,$8000,$FF9A,$0040,$0001,$0065,$0065,$0FFF
	DC.W	$0000,$F000,$F000,$F000,$FFAD,$0042,$0000,$0052
	DC.W	$0052,$F7FF,$0000,$0800,$0800,$0800,$FF33,$0084
	DC.W	$0000,$00CC,$00CC,$B7FF,$4000,$0800,$4800,$4800
	DC.W	$FED8,$0107,$0000,$0127,$0127,$7BFF,$8000,$0400
	DC.W	$8400,$8400,$FE61,$018E,$0000,$019E,$019E,$7BFF
	DC.W	$8000,$0400,$8400,$8400,$FF07,$00F8,$0000,$00F8
	DC.W	$00F8,$79FF,$8000,$0600,$8600,$8600,$FFBF,$0040
	DC.W	$0000,$0040,$0040,$BDFF,$4000,$0200,$4200,$4200
	DC.W	$FFDF,$0020,$0000,$0020,$0020,$FDFF,$0000,$0200
	DC.W	$0200,$0200,$FFE7,$0018,$0000,$0018,$0018,$7DFF
	DC.W	$8000,$0200,$8200,$8200,$FFF8,$0007,$0000,$0007
	DC.W	$0007,$FFFF,$0000,$0000,$0000,$0000,$FFFE,$0001
	DC.W	$0000,$0001,$0001,$7FFF,$8000,$0000,$8000,$8000
	DC.W	$FFCF,$0020,$0010,$0030,$0030,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FFB3,$0040,$000C,$004C,$004C,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FFDD,$0020,$0002,$0022
	DC.W	$0022,$FFFF,$0000,$0000,$0000,$0000,$FFE6,$0018
	DC.W	$0001,$0019,$0019,$7FFF,$0000,$8000,$8000,$8000
	DC.W	$FFF3,$0000,$0000,$000C,$000C,$BFFF,$0000,$4000
	DC.W	$4000,$4000,$FFCD,$0020,$0000,$0032,$0032,$07FF
	DC.W	$0000,$F800,$F800,$F800,$FFD6,$0021,$0000,$0029
	DC.W	$0029,$FBFF,$0000,$0400,$0400,$0400,$FF99,$0042
	DC.W	$0000,$0066,$0066,$DBFF,$2000,$0400,$2400,$2400
	DC.W	$FF6C,$0083,$0000,$0093,$0093,$3DFF,$C000,$0200
	DC.W	$C200,$C200,$FF30,$00C7,$0000,$00CF,$00CF,$BDFF
	DC.W	$4000,$0200,$4200,$4200,$FF83,$007C,$0000,$007C
	DC.W	$007C,$BCFF,$4000,$0300,$4300,$4300,$FFDF,$0020
	DC.W	$0000,$0020,$0020,$DEFF,$2000,$0100,$2100,$2100
	DC.W	$FFEF,$0010,$0000,$0010,$0010,$FEFF,$0000,$0100
	DC.W	$0100,$0100,$FFF3,$000C,$0000,$000C,$000C,$BEFF
	DC.W	$4000,$0100,$4100,$4100,$FFFC,$0003,$0000,$0003
	DC.W	$0003,$7FFF,$8000,$0000,$8000,$8000,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$3FFF,$C000,$0000,$C000,$C000
	DC.W	$FFE7,$0010,$0008,$0018,$0018,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FFD9,$0020,$0006,$0026,$0026,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FFEE,$0010,$0001,$0011
	DC.W	$0011,$FFFF,$0000,$0000,$0000,$0000,$FFF3,$000C
	DC.W	$0000,$000C,$000C,$3FFF,$0000,$C000,$C000,$C000
	DC.W	$FFF9,$0000,$0000,$0006,$0006,$DFFF,$0000,$2000
	DC.W	$2000,$2000,$FFE6,$0010,$0000,$0019,$0019,$83FF
	DC.W	$0000,$7C00,$7C00,$7C00,$FFEB,$0010,$0000,$0014
	DC.W	$0014,$7DFF,$8000,$0200,$8200,$8200,$FFCC,$0021
	DC.W	$0000,$0033,$0033,$EDFF,$1000,$0200,$1200,$1200
	DC.W	$FFB6,$0041,$0000,$0049,$0049,$1EFF,$E000,$0100
	DC.W	$E100,$E100,$FF98,$0063,$0000,$0067,$0067,$5EFF
	DC.W	$A000,$0100,$A100,$A100,$FFC1,$003E,$0000,$003E
	DC.W	$003E,$DE7F,$2000,$0180,$2180,$2180,$FFEF,$0010
	DC.W	$0000,$0010,$0010,$EF7F,$1000,$0080,$1080,$1080
	DC.W	$FFF7,$0008,$0000,$0008,$0008,$FF7F,$0000,$0080
	DC.W	$0080,$0080,$FFF9,$0006,$0000,$0006,$0006,$DF7F
	DC.W	$2000,$0080,$2080,$2080,$FFFE,$0001,$0000,$0001
	DC.W	$0001,$3FFF,$C000,$0000,$C000,$C000,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$9FFF,$6000,$0000,$6000,$6000
	DC.W	$FFF3,$0008,$0004,$000C,$000C,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FFEC,$0010,$0003,$0013,$0013,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FFF7,$0008,$0000,$0008
	DC.W	$0008,$7FFF,$0000,$8000,$8000,$8000,$FFF9,$0006
	DC.W	$0000,$0006,$0006,$9FFF,$0000,$6000,$6000,$6000
	DC.W	$FFFC,$0000,$0000,$0003,$0003,$EFFF,$0000,$1000
	DC.W	$1000,$1000,$FFF3,$0008,$0000,$000C,$000C,$41FF
	DC.W	$0000,$3E00,$BE00,$BE00,$FFF5,$0008,$0000,$000A
	DC.W	$000A,$BEFF,$4000,$0100,$4100,$4100,$FFE6,$0010
	DC.W	$0000,$0019,$0019,$76FF,$8800,$0100,$8900,$8900
	DC.W	$FFDB,$0020,$0000,$0024,$0024,$0F7F,$F000,$0080
	DC.W	$F080,$F080,$FFCC,$0031,$0000,$0033,$0033,$2F7F
	DC.W	$D000,$0080,$D080,$D080,$FFE0,$001F,$0000,$001F
	DC.W	$001F,$EF3F,$1000,$00C0,$10C0,$10C0,$FFF7,$0008
	DC.W	$0000,$0008,$0008,$F7BF,$0800,$0040,$0840,$0840
	DC.W	$FFFB,$0004,$0000,$0004,$0004,$FFBF,$0000,$0040
	DC.W	$0040,$0040,$FFFC,$0003,$0000,$0003,$0003,$EFBF
	DC.W	$1000,$0040,$1040,$1040,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$1FFF,$E000,$0000,$E000,$E000,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$CFFF,$3000,$0000,$3000,$3000
	DC.W	$FFF9,$0004,$0002,$0006,$0006,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FFF6,$0008,$0001,$0009,$0009,$7FFF
	DC.W	$0000,$8000,$8000,$8000,$FFFB,$0004,$0000,$0004
	DC.W	$0004,$BFFF,$0000,$4000,$4000,$4000,$FFFC,$0003
	DC.W	$0000,$0003,$0003,$CFFF,$0000,$3000,$3000,$3000
	DC.W	$FFFE,$0000,$0000,$0001,$0001,$77FF,$0000,$0800
	DC.W	$8800,$8800,$FFF9,$0004,$0000,$0006,$0006,$A0FF
	DC.W	$0000,$1F00,$5F00,$5F00,$FFFA,$0004,$0000,$0005
	DC.W	$0005,$DF7F,$2000,$0080,$2080,$2080,$FFF3,$0008
	DC.W	$0000,$000C,$000C,$3B7F,$4400,$0080,$C480,$C480
	DC.W	$FFED,$0010,$0000,$0012,$0012,$87BF,$7800,$0040
	DC.W	$7840,$7840,$FFE6,$0018,$0000,$0019,$0019,$17BF
	DC.W	$E800,$0040,$E840,$E840,$FFF0,$000F,$0000,$000F
	DC.W	$000F,$779F,$8800,$0060,$8860,$8860,$FFFB,$0004
	DC.W	$0000,$0004,$0004,$FBDF,$0400,$0020,$0420,$0420
	DC.W	$FFFD,$0002,$0000,$0002,$0002,$FFDF,$0000,$0020
	DC.W	$0020,$0020,$FFFE,$0001,$0000,$0001,$0001,$77DF
	DC.W	$8800,$0020,$8820,$8820,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$8FFF,$7000,$0000,$7000,$7000,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$E7FF,$1800,$0000,$1800,$1800
	DC.W	$FFFC,$0002,$0001,$0003,$0003,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FFFB,$0004,$0000,$0004,$0004,$3FFF
	DC.W	$0000,$C000,$C000,$C000,$FFFD,$0002,$0000,$0002
	DC.W	$0002,$DFFF,$0000,$2000,$2000,$2000,$FFFE,$0001
	DC.W	$0000,$0001,$0001,$67FF,$8000,$1800,$9800,$9800
	DC.W	$FFFF,$0000,$0000,$0000,$0000,$3BFF,$0000,$0400
	DC.W	$C400,$C400,$FFFC,$0002,$0000,$0003,$0003,$D07F
	DC.W	$0000,$0F80,$2F80,$2F80,$FFFD,$0002,$0000,$0002
	DC.W	$0002,$6FBF,$1000,$0040,$9040,$9040,$FFF9,$0004
	DC.W	$0000,$0006,$0006,$9DBF,$2200,$0040,$6240,$6240
	DC.W	$FFF6,$0008,$0000,$0009,$0009,$C3DF,$3C00,$0020
	DC.W	$3C20,$3C20,$FFF3,$000C,$0000,$000C,$000C,$0BDF
	DC.W	$7400,$0020,$F420,$F420,$FFF8,$0007,$0000,$0007
	DC.W	$0007,$3BCF,$C400,$0030,$C430,$C430,$FFFD,$0002
	DC.W	$0000,$0002,$0002,$FDEF,$0200,$0010,$0210,$0210
	DC.W	$FFFE,$0001,$0000,$0001,$0001,$FFEF,$0000,$0010
	DC.W	$0010,$0010,$FFFF,$0000,$0000,$0000,$0000,$3BEF
	DC.W	$C400,$0010,$C410,$C410,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$C7FF,$3800,$0000,$3800,$3800,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$F3FF,$0C00,$0000,$0C00,$0C00
	DC.W	$FFFE,$0001,$0000,$0001,$0001,$7FFF,$0000,$8000
	DC.W	$8000,$8000,$FFFD,$0002,$0000,$0002,$0002,$9FFF
	DC.W	$0000,$6000,$6000,$6000,$FFFE,$0001,$0000,$0001
	DC.W	$0001,$EFFF,$0000,$1000,$1000,$1000,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$33FF,$C000,$0C00,$CC00,$CC00
	DC.W	$FFFF,$0000,$0000,$0000,$0000,$9DFF,$0000,$0200
	DC.W	$6200,$6200,$FFFE,$0001,$0000,$0001,$0001,$683F
	DC.W	$0000,$07C0,$97C0,$97C0,$FFFE,$0001,$0000,$0001
	DC.W	$0001,$B7DF,$0800,$0020,$4820,$4820,$FFFC,$0002
	DC.W	$0000,$0003,$0003,$CEDF,$1100,$0020,$3120,$3120
	DC.W	$FFFB,$0004,$0000,$0004,$0004,$61EF,$1E00,$0010
	DC.W	$9E10,$9E10,$FFF9,$0006,$0000,$0006,$0006,$85EF
	DC.W	$3A00,$0010,$7A10,$7A10,$FFFC,$0003,$0000,$0003
	DC.W	$0003,$1DE7,$E200,$0018,$E218,$E218,$FFFE,$0001
	DC.W	$0000,$0001,$0001,$FEF7,$0100,$0008,$0108,$0108
	DC.W	$FFFF,$0000,$0000,$0000,$0000,$7FF7,$8000,$0008
	DC.W	$8008,$8008,$FFFF,$0000,$0000,$0000,$0000,$9DF7
	DC.W	$6200,$0008,$6208,$6208,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$E3FF,$1C00,$0000,$1C00,$1C00,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$F9FF,$0600,$0000,$0600,$0600
	DC.W	$FFFF,$0000,$0000,$0000,$0000,$3FFF,$8000,$4000
	DC.W	$C000,$C000,$FFFE,$0001,$0000,$0001,$0001,$CFFF
	DC.W	$0000,$3000,$3000,$3000,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$77FF,$8000,$0800,$8800,$8800,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$99FF,$6000,$0600,$6600,$6600
	DC.W	$FFFF,$0000,$0000,$0000,$0000,$CEFF,$0000,$0100
	DC.W	$3100,$3100,$FFFF,$0000,$0000,$0000,$0000,$341F
	DC.W	$8000,$03E0,$CBE0,$CBE0,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$5BEF,$8400,$0010,$A410,$A410,$FFFE,$0001
	DC.W	$0000,$0001,$0001,$676F,$0880,$0010,$9890,$9890
	DC.W	$FFFD,$0002,$0000,$0002,$0002,$B0F7,$0F00,$0008
	DC.W	$4F08,$4F08,$FFFC,$0003,$0000,$0003,$0003,$C2F7
	DC.W	$1D00,$0008,$3D08,$3D08,$FFFE,$0001,$0000,$0001
	DC.W	$0001,$0EF3,$F100,$000C,$F10C,$F10C,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$7F7B,$8080,$0004,$8084,$8084
	DC.W	$FFFF,$0000,$0000,$0000,$0000,$BFFB,$4000,$0004
	DC.W	$4004,$4004,$FFFF,$0000,$0000,$0000,$0000,$CEFB
	DC.W	$3100,$0004,$3104,$3104,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$F1FF,$0E00,$0000,$0E00,$0E00,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$FCFF,$0300,$0000,$0300,$0300
	DC.W	$FFFF,$0000,$0000,$0000,$0000,$9FFF,$4000,$2000
	DC.W	$6000,$6000,$FFFF,$0000,$0000,$0000,$0000,$67FF
	DC.W	$8000,$1800,$9800,$9800,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$BBFF,$4000,$0400,$4400,$4400,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$CCFF,$3000,$0300,$3300,$3300
	DC.W	$FFFF,$0000,$0000,$0000,$0000,$E77F,$0000,$0080
	DC.W	$1880,$1880,$FFFF,$0000,$0000,$0000,$0000,$9A0F
	DC.W	$4000,$01F0,$65F0,$65F0,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$ADF7,$4200,$0008,$5208,$5208,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$33B7,$8440,$0008,$CC48,$CC48
	DC.W	$FFFE,$0001,$0000,$0001,$0001,$D87B,$0780,$0004
	DC.W	$2784,$2784,$FFFE,$0001,$0000,$0001,$0001,$617B
	DC.W	$8E80,$0004,$9E84,$9E84,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$0779,$F880,$0006,$F886,$F886,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$BFBD,$4040,$0002,$4042,$4042
	DC.W	$FFFF,$0000,$0000,$0000,$0000,$DFFD,$2000,$0002
	DC.W	$2002,$2002,$FFFF,$0000,$0000,$0000,$0000,$E77D
	DC.W	$1880,$0002,$1882,$1882,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$F8FF,$0700,$0000,$0700,$0700,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$FE7F,$0180,$0000,$0180,$0180

filledhand:
	DC.W	$CFFF,$3000,$1000,$3000,$3000,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$83FF,$4C00,$0C00,$7C00,$7C00,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$C1FF,$2200,$0200,$3E00
	DC.W	$3E00,$FFFF,$0000,$0000,$0000,$0000,$E07F,$1980
	DC.W	$0180,$1F80,$1F80,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$F03F,$0040,$0C40,$0FC0,$0FC0,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$C007,$20F8,$12F8,$3FF8,$3FF8,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$C003,$2104,$0804,$3FFC
	DC.W	$3FFC,$FFFF,$0000,$0000,$0000,$0000,$8003,$4224
	DC.W	$2404,$7FFC,$7FFC,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$0001,$83C2,$1002,$FFFE,$FFFE,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$0001,$C742,$0802,$FFFE,$FFFE,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$8000,$7C43,$0003,$7FFF
	DC.W	$7FFF,$FFFF,$0000,$0000,$0000,$0000,$C000,$2021
	DC.W	$0001,$3FFF,$3FFF,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$E000,$1001,$0001,$1FFF,$1FFF,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$F000,$0C41,$0001,$0FFF,$0FFF,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FC01,$0380,$0000,$03FE
	DC.W	$03FE,$FFFF,$0000,$0000,$0000,$0000,$FF07,$00C0
	DC.W	$0000,$00F8,$00F8,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$E7FF,$1800,$0800,$1800,$1800,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$C1FF,$2600,$0600,$3E00,$3E00,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$E0FF,$1100,$0100,$1F00
	DC.W	$1F00,$FFFF,$0000,$0000,$0000,$0000,$F03F,$0CC0
	DC.W	$00C0,$0FC0,$0FC0,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$F81F,$0020,$0620,$07E0,$07E0,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$E003,$107C,$097C,$1FFC,$1FFC,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$E001,$1082,$0402,$1FFE
	DC.W	$1FFE,$FFFF,$0000,$0000,$0000,$0000,$C001,$2112
	DC.W	$1202,$3FFE,$3FFE,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$8000,$41E1,$0801,$7FFF,$7FFF,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$8000,$63A1,$0401,$7FFF,$7FFF,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$C000,$3E21,$0001,$3FFF
	DC.W	$3FFF,$7FFF,$8000,$8000,$8000,$8000,$E000,$1010
	DC.W	$0000,$1FFF,$1FFF,$7FFF,$8000,$8000,$8000,$8000
	DC.W	$F000,$0800,$0000,$0FFF,$0FFF,$7FFF,$8000,$8000
	DC.W	$8000,$8000,$F800,$0620,$0000,$07FF,$07FF,$7FFF
	DC.W	$8000,$8000,$8000,$8000,$FE00,$01C0,$0000,$01FF
	DC.W	$01FF,$FFFF,$0000,$0000,$0000,$0000,$FF83,$0060
	DC.W	$0000,$007C,$007C,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$F3FF,$0C00,$0400,$0C00,$0C00,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$E0FF,$1300,$0300,$1F00,$1F00,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$F07F,$0880,$0080,$0F80
	DC.W	$0F80,$FFFF,$0000,$0000,$0000,$0000,$F81F,$0660
	DC.W	$0060,$07E0,$07E0,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FC0F,$0010,$0310,$03F0,$03F0,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$F001,$083E,$04BE,$0FFE,$0FFE,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$F000,$0841,$0201,$0FFF
	DC.W	$0FFF,$FFFF,$0000,$0000,$0000,$0000,$E000,$1089
	DC.W	$0901,$1FFF,$1FFF,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$C000,$20F0,$0400,$3FFF,$3FFF,$7FFF,$8000,$8000
	DC.W	$8000,$8000,$C000,$31D0,$0200,$3FFF,$3FFF,$7FFF
	DC.W	$8000,$8000,$8000,$8000,$E000,$1F10,$0000,$1FFF
	DC.W	$1FFF,$3FFF,$C000,$C000,$C000,$C000,$F000,$0808
	DC.W	$0000,$0FFF,$0FFF,$3FFF,$4000,$4000,$C000,$C000
	DC.W	$F800,$0400,$0000,$07FF,$07FF,$3FFF,$4000,$4000
	DC.W	$C000,$C000,$FC00,$0310,$0000,$03FF,$03FF,$3FFF
	DC.W	$4000,$4000,$C000,$C000,$FF00,$00E0,$0000,$00FF
	DC.W	$00FF,$7FFF,$0000,$0000,$8000,$8000,$FFC1,$0030
	DC.W	$0000,$003E,$003E,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$F9FF,$0600,$0200,$0600,$0600,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$F07F,$0980,$0180,$0F80,$0F80,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$F83F,$0440,$0040,$07C0
	DC.W	$07C0,$FFFF,$0000,$0000,$0000,$0000,$FC0F,$0330
	DC.W	$0030,$03F0,$03F0,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FE07,$0008,$0188,$01F8,$01F8,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$F800,$041F,$025F,$07FF,$07FF,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$F800,$0420,$0100,$07FF
	DC.W	$07FF,$7FFF,$8000,$8000,$8000,$8000,$F000,$0844
	DC.W	$0480,$0FFF,$0FFF,$7FFF,$8000,$8000,$8000,$8000
	DC.W	$E000,$1078,$0200,$1FFF,$1FFF,$3FFF,$4000,$4000
	DC.W	$C000,$C000,$E000,$18E8,$0100,$1FFF,$1FFF,$3FFF
	DC.W	$4000,$4000,$C000,$C000,$F000,$0F88,$0000,$0FFF
	DC.W	$0FFF,$1FFF,$6000,$6000,$E000,$E000,$F800,$0404
	DC.W	$0000,$07FF,$07FF,$1FFF,$2000,$2000,$E000,$E000
	DC.W	$FC00,$0200,$0000,$03FF,$03FF,$1FFF,$2000,$2000
	DC.W	$E000,$E000,$FE00,$0188,$0000,$01FF,$01FF,$1FFF
	DC.W	$2000,$2000,$E000,$E000,$FF80,$0070,$0000,$007F
	DC.W	$007F,$3FFF,$0000,$0000,$C000,$C000,$FFE0,$0018
	DC.W	$0000,$001F,$001F,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FCFF,$0300,$0100,$0300,$0300,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$F83F,$04C0,$00C0,$07C0,$07C0,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FC1F,$0220,$0020,$03E0
	DC.W	$03E0,$FFFF,$0000,$0000,$0000,$0000,$FE07,$0198
	DC.W	$0018,$01F8,$01F8,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FF03,$0004,$00C4,$00FC,$00FC,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FC00,$020F,$012F,$03FF,$03FF,$7FFF
	DC.W	$8000,$8000,$8000,$8000,$FC00,$0210,$0080,$03FF
	DC.W	$03FF,$3FFF,$4000,$4000,$C000,$C000,$F800,$0422
	DC.W	$0240,$07FF,$07FF,$3FFF,$4000,$4000,$C000,$C000
	DC.W	$F000,$083C,$0100,$0FFF,$0FFF,$1FFF,$2000,$2000
	DC.W	$E000,$E000,$F000,$0C74,$0080,$0FFF,$0FFF,$1FFF
	DC.W	$2000,$2000,$E000,$E000,$F800,$07C4,$0000,$07FF
	DC.W	$07FF,$0FFF,$3000,$3000,$F000,$F000,$FC00,$0202
	DC.W	$0000,$03FF,$03FF,$0FFF,$1000,$1000,$F000,$F000
	DC.W	$FE00,$0100,$0000,$01FF,$01FF,$0FFF,$1000,$1000
	DC.W	$F000,$F000,$FF00,$00C4,$0000,$00FF,$00FF,$0FFF
	DC.W	$1000,$1000,$F000,$F000,$FFC0,$0038,$0000,$003F
	DC.W	$003F,$1FFF,$0000,$0000,$E000,$E000,$FFF0,$000C
	DC.W	$0000,$000F,$000F,$7FFF,$0000,$0000,$8000,$8000
	DC.W	$FE7F,$0180,$0080,$0180,$0180,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FC1F,$0260,$0060,$03E0,$03E0,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FE0F,$0110,$0010,$01F0
	DC.W	$01F0,$FFFF,$0000,$0000,$0000,$0000,$FF03,$00CC
	DC.W	$000C,$00FC,$00FC,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FF81,$0002,$0062,$007E,$007E,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FE00,$0107,$0097,$01FF,$01FF,$3FFF
	DC.W	$C000,$C000,$C000,$C000,$FE00,$0108,$0040,$01FF
	DC.W	$01FF,$1FFF,$2000,$2000,$E000,$E000,$FC00,$0211
	DC.W	$0120,$03FF,$03FF,$1FFF,$2000,$2000,$E000,$E000
	DC.W	$F800,$041E,$0080,$07FF,$07FF,$0FFF,$1000,$1000
	DC.W	$F000,$F000,$F800,$063A,$0040,$07FF,$07FF,$0FFF
	DC.W	$1000,$1000,$F000,$F000,$FC00,$03E2,$0000,$03FF
	DC.W	$03FF,$07FF,$1800,$1800,$F800,$F800,$FE00,$0101
	DC.W	$0000,$01FF,$01FF,$07FF,$0800,$0800,$F800,$F800
	DC.W	$FF00,$0080,$0000,$00FF,$00FF,$07FF,$0800,$0800
	DC.W	$F800,$F800,$FF80,$0062,$0000,$007F,$007F,$07FF
	DC.W	$0800,$0800,$F800,$F800,$FFE0,$001C,$0000,$001F
	DC.W	$001F,$0FFF,$0000,$0000,$F000,$F000,$FFF8,$0006
	DC.W	$0000,$0007,$0007,$3FFF,$0000,$0000,$C000,$C000
	DC.W	$FF3F,$00C0,$0040,$00C0,$00C0,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FE0F,$0130,$0030,$01F0,$01F0,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FF07,$0088,$0008,$00F8
	DC.W	$00F8,$FFFF,$0000,$0000,$0000,$0000,$FF81,$0066
	DC.W	$0006,$007E,$007E,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FFC0,$0001,$0031,$003F,$003F,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FF00,$0083,$004B,$00FF,$00FF,$1FFF
	DC.W	$E000,$E000,$E000,$E000,$FF00,$0084,$0020,$00FF
	DC.W	$00FF,$0FFF,$1000,$1000,$F000,$F000,$FE00,$0108
	DC.W	$0090,$01FF,$01FF,$0FFF,$9000,$1000,$F000,$F000
	DC.W	$FC00,$020F,$0040,$03FF,$03FF,$07FF,$0800,$0800
	DC.W	$F800,$F800,$FC00,$031D,$0020,$03FF,$03FF,$07FF
	DC.W	$0800,$0800,$F800,$F800,$FE00,$01F1,$0000,$01FF
	DC.W	$01FF,$03FF,$0C00,$0C00,$FC00,$FC00,$FF00,$0080
	DC.W	$0000,$00FF,$00FF,$03FF,$8400,$0400,$FC00,$FC00
	DC.W	$FF80,$0040,$0000,$007F,$007F,$03FF,$0400,$0400
	DC.W	$FC00,$FC00,$FFC0,$0031,$0000,$003F,$003F,$03FF
	DC.W	$0400,$0400,$FC00,$FC00,$FFF0,$000E,$0000,$000F
	DC.W	$000F,$07FF,$0000,$0000,$F800,$F800,$FFFC,$0003
	DC.W	$0000,$0003,$0003,$1FFF,$0000,$0000,$E000,$E000
	DC.W	$FF9F,$0060,$0020,$0060,$0060,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FF07,$0098,$0018,$00F8,$00F8,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FF83,$0044,$0004,$007C
	DC.W	$007C,$FFFF,$0000,$0000,$0000,$0000,$FFC0,$0033
	DC.W	$0003,$003F,$003F,$FFFF,$0000,$0000,$0000,$0000
	DC.W	$FFE0,$0000,$0018,$001F,$001F,$7FFF,$8000,$8000
	DC.W	$8000,$8000,$FF80,$0041,$0025,$007F,$007F,$0FFF
	DC.W	$F000,$F000,$F000,$F000,$FF80,$0042,$0010,$007F
	DC.W	$007F,$07FF,$0800,$0800,$F800,$F800,$FF00,$0084
	DC.W	$0048,$00FF,$00FF,$07FF,$4800,$0800,$F800,$F800
	DC.W	$FE00,$0107,$0020,$01FF,$01FF,$03FF,$8400,$0400
	DC.W	$FC00,$FC00,$FE00,$018E,$0010,$01FF,$01FF,$03FF
	DC.W	$8400,$0400,$FC00,$FC00,$FF00,$00F8,$0000,$00FF
	DC.W	$00FF,$01FF,$8600,$0600,$FE00,$FE00,$FF80,$0040
	DC.W	$0000,$007F,$007F,$01FF,$4200,$0200,$FE00,$FE00
	DC.W	$FFC0,$0020,$0000,$003F,$003F,$01FF,$0200,$0200
	DC.W	$FE00,$FE00,$FFE0,$0018,$0000,$001F,$001F,$01FF
	DC.W	$8200,$0200,$FE00,$FE00,$FFF8,$0007,$0000,$0007
	DC.W	$0007,$03FF,$0000,$0000,$FC00,$FC00,$FFFE,$0001
	DC.W	$0000,$0001,$0001,$0FFF,$8000,$0000,$F000,$F000
	DC.W	$FFCF,$0030,$0010,$0030,$0030,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FF83,$004C,$000C,$007C,$007C,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FFC1,$0022,$0002,$003E
	DC.W	$003E,$FFFF,$0000,$0000,$0000,$0000,$FFE0,$0019
	DC.W	$0001,$001F,$001F,$7FFF,$8000,$8000,$8000,$8000
	DC.W	$FFF0,$0000,$000C,$000F,$000F,$3FFF,$4000,$4000
	DC.W	$C000,$C000,$FFC0,$0020,$0012,$003F,$003F,$07FF
	DC.W	$F800,$F800,$F800,$F800,$FFC0,$0021,$0008,$003F
	DC.W	$003F,$03FF,$0400,$0400,$FC00,$FC00,$FF80,$0042
	DC.W	$0024,$007F,$007F,$03FF,$2400,$0400,$FC00,$FC00
	DC.W	$FF00,$0083,$0010,$00FF,$00FF,$01FF,$C200,$0200
	DC.W	$FE00,$FE00,$FF00,$00C7,$0008,$00FF,$00FF,$01FF
	DC.W	$4200,$0200,$FE00,$FE00,$FF80,$007C,$0000,$007F
	DC.W	$007F,$00FF,$4300,$0300,$FF00,$FF00,$FFC0,$0020
	DC.W	$0000,$003F,$003F,$00FF,$2100,$0100,$FF00,$FF00
	DC.W	$FFE0,$0010,$0000,$001F,$001F,$00FF,$0100,$0100
	DC.W	$FF00,$FF00,$FFF0,$000C,$0000,$000F,$000F,$00FF
	DC.W	$4100,$0100,$FF00,$FF00,$FFFC,$0003,$0000,$0003
	DC.W	$0003,$01FF,$8000,$0000,$FE00,$FE00,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$07FF,$C000,$0000,$F800,$F800
	DC.W	$FFE7,$0018,$0008,$0018,$0018,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FFC1,$0026,$0006,$003E,$003E,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FFE0,$0011,$0001,$001F
	DC.W	$001F,$FFFF,$0000,$0000,$0000,$0000,$FFF0,$000C
	DC.W	$0000,$000F,$000F,$3FFF,$C000,$C000,$C000,$C000
	DC.W	$FFF8,$0000,$0006,$0007,$0007,$1FFF,$2000,$2000
	DC.W	$E000,$E000,$FFE0,$0010,$0009,$001F,$001F,$03FF
	DC.W	$7C00,$7C00,$FC00,$FC00,$FFE0,$0010,$0004,$001F
	DC.W	$001F,$01FF,$8200,$0200,$FE00,$FE00,$FFC0,$0021
	DC.W	$0012,$003F,$003F,$01FF,$1200,$0200,$FE00,$FE00
	DC.W	$FF80,$0041,$0008,$007F,$007F,$00FF,$E100,$0100
	DC.W	$FF00,$FF00,$FF80,$0063,$0004,$007F,$007F,$00FF
	DC.W	$A100,$0100,$FF00,$FF00,$FFC0,$003E,$0000,$003F
	DC.W	$003F,$007F,$2180,$0180,$FF80,$FF80,$FFE0,$0010
	DC.W	$0000,$001F,$001F,$007F,$1080,$0080,$FF80,$FF80
	DC.W	$FFF0,$0008,$0000,$000F,$000F,$007F,$0080,$0080
	DC.W	$FF80,$FF80,$FFF8,$0006,$0000,$0007,$0007,$007F
	DC.W	$2080,$0080,$FF80,$FF80,$FFFE,$0001,$0000,$0001
	DC.W	$0001,$00FF,$C000,$0000,$FF00,$FF00,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$83FF,$6000,$0000,$7C00,$7C00
	DC.W	$FFF3,$000C,$0004,$000C,$000C,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FFE0,$0013,$0003,$001F,$001F,$FFFF
	DC.W	$0000,$0000,$0000,$0000,$FFF0,$0008,$0000,$000F
	DC.W	$000F,$7FFF,$8000,$8000,$8000,$8000,$FFF8,$0006
	DC.W	$0000,$0007,$0007,$1FFF,$6000,$6000,$E000,$E000
	DC.W	$FFFC,$0000,$0003,$0003,$0003,$0FFF,$1000,$1000
	DC.W	$F000,$F000,$FFF0,$0008,$0004,$000F,$000F,$01FF
	DC.W	$3E00,$BE00,$FE00,$FE00,$FFF0,$0008,$0002,$000F
	DC.W	$000F,$00FF,$4100,$0100,$FF00,$FF00,$FFE0,$0010
	DC.W	$0009,$001F,$001F,$00FF,$8900,$0100,$FF00,$FF00
	DC.W	$FFC0,$0020,$0004,$003F,$003F,$007F,$F080,$0080
	DC.W	$FF80,$FF80,$FFC0,$0031,$0002,$003F,$003F,$007F
	DC.W	$D080,$0080,$FF80,$FF80,$FFE0,$001F,$0000,$001F
	DC.W	$001F,$003F,$10C0,$00C0,$FFC0,$FFC0,$FFF0,$0008
	DC.W	$0000,$000F,$000F,$003F,$0840,$0040,$FFC0,$FFC0
	DC.W	$FFF8,$0004,$0000,$0007,$0007,$003F,$0040,$0040
	DC.W	$FFC0,$FFC0,$FFFC,$0003,$0000,$0003,$0003,$003F
	DC.W	$1040,$0040,$FFC0,$FFC0,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$007F,$E000,$0000,$FF80,$FF80,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$C1FF,$3000,$0000,$3E00,$3E00
	DC.W	$FFF9,$0006,$0002,$0006,$0006,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FFF0,$0009,$0001,$000F,$000F,$7FFF
	DC.W	$8000,$8000,$8000,$8000,$FFF8,$0004,$0000,$0007
	DC.W	$0007,$3FFF,$4000,$4000,$C000,$C000,$FFFC,$0003
	DC.W	$0000,$0003,$0003,$0FFF,$3000,$3000,$F000,$F000
	DC.W	$FFFE,$0000,$0001,$0001,$0001,$07FF,$0800,$8800
	DC.W	$F800,$F800,$FFF8,$0004,$0002,$0007,$0007,$00FF
	DC.W	$1F00,$5F00,$FF00,$FF00,$FFF8,$0004,$0001,$0007
	DC.W	$0007,$007F,$2080,$0080,$FF80,$FF80,$FFF0,$0008
	DC.W	$0004,$000F,$000F,$007F,$4480,$8080,$FF80,$FF80
	DC.W	$FFE0,$0010,$0002,$001F,$001F,$003F,$7840,$0040
	DC.W	$FFC0,$FFC0,$FFE0,$0018,$0001,$001F,$001F,$003F
	DC.W	$E840,$0040,$FFC0,$FFC0,$FFF0,$000F,$0000,$000F
	DC.W	$000F,$001F,$8860,$0060,$FFE0,$FFE0,$FFF8,$0004
	DC.W	$0000,$0007,$0007,$001F,$0420,$0020,$FFE0,$FFE0
	DC.W	$FFFC,$0002,$0000,$0003,$0003,$001F,$0020,$0020
	DC.W	$FFE0,$FFE0,$FFFE,$0001,$0000,$0001,$0001,$001F
	DC.W	$8820,$0020,$FFE0,$FFE0,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$803F,$7000,$0000,$7FC0,$7FC0,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$E0FF,$1800,$0000,$1F00,$1F00
	DC.W	$FFFC,$0003,$0001,$0003,$0003,$FFFF,$0000,$0000
	DC.W	$0000,$0000,$FFF8,$0004,$0000,$0007,$0007,$3FFF
	DC.W	$C000,$C000,$C000,$C000,$FFFC,$0002,$0000,$0003
	DC.W	$0003,$1FFF,$2000,$2000,$E000,$E000,$FFFE,$0001
	DC.W	$0000,$0001,$0001,$07FF,$9800,$1800,$F800,$F800
	DC.W	$FFFF,$0000,$0000,$0000,$0000,$03FF,$0400,$C400
	DC.W	$FC00,$FC00,$FFFC,$0002,$0001,$0003,$0003,$007F
	DC.W	$0F80,$2F80,$FF80,$FF80,$FFFC,$0002,$0000,$0003
	DC.W	$0003,$003F,$1040,$8040,$FFC0,$FFC0,$FFF8,$0004
	DC.W	$0002,$0007,$0007,$003F,$2240,$4040,$FFC0,$FFC0
	DC.W	$FFF0,$0008,$0001,$000F,$000F,$001F,$3C20,$0020
	DC.W	$FFE0,$FFE0,$FFF0,$000C,$0000,$000F,$000F,$001F
	DC.W	$7420,$8020,$FFE0,$FFE0,$FFF8,$0007,$0000,$0007
	DC.W	$0007,$000F,$C430,$0030,$FFF0,$FFF0,$FFFC,$0002
	DC.W	$0000,$0003,$0003,$000F,$0210,$0010,$FFF0,$FFF0
	DC.W	$FFFE,$0001,$0000,$0001,$0001,$000F,$0010,$0010
	DC.W	$FFF0,$FFF0,$FFFF,$0000,$0000,$0000,$0000,$000F
	DC.W	$C410,$0010,$FFF0,$FFF0,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$C01F,$3800,$0000,$3FE0,$3FE0,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$F07F,$0C00,$0000,$0F80,$0F80
	DC.W	$FFFE,$0001,$0000,$0001,$0001,$7FFF,$8000,$8000
	DC.W	$8000,$8000,$FFFC,$0002,$0000,$0003,$0003,$1FFF
	DC.W	$6000,$6000,$E000,$E000,$FFFE,$0001,$0000,$0001
	DC.W	$0001,$0FFF,$1000,$1000,$F000,$F000,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$03FF,$CC00,$0C00,$FC00,$FC00
	DC.W	$FFFF,$0000,$0000,$0000,$0000,$81FF,$0200,$6200
	DC.W	$7E00,$7E00,$FFFE,$0001,$0000,$0001,$0001,$003F
	DC.W	$07C0,$97C0,$FFC0,$FFC0,$FFFE,$0001,$0000,$0001
	DC.W	$0001,$001F,$0820,$4020,$FFE0,$FFE0,$FFFC,$0002
	DC.W	$0001,$0003,$0003,$001F,$1120,$2020,$FFE0,$FFE0
	DC.W	$FFF8,$0004,$0000,$0007,$0007,$000F,$1E10,$8010
	DC.W	$FFF0,$FFF0,$FFF8,$0006,$0000,$0007,$0007,$000F
	DC.W	$3A10,$4010,$FFF0,$FFF0,$FFFC,$0003,$0000,$0003
	DC.W	$0003,$0007,$E218,$0018,$FFF8,$FFF8,$FFFE,$0001
	DC.W	$0000,$0001,$0001,$0007,$0108,$0008,$FFF8,$FFF8
	DC.W	$FFFF,$0000,$0000,$0000,$0000,$0007,$8008,$0008
	DC.W	$FFF8,$FFF8,$FFFF,$0000,$0000,$0000,$0000,$8007
	DC.W	$6208,$0008,$7FF8,$7FF8,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$E00F,$1C00,$0000,$1FF0,$1FF0,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$F83F,$0600,$0000,$07C0,$07C0
	DC.W	$FFFF,$0000,$0000,$0000,$0000,$3FFF,$C000,$4000
	DC.W	$C000,$C000,$FFFE,$0001,$0000,$0001,$0001,$0FFF
	DC.W	$3000,$3000,$F000,$F000,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$07FF,$8800,$0800,$F800,$F800,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$81FF,$6600,$0600,$7E00,$7E00
	DC.W	$FFFF,$0000,$0000,$0000,$0000,$C0FF,$0100,$3100
	DC.W	$3F00,$3F00,$FFFF,$0000,$0000,$0000,$0000,$001F
	DC.W	$83E0,$4BE0,$FFE0,$FFE0,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$000F,$8410,$2010,$FFF0,$FFF0,$FFFE,$0001
	DC.W	$0000,$0001,$0001,$000F,$0890,$9010,$FFF0,$FFF0
	DC.W	$FFFC,$0002,$0000,$0003,$0003,$0007,$0F08,$4008
	DC.W	$FFF8,$FFF8,$FFFC,$0003,$0000,$0003,$0003,$0007
	DC.W	$1D08,$2008,$FFF8,$FFF8,$FFFE,$0001,$0000,$0001
	DC.W	$0001,$0003,$F10C,$000C,$FFFC,$FFFC,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$0003,$8084,$0004,$FFFC,$FFFC
	DC.W	$FFFF,$0000,$0000,$0000,$0000,$8003,$4004,$0004
	DC.W	$7FFC,$7FFC,$FFFF,$0000,$0000,$0000,$0000,$C003
	DC.W	$3104,$0004,$3FFC,$3FFC,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$F007,$0E00,$0000,$0FF8,$0FF8,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$FC1F,$0300,$0000,$03E0,$03E0
	DC.W	$FFFF,$0000,$0000,$0000,$0000,$9FFF,$6000,$2000
	DC.W	$6000,$6000,$FFFF,$0000,$0000,$0000,$0000,$07FF
	DC.W	$9800,$1800,$F800,$F800,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$83FF,$4400,$0400,$7C00,$7C00,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$C0FF,$3300,$0300,$3F00,$3F00
	DC.W	$FFFF,$0000,$0000,$0000,$0000,$E07F,$0080,$1880
	DC.W	$1F80,$1F80,$FFFF,$0000,$0000,$0000,$0000,$800F
	DC.W	$41F0,$25F0,$7FF0,$7FF0,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$8007,$4208,$1008,$7FF8,$7FF8,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$0007,$8448,$4808,$FFF8,$FFF8
	DC.W	$FFFE,$0001,$0000,$0001,$0001,$0003,$0784,$2004
	DC.W	$FFFC,$FFFC,$FFFE,$0001,$0000,$0001,$0001,$0003
	DC.W	$8E84,$1004,$FFFC,$FFFC,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$0001,$F886,$0006,$FFFE,$FFFE,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$8001,$4042,$0002,$7FFE,$7FFE
	DC.W	$FFFF,$0000,$0000,$0000,$0000,$C001,$2002,$0002
	DC.W	$3FFE,$3FFE,$FFFF,$0000,$0000,$0000,$0000,$E001
	DC.W	$1882,$0002,$1FFE,$1FFE,$FFFF,$0000,$0000,$0000
	DC.W	$0000,$F803,$0700,$0000,$07FC,$07FC,$FFFF,$0000
	DC.W	$0000,$0000,$0000,$FE0F,$0180,$0000,$01F0,$01F0

