iea:	equ	$fffa07
ieb:	equ	$fffa09
isra:	equ	$fffa0f
ima:	equ	$fffa13
tbcr:	equ	$fffa1b
tbdr:	equ	$fffa21
vbl_vec:	equ	$70
key_vec:	equ	$118
hbl_vec:	equ	$120
start:
	clr.l   -(SP)           ;Go into supervisor mode
        move.w  #$20,-(SP)
        trap    #1
        addq.l  #6,SP
        move.l  D0,savesup
	move.b	#0,$484

*	move.w	#4,-(sp)
*	trap	#14
*	addq.l	#2,sp
*	move.w	d0,ressave


setupkey:
	move.w	#1,-(sp)
	move.w	#14,-(sp)
	trap	#14
	addq.l	#4,sp
	move.l	d0,keybuf
	move.w	#$7ff,$ff8924

	move.l	vbl_vec,vblt+2		;set up vbl handler
	move.l	vbl_vec,oldvblvec
	move.l	#vbl_handler,vbl_vec

	lea	channel0params,a0
	move.w	#%00001001,channeloff(a0)
	move.w	#-1,channelprocess(a0)
	lea	channel1params,a0
	move.w	#%00010010,channeloff(a0)
	move.w	#-1,channelprocess(a0)
	lea	channel2params,a0
	move.w	#%00100100,channeloff(a0)
	move.w	#-1,channelprocess(a0)
testloop:
	jsr	keyboard
	move.w	#37,-(sp)
	trap	#14
	addq.l	#2,sp
	bra	testloop



vbl_handler:
	movem.l	d0-d7/a0-a6,-(sp)
	bsr	dosound
	movem.l	(sp)+,d0-d7/a0-a6
vblt:	jmp	$0
***************************************
dosound:
	lea	channel0params,a1
	bsr	dosoundstuff
	lea	channel1params,a1
	bsr	dosoundstuff
	lea	channel2params,a1
dosoundstuff:
	tst.w	channelprocess(a1)
	bmi	noch0
	move.w	#$0000,$ff8240
	subq.w	#1,channellife(a1)
	bpl	still0
	move.w	#-1,channelprocess(a1)
	bra	stopsound0
still0:
	tst.w	channelwaveform(a1)	;does it need shaping
	bmi	skip0waveforms
	subq.w	#1,channelspeed2(a1)
	tst.w	channelspeed2(a1)
	bpl	skip0waveforms
	move.w	channelspeed(a1),channelspeed2(a1)
	cmpi.w	#0,channelwaveform(a1)
	bne	ch0p1
	move.w	channelvolume(a1),d1
	addq.w	#1,d1
	cmpi.w	#16,d1
	blt	ch0pl
	moveq	#15,d1
ch0pl:
	bra	finalwaveform
ch0p1:
	cmpi.w	#1,channelwaveform(a1)
	bne	ch0p2
	move.w	channelvolume(a1),d1
	subq.w	#1,d1
	cmpi.w	#0,d1
	bge	ch0pu
	moveq	#0,d1
ch0pu:
	bra	finalwaveform
ch0p2:
	cmpi.w	#2,channelwaveform(a1)
	bne	ch0p3
	move.w	channelvolume(a1),d1
	move.w	channelvel(a1),d2
	add.w	d2,d1
	cmpi.w	#0,d1
	bgt	ch0saw1
	neg.w	channelvel(a1)
	bra	ch0saw2
ch0saw1:
	cmpi.w	#15,d1
	blt	ch0saw2
	neg.w	channelvel(a1)
ch0saw2:
	bra	finalwaveform
ch0p3:
	cmpi.w	#3,channelwaveform(a1)
	bne	ch0p4
	move.w	channelvolume(a1),d1
	addq.w	#1,d1
	and.w	#$f,d1
	bra	finalwaveform
ch0p4:
	move.w	channelvolume(a1),d1
	subq.w	#1,d1
	bge	finalwaveform
	moveq	#15,d1
finalwaveform:
	move.w	d1,channelvolume(a1)
	move.w	channelvolreg(a1),d0
	bsr	writedata
skip0waveforms:
	moveq	#0,d7
	move.w	channelreg(a1),d7
	bmi	noch0
	move.w	channelreg2(a1),d2
	move.w	(a1,d2.w),d1
	add.w	channeladd(a1),d1
	cmp.w	channelcmp(a1),d1
	bne	not0end
	move.w	#-1,channelprocess(a1)
	bsr	stopsound0
not0end:
	move.w	d1,(a1,d2.w)
	move.w	d7,d0
	bsr	writedata
noch0:
	rts
stopsound0:
	move.b	mymixer,d1
	or.w	channeloff(a1),d1	;reg
	move.b	d1,mymixer
	move.b	#7,d0
	bsr	writedata
	rts

writedata:
	move.b	d0,$ff8800
	cmp.b	#7,d0
	bne	wd2
	and.b	#$3f,d1
	move.b	$ff8800,d0
	and.b	#$c0,d0
	or.b	d0,d1
wd2:
	move.b	d1,$ff8802
	rts
*****************************************
*	Pass ad of soundata in a1	*
*****************************************
startsound:
	movem.l	d0-d1/a0,-(sp)
	cmpi.w	#0,channelprocess(a1)
	bne	start1
	lea	channel0params,a0
	bra	startit
start1:
	cmpi.b	#1,channelprocess(a1)
	bne	start2
	lea	channel1params,a0
	bra	startit
start2:
	lea	channel2params,a0
startit:
	move.l	a0,-(sp)
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.w	#-1,(a0)+
	addq.l	#2,a1		;skip channelprocess
	move.w	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
*	move.l	(a1)+,(a0)+
	move.l	(sp)+,a0

	move.w	channelfine(a0),d1
	move.w	channelfinereg(a0),d0
	bsr	writedata
	move.w	channelcoarse(a0),d1
	move.w	channelcoarsereg(a0),d0
	bsr	writedata
	move.w	channelvolume(a0),d1
	move.w	channelvolreg(a0),d0
	bsr	writedata
	move.w	channelnoise(a0),d1
	beq.s	nonoise
	moveq	#6,d0
	bsr	writedata
	move.w	channelmixa(a0),d1
	bclr	d1,mymixer
	bra.s	skipkl
nonoise:
	move.w	channelmixa(a0),d1
	bset	d1,mymixer
skipkl:
	move.w	channelmixb(a0),d1
	bclr	d1,mymixer
	move.b	mymixer,d1
	moveq	#7,d0
	bsr	writedata
bp1:
	move.w	#1,channelprocess(a0)
	movem.l	(sp)+,d0-d1/a0
	rts

keyclicksound:
	dc.w	$000F,$0001,$0000,$0000,$0000
	dc.w	$0080,$0000,$FFFF,$0000,$0000
	dc.w	$0000,$0000,$0000,$0000,$0003
	dc.w	$0008,$0000,$0001,$0009,$0000
errorsound:
	dc.w	$000E,$FFF2,$000F,$0000,$0000
	dc.w	$0000,$000B,$0003,$001C,$0000
	dc.w	$0001,$0000,$000C,$0000,$0004
	dc.w	$0009,$0002,$0003,$0012,$0001

mymixer:		dc.b	%00111111
even
channel0params:		blk.w	20,0
channel1params:		blk.w	20,0
channel2params:		blk.w	20,0

channelvolume:		equ	0
channelwaveform:	equ	2
channellife:		equ	4
channelspeed:		equ	6
channelspeed2:		equ	8
channelfine:		equ	10
channelcoarse:		equ	12
channelreg:		equ	14
channeladd:		equ	16
channelcmp:		equ	18
channelprocess:		equ	20
channelnoise:		equ	22
channelreg2:		equ	24
channelvel:		equ	26
channelmixa:		equ	28
channelvolreg:		equ	30
channelfinereg:		equ	32
channelcoarsereg:	equ	34
channeloff:		equ	36
channelmixb:		equ	38
	even
****************************************
keyboard:
	move.l	keybuf,a0
	move.w	6(a0),d0
	cmp.w	8(a0),d0
	bne	ischar
	rts
ischar:
	move.w	#2,-(sp)
	move.w	#2,-(sp)
	trap	#13
	addq.l	#4,sp
	swap	d0
quit:	cmpi.w  #$10,d0
	bne	keyplay
	bra	gem
	rts
keyplay:
	cmpi.w	#$3b,d0
	bne	keyback
	lea	keyclicksound,a1
	bsr	startsound
	rts
keyback:
	rts
******************************************
*               RETURN TO GEM
gem:
	move.w	#$0fff,$ff8240
	move.b	#%11111110,$ff820a
	move.l	oldvblvec,vbl_vec

        move.b  #7,$484
      
        move.l  savesup,-(SP)    ;Back to user mode
        move.w  #$20,-(SP)
        trap    #1
        addq.l  #6,SP
illegal
	clr.w	-(sp)
	trap	#1

rvsave:	dc.l	0
resave:	dc.l	0
keybuf:	dc.l	0
savesup:	dc.l	0
oldvblvec:	dc.l	0



