/* =========================================================
	ICONIFY with mFORTH
	C-Source from STC 5/1995 
	corrected and modified by Rainer Saric
	=========================================================
	Simple Programm to show some features of mForth

	* Conditional compiling
	* GEM - Programming
	* Iconify
	* Create standalones
	* Shutdown via AP_TERM

	========================================================= */

#define MAKE -1 immediate		/* Create Application	*/

mforth						/* Reset vocs						*/
hex							/* Defines from gemdefs.h		*/
#define MU_MESAG  0010
decimal
#define WM_CLOSED   22
hex
#define WNAME   	0001
#define CLOSER  	0002
#define SMALLER	4000
decimal
#define WM_REDRAW			20
#define WM_TOPPED			21
#define WM_BUTTOMED		33
#define WM_ICONIFY		34
#define WM_UNICONIFY		35
#define WM_ALLICONIFY	36
#define AP_TERM			50

#define WF_CURRXYWH	 	 5
#define WF_FIRSTXYWH 	11
#define WF_NEXTXYWH		12
#define WF_TOP				10
#define WF_ICONIFY		26
#define WF_UNICONIFY		27

#define END_UPDATE 		0
#define BEG_UPDATE 		1

#define SHW_MSGTYPE		9

/* | is for compatibilty	*/
integer done	|		/* While false do event loop */
integer icony	|		/* Bool, true if window is iconified	*/
integer whandle	|	/* Window handle	*/
8 warray msgbuff 	|	/* Standard message buffer for evnt_multi	*/
4 warray pxy		|	/* temp. buffer	*/
create ws 8 allot	|	/* Size of window	*/
create r1 8 allot	|
create r2 8 allot |

create null_ptn 0 , |

create image_data hex
  003F w, C000 w, 00C0 w, 3000 w, 0100 w, 0800 w, 03FE w, 0400 w, 
  0601 w, 8200 w, 0800 w, 4600 w, 1000 w, 2B00 w, 2000 w, 1500 w, 
  2000 w, 1B00 w, 4000 w, 0D00 w, 4070 w, 0B00 w, 80E8 w, 0F00 w, 
  81A4 w, 0E00 w, 8144 w, 0E00 w, 8184 w, 0C00 w, FF08 w, 1800 w, 
  0010 w, 1000 w, 0020 w, 3FFC w, 0040 w, 7FFE w, 0040 w, BFFE w, 
  0080 w, FFFE w, 0081 w, A1FE w, 0081 w, 4FF8 w, 0081 w, FFC0 w, 
  00FF w, 7F00 w, 0040 w, FC00 w, 00FF w, B800 w, 0081 w, 7000 w, 
  0081 w, A000 w, 0081 w, 4000 w, 0081 w, 8000 w, 00FF w, 0000 w, |
decimal

/* Create object to display an image in iconified windows */
create image image_data a, 16 w, 16 w, 100 w, 100 w, 1 w,
create icony_image
-1 w, -1 w, -1 w, 23 w, 0 w, 0 w, image a, 0 w, 0 w, 32 w, 32 w, |

: blank ( -- )					/* blank default window	*/
	hide_mouse					
	4 msgbuff r2 rc_copy
	r2 4w@ -1 -1 pair+ xywh>xyxy 0 pxy 4w!
	3 msgbuff w@ WF_FIRSTXYWH wind_get r1 4w!
	begin 	r1 2+ @
	while 	r2 4w@ r1 4w@ rc_inter
				if 	1 1 pair- xywh>xyxy 1 s_clip
						0 sf_color
						1 sf_interior	1 sf_style
						0 sf_perimeter 
						0 swr_mode 
						BEG_UPDATE wind_update
							0 pxy 4w@ bar
							icony
							if 	noop	/* Draw Icon	*/
							else	noop 	/* Draw window	*/
							endif
						END_UPDATE wind_update
				else 2drop 2drop
				endif
				3 msgbuff w@ WF_NEXTXYWH wind_get r1 4w!
	repeat
	r1 4w@ 0 s_clip show_mouse ;

: do_events	( -- )
	whandle WF_CURRXYWH wind_get ws 4w!	/* Get current size of Window */
	begin		/* We want only MU_MESAGes	*/
				MU_MESAG 0 0 0  0 0 0 0 0  0 0 0 0 0  0 0
				0 msgbuff evnt_multi >r 2drop 2drop 2drop
				r> MU_MESAG and
				if			0 msgbuff w@
							begin-case
								WM_REDRAW
									case blank
									break
								WM_CLOSED 
									case	true to done	
									break
								WM_ICONIFY
									case	whandle WF_ICONIFY 4 msgbuff 4w@ wind_set
									break
								WM_ALLICONIFY
									case	whandle WF_ICONIFY ws 4w@ wind_set
									break
								WM_UNICONIFY
									case	whandle WF_UNICONIFY ws 4w@ wind_set
									break
								WM_TOPPED
									case whandle WF_TOP 0 0 0 0 wind_set
									break
								AP_TERM	/* Handle shutdown	*/
									case true to done
									break	
							end-case
				endif
	done until ;

: doit	( -- )
	[ WNAME CLOSER + SMALLER + ] literal 
	0 0 32767 32767 wind_create to whandle /* max size of window 	*/
	whandle 0< 		/* Important, if you don't use Multitasking 		*/
	if 	1 s" [1][No more windows!][ Uh Oh ]" form_alert drop 
	else	whandle s" Iconify-Demo" wind_name
			whandle 50 100 300 100 wind_open
			do_events
			whandle wind_close
			whandle wind_delete
	endif ;

: main	( -- )
	appl_init 0>=
	if		arrow
			graf_handle v_handle w! 2drop 2drop
			1 1 1 1 1 1 1 1 1 1 2 opnvwk 
			contrl 12 + w@ v_handle w!
			global w@ $400 >=
			if	 SHW_MSGTYPE 1 0 0 0 shel_write drop	endif
			doit
			clsvwk
			appl_exit
	endif
	MAKE #if 0 return #endif ;

MAKE #if 
	system make icony.app bye
#endif

