REM==================================================================
REM    				FITNESS PROFILE PROGRAM  (version 509)
REM    * SAVED as Fitpr509.bas          2/24/00 
REM    		for the STe in HiSoft Basic 
REM	   * Should RUN on QUICKBASIC 4.5
REM    * Modified from FITNESS PROFILE version 5.08
REM	   * Rounds off English UNITS to the nearest 1/8
REM    * Printout on Data POSSIBLY PERFECTED
REM    * BODY FAT possibly PERFECTED. Now more accurate. Older versions
REM			had incorrect calc. for older persons body fat levels.
REM    * Needs:    error trapping & hrs. per wk. converion 
REM==================================================================
DIM SHARED AB$,BF$,BL$,BM$,BU$,CA$,CB$,CR$
DIM SHARED EX$,F$,FA$,HT$,LBM$,MR$  
DIM SHARED P$,R$,S$,TC$,TG$,TH$,TP$,TY$,TYMR$,UA$
AB$="WAIST"
BF$="BODY FAT":BL$=" ":BM$="BASAL METABOLIC RATE":BU$="BUTTOCKS(HIPS)"
CA$="CALF":CB$="CARBOHYDRATES":CR$="CALORIC REQUIREMENT"
EX$="HOURS of EXERCISE":F$="FATS":FA$="FOREARM"
HT$="HEIGHT"::LBM$="LEAN BODY MASS is estimated to be"
MR$="RESTING METABOLIC RATE"
P$="PROTEIN":TH$="THIGH":UA$="UPPER ARM"
TY$="You are TOO YOUNG to have your body composition computed"
TYMR$="You are TOO YOUNG to have your METABOLIC RATE computed"
DIM SHARED AAF,AB,ACT,ADJ,ADJUSTBF,ADJUSTMENT,ADJUSTEE,ADJUSTOR,AGE
DIM SHARED BF,BFL,BFD,BM,BU,CA,CB,CBP,CBC,CBG,CR#
DIM SHARED EX,EXW,FA,FC,FG,FT,FP,LB,LBM,LCR,LCRO,LCRU,HEXW,HT,IBF,IN,MR#
DIM SHARED P,PBF,PBFL,PIBF,PIBFL,PRC,PRG,PRP,TC,TG,TH,TP,UA,sa#
DIM SHARED YMAB#,YMUA#,YMFA#,OMAB,OMBU,OMFA
DIM SHARED YWAB#,YWFA#,YWTH#,OWAB,OWCA,OWTH
DIM SHARED ANK,BIC,CAF,CHT,FARM,HIP,KNE,NEC,THI,WAT,WRS,WST
DIM SHARED x(12),part(12),temp(12),tdifference(12)
REM*********************************************************
DATA_GATHERING:
CLS
? "                     FITNESS PROFILE"
? "                       version 509"
? "                     DATA COLLECTION"
? "	              ";Date$
X=5:Y=10
   LOCATE X,Y:? "AGE":LOCATE X,Y+35:INPUT AGE
   LOCATE X,Y+35:? AGE;" YEARS OLD"
  DO
X=8
   LOCATE X,Y:? "GENDER(Male/Female)":LOCATE X,Y+35:INPUT S$
   	IF S$="F" OR  S$="f" THEN 
    	 LOCATE X,Y+35:? " FEMALE"
    	 S$="F"
 	ELSEIF S$="M" OR S$="m" THEN
		 LOCATE X,Y+35:? " MALE"
		 S$="M"
 	ELSE    LOCATE X,Y+35:?"INPUT WRONG LETTER"
         FOR WAIT =1 TO 2500:NEXT WAIT
		 LOCATE X,Y+35:?"                         "
	END IF
  LOOP UNTIL S$="M" OR S$="m" OR S$="F" OR S$="f"
X=11
   LOCATE X,Y:? HT$:LOCATE X+1,Y:? "(FT.,IN.)"
   LOCATE X+1,Y+35:INPUT FT,IN:LOCATE X+1,Y+35:? FT;" FT. ";IN;" IN."
X=15
   LOCATE X,Y:? "WEIGHT":LOCATE X,Y+35:INPUT LB
   LOCATE X,Y+35:? LB;" POUNDS"
X=18
   LOCATE X,Y:? "TOTAL ";EX$; " Per Week"
   LOCATE X,Y+35:INPUT EX:LOCATE X,Y+35:? EX;" HRS/WK"
X=19
   LOCATE X+1,Y:? EX$;" Per Week"
X=21
   LOCATE X,Y+10:?" with WEIGHTS"
   LOCATE X,Y+35:INPUT EXW
   LOCATE X,Y+35:? EXW;" HRS/WK"
  DO
 	IF EXW>EX THEN
 		X=22: Y= 15: LOCATE X,Y
 		? "Exercise with Weights CANNOT BE GREATER THAN Total Exercise" 
 	END IF	
X=24:Y=10
   LOCATE X,Y:? "DO YOU WISH TO CHANGE YOUR DATA(Y or N)"
   LOCATE X,Y+55:INPUT R$
		IF R$="Y" OR R$="y" THEN
		 	GOTO DATA_GATHERING
		ELSEIF R$="N" OR R$="n" THEN
		     CALL DATAPRINTOUT
		ELSE
		 	LOCATE X+1,Y:?"INPUT WRONG LETTER"
	          LOCATE X+1,Y:?"                  "
        END IF

  LOOP UNTIL R$="Y" OR R$="y" OR R$="N" OR R$="n"

SCREEN_MENU:
CLS
DO
  '      Screen MENU of Program
	LOCATE 1,10:?"=============         Fitness Profile         ============="
    locate 2,34:?"Version 509 "
	LOCATE 3,28:? "MENU of Program Choices"
	LOCATE 7,10:? "(1) Body Composition /Body Fat Analysis"
	LOCATE 9,10:? "(2) Nutritional Requirement Analysis"
	LOCATE 11,10:?"(3) Ideal Body Dimension Analysis"
	LOCATE 13,10:?"(4) New Data Input(Another Person or What If Scenarios)"
	LOCATE 15,10:?"(5) Exit(End) Program"
  '      Get CHOICE of MENU selection
	LOCATE 24,20
 		INPUT "Which do you choose? >",choice$
  '      Response to Selection
 	SELECT CASE choice$
 		CASE "1"
    		CALL bodyfat  
 		CASE "2"
    		CALL nutrition
		CASE "3"
    		CALL idealdimensions
		CASE "4"
    		GOTO DATA_GATHERING
		CASE "5"
			LOCATE 24,15
			INPUT "Do you really wish to EXIT Program  (Y/N)";answer$
				IF answer$="y" OR answer$= "Y" THEN EXIT LOOP
		CASE ELSE
	CALL renumber
	END SELECT
CLS
LOOP

END
REM============================================================
 EARORTRAP:
	CLS
    ? "YOU HAVE MADE SOME TYPE OF ERROR" 
    ?"ERROR # ";ERR;" HAS OCCURRED AT LINE ";ERL
DO
 LOCATE 25,15:? " Hit the number 0 to continue";
 INPUT anewnumber$
 LOCATE 23,15:?"                                 "
 LOCATE 24,40:?"               "
LOOP UNTIL anewnumber$="0"

   RESUME  SCREEN_MENU
'======================================================================
SUB renumber
DO
 LOCATE 24,15:? " Input a NUMBER from 1 to 5 "
 LOCATE 25,15:? " Hit the number 0 to continue";
 		INPUT anewnumber$
 LOCATE 23,15:?"                                 "
 LOCATE 24,40:?"               "
LOOP UNTIL anewnumber$="0"
END SUB
'=====================================================================
SUB bodyfat
CLS
			REM  Branches to appropriate age/gender subroutine
			REM : Possible source of Tables for BODY FAT from book
			REM    "Getting In Shape" by Katch, McArdle and Boylan
			REM		Houghton Mifflin Co.   Boston 1979
 	ADJUSTOR=0:ADJUSTEE=0:BFL=0:IBF=0:BF#=0: LBM=0
	PBF=0:PBFL=0:PIBF=0:PIBFL=0
 LPRINT CHR$(27);CHR$(40);CHR$(115);CHR$(51);CHR$(66):    REM BOLD PRINT
 LPRINT "     BODY FAT ESTIMATE"
 LPRINT CHR$(27);CHR$(40);CHR$(115);CHR$(48);CHR$(66):    REM NO BOLD PRINT 
 LPRINT "  ";BF$;" DATA"
     IF age<17 THEN
     	? ty$
     	LPRINT ty$ 
     	CALL RESUME_PROGRAM
     	
	 ELSEIF AGE>=17 AND age<36 AND S$="F" THEN
                         CALL YOUNG_FEMALE(temp,tdifference)       
	 ELSEIF AGE>=36 AND  S$="F" THEN
                         CALL OLDER_FEMALE(temp,tdifference) 
	 ELSEIF AGE>=17 AND age<36 AND S$="M" THEN
                         CALL YOUNG_MALE(temp,tdifference) 
	 ELSEIF AGE>=36 AND S$="M" THEN
                         CALL OLDER_MALE(temp,tdifference)
 	 END IF                         

END SUB    
REM================================================================
 SUB ADJUSTORS
					REM Interpolates BODY FAT%
		ADJUSTEE=BF-BFL:?"adjustee=";adjustee
		ADJUSTMENT=ADJUSTEE*ADJUSTOR:?"adjustment=";adjustment
		ADJUSTBF=BFL+ADJUSTMENT:?"adjustbf=";adjustbf
		IBF=INT((ADJUSTBF +.005)*100)/100
		 
 END SUB
REM =============================================================== 
SUB YOUNG_FEMALE(temp,tdifference)     REM    ** YOUNG WOMEN BODY FAT  17-35 [ <36 ]  **
CLS
?"THIS IS YOUNG FEMALE BODY FAT SUBROUTINE"
    X=7:Y=25
   		LOCATE X,4
   			? AB$;" ";
    	LOCATE X,Y:INPUT AB
   							LPRINT "   ";AB$;"   ";
   							LPRINT USING "##.###";AB;
   							LPRINT " in."
		  YWAB#=0.02+((AB*4)*0.33405)  
				            ?"YWAB = ";YWAB#
    X=9:Y=25
   		LOCATE X,4
   			? TH$;" ";
   		LOCATE X,Y:INPUT TH
              				LPRINT "   ";TH$;"   ";
              				LPRINT USING "##.###";TH;
              				LPRINT " in."
    	  YWTH#=0.01+((TH*4)*0.52)
							?"YWTH = ";YWTH#
  	X=11:Y=25
   		LOCATE X,4
   			? FA$;" ";
   		LOCATE X,Y:INPUT FA
              				LPRINT "   ";FA$;" ";
              				LPRINT USING "##.###";FA;
              				LPRINT " in."
   		  YWFA#=2.5E-03+((FA*4)*1.0775)
							?"YWFA = ";YWFA#

  REM Age Activity Factor
	 		IF EX>=4 THEN 
 				AAF=22.6
 			ELSEIF EX<4 THEN
 				AAF=19.6
			END IF
			
  REM BODY FAT CALCULATION
	  		BF=(YWAB#+YWTH#-YWFA#-AAF)
	  
CALL YOUNG_PERSON_ACTIVITY
CLS
END SUB
REM=============================================================
SUB young_male(temp,tdifference)    REM ** YOUNG MEN BODY FAT 17-35 [ <36 ]  **
CLS
  	X=7:Y=25
 		LOCATE X,4
   			? AB$;" ";
   		LOCATE X,Y:INPUT AB
   							LPRINT "   ";AB$;"     ";
   							LPRINT USING "##.###";AB;
   							LPRINT " in."           
   		  YMAB#=0.01+((AB*4)*0.328)  
							?"YMAB = ";YMAB#
    X=9:Y=25
   		LOCATE X,4
   			? UA$;" ";
   		LOCATE X,Y:INPUT UA
      						LPRINT "   ";UA$;" ";
   							LPRINT USING "##.###";UA;
   							LPRINT " in."           
    	  YMUA#=0.01+((UA*4)*0.925)
							?"YMUA = ";YMUA#
  	X=11:Y=25
   		LOCATE X,4
   			? FA$;" ";
   		LOCATE X,Y:INPUT FA
   							LPRINT "   ";FA$;"   ";
   							LPRINT USING "##.###";FA;
   							LPRINT " in."           
   		  YMFA#=FA*4*1.3575
							?"YMFA = ";YMFA#

  REM Age Activity Factor
	 	IF EX>=4 THEN 
 			AAF=14.2
 		ELSEIF EX<4 THEN
 			AAF=10.2
		END IF
		
  REM BODY FAT CALCULATION
      	BF=(YMAB#+YMUA#-YMFA#-AAF)
 
 CALL YOUNG_PERSON_ACTIVITY   
 CLS 
 END SUB
REM===========================================================
SUB YOUNG_PERSON_ACTIVITY

  	 IF EXW>=10 THEN
   	 	BF=BF/2  
	
	 ELSEIF EXW>=6 AND EXW<10 THEN
	    BFL=BF/2    
		BF=BF/1.5:HEXW=10 
		ADJUSTOR=(HEXW-EXW)/4	:REM Used to interpolate body fat 
		           
			CALL ADJUSTORS
	 ELSEIF EXW<6 THEN
	    BFL=BF/1.5     
		BF=BF:HEXW=6
		ADJUSTOR=(HEXW-EXW)/6	:REM Used to interpolate body fat
		           
			CALL ADJUSTORS
	 ELSE BF=BF     
		
	 END IF
   		
CALL YOUNG_BODY_FAT_PRINTOUT(temp,tdifference)
END SUB
REM==================================================================
SUB YOUNG_BODY_FAT_PRINTOUT(temp,tdifference)

	BF=INT((BF+5.0E-03)*100)/100
	BFL=INT((BFL+5.0E-03)*100)/100
	PBF=LB*BF/100
	PBF=INT((PBF+5.0E-03)*100)/100:REM -->LBS.of Fat
		Temp=pbf
		CALL rounding_off(temp,tdifference)
		pbf=FIX(temp) + tdifference
            ? "BODY FAT ESTIMATE   (UNINTERPOLATED)        ";
            PRINT USING "##.##";BF;
            ?" %  or  ";
            PRINT USING "##.###";PBF;
            ?" lbs. of FAT"
        	LPRINT "BODY FAT(uninterpolated) is Estimated to be ";
    		LPRINT USING "##.##";BF;
    		LPRINT" %  or  ";
    		LPRINT USING "##.###";PBF;
    		LPRINT " lbs. of Fat"

	IF EXW<10  THEN
		PBFL=LB*BFL/100:PBFL=INT((PBFL+5.0E-03)*100)/100:REM -->LBS.of Fat at next level
			Temp=pbfl
			CALL rounding_off(temp,tdifference)
			pbfl=FIX(temp) + tdifference
  		PRINT "BODY FAT at the NEXT LEVEL is Estimated at  ";
        PRINT USING "##.##";BFL;
        PRINT " %  or  ";
        PRINT USING "##.###";PBFL;
        PRINT " lbs. of Fat" 	
    	LPRINT "BODY FAT at the NEXT LEVEL is Estimated at  ";
        LPRINT USING "##.##";BFL;
        LPRINT " %  or  ";
        LPRINT USING "##.###";PBFL;
      	LPRINT " lbs. of Fat" 		
	END IF
	
	IF EXW>= 10 OR EXW=6 OR EXW=0 THEN
		PIBF=PBF
		? "Interpolation does not apply here."
		LPRINT"Interpolation does not apply here."
    ELSE     
  		PIBF=LB*IBF/100:PIBF=INT((PIBF+5.0E-03)*100)/100:REM -->interpolated LBS.of Fat
			Temp=pibf
			CALL rounding_off(temp,tdifference)
			pibf=FIX(temp) + tdifference
			 	? "BODY FAT ESTIMATE   (interpolated)          ";
			 	PRINT USING "##.##"; IBF;
            	?" %  or  ";
            	PRINT USING "##.###"; PIBF;
             	?" lbs. of FAT"
             	LPRINT "BODY FAT(interpolated) is Estimated to be   ";
             	LPRINT USING "##.##"; IBF;
             	LPRINT" %  or  ";
             	LPRINT USING "##.###"; PIBF;
             	LPRINT" lbs. of FAT"
	END IF
	
	LBM=LB-PIBF:    REM Lbs. of LEAN BODY MASS
	?lbm$;" ";
	PRINT USING "###.###";LBM;
	?" lbs."
	LPRINT lbm$;" "; 
	LPRINT USING "###.###";LBM;
	LPRINT " lbs."

	IF EXW<10 THEN
        PRINT " **  Additional exercise, especially weightlifting, will result"
        PRINT "     in a lower body fat level even at your current dimensions."
        LPRINT " **  Additional exercise, especially weightlifting, will result"
        LPRINT "     in a lower body fat level even at your current dimensions."
	ELSEIF EXW>= 10 THEN
   		PRINT "     **  Additional exercise will not lower your body fat level."
   		PRINT "         Changes in your measurements will result in Body Fat Changes." 
   		LPRINT "     **  Additional exercise will not lower your body fat level."
   		LPRINT "         Changes in your measurements will result in Body Fat Changes." 
	END IF

CALL RESUME_PROGRAM
ADJUSTOR=0:ADJUSTEE=0:BFL=0:IBF=0:BF#=0	
 
END SUB
REM================================================================
SUB OLDER_FEMALE(temp,tdifference)     REM ** OLDER FEMALE BODY FAT  >=36  **

CLS
?"THIS IS OLDER FEMALE BODY FAT SUBROUTINE" 
    X=7:Y=25
   		LOCATE X,4
   			? AB$;" ";
   		LOCATE X,Y:INPUT AB
      						LPRINT "   ";AB$;"   ";
   							LPRINT USING "##.###";AB;
   							LPRINT " in."           
    	  OWAB#=0.005+((AB*4)*0.29683)  
	          				?"OWAB = ";OWAB#
    X=9:Y=25
   		LOCATE X,4
   			? TH$;" ";
   		LOCATE X,Y:INPUT TH
   							LPRINT "   ";TH$;"   ";
   							LPRINT USING "##.###";TH;
   							LPRINT " in."           
     	  OWTH#=TH*4*0.30913
							?"OWTH = ";OWTH#
  	X=11:Y=25
   		LOCATE X,4
   			? CA$;" ";
   		LOCATE X,Y:INPUT CA
   							LPRINT "   ";CA$;"    ";
   							LPRINT USING "##.###";CA;
   							LPRINT " in."           
   		  OWCA#=CA*4*0.3615
							?"OWCA = ";OWCA#

  REM Age Activity Factor
 		IF EX>=4 THEN 
 			AAF=21.4
 		ELSEIF EX<4 THEN
 		 	AAF=18.4
		END IF
		
  REM BODY FAT CALCULATION
  		BF=(OWAB#+OWTH#-OWCA#-AAF)
   
 CALL OLD_PERSON_ACTIVITY
  
CLS
END SUB
REM=========================================================== 
SUB OLDER_MALE(temp,tdifference)     REM ** OLDER MEN BODY FAT  >=36  **

CLS
?"THIS IS OLDER MALE BODY FAT SUBROUTINE" 
    X=7:Y=25
   		LOCATE X,4
   			? AB$;" ";
    	LOCATE X,Y:INPUT AB
   							LPRINT "   ";AB$;"          ";
   							LPRINT USING "##.###";AB;
   							LPRINT " in."           
     	  OMAB#=0.22+((AB*4)*0.222317)  
	        				?"OMAB = ";OMAB#
    X=9:Y=25
   		LOCATE X,4
   			? BU$;" ";
    	LOCATE X,Y:INPUT BU
   							LPRINT "   ";BU$;" ";
   							LPRINT USING "##.###";BU;
   							LPRINT " in."             
     		  OMBU#=BU*4*0.262
						   	?"OMBU = ";OMBU#
  	X=11:Y=25
   		LOCATE X,4
   			? FA$;" ";
    	LOCATE X,Y:INPUT FA
   							LPRINT "   ";FA$;"        ";
   							LPRINT USING "##.###";FA;
   							LPRINT " in."           
    	  OMFA#=FA*4*0.75045
							?"OMFA = ";OMFA#

  REM Age Activity Factor
		IF EX>=4 THEN
 			 AAF=19
 		ELSEIF EX<4 THEN
 		 	 AAF=15
		END IF
		
  REM BODY FAT CALCULATION
		BF=(OMAB#+OMBU#-OMFA#-AAF)

 CALL OLD_PERSON_ACTIVITY 
CLS
END SUB

REM================================================================
SUB OLD_PERSON_ACTIVITY
   	 
		IF EXW>=8 THEN
  	 		BF=BF/2
 	 	       	 	      
	 	ELSEIF EXW>=4 AND EXW<8 THEN
	 		BFL=BF/2
	    	BF=BF/1.5:HEXW=8    
			ADJUSTOR=(HEXW-EXW)/4
			
				CALL ADJUSTORS
		 ELSEIF EXW<4 THEN
		 	BFL=BF/1.5
		    BF=BF:HEXW=4
			ADJUSTOR=(HEXW-EXW)/4

				CALL ADJUSTORS
		ELSE BF=BF     
			
	    END IF
     
 CALL OLD_BODY_FAT_PRINTOUT(temp,tdifference)

END SUB
REM============================================================================
SUB OLD_BODY_FAT_PRINTOUT(temp,tdifference)

	BF=INT((BF+5.0E-03)*100)/100
	BFL=INT((BFL+5.0E-03)*100)/100
	PBF=LB*BF/100
	PBF=INT((PBF+5.0E-03)*100)/100:REM -->LBS.of Fat
		Temp=pbf
		CALL rounding_off(temp,tdifference)
		pbf=FIX(temp) + tdifference
            ? "BODY FAT ESTIMATE   (UNINTERPOLATED)        ";
            PRINT USING "##.##";BF;
            ?" %  or  ";
            PRINT USING "##.###";PBF;
            ?" lbs. of FAT"
        	LPRINT "BODY FAT(uninterpolated) is Estimated to be ";
    		LPRINT USING "##.##";BF;
    		LPRINT" %  or  ";
    		LPRINT USING "##.###";PBF;
    		LPRINT " lbs. of Fat"

	IF EXW<8  THEN
		PBFL=LB*BFL/100:PBFL=INT((PBFL+5.0E-03)*100)/100:REM -->LBS.of Fat at next level
			Temp=pbfl
			CALL rounding_off(temp,tdifference)
			pbfl=FIX(temp) + tdifference
  				PRINT "BODY FAT at the NEXT LEVEL is Estimated at  ";
        		PRINT USING "##.##";BFL;
        		PRINT " %  or  ";
        		PRINT USING "##.###";PBFL;
        		PRINT " lbs. of Fat" 	
    			LPRINT "BODY FAT at the NEXT LEVEL is Estimated at  ";
        		LPRINT USING "##.##";BFL;
        		LPRINT " %  or  ";
        		LPRINT USING "##.###";PBFL;
      			LPRINT " lbs. of Fat" 		
	END IF
	
	IF EXW>= 8 OR EXW=4 OR EXW=0 THEN
		PIBF=PBF
		? "Interpolation does not apply here."
		LPRINT"Interpolation does not apply here."
    ELSE     
  		PIBF=LB*IBF/100:PIBF=INT((PIBF+5.0E-03)*100)/100:REM -->interpolated LBS.of Fat
			Temp=pibf
			CALL rounding_off(temp,tdifference)
			pibf=FIX(temp) + tdifference	
			 	? "BODY FAT ESTIMATE   (interpolated)          ";
				 PRINT USING "##.##"; IBF;
             	?" %  or  ";
             	PRINT USING "##.###"; PIBF;
             	?" lbs. of FAT"
             	LPRINT "BODY FAT(interpolated) is Estimated to be   ";
             	LPRINT USING "##.##"; IBF;
            	 LPRINT" %  or  ";
             	LPRINT USING "##.###"; PIBF;
             	LPRINT" lbs. of FAT"
	END IF
	
	LBM=LB-PIBF:		REM   Lbs. of Lean Body Mass 
	?lbm$;" ";
	PRINT USING "###.###";LBM;
	?" lbs."
	LPRINT lbm$;" "; 
	LPRINT USING "###.###";LBM;
	LPRINT " lbs."

	IF EXW<8 THEN
        PRINT " **  Additional exercise, especially weightlifting, will result"
        PRINT "     in a lower body fat level even at your current dimensions."
        LPRINT " **  Additional exercise, especially weightlifting, will result"
        LPRINT "     in a lower body fat level even at your current dimensions."
	ELSEIF EXW>= 8 THEN
   		PRINT "     **  Additional exercise will not lower your body fat level."
   		PRINT "         Changes in your measurements will result in Body Fat Changes." 
   		LPRINT "     **  Additional exercise will not lower your body fat level."
   		LPRINT "         Changes in your measurements will result in Body Fat Changes." 
	END IF

CALL RESUME_PROGRAM
ADJUSTOR=0:ADJUSTEE=0:BFL=0:IBF=0:BF#=0	
 
END SUB
'====================================================================
SUB nutrition
CLS
     IF age<12 THEN
     	? TYMR$
     	LPRINT TYMR$ 
     	CALL RESUME_PROGRAM
     	GOTO SCREEN_MENU
	ELSEIF AGE=>12 THEN
		CALL activity_level_menu
		CALL ACTIVITY_RESPONSE(ACT)
	END IF
 REM CR$ DATA
		 WT=LB/2.2
		 HT=((FT*12)+IN)*2.54
     	 SA#=HT^0.725*WT^0.425*7.184E-03:?sa#
			REM : Dubois Formula for surface area
			REM : Merck Manual 11th ed., p.111
	 IF S$="F" THEN CALL FEMALE_MINUTE_METABOLISM(AGE,ACT,WT,HT,SA#)    REM GOTO 2200
	 IF S$="M" THEN CALL MALE_MINUTE_METABOLISM(AGE,ACT,WT,HT,SA#)      REM GOTO 2300

END SUB
 REM******************************************************************
  SUB FEMALE_MINUTE_METABOLISM(AGE,ACT,WT,HT,SA#)
	 IF AGE=12 THEN mr#=0.738
	 IF AGE=13 THEN mr#=0.715
 	 IF AGE=14 THEN mr#=0.69
	 IF AGE=15 THEN mr#=0.668
	 IF AGE=16 THEN mr#=0.647
	 IF AGE=17 THEN mr#=0.63
	 IF AGE=18 OR 19 THEN mr#=0.615
	 IF AGE>=20 AND AGE<=29 THEN mr#=0.603
	 IF AGE>=30 AND AGE<=39 THEN mr#=0.603*0.98
	 IF AGE>=40 AND AGE<=49 THEN mr#=0.603*0.96
	 IF AGE>=50 AND AGE<=59 THEN mr#=0.603*0.94
	 IF AGE>=60 AND AGE<=69 THEN mr#=0.603*0.92
	 IF AGE>=70 AND AGE<=79 THEN mr#=0.603*0.9
	 IF AGE>=80 THEN mr#=0.603*0.85
	 
CALL Bmr_CR_CALC(AGE,ACT,mr#,SA#)	

END SUB
REM*********************************************************************
 SUB MALE_MINUTE_METABOLISM(AGE,ACT,WT,HT,SA#)

	 IF AGE=12 THEN mr#=0.779
	 IF AGE=13 AND AGE<=15 THEN mr#=0.772
	 IF AGE=16 THEN mr#=0.762
	 IF AGE=17 THEN mr#=0.746
	 IF AGE=18 THEN mr#=0.721
	 IF AGE=19 THEN mr#=0.705
	 IF AGE=20 OR 21 THEN mr#=0.69
	 IF AGE>=22 AND AGE<=29 THEN mr#=0.68
	 IF AGE>=30 AND AGE<=39 THEN mr#=0.68*0.98
	 IF AGE>=40 AND AGE<=49 THEN mr#=0.68*0.96
	 IF AGE>=50 AND AGE<=59 THEN mr#=0.68*0.94
	 IF AGE>=60 AND AGE<=69 THEN mr#=0.68*0.92
	 IF AGE>=70 AND AGE<=79 THEN mr#=0.68*0.9
	 IF AGE>=80 THEN mr#=0.68*0.85

CALL Bmr_CR_CALC(AGE,ACT,mr#,SA#)

END SUB
REM*****************************************************************
 SUB Bmr_CR_CALC(AGE,ACT,mr#,SA#)	 
	
	 bmr=SA#*mr#*60*24:?"bmr=";bmr
  
   REM CR$ CALC*****************************
	 IF ACT=1 THEN AL=1.3
	 IF ACT=2 THEN AL=1.5
	 IF ACT=3 THEN AL=1.7
	 IF ACT=4 THEN AL=2
	 CR#=bmr*AL:?"cr#=";cr#
	 LCR=INT((CR#+0.005)*100)/100

	REM ******* NUTRIENT NEEDS*************

		REM ****  PRG=G$ OF P$  *******             
 			IF AGE<=14 THEN GOTO 2530
 			IF AGE>14 AND AGE<=21 THEN GOTO 2550
 			IF AGE>21 AND AGE<35 THEN GOTO 2570
 			IF AGE>=35 THEN GOTO 2610
	
		2530 REM ***** AGE 14 & UNDER *******
			IF ACT=4 THEN GOTO 2642
		 	IF ACT=3 THEN GOTO 2644
			IF ACT<=2 THEN GOTO 2646

		2550 REM **** AGES 14+ TO 21 ********              
			IF ACT=4 AND EX>=10 AND EXW>=4 THEN GOTO 2642
			IF ACT=4 AND EX>=10 AND EXW<4 THEN GOTO 2644
			IF ACT=3 AND EX>=4 AND EX<10 AND EXW>=2 AND EXW<4 THEN GOTO 2646
			IF ACT=3 AND EX>=4 AND EX<10 AND EXW<2 THEN GOTO 2648
			IF ACT=2 AND EX>=2 AND EX<4 THEN GOTO 2650
	 		IF ACT=2 AND EX<2 THEN GOTO 2652
	 		IF ACT=1 THEN GOTO 2654

		2570 REM **** AGES 21+ TO -35 *******
	 		IF ACT=4 AND EX>=10 AND EXW>=10 THEN GOTO 2642
	 		IF ACT=4 AND EX>=10 AND EXW>7 AND EXW<10 THEN GOTO 2644
	 		IF ACT=4 AND EX>=10 AND EXW>5 AND EXW<=7 THEN GOTO 2646
	 		IF ACT=4 AND EX>=10 AND EXW>3 AND EXW<=5 THEN GOTO 2648
	 		IF ACT=4 AND EX>=10 AND EXW<=3 THEN GOTO 2652
	 		IF ACT=4 AND EX<10 THEN GOTO 2654
	 		IF ACT=3 AND EX>=4 AND EX<10 AND EXW>=8 AND EXW<10 THEN GOTO 2646
	 		IF ACT=3 AND EX>=4 AND EX<10 AND EXW>=6 AND EXW<8 THEN GOTO 2648
	 		IF ACT=3 AND EX>=4 AND EX<10 AND EXW>=4 AND EXW<6 THEN GOTO 2650
	 		IF ACT=3 AND EX>=4 AND EX<10 AND EXW<4 THEN GOTO 2652
	 		IF ACT=3 AND EX<4 THEN GOTO 2656
	 		IF ACT=2 AND EX>=2 AND EX<3 AND EXW>=2 AND EXW<=3 THEN GOTO 2654
	 		IF ACT=2 AND EX>=2 AND EX<3 AND EXW<2 THEN GOTO 2656
	 		IF ACT=2 AND EX<2 THEN GOTO 2656
	 		IF ACT=1 THEN GOTO 2658

		2610 REM ******* AGES 35+ ***********
	 		IF ACT=4 AND EX>=8 AND EXW>=8 THEN GOTO 2642
	 		IF ACT=4 AND EX>=8 AND EXW>=6 AND EXW<8 THEN GOTO 2646
	 		IF ACT=4 AND EX>=8 AND EXW>=4 AND EXW<6 THEN GOTO 2648
	 		IF ACT=4 AND EX>=8 AND EXW<4 THEN GOTO 2650
	 		IF ACT=4 AND EX<=8 THEN GOTO 2654
	 		IF ACT=3 AND EX>=3 AND EX<8 AND EXW>=6 AND EXW<8 THEN GOTO 2648
	 		IF ACT=3 AND EX>=3 AND EX<8 AND EXW>=4 AND EXW<6 THEN GOTO 2650
	 		IF ACT=3 AND EX>=3 AND EX<8 AND EXW<4 THEN GOTO 2652
	 		IF ACT=3 AND EX<3 THEN GOTO 2654
	 		IF ACT=2 THEN GOTO 2656
	 		IF ACT=1 THEN GOTO 2658

	2640 REM *** COMPUTER FORMULAE FOR  PROTEIN REQUIREMENTS ****

		2642 PRG=LB:GOTO 2670:REM 1G/LB =2.2G/2.2LB
		2644 PRG=INT((LB/1.1)+0.5):GOTO 2670:REM .9G/LB=2G/2.2LB
		2646 PRG=INT((LB/1.25)+0.5):GOTO 2670:REM .8/LB=1.76G/2.2LB
		2648 PRG=INT((LB/1.33)+0.5):GOTO 2670:REM .75G/LB=1.65G/2.2LB
		2650 PRG=INT((LB/1.47)+0.5):GOTO 2670:REM .68G/LB=1.5G/2.2LB
		2652 PRG=INT((LB/1.5)+0.5):GOTO 2670:REM .67G/LB=1.47G/2.2LB
		2654 PRG=INT((LB/1.75)+0.5):GOTO 2670:REM .57G/LB=1.25G/2.2LB
		2656 PRG=INT((LB/2)+0.5):GOTO 2670:REM .5G/LB=1.1G/2.2LB
		2658 PRG=INT((LB/2.2)+0.5):GOTO 2670:REM .45G/LB=1G/2.2LB
		2670 PRC=INT(4*(PRG)+0.5):REM C$ FROM P$

	 PRP=INT((PRC*1000/CR#)+.5)/10:REM %P$
	 CBP=60.0:REM %CB$
	 CBC=INT((CR#*0.6)+0.5):REM C$ FROM CB$
	 CBG=INT((CBC/4)+0.5):REM G$ OF CB$
	 FP=100-PRP-CBP:REM %F$
	 FC=INT(CR#*(FP/100)+0.5):REM C$ OF F$
	 FG=INT((FC/9)+0.5):REM G$ OF F$

REM ******  CHART OF NUTRIENT REQ. ***********
	CLS
	 LOCATE 2,10:? "NUTRIENT REQUIREMENT for ACTIVITY LEVEL ";ACT 
	 LOCATE 4,2:? "NUTRIENT"
	 LOCATE 4,20:? "PERCENT"
	 LOCATE 4,30:? "GRAMS"
	 LOCATE 4,40:?"CALORIES"

	LOCATE 5,2:? "________"
	LOCATE 5,20:? "________"
	LOCATE 5,30:? "________"
	LOCATE 5,40:? "________"

	LOCATE 8,2:? P$
	LOCATE 8,20:PRINT USING"####.##"; PRP;:?"%"
	LOCATE 8,30:PRINT USING"####.##"; PRG
	LOCATE 8,40:PRINT USING"####.##"; PRC

	LOCATE 10,2:? CB$
	LOCATE 10,20:PRINT USING"####.##"; CBP;:?"%"
	LOCATE 10,30:PRINT USING"####.##"; CBG
	LOCATE 10,40:PRINT USING"####.##"; CBC

	LOCATE 12,2:? F$
	LOCATE 12,20:PRINT USING"####.##"; FP;:?"%"	
	LOCATE 12,30:PRINT USING"####.##"; FG
	LOCATE 12,40:PRINT USING"####.##"; FC
	FOR DASH=2 TO 52
		LOCATE 13,DASH:PRINT "-"
	NEXT DASH	
	FOR ROW=8 TO 12 STEP 2
	 	LOCATE ROW,50:? " /DAY"
	NEXT ROW
	LOCATE 14,2:? CR$
	LOCATE 14,40:PRINT USING"####.##";PRC + CBC + FC
	LOCATE 14,50:? " /DAY"
		 
 LCR=INT(CR#):LCRU=INT(CR#*0.9):LCRO=INT(CR#*1.1)
 	LOCATE 16,7:? "Your Caloric Range is between "; LCRU;"-";LCRO;"Cal./Day"

CALL NUTREQPRNT
CALL WAIT
END SUB
'====================================================================
SUB idealdimensions
CLS
 REM ******************************
 REM IDEAL BODY DIMENSION SUBROUTINE
 REM ******************************

	LOCATE 2,8:? "IDEAL BODY DIMENSIONS"
	LOCATE 4,1:? "PLEASE GIVE MEASUREMENTS"
	LOCATE 5,2:? "TO THE NEAREST .125 INCH(= 1/8 inch)"
	LOCATE 7,4:? "WRIST MEASUREMENT"
	LOCATE 8,4:INPUT WRS
	LOCATE 10,4:? "ANKLE MEASUREMENT"
	LOCATE 11,4:INPUT ANK
 
		AW=ANK+WRS:     REM AW=ANKLE+WRIST

		ANKLE=ANK:WRIST=WRS
 
  IF S$="M" OR S$="m" THEN 
 	CALL MALE_IDEAL_DIMENSIONS(AW,ANK,ANKLE,BIC,CAF,CHT,FARM,HIP,KNE,NEC,THI,WAT,WRS,WRIST,WST)
 	
  ELSEIF S$="F" OR S$="f" THEN
 	CALL FEMALE_IDEAL_DIMENSIONS(AW,ANK,ANKLE,BIC,CAF,CHT,FARM,HIP,KNE,NEC,THI,WAT,WRS,WRIST,WST) 		
 
  END IF

END SUB 	
REM *************** MALE_IDEAL_DIMENSIONS********************
  SUB  MALE_IDEAL_DIMENSIONS(AW,ANK,ANKLE,BIC,CAF,CHT,FARM,HIP,KNE,NEC,THI,WAT,WRS,WRIST,WST)

	   REM *****************************
       REM <MALE IDEAL DIMENSION FORMLA>
 	   REM <IRON MAN TABLE VERIFICATION>
 	   REM =(ANK+WRS-CORR.FACT.)*5*INCREMENT/.2 >> *5 CHANGES VALUES TO 1 INCH
	   REM *****************************

	 BIC=INT((((aw-6.422)*5*0.3148)+5.0E-03)*100)/100:part(1)=bic:REM BICEPS
	 FARM=INT((((aw-3.82)*5*0.2058)+5.0E-03)*100)/100:part(2)=farm:REM FOREARM
     WRS=INT((((aw+0.1)*5*0.089)+5.0E-03)*100)/100:part(3)=wrs:REM WRIST
	 NEC=INT((((AW-5)*5*0.2932)+5.0E-03)*100)/100:part(4)=nec:REM NECK
	 CHT=INT((((AW-5.92)*5*0.833)+5.0E-03)*100)/100:part(5)=cht:REM CHEST
	 WST=INT((((AW-4.4)*5*0.5424)+5.0E-03)*100)/100:part(6)=wst:REM WAIST
	 HIP=INT((((AW-3.84)*5*0.62)+5.0E-03)*100)/100:part(7)=hip:REM HIP
	 THI=INT((((AW-5.8)*5*0.4445)+5.0E-03)*100)/100:part(8)=thi:REM THIGH
	 KNE=INT((((AW-0.4)*5*0.18642)+5.0E-03)*100)/100:part(9)=kne:REM KNEE
	 CAF=INT((((AW-4.8)*5*0.26955)+5.0E-03)*100)/100:part(10)=caf:REM CALF
	 ANK=INT((((AW-0.09)*5*0.1111)+5.0E-03)*100)/100:part(11)=ank:REM ANKLE
	 WAT=(AW-4.2549)*5*0.026677:REM SQ.RT. OF WT/IN
	 WAT=WAT^2*((FT*12)+IN)
	 WAT=INT(((WAT)+5.0E-03)*100)/100:part(12)=wat:REM WEIGHT
	
	 FOR x=1 TO 12		
		temp(x)=part(x)
		 TEMP=TEMP(X)
			ROUNDING_OFF TEMP,TDIFFERENCE
		TEMP(X)=TEMP
		TDIFFERENCE(X)= TDIFFERENCE
		temp(x)=FIX(temp(x)) + tdifference(x)		
     NEXT x 
       
        CALL MALE_PRINTOUTOFIDEALDIMENSIONS(AW,ANK,ANKLE,BIC,CAF,CHT,FARM,HIP,KNE,NEC,THI,WAT,WRS,WRIST,WST)
     	
END SUB
REM ******* FEMALE_IDEAL_DIMENSIONS ************************
SUB  FEMALE_IDEAL_DIMENSIONS(AW,ANK,ANKLE,BIC,CAF,CHT,FARM,HIP,KNE,NEC,THI,WAT,WRS,WRIST,WST)

        REM********************************
		REM <FEMALE IDEAL DIMENSION FORMLA
	 	REM *******************************
	 CHT=((WRS*5.5)+5.0E-03)*100/100:part(1)=cht
	 WST=((WRS*4.5)+5.0E-03)*100/100:part(2)=wst
	 HIP=((WRS*6)+5.0E-03)*100/100:part(3)=hip
	 THI=((WRS*3.5)+5.0E-03)*100/100:part(4)=thi	 	
	 KNE=((WRS*2.5)+5.0E-03)*100/100:part(5)=kne
	 ANK=((WRS*1.25)+5.0E-03)*100/100:part(6)=ank
	 
	 HT=(FT*12)+IN
      	IF HT=60 THEN WAT=116.5
  		IF HT<>60 THEN WAT=116:REM STANDARDIZES WEIGHT FOR INDIVIDUAL ADJUSTMENT
  		IF HT<60 THEN WAT=WAT+(2*(HT-60)):REM ADJUST WT BY -2 lb./inch UNDER 5'
  		IF HT>60 THEN WAT=WAT+(3*(HT-60)):REM ADJUST WT BY +3 lb./inch OVER 5'
  		
  	IF WRS=5.9 THEN WAT=WAT
  	IF WRS<>5.9 THEN WAT=WAT+((WRS-5.9)*9)
  	
   REM ADJUSTS WEIGHT TO FRAME SIZE(wrist measurement)
		 WAT=INT(((WAT-3)+5.0E-03)*100)/100:part(7)=wat:REM WEIGHT-SHOE HEIGHT ADJUSTMENT

      FOR x=1 TO 7		
		temp(x)=part(x)
		 TEMP=TEMP(X)
			 ROUNDING_OFF TEMP,TDIFFERENCE
		TEMP(X)=TEMP
		TDIFFERENCE(X)= TDIFFERENCE
		 temp(x)=FIX(temp(x)) + tdifference(x)		
     NEXT x 
CALL FEMALE_PRINTOUTOFIDEALDIMENSIONS(AW,ANK,ANKLE,BIC,CAF,CHT,FARM,HIP,KNE,NEC,THI,WAT,WRS,WRIST,WST)

END SUB
'==========================================================================
SUB newdata
LOCATE 24,15:?"                                            "
LOCATE 22,10 ?"There nothing here in 'NEW DATA' subroutine"
CALL WAIT

END SUB

REM ***************** NUTRITION ACTIVITY MENU *********************
SUB ACTIVITY_LEVEL_MENU
CLS
 LOCATE 5,23:? "NUTRITION PROGRAM":
 LOCATE 7,25:? "ACTIVITY LEVELS"
 LOCATE 10,20:? "1) SEDENTARY ACTIVITY"
 LOCATE 12,20:? "2) LIGHT ACTIVITY"
 LOCATE 14,20:? "3) MODERATE ACTIVITY"
 LOCATE 16,20:? "4) STRENUOUS ACTIVITY"
END SUB
REM****************** ACTIVITY_RESPONSE ***************************
SUB ACTIVITY_RESPONSE(ACT)

	DO
      LOCATE 18,5:? "DO YOU NEED DESCRIPTION OF ACTIVITY LEVELS(Y OR N)"
 	  LOCATE 18,55:INPUT R$
 	  	IF R$="Y" OR R$="y" THEN CALL ACTIVITYLEVELS
                CALL activity_level_menu
    LOOP UNTIL R$="Y" OR R$="y" OR R$="N" OR R$="n"	  
    
    DO     
     LOCATE 20,5: INPUT "Press Key with NUMBER of Your Activity Level"; ACT
   	 LOCATE 20,50:?"                                 "
   	LOOP UNTIL ACT=>1 AND ACT=<4  		
     
	LOCATE 22,30: ? "ACTIVITY LEVEL  ";ACT

   CALL WAIT

END SUB
REM====================================================================
SUB ACTIVITYLEVELS

 REM **************************************
 REM
 REM    SUB DESCRIPTION OF ACTIVITY LEVELS
 REM
 REM **************************************
CLS
 LOCATE 4,15:? "ACTIVITY   LEVEL"
 LOCATE 5,15:? "________________"
 LOCATE 9,10:? "1) SEDENTARY    I"
 LOCATE 11,10:? "2) LIGHT       II"
 LOCATE 13,10:? "3) MODERATE   III"
 LOCATE 15,10:? "4) STRENUOUS   IV"
 LOCATE 17,10:? "5) nutrition menu"
 LOCATE 20,12:? "select a #(1-5) "

 ' Get CHOICE of MENU selection
		LOCATE 24,20:INPUT "Which do you choose? >",choice$
'  Response to Selection
 		SELECT CASE choice$
 			CASE "1"
    			CALL SEDENTARY
 			CASE "2"
    			CALL LIGHT
			CASE "3"
    			CALL MODERATE
			CASE "4"
    			CALL STRENUOUS
			CASE "5"
    			CALL RENUMBER
		END SELECT
END SUB
REM ******************* SEDENTARY ACTIVITY ************************
SUB SEDENTARY
CLS
 LOCATE 1,24:? "ACTIVITY LEVEL  I"
 LOCATE 2,24:? "_________________ "
 LOCATE 3,24:? " ` SEDENTARY ` "
 
 LOCATE 5,2:? "In general: "
 LOCATE 6,5:? "SEATED activity with some arm movement"
 LOCATE 7,7:? "AND no more than 2 hrs. of:"
 LOCATE 8,10:? "a) standing"
 LOCATE 9,10:? "b) walking "
 LOCATE 10,10:? "c) exercise"
 LOCATE 12,5:? "EXAMPLE ACTIVITIES:"
 LOCATE 13,15:? "- READING OR STUDYING"
 LOCATE 14,15:? "- WRITING OR TYPING"
 LOCATE 15,15:? "- WATCHING TV OR PLAYING VIDEO GAMES"
 LOCATE 16,15:? "- SEWING, EATING, OR DRIVING"
 LOCATE 17,15:? "- DRAWING OR PAINTING(ART)"
 LOCATE 18,15:? "- PLAYING A MUSICAL INSTRUMENT"
 LOCATE 19,15:? "- PLAYING CARDS"

CALL WAIT
CALL ACTIVITYLEVELS
END SUB
REM *******************  LIGHT ACTIVITY   **************************
SUB LIGHT
CLS
 LOCATE 1,24:? "ACTIVITY LEVEL II"
 LOCATE 2,24:? "_________________"
 LOCATE 3,24:? "` LIGHT ACTIVITY ` "
 LOCATE 5,5:? "In general: "
 LOCATE 6,7: ? "If 17 to 35 : EXERCISE MORE THAN 2 BUT  LESS THAN 4 HRS. PER WEEK"
 LOCATE 7,7: ? "If 36 or Over:EXERCISE MORE THAN 2 BUT  LESS THAN 3 HRS. PER WEEK"
 LOCATE 9,7: ? "STANDING with some arm movement"
 LOCATE 10,7: ? "EXAMPLE ACTIVITIES:"
 LOCATE 12,15: ? "- TEACHING OR LABWORK OR SHOPPING"
 LOCATE 13,15: ? "- CAR MECHANIC OR ELECTRICAL TRADE"
 LOCATE 14,15: ? "- LIGHT CARPENTRY with power tools"
 LOCATE 15,15: ? "- SHOP WORK OR FAST PACED OFFICE WORK"
 LOCATE 16,15: ? "- GOLF OR WALKING(2.5-3 MPH)"
 LOCATE 17,15: ? "- HOUSEWORK using appliances"
 LOCATE 18,15: ? "- RESTURUANT WORK at a moderate pace"

 CALL WAIT
CALL ACTIVITYLEVELS
END SUB 
REM ******************** MODERATE ACTIVITY ***************************
SUB MODERATE
CLS
 LOCATE 1,24: ? "ACTIVITY LEVEL III"
 LOCATE 2,24: ? "__________________"
 LOCATE 3,24: ? "`MODERATE ACTIVITY`"
 LOCATE 5,5: ? "In general: "
 LOCATE 6,7: ? "If 17 to 35 : EXERCISE MORE THAN 4 BUT LESS THAN 10 HRS. PER WEEK"
 LOCATE 7,7: ? "If 36 or Over:EXERCISE MORE THAN 3 BUT LESS THAN 8 HRS. PER WEEK"
 LOCATE 9,7: ? "STANDING with MUCH arm movement OR SEATED with VERY STRENUOUS activity"
 LOCATE 10,7: ? "EXAMPLE ACTIVITIES:"
 LOCATE 11,15: ? "- GARDENING OR LIGHT FARM WORK"
 LOCATE 12,15: ? "- FAST PACED RESTAURANT WORK"
 LOCATE 13,15: ? "- CARPENTRY with hand tools"
 LOCATE 14,15: ? "- SHOPPING WITH BUNDLES"
 LOCATE 15,15: ? "- MODERATE PACED WALKING(3.5-4 MPH)"
 LOCATE 16,15: ? "- DANCING (not AEROBIC PACE)"
 LOCATE 17,15: ? "- RESTURUANT WORK at a fast pace"
 LOCATE 18,15: ? "- LEISURELY PACED SPORTS ACTIVITY"
 LOCATE 19,21: ? "* SLOW PACED CYCLING,TENNIS,etc."
 LOCATE 20,15: ? "- HOUSEWORK without appliances"
 LOCATE 21,21: ? "* SCRUBBING & SWEEPING FLOORS"
 LOCATE 22,21: ? "* LAUNDERING by HAND"
 LOCATE 23,21: ? "* MAKING BEDS / HANGING OUT CLOTHES"

CALL WAIT
CALL ACTIVITYLEVELS
END SUB
REM *********************** STRENUOUS ACTIVITY **********************
SUB STRENUOUS
CLS
 LOCATE 1,24: ? "ACTIVITY LEVEL IV"
 LOCATE 2,24: ? "_________________"
 LOCATE 3,24: ? "STRENUOUS ACTIVITY"
 LOCATE 5,7: ? "In general: "
 LOCATE 6,7: ? "If 17 to 35 :  EXERCISE 10 HRS. OR  MORE PER WEEK"
 LOCATE 7,7: ? "If 36 or Over:  EXERCISE 8 HRS. OR MORE PER WEEK"
 LOCATE 9,7: ? "PERIODS OF RUNNING/VERY LITTLE SITTING"
 LOCATE 10,7: ? "EXAMPLE ACTIVITIES:"
 LOCATE 11,15: ? "- HEAVY FARMING or LUMBERING"
 LOCATE 12,15: ? "- PICK & SHOVEL TYPE WORK"
 LOCATE 13,15: ? "- CONSTRUCTION WORK"
 LOCATE 14,15: ? "- MINE or STEEL WORK"
 LOCATE 15,15: ? "- WALKING UPHILL"
 LOCATE 16,15: ? "- ARMED SERVICE RECRUIT"
 LOCATE 17,15: ? "- UNSKILLED LABOR WORKING WITH HEAVY LOADS"
 LOCATE 18,15: ? "- ANY SPORT or ACTIVITY employing:"
 LOCATE 19,21: ? "* A FAST PACE"
 LOCATE 20,21: ? "* NEARLY CONSTANT MOTION"
 LOCATE 21,21: ? "* HEAVY LOADS or WEIGTHS"

CALL WAIT
CALL ACTIVITYLEVELS
END SUB
REM================================================================
SUB DATAPRINTOUT
      REM         ** SUB ON PRINTER PRINTOUT OF DATA **
      REM  *** PRINTOUT using HEWLWETT PACKARD INKJET PRINTER ***
LPRINT CHR$(27);CHR$(40);CHR$(115);12;CHR$(86):REM DOUBLE WIDTH  POINT SIZE
LPRINT CHR$(27);CHR$(40);CHR$(115);5;CHR$(72):REM DOUBLE WIDTH   PITCH SIZE
LPRINT CHR$(27);CHR$(38);CHR$(100);CHR$(51)CHR$(68):REM UNDERLINE
LPRINT "********** FITNESS PROFILE **********"
LPRINT CHR$(27);CHR$(38);CHR$(100);CHR$(64):REM NO UND
LPRINT "     DATA(taken ";DATE$;")"
LPRINT CHR$(27);CHR$(40);CHR$(115);10;CHR$(86);:REM NO DOUBLE PRINT  POINT SIZE
LPRINT CHR$(27);CHR$(40);CHR$(115);10;CHR$(72);:REM NO DOUBLE WIDTH  PITCH SIZE

	LPRINT "AGE       ";AGE;" YEARS OLD"
	
	IF S$="F" THEN
 		LPRINT "GENDER     FEMALE"
	ELSEIF S$="M" THEN
 		LPRINT "GENDER     MALE"
	END IF
 
	LPRINT "HEIGHT    ";FT;" FT. ";IN;" IN."
 	LPRINT "WEIGHT    ";LB;" POUNDS"
 	LPRINT "EXERCISE  ";CHR$(27);CHR$(40);CHR$(115);CHR$(49);CHR$(83):' ITALICS
		LPRINT " TOTAL     ";EX;" HRS./WK."
		LPRINT " with WTS. ";EXW;" HRS./WK."
	LPRINT CHR$(27);CHR$(40);CHR$(115);CHR$(48);CHR$(83):REM NO ITALICS

END SUB
REM=======================================================================
SUB NUTREQPRNT
REM           SUB OF PRINTOUT OF NUTRITIONAL REQUIREMENT
        REM ******** NUTRIENT REQUIREMENT ESTIMATES **********

 LPRINT CHR$(27);CHR$(40);CHR$(115);CHR$(51);CHR$(66):    REM BOLD PRINT
 LPRINT "     NUTRITIONAL REQUIREMENTS"
 LPRINT CHR$(27);CHR$(40);CHR$(115);CHR$(48);CHR$(66);:    REM NO BOLD PRINT
 LPRINT "               for"
 LPRINT "         ACTIVITY LEVEL ";ACT
 LPRINT " "
 LPRINT "NUTRIENT          PERCENT    GRAMS    CALORIES  "
 LPRINT " "
 LPRINT "Protein          ";
 LPRINT USING "####.##";prp;:LPRINT "     ";  
 LPRINT USING "####";prg;:LPRINT "       ";  
 LPRINT USING "####";prc;:LPRINT "  /Day"  
 LPRINT "Carbohydrates    ";
 LPRINT USING "####.##";cbp;:LPRINT "     ";  
 LPRINT USING "####";cbg;:LPRINT "       ";  
 LPRINT USING "####";cbc;:LPRINT"  /Day"
 LPRINT CHR$(27);CHR$(38);CHR$(100);CHR$(51)CHR$(68);:REM UNDERLINE
 LPRINT "Fats             ";
 LPRINT USING "####.##";fp;:LPRINT "     ";  
 LPRINT USING "####";fg;:LPRINT "       ";
 LPRINT USING "####";fc;:LPRINT "  /Day"
 LPRINT CHR$(27);CHR$(38);CHR$(100);CHR$(64);:REM NO UND  
 LPRINT "       Estimated Caloric requirement:  ";LCR;" CALORIES/DAY"
 LPRINT
 LPRINT "YOUR ACTUAL CALORIC REQUIREMENT LIES SOMEWHERE BETWEEN ";
 LPRINT LCRU;"-";LCRO;"CAL./DAY"

END SUB
REM==================================================================

 SUB MALE_PRINTOUTOFIDEALDIMENSIONS(AW,ANK,ANKLE,BIC,CAF,CHT,FARM,HIP,KNE,NEC,THI,WAT,WRS,WRIST,WST)

 REM *******************************
 REM **    PRINT IDEAL DIMENSION  **
 REM ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

 LPRINT CHR$(27);CHR$(40);CHR$(115);CHR$(51);CHR$(66):    REM BOLD PRINT
 LPRINT "     IDEAL BODY DIMENSIONS  ":REM *** MALE ***
 LPRINT CHR$(27);CHR$(40);CHR$(115);CHR$(48);CHR$(66):    REM NO BOLD PRINT 
 PRINT "  IDEAL BODY DIMENSIONS  ":REM *** MALE ***
 LPRINT "  WRIST ";
 LPRINT USING "##.###"; WRIST;
 LPRINT "     ANKLE ";
 LPRINT USING "##.###";ANKLE
 LPRINT "              ";
 LPRINT CHR$(27);CHR$(38);CHR$(100);CHR$(51)CHR$(68);:REM UNDERLINE
 LPRINT "IDEAL"
 LPRINT CHR$(27);CHR$(38);CHR$(100);CHR$(64):REM NO UND
 PRINT "              IDEAL "
 PRINT "             ______ "
 LPRINT " BICEPS     ";:LPRINT USING "####.###";temp(1);:LPRINT" in."
 PRINT " BICEPS     ";:PRINT USING "####.###";temp(1);:?" in."
 LPRINT " FOREARMS   ";:LPRINT USING "####.###";temp(2);:LPRINT" in."
 PRINT " FOREARMS   ";: PRINT USING"####.###";temp(2);:?" in."
 LPRINT " WRIST      ";:LPRINT USING"####.###";temp(3);:LPRINT" in."
 PRINT " WRIST      ";: PRINT USING"####.###";temp(3);:?" in." 
 LPRINT " NECK       ";: LPRINT USING"####.###";temp(4);:LPRINT" in." 
 PRINT " NECK       ";: PRINT USING"####.###"; temp(4);:?" in." 
 LPRINT " CHEST      ";: LPRINT USING"####.###";temp(5);:LPRINT" in."
 PRINT " CHEST      ";: PRINT USING"####.###";temp(5);:	?" in."
 LPRINT " WAIST      ";: LPRINT USING"####.###";temp(6);:LPRINT" in."
 PRINT " WAIST      ";: PRINT USING"####.###";temp(6);:?" in."
 LPRINT " HIP        ";: LPRINT USING"####.###";temp(7);:LPRINT" in."
 PRINT " HIP        ";: PRINT USING"####.###";temp(7);:?" in." 
 LPRINT " THIGHS     ";: LPRINT USING"####.###";temp(8);:LPRINT" in."
 PRINT " THIGHS     ";: PRINT USING"####.###";temp(8);:?" in."
 LPRINT " KNEES      ";: LPRINT USING"####.###";temp(9);:LPRINT" in."
 PRINT " KNEES      ";: PRINT USING"####.###";temp(9);:?" in."  
 LPRINT " CALVES     ";: LPRINT USING"####.###";temp(10);:LPRINT" in."
 PRINT " CALVES     ";: PRINT USING"####.###";temp(10);:?" in."
 LPRINT " ANKLES     ";: LPRINT USING"####.###";temp(11);:LPRINT" in."
 PRINT " ANKLES     ";: PRINT USING"####.###";temp(11);:?" in."
 LPRINT " WEIGHT     ";: LPRINT USING"####.###";temp(12);:LPRINT" lbs."
 PRINT " WEIGHT     ";: PRINT USING"####.###";temp(12);:?" lbs."

CALL WAIT

END SUB
REM************ female PRINTOUT OF IDEAL DIMENSIONS ******************
SUB FEMALE_PRINTOUTOFIDEALDIMENSIONS(AW,ANK,ANKLE,BIC,CAF,CHT,FARM,HIP,KNE,NEC,THI,WAT,WRS,WRIST,WST)

 LPRINT CHR$(27);CHR$(40);CHR$(115);CHR$(51);CHR$(66):    REM BOLD PRINT
 LPRINT "     IDEAL BODY DIMENSIONS  ":REM ^^^ FEMALE ^^^ 
 LPRINT CHR$(27);CHR$(40);CHR$(115);CHR$(48);CHR$(66):    REM NO BOLD PRINT 
 PRINT "  IDEAL BODY DIMENSIONS  ":REM ^^^ FEMALE ^^^
 LPRINT "  WRIST ";
 LPRINT USING "##.###"; WRIST;
 LPRINT "     ANKLE ";
 LPRINT USING "##.###";ANKLE
 LPRINT "              ";
 LPRINT CHR$(27);CHR$(38);CHR$(100);CHR$(51)CHR$(68);:REM UNDERLINE
 LPRINT "IDEAL"
 LPRINT CHR$(27);CHR$(38);CHR$(100);CHR$(64):REM NO UND
 PRINT "              IDEAL "
 PRINT "             ______ "
 LPRINT " CHEST      ";: LPRINT USING"####.###";temp(1);:LPRINT" in."
 PRINT " CHEST      ";: PRINT USING"####.###";temp(1);:?" in."
 LPRINT " WAIST      ";: LPRINT USING"####.###";temp(2);:LPRINT" in."
 PRINT " WAIST      ";: PRINT USING"####.###";temp(2);:?" in."
 LPRINT " HIP        ";: LPRINT USING"####.###";temp(3);:LPRINT" in."
 PRINT " HIP        ";: PRINT USING"####.###";temp(3);:?" in."
 LPRINT " THIGHS     ";: LPRINT USING"####.###";temp(4);:LPRINT" in."
 PRINT " THIGHS     ";: PRINT USING"####.###";temp(4);:?" in."
 LPRINT " KNEES      ";: LPRINT USING"####.###";temp(5);:LPRINT" in."
 PRINT " KNEES      ";: PRINT USING"####.###";temp(5);:?" in."
 LPRINT " ANKLES     ";: LPRINT USING"####.###";temp(6);:LPRINT" in."
 PRINT " ANKLES     ";: PRINT USING"####.###";temp(6);:?" in."
 LPRINT " WEIGHT     ";: LPRINT USING"####.###";temp(7);:LPRINT" lbs."
 PRINT " WEIGHT     ";: PRINT USING"####.###";temp(7);:?" lbs."

  CALL WAIT
  
END SUB
REM==================================================================
SUB wait
	DO
 		LOCATE 25,15:? " Hit the number 0 to continue";
 			INPUT anewnumber$
 		LOCATE 23,15:?"                                 "
 		LOCATE 24,40:?"               "
	LOOP UNTIL anewnumber$="0"

END SUB
REM ******** RESUME_PROGRAM *********
SUB RESUME_PROGRAM
 	DO
 		LOCATE 24,15:? " Input a NUMBER from 1 to 9 to CONTINUE ";
 			INPUT ANYnumber
 		LOCATE 23,15:?"                                 "
 		LOCATE 24,40:?"                                 "
	LOOP UNTIL ANYnumber>0 OR ANYnumber<10

END SUB
REM *******************************************
REM **   
REM ** ROUNDS OFF to nearest 1/8(=.125)DECIMALLY
REM ** 
REM **         saved as ROUND8TH.BAS   10/15/96
REM *******************************************
SUB ROUNDING_OFF(TEMP,TDIFFERENCE)
 
 				REM PRINT "TEMP(IN ROUND) = ";TEMP
	TEMPFIX = FIX(TEMP)
				REM PRINT "TEMPFIX = ";TEMPFIX
	DIFFERENCE = TEMP - TEMPFIX
				REM PRINT "DIFFERENCE = ";DIFFERENCE

 	IF DIFFERENCE>= .0625 AND  DIFFERENCE< .1875 THEN
 		 TDIFFERENCE = .125 		 
 	ELSEIF DIFFERENCE>= .1875 AND DIFFERENCE <= .3125 THEN
 		 TDIFFERENCE= .25
 	ELSEIF DIFFERENCE>= .3125 AND DIFFERENCE <= .4375 THEN
 		 TDIFFERENCE = .375
 	ELSEIF DIFFERENCE >= .4375 AND DIFFERENCE <= .5625 THEN
 		TDIFFERENCE = .5
    ELSEIF DIFFERENCE >= .5625 AND DIFFERENCE <= .6875 THEN
    	 TDIFFERENCE = .625
    ELSEIF DIFFERENCE >= .687 AND DIFFERENCE <= .8125 THEN
 		TDIFFERENCE = .75
 	ELSEIF DIFFERENCE >= .8125 AND DIFFERENCE <= .9375 THEN
 		 TDIFFERENCE = .875
 	ELSEIF DIFFERENCE > .9375 AND DIFFERENCE <= .9999 THEN
 	     TDIFFERENCE = 1.000
 	ELSE TDIFFERENCE = .000
    END IF
   			   REM PRINT "TDIFFERENCE(IN SUB) = ";TDIFFERENCE		 
END SUB