/*
 *	demo of SCSIDRV interface
 *
 *	written by Roger Burrows, Anodyne Software
 *	for MyAtari magazine
 *
 *	NOTE:
 *	if compiling with Lattice C v5.xx, you MUST use the -aw option
 *	(type-based stack alignment), to force shorts and chars to be
 *	passed on the stack as short integers (required by scsidrv
 *	interface).
 *
 */
#include <stdio.h>
#include <cookie.h>
#include <string.h>
#if LATTICE
#include <osbind.h>
#define cdecl			/* Lattice doesn't know this keyword, used in scsidefs.h */
#else
#include <tos.h>
#define BOOLEAN int
#endif
#include "scsidefs.h"

/*
 *	globals
 */
tpScsiCall scsicall;

/*
 *	function prototypes
 */
tpScsiCall init_scsi(void);
void scan_busses(void);
void list_devices(tBusInfo *Bus);
LONG scsi_inquiry(tHandle handle,char *inqdata);

int main(void)
{
	printf("Program to demonstrate usage of the SCSIDRV interface\n");
	printf("by Roger Burrows (Anodyne Software) for MyAtari magazine\n");

	if (init_scsi())
		scan_busses();
	else printf("SCSIDRV not available\n\n");

	printf("Press a key to exit");
	while(Cconis())
		;
	Cconin();

	return 0;
}

tpScsiCall init_scsi(void)
{
long value;

	scsicall = NULL;
	if (getcookie(0x53435349L,&value)) {			/* 'SCSI' */
		scsicall = (tpScsiCall)value;
		if (scsicall->Version < SCSIRevision)
			scsicall = NULL;
	}

	return scsicall;
}

void scan_busses(void)
{
LONG rc;
tBusInfo Info;
void *oldstack;

	printf("\nScanning busses ...\n");

	oldstack = (void *)Super(NULL);

	rc = scsicall->InquireSCSI(cInqFirst,&Info);
	while(rc == 0) {
		printf("Bus %d: %s\n",Info.BusNo,Info.BusName);
		list_devices(&Info);
		printf("\n");
		rc = scsicall->InquireSCSI(cInqNext,&Info);
	}

	Super(oldstack);
}
				
void list_devices(tBusInfo *Bus)
{
char inqdata[36];
char vendor[9], product[17], revision[5];
tDevInfo Dev;
tHandle handle;
ULONG MaxLen;
LONG rc;

	rc = scsicall->InquireBus(cInqFirst,Bus->BusNo,&Dev);

	while (rc == 0L) {
		printf("  Id %2ld ",Dev.SCSIId.lo);

		rc = scsicall->Open(Bus->BusNo,&Dev.SCSIId,&MaxLen);
		if (rc < 0L) {
			printf("error: can't open device\n");
			continue;
		}
		handle = (tHandle) rc;

		memset(inqdata,0,sizeof(inqdata));
		rc = scsi_inquiry(handle,inqdata);

		if (rc != 0L) {
			printf("error: INQUIRY failed, SCSIDRV rc=%ld",rc);
			if (rc > 0)
				printf(": possible check condition from device");
			printf("\n");
		} else {
			strncpy(vendor,inqdata+8,8);
			vendor[8] = '\0';
			strncpy(product,inqdata+16,16);
			product[16] = '\0';
			strncpy(revision,inqdata+32,4);
			revision[4] = '\0';
			printf(" %s %s %s",vendor,product,revision);

			switch(*inqdata&0x1f) {
			case 0:
				printf(" (direct access)");
				break;
			case 1:
				printf(" (sequential access)");
				break;
			case 2:
				printf(" (printer)");
				break;
			case 3:
				printf(" (processor)");
				break;
			case 4:
				printf(" (write-once)");
				break;
			case 5:
				printf(" (CD-ROM)");
				break;
			case 6:
				printf(" (scanner)");
				break;
			case 7:
				printf(" (optical memory)");
				break;
			case 8:
				printf(" (medium changer)");
				break;
			case 9:
				printf(" (communications)");
				break;
			case 10:
			case 11:
				printf(" (ASC IT 8 (graphic arts pre-press)");
				break;
			case 0x1f:
				printf(" (unknown)");
				break;
			default:
				printf(" (reserved device type %h)",*inqdata);
			}
			printf("\n");
			scsicall->Close(handle);
		}
		rc = scsicall->InquireBus(cInqNext,Bus->BusNo,&Dev);
	}
}

LONG scsi_inquiry(tHandle handle,char *inqdata)
{
tSCSICmd cmd;
BYTE cdb[6] = { 0x12, 0, 0, 0, 36, 0 };
WORD reqbuff[18/2];	/* even alignment for safety */

	cmd.Handle = handle;
	cmd.Cmd = cdb;
	cmd.CmdLen = 6;
	cmd.Buffer = inqdata;
	cmd.TransferLen = 36;
	cmd.SenseBuffer = (char *)reqbuff;
	cmd.Timeout = 200;			/* i.e. 1 second - generous :-) */
	cmd.Flags = 0;

	return scsicall->In(&cmd);
}
