/*	PROGDEF.C	User Define Object Types fr GFA-Basic
	Dieses C-Modul ist so programmiert, da es ohne groe nderungen
	disassembliert, assembliert und so als Assemblermodul in GFA-Basic
	Programme bernommem werden kann.	Volker Hemsen 01.08.92		*/

/*	Die folgenden Routinen wurden fr Lattice C erstellt. Die wichtigsten
	Compileroptionen sind: standard short integer, far-Code		*/


/*		VDI-Funktionsparameter		*/
#define	v_bar			0x0B020001
#define v_line			0x06020000
#define v_circle		0x0B030004
#define vr_recfl		0x72020000
#define vsf_color		0x19000100
#define vsf_interior	0x17000100
#define vsf_style		0x18000100
#define vs_clip			0x81020100
#define vswr_mode		0x20000100


/*		AES-Strukturen		*/
typedef struct parm_blk
{
	void *pb_tree;		/*	eigentlich OBJECT*	*/
	short pb_obj;
	short pb_prevstate;
	short pb_currstate;
	short pb_x;
	short pb_y;
	short pb_w;
	short pb_h;
	short pb_xc;
	short pb_yc;
	short pb_wc;
	short pb_hc;
	long pb_parm;
} PARMBLK;

#define SELECTED	1


/*		VDI-Struktur		*/
typedef struct
{
	int* contrl;
	int* intin;
	int* ptsin;
	int* intout;
	int* ptsout;
}	VDIPB;


/*		Funktionsprototypen		*/
void __stdargs vdi_call(long a);
void __asm koo_trans(register __a2 PARMBLK *parmblk);
void __regargs deffill(int interior,int style);
int __stdargs ubutton(PARMBLK *parmblk);	/*	Crossed Button 	*/
int __stdargs ufillbutton(PARMBLK *parmblk);	/*	Filled Button 	*/
int __stdargs ufillcircle(PARMBLK *parmblk);	/*	ausgefllter Kreis	*/

/*	Pointer auf den VDI-Parameterblock	*/
VDIPB *vdipb;


int __stdargs ubutton(PARMBLK *parmblk)	/*	Crossed Button 	*/
{
	register int *vp,b;
	
	koo_trans(parmblk);
	vp=vdipb->ptsin;
	vdi_call(v_bar);
	if (parmblk->pb_currstate&SELECTED)
	{
		vdi_call(v_line);
		b=vp[1];
		vp[1]=vp[3];
		vp[3]=b;
		vdi_call(v_line);
	}
	return(parmblk->pb_currstate & ~SELECTED);
}

int __stdargs ufillbutton(PARMBLK *parmblk)	/*	Filled Button 	*/
{
	register int* vp;
	
	koo_trans(parmblk);
	vdi_call(v_bar);
	if (parmblk->pb_currstate & SELECTED)
	{
		deffill(2,8);
		vp=vdipb->ptsin;
		vp[0]+=2;
		vp[1]+=2;
		vp[2]-=2;
		vp[3]-=2;
		vdi_call(v_bar);
	}
	return(parmblk->pb_currstate & ~SELECTED);
}

int __stdargs ufillcircle(PARMBLK *parmblk)	/*	ausgefllter Kreis	*/
{
	register int* vp;
	register int b;
	
	deffill(0,0);
	vp=vdipb->ptsin;
	b=(parmblk->pb_w>>1);
	vp[0]=parmblk->pb_x+b;
	vp[1]=parmblk->pb_y+(parmblk->pb_h>>1);
	vp[4]=b;
	vdi_call(v_circle);
	if (parmblk->pb_currstate & SELECTED)
	{
		deffill(2,8);
		vp[4]-=3;
		vdi_call(v_circle);
	}
	return(parmblk->pb_currstate & ~SELECTED);
}

/*	fr die Boxen Parameter bereitlegen	*/
void __asm koo_trans(register __a2 PARMBLK *parmblk)
{
	register int *vp;
	deffill(0,0);
	vp=vdipb->ptsin;
	vp[0]=parmblk->pb_x+1;
	vp[1]=parmblk->pb_y+1;
	vp[2]=vp[0]+parmblk->pb_w-2;
	vp[3]=vp[1]+parmblk->pb_h-2;
}

/*	vsf_interior und vsf_style einstellen, vsf_color=schwarz	*/
void __regargs deffill(int interior,int style)
{
	register int *vi;
	vi=vdipb->intin;
	vi[0]=1;
	vdi_call(vsf_color);
	vi[0]=interior;
	vdi_call(vsf_interior);
	vi[0]=style;
	vdi_call(vsf_style);
}

