; V_SCREEN - Virtuelle Bildschirmauflsungen fr Atari STE Computer
; programmiert von Volker Hemsen, 15.08.1993, Freeware

; V_SCREEN steht in KEINER programmtechnischen Verbindung mit BigScreen!!!

; bei der Entwicklung haben erheblich geholfen:
; HalfScreen von Julian F. Reschke, verffentlicht in ST-Magazin ?/90
; und das Atari Profibuch ST-STE-TT

; V_SCREEN wurde getestet mit:
; luft mit/auf: MEGA STE, NVDI 2.03, SpeedoGDOS
; luft NICHT mit: MultiTOS, Original-VDI

; verwendeter Assembler: TurboAss von -soft

weite           EQU 960
hoehe           EQU 600

                TEXT

start:          movea.l 4(SP),A0        ;adr der Basepage
                move.l  #$0100,D0       ;Groesse der Basepage
                add.l   $0C(A0),D0      ;lnge des TEXT-Segments
                add.l   $14(A0),D0      ;lnge des DATA-Segments
                add.l   $1C(A0),D0      ;lnge des BSS
                clr.w   -(SP)
                move.l  D0,-(SP)
                move.w  #$31,-(SP)      ;ptermres

                move.w  #-1,-(SP)       ;log. und physik. Bildschirmadresse
                pea     screen(PC)      ;ndern
                pea     screen(PC)
                move.w  #5,-(SP)
                trap    #14
                lea     12(SP),SP

                pea     installme(PC)
                move.w  #38,-(SP)       ;supexec
                trap    #14
                addq.l  #6,SP

                trap    #1              ;ende


installme:      move.l  $88.w,oldtrap2
                move.l  #my_trap2,$88.w
                move.b  #(weite-640)/16,$FFFF820F.w
                rts

                DC.L 'XBRA'
                DC.L 'VSCR'
oldtrap2:       DC.L 0
my_trap2:       cmp.w   #$73,D0         ;vdi?
                bne.s   normalvdi
                movea.l D1,A0
                move.l  12(A0),intout   ;Zeiger auf intout
                movea.l (A0),A1         ;Zeiger auf control
                cmpi.w  #1,(A1)         ;open workstation?
                bne.s   normalvdi
                movea.l 4(A0),A1        ;Zeiger auf intin
                cmpi.w  #10,(A1)        ;Bildschirmtreiber?
                bge.s   normalvdi
                move.l  2(SP),back      ;Rcksprungadr merken
                move.l  #patch,2(SP)    ;eigene einsetzen
normalvdi:      move.l  oldtrap2(PC),-(SP)
                rts

patch:          linea   #0 [ Init ]
                move.l  A0,linea_a0     ;in der Hoffnung das er sich nicht ndert
                move.l  -$36(A0),oldmaus
                move.l  #maus,-$36(A0)  ;Mausvektor
                move.w  #(weite/8),D0
                move.w  D0,-2(A0)       ;al.bytes_lin
                move.w  D0,2(A0)        ;al.width
                move.w  #weite,-12(A0)  ;al.v_rez_hz
                move.w  #hoehe,-4(A0)   ;al.v_res_vt
                move.w  #(weite-1),-$02B4(A0) ;al.workout[0]
                move.w  #(hoehe-1),-$02B2(A0) ;al.workout[0]
                movea.l intout(PC),A1
                move.w  #(weite-1),(A1) ;intout[0]
                move.w  #(hoehe-1),2(A1) ;intout[1]
                bsr.s   vb_inst
                move.l  back(PC),-(SP)
                rts


vb_inst:        move.w  $0454.w,D0      ;eigenen vertikal Blank Interrupt installieren
                lsl.w   #2,D0
                movea.l $0456.w,A0
                moveq   #4,D1
search_vb_slot: tst.l   0(A0,D1.w)
                beq.s   slot_found
                addq.w  #4,D1
                cmp.w   D0,D1
                bne.s   search_vb_slot
                clr.w   D0
                rts
slot_found:     move.l  #myvb,0(A0,D1.w)
                rts


rand            EQU 4

                DC.L 'XBRA'
                DC.L 'VSCR'
oldmaus:        DC.L 0
maus:           movem.l D0-D2/A0-A2,-(SP)
                movea.l linea_a0(PC),A0
                move.w  physx(PC),D0
                move.w  -$025A(A0),D1   ;X-Pos der Maus
                cmp.w   D1,D0
                bgt.s   mausactionx1
                add.w   #640-rand,D0
                cmp.w   D1,D0
                blt.s   mausactionx2
mausy:          move.w  physy(PC),D0
                move.w  -$0258(A0),D1   ;Y-Pos der Maus
                cmp.w   D1,D0
                bgt.s   mausactiony1
                add.w   #400-rand,D0
                cmp.w   D1,D0
                blt.s   mausactiony2
mausend:        movem.l (SP)+,D0-D2/A0-A2
                move.l  oldmaus(PC),-(SP)
                rts

mausactionx1:   move.w  -$025A(A0),D0
                bpl.s   mausactionx1a
                moveq   #0,D0
mausactionx1a:  move.w  D0,physx
                bsr.s   setphys
                bra.s   mausy

mausactionx2:   move.w  -$025A(A0),D0
                sub.w   #640-rand,D0
                cmp.w   #weite-640,D0
                bmi.s   mausactionx2a
                move.w  #weite-640,D0
mausactionx2a:  move.w  D0,physx
                bsr.s   setphys
                bra.s   mausy

mausactiony1:   move.w  -$0258(A0),D0
                bpl.s   mausactiony1a
                moveq   #0,D0
mausactiony1a:  move.w  D0,physy
                bra.s   setphys

mausactiony2:   move.w  -$0258(A0),D0
                sub.w   #400-rand,D0
                cmp.w   #hoehe-400,D0
                bmi.s   mausactiony2a
                move.w  #hoehe-400,D0
mausactiony2a:  move.w  D0,physy
;                bra.s   setphys

setphys:        lea     screen(PC),A0   ;physikalische Adresse neu setzen
                move.w  physy(PC),D0
                mulu    #(weite/8),D0
                moveq   #0,D1
                move.w  physx(PC),D1
                asr.l   #3,D1
                add.l   D1,D0
                add.l   A0,D0

                move    SR,oldsr        ;Interrupts merken und sperren
                andi    #%1111100011111111,SR
                subi.l  #46,$04A2.w     ;Platz fr weiteren XBIOS-Aufruf
                move.w  #-1,-(SP)
                move.l  D0,-(SP)
                move.l  #-1,-(SP)
                move.w  #5,-(SP)
                trap    #14
                lea     12(SP),SP
                addi.l  #46,$04A2.w     ;Platz wieder freigeben
                move    oldsr(PC),SR    ;Interrupts wieder freigeben
                not.w   myvbflag        ;fr den nchsten Vertikal Blank
                bra     mausend

                DC.L 'XBRA'
                DC.L 'VSCR'
                DC.L 0
myvb:           tst.w   myvbflag
                beq.s   myvbrts
                clr.w   myvbflag
                movem.l D0-D1,-(SP)
                move.b  #((weite-640)/16),D1 ;Breite in Words
                move.w  physx(PC),D0    ;x & $F
                and.w   #%1111,D0
                tst.w   D0
                beq.s   myvbset         ;wenn nicht 0 dann Breite-1
                subq.b  #1,D1
myvbset:        move.b  D0,$FFFF8265.w  ;Pixel bis zum nchsten Word
                move.b  D1,$FFFF820F.w  ;zu berspringende Words
                movem.l (SP)+,D0-D1
myvbrts:        rts

                BSS
back:           DS.L 1
intout:         DS.L 1
linea_a0:       DS.L 1
oldsr:          DS.L 1
myvbflag:       DS.W 1
physx:          DS.W 1
physy:          DS.W 1
screen:         DS.B weite*hoehe/8

                END
