***************************************************************************
*  ER68_COM.Q ist die Quelltextdatei zu ER68_COM.AUT                      *
*  Beide Dateien gehren zum EASY RIDER Reassembler                       *
*  Quelltext fr ER68_ASS                         Autor: Andreas Borchard *
*  letzte nderung: 06.06.1991                                            *
***************************************************************************
*  ER68_COM.AUT enthlt die Bytefolgen, die "automatisch"  im Modus       *
*  REASSEMBLIEREN von einem definierten KOMMENTAR begleitet werden        *
*  ER68_COM.AUT mu in folgendem Format vorliegen:                        *
*                                                                       
*  1. DESKRIPTORFELD
*  DC.W         DISTANZ VOM 1. ZUM 2. DESKRIPTORFELD (MAX. 32767 B.) 
*  DC.B         1. BYTE DER ZU KOMMENTIERENDEN BYTEFOLGE
*  DC.B         ANZAHL DER NOCHFOLGENDEN BYTES DER BYTEFOLGE (MAX. 255 B.)
*  DC.B         2.BYTE,3.BYTE,4.BYTE ...
*  DC.B         'AUSZUGEBENDER KOMMENTAR',0
*  EVEN
*  2. DESKRIPTORFELD 
*  USW.
*  
*  Dem letzten Deskriptorfeld mu ein abschlieendes 'DC.W 0' folgen.
*  Steuercodes im Kommentarfeld auer <TAB> (=9) und <Control G> (=7)
*  werden ignoriert!
*  Eine Bytefolge wird Byte fr Byte mit den Opcodes im reassemblierten 
*  Programm verglichen, und zwar grundstzlich beginnend beim Opcodeanfang!
*  Datenbytes werden nicht verglichen, wohl aber Befehlsemulatoren (LINEA,
*  LINEF), falls diese zu Code gewandelt wurden.
*  In einer Bytefolge kann $AA als Platzhalter fr ein beliebiges Byte ver-
*  wendet werden. Wenn mit $AA selbst verglichen werden soll mu ein zweites
*  $AA nachgestellt werden.
*  Wenn der Platzhalter gleich an 1. Stelle eingesetzt werden soll, mu
*  das 2. Byte ebenfalls der Platzhalter sein.
*  Als Bitplatzhalter kann $AB eingesetzt werden. Diesem Wert mu
*  ein Byte folgen, das die zu testenden Bits angibt und dann ein Byte, das
*  den Vergleichswert des Tests liefert. Das zu vergleichende Byte im
*  Programm wird als "gleich" angesehen, wenn die UND-Operation mit dem
*  $AB folgenden Byte das Ergebnis des 2. Bytes, welches $AB folgt,
*  entspricht! 
*  Zur weiteren Verdeutlichung ein Auszug aus der Assemblerroutine des
*  Reassemblers:
*       CMP.B   #$AB,(CMP_PTR)
*       BNE.S   NOT_BITPLACEHOLDER
*       TST.B   1(CMP_PTR)
*       BEQ.S   CMP_WITH_AB
*       AND.B   1(CMP_PTR),PRG_BYTE
*       CMP.B   2(CMP_PTR),PRG_BYTE
*       BEQ     IS_EQUAL 
*  Wie hier angedeutet, mu, wenn ein Programmbyte mit $AB verglichen werden
*  soll, diesem Byte $00 folgen! (-> UND-Operation mit 0 liefert immer 0 und
*  ist deshalb unntz!) 
*  Wenn der Bitplatzhalter gleich an 1. Stelle eingesetzt werden soll, mu
*  das 2. Byte ebenfalls der Platzhalter sein.
*  BEISPIELE:
*
*  1)
*  DC.B  $AA                    ;1. BYTE
*  DC.B  4                      ;ANZAHL DER WEITEREN B.
*  DC.B  $AA,$3C,$00,$4A        ;WEITERE BYTES
*
*  sucht nach $??3C004A 
*  und kommentiert alle Befehle, die dem Muster '*.W #$4A,*' entsprechen.
*
*  2)
*  DC.B  $AA                    ;1. BYTE
*  DC.B  2                      ;ANZAHL DER WEITEREN B.
*  DC.B  $AA,$AA                ;WEITERE BYTES
*
*  sucht nach $AA 
*  und kommentiert (findet) vermutlich nichts.
*
*  3)
*  DC.B  $3F                    ;1. BYTE
*  DC.B  3                      ;ANZAHL DER WEITEREN B.
*  DC.B  $3C,$00,$AA            ;WEITERE BYTES
*
*  sucht nach $3F3C00?? 
*  und kommentiert alle Befehle mit folgendem Muster: 'MOVE.W #$??,-(A7)'.
*
*  4)
*  DC.B  $3F                    ;1. BYTE
*  DC.B  4                      ;ANZAHL DER WEITEREN B.
*  DC.B  $3C,$00,$AA,$AA        ;WEITERE BYTES
*
*  sucht nach $3F3C00AA 
*  und kommentiert 'MOVE.W #$AA,-(A7)'.
*
*  5)
*  DC.B  $AA                    ;1. BYTE
*  DC.B  0                      ;ANZAHL DER WEITEREN B.
*
*  sucht nach $?? 
*  und kommentiert jeden Befehl.
*
* 6)
* DC.B  $AB
* DC.B  3
* DC.B  $AB,$F0,$60
*
* sucht nach %0110????
* und kommentiert alle Sprungbefehle.
*
* 7)
* DC.B  $AB
* DC.B  2
* DC.B  $AB,$00
*
* sucht nach $AB
* und findet wiederum vermutlich nichts.
*
* 8)
* DC.B  $AA
* DC.B  4
* DC.B  $AA,$AB,$3F,$3C
*
* sucht nach %??????????111100
* und kommentiert Befehle, die dem Muster *.X  #C,<ea> entsprechen.
*
***************************************************************************

 MODUL \EASYRIDE\ER68_COM.AUT      * Unter diesem Namen soll der Code 
                                   * gespeichert werden

 ORG   0                           * um einen Programmheader zu verhindern 
**************************************************************************
* Wer den EASY RIDER Assembler besitzt, sollte die bersichtlichere 
* MACROVERSION weiter unten betrachten!
ER68_ASS=1              * auskommentieren, wenn die MAKROVERSION nicht 
                        * verwendet werden soll!
        IFND ER68_ASS
* GEMDOS-ROUTINEN
 LOCAL
 DC.W  .AUT2-*
 DC.B  $42
 DC.B  (.AUT1-*)-1
 DC.B  $67,$4E,$41
.AUT1:
 DC.B  '	;PTERM0',0                
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,1,$4E,$41
.AUT1:
 DC.B  '	;CCONIN',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,2,$4E,$41
.AUT1:
 DC.B  '	;CCONOUT',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,3,$4E,$41
.AUT1:
 DC.B  '	;CAUXIN',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,4,$4E,$41
.AUT1:
 DC.B  '	;CAUXOUT',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,5,$4E,$41
.AUT1:
 DC.B  '	;CPRNOUT',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,6,$4E,$41
.AUT1:
 DC.B  '	;CRAWIO',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,7,$4E,$41
.AUT1:
 DC.B  '	;CRAWCIN',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,8,$4E,$41
.AUT1:
 DC.B  '	;CNECIN',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,9,$4E,$41
.AUT1:
 DC.B  '	;CCONWS',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$A,$4E,$41
.AUT1:
 DC.B  '	;CCONRS',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$B,$4E,$41
.AUT1:
 DC.B  '	;CCONIS',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$E,$4E,$41
.AUT1:
 DC.B  '	;DSETDRV',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$10,$4E,$41
.AUT1:
 DC.B  '	;CCONOS',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$11,$4E,$41
.AUT1:
 DC.B  '	;CPRNOS',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$12,$4E,$41
.AUT1:
 DC.B  '	;CAUXIS',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$13,$4E,$41
.AUT1:
 DC.B  '	;CAUXOS',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$19,$4E,$41
.AUT1:
 DC.B  '	;DGETDRV',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$1A,$4E,$41
.AUT1:
 DC.B  '	;DSETDTA',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$20,$4E,$41
.AUT1:
 DC.B  '	;SUPER',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$2A,$4E,$41
.AUT1:
 DC.B  '	;TGETDATE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$2B,$4E,$41
.AUT1:
 DC.B  '	;TSETDATE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$2C,$4E,$41
.AUT1:
 DC.B  '	;TGETTIME',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$2D,$4E,$41
.AUT1:
 DC.B  '	;TSETTIME',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$2F,$4E,$41
.AUT1:
 DC.B  '	;FGETDTA',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$30,$4E,$41
.AUT1:
 DC.B  '	;SVERSION',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$31,$4E,$41
.AUT1:
 DC.B  '	;PTERMRES',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$36,$4E,$41
.AUT1:
 DC.B  '	;DFREE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$39,$4E,$41
.AUT1:
 DC.B  '	;DCREATE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$3A,$4E,$41
.AUT1:
 DC.B  '	;DDELETE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$3B,$4E,$41
.AUT1:
 DC.B  '	;DSETPATH',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$3C,$4E,$41
.AUT1:
 DC.B  '	;FCREATE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$3D,$4E,$41
.AUT1:
 DC.B  '	;FOPEN',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$3E,$4E,$41
.AUT1:
 DC.B  '	;FCLOSE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$3F,$4E,$41
.AUT1:
 DC.B  '	;FREAD',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$40,$4E,$41
.AUT1:
 DC.B  '	;FWRITE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$41,$4E,$41
.AUT1:
 DC.B  '	;FDELETE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$42,$4E,$41
.AUT1:
 DC.B  '	;FSEEK',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$43,$4E,$41
.AUT1:
 DC.B  '	;FATTRIB',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$45,$4E,$41
.AUT1:
 DC.B  '	;FDUP',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$46,$4E,$41
.AUT1:
 DC.B  '	;FFORCE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$47,$4E,$41
.AUT1:
 DC.B  '	;DGETPATH',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$48,$4E,$41
.AUT1:
 DC.B  '	;MALLOC',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$49,$4E,$41
.AUT1:
 DC.B  '	;MFREE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$4A,$4E,$41
.AUT1:
 DC.B  '	;MSHRINK',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$4B,$4E,$41
.AUT1:
 DC.B  '	;PEXEC',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$4C,$4E,$41
.AUT1:
 DC.B  '	;PTERM',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$4E,$4E,$41
.AUT1:
 DC.B  '	;FSFIRST',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$4F,$4E,$41
.AUT1:
 DC.B  '	;FSNEXT',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$56,$4E,$41
.AUT1:
 DC.B  '	;FRENAME',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$57,$4E,$41
.AUT1:
 DC.B  '	;FDATIME',0
 EVEN
.AUT2:
* BIOS-ROUTINEN
 LOCAL
 DC.W  .AUT2-*
 DC.B  $42
 DC.B  (.AUT1-*)-1
 DC.B  $67,$4E,$4D
.AUT1:
 DC.B  '	;GETMBP',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,1,$4E,$4D
.AUT1:
 DC.B  '	;BCONSTAT',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,2,$4E,$4D
.AUT1:
 DC.B  '	;BCONIN',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,3,$4E,$4D
.AUT1:
 DC.B  '	;BCONOUT',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,4,$4E,$4D
.AUT1:
 DC.B  '	;RWABS',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,5,$4E,$4D
.AUT1:
 DC.B  '	;SETEXC',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,6,$4E,$4D
.AUT1:
 DC.B  '	;TICKCAL',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,7,$4E,$4D
.AUT1:
 DC.B  '	;GETBPB',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,8,$4E,$4D
.AUT1:
 DC.B  '	;BCOSTAT',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,9,$4E,$4D
.AUT1:
 DC.B  '	;MEDIACH',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,10,$4E,$4D
.AUT1:
 DC.B  '	;DRVMAP',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,11,$4E,$4D
.AUT1:
 DC.B  '	;KBSHIFT',0
 EVEN
.AUT2:
* XBIOS-ROUTINEN
 LOCAL
 DC.W  .AUT2-*
 DC.B  $42
 DC.B  (.AUT1-*)-1
 DC.B  $67,$4E,$4E
.AUT1:
 DC.B  '	;INITMOUSE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,2,$4E,$4E
.AUT1:
 DC.B  '	;PHYSBASE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,3,$4E,$4E
.AUT1:
 DC.B  '	;LOGBASE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,4,$4E,$4E
.AUT1:
 DC.B  '	;GETREZ',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,5,$4E,$4E
.AUT1:
 DC.B  '	;SETSCREEN',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,6,$4E,$4E
.AUT1:
 DC.B  '	;SETPALLETE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,7,$4E,$4E
.AUT1:
 DC.B  '	;SETCOLOR',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,8,$4E,$4E
.AUT1:
 DC.B  '	;FLOPRD',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,9,$4E,$4E
.AUT1:
 DC.B  '	;FLOPWR',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,10,$4E,$4E
.AUT1:
 DC.B  '	;FLOPFMT',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,12,$4E,$4E
.AUT1:
 DC.B  '	;MIDIWS',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,13,$4E,$4E
.AUT1:
 DC.B  '	;MFPINT',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,14,$4E,$4E
.AUT1:
 DC.B  '	;IOREC',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,15,$4E,$4E
.AUT1:
 DC.B  '	;RSCONF',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,16,$4E,$4E
.AUT1:
 DC.B  '	;KEYBTL',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,17,$4E,$4E
.AUT1:
 DC.B  '	;RANDOM',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,18,$4E,$4E
.AUT1:
 DC.B  '	;PROTOBT',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,19,$4E,$4E
.AUT1:
 DC.B  '	;FLOPVER',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,20,$4E,$4E
.AUT1:
 DC.B  '	;SCRDMP',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,21,$4E,$4E
.AUT1:
 DC.B  '	;CURSCONF',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,22,$4E,$4E
.AUT1:
 DC.B  '	;SETTIME',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,23,$4E,$4E
.AUT1:
 DC.B  '	;GETTIME',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,24,$4E,$4E
.AUT1:
 DC.B  '	;BIOSKEYS',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,25,$4E,$4E
.AUT1:
 DC.B  '	;IKBDWS',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,26,$4E,$4E
.AUT1:
 DC.B  '	;JDISINT',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,27,$4E,$4E
.AUT1:
 DC.B  '	;JENABINT',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,28,$4E,$4E
.AUT1:
 DC.B  '	;GIACCESS',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,29,$4E,$4E
.AUT1:
 DC.B  '	;OFFGIBIT',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,30,$4E,$4E
.AUT1:
 DC.B  '	;ONGIBIT',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,31,$4E,$4E
.AUT1:
 DC.B  '	;XBTIMER',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,32,$4E,$4E
.AUT1:
 DC.B  '	;DOSOUND',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,33,$4E,$4E
.AUT1:
 DC.B  '	;SETPRT',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,34,$4E,$4E
.AUT1:
 DC.B  '	;KBDVBASE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,35,$4E,$4E
.AUT1:
 DC.B  '	;KBRATE',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,36,$4E,$4E
.AUT1:
 DC.B  '	;PRTBLK',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,37,$4E,$4E
.AUT1:
 DC.B  '	;VSYNC',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,38,$4E,$4E
.AUT1:
 DC.B  '	;SUPEXEC',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $3F
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,39,$4E,$4E
.AUT1:
 DC.B  '	;PUNTAES',0
 EVEN
.AUT2:
*AES UND VDI
 LOCAL
 DC.W  .AUT2-*
 DC.B  $30
 DC.B  (.AUT1-*)-1
 DC.B  $3C,0,$C8,$4E,$42
.AUT1:
 DC.B  '	;AES-AUFRUF',0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $70
 DC.B  (.AUT1-*)-1
 DC.B  $73,$4E,$42
.AUT1:
 DC.B  '	;VDI-AUFRUF',0
 EVEN
.AUT2:
 IFEQ  0
* BEISPIELE FR WEITERE MGLICHE KOMMENTARE
 LOCAL
 DC.W  .AUT2-*
 DC.B  $AA
 DC.B  (.AUT1-*)-1
 DC.B  $AA,$3C,$00,$30
.AUT1:
 DC.B  "	;#'0'",0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $AA
 DC.B  (.AUT1-*)-1
 DC.B  $AA,$3C,$00,$39
.AUT1:
 DC.B  "	;#'9'",0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $AA
 DC.B  (.AUT1-*)-1
 DC.B  $AA,$3C,$00,$41
.AUT1:
 DC.B  "	;#'A'",0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $AA
 DC.B  (.AUT1-*)-1
 DC.B  $AA,$3C,$00,$5A
.AUT1:
 DC.B  "	;#'Z'",0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $AA
 DC.B  (.AUT1-*)-1
 DC.B  $AA,$3C,$00,$7A
.AUT1:
 DC.B  "	;#'z'",0
 EVEN
.AUT2:
 LOCAL
 DC.W  .AUT2-*
 DC.B  $AA
 DC.B  (.AUT1-*)-1
 DC.B  $AA,$3C,$00,$61
.AUT1:
 DC.B  "	;#'a'",0
 EVEN
.AUT2:
 LOCAL
 ENDIF
 DC.W  0         * DAMIT MU DIE DATEI ABSCHLIEEN!
        ELSE               * die MAKRO-Version

        MAC_BUFFL 2500

GET_MASK MACRO
.MASK   SET  0
.ERG    SET  0
        IFNE 1:$(\1)='%'
.ZIFFER SET  8
        REPEAT
        IFEQ (.OFF+.ZIFFER):$(\1)='?'
.MASK     SET  .MASK|(1<<-(.ZIFFER-8))
          IFEQ (.OFF+.ZIFFER):$(\1)='0'
            IFNE (.OFF+.ZIFFER):$(\1)='1'
.ERG          SET .ERG|(1<<-(.ZIFFER-8))
            ELSE
              ILLEGALES ZEICHEN IN \1. NUR 0,1 ODER ? IST ERLAUBT
            ENDIF
          ENDIF
        ENDIF
.ZIFFER SET     .ZIFFER-1
        UNTIL   #7
.OFF    SET     .OFF+8
        ELSE
.ZIFFER SET  2
        REPEAT
        IFEQ (.OFF+.ZIFFER):$(\1)='?'
.MASK     SET  .MASK|($0F<<-((.ZIFFER=1)*4))
.LOC      SET  (.OFF+.ZIFFER):$(\1)
          IFEQ  (.LOC>='0'&&.LOC<='9')||(.LOC&$DF>='A'&&.LOC&$DF<='F')
            ILLEGALES ZEICHEN IN \1. NUR 0-9,A-F ODER ? IST ERLAUBT
          ELSE 
            IFNE  .LOC>'9'
.LOC          SET  (.LOC&$DF)-55
            ELSE
.LOC          SET   .LOC-'0'
            ENDIF
.ERG        SET   .ERG|(.LOC<<-((.ZIFFER=1)*4))
          ENDIF
        ENDIF
.ZIFFER   SET     .ZIFFER-1
        UNTIL   #1
.OFF    SET     .OFF+2
        ENDIF
        ENDM

GEN_BYTES MACRO 
        IFNE    .MASK=0
BYTES     SETSTR  BYTES+(-(1:BYTES<>0)*',')+$(170)
        ELSE
          IFNE    .MASK=$FF
BYTES       SETSTR  BYTES+(-(1:BYTES<>0)*',')+$([.ERG])
            IFNE   .ERG=170||.ERG=171
BYTES         SETSTR  BYTES+","+($([.ERG])::$(170,171))::$(170,0)
            ENDIF
          ELSE
BYTES       SETSTR  BYTES+(-(1:BYTES<>0)*',')+$(171,[.MASK],[.ERG])
          ENDIF
        ENDIF
        ENDM

MAKE_COM MACRO
.OFF    SET  1
BYTES   SETSTR $()
        IFEQ  1:$(\1)='%'||1:$(\1)='$'
          ILLEGALER OPERATOR IN \1. NUR % ODER $ IST ERLAUBT
          EXITM
        ENDIF
        GET_MASK  \1
        GEN_BYTES 
STBYTE  SETSTR 1::BYTES
        IFNE  STBYTE::$(170,171)=0
BYTES     SETSTR  $()
        ENDIF
        IFNE  (.OFF+1):$(\1)
        REPEAT
          GET_MASK \1
          GEN_BYTES
        UNTIL   (.OFF+1):$(\1)
        ENDIF
        TMKECOM STBYTE,BYTES,\<
FIRSTBYTE SETSTR $()
BYTES     SETSTR $()
        ENDM 

TMKECOM MACRO
        MKECOM  [\1],\<
        ENDM

MKECOM  MACRO
        IFNE    \#-3            ;Parameterzahl berprfen
         PARAMETERZAHL -> (\=) STIMMT NICHT
         EXITM
        ENDIF
        DC.W    \@AUT2-*        ;Distanz zum nchsten Deskriptorfeld
        DC.B    \1              ;1.Byte
        DC.B    (\@AUT1-*)-1    ;Anzahl der weiteren Bytes
        IFNE    $([\2])
          DC.B    [\2]          ;weitere Bytes (die eckigen Klammern bewirken
                                ;die Entfernung der Anfhrungsstriche!)
        ENDIF
\@AUT1:
        DC.B    \3,0            ;Kommentar + NULL-Byte
        EVEN                    ;nchstes Feld auf gerade Adresse legen!
\@AUT2:
        ENDM
        EXP
        MAKE_COM  $42674E41,'	;PTERMO'
        MAKE_COM  $3F3C00014E41,'	;CCONIN'
        MAKE_COM  $3F3C00024E41,'	;CCONOUT'
        MAKE_COM  $3F3C00034E41,'	;CAUXIN'
        MAKE_COM  $3F3C00044E41,'	;CAUXOUT'
        MAKE_COM  $3F3C00054E41,'	;CPRNOUT'
        MAKE_COM  $3F3C00064E41,'	;CRAWIO'
        MAKE_COM  $3F3C00074E41,'	;CRAWCIN'
        MAKE_COM  $3F3C00084E41,'	;CNECIN'
        MAKE_COM  $3F3C00094E41,'	;CCONWS'
        MAKE_COM  $3F3C000A4E41,'	;CCONRS'
        MAKE_COM  $3F3C000B4E41,'	;CCONIS'
        MAKE_COM  $3F3C000E4E41,'	;DSETDRV'
        MAKE_COM  $3F3C00104E41,'	;CCONOS'
        MAKE_COM  $3F3C00114E41,'	;CPRNOS'
        MAKE_COM  $3F3C00124E41,'	;CAUXIS'
        MAKE_COM  $3F3C00134E41,'	;CAUXOS'
        MAKE_COM  $3F3C00194E41,'	;DGETDRV'
        MAKE_COM  $3F3C001A4E41,'	;DSETDTA'
        MAKE_COM  $3F3C00204E41,'	;SUPER'
        MAKE_COM  $3F3C002A4E41,'	;TGETDATE'
        MAKE_COM  $3F3C002B4E41,'	;TSETDATE'
        MAKE_COM  $3F3C002C4E41,'	;TGETTIME'
        MAKE_COM  $3F3C002D4E41,'	;TSETTIME'
        MAKE_COM  $3F3C002F4E41,'	;FGETDTA'
        MAKE_COM  $3F3C00304E41,'	;SVERSION'
        MAKE_COM  $3F3C00314E41,'	;PTERMRES'
        MAKE_COM  $3F3C00364E41,'	;DFREE'
        MAKE_COM  $3F3C00394E41,'	;DCREATE'
        MAKE_COM  $3F3C003A4E41,'	;DDELETE'
        MAKE_COM  $3F3C003B4E41,'	;DSETPATH'
        MAKE_COM  $3F3C003C4E41,'	;FCREATE'
        MAKE_COM  $3F3C003D4E41,'	;FOPEN'
        MAKE_COM  $3F3C003E4E41,'	;FCLOSE'
        MAKE_COM  $3F3C003F4E41,'	;FREAD'
        MAKE_COM  $3F3C00404E41,'	;FWRITE'
        MAKE_COM  $3F3C00414E41,'	;FDELETE'
        MAKE_COM  $3F3C00424E41,'	;FSEEK'
        MAKE_COM  $3F3C00434E41,'	;FATTRIB'
        MAKE_COM  $3F3C00454E41,'	;FDUP'
        MAKE_COM  $3F3C00464E41,'	;FFORCE'
        MAKE_COM  $3F3C00474E41,'	;DGETPATH'
        MAKE_COM  $3F3C00484E41,'	;MALLOC'
        MAKE_COM  $3F3C00494E41,'	;MFREE'
        MAKE_COM  $3F3C004A4E41,'	;MSHRINK'
        MAKE_COM  $3F3C004B4E41,'	;PEXEC'
        MAKE_COM  $3F3C004C4E41,'	;PTERM'
        MAKE_COM  $3F3C004E4E41,'	;FSFIRST'
        MAKE_COM  $3F3C004F4E41,'	;FSNEXT'
        MAKE_COM  $3F3C00564E41,'	;FRENAME'
        MAKE_COM  $3F3C00574E41,'	;FDATIME'
        MAKE_COM  $42674E4D,'	;GETMBP'
        MAKE_COM  $3F3C00014E4D,'	;BCONSTAT'
        MAKE_COM  $3F3C00024E4D,'	;BCONIN'
        MAKE_COM  $3F3C00034E4D,'	;BCONOUT'
        MAKE_COM  $3F3C00044E4D,'	;RWABS'
        MAKE_COM  $3F3C00054E4D,'	;SETEXC'
        MAKE_COM  $3F3C00064E4D,'	;TICKCAL'
        MAKE_COM  $3F3C00074E4D,'	;GETBPB'
        MAKE_COM  $3F3C00084E4D,'	;BCOSTAT'
        MAKE_COM  $3F3C00094E4D,'	;MEDIACH'
        MAKE_COM  $3F3C000A4E4D,'	;DRVMAP'
        MAKE_COM  $3F3C000B4E4D,'	;KBSHIFT'
        MAKE_COM  $42674E4E,'	;INITMOUSE'
        MAKE_COM  $3F3C00024E4E,'	;PHYSBASE'
        MAKE_COM  $3F3C00034E4E,'	;LOGBASE'
        MAKE_COM  $3F3C00044E4E,'	;GETREZ'
        MAKE_COM  $3F3C00054E4E,'	;SETSCREEN'
        MAKE_COM  $3F3C00064E4E,'	;SETPALLETE'
        MAKE_COM  $3F3C00074E4E,'	;SETCOLOR'
        MAKE_COM  $3F3C00084E4E,'	;FLOPRD'
        MAKE_COM  $3F3C00094E4E,'	;FLOPWR'
        MAKE_COM  $3F3C000A4E4E,'	;FLOPFMT'
        MAKE_COM  $3F3C000C4E4E,'	;MIDIWS'
        MAKE_COM  $3F3C000D4E4E,'	;MFPINT'
        MAKE_COM  $3F3C000E4E4E,'	;IOREC'
        MAKE_COM  $3F3C000F4E4E,'	;RSCONF'
        MAKE_COM  $3F3C00104E4E,'	;KEYBTL'
        MAKE_COM  $3F3C00114E4E,'	;RANDOM'
        MAKE_COM  $3F3C00124E4E,'	;PROTOBT'
        MAKE_COM  $3F3C00134E4E,'	;FLOPVER'
        MAKE_COM  $3F3C00144E4E,'	;SCRDMP'
        MAKE_COM  $3F3C00154E4E,'	;CURSCONF'
        MAKE_COM  $3F3C00164E4E,'	;SETTIME'
        MAKE_COM  $3F3C00174E4E,'	;GETTIME'
        MAKE_COM  $3F3C00184E4E,'	;BIOSKEYS'
        MAKE_COM  $3F3C00194E4E,'	;IKBDWS'
        MAKE_COM  $3F3C001A4E4E,'	;JDISINT'
        MAKE_COM  $3F3C001B4E4E,'	;JENABINT'
        MAKE_COM  $3F3C001C4E4E,'	;GIACCESS'
        MAKE_COM  $3F3C001D4E4E,'	;OFFGIBIT'
        MAKE_COM  $3F3C001E4E4E,'	;ONGIBIT'
        MAKE_COM  $3F3C001F4E4E,'	;XBTIMER'
        MAKE_COM  $3F3C00204E4E,'	;DOSOUND'
        MAKE_COM  $3F3C00214E4E,'	;SETPRT'
        MAKE_COM  $3F3C00224E4E,'	;KBDVBASE'
        MAKE_COM  $3F3C00234E4E,'	;KBRATE'
        MAKE_COM  $3F3C00244E4E,'	;PRTBLK'
        MAKE_COM  $3F3C00254E4E,'	;VSYNC'
        MAKE_COM  $3F3C00264E4E,'	;SUPEXEC'
        MAKE_COM  $3F3C00274E4E,'	;PUNTAES'
        MAKE_COM  $303C00C84E42,'	;AES-AUFRUF'
        MAKE_COM  $70734E42,'	;VDI-AUFRUF'

********** HUFIGE ER68_ASS-TURBOC-AES-AUFRUFE KOMMENTIEREN...
********** DIE HIER ANGEGEBENEN BYTEFOLGEN SIND NICHT EINDEUTIG, D. H.,
********** DA U. U. FALSCH KOMMENTIERT WIRD, DESHALB DAS '?' 
********** HINTER DEM KOMMENTAR...
        MAKE_COM  $700A6000,'	;FUNKTIONSNUMMER FR APPL_INIT?'
        MAKE_COM  $70136000,'	;FUNKTIONSNUMMER FR APPL_EXIT?'
        MAKE_COM  $70186000,'	;FUNKTIONSNUMMER FR EVNT_TIMER?'
        MAKE_COM  $70196100,'	;FUNKTIONSNUMMER FR EVNT_MULTI?'
        MAKE_COM  $702A6000,'	;FUNKTIONSNUMMER FR OBJC_DRAW?'
        MAKE_COM  $702B6000,'	;FUNKTIONSNUMMER FR OBJC_FIND?'
        MAKE_COM  $70336000,'	;FUNKTIONSNUMMER FR FORM_DIAL?'
        MAKE_COM  $70366100,'	;FUNKTIONSNUMMER FR FORM_CENTER?'
        MAKE_COM  $70326000,'	;FUNKTIONSNUMMER FR FORM_DO?'
        MAKE_COM  $70346000,'	;FUNKTIONSNUMMER FR FORM_ALERT?'
        MAKE_COM  $701E6000,'	;FUNKTIONSNUMMER FR MENU_BAR?'
        MAKE_COM  $701F6000,'	;FUNKTIONSNUMMER FR MENU_ICHECK?'
        MAKE_COM  $70206000,'	;FUNKTIONSNUMMER FR MENU_IENABLE?'
        MAKE_COM  $70216000,'	;FUNKTIONSNUMMER FR MENU_TNORMAL?'
        MAKE_COM  $70226100,'	;FUNKTIONSNUMMER FR MENU_TEXT?'
        MAKE_COM  $704D6100,'	;FUNKTIONSNUMMER FR GRAF_HANDLE?'
        MAKE_COM  $70476100,'	;FUNKTIONSNUMMER FR GRAF_DRAGBOX?'
        MAKE_COM  $704E6000,'	;FUNKTIONSNUMMER FR GRAF_MOUSE?'
        MAKE_COM  $704F6100,'	;FUNKTIONSNUMMER FR GRAF_MKSTATE?'
        MAKE_COM  $70686100,'	;FUNKTIONSNUMMER FR WIND_GET?'
        MAKE_COM  $70646000,'	;FUNKTIONSNUMMER FR WIND_CREATE?'
        MAKE_COM  $70656000,'	;FUNKTIONSNUMMER FR WIND_OPEN?'
        MAKE_COM  $70676000,'	;FUNKTIONSNUMMER FR WIND_DELETE?'
        MAKE_COM  $70696000,'	;FUNKTIONSNUMMER FR WIND_SET?'
        MAKE_COM  $706C6100,'	;FUNKTIONSNUMMER FR WIND_CALC?'
        MAKE_COM  $70666000,'	;FUNKTIONSNUMMER FR WIND_CLOSE?'
        MAKE_COM  $706B6000,'	;FUNKTIONSNUMMER FR WIND_UPDATE?'
        MAKE_COM  $706E6000,'	;FUNKTIONSNUMMER FR RSRC_LOAD?'
        MAKE_COM  $706F6000,'	;FUNKTIONSNUMMER FR RSRC_FREE?'

************* Mit Hilfe des BITPLATZHALTERS mgliche Codeoptimierungen
************* im Quelltext aufdecken ...

************* SUCHE NACH Bcc  C(PC) WOBEI -128<=C<=127 
************* DER REASSEMBLER WIRD HIER IN DER REGEL OFT FNDIG...
        MAKE_COM %0110????00000000000000000???????,'	;Sprung knnte kurz sein!' 
        MAKE_COM %0110????00000000111111111???????,'	;Sprung knnte kurz sein!' 

************* SUCHE NACH MOVE.X #C,Dn WOBEI -128<=C<=127
************* AUCH HIER WIRD DER REASSEMBLER OFT FNDIG...
        MAKE_COM %0010???0001111000000000000000000000000000???????,'	;kann durch MOVEQ ersetzt werden!' 
        MAKE_COM %0010???0001111001111111111111111111111111???????,'	;kann durch MOVEQ ersetzt werden!' 
        MAKE_COM %00?1???000111100000000000???????,'	;kann vielleicht durch MOVEQ ersetzt werden!'
        MAKE_COM %00?1???000111100111111111???????,'	;kann vielleicht durch MOVEQ ersetzt werden!'

************* SUCHE NACH ADDI/SUBI.X #C,<EA> WOBEI 0<=C<=8
************* DIE FOLGENDEN BYTEFOLGEN WERDEN SELTEN LOKALISIERT...
        MAKE_COM %000001?00???????0000000000000000,'	;unsinniger Befehl!?'
        MAKE_COM %000001?010??????00000000000000000000000000000000,'	;unsinniger Befehl!?'
        MAKE_COM %000001?00???????0000000000000???,'	;kann durch ADDQ/SUBQ ersetzt werden!'
        MAKE_COM %000001?010??????00000000000000000000000000000???,'	;kann durch ADDQ/SUBQ ersetzt werden!'
        MAKE_COM %000001?00???????0000000000001000,'	;kann durch ADDQ/SUBQ ersetzt werden!'
        MAKE_COM %000001?010??????00000000000000000000000000001000,'	;kann durch ADDQ/SUBQ ersetzt werden!'

************* SUCHE NACH ADD(A)/SUB(A).X #C,Dn(An) WOBEI 0<=C<=8
************* DIE FOLGENDEN BYTEFOLGEN WERDEN EBENFALLS SELTEN LOKALISIERT...
        MAKE_COM %1?01???00?1111000000000000000000,'	;unsinniger Befehl!?'
        MAKE_COM %1?01???01011110000000000000000000000000000000000,'	;unsinniger Befehl!?'
        MAKE_COM %1?01???0111111000000000000000000,'	;unsinniger Befehl!?'
        MAKE_COM %1?01???11111110000000000000000000000000000000000,'	;unsinniger Befehl!?'
        MAKE_COM %1?01???00?1111000000000000000???,'	;kann durch ADDQ/SUBQ ersetzt werden!'
        MAKE_COM %1?01???01011110000000000000000000000000000000???,'	;kann durch ADDQ/SUBQ ersetzt werden!'
        MAKE_COM %1?01???0111111000000000000000???,'	;kann durch ADDQ/SUBQ ersetzt werden!'
        MAKE_COM %1?01???11111110000000000000000000000000000000???,'	;kann durch ADDQ/SUBQ ersetzt werden!'
        MAKE_COM %1?01???00?1111000000000000001000,'	;kann durch ADDQ/SUBQ ersetzt werden!'
        MAKE_COM %1?01???01011110000000000000000000000000000001000,'	;kann durch ADDQ/SUBQ ersetzt werden!'
        MAKE_COM %1?01???0111111000000000000001000,'	;kann durch ADDQ/SUBQ ersetzt werden!'
        MAKE_COM %1?01???11111110000000000000000000000000000001000,'	;kann durch ADDQ/SUBQ ersetzt werden!'

************* SUCHE NACH ADDA/SUBA.L #C,An WOBEI $FFFF8000<=C<=$7FFF
************* DIESE BYTEFOLGEN HINGEGEN FINDET MAN ERHEBLICH FTER...
        MAKE_COM %1?01???11111110000000000000000000???????,'	;kann durch LEA C(An),An ersetzt werden!'
        MAKE_COM %1?01???11111110011111111111111111???????,'	;kann durch LEA C(An),An ersetzt werden!'

************* SUCHE NACH MOVE.L #C,An WOBEI $FFFF8000<=C<=$7FFF        
************* UND DIESE BYTEFOLGEN EBENFALLS RECHT HUFIG...
        MAKE_COM %0010???00111110000000000000000000???????,'	;kann durch LEA C.W,An ersetzt werden!'
        MAKE_COM %0010???00111110011111111111111111???????,'	;kann durch LEA C.W,An ersetzt werden!'
        DC.W    0
        ENDIF
 END
