;
	LIST	+S
;
	PUBLIC	START,MASKINT,NMINT
;
	EXTERN	TOPRAM,TIMER,KEYPRS,KEYSTO,RAM
;
	CSEG			;start with code segment
;
START	DI			;interrupts off
	LD	SP,TOPRAM	;set up stack
	IM	1		;rst38 interrupt please
	JR	OVAINT		;jump over interrupts
;
	ASEG			;must have fixed addresses
;
	ORG	#38		;maskable interrupts address
;
MASKINT	PUSH	HL		;save register used
	LD	HL,(TIMER)	;get timer count
	INC	HL		;bump count
	LD	(TIMER),HL	;and store
	POP	HL		;restore register used
	RETI			;and exit
;
	ORG	#66		;non-maskable interrupts address
;
NMINT	PUSH	AF		;save register used
	LD	A,(KEYPRS)	;get keypress
	LD	(KEYSTO),A	;and store
	POP	AF		;restore register used
	RETN			;and exit
;
	CSEG			;back to program code
;
	ORG	#80		;start at address past interrupts
;
;	code continues from here
;
OVAINT	NOP
;
