; intequ.inc
; Wed Aug  2 23:50:28 PDT 1989
; DSP 56000 interrupt vector equates
; This file came from Motorola's Dr. BuB DSP board

;************************************************************************
;
;       EQUATES for DSP56000 interrupts
;       Reference: DSP56000 User's Manual, Table 8.1, Interrupt Sources
;
;************************************************************************

i_reset EQU     $0000   ; hardware _RESET
i_stack EQU     $0002   ; stack error
i_trace EQU     $0004   ; trace
i_swi   EQU     $0006   ; SWI
i_irqa  EQU     $0008   ; _IRQA
i_irqb  EQU     $000A   ; _IRQB
 
i_ssird EQU     $000C   ; SSI receive data
i_ssirde EQU    $000E   ; SSI receive data with exception status
i_ssitd EQU     $0010   ; SSI transmit data
i_ssitde EQU    $0012   ; SSI transmit data with exception status
 
i_scird EQU     $0014   ; SCI receive data
i_scirde EQU    $0016   ; SCI receive data with exception status
i_scitd EQU     $0018   ; SCI transmit data
i_sciil EQU     $001A   ; SCI idle line
i_scitm EQU     $001C   ; SCI timer
 
i_hstrd EQU     $0020   ; host receive data
i_hsttd EQU     $0022   ; host transmit data
i_hstcm EQU     $0024   ; host command (default)
;
i_hstuc_0	equ	$26
i_hstuc_1	equ	$28
i_hstuc_2	equ	$2a
i_hstuc_3	equ	$2c
i_hstuc_4	equ	$2e
i_hstuc_5	equ	$30
i_hstuc_6	equ	$32
i_hstuc_7	equ	$34
i_hstuc_8	equ	$36
i_hstuc_9	equ	$38
i_hstuc_10	equ	$3a
i_hstuc_11	equ	$3c
;
i_illegal	equ	$3e
;
;---
;EOF
;---