/*
         Name: Remove symbols
         Type: C
       Author: Fredrik Noring
      Version: 0.9
 Date Entered: 16 September 1994
  Last Change: 16 September 1994

  Description: Removes LOD symbol table.
*/

#include <stdio.h>

#define VERSION "0.9"
#define DEFAULT_NAME "out.lod"
#define MAX_STRING 1024

char buffer[MAX_STRING];

main(argc, argv)
int argc;
char *argv[];
{
	FILE *fpl, *fps;

	switch (argc) {
		case 0:
		case 1:
			fpl = stdin;
			fps = stdout;
			break;
		case 2:
			if (!strcmp(argv[1], "-v")) {
				fprintf(stderr,
					"LOD symbol table remover v"VERSION"\n");
				return(0);
			} else {
				fpl = fopen(argv[1], "rb");
				fps = fopen(DEFAULT_NAME, "wb");
			}
			break;
		case 3:
			fpl = fopen(argv[1], "rb");
			fps = fopen(argv[2], "wb");
			break;
		default:
			printf("Too many arguments\n");
			return(-1);
	}

	while (fgets(buffer, MAX_STRING-1, fpl) != NULL) {
		if (!strncmp(buffer, "_SYMBOL", 7))
			while (fgets(buffer, MAX_STRING-1, fpl) != NULL &&
				strncmp(buffer, "_END", 4));
		fprintf(fps, buffer);
	}

	fclose(fpl);
	fclose(fps);

	return 0;
}
