;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; HV.INC - Constant file for Minimum Object List Update Examples

;PPP		.equ	4		; Pixels per Phrase (16-bit CRY)
;BMP_WIDTH	.equ	192		; Width in Pixels
;BMP_PHRASES	.equ	(192/PPP)	; Width in Phrases
;BMP_HEIGHT	.equ	67		; Height in Pixels
;BMP_LINES	.equ	(BMP_HEIGHT*2)	; Height in Half Scanlines

;X_MOTION	.equ	4
;Y_MOTION	.equ	6		; Should be even
;UPDATE_FREQ	.equ	1		; Update every frame

PPP		.equ	4		; Pixels per Phrase (16-bit CRY)
BMP_WIDTH	.equ	64		; Width in Pixels
BMP_PHRASES	.equ	(64/PPP)	; Width in Phrases
BMP_HEIGHT	.equ	64		; Height in Pixels
BMP_LINES	.equ	(BMP_HEIGHT*2)	; Height in Half Scanlines

X_MOTION	.equ	1
Y_MOTION	.equ	2		; Should be even

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Constants for GPU Interrupt Example

ISTACK		.equ	$F03EFC		    ; Location of interrupt stack

OP_INT		.equ	$F03030		    ; GPU Object Processor Interrupt
					                    ; Entry Point
OP_HNDLR_ADDR	.equ	$F03080		; Handler for GPU Object Processor
					                    ; Interrupt
GPU_LOOP_ADDR	.equ	$F03400		; Address of program code which waits for a flag
					                    ; and then shuts itself off.
