/****************************************************************/
/* File name:	INSERT.C	Revised:	1990.11.29	*/
/* Revised by:	U.R. Andersson	Sozoboned:	1990.11.29	*/
/* Copyright:	(c)1990 Lloyd Patton, all rights reserved.	*/
/*   but...	Rights for non-commercial uses released to PD.	*/
/****************************************************************/

/* Insert keypresses by Lloyd Patton */

/*
 * The problem is that if a replacement interrupt handler is written,
 * then the operating system does not receive the key press information, and
 * typing commands into a debugger becomes impossible.
 *     "Simply placing the keystroke data into the keyboard buffer will be
 * sufficient. Each keystroke is stored in a circular-list buffer as a 32 bit
 * integer, in the format returned by the Bconin routine. The low word contains
 * the character, the high word has the scan code in the lowest 8 bits and the
 * kbshift variable in the highest 8 bits. Also remember to update the Iorec
 * structure and take care of rotation around the buffer".
 *     Here is Lloyd's solution:
 */

#include	<osbind.h>

typedef	struct
{	char	*ibuf;
	int	ibufsiz;
	int	ibufhd;
	int	ibuftl;
	int	ibuflmk;
	int	ibufhmk;
} iorec;

main()
{	long	UpperA = 0x001e0041;	/* 'A' */
	long	Number0 = 0x000b0030;	/* '0' */
	long	ch;
	appl_init();
	insert_char(UpperA);
	ch = evnt_keybd();	/* test GEM call */
	printf("\nkeystroke should be 0x1e41 and is 0x%lx\n", ch);
	insert_char(Number0);
	ch = Bconin(2);		/* test BIOS call */
	printf("\nkeystroke should be 0x000b0030 and is 0x%08lx\n", ch);
	evnt_keybd();
	appl_exit();
} /* ends main() */

insert_char(keycode)
long	keycode;
{	iorec	*keybuf;
	long	stksave;
	keybuf = (iorec *) Iorec(1);	/* get Iorec address */
	stksave = Super(0L);	/* supervisor mode to access Iorec */
	if ((keybuf->ibuftl += 4) >= keybuf->ibufsiz)	/* test end */
		keybuf->ibuftl = 0;	/* loop around buffer */
	if (keybuf->ibuftl != keybuf->ibufhd)	/* test room */
		*(long *)&keybuf->ibuf[keybuf->ibuftl] = keycode;
		/* stores keystroke */
	Super(stksave);   /* back to user mode */
} /* ends insert_char(keycode) */

/* End of:	INSERT.C	*/
