/* NEOCONV 1.0 - "C" language source file
	for DRI's 68000 Alcyon C compiler, (Atari software development package).

   Author:		Ken Settle.
   Disclaimer:		I am not responsible for anything this does.
   Operating system:	GEMDOS.
   Computer:		Atari 520ST.

   Description: Converts DEGAS-format ".PI1" files to NEOCHROME ".NEO" format.
   Notes:	I have NEOCHROME & wanted to be able to mess with the DEGAS
		pictures (I'd have that too, but I can't find it anywhere).

   What's next: I'm working on a RAM disk and software print spooler, for Public
		Domain.  (who wants to pay $30+ for simple stuff like that?)

   Assembly procedure:

	cp68 neoconv.c neoconv.i
	c068 neoconv.i neoconv.1 neoconv.2 neoconv.3 -f
	c168 neoconv.1 neoconv.2 neoconv.s
	as68 -l -u neoconv.s
	link68 [u] neoconv.68k=apstart,neoconv,osbind,aesbind
	relmod neoconv

	(file should be renamed from NEOCONV.PRG to NEOCONV.TTP)

   Use: (1) double-click (open) the NEOCONV.TTP file.
	(2) enter the name of the .PI1 file you wish to convert (with or
		without the .PI1 extension.
	<or>
	(1) install the NEOCONV.TTP as an application for .PI1 files. 
	(2) double-click (open) the <picture>.PI1 file.

   Conversion times:
	about 15 seconds, floppy to floppy,
	about 2 seconds, hard disk to hard disk,
	about .5 seconds RAM disk to RAM disk.

*/

#include "osbind.h"

int buffer[17000];		/* I/O buffer for .PI1 picture file */
				/* (slight overkill, but who cares?) */
char newstuff[92]="        .   "; /* required by NEO, I don't know why. */

int gl_apid;			/* process ID # */

int cntrl[12];
int intin[128];
int ptsin[128];
int intout[128];
int ptsout[128];		/* storage wasted by bind to shel_read */

strcpy(s,t)			/* copy "t" string to "s" string */
char *s,*t;
{
 while(*s++ = *t++)		/* this is alot faster then a bind to GEMLIB */
   ;
}

do_error(number)
int number;
{
 Cconws("Error occurred... Press <return> to return to GEM desktop.\n\r");
 Cconin();				/* get a character */
 appl_exit();				/* say goodbye */
 Pterm0();				/* TERMINATOR */
}

main()
{long error;				/* dos error return code */
 int handle;				/* .PI1 input file handle */
 int handleo;				/* .NEO output file handle */
 long length;				/* length of input file */
 int index;				/* a general-purpose index for loops */
 int index1;				/* another index */
 char invoke[128],cmdtail[128];		/* command line paramaters */
 char fname[80];			/* filename */

 appl_init();

 for(index=12; index < 92; index++)	/* fill out newstuff with zeros */
  newstuff[index] = '\0';

 Cconws("NEOCONV 1.0 -- Convert DEGAS-format (.PI1) files to .NEO format.\n\r");
 Cconws("Public Domain 11/17/85:  Ken Settle.\n\n\r");

 Cconws("File:  ");

 shel_read(invoke,cmdtail);		/* get the command that made this */
/* cmdtail[0]++;	*/		/* inc count of characters */

 cmdtail[cmdtail[0]+1]='\0';		/* convert command line to a string */
 strcpy(fname,&cmdtail[1]);		/* copy that string into filename */

 for(index=cmdtail[0],index1=0; index > 0; --index)
 if(fname[index]=='.')			/* if we found the extension */
 {
  index1=index;  			/* remember where */
  index=0;				/* provide exit condition for loop */
 }else
 if(fname[index]==':' || fname[index]=='\\')	/* if catalog/drive spec */
 {
  index1=cmdtail[0];			/* no extension found, end of string */
  index=0;				/* provide exit condition for loop */
 }

 if(index1==0)				/* if no extension/drive/catalog */
  index1=cmdtail[0];			/* point to end of string */
  
/* for(index=1; index < cmdtail[0]; index++) \* find extension of input filename*/
/* if (cmdtail[index] == '.')
  index=cmdtail[0];
 else
  fname[index1++]=cmdtail[index];	\* build up a filename w/o extension */

 strcpy(&fname[index1],".PI1"); 	/* add ".PI1" extension to filename */

 Cconws(fname);				/* print the filename to the display */

 Cconws("\n\n\r");

 error=Fopen(fname,0);			/* open picture file to read */
 if(error<0)				/* if dos error, exit */
  do_error(error);

 handle=(int)error;			/* else-file handle was returned */

 Cconws("Reading ");			/* echo to display, "reading filename */
 Cconws(fname);
 Cconws("\n\r");

 length=Fread(handle,34000L,&buffer[1]); /* read entire file into buffer */
 if(length<0)				/* if dos error, exit */
  do_error(error);

 error=Fclose(handle);			/* close input file */
 if(error<0)				/* if dos error, exit */
  do_error(error);

 strcpy(&fname[index1],".NEO");		/* add .NEO extension to filename */
 error=Fcreate(fname,0);		/* create .NEO output file */
 if(error<0)				/* if dos error (you guessed it!) */
  do_error(error);

 error=Fopen(fname,1);			/* open .NEO file for writing */
 if(error<0)				/* if dos error, die */
  do_error(error);

 handleo=(int)error;			/* if no error, we have a file handle */

 Cconws("Writing ");			/* echo to display "writing filename" */
 Cconws(fname);
 Cconws("\n\r");

 buffer[0]=0;				/* NEO wants first word to be 0 */
 error=Fwrite(handleo,36L,&buffer);	/* write color pallette */
 if(error<0)				/* if error, blow up */
  do_error(error);

 error=Fwrite(handleo,92L,&newstuff);	/* pad out rest of 1st 128 bytes */
 if(error<0)				/* if error, kick the bucket */
  do_error(error);

 length -= 34;
 error=Fwrite(handleo,(long)length,&buffer[18]); /* write rest of file */
 if(error<0)				/* if error, die gracefully... */
  do_error(error);

/* Yes, this does work without a Fclose on the output file, exit does it. */

 Cconws("File converted.  Press <return> to return to desktop.\n\r");
 Cconin();				/* get a character */
 appl_exit();
} /* ends main() */  					/* done */

/* End of file */
