/*****************************************************************************
*
*                                    config.h
*
*   from DKBTrace (c) 1990  David Buck
*
*  This file contains ibm-specific defines, types, etc.
*
* This software is freely distributable. The source and/or object code may be
* copied or uploaded to communications services so long as this notice remains
* at the top of each file.  If any changes are made to the program, you must
* clearly indicate in the documentation and in the programs startup message
* who it was who made the changes. The documentation should also describe what
* those changes were. This software may not be included in whole or in
* part into any commercial package without the express written consent of the
* author.  It may, however, be included in other public domain or freely
* distributed software so long as the proper credit for the software is given.
*
* This software is provided as is without any guarantees or warranty. Although
* the author has attempted to find and correct any bugs in the software, he
* is not responsible for any damage caused by the use of the software.  The
* author is under no obligation to provide service, corrections, or upgrades
* to this package.
*
* Despite all the legal stuff above, if you do find bugs, I would like to hear
* about them.  Also, if you have any comments or questions, you may contact me
* at the following address:
*
*     David Buck
*     22C Sonnet Cres.
*     Nepean Ontario
*     Canada, K2H 8W7
*
*  I can also be reached on the following bulleton boards:
*
*     OMX              (613) 731-3419
*     Mystic           (613) 596-4249  or  (613) 596-4772
*
*  Fidonet:   1:163/109.9
*  Internet:  dbuck@ccs.carleton.ca
*  The "You Can Call Me RAY" BBS    (708) 358-5611
*
*  IBM Port by Aaron A. Collins. Aaron may be reached on the following BBS'es:
*
*     The "You Can Call Me RAY" BBS (708) 358-5611
*     The Information Exchange BBS  (708) 945-5575
*
*****************************************************************************/

/* The following defines may be added when porting to other systems or
   other compilers.  The defaults are shown here:


   #define PARAMS(x) x                   - use 'x' for ANSI, '()' for non ANSI
   #define EPSILON 1.0e-5                - a small value used for quartics
   #define FILE_NAME_LENGTH 150          - default file name length
 
   #define DBL double                    - floating point precision
   #define DBL_FORMAT_STRING "%lf"       - the string to use for scanfs of doubles
 
   #define DEFAULT_OUTPUT_FORMAT  'd'    - the default +f format
   #define TEST_ABORT                    - code to test for ^C or abort
                                           (called on each pixel)
   #define RED_RAW_FILE_EXTENSION ".red" - for +fr, this is the extension for the
                                           red file
   #define GREEN_RAW_FILE_EXTENSION ".grn"  - ditto for the green file
   #define BLUE_RAW_FILE_EXTENSION ".blu"   - ditto again for the blue file
   #define STARTUP_DKB_TRACE             - first executable statement of main
                                           (useful for initialization)
   #define PRINT_OTHER_CREDITS           - used for people who extend dkbtrace.
                                           (put your own printf's here)
   #define FINISH_DKB_TRACE              - last statement before exiting normally
   #define FILENAME_SEPARATOR "/"        - the character that separates names
                                           in a path.
   #define setvbuf(w,x,y,z)              - some systems don't understand setvbuf.
                                           If not, just define it away - it's
                                           not critical to the raytracer.  It
                                           just buffers disk accesses.
*/



/*** For Atari computers with Lattice C 5 or Turbo C compilers   ***/
/*** Some notes are included for happy owners of Pure C compiler ***/
#ifndef _PURE_C_
#define _PURE_C_
#endif

#ifndef _TURBO_C_    /* use _TURBO_C_ for Turbo C compilers    */
#define _TURBO_C_    /* or _LATTICE_C_ for Lattice C compilers */
#endif

/*** If you have a coprocessor ... ***/
/*
#ifndef _68881_
#define _68881_
#endif
*/


#include <stdarg.h>
#include <stdlib.h>
#ifdef _68881_
#include <math.h>
#endif

#define ACOS acos
#define SQRT sqrt
#define COS cos
#define SIN sin

#define DBL double
#define EPSILON 1.0e-5
/*#define HUGE_VAL 1.0e+17*/




#ifdef _TURBO_C_

	#include <ext.h>
	#include <math.h>
	
	#ifndef _PURE_C_	
	/*** For Turbo C 2.03, scanf function don't work with	*/
	/*** floating point library ... 			*/
	/*** ascanf() was written by Marc ABRAMSON, alias Redrackam */ 
	extern int ascanf(char *chaine, char *form, double *r_float);
	
	/*** Note: this bug is cleared in Pure C compiler and */
	/*** ascanf() is not used using this compiler.        */	
	#endif
#endif


#ifdef _LATTICE_C_

	/*** For Lattice C 5.06, with or without math. copro. ***/
	#include <conio.h>
	#ifdef _68881_
		#include <m68881.h>
	#else	
		#include <math.h>
	#endif

#endif

#ifdef _PURE_C_
	#define lfloor(a) floor(a)
	#define POW pow
#else
#ifndef _68881_
	#define POW pow
	#define lfloor(a) ((long)(a))
#else
	#ifndef _PURE_C_
	/*** floor() and fmod() are not defined with 6888x coprocessor ***/
	#define floor(a) fintrz(a)
	#define fmod(a,b) ((((a)/(b))-fintrz((a)/(b)))*(b))
		
	/*** Those two functions are used in file TEXTURE.C ***/
	#define lufloor(a) ((1.0*(long)(a)>(a))?((long)(a)-1):((long)(a)))  
	#define lfloor(a) (((a)>=0.0)?(lufloor(a)):(-lufloor(0.0-a)))  

	/*** pow() is not defined with 6888x coprocessor using ***/
	/*** Lattice C 5.06 or Turbo C 2.03 compilers ***/
	
	/*** pow & POW functions are used in TEXTURE.C and QUARTICS.C ***/
	extern DBL _pow(DBL a, DBL b);		
	#define pow(a,b) (((a)>0.0)?(exp((b)*log(a))):(_pow(a,b))) 
	#define POW pow
	
	/*** Note: with Pure C compiler, floor(), fmod() and */
	/*** pow() functions are correctly defined.          */
	#endif
#endif
#endif





#define DEFAULT_OUTPUT_FORMAT	'd'

#define TEST_ABORT if (Options & EXITENABLE) if (kbhit()) { Stop_Flag = TRUE; getch(); }

#define RED_RAW_FILE_EXTENSION	 ".r8"	/* PICLAB's "RAW" file format */
#define GREEN_RAW_FILE_EXTENSION ".g8"	/* PICLAB's "RAW" file format */
#define BLUE_RAW_FILE_EXTENSION	 ".b8"	/* PICLAB's "RAW" file format */

#define FILENAME_SEPARATOR "\\"		/* wierd 'ol IBM's like backslashes */

#define PARAMS(x)  x


