#include "global.h"
#include "comm.h"
#include "dd.h"
#include "file.h"
#include "options.h"
#include "poslist.h"
#include "rsc.h"
#include "window.h"
#include "av.h"


/* exportierte Variablen *****************************************************/
GLOBAL WORD	av_shell_id = -1,		/* ID des Desktops */
				av_shell_status = 0;	/* Welche AV_* kann Desktop */

/* lokale Variablen **********************************************************/

/* Hilfe-System **************************************************************/

#ifndef AC_HELP
#define AC_HELP		1025
#endif

/*
 * Generiert aus einem Pfadnamen den GEM-Namen (max. acht Zeichen, ggf.
 * mit ' ' aufgefllt) und berprft ihn auf ST-GUIDE.
*/
LOCAL BOOLEAN make_name(UBYTE *longname, UBYTE *shortname, BOOLEAN must_stg)
{
	WORD	len, i;
	UBYTE	*p;

	if (longname[0] == EOS)
	{
		note(1, NOHELP);
		strcpy(shortname, "");
		return FALSE;
	}
	else
	{
		file_name(longname, shortname, FALSE);
		str_upper(shortname);
		p = strrchr(shortname, '.');				/* Extension abschneiden */
		*p = '\0';
		len = (short) strlen(shortname);
		for (i = len; i < 8; i++)
			strcat(shortname, " ");
		if (must_stg && (strcmp(shortname, "ST-GUIDE") != 0))
		{
			note(1, NOSTG);
			return FALSE;
		}
		else
			return TRUE;
	}
}


/*
 * Liefert die app_id des bergebenen Programmes zurck. Falls es noch
 * nicht luft, wird es mit arg gestartet.
*/
LOCAL WORD get_id(UBYTE* name, UBYTE *path, UBYTE *arg, BOOLEAN *started)
{
	WORD		ret = -1;
	UBYTE		*p, help[128] = "";
	BOOLEAN	s = FALSE;

	if (name[0] != EOS)
	{
		ret = appl_find(name);
		if (ret < 0)							/* ggf. als Programm nachstarten */
		{
			if (arg != NULL)
			{
				strcpy(help, " ");
				strcat(help, arg);
				help[0] = (UBYTE)strlen(help);
			}
			p = strrchr(path, '.');
			if (file_exist(path) && ((strncmp(p, ".APP", 3) == 0) || (strncmp(p, ".PRG", 3) == 0) ||
											 (strncmp(p, ".app", 3) == 0) || (strncmp(p, ".prg", 3) == 0)))
			{
				if (gem >= 0x400)
				{
					ret = shel_write(1, 1, 1, path, help);
					s = (ret > 0);
				}
				else if (magx)
				{
					ret = shel_write(1, 1, 100, path, help);
					s = (ret > 0);
				}
				else
				{
					note(1, HELPSTART);
					ret = -1;
				}
			}
			else
			{
				fnote(1, HELPNOTF, helpprog);
				ret = - 1;
			}
		}
	}
	if (started != NULL)
		*started = s;
	return ret;
}

LOCAL VOID send_help(WORD id, CONST UBYTE *str)
{
	memset(msgbuff, 0, (WORD)sizeof(msgbuff));
	msgbuff[0] = AC_HELP;
	msgbuff[1] = gl_apid;
	strcpy(global_str1, str);
	*(UBYTE **)(msgbuff + 3) = global_str1;
	send_msg(id);
}

GLOBAL BOOLEAN call_help(CONST UBYTE *str)
{
	WORD		help_id;
	FILENAME	name;

	wake_mouse();
	if (make_name(helpprog, name, FALSE))
	{
		help_id = get_id(name, helpprog, NULL, NULL);
		if (help_id > 0)
		{
			send_help(help_id, str);
			return TRUE;
		}
	}
	return FALSE;
}

GLOBAL BOOLEAN call_hyp(CONST UBYTE *data)
{
	WORD		stg_id;
	UBYTE 	help[80];
	FILENAME name;
	BOOLEAN	started;

	if (helpprog[0] == EOS)
	{
		note(1, NOHELP);
		return FALSE;
	}
	wake_mouse();
	if (make_name(helpprog, name, TRUE))
	{
		strcpy(help, "*:\\qed.hyp ");
		strcat(help, data);

		stg_id = get_id(name, helpprog, help, &started);
		if (stg_id > 0 && !started)			/* nicht gestartet, da es bereits lief! */
			send_vastart(stg_id, help);		/* -> also Message schicken */
		return (stg_id > 0);
	}
	return FALSE;
}


LOCAL VOID get_my_name(UBYTE *my_name)
{
	UBYTE	str[12];
	WORD	d, i, id;

	if ((appl_xgetinfo(4, &d, &d, &i, &d)) && (i == 1))	/* gibts appl_search? */
	{
		i = appl_search(0, str, &d, &id);
		while (i != 0)
		{
			if (id == gl_apid)
				break;
			i = appl_search( 1, str, &d, &id);
		}
	}
	if (i != 0)
	{
		strcpy(my_name, str);
		for (i = (WORD)strlen(my_name); i < 8; i++)
			strcat(my_name, " ");
	}
	else
		strcpy(my_name, "");
	if	(debug & DBG_AV)
		Debug("qed: get_my_name()= %s.\n", my_name);
}

/* AV-Protokoll **************************************************************/

LOCAL UBYTE	*glob_data = NULL;

LOCAL VOID send_avprot(VOID)
{
	if (av_shell_id >= 0)
	{
		memset(msgbuff, 0, (WORD)sizeof(msgbuff));
		msgbuff[0] = AV_PROTOKOLL;
		msgbuff[1] = gl_apid;
		msgbuff[3] = (2|16);		/* VA_START, Quoting */
		get_my_name(global_str1);
		*(UBYTE **) (msgbuff + 6) = global_str1;
		send_msg(av_shell_id);
		if (debug & DBG_AV)
			Debug("qed: AV_PROTOKOLL\n");
	}
}

LOCAL VOID send_avexit(VOID)
{
	if ((av_shell_id >= 0) && (av_shell_status & 1024))
	{
		memset(msgbuff, 0, (WORD)sizeof(msgbuff));
		msgbuff[0] = AV_EXIT;
		msgbuff[1] = gl_apid;
		msgbuff[3] = gl_apid;
		send_msg(av_shell_id);
		if (debug & DBG_AV)
			Debug("qed: AV_EXIT\n");
	}
}

GLOBAL BOOLEAN send_avkey(WORD ks, WORD kr)
{
	BOOLEAN	b = FALSE;

	if ((av_shell_id >= 0) && (av_shell_status & 1))
	{
		wake_mouse();
		memset(msgbuff, 0, (WORD)sizeof(msgbuff));
		msgbuff[0] = AV_SENDKEY;
		msgbuff[1] = gl_apid;
		msgbuff[3] = ks;
		msgbuff[4] = kr;
		b = send_msg(av_shell_id);
		if (debug & DBG_AV)
			Debug("qed: AV_SENDKEY (%d,%d)\n", ks, kr);
	}
	return b;
}

GLOBAL VOID send_avwinopen(WORD handle)
{
	if ((av_shell_id >= 0) && (wind_cycle))	/* Fensterwechsel global */
	{
		memset(msgbuff, 0, (WORD)sizeof(msgbuff));
		msgbuff[0] = AV_ACCWINDOPEN;
		msgbuff[1] = gl_apid;
		msgbuff[3] = handle;
		send_msg(av_shell_id);
		if (debug & DBG_AV)
			Debug("qed: AV_ACCWINDOPEN (%d)\n", handle);
	}
}

GLOBAL VOID send_avwinclose(WORD handle)
{
	if ((av_shell_id >= 0) && (wind_cycle))	/* Fensterwechsel global */
	{
		memset(msgbuff, 0, (WORD)sizeof(msgbuff));
		msgbuff[0] = AV_ACCWINDCLOSED;
		msgbuff[1] = gl_apid;
		msgbuff[3] = handle;
		send_msg(av_shell_id);
		if (debug & DBG_AV)
			Debug("qed: AV_ACCWINDCLOSED (%d)\n", handle);
	}
}

GLOBAL VOID send_avdrag(WORD wh, MOUSEDATA *mouse, WORD data_type)
{
	if ((av_shell_id >= 0) && (av_shell_status & 512))
	{
		WORD	app, d;
		
		wind_get(wh, WF_OWNER, &app, &d, &d, &d);
		memset(msgbuff, 0, (WORD)sizeof(msgbuff));
		msgbuff[0] = AV_DRAG_ON_WINDOW;
		msgbuff[1] = gl_apid;
		msgbuff[3] = mouse->x;
		msgbuff[4] = mouse->y;
		msgbuff[5] = mouse->kstate;

		switch (data_type)
		{
			case DRAGDROP_PATH :		/* ein Name */
				if (debug & DBG_AV)
					Debug("qed: AV_DRAG_TO_WIN single file\n");
				strcpy(global_str1, drag_filename);
				*(UBYTE **) (msgbuff + 6) = global_str1;
				break;
			case DRAGDROP_DATA :		/* mehrere Namen */
				if (debug & DBG_AV)
					Debug("qed: AV_DRAG_TO_WIN multible files\n");
				glob_data = malloc_global(drag_data_size + 1);
				if (glob_data != NULL)
				{
					strcpy(glob_data, drag_data);
					*(UBYTE **) (msgbuff + 6) = glob_data;
				}
				break;
		}
		send_msg(av_shell_id);
	}
}

GLOBAL VOID send_vastart(WORD id, CONST UBYTE *data)
{
	memset(msgbuff, 0, (WORD)sizeof(msgbuff));
	msgbuff[0] = VA_START;
	msgbuff[1] = gl_apid;
	strcpy(global_str1, data);
	*(UBYTE **)(msgbuff + 3) = global_str1;
	send_msg(id);
}

LOCAL VOID send_avstarted(WORD id, UBYTE *p)
{
	memset(msgbuff, 0, (WORD)sizeof(msgbuff));
	msgbuff[0] = AV_STARTED;
	msgbuff[1] = gl_apid;
	*(UBYTE **)(msgbuff + 3) = p;
	send_msg(id);
}

/*
 * Zerlegt VA_START-Arg in einzelne Dateinamen.
 * Quoting wird korrekt ausgewertet ('arg 1', 'arg''s')
*/
LOCAL BOOLEAN parse_vaarg(POSENTRY **list, UBYTE *arg)
{
	WORD		i, j, len;
	PATH		filename;
	BOOLEAN	in_quote = FALSE;
	
	len = (WORD)strlen(arg);
	if (len > 0)
	{
		i = 0;
		j = 0;
		strcpy(filename, "");
		while (i < len)
		{
			if (arg[i] == '\'')
			{
				i++;
				if (in_quote)
				{
					if (arg[i] == '\'')					/* Doppeltes ' */
					{
						filename[j++] = '\'';
						i++;
					}
					else
						in_quote = FALSE;
				}
				else
					in_quote = TRUE;
			}
			if ((arg[i] != ' ') || ((arg[i] == ' ' && in_quote)))
				filename[j++] = arg[i++];
			else
			{
				filename[j++] = '\0';
				insert_poslist(list, filename, 0, 0);
				j = 0;
				i++; 
			}
		}
		if (j > 0)
		{
			filename[j++] = '\0';
			insert_poslist(list, filename, 0, 0);
		}
		return TRUE;
	}
	return FALSE;
}


GLOBAL VOID hndl_av(WORD msg[])
{
	UBYTE		*str_p;
	EVNTDATA	ev;
	POSENTRY	*va_list = NULL;

	switch (msg[0])
	{
		case VA_START :
			if (all_iconified)
				all_uniconify(NULL);
			str_p = *(UBYTE **)(msg + 3);
			if (str_p != NULL)
			{
				if (strlen(str_p) > 0 && parse_vaarg(&va_list, str_p))
				{
					send_avstarted(msg[1], str_p);
					if (debug & DBG_AV)
						Debug("qed: va_arg= %s\n", str_p);
					open_poslist(va_list);
					delete_poslist(&va_list);
				}
			}
			break;
		case VA_PROTOSTATUS :
			if (debug & DBG_AV)
				Debug("qed: VA_PROTSTATUS %u\n", av_shell_status);
			av_shell_status = msg[3];
			if (wind_cycle && !(av_shell_status & 64))
				wind_cycle = FALSE;			/* glob. Fensterwechsel abschalten */
			break;
		case VA_DRAG_COMPLETE :
			if (debug & DBG_AV)
				Debug("qed: VA_DRAG_COMPLETE.\n");
			if (glob_data != NULL)
			{
				free(glob_data);
				glob_data = NULL;
			}
			break;
		case VA_DRAGACCWIND :				/* bei D&D mit glob. Fensterwechsel */
			str_p = *(UBYTE **)(msg + 6);
			if (str_p != NULL)
			{
				graf_mkstate(&ev);
				hndl_avdd(msg[3], ev.kstate, str_p);
			}
			break;
		default:
			break;
	}
}

GLOBAL VOID init_av(VOID)
{
	WORD	i;
	UBYTE	name[9], *p;

	p = getenv("AVSERVER");
	if (p != NULL)
	{
		strncpy(name, p, 8);
		name[8] = EOS;
		for (i = (WORD)strlen(name); i < 8; i++)
			strcat(name, " ");
		i = appl_find(name);
		if (i >= 0)
			av_shell_id = i;
	}
	if (debug & DBG_AV)
		Debug("qed: av_shell_id= %d\n", av_shell_id);

	send_avprot();
}

GLOBAL VOID term_av(VOID)
{
	send_avexit();
}
