#include "global.h"
#include "av.h"
#include "clipbrd.h"
#include "dd.h"
#include "olga.h"
#include "se.h"
#include "comm.h"

/* Document-History fr StartMeUp ********************************************/
#define DHST_ADD 0xDADD

typedef struct
{
	char	*appname,
       	*apppath,
       	*docname,
       	*docpath;
} DHSTINFO;

/* exportierte Variablen *****************************************************/
GLOBAL UBYTE	*global_str1,
					*global_str2;
GLOBAL WORD		msgbuff[8]; 			/* Buffer, den send_msg verschickt */


/* lokale Variablen **********************************************************/
LOCAL DHSTINFO	*dhst = NULL;
LOCAL WORD		dhst_id = -1;

/*****************************************************************************/

GLOBAL VOID *malloc_global(LONG size)
{
	VOID	*r;

	if (__mint || magx)
		r = Mxalloc(size, 43);
	else
		r = Malloc(size);
	return r;
}

GLOBAL BOOLEAN send_msg(WORD id)
{
	WORD	ret;
	
	msgbuff[1] = gl_apid;
	msgbuff[2] = 0;
	ret = appl_write(id, (short) sizeof(msgbuff), msgbuff);
	return (ret > 0);
}


GLOBAL VOID send_clip_change(VOID)
{
	WORD	d, i;

	if ((av_shell_id >= 0) && (av_shell_status & 512))	/* Desktop informieren */
	{
		memset(msgbuff, 0, (WORD)sizeof(msgbuff));
		msgbuff[0] = AV_PATH_UPDATE;
		strcpy(global_str1, clip_dir);
		*(UBYTE **) (msgbuff + 3) = global_str1;
		send_msg(av_shell_id);
	}
	if (((appl_xgetinfo(10, &i, &d, &d, &d)) && ((i&0x00FF) >= 7)) /* gibts Broadcast? */
		 || (magx >= 0x400))
	{
		memset(msgbuff, 0, (WORD)sizeof(msgbuff));
		msgbuff[0] = SC_CHANGED;	/* alle anderen Applikationen */
		msgbuff[1] = gl_apid;
		msgbuff[3] = 0x0002;	/* Text */
		msgbuff[4] = '.T';
		msgbuff[5] = 'XT';
		shel_write(7, 0, 0, (UBYTE *)msgbuff, NULL);
	}
}

GLOBAL VOID send_m_special(WORD mode, WORD app)
{
	if (magx)
	{
		WORD	id;
		memset(msgbuff, 0, (WORD)sizeof(msgbuff));
		msgbuff[0] = SM_M_SPECIAL;
		msgbuff[4] = 'MA';
		msgbuff[5] = 'GX';
		msgbuff[6] = mode;
		msgbuff[7] = app;
		id = appl_find("SCRENMGR");
		send_msg(id);
	}
}

GLOBAL VOID send_dhst(UBYTE *filename)
{
	if (dhst_id == -1)
	{
		LONG	l;

		if (getcookie('DHST', &l))
			dhst_id = (short)l;
		else
			dhst_id = 0;
	}
	if (dhst_id > 0)
	{
		if (dhst == NULL)
		{
			dhst = malloc_global(sizeof(DHSTINFO));
			dhst->appname = malloc_global(4);
			strcpy(dhst->appname, "qed");
			
			if (debug)
			{
				dhst->apppath = malloc_global(22);
				strcpy(dhst->apppath, "c:\\system\\qed\\qed.app");
			}
			else
			{
				dhst->apppath = malloc_global(strlen(app_path) + strlen("qed.app") + 1);
				strcpy(dhst->apppath, app_path);
				strcat(dhst->apppath, "qed.app");
			}
			dhst->docname = malloc_global(sizeof(FILENAME));
			dhst->docpath = malloc_global(sizeof(PATH));
		}
		file_splitt(filename, NULL, dhst->docname);
		strcpy(dhst->docpath, filename);
		
		msgbuff[0] = DHST_ADD;
		*(DHSTINFO **)(msgbuff + 3) = dhst;
		msgbuff[5] = 0;
		msgbuff[6] = 0;
		msgbuff[7] = 0;
		send_msg(dhst_id);
	}
}

GLOBAL VOID init_comm(VOID)
{
	global_str1 = malloc_global(256);
	global_str2 = malloc_global(256);
	init_av();
	init_se();
	init_olga();
}

GLOBAL VOID term_comm(VOID)
{
	term_olga();
	term_se();
	term_av();
	if (global_str1 != NULL)
		Mfree(global_str1);
	if (global_str2 != NULL)
		Mfree(global_str2);
	if (dhst != NULL)
	{
		Mfree(dhst->appname);
		Mfree(dhst->apppath);
		Mfree(dhst->docname);
		Mfree(dhst->docpath);
		Mfree(dhst);
	}
}
