#include <atarierr.h>
#include <limits.h>
#include <signal.h>

#include "global.h"
#include "comm.h"
#include "edit.h"
#include "find.h"
#include "icon.h"
#include "projekt.h"
#include "window.h"
#include "dd.h"


#define DD_OK			0
#define DD_NAK 		1
#define DD_EXT 		2
#define DD_LEN 		3

#define DD_NUMEXTS	8
#define DD_EXTSIZE	32
#define DD_NAMEMAX	128
#define DD_TIMEOUT	4000

/* exportierte Variablen *****************************************************/
GLOBAL PATH		drag_filename;		/* Dateiname/Pfad wurde gedragged */
GLOBAL UBYTE	*drag_data;			/* Daten wurden gedragged */
GLOBAL LONG		drag_data_size;	/* Die Lnge der Daten */

/* lokale Variablem **********************************************************/
LOCAL __Sigfunc	oldsig;


/* DD Empfang ****************************************************************/
LOCAL WORD parse_ARGS(UBYTE *str)
{
	WORD		cnt = 1;
	UBYTE 	*c = str;
	BOOLEAN	in_quote = FALSE;

	while (*c)
	{
		switch (*c)
		{
			case ' ' :
				if (!in_quote)
				{
					*c = '\0';
					cnt++;
				}
				break;
			case '\'' :
				strcpy(c, c + 1);
				if (!in_quote)
					in_quote = TRUE;
				else
				{
					if (*c != '\'')
					{
						in_quote = FALSE;
						*c = 0;
						if (c[1])
							cnt++;
					}
				}
				break;
			default:
				break;
		} /* switch */
		c += 1;
	} /* while */
	return cnt;
}

LOCAL VOID insert(WINDOWP w, WORD kstate, UBYTE *filename)
{
	BOOLEAN	alt;
	WORD		icon;

 	global_shift = (kstate & 3);
	alt = (kstate & 0x8);
	make_normalpath(filename, FALSE);
	strcpy(drag_filename, filename);
	if (w->class == CLASS_PROJEKT)
	{
		if (filename[strlen(filename) - 1] == '\\')			/* Pfad */
			Icon_drag(w->handle, DRAGDROP_PATH);				/*  -> Datei suchen */
		else																/* Datei */
			Icon_drag(w->handle, DRAGDROP_FILE);				/*  -> einfgen */
	}
	else
	{
		if (global_shift || 											/* Name bzw. */
			 (filename[strlen(filename) - 1] == '\\'))		/* Pfad einfgen */
			Icon_drag(w->handle, DRAGDROP_PATH);
		else if (alt)													/* Inhalt einfgen */
			Icon_drag(w->handle, DRAGDROP_FILE);
		else																/* neues Fenster ffnen */
		{
			if (filematch(filename, "*.QPJ"))
				icon = load_projekt(filename);
			else
				icon = load_edit(filename, FALSE);
			if (icon > 0)
				send_dhst(filename);
		}
	}
}

LOCAL VOID parse(UBYTE *cmdline, WINDOWP w, WORD kstate)
{
	WORD	comps = parse_ARGS(cmdline);
	UBYTE *c = cmdline;

	drag_data_size = comps;			/* Anzahl der ARGS merken */
	while (comps - 1)
	{
		insert(w, kstate, c);
		c += strlen(c) +1;
		comps--;
	}
	insert(w, kstate, c);
}

LOCAL LONG dd_open_pipe(WORD pnum)
{
	UBYTE pipename[20];
	LONG	fd;

	sprintf(pipename, "U:\\PIPE\\DRAGDROP.%c%c", (pnum & 0xff00) >> 8, pnum & 0xff);
	if ((fd = Fopen(pipename, 2)) > 0)
		oldsig = signal(SIGPIPE, SIG_IGN);
	return fd;
}

LOCAL VOID dd_close(LONG fd)
{
	signal(SIGPIPE, oldsig);
	Fclose((short) fd);
}

LOCAL LONG dd_open(WORD pipe_num, CONST UBYTE *extlist)
{
	LONG	fd;
	UBYTE outbuf[DD_EXTSIZE + 2];

	fd = dd_open_pipe(pipe_num);
	if (fd < 0)
		return fd;

	memset(outbuf, 0, DD_EXTSIZE + 2);
	outbuf[0] = DD_OK;
	strncpy(outbuf + 1, extlist, DD_EXTSIZE);
	if (Fwrite((short) fd, DD_EXTSIZE + 1, outbuf) != DD_EXTSIZE + 1)
	{
		dd_close(fd);
		return -1L;
	}
	return fd;
}

LOCAL BOOLEAN dd_getheader(LONG fd, UBYTE *obname, UBYTE *fname, UBYTE *datatype,
									LONG *size)
{
	WORD		hdrlen, cnt, slen;
	UBYTE 	buf[PATH_MAX + DD_NAMEMAX + 1];

	if (Fread((short) fd, 2, &hdrlen) != 2)
		return FALSE;
	if (hdrlen < 8)
		return FALSE;

	if (Fread((short) fd, 4, datatype) != 4)
		return FALSE;
	datatype[4] = '\0';

	if (Fread((short) fd, 4, size) != 4)
		return FALSE;
	hdrlen -= 8;
	cnt = hdrlen;

	if (cnt > PATH_MAX + DD_NAMEMAX)
		cnt = PATH_MAX + DD_NAMEMAX;
	if (Fread((short) fd, cnt, buf) != cnt)
		return FALSE;
	buf[PATH_MAX + DD_NAMEMAX] = '\0';
	hdrlen -= cnt;
	slen = (short) strlen(buf);

	if (slen < DD_NAMEMAX)
		strcpy(obname, buf);
	if (slen < PATH_MAX + DD_NAMEMAX)
	{
		UBYTE *fp = buf + slen + 1;

		slen = (short) strlen(fp);
		if (slen < PATH_MAX)
			strcpy(fname, fp);
	}

	while (hdrlen)
	{
		WORD	cnt = hdrlen;

		if (cnt > sizeof(buf))
			hdrlen = (short) sizeof(buf);
		Fread((short) fd, cnt, buf);
		hdrlen -= cnt;
	}
	return TRUE;
}

LOCAL BOOLEAN dd_reply(LONG fd, UBYTE ack)
{
	if (Fwrite((short) fd, 1L, &ack) != 1)
	{
		dd_close(fd);
		return FALSE;
	}
	return TRUE;
}

GLOBAL VOID	hndl_dd(WORD *msg)
{
	WINDOWP 	w_dest = get_window(msg[3]);
	LONG		fd,
				size;
	UBYTE 	obname[DD_NAMEMAX],
				ext[5],
				fname[PATH_MAX],
				ourexts[DD_EXTSIZE] = "ARGS.TXT";

	if (w_dest != NULL)
	{
		fd = dd_open(msg[7], ourexts);
		if (fd < 0)
			return ;

		do
		{
			if (!dd_getheader(fd, obname, fname, ext, &size))
			{
				dd_close(fd);
				return;
			}
			if (!strncmp(ext, "ARGS", 4))
			{
				UBYTE	*cmdline = malloc(size +1);

				if (!cmdline)
				{
					dd_reply(fd, DD_LEN);
					continue;
				}
				dd_reply(fd, DD_OK);
				Fread((short) fd, size, cmdline);
				dd_close(fd);
				cmdline[size] = 0;
				parse(cmdline, w_dest, msg[6]);
				free(cmdline);
				drag_data_size = 0;
				return ;
			}
			if (strncmp(ext, ".TXT", 4) == 0 )
			{
				drag_data = malloc(size + 1);
				/* ^^ wird nach dem Einfgen in edit.c wieder freigegeben! */
				drag_data_size = size;
				if (drag_data == NULL)
				{
					dd_reply(fd, DD_LEN);
					continue;
				}
				dd_reply(fd, DD_OK);
				Fread((short) fd, drag_data_size, drag_data);
				dd_close(fd);
				drag_data[drag_data_size] = 0;
				Icon_drag(w_dest->handle, DRAGDROP_DATA);
				return ;
			}
		}
		while (dd_reply(fd, DD_EXT));
	}
}


GLOBAL VOID	hndl_avdd(WORD win_handle, WORD kstate, UBYTE *arg)
{
	WINDOWP 	w_dest = get_window(win_handle);
	UBYTE		*cmdline;
	
	if (w_dest != NULL)
	{
		cmdline = (UBYTE *) malloc(strlen(arg));
		strcpy(cmdline, arg);
		parse(cmdline, w_dest, kstate);
		free(cmdline);
	}
}

/* DD Senden *****************************************************************/

#if 0

LOCAL WORD dd_create(WORD rcvr_id, WORD window, MOUSEDATA *mouse, ULONG format[8])
{
	UBYTE	pipe[24];
	LONG	handle_mask;
	WORD	handle, i;

	strcpy(pipe, "U:\\pipe\\dragdrop.aa" );
	pipe[18] = 'a' - 1;
	do														/* erste freie Pipe suchen */
	{
		pipe[18]++;
		if (pipe[18] > 'z')
		{
			pipe[17]++;
			if (pipe[17] > 'z')
				return( -1 );
		}
		handle = (WORD)Fcreate(pipe, 0x02);		
	} 
	while (handle == EACCDN);

	if (handle < 0)
		return(handle);

	memset(msgbuff, 0, (WORD)sizeof(msgbuff));
	msgbuff[0] = AP_DRAGDROP;
	msgbuff[3] = window;
	msgbuff[4] = mouse->x;
	msgbuff[5] = mouse->y;
	msgbuff[6] = mouse->kstate;
	msgbuff[7] = (((WORD) pipe[17]) << 8 ) + pipe[18];
	
	if (!send_msg(rcvr_id))
	{
		Fclose(handle);
		return(-2);
	}

	handle_mask = 1L << handle;
	i = Fselect(DD_TIMEOUT, &handle_mask, 0L, 0L);
	if (i && handle_mask)
	{
		UBYTE	reply;
		
		if (Fread(handle, 1L, &reply) == 1)
		{
			if (reply == DD_OK)
			{
				if (Fread(handle, DD_EXTSIZE, format) == DD_EXTSIZE)	
				{
					oldsig = Psignal(SIGPIPE, (void *) SIG_IGN);
					return(handle);
				}
			}
		}
	}
	Fclose(handle);
	return(-1);
}

LOCAL WORD dd_stry(WORD handle, ULONG format, UBYTE *name, LONG size)
{
	WORD	str_len;
	WORD	hdr_len;
	
	str_len = (WORD)strlen(name) + 1;
	hdr_len = 4 + 4 + str_len;
	if (Fwrite(handle, 2, &hdr_len) == 2)
	{
		LONG	written;
		
		written = Fwrite(handle, 4, &format);
		written += Fwrite(handle, 4, &size);
		written += Fwrite(handle, str_len, name);
		
		if (written == hdr_len)
		{
			UBYTE	reply;
			
			if (Fread(handle, 1, &reply) == 1)
				return(reply);
		}
	}	
	return(DD_NAK);
}

GLOBAL VOID send_dd(WORD wh, MOUSEDATA *mouse, WORD data_type)
{
	WORD		pipe, app, d;
	ULONG		types[DD_NUMEXTS];
	LONG		ret;
	
	wind_get(wh, WF_OWNER, &app, &d, &d, &d);
	pipe = dd_create(app, wh, mk, types);
	if (pipe > 0)
	{
		switch (data_type)
		{
			case DRAGDROP_FILE :
				break;
			case DRAGDROP_PATH :
				if (dd_stry(pipe, 'ARGS', "ARGS.TXT", strlen(drag_filename) + 1) == DD_OK)
				{
					ret = Fwrite(pipe, strlen(drag_filename) + 1, drag_filename);
					Fclose(pipe);
Debug("qed: D&D to Win %d, App %d\n", wh, app);
				}
				break;
			case DRAGDROP_DATA :
				break;
		}
	}
}
#endif
