/*
 * Debug ermglicht das Debuggen von GEM-Programmen.
 * Dazu wird eines der mglichen DEBUGDEVICEs geffnet und dann
 * kann es wie eine normale Datei fr Ausgaben benutzt werden.
 *
 */
#ifndef _DEBUG_H_
#define _DEBUG_H_

typedef enum {null, Con, TCON, Datei, Terminal, 
				  Modem1, Modem2, Seriell1, Seriell2, Prn} DEVICETYP;
/*
 * Legt die mglichen Ausgabekanle fest.
 */

EXTERN VOID	DebugInit(DEVICETYP dev, UBYTE *file);
/*
 * Initialisiert das Debugdevice.
 *	dev	 : Typ des Devices
 * file	 : Wenn dev = Datei, der Dateiname der Log-Datei, sonst NULL.
 */
 
EXTERN VOID	DebugExit(VOID);
/*
 * Schliet das Device.
 */
 
EXTERN VOID	Debug(UBYTE *FormatString, ...);
/*
 * Ein Ersatz fr fprintf. Parameter so wie bei fprintf.
 */

EXTERN VOID StopIt(BOOLEAN start);
/*
 * Stopt die 200Hz-Ticks.
*/

#endif
