#include <support.h>
#include <time.h>

#include "global.h"
#include "ausgabe.h"
#include "av.h"
#include "block.h"
#include "clipbrd.h"
#include "comm.h"
#include "dd.h"
#include "event.h"
#include "error.h"
#include "file.h"
#include "find.h"
#include "fontsel.h"
#include "icon.h"
#include "kurzel.h"
#include "makro.h"
#include "memory.h"
#include "menu.h"
#include "obj.h"
#include "olga.h"
#include "options.h"
#include "poslist.h"
#include "printer.h"
#include "projekt.h"
#include "rsc.h"
#include "set.h"
#include "sort.h"
#include "tasten.h"
#include "text.h"
#include "umbruch.h"
#include "window.h"
#include "edit.h"

/* Exportierte Variablen ***************************************************/
GLOBAL WORD	edit_type;

/****** DEFINES ************************************************************/

#define KIND	(NAME|INFO|CLOSER|FULLER|MOVER|SIZER|UPARROW|DNARROW|VSLIDE|LFARROW|RTARROW|HSLIDE|SMALLER)
#define FLAGS	(WI_TEXT|WI_FONTSIZE|WI_REDRAW)

/* Anzahl der nderungen in allen Texten bis zum restore_edit */
#define MAX_CHG 30

#define TEMP_LINK 10001

/****** TYPES **************************************************************/

typedef struct
{
	WORD	link; 		/* Nummer von Text und Window */
	WORD	c; 		/* Art der nderung */
	LONG	y; 		/* y-Position */
} TCHANGE;

/* lokale Variablen ********************************************************/
LOCAL SET		used_info;	/* Icon-Nr fr Text und Fenster */
LOCAL WORD		chg_anz, find_erg, ascii_wert;
LOCAL TCHANGE 	chg[MAX_CHG];
LOCAL SET		chg_links;
LOCAL POSENTRY	*lastpos_list = NULL;

/* lokale Prototypen *******************************************************/

LOCAL VOID 		icon_exist		(WORD icon, SET actions);
LOCAL BOOLEAN 	icon_test		(WORD icon, WORD action);
LOCAL WORD		icon_edit		(WORD icon, WORD action);
LOCAL BOOLEAN 	icon_drag		(WORD icon, WORD source);
LOCAL VOID 		wi_draw			(WINDOWP window, CONST GRECT *d);
LOCAL VOID 		wi_click 		(WINDOWP window, MOUSEDATA *mouse);
LOCAL BOOLEAN 	wi_key			(WINDOWP window, KEYDATA *key);
LOCAL VOID 		wi_top			(WINDOWP window);
LOCAL	VOID		wi_iconify		(WINDOWP window);
LOCAL	VOID		wi_uniconify	(WINDOWP window);
LOCAL VOID 		destruct 		(WORD icon);

LOCAL VOID 		lz2tab			(TEXTP t_ptr);
LOCAL VOID 		tab2lz			(TEXTP t_ptr);
LOCAL VOID 		goto_line		(TEXTP t_ptr, WORD x, LONG y);
LOCAL VOID 		make_undo		(TEXTP t_ptr);
LOCAL VOID 		print_edit		(TEXTP t_ptr);
LOCAL BOOLEAN 	open_edit		(WORD icon);
LOCAL VOID 		crt_edit 		(WINDOWP window);
LOCAL WORD  	crt_new_text	(CONST UBYTE *filename);

/***************************************************************************/

WORD anz_loaded(VOID)
{
	return (setcard(used_info));
}

WORD still_loaded(UBYTE *name)
{
	WORD i, min;

	min = setmin(used_info);
	for (i=setmax(used_info); i>=min; i--)
		if (setin(used_info,i))
		{
			TEXTP t_ptr = get_text(i);

/*			if (!t_ptr->namenlos && filematch(t_ptr->filename, name))*/
			if (!t_ptr->namenlos && strcmp(t_ptr->filename, name)==0)
				return i;
		}
	return -1;
}

LOCAL WORD col_lz2tab(ZEILEP col, UBYTE *t, WORD tab_size)
{
	UBYTE		*str, c;
	WORD		i, tabH, lz, len;
	BOOLEAN	changes;

	str = TEXT(col);
	changes = FALSE;
	tabH = tab_size;
	lz = 0;
	len = 0;
	for (i=col->len; (--i)>=0; )
	{
		c = *str++;
		if (c==' ')
		{
			if ((--tabH)==0)
			{
				if (lz>0)			/* Leerzeichen ersetzen */
				{
					c = '\t';
					t -= lz;
					len -= lz;
					changes = TRUE;
				}
				tabH = tab_size;
				lz = 0;
			}
			else
				lz++;
		}
		else
		{
			lz = 0;
			if ((--tabH)==0) tabH = tab_size;
		}
		*t++ = c;
		len++;
	}
	*t = EOS;
	if (changes)
		return (len);
	return (-1);
}

LOCAL VOID lz2tab(TEXTP t_ptr)
{
	ZEILEP 	lauf;
	WORD		x, i, tabsize;
	UBYTE		str[MAX_LINE_LEN + 1];

	set_mouse(HOURGLASS, NULL);
	tabsize = t_ptr->loc_opt->tabsize;
	x = BildPos(t_ptr->xpos,t_ptr->cursor_line,TRUE,tabsize);
	lauf = FIRST(&t_ptr->text);
	while (!IS_TAIL(lauf))
	{
		i = col_lz2tab(lauf, str, tabsize);
		if (i != -1)									/* Zeile verndert */
		{
			REALLOC (&lauf, 0, i-lauf->len);
			memcpy(TEXT(lauf), str, (short) strlen(str));
			t_ptr->moved++;
		}
		NEXT(lauf);
	}
	t_ptr->cursor_line = get_line(&t_ptr->text,t_ptr->ypos);
	t_ptr->xpos = InterPos(x,t_ptr->cursor_line,TRUE,tabsize);
	make_chg(t_ptr->link,POS_CHANGE,0); 	/* immer: Damit Infozeile einen '*' bekommt */
	restore_edit();
	set_mouse(ARROW, NULL);
}

LOCAL WORD col_tab2lz(ZEILEP col, UBYTE *t, WORD tab_size)
{
	BOOLEAN	with_tab = FALSE;
	WORD		tabH, len, i;
	UBYTE		*str, c;

	str = TEXT(col);
	tabH = tab_size;
	for (i = col->len,len = 0; (--i) >= 0 && (len < (MAX_LINE_LEN+1)); )
	{
		c = *str++;
		if (c == '\t')
		{
			with_tab = TRUE;
			len += tabH;
			if (len > (MAX_LINE_LEN+1))
				tabH -= (len - (MAX_LINE_LEN+1));
			do
			{
				*t++ = ' ';
			}
			while (--tabH);
			tabH = tab_size;
		}
		else
		{
			*t++ = c;
			if ((--tabH)==0)
				tabH = tab_size;
			len++;
		}
	}
	*t = EOS;
	if (with_tab)
		return(len);
	else
		return(-1);
}

LOCAL VOID tab2lz(TEXTP t_ptr)
{
	ZEILEP 	lauf;
	WORD		i, x, tabsize;
	UBYTE		str[MAX_LINE_LEN + 1];

	set_mouse(HOURGLASS, NULL);
	tabsize = t_ptr->loc_opt->tabsize;
	x = BildPos(t_ptr->xpos,t_ptr->cursor_line,TRUE,tabsize);
	lauf = FIRST(&t_ptr->text);
	while (!IS_TAIL(lauf))
	{
		i = col_tab2lz (lauf,str,tabsize);
		if (i != -1)									/* Zeile verndert */
		{
			REALLOC (&lauf, 0, i-lauf->len);
			memcpy(TEXT(lauf), str, (short)strlen(str));
			t_ptr->moved++;
		}
		NEXT(lauf);
	}
	t_ptr->cursor_line = get_line(&t_ptr->text,t_ptr->ypos);
	t_ptr->xpos = InterPos(x,t_ptr->cursor_line,TRUE,tabsize);
	make_chg(t_ptr->link,POS_CHANGE,0); 	/* immer: Damit Infozeile einen '*' bekommt */
	restore_edit();
	set_mouse(ARROW, NULL);
}

LOCAL VOID goto_line(TEXTP t_ptr, WORD x, LONG y)
{
	if (x < 0)
		x = 0;
	if (y < 0)
		y = 0;
	if (y >= t_ptr->text.lines)
		y = t_ptr->text.lines - 1L;
	t_ptr->cursor_line = get_line(&t_ptr->text, y);
	t_ptr->ypos = y;
	t_ptr->xpos = InterPos(x,t_ptr->cursor_line,t_ptr->loc_opt->tab,t_ptr->loc_opt->tabsize);
	make_chg(t_ptr->link,POS_CHANGE, 0);
}

LOCAL VOID make_undo(TEXTP t_ptr)
{
	WORD undo;

	undo = get_undo();
	if (undo == NO_UNDO) 
		return;

	/*
	 * Vorher an undo_pos springen
	 * Weil sonst u.U. restore zu schwierig
	 * Wird auch von do_undo_col vorausgesetzt
	*/
	t_ptr->cursor_line = get_line(&t_ptr->text,undo_y);
	t_ptr->ypos = undo_y;
	t_ptr->xpos = 0;
	make_chg(t_ptr->link,POS_CHANGE,0);
	restore_edit();

	do
	{
		if (undo == COL_ANDERS)
		{
			do_undo_col(t_ptr,undo);
			restore_edit();
		}
		else
		{
			blk_undo(t_ptr,undo);
			restore_edit();
		}
		undo = get_undo();
	}
	while (undo != NO_UNDO);
}

/***************************************************************************/

LOCAL VOID do_absatz(WINDOWP window)
{
	if (window->flags & WI_TEXT) 					/* Text-Fenster */
	{
		TEXTP	t_ptr = get_text(window->handle);
		
		make_absatz(t_ptr);
		get_longestline(t_ptr);
		if (window->doc.w != t_ptr->max_line->exp_len)
		{
			window->doc.w = t_ptr->max_line->exp_len;
			set_sliders(window, HORIZONTAL, SLPOS+SLSIZE);
		}	
		redraw_window(window, &window->work);
	}
}


/*
 * Es wurde Zeilenumbruch ein oder ausgeschaltet und/oder Tab gendert 
*/
VOID absatz_edit(VOID)
{
	do_all_window(CLASS_EDIT, do_absatz);
}


/***************************************************************************/

LOCAL VOID chg_edit_name(WORD icon)
{
	WINDOWP	window = get_window(icon);
	TEXTP 	t_ptr = get_text(icon);

	set_wtitle(window, t_ptr->filename);
}

/***************************************************************************/
/* Anlegen einer neuen Textdatei 														*/
/***************************************************************************/

WORD new_edit(VOID)
{
	WORD	icon;
	TEXTP t_ptr;

	icon = crt_new_text("");
	if (icon < 0)
	{
		note(1,NOTEXT);
		return -1;
	}
	t_ptr = get_text(icon);
	if (t_ptr->loc_opt->umbrechen)
		make_absatz(t_ptr);
	if (do_icon(icon,DO_OPEN) < 0)
	{
		note(1, NOWINDOW);
		Icon_edit(icon, DO_DELETE);
		icon = -3;
	}
	return icon;
} /* new_edit */

/***************************************************************************/

GLOBAL WORD load_edit(UBYTE *name, BOOLEAN bin)
/* return: <=0 wurde nicht geladen */
/* 		  =0	weitere Texte versuchen sinnvoll */
/* 		  <0	weiter Texte versuchen nicht sinnvoll */
{
	WINDOWP 	window;
	TEXTP 	t_ptr;
	FILENAME	datei;
	PATH		path;
	WORD		err, icon;

	if (!caseSens(name, NULL))
		str_upper(name);

	set_fsel_path(name);
	file_splitt(name, path, datei);
	if ((icon = still_loaded(name)) > 0)				/* schon geladen */
	{
		if (do_icon(icon, DO_OPEN) < 0)					/* nur Fenster auf */
			note(1, NOWINDOW);
		return icon;
	}
	icon = crt_new_text(name); 							/* neuen Text anlegen */
	if (icon < 0)
	{
		note(1, NOTEXT);
		return -1;												/* hat keinen Zweck mehr */
	}
	t_ptr = get_text(icon);

	if (bin)
	{
		t_ptr->text.ending = binmode;
		t_ptr->text.max_line_len = bin_line_len;
	}
	else
		t_ptr->text.max_line_len = MAX_LINE_LEN;

	if ((err = load(t_ptr, TRUE)) == -33)				/* File not Found */
	{
		if (path_exist(path))
		{
			if (fnote(1, NEWTEXT, datei) == 2)			/* neue Datei anlegen */
			{
				Icon_edit(icon, DO_DELETE);
				return 0;										/* naechsten versuche */
			}
		}
		else
		{
			fnote(1, READERR, datei);
			Icon_edit(icon, DO_DELETE);
			return 0;											/* naechsten versuchen */
		}
	}
	else if (err)												/* anderer Fehler */
	{
		fnote(1, READERR, datei);
		Icon_edit(icon, DO_DELETE);
		return 0;
	}
	if (t_ptr->loc_opt->umbrechen)
	{
		make_absatz(t_ptr);
		if (t_ptr->loc_opt->format_by_load)
			total_format(t_ptr);
	}
	window = get_window(icon);
	window->doc.x = 0;
	window->doc.y = 0;
	window->doc.w = get_longestline(t_ptr);
	window->doc.h = t_ptr->text.lines;
	if (do_icon(icon, DO_OPEN) < 0)
	{
		note(1, NOWINDOW);
		Icon_edit(icon, DO_DELETE);
		icon = -2;
	}
	if (t_ptr->moved) 										
	{
		if (t_ptr->loc_opt->umbrechen)					/* format_by_load */
			set_info(t_ptr, STRING(UMBRUCHSTR));
		else														/*	Nullbytes */
		{
			make_chg(t_ptr->link,TOTAL_CHANGE,0);
			set_info(t_ptr, STRING(NULLBYTESTR));
		}
		change_window(window, t_ptr->filename, TRUE);
		restore_edit();
		mybeep();
	}

	if (find_poslist(lastpos_list, name, &desire_x, &desire_y) != NULL)
		Icon_edit(icon, DO_GOTO);
	else
		insert_poslist(&lastpos_list, name, 0, 0);

	return icon;
}

/***************************************************************************/

LOCAL VOID print_edit (TEXTP t_ptr)
{
	FILENAME name;

	if (t_ptr->namenlos)
		strcpy(name, t_ptr->filename);
	else
		file_name(t_ptr->filename, name, FALSE);
	if (prn_options(t_ptr->block))
	{
		if (print_block)
			blk_drucken(name, t_ptr);
		else
			txt_drucken(name, t_ptr);
	}
} /* print_edit */


GLOBAL VOID close_edit(UBYTE *file, WORD flag)
{
	WORD i, min;

	min = setmin(used_info);
	for (i = setmax(used_info); i >= min; i--)
		if (setin(used_info, i))
		{
			TEXTP t_ptr = get_text(i);

			if (filematch(t_ptr->filename, file))
			{
				switch (flag)
				{
					case 0 :		/* sichern ohne schlieen */
						do_icon(i, DO_SAVE);
						break;
					case 1 :		/* sichern und schlieen */
						do_icon(i, DO_DELETE);
						break;
					case 2 :		/* schlieen ohne sichern */
						t_ptr->moved = 0;
						do_icon(i, DO_DELETE);
						break;
					default:
						Debug("qed: close_edit: Unknown SE_CLOSE Flag %d\n", flag);
						break;
				}
			}
		}
}


LOCAL BOOLEAN delete_edit(WORD icon, TEXTP t_ptr)
{
	WORD	antw;
	FILENAME	name;

	if (t_ptr->moved != 0)
	{
		if (quick_close)
			antw = 1;
		else
		{
			if (t_ptr->namenlos)
				strcpy(name, t_ptr->filename);
			else
				file_name(t_ptr->filename, name, FALSE);
			antw = fnote(1, MOVED, name);
		}
		if (antw == 1)
		{
			if (do_icon(icon,DO_SAVE) < 0)
				return (FALSE);
		}
		if (antw == 3)
			return(FALSE);
	}
	return (TRUE);
}

/***************************************************************************/
/* Fenster angeclickt																		*/
/***************************************************************************/
LOCAL VOID set_cursor(WINDOWP window, WORD mx, WORD my)
{
	TEXTP 	t_ptr = get_text(window->handle);
	WORD		x;
	LONG		y;
	ZEILEP	col;

	y = (my - window->work.g_y);
	if (y < 0)
		y -= gl_hchar; 	/* wg. Rundung */
	y /= gl_hchar;
	y += window->doc.y;
	if (y >= t_ptr->text.lines)
		y = t_ptr->text.lines-1;
	else if (y < 0)
		y = 0;
	col = get_line(&t_ptr->text, y);

	t_ptr->ypos = y;
	t_ptr->cursor_line = col;
	if (winFont.prop)
	{
		WORD	i, x_soll, s, e, xl; 

		x_soll = (mx - window->work.g_x) + ((short) window->doc.x * gl_wchar);

		/* Zur groben Positionierung machen wir "Halbierungs-Algorithmus" */
		s = 0;
		e = col->len;
		xl = -1;
		while (TRUE)
		{
			x = s + ((e - s) / 2);
			if (x == xl)
				break;
			t_ptr->xpos = x;
			i = cursor_xpos(t_ptr, t_ptr->xpos);
			if (i > x_soll)
				e = x;			/* in linker Hlfte */
			else
				s = x;			/* in rechter Hlfte */
			xl = x;				
		}
		/* jetzt Fein-Positionierung zeichenweise heranbewegen */
		for (x = s; x <= e; x++)
		{
			t_ptr->xpos = x;
			i = cursor_xpos(t_ptr, t_ptr->xpos);
			if (i > x_soll) 
				break;
		}
		x--;
	}
	else
	{
		x = mx - window->work.g_x;
		if (x > 0)
		{
			x /= gl_wchar;
			x += (short) window->doc.x;
		}
		else if (window->doc.x>0)
			x = (short) window->doc.x-1;
		else
			x = 0;
		x = InterPos(x,col,t_ptr->loc_opt->tab,t_ptr->loc_opt->tabsize);
	}
	t_ptr->xpos = x;

	y -= window->doc.y;
	if (y > 0)
	{
		if (y > window->w_height)
			make_chg(t_ptr->link,MOVE_UP, y-window->w_height);
	}
	else
		make_chg(t_ptr->link,MOVE_DOWN, -y);
	make_chg(t_ptr->link,POS_CHANGE, 0);
}

#define LINE_MODE		1
#define WORD_MODE		2
#define KEY_MODE		3
#define BRACE_MODE	4

LOCAL VOID wi_click(WINDOWP window, MOUSEDATA *mouse)
{
	WORD		event, mode;
	TEXTP 	t_ptr = get_text(window->handle);
	GRECT		*s = &window->work;
	KEYDATA	key;
	
	/* Infomeldung lschen */
	clear_info(t_ptr);

	if (mouse->bstate & 2) 				/* Rechtsclick */
	{
		if (strlen(error[0]) > 0)
		{
			blk_demark(t_ptr);
			set_cursor(window, mouse->x, mouse->y);
			restore_edit();
			handle_error(t_ptr);
		}
		return;								/* und wech... */
	}

	if (!inside(mouse->x, mouse->y, s))
		return;
	t_ptr->blk_mark_mode = FALSE;
	unclick_window();
	if (mouse->breturn == 2)				/* Doppelklick */
	{
		blk_demark(t_ptr);
		set_cursor(window, mouse->x, mouse->y);
		restore_edit();
		if (mouse->kstate & (K_RSHIFT|K_LSHIFT) ||				/* Ganze Zeile markieren */
			 t_ptr->xpos==t_ptr->cursor_line->len)
		{
			t_ptr->xpos = 0;
			blk_mark(t_ptr, 0);
			if (IS_LAST(t_ptr->cursor_line))
				t_ptr->xpos = t_ptr->cursor_line->len;
			else
			{
				NEXT(t_ptr->cursor_line);
				t_ptr->ypos++;
			}
			blk_mark(t_ptr, 1);
			restore_edit();
			mode = LINE_MODE;
		}
		else if (blk_mark_brace(t_ptr))							/* Klammer-Selektion */
		{
			restore_edit();
			mode = BRACE_MODE;
		}
		else																/* wortweise */
		{
			blk_mark_word(t_ptr);
			mode = WORD_MODE;
		}
	}
	else																	/* Einfachklick */
	{
		if (mouse->kstate & (K_RSHIFT|K_LSHIFT))
		{
			if (!t_ptr->block)
				blk_mark(t_ptr,0);									/* Anfang = alte Cursorpos */
			set_cursor(window, mouse->x, mouse->y);
			blk_mark(t_ptr, 1);
			restore_edit();
		}
		else
		{
			blk_demark(t_ptr);
			set_cursor(window, mouse->x, mouse->y);
			blk_mark(t_ptr, 0);
			restore_edit();
		}
		mode = KEY_MODE;
	}
	graf_mkstate((EVNTDATA*)mouse);
	if (mouse->bstate & 1)							/* immernoch gedrckt */
	{
		set_mouse(POINT_HAND, NULL);
		wind_update(BEG_MCTRL);						/* Mauskontrolle bernehmen */
		while(TRUE)
		{
			event = qed_evnt_multi((MU_BUTTON | MU_M1 | MU_M2),
										  1, 0x01, 0x00,
										  TRUE, mouse->x, mouse->y, 1, 1,
										  TRUE, s->g_x, s->g_y, s->g_w, s->g_h,
										  NULL,
										  0L,
										  mouse,
										  &key);

			if (event & MU_BUTTON) 
				break;
			if (event & (MU_M1 | MU_M2))
			{
				set_cursor(window, mouse->x, mouse->y);
				if (mode == WORD_MODE)
				{
					LONG	y;
					WORD	x, pos,len;
					UBYTE	*str;

					pos = t_ptr->xpos;
					str = TEXT(t_ptr->cursor_line) + pos;
					len = t_ptr->cursor_line->len;
					get_blk_mark(t_ptr, &y, &x);
					if (t_ptr->ypos > y || t_ptr->xpos > x) 		/* nach rechts */
					{
						while(pos<=len && setin(t_ptr->loc_opt->wort_set,*str))
						{
							pos++;
							str++;
						}
					}
					else													/* nach links */
					{
						while(pos>=0 && setin(t_ptr->loc_opt->wort_set,*str))
						{
							pos--;
							str--;
						}
						str++; pos++;
					}
					t_ptr->xpos = pos;
				}
				else if (mode == LINE_MODE)
				{
					LONG	y;
					WORD	x;

					get_blk_mark(t_ptr, &y, &x);
					t_ptr->xpos = 0;
					if (y == t_ptr->ypos && !IS_LAST(t_ptr->cursor_line))
					{
						NEXT(t_ptr->cursor_line);
						t_ptr->ypos++;
					}
				}
				blk_mark(t_ptr, 1);
				restore_edit();
			}
		}
		wind_update(END_MCTRL);						/* Mauskontrolle wieder abgeben */
		set_mouse(ARROW, NULL);
	}
}


LOCAL BOOLEAN wi_key (WINDOWP window, KEYDATA *key)
{
	TEXTP t_ptr = get_text(window->handle);

	/* Infomeldung lschen */
	clear_info(t_ptr);

	if (edit_key(t_ptr, window, key))
	{
		restore_edit();
		return TRUE;
	}
	return FALSE;
}


LOCAL VOID wi_draw(WINDOWP window, CONST GRECT *d)
{
	TEXTP t_ptr = get_text(window->handle);

	set_clip(TRUE, d);
	if (d->g_x == window->work.g_x && d->g_w == window->work.g_w)
	{
		if (d->g_y == window->work.g_y + window->work.g_h - window->yfac &&
			 d->g_h == window->yfac)
		{
			/* Letzte Zeile */
			line_out(window, t_ptr, window->w_height - 1);
		}
		else if (d->g_y == window->work.g_y && d->g_h == window->yfac)
		{
			/* Erste Zeile */
			line_out(window, t_ptr, 0);
		}
		else
			bild_out(window, t_ptr);
	}
	else
		bild_out(window,t_ptr);
}


LOCAL VOID wi_top(WINDOWP window)
{
	/* Krzel/Schreibschutz ndern */
	do_icon(window->handle, DO_UPDATE);
}

LOCAL	VOID wi_iconify(WINDOWP window)
{
	TEXTP 	t_ptr = get_text(window->handle);
	FILENAME	short_name;

	make_shortpath(t_ptr->filename, short_name, 8);
	set_wtitle(window, short_name);
}

LOCAL	VOID wi_uniconify(WINDOWP window)
{
	TEXTP t_ptr = get_text(window->handle);

	set_wtitle(window, t_ptr->filename);
}

/***************************************************************************/
/* Operation vorhanden ?																	*/
/***************************************************************************/

LOCAL VOID icon_exist(WORD icon, SET actions)
{
	TEXTP		t_ptr = get_text(icon);
	WINDOWP	window = get_window(icon);

	setclr(actions);

	if ((window->flags & WI_ICONIFIED) || (window->flags & WI_SHADED))
	{
		/* Einzige mgliche Aktion: */
		setincl(actions, DO_DELETE);
		return;
	}

	if (any_undo())
		setincl(actions, DO_UNDO);
	if (t_ptr->block)
	{
		setincl(actions, DO_CUT);
		setincl(actions, DO_COPY);
		setincl(actions, DO_LEFT);
		setincl(actions, DO_RIGHT);
		setincl(actions, DO_ONE_LEFT);
		setincl(actions, DO_ONE_RIGHT);
		setincl(actions, DO_BIG2SMALL);
		setincl(actions, DO_SMALL2BIG);
		setincl(actions, DO_CHNG_SMBG);
		setincl(actions, DO_CAPS);
		setincl(actions, DO_SORT);
	}
	else
	{
		setincl(actions, DO_LINECOPY);
		setincl(actions, DO_SWAPCHAR);
	}
	if (t_ptr->loc_opt->tab)
	{
		setincl(actions, DO_TAB2LZ);
		setincl(actions, DO_LZ2TAB);
	}
	if (t_ptr->loc_opt->umbrechen)
		setincl(actions, DO_FORMAT);
	else
		setincl(actions, DO_STRIPLINES);
	if (window->flags & WI_OPEN)
		setincl(actions, DO_CLOSE);
	setincl(actions, DO_DELETE);
	setincl(actions, DO_PASTE);
	setincl(actions, DO_SELALL);
	setincl(actions, DO_OPEN);
	setincl(actions, DO_INFO);
	setincl(actions, DO_HELP);
	setincl(actions, DO_PRINT);
	if (!t_ptr->namenlos)
		setincl(actions,DO_ABAND);
	setincl(actions, DO_SAVE);
	setincl(actions, DO_SAVENEW);
	setincl(actions, DO_FIND);
	setincl(actions, DO_FINDNEXT);
	setincl(actions, DO_GOTO);
	setincl(actions, DO_ADD);
	setincl(actions, DO_UPDATE);
	setincl(actions, DO_ZEICHTAB);
	setincl(actions, DO_UMLAUT);
	if (t_ptr->moved)
		setincl(actions, DO_AUTOSAVE);
	setincl(actions, DO_FEHLER);
}

/***************************************************************************/
/* Operation testen																			*/
/***************************************************************************/

LOCAL BOOLEAN icon_test(WORD icon, WORD action)
{
	BOOLEAN	erg;
	TEXTP 	t_ptr = get_text(icon);
	FILENAME	name;

	switch(action)
	{
		case DO_UNDO	:
			erg = any_undo();
			break;
		case DO_CUT 	:
			erg = t_ptr->block;
 			break;
		case DO_COPY	:
			erg = t_ptr->block;
			break;
		case DO_LINECOPY:
			erg = !(t_ptr->block);
			break;
		case DO_PASTE	:
			erg = TRUE;
			break;
		case DO_SELALL :
			erg = TRUE;
			break;
		case DO_CLOSE	:
		case DO_DELETE	:
			erg = delete_edit(icon, t_ptr);
			break;
		case DO_OPEN	:
			erg = TRUE;
			break;
		case DO_INFO	:
			erg = TRUE;
			break;
		case DO_HELP	:
			erg = TRUE;
			break;
		case DO_LEFT	:
			erg = t_ptr->block;
			break;
		case DO_RIGHT	:
			erg = t_ptr->block;
			break;
		case DO_ONE_LEFT	:
		case DO_ONE_RIGHT	:
		case DO_BIG2SMALL	:
		case DO_SMALL2BIG	:
		case DO_CHNG_SMBG	:
		case DO_CAPS		:
		case DO_SORT 		:
			erg = t_ptr->block;
			break;
		case DO_FORMAT :
			erg = t_ptr->loc_opt->umbrechen;
			break;
		case DO_PRINT	:
			erg = TRUE;
			break;
		case DO_ABAND	:
			if (t_ptr->namenlos)
				erg = FALSE;
			else
			{
				erg = TRUE;
				if (!ist_leer(&t_ptr->text) && t_ptr->moved!=0)
				{
					if (t_ptr->namenlos)
						strcpy(name, t_ptr->filename);
					else
						file_name(t_ptr->filename, name, FALSE);
					erg = (fnote(1,ABANDON,name)==1);
				}
			}
			break;
		case DO_SAVE	:
			erg = TRUE;
			break;
		case DO_SAVENEW:
			erg = TRUE;
			break;
		case DO_FIND	:
			find_erg = find_dial(FALSE);
			erg = (find_erg!=0);
			break;
		case DO_FINDNEXT:
			erg = TRUE;
			break;
		case DO_ADD 	:
			erg = TRUE;
			break;
		case DO_GOTO	:
			erg = goto_line_dial();
			break;
		case DO_STRIPLINES:
			erg = !t_ptr->loc_opt->umbrechen;
			break;
		case DO_TAB2LZ :
			erg = t_ptr->loc_opt->tab;
			break;
		case DO_LZ2TAB :
			erg = t_ptr->loc_opt->tab;
			break;
		case DO_UPDATE	:
			erg = TRUE;
			break;
		case DO_ZEICHTAB:
			ascii_wert = ascii_table(winFont.id, 13);
			erg = (ascii_wert != -1);
			break;
		case DO_UMLAUT:
			erg = umlaut_dial();
			break;
		case DO_SWAPCHAR:
			erg = !t_ptr->block;
			break;
		case DO_AUTOSAVE :
			if (as_text && t_ptr->moved)
			{
				LONG	min;
				WORD	btn;

				min = (short)((time(NULL) - t_ptr->asave) / 60L);
				if (min >= as_text_min)
				{
					if (as_text_ask)				/* Nachfrage ? */
					{
						FILENAME		name;

						if (t_ptr->namenlos)
							strcpy(name, t_ptr->filename);
						else
							file_name(t_ptr->filename, name, FALSE);
						mybeep();
						btn = fnote(2, ASAVEASK, name);
						if (btn == 1)
							as_text = FALSE;
					}
					else
						btn = 2;

					t_ptr->asave = time(NULL);
					erg = (btn == 2);
				}
				else
					erg = FALSE;
			}
			else
			{
				t_ptr->asave = time(NULL);
				erg = FALSE;
			}
			break;
		case DO_FEHLER :
			erg = TRUE;
			break;
		default	:
			erg = FALSE;
	}
	return erg;
}

/***************************************************************************/
/* Operation durchfhren																	*/
/***************************************************************************/

LOCAL WORD icon_edit(WORD icon, WORD action)
{
	PATH		name;
	TEXTP		t_ptr = get_text(icon);
	RING		r;
	WINDOWP	window;
	WORD		erg;
	BOOLEAN	ok, bin;
	FSEL		fsel;
	ZEILEP	lauf;

	window = get_window(icon);
	erg = 0;
	switch(action)
	{
		case DO_UNDO	:
			t_ptr->blk_mark_mode = FALSE;
			blk_demark(t_ptr);
			make_undo(t_ptr);
			erg = 1;
			break;
		case DO_CUT 	:
			t_ptr->blk_mark_mode = FALSE;
			blk_cut(t_ptr,global_shift);
			restore_edit();
			erg = 1;
			break;
		case DO_COPY	:
			t_ptr->blk_mark_mode = FALSE;
			blk_copy(t_ptr,global_shift);
			restore_edit();
			erg = 1;
			break;
		case DO_LINECOPY:
			line_copy(t_ptr, global_shift);
			restore_edit();
			erg = 1;
			break;
		case DO_PASTE	:
			t_ptr->blk_mark_mode = FALSE;
			load_clip();
			if (!ist_leer(&clip_text))
			{
				blk_paste(t_ptr, &clip_text);
				if (t_ptr->loc_opt->umbrechen && t_ptr->loc_opt->format_by_paste)
					format(t_ptr);
				restore_edit();
			}
			erg = 1;
			break;
		case DO_SELALL :
			t_ptr->blk_mark_mode = FALSE;
			blk_mark_all(t_ptr);
			restore_edit();
			erg = 1;
			break;
		case DO_CLOSE	:
		case DO_DELETE	:
			t_ptr->blk_mark_mode = FALSE;
			destruct(icon);
			erg = 1;
			break;
		case DO_OPEN	:
			t_ptr->blk_mark_mode = FALSE;
			if (!open_edit(icon))
				erg = -1;
			else
				erg = 1;
			break;
		case DO_INFO	:
			t_ptr->blk_mark_mode = FALSE;
			if (t_ptr->block)
				block_info(t_ptr);
			else
				info_edit(icon);
			erg = 1;
			break;
		case DO_HELP	:
			t_ptr->blk_mark_mode = FALSE;
			if (!t_ptr->block)
				blk_mark_word(t_ptr);
			if (t_ptr->block)
			{
				block_copy(t_ptr, &r);
				if (strlen(TEXT(FIRST(&r))) > 0)
					erg = call_help(TEXT(FIRST(&r)));
				else
					erg = call_hyp("main");
				kill_textring(&r);
			}
			else
				erg = call_hyp("main");
			break;
		case DO_LEFT	:
			t_ptr->blk_mark_mode = FALSE;
			blk_left(t_ptr, FALSE);
			restore_edit();
			erg = 1;
			break;
		case DO_ONE_LEFT	:
			t_ptr->blk_mark_mode = FALSE;
			blk_left(t_ptr, TRUE);
			restore_edit();
			erg = 1;
			break;
		case DO_RIGHT	:
			t_ptr->blk_mark_mode = FALSE;
			blk_right(t_ptr, FALSE);
			restore_edit();
			erg = 1;
			break;
		case DO_ONE_RIGHT	:
			t_ptr->blk_mark_mode = FALSE;
			blk_right(t_ptr, TRUE);
			restore_edit();
			erg = 1;
			break;
		case DO_SMALL2BIG	:
			t_ptr->blk_mark_mode = FALSE;
			blk_upplow(t_ptr, BLK_UPPER);
			restore_edit();
			erg = 1;
			break;
		case DO_BIG2SMALL	:
			t_ptr->blk_mark_mode = FALSE;
			blk_upplow(t_ptr, BLK_LOWER);
			restore_edit();
			erg = 1;
			break;
		case DO_CHNG_SMBG	:
			t_ptr->blk_mark_mode = FALSE;
			blk_upplow(t_ptr, BLK_CH_UPLO);
			restore_edit();
			erg = 1;
			break;
		case DO_CAPS	:
			t_ptr->blk_mark_mode = FALSE;
			blk_upplow(t_ptr, BLK_CAPS);
			restore_edit();
			erg = 1;
			break;
		case DO_FORMAT :
			t_ptr->blk_mark_mode = FALSE;
			blk_demark(t_ptr);
			if (global_shift)
				total_format(t_ptr);
			else
				format(t_ptr);
			restore_edit();
			erg = 1;
			break;
		case DO_PRINT	:
			t_ptr->blk_mark_mode = FALSE;
			print_edit(t_ptr);
			erg = 1;
			break;
		case DO_ABAND	:
abandon:	strcpy(name, t_ptr->filename);
			bin = (t_ptr->text.ending == binmode);
			destruct(icon);
			icon = load_edit(name, bin);
			if (icon > 0)
			{
				t_ptr = get_text(icon);
				erg = -1;
				if (t_ptr != NULL)
				{
					if (open_edit(icon))
					{
						memset(msgbuff, 0, (WORD) sizeof(msgbuff));
						msgbuff[0] = WM_TOPPED;
						msgbuff[3] = window->handle;
						send_msg(gl_apid);
						erg = 1;
					}
				}
			}
			clr_undo();
			break;
		case DO_SAVE	:
			if (!t_ptr->namenlos)
			{
				t_ptr->blk_mark_mode = FALSE;
				if (t_ptr->loc_opt->umbrechen)
					save_absatz(t_ptr);					/* Zeilenende korrigieren */
				if (save(t_ptr)<0)
					erg = -1;
				else
					erg = 1;

				make_chg(icon, WT_CHANGE, 0);			/* nur Fenstertitel schreiben */
				restore_edit();
				break;
			}
			/* Bei Namenlos zu DO_SAVENEW */
		case DO_SAVENEW:
			t_ptr->blk_mark_mode = FALSE;
			strcpy(fsel.suffix,"*.*");
			strcpy(fsel.name,"");
			if (t_ptr->block)
			{
				if (save_new(name,&fsel, STRING(SAVEBLKSTR)))
				{
					TEXTP temp_ptr;

					temp_ptr = new_text(TEMP_LINK);
					if (t_ptr->loc_opt->umbrechen)	/* Zeilenende korrigieren */
						save_absatz(t_ptr);
					block_copy(t_ptr,&temp_ptr->text);	/* Block rauskopieren */
					temp_ptr->cursor_line = FIRST(&t_ptr->text);
					temp_ptr->loc_opt = t_ptr->loc_opt;
					erg = save_as(temp_ptr,name);
					destruct_text(temp_ptr);
					if (erg==0)
						erg = 1;
				}
			}
			else
			{
				if (save_new(name,&fsel, STRING(SAVEASSTR)))
				{
					BOOLEAN umb_old = t_ptr->loc_opt->umbrechen;
					
					if (t_ptr->loc_opt->umbrechen)	/* Zeilenende korrigieren */
						save_absatz(t_ptr);
					if ((erg=save_as(t_ptr,name))==0)
					{
						if (t_ptr->namenlos || note(1,GETNAME)==1)
						{
							/* OLGA informieren */
							do_OLGA(OLGA_RENAME, t_ptr->filename, name);
							do_OLGA(OLGA_UPDATE, name, NULL);

							set_text_name(t_ptr, name, FALSE);
							chg_edit_name(icon);
							t_ptr->moved = 0;
							t_ptr->file_date_time = file_time(name,NULL,NULL);
							t_ptr->readonly = file_readonly(name);
						}
						make_chg(icon, TOTAL_CHANGE, 0); /* ggf. neue lok. Optionen! */
						make_chg(icon, POS_CHANGE, 0);	/* Headline schreiben */
						ch_kurzel(t_ptr->loc_opt->kurzel, FALSE);
						if (umb_old != t_ptr->loc_opt->umbrechen)
							make_absatz(t_ptr);
						restore_edit();
						if (erg==0)
							erg = 1;
					}
				}
			}
			break;
		case DO_FIND	:
			t_ptr->blk_mark_mode = FALSE;
			if (find_erg == 1)
			{
				if (start_find(t_ptr,FALSE)==0)
				{
					mybeep();
					end_play();
				}
			}
			else
			{
				if (find_erg == 2)
				{
					if (start_replace(t_ptr, FALSE) == 0)
					{
						mybeep();
						end_play();
					}
				}
			}
			erg = 1;
			break;
		case DO_FINDNEXT:
			t_ptr->blk_mark_mode = FALSE;
			if (do_next(t_ptr) != 1)
			{
					mybeep();
					end_play();
			}
			erg = 1;
			break;
		case DO_GOTO	:
			t_ptr->blk_mark_mode = FALSE;
			blk_demark(t_ptr);
			goto_line(t_ptr, desire_x, desire_y);
			restore_edit();
			erg = 1;
			break;
		case DO_STRIPLINES:
			t_ptr->blk_mark_mode = FALSE;
			blk_demark(t_ptr);
			set_mouse(HOURGLASS, NULL);
			if (strip_endings(t_ptr))
			{
				t_ptr->max_line = NULL;
				lauf = t_ptr->cursor_line = get_line(&t_ptr->text, t_ptr->ypos);
				if (t_ptr->xpos > lauf->len)
					t_ptr->xpos = lauf->len;
				make_chg(t_ptr->link, POS_CHANGE, 0);		/* '*' in Titel */
			}
			set_mouse(ARROW, NULL);
			restore_edit();
			erg = 1;
			break;
		case DO_TAB2LZ :
			t_ptr->blk_mark_mode = FALSE;
			blk_demark(t_ptr);
			tab2lz(t_ptr);
			erg = 1;
			break;
		case DO_LZ2TAB :
			t_ptr->blk_mark_mode = FALSE;
			blk_demark(t_ptr);
			lz2tab(t_ptr);
			erg = 1;
			break;
		case DO_ADD 	:
			strcpy(fsel.suffix,"*.*");
			strcpy(fsel.name,"");
			if (global_shift)
				ok = select_file(&fsel, name, STRING(INSNAMESTR));
			else
				ok = select_file(&fsel, name, STRING(MERGESTR));
			if (ok)
			{
				if (global_shift)				/* Dateinamen einfgen */
				{
					RING	temp_ring;
					ZEILEP	col;

					init_textring(&temp_ring);
					col = new_col(name, (short)strlen(name));
					col_insert(&(temp_ring.head), col);
					blk_paste(t_ptr, &temp_ring);
					restore_edit();
					kill_textring(&temp_ring);
				}
				else								/* Dateiinhalt einfgen */
				{
					TEXTP temp_ptr = new_text(TEMP_LINK);

					if (temp_ptr!=NULL)
					{
						set_text_name(temp_ptr, name, FALSE);
						if (!load(temp_ptr, FALSE))
						{
							if (t_ptr->loc_opt->umbrechen)
							{
								temp_ptr->loc_opt = t_ptr->loc_opt;
								make_absatz(temp_ptr);
								if (temp_ptr->loc_opt->format_by_load)
									total_format(temp_ptr);
							}
							blk_paste(t_ptr,&(temp_ptr->text));
							restore_edit();
						}
						destruct_text(temp_ptr);
					}
				}
			}
			erg = 1;
			break;
		case DO_UPDATE	:
			/* Schreibschutz oder Datei verndert? */
			if (file_exist(t_ptr->filename))
			{
				BOOLEAN	read_only = file_readonly(t_ptr->filename);

				if (read_only!=t_ptr->readonly)
				{
					t_ptr->readonly = read_only;
					make_chg(icon,POS_CHANGE,0);		/* Headline schreiben */
					restore_edit();
				}
				if (t_ptr->file_date_time!=-1L)
				{
					LONG date_time = file_time(t_ptr->filename,NULL,NULL);

					if (date_time!=t_ptr->file_date_time)
					{
						FILENAME	name;

						file_name(t_ptr->filename, name, FALSE);
						if (fnote(1, MOVED3, name) == 1)
							goto abandon;
						else
							t_ptr->file_date_time = date_time;
					}
				}
			}
			/* Krzel updaten */
			ch_kurzel(t_ptr->loc_opt->kurzel, FALSE);
			erg = 1;
			break;
		case DO_ZEICHTAB:
			if (ascii_wert != -1 )
				char_insert(t_ptr, ascii_wert);
			restore_edit();
			erg = 1;
			break;
		case DO_UMLAUT:
			change_umlaute(t_ptr);
			erg = 1;
			break;
		case DO_SWAPCHAR:
			char_swap(t_ptr);
			restore_edit();
			break;
		case DO_AUTOSAVE:
			icon_edit(icon, DO_SAVE);
			break;
		case DO_FEHLER :
			if (error[0][0] != EOS)
			{
				blk_demark(t_ptr);
				restore_edit();
				handle_error(t_ptr);
			}
			break;
		case DO_SORT :
			sort_block(t_ptr);
			break;
	}
	return erg;
}

/***************************************************************************/
/* Ein Icon wurde auf ein Text-Icon geschoben										*/
/***************************************************************************/

LOCAL BOOLEAN icon_drag (WORD icon, WORD source)
{
	WINDOWP	w = get_window(icon);
	TEXTP 	t_ptr;

 	if ((w->flags & WI_ICONIFIED) || (w->flags & WI_SHADED))
 		return FALSE;
 
	switch (source)
	{
		case DRAGDROP_FILE :
			t_ptr = get_text(icon);
			if (drag_filename[0] != EOS && t_ptr != NULL)
			{
				TEXTP temp_ptr = new_text(TEMP_LINK);

				if (temp_ptr!=NULL)
				{
					set_text_name(temp_ptr, drag_filename, FALSE);
					if (!load(temp_ptr, FALSE))
					{
						blk_paste(t_ptr,&(temp_ptr->text));
						restore_edit();
					}
					destruct_text(temp_ptr);
					return TRUE;
				}
			}
			drag_filename[0] = EOS;
			break;
		case DRAGDROP_PATH :
			t_ptr = get_text(icon);
			if (drag_filename[0] != EOS && t_ptr != NULL)
			{
				if ((t_ptr->cursor_line->len + (short)strlen(drag_filename)) < MAX_LINE_LEN)
				{
					RING		temp_ring;
					ZEILEP	col;
	
					init_textring(&temp_ring);
					col = new_col(drag_filename, (short)strlen(drag_filename));
					col_insert(&(temp_ring.head), col);
					if (drag_data_size > 1)
					{
						/* mehr als ein ARGS -> Zeilenvorschub */
						col = new_col("", 0);
						col_append(&temp_ring, col);
					}
					blk_paste(t_ptr, &temp_ring);
					restore_edit();
					kill_textring(&temp_ring);
					return TRUE;
				}
				else
					fnote(1, TOOLONG, MAX_LINE_LEN);
			}
			drag_filename[0] = EOS;
			break;
		case DRAGDROP_DATA :
			if (drag_data_size > 0 && drag_data != NULL)
			{
				RING		temp_ring;
				ZEILEP	col;
				UBYTE		*p1, *p2, *zeile;
				LONG		delta;
				ZEILEP	lauf;

				t_ptr = get_text(icon);
				init_textring(&temp_ring);
				lauf = &temp_ring.head;
				p1 = drag_data;
				p2 = strchr(p1, '\r');
				if (p2 != NULL)							/* mehrere Zeilen? */
				{
					zeile = (UBYTE *) malloc(MAX_LINE_LEN);
					while (p2 != NULL)
					{
						delta = p2 - p1;
						strncpy(zeile, p1, delta);
						zeile[delta] = EOS;
						col = new_col(zeile, (short)strlen(zeile));
						col_insert(lauf, col);
						NEXT(lauf);
						p1 = p2 + 2;						/* \r\n berspringen */
						p2 = strchr(p1, '\r');
						temp_ring.lines++;
					}
					free(zeile);
				}
				else											/* nur eine Zeile ohne \r\n */
				{
					col = new_col(drag_data, (short)strlen(drag_data));
					col_insert(lauf, col);
				}
				blk_paste(t_ptr, &temp_ring);
				restore_edit();
				kill_textring(&temp_ring);
				free(drag_data);							/* Speicher wieder freigeben */
				drag_data_size = 0L;
				return TRUE;
			}
			break;
		default:
			if (debug)
				Debug("edit.icon_drag(): Unbekannter Mode %d\n", source);
	}
	return FALSE;
}

/***************************************************************************/

VOID blink_edit(VOID)
{
	WINDOWP	window;
	TEXTP 	t_ptr;

	window = winlist_top();
	if (window!=NULL && window->class==CLASS_EDIT)
	{
		t_ptr = get_text(window->handle);
		if (t_ptr->cursor)
		{
			if (t_ptr->blink) 		/* gerade wg. Blinken aus */
				t_ptr->blink = FALSE;
			else
				t_ptr->blink = TRUE;
			cursor(window,t_ptr);
		}
	}
}

VOID onblink_edit(VOID)
{
	WINDOWP	window;
	TEXTP 	t_ptr;

	window = winlist_top();
	if (window!=NULL && window->class==CLASS_EDIT)
	{
		t_ptr = get_text(window->handle);
		if (t_ptr->cursor)
		{
			cursor(window,t_ptr);
			t_ptr->blink = FALSE;
		}
	}
}

VOID offblink_edit(VOID)
{
	WINDOWP	window;
	TEXTP 	t_ptr;

	window = winlist_top();
	if (window!=NULL && window->class==CLASS_EDIT)
	{
		t_ptr = get_text(window->handle);
		if (t_ptr->cursor && !t_ptr->blink)
		{
			cursor(window,t_ptr);
		}
	}
}

/***************************************************************************/
/* Tastenverarbeitung																		*/
/***************************************************************************/
VOID make_chg (WORD link, WORD change, LONG ypos)
{
/*
	SCROLL_UP 		Alles unter der aktuellen Zeile wird hochgescrollt,
						die letzte Zeile wird natrlich neu geschrieben.
		  				(Cntrl-Y, und Delete am Ende der Zeile).
	SCROLL_DOWN		Alles unterhalb der aktuellen Zeile und diese Zeile werden
						nach unten gescrollt, die aktuelle Zeile wird neu
						geschrieben. Ist auch LINE_CHANGE gesetzt wird auch die
						Zeile vor der aktuellen Zeile neu geschrieben.
						(RETURN, last_out_klemm)
	MOVE_UP,
	MOVE_DOWN		Das Fenster wird hoch und runter gescrollt um anz Zeilen
	BLK_CHANGE		Die Blockmarkierung wurde gendert.
	WT_CHANGE		Fenstertitel ('*') lschen (nach save).
*/
	WORD i;

	if (change==TOTAL_CHANGE)
	{
		for (i=chg_anz; (--i)>=0; )			/* unntzte nderung */
			if (chg[i].link==link)
			{
				if (chg[i].c==LINE_CHANGE && chg[i].y>=ypos)
					chg[i].c = NOP_CHANGE;
				else if (chg[i].c==SCROLL_DOWN && chg[i].y>=ypos)
					chg[i].c = NOP_CHANGE;
				else if (chg[i].c==SCROLL_UP && chg[i].y>=ypos)
					chg[i].c = NOP_CHANGE;
				else if (chg[i].c==TOTAL_CHANGE && chg[i].y>=ypos)
				{
					chg[i].y = ypos;
					break;
				}
			}
	}
	if (change==LINE_CHANGE)
	{
		for (i=chg_anz; (--i)>=0; )			/* gleiche nderung */
			if (chg[i].link==link && chg[i].c==change && chg[i].y==ypos)
				return;
	}
	if (change==POS_CHANGE)
	{
		for (i=chg_anz; (--i)>=0; )
			if (chg[i].link==link && chg[i].c==change)
				return;
	}
	if (chg_anz>=MAX_CHG)
	{
		fnote(1,FATALERR,0);
		return;
	}
	chg[chg_anz].link = link;
	chg[chg_anz].c = change;
	chg[chg_anz].y = ypos;
	setincl(chg_links,link);
	chg_anz++;
}

VOID pos_korr(WINDOWP window, TEXTP t_ptr)
{
	WORD	x_new;
	LONG	y_new;

	y_new = t_ptr->ypos - window->doc.y;
	if (y_new < 0L)
	{
		if (y_new == -1L)
			arrow_window(window, WA_UPLINE, 1);
		else
			arrow_window(window, WA_UPLINE, window->w_height/2-y_new);
	}
	else if (y_new >= window->w_height)
	{
		if (y_new == window->w_height)
			arrow_window(window, WA_DNLINE, 1);
		else
			arrow_window(window, WA_DNLINE, y_new-window->w_height/2);
	}

	x_new = cursor_xpos(t_ptr, t_ptr->xpos) - (short) window->doc.x * gl_wchar;
	if (x_new < 0)
		arrow_window(window, WA_LFLINE, -(x_new/gl_wchar) + window->w_width/2);
	else if (x_new >= window->work.g_w)
		arrow_window(window, WA_RTLINE, (x_new-window->work.g_w)/gl_wchar + window->w_width/2);
}

/*
 * Neuzeichnen, wenn Fenster teilweise verdeckt.
 * z.B. bei D&D
*/
LOCAL VOID restore_offdesk(WINDOWP window, TCHANGE *c, WORD c_anz, TEXTP t_ptr)
{
	WORD		y_screen;
	BOOLEAN	done = FALSE;
	GRECT		a;

	for (; (--c_anz)>=0; c++)
	{
		switch (c->c)
		{
			case WT_CHANGE :	/* fr save(): nur '*' lschen, sonst nix */
				change_window(window, t_ptr->filename, (t_ptr->moved!=0));
				break;

			case POS_CHANGE	 :
				if (window->class==CLASS_EDIT)
				{
					a = window->work;
					a.g_h = sys_hchar;
					redraw_window(window, &a);
				}
				change_window(window, t_ptr->filename, (t_ptr->moved!=0));
				pos_korr(window, t_ptr);
				break;

			case LINE_CHANGE:
				y_screen = (short) (c->y - window->doc.y);
				if (y_screen>=0 && y_screen<window->w_height)
				{
					a = window->work;
					a.g_y += y_screen * window->yfac;
					a.g_h = window->yfac;
					redraw_window(window, &a);
				}
				break;

			case TOTAL_CHANGE  :
			case BLK_CHANGE	 :
			case SCROLL_UP 	 :
			case SCROLL_DOWN :
				if (!done)
					redraw_window(window, &window->work);
				done = TRUE;
				break;

			case MOVE_UP:
				arrow_window(window, WA_DNLINE, c->y);
				break;

			case MOVE_DOWN:
				arrow_window(window, WA_UPLINE, c->y);
				break;
		}
	}
}

/*
 * Neuzeichnen, wenn Fenster komplett frei.
*/
LOCAL VOID restore_indesk(WINDOWP window, TCHANGE *c, WORD c_anz, TEXTP t_ptr)
{
	GRECT	a;
	WORD	y_screen, help;
	LONG	z1,z2;

	for (; (--c_anz)>=0; c++)
	{
		set_clip(TRUE, &(window->work));
		switch (c->c)
		{
			case WT_CHANGE:				/* nur '*' ndern, sonst nix */
				change_window(window, t_ptr->filename, (t_ptr->moved!=0));
				break;

			case POS_CHANGE:
				if (window->class == CLASS_EDIT)
					head_out(window, t_ptr);
				change_window(window, t_ptr->filename, (t_ptr->moved!=0));
				pos_korr(window, t_ptr);
				break;

			case LINE_CHANGE:
				y_screen = (short)(c->y - window->doc.y);
				if (y_screen < window->w_height)
					line_out(window, t_ptr, y_screen);
				break;

			case TOTAL_CHANGE:
				y_screen = (short) (c->y - window->doc.y);
				bild_out(window,t_ptr);
				break;

			case SCROLL_UP:
				y_screen = (short) (c->y - window->doc.y);
				if (y_screen < window->w_height-1)
				{
					help = window->yfac*(y_screen+1);
					a = window->work;
					a.g_h -= help;
					a.g_y += help;
					scroll_vertical (&a, window->yfac);
				}
				if (y_screen < window->w_height)
					line_out(window, t_ptr, window->w_height-1);
				break;

			case SCROLL_DOWN:
				y_screen = (short) (c->y - window->doc.y);
				if (y_screen < window->w_height-1)
				{
					a = window->work;
					a.g_h -= window->yfac * (y_screen + 1);
					a.g_y += window->yfac * y_screen;
					scroll_vertical (&a, -window->yfac);
				}
				/* Die neue Zeile wird mit LINE_CHANGE gezeichnet */
				break;

			case MOVE_UP:
				arrow_window(window, WA_DNLINE, c->y);
				break;

			case MOVE_DOWN:
				arrow_window(window, WA_UPLINE, c->y);
				break;

			case BLK_CHANGE:
				z1 = c->y;
				c++; c_anz--;
				z2 = c->y;
				bild_blkout(window,t_ptr,z1,z2);
				break;
		}
	}
}

VOID restore_edit(VOID)
{
	WINDOWP	window;
	TEXTP 	t_ptr;
	WORD		i, c_anz, link, max;
	TCHANGE	c[MAX_CHG], *c_ptr;
	
	if (!chg_anz) 
		return;

	hide_mouse();
	max = setmax(chg_links);
	for (link = setmin(chg_links); link <= max; link++) 
	{
		if(setin(chg_links,link))
		{
			window = get_window(link);
			if (window == NULL) 
				continue;								/* Kommt vor (Prj_Text mit 10001) */
			c_anz = 0;
			c_ptr = chg;
			for (i=chg_anz; (--i)>=0; c_ptr++)
				if (c_ptr->link==link && c_ptr->c!=NOP_CHANGE)
					c[c_anz++] = *c_ptr;
	
			t_ptr = get_text(window->handle);

			/* Slider anpassen */
			if (window->doc.h != t_ptr->text.lines)
			{
				window->doc.h = t_ptr->text.lines;
				set_sliders(window, VERTICAL, SLPOS+SLSIZE);
			}

			get_longestline(t_ptr);
			if (window->doc.w != t_ptr->max_line->exp_len)
			{
				window->doc.w = t_ptr->max_line->exp_len;
				set_sliders(window, HORIZONTAL, SLPOS+SLSIZE);
			}	

			if ((window->flags & WI_OPEN) || (window->flags & WI_ICONIFIED))
			{
				if (free_for_draw(window))
					restore_indesk(window, c, c_anz, t_ptr);
				else
					restore_offdesk(window, c, c_anz, t_ptr);
			}
		}
	}
	show_mouse();
	chg_anz = 0;			/* Keine nderungen mehr */
	setclr(chg_links);
}

/***************************************************************************/
LOCAL VOID destruct(WORD icon)
{
	TEXTP t_ptr = get_text(icon);
	WINDOWP window = get_window(icon);

	insert_poslist(&lastpos_list, t_ptr->filename, t_ptr->xpos, t_ptr->ypos);

	/* Text war Error-Datei */
	if (t_ptr == last_errtext)
		last_errtext = NULL;

	close_window(window);
	destruct_text(t_ptr);
	del_icon(icon);
	setexcl(used_info,icon);
	clr_undo();
	do_all_icon(prj_type, DO_UPDATE);		/* Projekte updaten */
}

/***************************************************************************/

LOCAL WORD crt_new_text(CONST UBYTE *filename)
{
	TEXTP 		t_ptr;
	WINDOWP		win;
	PATH			name;
	BOOLEAN		namenlos;

	if (filename[0] == EOS)
	{
		strcpy(name, STRING(NAMENLOS));
		namenlos = TRUE;
	}
	else
	{
		strcpy(name, filename);
		namenlos = FALSE;
	}
	
	/* Fenster anlegen */
	win = create_window(KIND, CLASS_EDIT, crt_edit);
	if (win == NULL)
		return -1;
	if (!add_icon(edit_type, win->handle))
		return -1;

	/* Text kreiern */
	t_ptr = new_text(win->handle);
	if (t_ptr == NULL)
	{
		del_icon(win->handle);
		return -1;
	}
	set_text_name(t_ptr, name, namenlos);
	setincl(used_info, win->handle);

	set_wtitle(win, name);
	set_winfo(win, "");
	
	if (!namenlos)
		do_all_icon(prj_type, DO_UPDATE);				/* Projekte updaten */

	t_ptr->asave = time(NULL);

	return win->handle;
}

/***************************************************************************/
/* Kreieren eines Fensters 																*/
/***************************************************************************/
LOCAL VOID crt_edit(WINDOWP window)
{
	WORD		initw, inith;

	if (window->work.g_w == 0 || window->work.g_h == 0)
	{
		/* Keine Gre bekannt. */
		initw  = min ((desk.g_w / gl_wchar) * gl_wchar - 7 * gl_wchar, 80 * gl_wchar);
		inith  = (desk.g_h / gl_hchar) * gl_hchar - 7 * gl_hchar;
	
		window->work.g_x	= sys_wchar + 2 * 8;
		window->work.g_y	= 60;
		window->work.g_w	= initw;
		window->work.g_h	= inith;
	}
	
	window->flags		= FLAGS;
	window->doc.w		= 0;
	window->doc.h		= 0;
	window->xfac		= gl_wchar;
	window->yfac		= gl_hchar;
	window->w_width	= initw/gl_wchar;
	window->w_height	= inith/gl_hchar;
	window->draw		= wi_draw;
	window->click		= wi_click;
	window->key 		= wi_key;
	window->top			= wi_top;
	window->ontop		= wi_top;
	window->iconify	= wi_iconify;
	window->uniconify	= wi_uniconify;
	window->close		= NULL;
}

/***************************************************************************/
/* ffnen des Objekts																		*/
/***************************************************************************/
LOCAL BOOLEAN open_edit(WORD icon)
{
	BOOLEAN	ok;
	WINDOWP	window = get_window(icon);

	ok = TRUE;

	if (window->flags & WI_ICONIFIED)
		uniconify_window(window, NULL);
	else if (window->flags & WI_SHADED)
		shade_window(window, -1);
	else if (window->flags & WI_OPEN)
		top_window(window);
	else
	{
		TEXTP t_ptr = get_text(window->handle);

		window->doc.x = 0;
		window->doc.y = 0;
		window->doc.h = t_ptr->text.lines;
		pos_korr(window, t_ptr);
		ok = open_window (window);
		ch_kurzel(t_ptr->loc_opt->kurzel, FALSE);
	}
	return ok;
}

/***************************************************************************/
/* Info des Objekts																			*/
/***************************************************************************/
GLOBAL BOOLEAN info_edit (WORD icon)
{
	UBYTE			str[32], date[11];
	TEXTP 		t_ptr = get_text(icon);
	WORD			erg;
	LINEENDING	ending;
	BOOLEAN		b;
	
	ltoa(textring_bytes(&t_ptr->text), str, 10);
	fill_ptext (textinfo, INFGROSS, str);		/* Gre in Bytes */
	if (t_ptr->text.ending != binmode)
	{
		ltoa(t_ptr->text.lines, str, 10);
		fill_ptext (textinfo, INFZEILE, str);		/* Gre in Zeilen */
	}
	else
		fill_ptext (textinfo, INFZEILE, "--");		/* Binr: keine Zeilen */

	make_shortpath(t_ptr->filename, str, 30);
	fill_ptext (textinfo, INFNAME, str);		/* Name mit Pfad */
	if (t_ptr->namenlos)
	{
		strcpy(str, "");
		strcpy(date, "--");
	}
	else
		file_time (t_ptr->filename, date, str);
	fill_ptext (textinfo, INFDATUM, date); 	/* Datum */
	fill_ptext (textinfo, INFZEIT, str);		/* Uhrzeit */


	select_objc(textinfo, INFTOS, (t_ptr->text.ending == tos));
	select_objc(textinfo, INFUNIX, (t_ptr->text.ending == unix));
	select_objc(textinfo, INFMAC, (t_ptr->text.ending == apple));
	ending = t_ptr->text.ending;

	/* Dateien aus einem Projekt oder Binr -> kein Zeilenende */
	b = (!setin(used_info, icon) || (t_ptr->text.ending == binmode));
	disable_objc(textinfo, INFTOS, b);
	disable_objc(textinfo, INFUNIX, b);
	disable_objc(textinfo, INFMAC, b);
	erg = handle_dial(textinfo, 0);

	if (erg == INFOK)
	{
		if (get_select(textinfo, INFTOS))
			t_ptr->text.ending = tos;
		if (get_select(textinfo, INFUNIX))
			t_ptr->text.ending = unix;
		if (get_select(textinfo, INFMAC))
			t_ptr->text.ending = apple;

		if (t_ptr->text.ending != ending)
		{
			t_ptr->moved++;
			make_chg(t_ptr->link, POS_CHANGE, 0); 	/* Damit Infozeile einen '*' bekommt */
			restore_edit();
		}
	}
	return TRUE;
}

GLOBAL VOID init_edit(VOID)
{
	setclr(used_info);
	setclr(chg_links);
	drag_filename[0] = EOS;
	edit_type = decl_icon_type(icon_test,icon_edit,icon_exist,icon_drag);
}

GLOBAL VOID	cursor_off(WORD wHandle)
{
	WINDOWP	window;
	TEXTP 	t_ptr;

	window = get_window(wHandle);
	if (window!=NULL && window->class==CLASS_EDIT)
	{
		t_ptr = get_text(window->handle);
		if (t_ptr->cursor)
			t_ptr->cursor = FALSE;
	}
}

GLOBAL VOID	cursor_on(WORD wHandle)
{
	WINDOWP	window;
	TEXTP 	t_ptr;

	window = get_window(wHandle);
	if (window!=NULL && window->class==CLASS_EDIT)
	{
		t_ptr = get_text(window->handle);
		if (!t_ptr->cursor)
			t_ptr->cursor = TRUE;
	}
}

GLOBAL VOID set_info(TEXTP t_ptr, UBYTE *str)
{
	strcpy(t_ptr->info_str, str);
}

GLOBAL VOID clear_info(TEXTP t_ptr)
{
	if (t_ptr->info_str[0] != EOS)
		strcpy(t_ptr->info_str, "");
}
