#include <ctype.h>
#include <support.h>

#include "global.h"
#include "edit.h"
#include "icon.h"
#include "memory.h"
#include "rsc.h"
#include "set.h"
#include "text.h"
#include "window.h"
#include "error.h"

/*
 * Exportierte Variablen:
*/
GLOBAL UBYTE	error[FEHLERANZ][40];
GLOBAL TEXTP	last_errtext = NULL;

/*
 * lokales
*/
typedef enum {nil, read_text, read_name, read_zeile, read_spalte, read_fehler} TOKEN;

#define MAX_TOKEN		10				/* Anzahl der Token */
#define MAX_ERRLEN	120			/* Lnge der Fehlerzeile */

typedef struct
{
	TOKEN	token;
	UBYTE	text[10];
} TOKENELEM, *TEP;

LOCAL TOKENELEM	token_list[MAX_TOKEN];
LOCAL WORD			token_anzahl;
LOCAL	PATH			error_name;					/* Dateiname des Errorfiles */

/* das Ergebnis */
LOCAL PATH	dateiname;
LOCAL UBYTE	fehlertext[MAX_ERRLEN];
LOCAL LONG	fehlerzeile;
LOCAL WORD	fehlerspalte;
LOCAL WORD	err_anz = 0;



LOCAL VOID init_parser(UBYTE *muster)
{
	UBYTE	tmp[2] = " ";
	WORD	i;
	TOKEN last_token;

	strcpy(dateiname, "");
	fehlerzeile = -1;
	fehlerspalte = -1;
	strcpy(fehlertext, "");

	token_anzahl = 0;
	last_token = nil;
	for (i = 0; i < MAX_TOKEN; i++)
	{
		token_list[i].token = nil;
		strcpy(token_list[i].text, "");
	}

	for (i = 0; i < (short)strlen(muster); i++)
	{
		switch (muster[i])
		{
			case '%' :
				i++;
				if (last_token == read_text)
					token_anzahl++;
				switch (muster[i])
				{
					case 'f' :
						token_list[token_anzahl].token = read_name;
						last_token = read_name;
						break;
					case 'z' :
						token_list[token_anzahl].token = read_zeile;
						last_token = read_zeile;
						break;
					case 's' :
						token_list[token_anzahl].token = read_spalte;
						last_token = read_spalte;
						break;
					case 't' :
						token_list[token_anzahl].token = read_fehler;
						last_token = read_fehler;
						break;
				}
				break;
			default:
				if (last_token > read_text)
					token_anzahl++;
				token_list[token_anzahl].token = read_text;
				tmp[0] = muster[i];
				strcat(token_list[token_anzahl].text, tmp);
				last_token = read_text;
				break;
		}
	}
}


LOCAL BOOLEAN	readin_text(UBYTE *zeile, WORD *pos, UBYTE *text)
{
	WORD	len = (short)strlen(text),
			i;
	UBYTE	tmp[10];

	i = *pos;
	while ( (i < (short)strlen(zeile)) && (i < (len + *pos)))
	{
		tmp[i - *pos] = zeile[i];
		i++;
	}
	if (i > *pos)
	{
		tmp[i - *pos] = EOS;
		*pos = i;
		return (strcmp(tmp, text) == 0);
	}
	else
		return FALSE;
}

LOCAL BOOLEAN	readin_name(UBYTE *zeile, WORD *pos)
{
	SET	valid_char;
	PATH	tmp;
	WORD	i;

	strcpy(tmp,"-+._~\\/A-Za-z0-9");				/* Zulssige Zeichen fr Dateinamen */
	str2set(tmp, valid_char);
	i = *pos;
	while ( 	(i < (short)strlen(zeile)) && 	/* Sonderbehandlung fr ':', nur im Pfad erlaubt! */
				((setin(valid_char, zeile[i])) ||
				 (zeile[i] == ':' && (zeile[i+1] == '\\') || zeile[i+1] == '/')))
	{
		tmp[i - *pos] = zeile[i];
		i++;
	}
	if (i > *pos)
	{
		tmp[i - *pos] = EOS;
		*pos = i;

		if (strchr(tmp, '/') != NULL)				/* UNIX-Pfad -> nach TOS wandeln */
		{
			unx2dos(tmp, dateiname);
		}
		else if (tmp[1] != ':')						/* Kein Laufwerk -> Name ohne Pfad! */
		{

			file_splitt(error_name, dateiname, NULL);
			strcat(dateiname, tmp);
		}
		else
			strcpy(dateiname, tmp);
		return (file_exist(dateiname));
	}
	else
		return FALSE;
}

LOCAL BOOLEAN	readin_zeile(UBYTE *zeile, WORD *pos)
{
	WORD	i;
	UBYTE	tmp[10];

	i= *pos;
	while ( (i < (short)strlen(zeile)) && (isdigit(zeile[i])) )
	{
		tmp[i - *pos] = zeile[i];
		i++;
	}
	if (i > *pos)
	{
		tmp[i - *pos] = EOS;
		fehlerzeile = atol(tmp);
		*pos = i;
		return TRUE;
	}
	else
		return FALSE;
}

LOCAL BOOLEAN	readin_spalte(UBYTE *zeile, WORD *pos)
{
	WORD	i;
	UBYTE	tmp[10];

	i= *pos;
	while ( (i < (short)strlen(zeile)) && (isdigit(zeile[i])) )
	{
		tmp[i - *pos] = zeile[i];
		i++;
	}
	if (i > *pos)
	{
		tmp[i - *pos] = EOS;
		fehlerspalte = atoi(tmp);
		*pos = i;
		return TRUE;
	}
	else
		return FALSE;
}

LOCAL BOOLEAN	readin_fehler(UBYTE *zeile, WORD *pos)
{
	WORD	i, j;
	UBYTE	tmp[MAX_ERRLEN];

	i = *pos;
	j = 0;
	while ( (i < (short)strlen(zeile)) && (j < sizeof(tmp)) )
	{
		tmp[i - *pos] = zeile[i];
		i++;
		j++;
	}
	if (i > *pos)
	{
		tmp[i - *pos] = EOS;
		*pos = i;
		strcpy(fehlertext, tmp);
		return TRUE;
	}
	else
		return FALSE;
}

LOCAL BOOLEAN	parse_line(UBYTE *zeile)
{
	WORD		i, z_pos = 0;
	BOOLEAN	ok = FALSE;

	for (i = 0; i <= token_anzahl; i++)
	{
		switch (token_list[i].token)
		{
			case read_text :
				ok = readin_text(zeile, &z_pos, token_list[i].text);
				break;
			case read_name :
				ok = readin_name(zeile, &z_pos);
				break;
			case read_zeile :
				ok = readin_zeile(zeile, &z_pos);
				break;
			case read_spalte :
				ok = readin_spalte(zeile, &z_pos);
				break;
			case read_fehler :
				ok = readin_fehler(zeile, &z_pos);
				break;
		}
		if (!ok)
			break;
	}
	return ok;;
}


GLOBAL VOID	handle_error(TEXTP t_ptr)
{
	WORD	icon, i;
	UBYTE	str[256];

	if (last_errtext != NULL && t_ptr != last_errtext)
	{
		ZEILEP lauf = t_ptr->cursor_line;
	
		t_ptr = last_errtext;
		/* nchste Zeile setzen */		
		lauf = t_ptr->cursor_line;
		if (!IS_LAST(t_ptr->cursor_line))
		{
			NEXT(lauf);
			t_ptr->cursor_line = lauf;
			t_ptr->xpos = 0;
			t_ptr->ypos++;
			make_chg(t_ptr->link, POS_CHANGE, 0);
		}
	}
	for (i = 0; i < err_anz; i++)
	{
		init_parser(error[i]);
		strcpy(error_name, t_ptr->filename);
		if (parse_line(TEXT(t_ptr->cursor_line)))
		{
			last_errtext = t_ptr;

			if ((icon = still_loaded(dateiname)) >=0 )
				do_icon(icon, DO_OPEN);							/* Nur Fenster ffnen */
			else
				icon = load_edit(dateiname, FALSE);			/* Laden als Text und ffnen */
			if (icon > 0)
			{
				if (fehlerspalte > 0)
					desire_x = fehlerspalte - 1;				/* wir fange bei 0 an! */
				else
					desire_x = 0;
				if (fehlerzeile > 0)
					desire_y = fehlerzeile - 1;
				else
					desire_y = 0;

				if (strlen(fehlertext) > 0)
				{
					strcpy(str, STRING(ERRORSTR));
					strcat(str, fehlertext);
					set_info(get_text(icon), str);
				}
				Icon_edit(icon, DO_GOTO);
				return;
			}
		}
	}
	if (last_errtext != NULL)
		last_errtext = NULL;
	mybeep();
}

/*
 * Die Dialogbox fr die Fehlerzeile
 */
GLOBAL VOID	fehler_box(VOID)
{
	WORD	antw, i;
	UBYTE	str[40];
	
	for (i = 0; i < FEHLERANZ; i++)
		objc_setstring(fehler, FEHLTEXT1 + i, error[i]);
	antw = handle_dial(fehler, 0);
	if (antw == FEHLOK)
	{
		err_anz = 0;
		for (i = 0; i < FEHLERANZ; i++)
		{
			strcpy(error[i], "");								/* leeren */
			objc_getstring(fehler, FEHLTEXT1 + i, str);
			set_errorline(str);
		}
	}
}

/*
 * Zeilen aus Parameterdatei eintragen.
*/
GLOBAL VOID set_errorline(UBYTE *zeile)
{
	if ((err_anz < FEHLERANZ) && (zeile[0] != EOS))
	{
		strcpy(error[err_anz], zeile);
		err_anz++;
	}
}
