#include <errno.h>
#include <time.h>

#include "global.h"
#include "comm.h"
#include "edit.h"
#include "find.h"
#include "fsel.h"
#include "icon.h"
#include "memory.h"
#include "olga.h"
#include "options.h"
#include "projekt.h"
#include "rsc.h"
#include "text.h"
#include "window.h"
#include "file.h"

/* Puffer-Lnge zum Lesen/Schreiben */
#define	BUFFERSIZE	4*1024L


GLOBAL WORD	load(TEXTP t_ptr, BOOLEAN quiet)
{
	WORD		antw;
	BOOLEAN	null_byte;
	
	antw = load_datei(t_ptr->filename, &t_ptr->text, TRUE, &null_byte);
	t_ptr->cursor_line = t_ptr->text.head.nachf;
	t_ptr->readonly = file_readonly(t_ptr->filename);
	if (null_byte)
		t_ptr->moved++;
	if (antw == 0)
	{
		t_ptr->file_date_time = file_time(t_ptr->filename,NULL,NULL);
	}
	else
		t_ptr->file_date_time = -1L;
	if (antw!=0 && !quiet)
	{
		FILENAME	datei;
		PATH	path;

		file_splitt(t_ptr->filename, path, datei);

		if (antw==-33 && path_exist(path))	/* file not found und Pfad existiert */
			fnote(1, NOTEXIST, datei);
		else
			fnote(1, READERR, datei);
	}
	return(antw);
}


GLOBAL WORD load_datei(UBYTE *name, RINGP t, BOOLEAN verbose, BOOLEAN *null_byte)
{
	WORD		fd, antw;
	LONG		filesize;
	BOOLEAN	nb = FALSE, 
				ol = FALSE;
	
	/* gre der Datei ermitteln */
	filesize = file_size(name);
	if (filesize >= 0L)
	{
		fd = (short) Fopen(name, 0);
		if (fd > 0)
		{
			UBYTE		*buffer, *zeile;
			ZEILEP 	start, next;
			LONG		l, p, bytes;
			WORD		n;
			BOOLEAN	new_line, cr = FALSE, mem = TRUE;

			/* Puffer anfordern */
			buffer = (UBYTE *)malloc(BUFFERSIZE);
			zeile = malloc(MAX_LINE_LEN + 2);				/* + 2 fr Zeilenende */

			if (buffer == NULL || zeile == NULL)
			{
				note(1, NOMEMORY);
				return -39;
			}				

			nb = FALSE;
			set_mouse(HOURGLASS, NULL);

			/* Progress-Bar */
			verbose = verbose && ((filesize >> 10) >= transfer_size);
			if (verbose)
			{
				UBYTE		str[40];
				FILENAME	file;

				strcpy(str, STRING(LOADSTR));
				file_name(name, file, FALSE);
				strcat(str, file);
				start_aktion(str, FALSE, filesize);
				bytes = 0L;
			}


			/* Liste vorbereiten */
			start = t->tail.vorg;

			/* Einlesen */
			l = Fread(fd, BUFFERSIZE, buffer);

			n = 0;
			new_line = FALSE;
			while (mem && (l > 0))
			{
				p = 0;
				while (mem && (p < l))
				{
					if (t->ending != binmode)
					{
						if (buffer[p] == 0x0D)				/* CR -> Mac */
						{
							new_line = TRUE;
							p++;
							cr = TRUE;
							t->ending = apple;
						}
						else if (buffer[p] == 0x0A)		/* LF */
						{
							p++;
							if (cr)								/* CRLF -> TOS*/
							{
								cr = FALSE;
								t->ending = tos;
							}
							else
							{
								new_line = TRUE;				/* -> Unix */
								t->ending = unix;
							}
						}
						else if (n >= t->max_line_len)	/* berlnge */
						{
							ol = TRUE;
							new_line = TRUE;
						}
						else 
						{
							/* Nullbyte? */
							if (buffer[p] == '\0')
							{
								nb = TRUE;
								buffer[p] = ' ';				/* Durch Leerzeichen ersetzen */
							}
							zeile[n] = buffer[p];
							n++;
							p++;
						}
					}
					else	/* binmode */
					{
						if (n >= (t->max_line_len - 1))
							new_line = TRUE;
						zeile[n] = buffer[p];
						n++;
						p++;
					}
					
					if (new_line)
					{
						zeile[n] = EOS;
						start->nachf = new_col(zeile, n);
						if (start->nachf == NULL)
							mem = FALSE;
						else
						{
							start = start->nachf;
							if (ol)
							{
								start->info |= OVERLEN;
								ol = FALSE;
							}
						}
						n = 0;
						new_line = FALSE;
					}
				} /* while */

				if (verbose)
				{
					bytes += BUFFERSIZE;
					do_aktion(bytes);
				}
				l = Fread(fd, BUFFERSIZE, buffer);

				/* EOF */
				if (l == 0)
				{
					/* letzte Zeile ohne Zeilenende! */
					if (n > 0)
					{
						zeile[n] = EOS;
						start->nachf = new_col(zeile, n);
						if (start->nachf == NULL)
							mem = FALSE;
						else
							start = start->nachf;
					}

					/* letzte Zeile hatte ZE -> ein Dummyzeile anhngen */
					else if (n == 0)
					{
						start->nachf = new_col(zeile, 0);
						if (start->nachf == NULL)
							mem = FALSE;
						else
							start = start->nachf;
					}
				}
			} /* while */

			if (mem)
			{
				/* Ring schlieen */
				t->tail.vorg = start;
				start->nachf = &t->tail;
	
				/* Anzahl der Zeilen ermitteln */
				start = t->head.nachf;
				next = start->nachf;
				for (l = 0; !IS_TAIL(start); l++)
				{
					next->vorg = start;
					start = next;
					NEXT(next);
				}
				t->lines = l;
				if (l > 1L)
					col_delete(t, t->head.nachf);

				antw = 0;
			}
			else
			{
				/* Speichermangel! Bisher gelesene Zeilen freigeben. */
				next = FIRST(t);
				while (next)
				{
					start = next;
					NEXT(next);
					free_col(start);
				}
				set_mouse(ARROW, NULL);
				note(1, NOMEMORY);
				antw = -39;
			}
			Fclose(fd);

			free(buffer);
			free(zeile);
			
			if (verbose)
				end_aktion();

			set_mouse(ARROW, NULL);
		}
		else
			antw = fd;
	}
	else
		antw = -1;
	if (null_byte != NULL)
		*null_byte = nb;
	return(antw);
}


/*
 * Ermittelt die anzahl der Bytes und Zeilen der bergebenen Datei.
 * Wird bei der Projektverwaltung (Info) benutzt.
 */
GLOBAL WORD infoload(UBYTE *name, LONG *bytes, LONG *lines)
{
	RING			t;
	WORD			antw;

	init_textring(&t);
	if (load_datei(name, &t, FALSE, NULL) == 0)
	{
		*bytes = textring_bytes(&t);
		*lines = t.lines;
		antw = 0;
	}
	else
		antw = 1;
	kill_textring(&t);
	return antw;
}


/****************************************************************************/

LONG	VOID backup_name(UBYTE *name, UBYTE *ext)
{
	PATH		new;
	FILENAME	new_name;
	
	strcpy(new, name);
	strcat(new, ".");
	strcat(new, ext);
	file_name(new, new_name, FALSE);
	if (longName(new) >= strlen(new_name))
		strcpy(name, new);
	else
		make_ext(name, ext);
}

LOCAL VOID restore_back_up(TEXTP t_ptr)
{
	if (t_ptr->loc_opt->backup)
	{
		PATH old;

		if (file_exist(t_ptr->filename))
			Fdelete(t_ptr->filename);
		strcpy(old, t_ptr->filename);
		backup_name(old, t_ptr->loc_opt->backup_ext);
		Frename(0, old, t_ptr->filename);
	}
}


LOCAL VOID back_up(TEXTP t_ptr)
{
	PATH new;

	if (t_ptr->loc_opt->backup)
	{
		set_mouse(HOURGLASS, NULL);
		strcpy(new, t_ptr->filename);
		backup_name(new, t_ptr->loc_opt->backup_ext);
		if (file_exist(new))			/* Alte DUP-Datei lschen */
			Fdelete(new);
		Frename(0, t_ptr->filename, new);
		set_mouse(ARROW, NULL);
	}
}

GLOBAL WORD save_datei(UBYTE *name, RINGP t, BOOLEAN verbose)
{
	WORD	fd, antw;

	fd = (short) Fcreate(name, 0);
	if (fd > 0)
	{
		UBYTE		end_str[3], *zeile, *buffer, *ptr;
		WORD		e_len, z_len;
		LONG		ret, count, b, rest, text_size;
		ZEILEP	lauf;

		/* Puffer anfordern */
		buffer = (UBYTE *)malloc(BUFFERSIZE);
		zeile = (UBYTE *)malloc(MAX_LINE_LEN + 2);

		if (buffer == NULL || zeile == NULL)
		{
			note(1, NOMEMORY);
			return -39;
		}				

		set_mouse(HOURGLASS, NULL);

		/* Progress-Bar */
		text_size = textring_bytes(t);
		verbose = verbose && ((text_size >> 10) >= transfer_size);
		if (verbose)
		{
			UBYTE	str[40];
			FILENAME	file;

			strcpy(str, STRING(SAVESTR));
			file_name(name, file, FALSE);
			strcat(str,file);
			start_aktion(str, FALSE, text_size);
			count = 0L;
		}

		/* String mit Zeilenende erzeugen */
		switch (t->ending)
		{
			case tos :
				strcpy(end_str, "\r\n");
				e_len = 2;
				break;
			case unix :
				strcpy(end_str, "\n");
				e_len = 1;
				break;
			case apple :
				strcpy(end_str, "\r");
				e_len = 1;
				break;
			default:
				strcpy(end_str, "");
				e_len = 0;
				break;
		}
		
		lauf = FIRST(t);
		if (lauf != NULL)
		{
			b = 0L;
			ret = 1;
			ptr = buffer;
			rest = BUFFERSIZE;
			while ((!IS_TAIL(lauf)) && (ret > 0))
			{
				/* Zeile aus Text und Zeilenende zusammen setzen */
				memcpy(zeile, TEXT(lauf), lauf->len);
				z_len = lauf->len;

				/*
				 * Das Zeilenende wird nur dann angehngt, wenn lauf nicht letzte
				 * Zeile ist. Gab es beim Laden der Datei in der letzten Zeile
				 * ein ZE, gibt es die Dummyzeile. Gab es das ZE nicht, wird auch
				 * kein ZE angehngt!
				 */
				if (!IS_LAST(lauf) && (e_len > 0) && !IS_OVERLEN(lauf))
				{
					memcpy(zeile + lauf->len, end_str, e_len);
					z_len += e_len;
				}
				
				/* Passt die Zeile noch in den Puffer? */
				if (z_len < rest)
				{
					/* komplett in den Puffer */
					memcpy(ptr, zeile, z_len);
					ptr += z_len;
					b += z_len;
					rest -= z_len;
				}
				else
				{
					/* nur soviel kopieren, wie noch passt */
					memcpy(ptr, zeile, rest);
					ptr += rest;
					
					/* wegschreiben */
					ret = Fwrite(fd, BUFFERSIZE, buffer);
					if (verbose)
					{
						count += BUFFERSIZE;
						do_aktion(count);
					}

					if (ret != BUFFERSIZE)
						ret = -ENOSPC;

					/* und den Rest in den Puffer */
					b = z_len - rest;
					ptr = buffer;
					memcpy(ptr, zeile + rest, b);
					ptr += b;
					
					rest = BUFFERSIZE - b;
				}
				NEXT(lauf);
			}

			/* Befindet sich noch etwas im Puffer und ist kein Fehler aufgetreten? */
			if ((b > 0L) && (ret > 0))
			{
				ret = Fwrite(fd, b, buffer);
				if (verbose)
				{
					count += b;
					do_aktion(count);
				}
				if (ret != b)
					ret = -ENOSPC;
			}
			if (ret < 0)
				antw = (short)ret;
			else
				antw = 0;
		}
		else
			antw = 1;

		Fclose(fd);
		if (antw == -ENOSPC)
			Fdelete(name);

		free(buffer);
		free(zeile);

		if (verbose)
			end_aktion();
	}
	else
		antw = fd;

	set_mouse(ARROW, NULL);
	return antw;
}


GLOBAL WORD save(TEXTP t_ptr)
{
	WORD	antw;

	if (file_exist(t_ptr->filename))
	{
		if (file_readonly(t_ptr->filename))
		{
			FILENAME	file;

			t_ptr->readonly = TRUE;
			file_name(t_ptr->filename, file, FALSE);
			fnote(1, READONLY, file);
			return -39;
		}
		else
			t_ptr->readonly = FALSE;
		if (t_ptr->file_date_time != -1L)
		{
			LONG date_time = file_time(t_ptr->filename, NULL, NULL);

			if (date_time != t_ptr->file_date_time)
			{
				FILENAME	name;

				file_name(t_ptr->filename, name, FALSE);
				if (fnote(1, MOVED2, name) == 2)
					return -1;
			}
		}
	}
	back_up(t_ptr);
	antw = save_datei(t_ptr->filename, &t_ptr->text, TRUE);
	if (antw == 0)
	{
		t_ptr->moved = 0;
		t_ptr->file_date_time = file_time(t_ptr->filename, NULL, NULL);
		t_ptr->asave = time(NULL);

		/* OLGA informieren */
		do_OLGA(OLGA_UPDATE, t_ptr->filename, NULL);
	}
	else
	{
		if (antw == -ENOSPC)
		{
			UBYTE	tmp[20];

			make_shortpath(t_ptr->filename, tmp, 19);
			fnote(1, NOSPACE, tmp);
		}
		else
			note(1, WRITEERR);
/*		restore_back_up(t_ptr); */
		t_ptr->file_date_time = -1L;
	}

	return antw;
}


GLOBAL WORD save_as(TEXTP t_ptr, UBYTE *name)
{
	WORD	antw;

	if (file_exist(name))
	{
		if (file_readonly(name))
		{
			FILENAME	file;

			file_name(t_ptr->filename, file, FALSE);
			fnote(1,READONLY, file);
			return -39;
		}
	}
	antw = save_datei(name, &t_ptr->text, TRUE);
	if (antw != 0)
	{
		if (antw == -ENOSPC)
		{
			UBYTE	tmp[20];

			make_shortpath(t_ptr->filename, tmp, 19);
			fnote(1, NOSPACE, tmp);
		}
		else
			note(1, WRITEERR);
/*		restore_back_up(t_ptr);*/
	}
	return(antw);
}


GLOBAL BOOLEAN	save_new(UBYTE *name, FSEL *fsel, UBYTE *text)
{
	fsel->name[0] = EOS;
	if (!select_file(fsel,name, text))
		return FALSE;
	if (file_exist(name))
	{
		if (note(1,EXIST)==2) return
			FALSE;
	}
	return TRUE;
}


/*****************************************************************************/
/* Dateiauswahl																				  */
/*****************************************************************************/
LOCAL PATH 		fs_path; 					/* Pfad der Dateiauswahl-Box */
LOCAL FSEL 		default_fsel;				/* Suffix und Name in Box */
LOCAL BOOLEAN 	ext_fsel;					/* erweitertes Fileselect-Box mglich */

#define MFILE_ANZ 10							/* Anzahl fr Selectric */
LOCAL UBYTE		*slct_files[MFILE_ANZ];


GLOBAL VOID set_fsel_path(const UBYTE *path)
{
	PATH	p;

	file_splitt(path, p, NULL);
	if (path_exist(p))
		strcpy(fs_path, p);
}

GLOBAL BOOLEAN select_file(FSEL *fsel, UBYTE *filename, const UBYTE *lable)
{
	WORD		button;
	UBYTE		*p;
	PATH		l_path;
	FILENAME	l_name;

	if (fsel==NULL)
		fsel = &default_fsel;

	strcpy(l_path, fs_path);

	p = strrchr (l_path, '\\');
	strcpy((p+1), fsel->suffix);
	strcpy(l_name, fsel->name);

	wake_mouse();
/*	wind_update(BEG_UPDATE);*/
/*	wind_update(BEG_MCTRL);*/
	if (ext_fsel || gem >= 0x140 && gem < 0x200 || gem >= 0x300)
		fsel_exinput (l_path, l_name, &button, (UBYTE*)lable);
	else
		fsel_input (l_path, l_name, &button);
/*	wind_update(END_MCTRL);*/
/*	wind_update(END_UPDATE);*/
	if (button != 0)
	{
		p = strrchr (l_path, '\\');
		strcpy(fsel->suffix, (UBYTE *)p+1);
		p[1] = EOS;
		make_normalpath(l_path,FALSE);
		strcpy(fsel->name, l_name);

		strcpy (filename, l_path);
		strcat (filename, l_name);
		set_fsel_path(l_path);						/* aktuellen Pfad im GEMDOS ndern */
		send_dhst(filename);
	}
	else
		filename[0] = EOS;							/* Abbruch gedrckt */
	return (*l_name && (button !=0) );
}

LOCAL UBYTE **select_mfile (FSEL *fsel, UBYTE *path, const UBYTE *lable, WORD *anz)
{
	BOOLEAN	slct;

	slct =  slct_morenames(CMD_FILES_OUT, MFILE_ANZ, slct_files);
	if (select_file (fsel, path, lable))
	{
		if (slct)
			*anz = slct_getnum();
		else
			*anz = 1;
	}
	else
		*anz = 0;
	return (*anz > 1) ? slct_files : NULL;
}

GLOBAL VOID select_multi(VOID)
{
	WORD		anz_files, i, r;
	UBYTE		**files;
	PATH		name, path;

	name[0] = EOS;
	files = select_mfile(NULL, name, STRING(LOADFILESTR), &anz_files);
	if (anz_files > 0)
	{
		if (files == NULL)
		{
			if (!global_shift && (filematch(name, "*.QPJ")))
				r = load_projekt(name);
			else
				r = load_edit(name, FALSE);
			if (r > 0)
				send_dhst(name);
		}
		else
		{
			file_splitt(name, path, NULL);
			for (i = 0; i < anz_files; i++)
			{
				strcpy(name, path);
				strcat(name, files[i]);
				if (!global_shift && (filematch(name, "*.QPJ")))
					r = load_projekt(name);
				else
					r = load_edit(name, FALSE);
				if (r > 0)
					send_dhst(name);
			}
		}
	}
}

GLOBAL VOID select_bin(VOID)
{
	PATH	name;

	if (select_file(NULL, name, STRING(LOADBINSTR)))
		load_edit(name, TRUE);
}

/******************************************************************************/
GLOBAL VOID init_file(VOID)
{
	WORD	i;
	
	ext_fsel = fsel_check();					/* erweiterte FselBox */
	if (ext_fsel)
	{
		for (i = 0; i < MFILE_ANZ; i++)
		{
			slct_files[i] = (UBYTE *) malloc(sizeof(PATH));
			strcpy(slct_files[i], "");
		}
	}

	default_fsel.name[0] = EOS;
	strcpy(default_fsel.suffix,"*.*");
	get_path(fs_path, 0);							/* Aktuellen Pfad holen */
	strcat (fs_path, "*.*");						/* fr FileselctBox */
}

GLOBAL VOID term_file(VOID)
{
	WORD	i;
	
	if (ext_fsel)
	{
		for (i = 0; i < MFILE_ANZ; i++)
			if (slct_files[i] != NULL)
				free(slct_files[i]);
	}
}
