#include <support.h>

#include "global.h"
#include "comm.h"
#include "obj.h"
#include "printer.h"
#include "rsc.h"
#include "window.h"
#include "xfsl.h"
#include "xufsl.h"
#include "fontsel.h"

/*
 * exportierte Variablen
 */
FONTINFO	winFont;
FONTINFO	druckFont;

/* 
 * Fontauswahl durchfhren.
 * Reihenfolge:
 *		1. Cookie xFSL
 *		2. Cookie UFSL
 *		3. $FONTSELECT
 *		4. fnts_do()
 */
BOOLEAN	select_font(BOOLEAN wind)
{
	FONTINFO	*font;
	LONG		v;
	WORD		f_id, f_pts, ret, i, d;
	WORD		fs_handle, workout[57], f_anz;
	BOOLEAN	ok = FALSE;
	UBYTE		*p, *titel;

	if (wind)
	{
		font = &winFont;
		titel = STRING(SELWFONTSTR);
	}
	else
	{
		font = &druckFont;
		titel = STRING(SELPFONTSTR);
	}
	/* 
	 * Wir machen einfach eine eigene WS auf, da MagiC am Handle rumfummelt und
	 * alte UFSL den Demotext drucken wrden.
	 * Wer einen Font fr den Drucker aber nicht fr den Bildschirm anmeldet,
	 * hat selber schuld!
	*/
	fs_handle = open_vwork(workout);
	f_anz = workout[10];
	if (gdos)
	{
		f_anz += vst_load_fonts(fs_handle, 0);
		vst_font(fs_handle, font->id);
		vst_point(fs_handle, font->pts, &d,&d,&d,&d);
	}
	f_id = font->id;
	f_pts = font->pts;

	if (getcookie('xFSL', &v))
	{
		xFSL	*xfsl;

		xfsl = (xFSL *)v;
		ret = xfsl->xfsl_input(fs_handle, (FF_ALL), titel, &f_id, &f_pts);
		if (ret == 1)
		{
			font->id = f_id;
			font->pts = f_pts;
			ok = TRUE;
		}
	}
	else if (getcookie('UFSL', &v))
	{
		xUFSL_struct	*ufsl;
		ULONG				flags=0xFFFF;
		WORD				attr = 0, color = 1, skew = 0;
		FW_INFO			width={0,0,0};

		ufsl = (xUFSL_struct *)v;
		flags = UFS_SIZE_CHANGE|
				  UFS_GDOS_FONTS|
				  UFS_PROP_FONTS;

		if (ufsl->id == xUFS_ID)
		{
			if ((ufsl->version <= 0x103))
			{
				ret = ufsl->font_selexinput(fs_handle, flags, titel,
													titel, 1, 1, &f_id, &f_pts,
													&width, &attr, &color, &skew);
			}
			else
			{
				ret = ufsl->font_selexinput(fs_handle, flags, titel,
													 titel, 1, 1, &f_id, &f_pts,
													 &width, &attr, &color, &skew);
			}
		}
		else
		{
			ufsl->dialtyp = UFS_DIALOG;
			ret = ufsl->fontsel_input(fs_handle, f_anz, 0, titel, &f_id, &f_pts);
		}
		if (ret == UFS_OK)
		{
			font->id = f_id;
			font->pts = f_pts;
			ok = TRUE;
		}
	}
	else if (wind && (p = getenv("FONTSELECT")) != NULL)		/* nur fr Fenster-Font! */
	{
		UBYTE	name[9];

		strncpy(name, p, 8);
		for (i = (WORD)strlen(name); i < 8; i++)
			strcat(name, " ");
		i = appl_find(name);
		if (i >= 0)
		{
			memset(msgbuff, 0, (WORD)sizeof(msgbuff));
			msgbuff[0] = 0x7A19;			/* FONT_SELECT */
			msgbuff[3] = -1;
			msgbuff[4] = f_id;
			msgbuff[5] = f_pts;
			msgbuff[6] = 1;
			msgbuff[7] = 0;
			send_msg(i);
		}
	}
	else if (appl_xgetinfo(7, &i, &d, &d, &d) && (i & 0x04))
	{
		VOID	*fnt_ptr;
		WORD	check;
		LONG	ratio = 1l << 16,
				id = f_id,
				pts = (LONG) f_pts << 16;

		fnt_ptr = fnts_create(fs_handle, 0, (FNTS_BTMP|FNTS_OUTL|FNTS_MONO|FNTS_PROP),
									 (FNTS_3D), "The quick brown...", NULL);

		ret = fnts_do(fnt_ptr,  FNTS_BSET, id, pts, ratio, &check, &id, &pts, &ratio);

		if (ret == FNTS_OK|| ret == FNTS_SET)
		{
			font->id = (WORD) id;
			font->pts = (WORD) (pts >> 16);
			ok = TRUE;
		}
		fnts_delete(fnt_ptr, 1);
	}
	else
		note(1, NOFSL);

	if (gdos)
		vst_unload_fonts(fs_handle, 0);
	v_clsvwk(fs_handle);

	return ok;
}

GLOBAL VOID font_change(VOID)
{
	WORD	ret, w1, w2, d, dummy1[5], dummy3[3];

	/* gl_wchar und gl_hchar werden NUR hier verndert */
	vst_font(vdi_handle, winFont.id);
	winFont.pts = vst_point (vdi_handle, winFont.pts, &d, &d, &gl_wchar, &gl_hchar);

	vqt_width(vdi_handle,'M',&w1,&ret,&ret);
	vqt_width(vdi_handle,'i',&w2,&ret,&ret);
	winFont.prop = (w1 != w2);

	vqt_fontinfo(vdi_handle, &min_ascii, &max_ascii, dummy1, &d, dummy3);
	if (min_ascii <= 0)
		min_ascii = 1;

	/* Alle Fenster updaten */
	do_all_window(CLASS_ALL, do_font_change);
}
