/*
 * fsel.h: basiert auf fsel_inp.c von Oliver Scheel
*/
#include "global.h"
#include "fsel.h"


/* ----- Selectric---------------------------------------------------------- */

SLCT_STR	*slct = NULL;
LONG		fsel = 0L;


BOOLEAN fsel_check(VOID)
{
	return getcookie('FSEL', &fsel);
}


BOOLEAN slct_check(UWORD version)
{
	if (fsel_check())
	{
		slct = (SLCT_STR *)fsel;
		if (slct->id != 'SLCT')
			slct = NULL;
	}
	if (slct && (slct->version >= version))
		return TRUE;
	else
		return FALSE;
}


WORD slct_morenames(WORD mode, WORD num, VOID *ptr)
{
	if (slct_check(0x0102))
	{
		slct->comm = mode;
		slct->out_count = num;
		slct->out_ptr = ptr;
		return TRUE;
	}
	else
		return FALSE;
}


WORD slct_getnum(VOID)
{
	if (slct_check(0x0102))
		return (slct->out_count);
	else
		return 0;
}

WORD slct_first(DTA *mydta, WORD attr)
{
	if (slct_check(0x0102))
		return (slct->get_first(mydta, attr));
	else
		return -32;
}


WORD slct_next(DTA *mydta)
{
	if (slct_check(0x0102))
		return (slct->get_next(mydta));
	else
		return -32;
}


WORD slct_release(VOID)
{
	if (slct_check(0x0102))
		return (slct->release_dir());
	else
		return -32;
}


/* ----- Freedom ----------------------------------------------------------- */

WORD freedom_check(VOID)
{
	if (fsel_check())
	{
		slct = (SLCT_STR *)fsel;
		if (slct->id != 'SLCT')
			slct = NULL;
	}
	if (slct && (slct->version >= 0x0200))
		return TRUE;
	else
		return FALSE;
}
