#ifndef _QED_FSEL_H_
#define _QED_FSEL_H_

#define CMD_FILES_OUT	0x01		/* return filelist */
#define CFG_ONESTRING	0x02		/* return list in one string */
#define CFG_FIRSTNEXT	0x08

/* ------------------------------------------------------------------------- */
/* ----- Selectric Structure ----------------------------------------------- */
/* ------------------------------------------------------------------------- */

typedef struct
{
	ULONG		id;						/* Selectric ID (SLCT)		*/
	UWORD		version;					/* version (BCD-Format)		*/
	struct
	{
		unsigned				: 7;		/* reserved							*/
		unsigned todaytime: 1;
		unsigned pthsav	: 1;		/* save GEMDOS paths				*/
		unsigned stdest	: 1;		/* stay in destination path	*/
		unsigned				: 1;		/* reserved							*/
		unsigned numsrt	: 1;		/* numsort 							*/
		unsigned lower		: 1;		/* use lowercase letters		*/
		unsigned dclick	: 1;		/* open folder on dclick		*/
		unsigned hidden	: 1;		/* show hidden files				*/
		unsigned bypass	: 1;		/* Selectric ON/OFF 				*/
	} config;
	WORD		sort;						/* sort-mode (neg. = rev.)	*/
	WORD		num_ext;					/* number of extensions		*/
	UBYTE		*(*ext)[];				/* preset extensions		*/
	WORD		num_paths;				/* number of paths		*/
	UBYTE		*(*paths)[];			/* preset paths			*/
	WORD		comm;						/* communication word		*/
	WORD		in_count;				/* input counter		*/
	VOID		*in_ptr;					/* input pointer		*/
	WORD		out_count;				/* output counter		*/
	VOID		*out_ptr;				/* output pointer		*/
	WORD		cdecl	(*get_first)(DTA *dta, int attrib);
	WORD		cdecl (*get_next)(DTA *dta);
	WORD		cdecl	(*release_dir)(void);
} SLCT_STR;

/* ------------------------------------------------------------------------- */


BOOLEAN	fsel_check		(VOID);
/*
 * Prft nach, ob ein FSEL-Cookie vorhanden ist.
*/

BOOLEAN	slct_check		(UWORD version);
/*
 * Checkt, ob Selectric installiert ist und ob es die Mindest-Versionsnummer 
 * besitzt.
*/

WORD	slct_morenames		(WORD mode, WORD num, VOID *str);
/*
 * Initialisiert Selectric so, da es wei, da mehr als ein Name zurckgegeben 
 * werden kann.
*/

WORD	slct_getnum			(VOID);
/*
 * Liefert die Anzahl der ausgewhlten Dateien zurck.
*/

WORD	slct_first			(DTA *mydta, WORD attr);
/*
 * Wurde das Communication-Byte auf CFG_FIRSTNEXT gesetzt, so kann man ber 
 * diese Funktion den ersten selektierten Namen mit dem entsprechenden Attribut 
 * bekommen.
*/

WORD	slct_next			(DTA *mydta);
/*
 * Nachdem man mit slct_first() den ersten Namen zurckbekommt, kann man ber 
 * diese Funktion weitere Namen erhalten.
*/

WORD 	slct_release		(VOID);
/*
 * Gibt das Verzeichnis wieder frei (Wichtig!).
*/

/* ------------------------------------------------------------------------- */
/* ----- Freedom Structure ------------------------------------------------- */
/* ------------------------------------------------------------------------- */

typedef struct
{
	LONG	magic;					/* '?Fdm' */
	WORD	id;						/* Beliebige Id */
	WORD	maxsel;					/* Maximale Anzahl von zu selektierenden Files */
	struct
	{
		unsigned fullpaths: 1;	/* volle Pfadnamen in der Antwort */
		unsigned doquote	: 1;	/* Freedom darf quoten */
		unsigned noname 	: 1;	/* keinen Appl.-Namen vor Titel */
		unsigned sysmodal	: 1;	/* System-Modal ffnen (rgs..) */
		unsigned resvd		: 28; /* reserviert (auf 0 setzen) */
	} 		flags;
	WORD	handle;					/* Enthlt nach Erfolg das Fensterhandle des 
											Fileselektors (bzw. 0 bei einem fliegenden 
											Dialog). Sinn: Das aufrufende Programm kann 
											den Fileselektor kontrollieren, indem es etwa 
											eine WIN_CLOSED-Nachricht dafr an Freedom 
											sendet, oder das Fenster in sein Window-Cycle 
											mit einbezieht.
										*/
	WORD	server;					/* Enthlt nach Erfolg die Appl.-Id des 
											Fileselektor-Servers. An ihn knnen Nachrichten
											bzgl. des Fensters 'handle' gesendet werden.
										*/
	UBYTE	path[0];					/* jetzt kommt der der Pfad.. */
} Fdm_Str;


#ifndef FILE_SELECTED
#define FILE_SELECTED	0x4560
#endif

#ifndef WIN_TOPPED
#define WIN_TOPPED		0x7A22
#endif

#ifndef WIN_CLOSED
#define WIN_CLOSED		0x7A23
#endif


WORD 	freedom_check		(VOID);
/*
 * Checkt, ob Freedom installiert ist.
*/

#endif
