#include <stdarg.h>
#include <stat.h>
#include <support.h>
#include <time.h>
#include <unistd.h>

#include "global.h"
#include "fontsel.h"
#include "obj.h"
#include "rsc.h"
#include "set.h"


/*
 * exportierte Variablen
 */
GLOBAL WORD		phys_handle;		/* Physikalisches Workstation Handle */
GLOBAL WORD		gl_apid;				/* Identifikation fr Applikation */
GLOBAL WORD		gl_wchar;			/* Je nach aktuellem Font z.B. 8*16 */
GLOBAL WORD		gl_hchar;
GLOBAL WORD		sys_wchar;			/* 8*16 */
GLOBAL WORD		sys_hchar;
GLOBAL WORD		sys_wbox;			/* 19*19 */
GLOBAL WORD		sys_hbox;
GLOBAL WORD		min_ascii;
GLOBAL WORD		max_ascii;

GLOBAL WORD		fill_color;			/* aktuell eingestellte Fllfarbe */
GLOBAL WORD		planes;				/* Anzahl der Planes */
GLOBAL WORD		gem;					/* GEM-Version */
GLOBAL WORD		magx;					/* Mag!X da */
GLOBAL BOOLEAN	gdos;					/* GDOS vorhanden? */

GLOBAL BOOLEAN	global_shift;		/* bei aktueller Opertion wurde Shift gedrckt */
GLOBAL BOOLEAN	quick_close;		/* Sichern der Texte ohne Nachfrage */
GLOBAL WORD		vdi_handle;			/* Virtuelles Workstation Handle */

GLOBAL GRECT	desk;					/* Bildschirm-Gre  z.B. 0, 19, 640, 381 */

GLOBAL BOOLEAN	done;					/* Ende gewhlt ? */
GLOBAL PATH		app_path;			/* Pfad der Applikation */

GLOBAL WORD		desire_x, return_code;
GLOBAL LONG		desire_y, undo_y;

GLOBAL UWORD	debug;

/****** DEFINES **************************************************************/

#define CTRL_CHAR 	'^'		/* Men-Control-Buchstabe */
#define ALT_CHAR		0x07		/* Men-Alternate-Buchstabe */

/****** VARIABLES ************************************************************/

LOCAL BOOLEAN 	msleep = FALSE;

LOCAL GRECT 	clip; 			/* Letztes Clipping Rechteck */
LOCAL BOOLEAN 	clip_flag;

LOCAL LONG		_idt;							/* Cookie fr Datum und Zeit */

LOCAL WORD		sysfont_height;
LOCAL WORD		sysfont_id;

/*****************************************************************************/
/* ffne virtuelle Workstation																							 */
/*****************************************************************************/
WORD open_vwork (WORD *w_out)
{
	WORD	i, handle;
	WORD	work_in[11];

	for (i = 0; i < 11; i++)
		work_in[i] = 1;
	work_in[5]	= 0;
	work_in[9]	= WHITE; 					/* Fllfarbe */
	work_in[10] = 2; 							/* Raster Koordinaten */
	handle = phys_handle;
	v_opnvwk (work_in, &handle, w_out); /* ffne virtuelle Workstation */
	return (handle);
}

/*****************************************************************************/
/* Maus-Routinen																														 */
/*****************************************************************************/
GLOBAL BOOLEAN mouse_sleeps(VOID)
{
	return msleep;
}

GLOBAL VOID sleep_mouse(VOID)
{
	if (!msleep)
	{
		msleep = TRUE;
		hide_mouse();
	}
}

GLOBAL VOID wake_mouse(VOID)
{
	if (msleep)
	{
		msleep = FALSE;
		show_mouse();
	}
}

/*
 * Maus nur dann abschalten, wenn sie innerhalb des angegebenen Rechtecks liegt
 * bzw. wenn sie nicht gerade sleep't.
*/
GLOBAL BOOLEAN hide_mouse_if_needed(GRECT *rect)
{
	GRECT		mouse = {0, 0, 63, 31};
	EVNTDATA	evd;

	if (msleep)
		return FALSE;

	graf_mkstate(&evd);
	mouse.g_x = evd.x - (mouse.g_w / 2);
	mouse.g_y = evd.y - (mouse.g_h / 2);
	if (myrc_intersect(rect, &mouse))
	{
		hide_mouse();
		return TRUE;
	}
	return FALSE;
}

/*****************************************************************************/
/* Ausgabe recht oben im Men */
VOID print_headline(UBYTE *str)
{
	GRECT	c;
		
	if (desk.g_y != 1)		/* desk.g_y = 1: Men unsichtbar unter N.AES */
	{
		WORD ret, len, width;
		
		get_clip(&c);
		set_clip(FALSE, NULL);
		vst_font (vdi_handle, sysfont_id);
		vst_height(vdi_handle, sysfont_height, &ret, &ret, &width, &ret);
		len = (short) strlen(str);
		v_gtext(vdi_handle, desk.g_w - len * width, 0, str);

		vst_font (vdi_handle, winFont.id);
		vst_point (vdi_handle, winFont.pts, &ret, &ret, &ret, &ret);
		set_clip(TRUE, &c);
	}
}


/*****************************************************************************/
LOCAL LONG		maxvalue;
LOCAL	DIALINFO	aktion_box;

VOID start_aktion(const UBYTE *head, BOOLEAN inter, LONG max_value)
{
	maxvalue = max(max_value, 1);
	fill_ptext(aktion, ATEXT, head);
	aktion[ABOX2].ob_width = 1;
	hide_objc(aktion, AESC, !inter);
	open_dial(aktion, &aktion_box);
	dial_draw(&aktion_box);
}

VOID do_aktion (LONG value)
{
	LONG max_len, help;

	max_len = aktion[ABOX1].ob_width;
	help = max((max_len * value) / maxvalue,1);
	help = min(max_len, help);
	if (aktion[ABOX2].ob_width != help)
	{
		aktion[ABOX2].ob_width = (short) help;
		draw_Objc(aktion, ABOX2, 1);
	}
}

VOID end_aktion (VOID)
{
	dial_end(&aktion_box);
}

/*****************************************************************************/
GLOBAL VOID str_upper(UBYTE *str)
{
	while (*str != EOS)
	{
		*str = nkc_toupper(*str);
		str++;
	}
}

GLOBAL VOID str_lower(UBYTE *str)
{
	while (*str != EOS)
	{
		*str = nkc_tolower(*str);
		str++;
	}
}

/*****************************************************************************/
GLOBAL BOOLEAN str_to_key(UBYTE *str, KEYDATA *key)
{
	UBYTE		c, sign, *s1, *s2;
	BOOLEAN	erg = FALSE;

	if ((str[0] == EOS) || (key == NULL))
		return FALSE;

	s1 = strrchr(str, CTRL_CHAR);
	s2 = strrchr(str, ALT_CHAR);
	if (s1 > s2)
		str = s1;
	else
		str = s2;

	if (str!=NULL && strlen(str)>=2) 		/* Sign und Buchstabe */
	{
		sign = *str++; 							/* "Vorzeichen" */
		c	  = *str;								/* Eigentliches Zeichen */
		switch (sign)
		{
			case CTRL_CHAR:
				key->kstate = K_CTRL;
				key->kreturn = 0;
				key->normkey = NKF_FUNC|NKF_CTRL|c;
				key->ascii_code = c;
				key->shift = FALSE;
				key->ctrl = TRUE;
				key->alt = FALSE;
				erg = TRUE;
				break;
			case ALT_CHAR:
				key->kstate = K_ALT;
				key->kreturn = 0;
				key->normkey = NKF_FUNC|NKF_ALT|c;
				key->ascii_code = c;
				key->shift = FALSE;
				key->ctrl = FALSE;
				key->alt = TRUE;
				erg = TRUE;
				break;
		}
	}
	return erg;
}

GLOBAL VOID norm2gem(WORD knorm, WORD *kr, WORD *ks)
{
	*kr = nkc_n2gem(knorm);
	if (knorm & NKF_SHIFT)
		*ks = K_LSHIFT;
	if (knorm & NKF_CTRL)
		*ks |= K_CTRL;
	if (knorm & NKF_ALT)
		*ks |= K_ALT;
}

GLOBAL VOID gem2key(WORD kstate, WORD kreturn, KEYDATA *key)
{
	key->kstate	= kstate;
	key->kreturn = kreturn;
	key->normkey = normkey (kstate, kreturn);
	key->normkey &= ~NKF_CAPS;				/* CAPSLOCK lschen */
	key->ascii_code = key->normkey & 0x00FF;
	key->shift = (kstate & (K_RSHIFT | K_LSHIFT)) != 0;
	key->ctrl = (kstate & K_CTRL) != 0;
	key->alt	= (kstate & K_ALT) != 0;
}

/*****************************************************************************/
BOOLEAN inside (WORD x, WORD y, CONST GRECT *r)
{
	return (x >= r->g_x && y >= r->g_y && x < r->g_x + r->g_w && y < r->g_y + r->g_h);
}

/*****************************************************************************/

BOOLEAN get_clip (GRECT *size)
{
	*size = clip;
	return clip_flag;
}

VOID set_clip (BOOLEAN clipflag, CONST GRECT *size)
{
	WORD	xy[4];

	if (!clip_flag && !clipflag) 
		return;										/* Es ist aus und bleibt aus */
	clip_flag = clipflag;
	if (clipflag)
	{
		if (size == NULL)
			clip = desk;							/* Nichts definiert, nimm Desktop */
		else
			clip = *size;							/* Benutze definierte Gre */
		rect2array(&clip, xy);
	}
	else
		clip = desk;
	vs_clip (vdi_handle, clipflag, xy);
}


/*****************************************************************************/

WORD note (WORD button, WORD index)
{
	WORD ret;

	wake_mouse();
	if (mydials_are_init)
		ret = do_alert(button, (BYTE *)alertmsg[index]);
	else
		ret = form_alert(button, (BYTE *)alertmsg[index]);
	return (ret);
}

/*****************************************************************************/

WORD fnote(WORD button, WORD index, ...)
{
	va_list 	arg;
	UBYTE		buf[128];
	
	va_start(arg, index);
	vsprintf(buf, (char *)alertmsg[index], arg);
	va_end(arg);
	
	wake_mouse();
	if (mydials_are_init)
		return do_alert(button, buf);
	else
		return form_alert(button, buf);
}

/***************************************************************************/
/* Verschiedenes																				*/
/***************************************************************************/

VOID make_shortpath(const UBYTE *path, UBYTE *shortpath, WORD maxlen)
{
	PATH	help;
	WORD	path_len;
	UBYTE	*p1, *p2;

	strcpy(help,path);
	path_len = (short) strlen(help);
	if (maxlen < 18)
	{
		file_name(path,help, FALSE);
	}
	else if (path_len>maxlen)
	{
		p1 = strchr(help,'\\');
		p2 = p1;
		path_len += 2; 	/* zwei Punkte neu */
		while(*p2!=EOS && path_len>maxlen)
		{
			p2++;
			while(*p2!='\\' && *p2!=EOS)
			{
				p2++;
				path_len--;
			}
		}
		if (*p2!=EOS)
		{
			memmove(p1+3, p2, (short)strlen(p2)+1);
			p1[1] = '.';
			p1[2] = '.';
		}
		else
		{
			p2 = strrchr(help,'\\');
			memmove(help, p2, (short)strlen(p2)+1);
		}
	}
	strcpy(shortpath,help);
}

/* Macht aus allem einen kompletten Pfad			*/
/* evtl. vorhandene Dateinamen bleiben erhalten */
/* with_filename = hat ganz sicher Dateinamen	*/
BOOLEAN make_normalpath(UBYTE *path, BOOLEAN with_filename)
{
	WORD	i;
	PATH	p;
	UBYTE	*f, drv;

	if (path[0] == EOS)
		return FALSE;

	if (strchr(path, '/') != NULL)	/* UNIX-Pfad */
	{
		unx2dos(path, p);
		strcpy(path, p);
	}

	/* Laufwerk bestimmen */
	if (path[1] != ':') 					/* Kein Laufwerk */
	{
		drv = 'A' + Dgetdrv();			/* aktuelles Laufwerk */
		if (drv > 'Z')
			drv = drv - 'Z' + '0';		/* A..Z 1..6 */
		f = path;
	}
	else
	{
		path[0] = nkc_toupper(path[0]);
 		drv = path[0];
		if (drv > 'Z')
			drv = drv - 'Z' + '0';	/* A..Z 1..6 */
 		f = path + 2;
	}
	/* Pfad mit Laufwerk bestimmen */
	if (f[0]=='.' && (f[1]=='\\' || f[1]==EOS))
	{
		get_path(p, drv); 		/* aktuellen Pfad nehmen */
		if (f[1]=='\\') strcat(p,f+2);
	}
	else if (f[0]!='\\') 			/* Keine Root */
	{
		get_path(p, drv);
		strcat (p, f);
	}
	else
	{
		p[0] = drv;
		p[1] = ':';
		p[2] = EOS;
		strcat (p, f);
	}
	if (!with_filename)			/* herausbekommen ob Dateiname */
	{
		i = (short) strlen(p);
		if (p[i-1]!='\\')
		{
			p[i] = '\\';
			p[i+1] = EOS;
		}
		if (!path_exist(p))
			p[i] = EOS;
	}
	strcpy(path,p);
	return TRUE;
} /* make_normalpath */

VOID make_ext(UBYTE *fullname, const UBYTE *ext)
{
	UBYTE	*ptr;

	ptr = strrchr(fullname,'.');
	if (ptr == NULL || ptr < strrchr(fullname,'\\'))
	{
		ptr = fullname + strlen(fullname);
		*ptr = '.';
	}
	if (caseSens(fullname, NULL))
		strcpy(ptr+1, ext);
	else
	{
		UBYTE	myext[5];

		strcpy(myext, ext);
		str_upper(myext);
		strcpy(ptr+1, myext);
	}
}

VOID file_name(const UBYTE *fullname, UBYTE *filename, BOOLEAN withoutExt)
{
	file_splitt(fullname, NULL, filename);
	if (withoutExt)
	{
		UBYTE	*p;

		p = strrchr(filename, '.');
		if (p != NULL)
			*p = EOS;
	}
}

VOID file_splitt(const UBYTE *fullname, UBYTE *path, UBYTE *name)
{
	UBYTE	 *str;

	str = strrchr (fullname, '\\');

	if (path != NULL)
		path[0] = EOS;		/* schadet nix */
	if (name != NULL)
		name[0] = EOS;		/* ditto */

	if (str != NULL)
	{
		/* Dateinamen holen */
		if (name != NULL)
			strcpy(name, str+1);

		/* Pfad mit Laufwerk bestimmen */
		if (path != NULL)
		{
			WORD len =  (short)( str - (UBYTE *)fullname + 1);
			strncpy(path, fullname, len);
			path[len] = EOS;
		}
	}
} /* file_split */

/*****************************************************************************/

WORD get_first_drive(VOID)
{
	ULONG	drives;
	WORD	drive;

	drives = Dsetdrv(Dgetdrv());					/* Alle Laufwerke */
	if (drives == 0)
		drive = -1;
	else if (drives <= 3)
		drive = 0;										/* Benutze Laufwerk A */
	else
	{
		drives >>= 2;
		drive = 2;										/* Beginne bei Laufwerk C */
		while (!(drives & 1) && drive < 32)    /* Laufwerk gefunden */
		{
			drive++;
			drives >>= 1;
		}
	}
	return drive;
}


/*****************************************************************************/

BOOLEAN get_path (UBYTE *path, UBYTE drive)
{
	WORD ret, drive_nr;

	if (drive == 0)
	{
		drive = 'A' + Dgetdrv();					/* Aktuelles Laufwerk */
		if (drive > 'Z')
			drive = drive - 'Z' + '0';
	}
	else
		drive = nkc_toupper(drive);
	if (drive >= '1' && drive <= '6')			/* Laufwerk nach Z mit Big-DOS oder MetaDOS > 2.60 */
		drive_nr = drive - '1' + 26;
	else
		drive_nr = drive - 'A';
	path[0] = drive;
	path[1] = ':';
	ret = Dgetpath (path + 2, drive_nr + 1);
	strcat (path, "\\");
	return (ret == 0);
} /* get_path */


BOOLEAN set_path(UBYTE *path)
{
	WORD	drive, ret;

	if (path[0] == EOS)
		return FALSE;

	path[0] = nkc_toupper(path[0]);
	if (path[0] >= '1' && path[0] <= '6')
		drive = path[0] - '1' + 26;
	else
		drive = path[0] - 'A';
	Dsetdrv(drive);
	ret = Dsetpath(path + 2);
	return (ret == 0);
}

/*****************************************************************************/
LOCAL VOID make_date(struct tm *stime, UBYTE *date)
{
	if (date != NULL)
	{
		switch ((UWORD)_idt & 0xF00)					/* Reihenfolge im Datum */
		{
			case 0x000:  /* MM/DD/YYYY */
				strftime(date, 11, "%m/%d/%Y", stime);
				break;
			case 0x100:  /* DD.MM.YYYY */
				strftime(date, 11, "%d.%m.%Y", stime);
				break;
			default:  /* YYYY-MM-DD */
				strftime(date, 11, "%Y-%m-%d", stime);
				break;
		}
	}
}
/*****************************************************************************/

VOID get_datum(UBYTE *date)
{
	time_t		ttime;
	struct tm	*stime;

	time(&ttime);
	stime = localtime(&ttime);
	make_date(stime, date);
}

/*****************************************************************************/

LONG file_time(const UBYTE *filename, UBYTE *date, UBYTE *time)
{
	struct stat	s;
		
	if (stat(filename, &s) == 0)
	{
		struct tm	*stime;

		stime = localtime(&s.st_mtime);
		if (time != NULL)
			strftime(time, 9, "%H:%M:%S", stime);
		if (date != NULL)
			make_date(stime, date);
		return s.st_mtime;
	}
	else
		return 0;
}

/*****************************************************************************/
LONG file_size(const UBYTE *filename)
{
	struct stat	s;
	
	if (stat(filename, &s) == 0)
		return s.st_size;
	else
		return 0;
}

/*****************************************************************************/
BOOLEAN file_exist (const UBYTE *filename)
{
	struct stat	s;
	
	return (stat(filename, &s) == 0);
}

/*****************************************************************************/
BOOLEAN file_readonly (const UBYTE *filename)
{
	struct stat	s;
	BOOLEAN		ret = FALSE;
	
	if (stat(filename, &s) == 0)
	{
		WORD	uid, gid;

		uid = getuid();
		gid = getgid();
		if (((uid == s.st_uid) && ((s.st_mode & S_IWUSR) != 0)) ||	
				/* Besitzer hat Schreibrecht */
		   
		  	 ((gid == s.st_gid) && ((s.st_mode & S_IWGRP) != 0)) ||	
		  	 	/* Gruppe hat Schreibrecht */
		    
		    (((s.st_mode & S_IWOTH) != 0))	||								
		    	/* Welt hat Schreibrecht */
		    
		    ((uid == 0) && ((s.st_mode & S_IWUSR) != 0)))				
		    	/* root darf, wenn Owner darf */
			ret = FALSE;
		else
			ret = TRUE;
	}
	return ret;
}

/*****************************************************************************/
BOOLEAN path_exist(const UBYTE *pathname)
{
	struct stat	s;
	
	return ((stat(pathname, &s) == 0) && S_ISDIR(s.st_mode));
}

/*****************************************************************************/
GLOBAL WORD longName(UBYTE *filename)
{
	PATH	path;
	LONG	ret;

	/* eigentlichen Dateinamen abschneiden und durch '.' ersetzen -
		mu sein, da Datei evtl. noch nicht existiert... */
	file_splitt(filename, path, NULL);
	strcat(path, ".");
	ret = Dpathconf(path, 3);
	if ((ret < 0) || (ret == 12))
		ret = 0;
	return (WORD) ret;
}

/*****************************************************************************/
GLOBAL BOOLEAN caseSens(UBYTE *filename, WORD *val)
{
	PATH	path;
	LONG	ret;

	/* Eigentlichen Dateinamen abschneiden und durch '.' ersetzen -
		mu sein, da Datei evtl. noch nicht existiert... */
	file_splitt(filename, path, NULL) ;
	strcat(path, ".") ;
	ret = Dpathconf(path, 6);

	if (val != NULL)
		*val = (WORD) ret;
	/*
	 * ret = 2 tritt dann auf, wenn zwischen Gro/Klein nicht unterschieden
	 * wird, man aber Gro/Klein im Namen verwenden kann -> MacFS.
	 */
	return (ret == 0 || ret == 2);
}

/***************************************************************************/
/* Initialisieren des Moduls																*/
/***************************************************************************/
GLOBAL VOID init_global (VOID)
{
	WORD	work_out[57];
	WORD	ret, f_anz;

	phys_handle = graf_handle (&sys_wchar, &sys_hchar, &sys_wbox, &sys_hbox);
	wind_get_grect(0, WF_WORKXYWH, &desk);

	gdos = vq_gdos();
	done = FALSE;
	fill_color = WHITE;
	clip_flag = TRUE;

	vdi_handle = open_vwork(work_out);
	f_anz = work_out[10];
	vq_extnd (vdi_handle, TRUE, work_out);
	planes = work_out[4];

	if (gdos)
		f_anz += vst_load_fonts (vdi_handle, 0);

	vswr_mode(vdi_handle, MD_REPLACE);
	vsl_color (vdi_handle, BLACK);
	vsl_ends (vdi_handle, SQUARED, SQUARED);
	vsl_width (vdi_handle, 1);
	vst_alignment(vdi_handle, TA_LEFT, TA_TOP, &ret, &ret);

	get_sysfnt(&sysfont_id, &sysfont_height, NULL, NULL);
	winFont.id = 1;
	winFont.pts = 10;
	font_change();

	if (!getcookie('_IDT', &_idt))				/* Format fr Datum und Zeit */
		_idt = 0x0000112E;							/* DD.MM.YYYY HH:MM:SS */
}

/************************************************************************/
/* Terminieren des Moduls																*/
/************************************************************************/
GLOBAL VOID term_global(VOID)
{
	if (gdos)
		vst_unload_fonts (vdi_handle, 0);
	v_clsvwk(vdi_handle);
}
