#ifndef _qed_global_h_
#define _qed_global_h_

#include <macros.h>
#include <mintbind.h>
#include <md_small.h>
#include <osbind.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#ifndef __MINT__
#error qed benutzt ab Version 4 die MiNT-Lib!!
#endif

#include "types.h"


#define	ltoa(a,b,c)	_ltoa(a,b,c)
#define	itoa(a,b,c)	_itoa(a,b,c)

/****** Defines ***************************************************************/

#ifndef TA_LEFT						/* text alignment */
#define TA_LEFT			0
#define TA_ASCENT			2
#define TA_TOP				5
#endif

#ifndef SC_CHANGED
#define SC_CHANGED		80			/* AES-Message: Klemmbrett wurde verndert */
#endif

#define DTA					_DTA		/* Warum mit '_' in MiNT-Lib?? */

#define TIMER_INTERVALL	500L		/* Pollzeit fr Timerevent */


/****** global Variablen ******************************************************/

EXTERN WORD		phys_handle;		/* Physikalisches Workstation Handle */
EXTERN WORD		gl_apid;				/* Identifikation fr Applikation */
EXTERN WORD		gl_wchar;			/* Je nach aktuellem Font z.B. 8*16 */
EXTERN WORD		gl_hchar;
EXTERN WORD		sys_wchar;			/* 8*16 */
EXTERN WORD		sys_hchar;
EXTERN WORD		sys_wbox;			/* 19*19 */
EXTERN WORD		sys_hbox;
EXTERN WORD		min_ascii;			/* ... des Fensterfonts */
EXTERN WORD		max_ascii;

EXTERN WORD		fill_color;			/* aktuell eingestellte Fllfarbe */
EXTERN WORD		planes;				/* Anzahl der Planes */
EXTERN WORD		gem;					/* GEM-Version */
EXTERN WORD		__mint;				/* MiNT aktiv? -> MiNT-Lib */
EXTERN WORD 	magx;					/* MagiC da (>0) -> Version */
EXTERN BOOLEAN	gdos;					/* GDOS vorhanden? */

EXTERN BOOLEAN	global_shift;		/* bei aktueller Opertion wurde Shift gedrckt */
EXTERN BOOLEAN	quick_close;		/* Sichern der Texte ohne Nachfrage */
EXTERN WORD		vdi_handle;			/* Virtuelles Workstation Handle */

EXTERN GRECT	desk;					/* Bildschirm-Gre  0, 19, 1280, 951 */

EXTERN BOOLEAN	done;					/* Ende gewhlt ? */
EXTERN PATH		app_path;			/* Pfad der Applikation */

EXTERN WORD		desire_x, return_code;
EXTERN LONG		desire_y, undo_y;


/****** FUNCTIONS ************************************************************/

EXTERN WORD 		open_vwork		(WORD *w_out);

EXTERN BOOLEAN		mouse_sleeps			(VOID);
EXTERN VOID			sleep_mouse 			(VOID);
EXTERN VOID			wake_mouse				(VOID);
EXTERN BOOLEAN		hide_mouse_if_needed	(GRECT *rect);

EXTERN VOID			print_headline		(UBYTE *str);

EXTERN VOID			start_aktion		(CONST UBYTE *head, BOOLEAN inter, LONG max);
EXTERN VOID			do_aktion			(LONG value);
EXTERN VOID			end_aktion			(VOID);

EXTERN VOID			str_upper			(UBYTE *str);
EXTERN VOID			str_lower			(UBYTE *str);

EXTERN BOOLEAN		str_to_key			(UBYTE *str, KEYDATA *key);

EXTERN BOOLEAN		inside				(WORD x, WORD y, CONST GRECT *r);

EXTERN BOOLEAN		get_clip				(GRECT *size);
EXTERN VOID			set_clip				(BOOLEAN	 flag, CONST GRECT *size);

EXTERN WORD			note					(WORD button, WORD index);
EXTERN WORD			fnote					(WORD button, WORD index, ...);

EXTERN VOID			make_shortpath		(CONST UBYTE *path, UBYTE *shortpath, WORD maxlen);
EXTERN BOOLEAN		make_normalpath	(UBYTE *path, BOOLEAN with_filename);
EXTERN VOID			make_ext				(UBYTE *fullname, CONST UBYTE *ext);
EXTERN VOID			get_datum			(UBYTE *date);
EXTERN long			file_time			(CONST UBYTE *filename, UBYTE *date, UBYTE *time);
EXTERN long			file_size			(CONST UBYTE *filename);
EXTERN VOID			file_name			(CONST UBYTE *fullname, UBYTE *filename, BOOLEAN withoutExt);
EXTERN VOID	 		file_splitt 		(CONST UBYTE *fullname, UBYTE *path, UBYTE *name);
EXTERN WORD			get_first_drive	(VOID);
EXTERN VOID 		drive_name			(WORD drive, UBYTE *name);
EXTERN VOID			get_drive_space	(WORD drive, ULONG *total, ULONG *free);
EXTERN BOOLEAN		get_path				(UBYTE *path, UBYTE drive);
EXTERN BOOLEAN		set_path				(UBYTE *path);
EXTERN BOOLEAN		file_exist			(CONST UBYTE *filename);
EXTERN BOOLEAN		file_readonly		(CONST UBYTE *filename);
EXTERN BOOLEAN		path_exist			(CONST UBYTE *pathname);
EXTERN WORD			longName				(UBYTE *filename);
EXTERN BOOLEAN		caseSens				(UBYTE *filename, WORD *val);

EXTERN VOID 		gem2key				(WORD kstate, WORD kreturn, KEYDATA *key);
EXTERN VOID 		norm2gem				(WORD knorm, WORD *kr, WORD *ks);

EXTERN VOID			init_global			(VOID);
EXTERN VOID			term_global			(VOID);


/* Debugging */
#define DBG_GEN	1			/* generell */
#define DBG_ARG	2			/* argv */
#define DBG_INIT	4			/* init_* */
#define DBG_AV		8			/* AV-Protokoll */
#define DBG_SE		16			/* SE-Protokoll */

EXTERN UWORD		debug;

EXTERN VOID			Debug					(UBYTE *FormatString, ...);
EXTERN VOID 		StopIt				(BOOLEAN start);
 
#endif
