#include "global.h"
#include "rsc.h"
#include "set.h"
#include "window.h"
#include "icon.h"

/*****************************************************************/

#define	MAX_TYPE_ANZ	10

/* ============================================================== */

typedef struct
{
	VOID		(*exist)(WORD obj_nr, SET actions);
	BOOLEAN	(*test)(WORD obj_nr, WORD action);
	WORD		(*edit)(WORD obj_nr, WORD action);
	BOOLEAN	(*drag)(WORD obj_nr, WORD dest_obj);
} ICON_TYPE;

typedef ICON_TYPE *TYPEP;

typedef struct
{
	WORD	icon;
	WORD	type_id;
} ICON_TO_TYPE;
typedef ICON_TO_TYPE *I2T;

LOCAL ICON_TYPE	icon[MAX_TYPE_ANZ];
LOCAL ICON_TO_TYPE	i2t[MAX_ICON_ANZ];
LOCAL WORD		type_anz = 0;

/* ============================================================== */

LOCAL TYPEP search_type(WORD obj_nr)
{
	WORD	i;
	I2T	ic;

	obj_nr &= (~SUB_ICON);
	for (ic=i2t,i=MAX_ICON_ANZ; (--i)>=0; ic++)
		if (ic->icon==obj_nr)
			return(icon+ic->type_id);
	return(NULL);
}

WORD all_icons(WORD *c)
{
	I2T	ic;
	WORD	i, anz;

	ic = i2t;
	for (i=MAX_ICON_ANZ, anz=0; (--i)>=0; ic++)
		if (ic->icon!=-1)
		{
			*c++ = ic->icon;
			anz++;
		}
	return anz;
}

/* <0 : Fehler bei der Ausfhrung	*/
/*	=0 : Nicht mglich					*/
/* >0 : Erfolgreich ausgefhrt		*/
WORD do_icon(WORD icon, WORD action)
{
	TYPEP	t;

	t = search_type(icon);
	if (t!=NULL && (t->test)(icon,action))
		return (t->edit)(icon,action);
	return 0;
}

VOID do_all_icon(WORD type_id, WORD action)
{
	I2T	ic;
	WORD	i;

	ic = i2t;
	for (i=MAX_ICON_ANZ; (--i)>=0; ic++)
		if (ic->icon!=-1 && (ic->type_id==type_id || type_id==ALL_TYPES))
		{
			do_icon(ic->icon, action);
		}
}

BOOLEAN Icon_test(WORD icon, WORD action)
{
	TYPEP	t;

	t = search_type(icon);
	if (t!=NULL)
		return (t->test)(icon,action);
	return FALSE;
}

WORD Icon_edit(WORD icon, WORD action)
{
	TYPEP	t;

	t = search_type(icon);
	if (t!=NULL)
		return (t->edit)(icon,action);
	return 0;
}

VOID Icon_exist(WORD icon, SET actions)
{
	TYPEP	t;

	t = search_type(icon);
	if (t==NULL || t->exist==NULL)
		setclr(actions);
	else (t->exist)(icon,actions);
}

BOOLEAN Icon_drag(WORD dest_obj, WORD src_obj)
{
	TYPEP	t;

	t = search_type(dest_obj);						/* Ziel-Icon */
	if (t==NULL || t->drag==NULL) return FALSE;
	return((t->drag)(dest_obj,src_obj));
}

WORD decl_icon_type(BOOLEAN(*test)(WORD,WORD),
						 WORD(*edit)(WORD,WORD),
						 VOID(*exist)(WORD,SET),
						 BOOLEAN(*drag)(WORD,WORD))
{
	TYPEP	t;

	if (type_anz==MAX_TYPE_ANZ)
		fnote(1,FATALERR,12);
	t = icon+type_anz;
	t->exist	= exist;
	t->test	= test;
	t->edit	= edit;
	t->drag	= drag;
	type_anz++;
	return (type_anz-1);
}

BOOLEAN add_icon(WORD type_id, WORD obj_nr)
{
	WORD	i;
	I2T	ic;

	ic = i2t;
	for (i=MAX_ICON_ANZ; (--i)>=0; ic++)
		if (ic->icon==-1)
		{
			ic->icon = obj_nr;
			ic->type_id = type_id;
			return TRUE;
		}
	return FALSE;
}

VOID del_icon(WORD obj_nr)
{
	I2T	ic;
	WORD	i;

	ic = i2t;
	for (i=MAX_ICON_ANZ; (--i)>=0; ic++)
		if (ic->icon==obj_nr)
		{
			ic->icon = -1;
			return;
		}
	fnote(1,FATALERR,1);
}

WORD icon_anz(WORD type_id)
{
	I2T	ic;
	WORD	i, anz;

	anz = 0;
	ic = i2t;
	for (i=MAX_ICON_ANZ; (--i)>=0; ic++)
		if (ic->type_id==type_id || type_id==ALL_TYPES)
			anz++;
	return anz;
}

VOID init_icon(VOID)
{
	WORD	i;
	I2T	ic = i2t;

	for (i=MAX_ICON_ANZ; (--i)>=0; ic++)
		ic->icon = -1;
}
