
#include "global.h"
#include "edit.h"
#include "file.h"
#include "icon.h"
#include "memory.h"
#include "menu.h"
#include "obj.h"
#include "options.h"
#include "rsc.h"
#include "tasten.h"
#include "text.h"
#include "window.h"
#include "kurzel.h"

/*
 * Exportierte Variablen
 */
BOOLEAN	krz_loaded;

/**************************************************************************/


#define MNAME_LEN		15
#define KRZ_MAX_LEN	8

typedef struct
{
	UBYTE	name[MNAME_LEN+1];
	PATH	file;
	LONG	y;
	WORD	x;
}MARKE, *MARKEP;

#define KRZ_LEN(col)	(TEXT(col)[0])
#define KRZ_TXT(col)	(TEXT(col)+1)
#define ERSATZ(col)	(TEXT(col)+1+KRZ_MAX_LEN+1)

LOCAL RING		kurz;
/* Sortierte Zeilen 																*/
/* Am Anfang in umgedrehter Reihenfolge die Zeichen 					*/
/* des Krzel als Null-Terminierender String							 	*/
/* davor noch die lnge des Krzel (Pascalhnlich)						*/
/* 0 Krzellnge, 1-9 Krzel, ab der 10 Position der Ersatzstring	*/
LOCAL RING	auto_kurz;

LOCAL MARKE	Marken[MARKEN_ANZ];

LOCAL PATH	krz_name;	/* Name der aktuellen Krzeldatei, oder leer */

/***************************************************************************/
LOCAL VOID	go_to_marke(WORD nr);

LOCAL WORD  load_kurzel	(VOID);
LOCAL VOID 	clr_kurzel	(VOID);
LOCAL WORD  add_kurzel	(ZEILEP col);

/***************************************************************************/

GLOBAL BOOLEAN goto_line_dial (VOID)
{
	WORD	antw;
	UBYTE	s[12];

	objc_setstring(pos, GZEILE, "");
	objc_setstring(pos, GSPALTE, "");
	antw =handle_dial(pos, GZEILE);
	if (antw == GOK)
	{
		objc_getstring(pos, GZEILE, s);
		if (s[0] != EOS)
			desire_y = atol(s) - 1;
		else
			desire_y = 0L;
		objc_getstring(pos, GSPALTE, s);
		if (s[0] != EOS)
			desire_x = atoi(s) - 1;
		else
			desire_x = 0;
		return TRUE;
	}
	return FALSE;
}

/***************************************************************************/
/* Verwaltung der Marken																	*/
/***************************************************************************/

GLOBAL VOID del_marke(WORD nr)
{
	MARKEP	m;
	UBYTE		*str;
	WORD		len;

	if (nr >= 0 && nr < MARKEN_ANZ)
	{
		m = Marken + nr;
		m->file[0] = EOS;
		m->name[0] = EOS;
		str = menu[MMARKE1+nr].ob_spec.free_string + 5;
		len = MNAME_LEN;
		while ((--len)>=0)
			*str++ = ' ';
	}
}

GLOBAL VOID set_marke(WORD nr, CONST UBYTE *name, PATH file, LONG y, WORD x)
{
	MARKEP	m;

	if (nr >= 0 && nr < MARKEN_ANZ)
	{
		m = Marken + nr;
		m->x = x;
		m->y = y;
		strncpy(m->name, name, MNAME_LEN);
		strcpy(m->file, file);
		fillup_menu(MMARKE1 + nr, name, 5);
	}
}

GLOBAL BOOLEAN get_marke(WORD nr, UBYTE *name, PATH file, LONG *y, WORD *x)
{
	file[0] = EOS;
	if (nr >= 0 && nr < MARKEN_ANZ)
	{
		MARKEP	m;

		m = Marken+nr;
		*x = m->x;
		*y = m->y;
		strcpy(name,m->name);
		strcpy(file,m->file);
	}
	return (file[0] != EOS);
}

GLOBAL VOID init_marken(VOID)
{
	WORD		i;
	MARKEP	m;

	for (i = MARKEN_ANZ, m = Marken; (--i)>=0; m++)
	{
		m->file[0] = EOS;
		m->name[0] = EOS;
	}
	init_textring(&kurz);
	init_textring(&auto_kurz);
}

GLOBAL VOID goto_marke(WORD nr)
{
	PATH	file;
	UBYTE	name[12];
	LONG	y;
	WORD	x, icon;

	if (global_shift)
		del_marke(nr);
	else
	{
		get_marke(nr,name,file,&y,&x);
		if (file[0]!=EOS)
		{
			icon = still_loaded(file);
			if (icon<0)
				icon = load_edit(file, FALSE);
			if (icon>=0)
			{
				if (do_icon(icon, DO_OPEN) < 0)
					note(1, NOWINDOW);
				desire_y = y;
				desire_x = x;
				Icon_edit(icon,DO_GOTO);
			}
		}
	}
}

GLOBAL VOID config_marken(TEXTP t_ptr)
{
	WORD	antw;
	PATH	file;
	UBYTE	name[14];
	LONG	y;
	WORD	x, i;

	select_objc(marken, MRK1, TRUE);
	for (i = 1; i < MARKEN_ANZ; i++)
		select_objc(marken, MRK1+i, FALSE);
	for (i=0; i < MARKEN_ANZ; i++)
	{
		get_marke(i, name, file, &y, &x);
		objc_setstring(marken, MRKTXT1+i, name);
	}
	antw = handle_dial(marken, MRKTXT1);
	if (antw == MRKOK)
	{
		for (i = 0; i < MARKEN_ANZ; i++)
			if (get_select(marken,MRK1+i))
				break;
		objc_getstring(marken, MRKTXT1+i, name);
		if (name[0] == EOS)
			file_name(t_ptr->filename, name, FALSE);
		set_marke(i, name, t_ptr->filename, t_ptr->ypos, t_ptr->xpos);
	}
}

/***************************************************************************/
/* Verwaltung der Krzel																	*/
/***************************************************************************/


VOID clr_kurzel(VOID)
{
	free_textring(&kurz);
	free_textring(&auto_kurz);
	krz_loaded = FALSE;
}

VOID do_kurzel(TEXTP t_ptr, BOOLEAN online)
{
	BOOLEAN	set_pos, save_insert;
	WORD		xw, i, len;
	UBYTE		*str, buffer[KRZ_MAX_LEN+1];
	ZEILEP		col;
	RINGP		k;

	if (online)
		k = &auto_kurz;
	else
		k = &kurz;

	if (ist_leer(k))
		return;

	xw = t_ptr->xpos;
	if (xw == 0)
		return;
	str = TEXT(t_ptr->cursor_line)+xw;
	i = 0;
	len = min(xw,KRZ_MAX_LEN);
	while (len>0)														/* umdrehen */
	{
		buffer[i++] = *(--str);
		len--;
	}
	buffer[i] = EOS;													/* abschliessen */

	/* longest Match */
	for (col=FIRST(k); TRUE; NEXT(col))
	{
		if (IS_TAIL(col))
		{
			if (!online)			/* wenn man Auto-Krzel hat, pings sonst bei */
				mybeep();			/* jedem Zeichen, das kein Krzel ist! */
			return;
		}
		len = strncmp(buffer,KRZ_TXT(col),KRZ_LEN(col));
		if (len == 0)
			break;
		if (len > 0)
		{
			if (!online)			/* dito. */
				mybeep();
			return;
		}
	}

	/*
	 * Damit whrend der Krzelexpandierung NICHT automatisch
	 * eingerckt wird, merken wir uns die Einstellung und schalten es ab!
	 * Krzel, die mehrzeilig sind und mit Blanks/TABs beginnen, erscheinen
	 * sonst nicht korrekt.
	*/
	save_insert = t_ptr->loc_opt->einruecken;
	t_ptr->loc_opt->einruecken = FALSE;

	len = KRZ_LEN(col);
	if (overwrite)
		while ((--len)>=0) char_left(t_ptr);
	else
		while ((--len)>=0) char_bs(t_ptr);
	str = ERSATZ(col);
	set_pos = FALSE;
	for (i=col->len-(KRZ_MAX_LEN+2); (--i)>=0; )
	{
		if (*str == '^' && i > 0 && str[1] == '^')
		{
			char_cr(t_ptr);
			restore_edit();						/* sonst entstehen komische Effekte */
			xw++;
			str++;
			i--;
		}
		else if (*str!='~' || set_pos)		/* das erste '~'-Zeichen zhlt */
		{
			char_insert(t_ptr, *str);
			xw++;
		}
		else
		{
			set_pos = TRUE;
			xw = 0;
		}
		str++;
	}
	if (set_pos)
		while ((--xw)>=0) char_left(t_ptr);

	/*
	 * Und wieder herstellen
	*/
	t_ptr->loc_opt->einruecken = save_insert;
}

/* return 1 : kein Speicher mehr => abbruch */
/*        0 : alles ok                      */
WORD add_kurzel(ZEILEP col)
{
	WORD		len, i;
	UBYTE		*str, buffer[260], *start;
	ZEILEP		c;
	BOOLEAN	online;

	krz_loaded = TRUE;
	if (col->len<2)
		return(0);
	if (col->len > MAX_LINE_LEN - KRZ_MAX_LEN)
		return(0);
	if (!ist_mem_frei())
		return (1);
	start = strchr(TEXT(col),'=');					/* start zeigt auf Ersatztext */
	if (start==NULL)
		return(0);
	start++;
	/* WS am Anfang berspringen */
	for (str=TEXT(col); *str==' ' || *str=='\t'; str++) ;
	if (str[0]=='#' || str[0]=='=' ||
	    (str[0]=='*' && str[1]=='='))
		return(0);									/* Kommentarzeile oder kein Kurzel */
	len = 0;
	while (len<KRZ_MAX_LEN && *str!=' ' && *str!='\t' && *str!='=')	/* Ende suchen */
	{
		len++; str++;
	}
	if (start[-2]=='*')									/* auto. Krzel */
	{
		online = TRUE;
		if (*str=='=')
		{
			str--;
			len--;
		}
	}
	else
		online = FALSE;
	buffer[0] = len;										/* vorne Lnge */
	i = 1;
	while (len>0)											/* umdrehen */
	{
		buffer[i++] = *(--str);
		len--;
	}
	buffer[i] = EOS;										/* abschliessen */
	len = (short) strlen(start);
	memcpy(buffer + KRZ_MAX_LEN + 2, start, len);
	len += (KRZ_MAX_LEN+2);

	c = FIRST(&kurz);
	if (ist_leer(&kurz))
		INSERT(&c,0,len,buffer);
	else
	{
		while (!IS_TAIL(c) && strcmp(KRZ_TXT(c),buffer+1)>0)
			NEXT(c);
		col_insert(c->vorg,new_col(buffer,len));
		kurz.lines++;
	}
	if (online)
	{
		c = FIRST(&auto_kurz);
		if (ist_leer(&auto_kurz))
			INSERT(&c,0,len,buffer);
		else
		{
			while (!IS_TAIL(c) && strcmp(KRZ_TXT(c),buffer+1)>0)
				NEXT(c);
			col_insert(c->vorg,new_col(buffer,len));
			auto_kurz.lines++;
		}
	}
	return(0);
}

WORD load_kurzel(VOID)
{
	LONG			anz;
	RING			t;
	ZEILEP		lauf;
	WORD			erg;

	if (krz_name[0] == EOS)
		return 0;

	erg = 1;
	init_textring(&t);
	if (load_datei(krz_name, &t, FALSE, NULL) == 0)
	{
		anz = t.lines;
		lauf = FIRST(&t);
		if (anz)
		{
			clr_kurzel();							/* alte Krzel lschen */
			while ((--anz)>=0)
			{
				if (add_kurzel(lauf)) 
					break;
				NEXT(lauf);
			}
		}
		erg = 0;
	}
	kill_textring(&t);
	return erg;
}

VOID	ch_kurzel(CONST UBYTE *name, BOOLEAN force_load)
{
	if (name[0] == EOS)
	{
		clr_kurzel();
		krz_name[0] = EOS;
		return;
	}
	if ((strcmp(name, krz_name) != 0) || (force_load))
	{
		strcpy(krz_name, name);
		load_kurzel();
	}
}
