#ifndef _qed_memory_h_
#define _qed_memory_h_

#define MAX_LINE_LEN	1023

#define TEXT(x)		((UBYTE *)(x) + sizeof(ZEILE))
#define NEXT(x)		(x=x->nachf)
#define VORG(x)		(x=x->vorg)
#define FIRST(x)		((x)->head.nachf)
#define LAST(x)		((x)->tail.vorg)
#define IS_FIRST(x)	((x->vorg->info&HEAD)!=0)
#define IS_LAST(x)	((x->nachf->info&TAIL)!=0)

/* ZEILE->info */
#define MARKED				1
#define HEAD				2
#define TAIL				4
#define ABSATZ				8
#define OVERLEN			16

#define IS_MARKED(x)		((x->info&MARKED)!=0)
#define IS_HEAD(x)		((x->info&HEAD)!=0)
#define IS_TAIL(x)		((x->info&TAIL)!=0)
#define IS_ABSATZ(x)		((x->info&ABSATZ)!=0)
#define IS_OVERLEN(x)	((x->info&OVERLEN)!=0)


EXTERN ZEILEP 	new_col			(CONST UBYTE *str, WORD l);
EXTERN VOID		free_col			(ZEILEP col);
EXTERN ZEILEP	col_insert		(ZEILEP wo, ZEILEP was);
EXTERN VOID		col_append		(RINGP t, ZEILEP was);
EXTERN VOID		col_delete		(RINGP t, ZEILEP was);

EXTERN VOID		col_concate		(ZEILEP *wo);
EXTERN VOID		col_split		(ZEILEP *col,WORD pos);
EXTERN WORD		col_offset		(ZEILEP col);
EXTERN WORD		col_einrucken	(ZEILEP *col);

EXTERN VOID		INSERT			(ZEILEP *a, WORD pos, WORD delta, CONST UBYTE *str);
EXTERN UBYTE	*REALLOC			(ZEILEP *a, WORD pos, WORD delta);
EXTERN ZEILEP 	get_line			(RINGP r, LONG y);

EXTERN VOID		init_textring	(RINGP r);
EXTERN LONG		textring_bytes	(RINGP r);
EXTERN VOID		free_textring	(RINGP r);
EXTERN VOID		kill_textring	(RINGP r);
EXTERN BOOLEAN	doppeln			(RINGP old, RINGP new);
EXTERN BOOLEAN	ist_leer			(RINGP r);

EXTERN BOOLEAN	ist_mem_frei	(VOID);
EXTERN VOID		init_memory		(VOID);
EXTERN VOID		kill_memory		(VOID);

#endif
