#include <errno.h>

#include "global.h"
#include "av.h"
#include "block.h"
#include "clipbrd.h"
#include "edit.h"
#include "error.h"
#include "file.h"
#include "find.h"
#include "fontsel.h"
#include "icon.h"
#include "kurzel.h"
#include "makro.h"
#include "memory.h"
#include "obj.h"
#include "options.h"
#include "projekt.h"
#include "rsc.h"
#include "se.h"
#include "set.h"
#include "text.h"
#include "umbruch.h"
#include "version.h"
#include "window.h"
#include "menu.h"

/****** VARIABLES ************************************************************/

/* Menuenummer zu einer Aktion */
GLOBAL WORD menu_nr[] =	{MUNDO, MCUT, MCOPY, MPASTE, MSELALL, MCLOSE, -1, 
		  						 MINFO, -1, MLEFT, MRIGHT, MFORMAT, MPRINT, MABAND, 
		  						 MSAVE, MSAVENEW, -1, MFNDGOON, MADD, MGOTO, MSSTRIP,
		  						 MSTAB2LZ, -1, MSLZ2TAB, -1, MZEICHEN, MSWAP, MLEFT, 
		  						 MRIGHT, MSMALL, MBIG, MSMALLBIG, MCAPS, MUMLAUTE, 
		  						 -1, MFEHLERSPRUNG, MDELETE, MSORT};

EXTERN UBYTE	__Ident_gnulib[];

/*****************************************************************************/

LOCAL VOID	mclearup 	(VOID);

/*****************************************************************************/
LOCAL VOID info_dial(VOID)
{
	WORD	antw;

	objc_setstring(about, ADATUM, __DATE__);
	objc_setstring(about, AVERSION, ProgrammVersion);
	antw = handle_dial(about, 0);
	if (antw == AINFO)
	{
		UBYTE	str[20];

		strncpy(str, __Ident_gnulib+13, 16);
		str[16] = EOS;
		objc_setstring(about2, AMINT, str);
		handle_dial(about2, 0);
	}
}

/*****************************************************************************/
GLOBAL VOID	set_overwrite(BOOLEAN over)
{
	if (overwrite && !over) 	/* einfgen */
	{
		overwrite = FALSE;
		menu_icheck(menu, MOOVERW, FALSE);
		menu_icheck(menu, MOEINF, TRUE);
	}
	else				/* berschreiben */
	{
		overwrite = TRUE;
		menu_icheck(menu, MOOVERW, TRUE);
		menu_icheck(menu, MOEINF, FALSE);
	}
}

/***************************************************************************/
GLOBAL BOOLEAN prepare_quit(VOID)
{
	WORD	anz, i;
	WORD	ic, icp[MAX_ICON_ANZ];
	SET	actions;

	if (makro_rec)
		return FALSE;

	/* Erst alle testen, dann alle killen */
	anz = all_icons(icp);
	i = anz;
	while ((--i)>=0)
	{
		ic = icp[i];
		if (ic!=0)
		{
			Icon_exist(ic, actions);
			if (setin(actions, DO_DELETE))
				if (!Icon_test(ic, DO_DELETE))
					return FALSE;
		}
	}
	if ((save_opt == 0) != (global_shift == 0))
		option_save();
	i = anz;
	while ((--i)>=0)
	{
		ic = icp[i];
		if (ic!=0)
		{
			Icon_exist(ic, actions);
			if (setin(actions, DO_DELETE))
				Icon_edit(ic, DO_DELETE);
		}
	}
	return TRUE;
}

GLOBAL VOID do_quit(VOID)
{
	kill_memory();
	done = TRUE;
}

/*****************************************************************************/
GLOBAL VOID set_menu(WORD item, BOOLEAN yes)
{
	if (((menu[item].ob_state & DISABLED) == 0) != yes)
		menu_ienable (menu, item, yes);
}

GLOBAL VOID mark_menu(WORD item, BOOLEAN yes)
{
	if (((menu[item].ob_state & CHECKED) != 0) != yes)
		menu_icheck (menu, item, yes);
}

GLOBAL VOID fillup_menu(WORD item, CONST UBYTE *new_text, WORD free)
{
	WORD	len, max_len;
	UBYTE *str;

	str = menu[item].ob_spec.free_string + free;
	len = (short) strlen(new_text);
	max_len = (short) strlen(str) - 4;		/* ' ?? ' Shortcut nicht berscrieben! */
	if (len > max_len)
		len = max_len;
	memcpy(str, new_text, len);
	str += len; 
	len = max_len - len; 					/* Restlnge */
	while ((--len) >= 0)
		*str++ = ' ';
}

LOCAL VOID set_MCOPY(char *n)
{
	fillup_menu(MCOPY, n, 2);
	set_menu(MCOPY, TRUE);
}


VOID updt_menu (VOID)
{
	WINDOWP	window;
	SET		all_actions;
	WORD		i, nr;

	setclr(all_actions);
	window = winlist_top();

	if (sel_window != NULL) /* Aktion fr selektierte Objekte */
	{
		Icon_exist(sel_window->handle + SUB_ICON, all_actions);
		mark_menu(MSEL, FALSE);
		set_menu(MSEL, FALSE);
		set_menu(MSETMARK, FALSE);
	}
	else							/* Aktionen fr oberstes Fenster */
	{
		if (window != NULL)
			Icon_exist(window->handle, all_actions);

		if (window != NULL && window->class == CLASS_EDIT && 
			 !(window->flags & WI_ICONIFIED) && !(window->flags & WI_SHADED))
		{
			TEXTP t_ptr = get_text(window->handle);

			mark_menu(MSEL, (!ctrl_mark_mode && t_ptr->blk_mark_mode));
			set_menu(MSEL, !ctrl_mark_mode);
			set_menu(MSETMARK,TRUE);
		}
		else
		{
			mark_menu(MSEL,FALSE);
			set_menu(MSEL,FALSE);
			set_menu(MSETMARK,FALSE);
		}
	}

	i = num_openwin(CLASS_ALL);
	set_menu(MCYCLE, ((i >= 2) || wind_cycle));

	i = num_openwin(CLASS_EDIT);
	set_menu(MHINTER, (i >= 2));
	set_menu(MNEBEN, (i >= 2));
	set_menu(MUNTER, (i >= 2));

	mark_menu(MSRECORD, makro_rec);

	for (i = DO_ANZ; (--i) >= 0; )
	{
		nr = menu_nr[i];
		if (nr > -1)
			set_menu(nr, setin(all_actions,i));
	}
	if (setin(all_actions, DO_LINECOPY))
		set_MCOPY(STRING(LCOPYSTR));
	else if (setin(all_actions, DO_COPY))
		set_MCOPY(STRING(COPYSTR));

	setup_semenu();				/* -> se.c */
}


/*
 * Alle Mentitel abschalten, nur die ACC bleiben aktiv.
 * Wird bei All-Iconify benutzt.
 */
VOID	enable_menu(BOOLEAN enable)
{
	WORD	titel;

	/* ab dem zweiten Titel alle */
	for (titel = TFILE; titel <= TSHELL; titel++)
		menu_ienable(menu, titel|0x8000, enable);

	/* About-Eintrag auch noch */
	menu_ienable(menu, MABOUT, enable);
	
#if 0
LOCAL WORD	menu_width;

#define THEBAR		1							/* Objekt-Nummer der Menzeile */
#define THEACTIVE 2							/* Objekt-Nummer der aktiven Mens */
#define THEFIRST	3							/* Objekt-Nummer des ersten Mens */

	wind_update(BEG_UPDATE);
	titel = menu[THEFIRST].ob_next;
	while (titel != THEACTIVE)
	{
		disable_objc(menu, titel, !enable);
		titel = menu[titel].ob_next;
	}
	if (enable)
		menu[THEACTIVE].ob_width = menu_width;
	else
	{
		if (menu[THEACTIVE].ob_width != menu[THEFIRST].ob_width)
		{
			menu_width = menu[THEACTIVE].ob_width;
			menu[THEACTIVE].ob_width = menu[THEFIRST].ob_width;
		}
	}
	/* About-Eintrag auch noch */
	menu_ienable(menu, MABOUT, enable);
	if (!(gem >= 0x400) || (menu_bar(NULL, -1) == gl_apid))
		menu_bar(menu, TRUE);

	wind_update(END_UPDATE);
#endif
}

/***************************************************************************/
LOCAL VOID multitest_action(SET icons, SET action)
{
	WORD	icp[MAX_ICON_ANZ], ic;
	SET	help;
	WORD	i;

	i = all_icons(icp);
	setclr(action);
	while ((--i)>=0)
	{
		ic = icp[i];
		if(setin(icons,ic))
		{
			Icon_exist(ic,help);
			setor(action,help);
		}
	}
}

/*****************************************************************************/
LOCAL VOID do_multi_action(WORD action)
{
	WORD	icp[MAX_ICON_ANZ], ic;
	SET	sel_icons;
	WORD	i, anz;

	anz = all_icons(icp);
	setcpy(sel_icons, sel_objs);
	for (i=0; i<anz; i++)				/* In dieser Reihenfolge! */
	{
		ic = icp[i];
		if (setin (sel_icons, ic))
		{
			if (do_icon(ic,action)<0 && action==DO_OPEN)
			{
				note(1, NOWINDOW);
				break;
			}
		}
	}
}

GLOBAL VOID do_action(WORD action)
{
	if (sel_window != NULL)			/* Namen in Projekt selektiert */
	{
		if (do_icon(sel_window->handle+SUB_ICON, action) < 0 && action == DO_OPEN)
			note(1, NOWINDOW);
	}
	else
	{
		WINDOWP w = winlist_top();

		if (w != NULL)
			do_icon(w->handle,action);
	}
}


LOCAL VOID	menu_help(WORD title, WORD item)
{
	UBYTE help[128], *p1, str[128];

	/* Spezial-Flle: besonderer Text */
	if (item >= MMARKE1 && item <= MMARKE5)
		strcpy(str, STRING(HYPMARKESTR));
	else if (item == MPROJEKT)
		strcpy(str, STRING(DEFPRJSTR));
	else if (title == TSHELL)
		strcpy(str, "Shell");
	else if (item >= MHINTER && item <= MUNTER)
		strcpy(str, STRING(HYPANORDSTR));
	else
	{
		/* Spezial-Flle: Item ummappen */
		if (item == MOEINF)
			item = MOOVERW;

		/* die fhrenden '  ' berspringen und das letzte auch nicht */
		strcpy(help, menu[item].ob_spec.free_string);
		strncpy(str, help + 2, (short) strlen(help) - 3);
		p1 = strrchr(str, ' ');
		while (*(p1--) == ' ')	/* Leerzeichen weg */
			;
		*(p1+2) = EOS;
		if (str[strlen(str) - 1] == '.')		/* es folgen '...' */
			str[strlen(str) - 3] = EOS;
	}
	if (str[0] != EOS)
		call_hyp(str);
}


LOCAL BOOLEAN menu_key(KEYDATA *key)
{
	WORD	title, item;
	UWORD	normkey;
	
	updt_menu();
	/* Shift ausblenden wegen global_shift! */
	normkey = (key->normkey & ~NKF_SHIFT);
	if (my_menu_key (menu, normkey, &title, &item, TRUE))
	{
		hndl_menu(title, item, FALSE);
		return TRUE;
	}
	return FALSE;
}


/*
 * Globale Tasten auswerten, die bergeordnete Funktionen auslsen.
*/
GLOBAL BOOLEAN	key_global(KEYDATA *key)
{
	wake_mouse();
	if (key->normkey == (NKF_FUNC|NK_HELP))
	{
		do_action(DO_HELP);
		return TRUE;
	}
	else if ((key->normkey & NKF_ALT) && (key->kreturn >= 0x3B00  && key->kreturn <= 0x4400))
	/* Alt+Funktionstasten => Programmende mit Returncode */
	{
		return_code = ((key->kreturn - 0x3B00) / 0x100) + 1;
		quick_close = TRUE;
		if (prepare_quit())
			do_quit();
		else
			return_code = 0;
		return TRUE;
	}
	else if ((key->kreturn >= 0x3B00 && key->kreturn <= 0x4400) ||
		 	   (key->kreturn >= 0x5400 && key->kreturn <= 0x5D00))
	{
		/* Makro abspielen */
		if (!start_play(key->kreturn, 1) && f_to_desk)
			send_avkey(key->kstate, key->kreturn);
		return TRUE;
	}
	return (menu_key(key));
}


GLOBAL VOID hndl_menu (WORD title, WORD item, BOOLEAN ctrl)
{
	WINDOWP	w;
	WORD		action, antw, anz;
	UBYTE 	str[10];

	if (ctrl)
		menu_help(title, item);
	else
	{
		w = winlist_top();
		menu_tnormal(menu, title, FALSE);	/* Titel invers darstellen */
		action = -1;
		switch (item)
		{
			case MABOUT :
				info_dial();
				break;

			/* ==== Datei ==== */
			case MNEWTEXT	:
				new_edit();
				break;
			case MOPEN	 :
				if (sel_window == NULL)
					select_multi();
				else
					action = DO_OPEN;
				break;
			case MADD	:
				action = DO_ADD;
				break;
			case MNEWPROJ :
				new_prj();
				break;
			case MOPENBIN :
				if (sel_window == NULL)
					select_bin();
				else
					Debug("\aBinOpen aus Projekt geht noch nicht!\n");
				break;
			case MDELETE :
				action = DO_DELETE;
				break;
			case MSAVE:
				action = DO_SAVE;
				break;
			case MSAVENEW:
				action = DO_SAVENEW;
				break;
			case MABAND :
				action = DO_ABAND;
				break;
			case MPRINT :
				action = DO_PRINT;
				break;
			case MINFO	 :
				if (w == NULL)
					info_dial();
				else
					action = DO_INFO;
				break;
			case MQUIT2 :
				quick_close = TRUE;
			case MQUIT :
				if (prepare_quit())
				{
					menu_tnormal(menu, title, TRUE);
					do_quit();
				}
				break;
			/* ==== Bearbeiten ==== */
			case MUNDO	 :
				action = DO_UNDO;
				break;
			case MCUT	 :
				action = DO_CUT;
				break;
			case MCOPY	 :
				if (w!=NULL && w->class==CLASS_EDIT)
				{
					TEXTP t_ptr = get_text(w->handle);
					if (t_ptr->block)
						action = DO_COPY;
					else
						action = DO_LINECOPY;
				}
				break;
			case MPASTE :
				action = DO_PASTE;
				break;
			case MSEL	 :
				if (w!=NULL && w->class==CLASS_EDIT)
				{
					TEXTP t_ptr = get_text(w->handle);
					if (t_ptr->blk_mark_mode)
						t_ptr->blk_mark_mode = FALSE;
					else
					{
						blk_demark(t_ptr);
						restore_edit();
						blk_mark(t_ptr,0);
						t_ptr->blk_mark_mode = TRUE;
					}
				}
				break;
			case MSELALL :
				action = DO_SELALL;
				break;
			case MFORMAT :
				action = DO_FORMAT;
				break;
			case MSWAP:
				action = DO_SWAPCHAR;
				break;
			case MLEFT	 :
				if (global_shift)
					action = DO_ONE_LEFT;
				else
					action = DO_LEFT;
				break;
			case MRIGHT :
				if (global_shift)
					action = DO_ONE_RIGHT;
				else
					action = DO_RIGHT;
				break;
			case MSORT :
				action = DO_SORT;
				break;
			case MSMALLBIG :
				action = DO_CHNG_SMBG;
				break;
			case MBIG:
				action = DO_SMALL2BIG;
				break;
			case MSMALL :
				action = DO_BIG2SMALL;
				break;
			case MCAPS:
				action = DO_CAPS;
				break;

			/* ==== Fenster ==== */
			case MCYCLE :
				if ((wind_cycle) && (send_avkey(4, 0x1117)))	/* ^W */
					break;
				cycle_window();
				break;
			case MCLOSE :
				action = DO_CLOSE;
				break;
			case MHINTER :
			case MNEBEN :
			case MUNTER :
				arrange_window(item);
				break;

			/* ==== Suchen ==== */
			case MFIND	 :
				if ((w == NULL) || (global_shift))
					find_on_disk();
				else
					action = DO_FIND;
				break;
			case MFNDGOON:
				action = DO_FINDNEXT;
				break;
			case MGOTO	 :
				action = DO_GOTO;
				break;
			case MSETMARK:
				if (w!=NULL)
					config_marken(get_text(w->handle));
				break;
			case MMARKE1 :
			case MMARKE2 :
			case MMARKE3 :
			case MMARKE4 :
			case MMARKE5 :
				goto_marke(item-MMARKE1);
				break;

			/* ==== Spezial ==== */
			case MSRECORD:
				if (makro_rec)
					end_rec(TRUE);
				else
					start_rec();
				break;
			case MSPLAY :
				anz = 1;
				if (global_shift)
				{
					objc_setstring(makrorep, MREPANZ, "");
					antw = handle_dial(makrorep, MREPANZ);
					if (antw == MREPOK)
					{
						objc_getstring(makrorep,MREPANZ,str);
						anz = atoi(str);
					}
					else
						break;
				}
				start_play(-1, anz);
				break;
			case MSMAKRO :
				makro_dial();
				break;
			case MZEICHEN:
				action = DO_ZEICHTAB;
				break;
			case MUMLAUTE:
				action = DO_UMLAUT;
				break;
			case MFEHLER:
				fehler_box();
				break;
			case MFEHLERSPRUNG:
				action = DO_FEHLER;
				break;
			case MSSTRIP :
				action = DO_STRIPLINES;
				break;
			case MSTAB2LZ:
				action = DO_TAB2LZ;
				break;
			case MSLZ2TAB:
				action = DO_LZ2TAB;
				break;

			/* ==== Optionen ==== */
			case MOEINF:
				set_overwrite(FALSE);
				break;
			case MOOVERW:
				set_overwrite(TRUE);
				break;
			case MOFONT :
				if (select_font(TRUE))
					font_change();
				break;
			case MGLOBALO:
				global_options();
				break;
			case MLOCALOP:
				local_options();
				break;
			case MAUTOSAVE :
				autosave_options();
				break;
			case MKLAMMER :
				klammer_options();
				break;
			case MPROJEKT :
				open_def_prj();
				break;
			case MTAKEPRJ :
				add_to_def();
				break;
			case MSOPTION:
				option_save();
 				break;

			/* ==== Shell ==== */
			case MSOPT :
			case MSQUIT :
			case MSMAKEFILE :
			case MSSHELL :
			case MSCOMP :
			case MSMAKE :
			case MSMAKEALL :
			case MSLINK :
			case MSEXEC :
			case MSMAKEEXEC :
				hndl_es(item);
			default:
				break;
		}
		if (action!=-1)
			do_action(action);
	} /* if ctrl */
	menu_tnormal(menu, title, TRUE);
}
