#include "global.h"
#include "fontsel.h"
#include "menu.h"

#include "obj.h"

/***************************************************************************/
/* Objekt-Routinen																			*/
/***************************************************************************/

VOID fill_ptext (OBJECT *tree, WORD obj, CONST UBYTE *s)
{
	TEDINFO *ptedinfo;
	WORD	s_len, len;
	UBYTE	*str;

	ptedinfo = (TEDINFO *) get_obspec(tree, obj);
	str = ptedinfo->te_ptext;
	len = ptedinfo->te_txtlen - 1;
	s_len = min((short) strlen(s), len);
	if (ptedinfo->te_just==TE_LEFT)
	{
		memcpy(str, s, s_len);
		str += s_len;
		while ((--len) >= s_len)
			*str++ = ' ';
		*str = EOS;
	}
	else
	{
		while ((--len)>=s_len)
			*str++ = ' ';
		memcpy(str, s, s_len);
		str += s_len;
		*str = EOS;
	}
}

VOID hide_objc(OBJECT *tree, WORD obj, BOOLEAN hide)
{
	if (hide)
		do_flags(tree, obj, HIDETREE);
	else
		undo_flags(tree, obj, HIDETREE);
}

VOID disable_objc(OBJECT *tree, WORD obj, BOOLEAN dis)
{
	if (dis)
		do_state(tree, obj, DISABLED);
	else
		undo_state(tree, obj, DISABLED);
}

VOID select_objc(OBJECT *tree, WORD obj, BOOLEAN sel)
{
	if (sel)
		do_state(tree, obj, SELECTED);
	else
		undo_state(tree, obj, SELECTED);
}

BOOLEAN get_select(OBJECT *tree, WORD obj)
{
	return ((tree[obj].ob_state&SELECTED)!=0);
}

WORD find_xobj(OBJECT *tree, WORD xtype)
{
	UWORD	obj, xt;

	obj = 0;
	while (tree[obj].ob_next != 0)
	{
		get_obtype(tree, obj, &xt);
		if (xt == xtype)
			return obj;
		obj++;
	}
	return -1;
}

VOID	draw_Dial(DIALINFO *d, WORD obj, WORD deep)
{
	objc_draw(d->Tree, obj, deep, (GRECT*)&d->x);
}

VOID	draw_Objc(OBJECT *tree, WORD obj, WORD deep)
{
	objc_draw(tree, obj, deep, (GRECT*)&tree[0].ob_x);
}
