#include "global.h"
#include "comm.h"
#include "olga.h"

/* lokale Variablem **********************************************************/
LOCAL WORD		OLGA_id;
LOCAL BOOLEAN	OLGA_Activ;


/*****************************************************************************/
LOCAL VOID sendOLEinit(VOID)
{
	memset(msgbuff, 0, (WORD)sizeof(msgbuff));
	msgbuff[0] = OLE_INIT;
	msgbuff[1] = gl_apid;
	msgbuff[3] = OL_SERVER;
	msgbuff[7] = 'ED';
	send_msg(OLGA_id);
}

LOCAL VOID sendOLEexit(VOID)
{
	memset(msgbuff, 0, (WORD)sizeof(msgbuff));
	msgbuff[0] = OLE_EXIT;
	msgbuff[1] = gl_apid;
	send_msg(OLGA_id);
}

LOCAL VOID sendOLGAupdate(UBYTE *filename)
{
	memset(msgbuff, 0, (WORD)sizeof(msgbuff));
	msgbuff[0] = OLGA_UPDATE;
	msgbuff[1] = gl_apid;
	strcpy(global_str1, filename);
	*(UBYTE **)(msgbuff + 3) = global_str1;
	send_msg(OLGA_id);
}

LOCAL VOID sendOLGArename(UBYTE *oldname, UBYTE *newname)
{
	memset(msgbuff, 0, (WORD)sizeof(msgbuff));
	msgbuff[0] = OLGA_RENAME;
	msgbuff[1] = gl_apid;
	strcpy(global_str1, oldname);
	*(UBYTE **)(msgbuff + 3) = global_str1;
	strcpy(global_str2, newname);
	*(UBYTE **)(msgbuff + 5) = global_str2;
	send_msg(OLGA_id);
}

GLOBAL VOID	hndl_OLGA(WORD *msg)
{
	switch (msg[0])
	{
		case OLGA_INIT :
			OLGA_Activ = TRUE;
			break;
		case OLE_NEW :
			OLGA_id = msg[1];
			sendOLEinit();
			break;
		case OLGA_ACK :
			break;
		case OLE_EXIT :
			OLGA_Activ = FALSE;
			break;
	}
}

GLOBAL VOID do_OLGA(WORD flag, UBYTE *name1, UBYTE *name2)
{
	if (OLGA_Activ)
	{
		switch (flag)
		{
			case OLGA_UPDATE :
				if (name1 != NULL)
					sendOLGAupdate(name1);
				break;
			case OLGA_RENAME :
				if (name1 != NULL && name2 != NULL)
					sendOLGArename(name1, name2);
				break;
		}
	}
}

GLOBAL VOID init_olga(VOID)
{
	UBYTE	*p;

	OLGA_id = appl_find("OLGA    ");
	if (OLGA_id > 0)
		sendOLEinit();
	else
	{
		p = getenv("OLGAMANAGER");
		if (p != NULL)
		{
			PATH	olga_path, olga_name, old;

			strcpy(olga_name, p);
			file_splitt(olga_name, olga_path, NULL);
			get_path(old, 0);
			set_path(olga_path);
			if (gem >= 0x400)
				shel_write(1, 1, 1, olga_name, "");
			else if (magx)
				shel_write(1, 1, 100, olga_name, "");
			set_path(old);
		}
	}
}

GLOBAL VOID term_olga(VOID)
{
	if (OLGA_Activ)
		sendOLEexit();
}
