#include <support.h>
#include <time.h>

#include "global.h"
#include "block.h"
#include "event.h"
#include "file.h"
#include "fontsel.h"
#include "memory.h"
#include "obj.h"
#include "rsc.h"
#include "wp-print.h"
#include "printer.h"

/*
 * Exportierte Variablen
 */
GLOBAL WORD			rand_len;
GLOBAL BOOLEAN		zeilen_nr, seiten_nr, vorschub, pruef_prn, use_gdos_print,
						use_rand, print_block;
GLOBAL WORD			gdos_device;
GLOBAL WORD			wp_mode, wp_seiten_len, wp_seiten_width;
GLOBAL PATH			wp_treiber, metafile;
GLOBAL BOOLEAN		wp_nlq, prn_ok;

/****** DEFINES **************************************************************/

/****** TYPES ****************************************************************/

typedef struct{
	WORD	devID;						/* die Nummer (21 .. 99) */
	UBYTE	devName[DEV_LEN - 1];	/* der Name */
	WORD	FntAnz;						/* die Anzahl der Fonts */
	UBYTE	firstName[32];				/* name des ersten Fonts */
	WORD	firstID;						/* ID des ersten Fonts */
	WORD	firstSize;					/* Gre des ersten Fonts */
} DevInfoS;

/****** VARIABLES ************************************************************/

LOCAL WORD			xpos, prn_x, prn_y, prn_w, prn_h, line_height;
LOCAL WORD			prn_handle, 	/* GDOS */
						prn_device;		/* GEMDOS */
LOCAL BOOLEAN		dev_has_changed;
LOCAL DevInfoS		GdosDevices[10];
LOCAL WORD			dev_anzahl;

/****** FUNCTIONS ************************************************************/

LOCAL VOID		plot_char	(UBYTE c);
LOCAL VOID		plot_str		(UBYTE *adr, WORD rand, BOOLEAN tab, WORD tab_size);
LOCAL VOID		plot_int		(WORD z, WORD stellen);

LOCAL VOID		drucken		(UBYTE *name, RINGP t, BOOLEAN tab, WORD tab_size);
LOCAL VOID		gdos_drucken(UBYTE *name, RINGP t, BOOLEAN tab, WORD tab_size);
LOCAL BOOLEAN	prn_check 	(WORD wait_time);

/***************************************************************************/

short MicromToDPI( short microm)
{
	switch (microm)
	{
		case 35:			return 720;
		case 42:			return 600;
		case 71:			return 360;
		case 85:			return 300;
		case 117:
		case 118:		return 216;
		case 130:		return 196;
		case 141:		return 180;
		case 175:
		case 176:		return 144;
		case 211:
		case 212:		return 120;
		default:			return 25400 / microm;
	}
} /* MicromToDPI */


BOOLEAN	DeviceInfo(WORD devID, DevInfoS *devInfo)
{
	WORD	workin[] = { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2};
	WORD	workout[57];
	WORD	wkHandle;
	WORD	devExist;
	WORD	i, id;
	UBYTE	name[80];

	if (!vq_gdos())
    		return FALSE;

	workin[0] = devID;
	wkHandle = -1;
	v_opnwk( workin, &wkHandle, workout);
	if (wkHandle <= 0)
		return FALSE;

	devInfo->devID   = devID;
	devInfo->FntAnz  = workout[10] + vst_load_fonts(wkHandle, 0);

	if (devInfo->FntAnz <= 0)	/* Treiber nur gltig, wenn es auch Fonts gibt!! */
	{
		vst_unload_fonts(wkHandle, 0);
		v_clswk( wkHandle);
		return FALSE;
	}

	for (i=1; i<100; i++)
	{
		id = vqt_name(wkHandle, i, devInfo->firstName);
		if (id >= 0)
			break;
	}
	if (id < 0)
		return FALSE;

	devInfo->firstSize = vst_point(wkHandle, 10, &i, &i, &i, &i);
	devInfo->firstID	= id;

	_VDIParBlk.contrl[2] = 0;
	vqt_devinfo( wkHandle, devID, &devExist, name);
	if (_VDIParBlk.contrl[2] == 0)			/*** Funktion ist nicht implementiert, generiere Namen ***/
	{
		if ((devID >= 21) && (devID < 31))
			sprintf(name, "GDOS PRINTER %d", devID);
		else if ((devID >= 31) && (devID < 41))
			sprintf(name, "GDOS METAFILE %d", devID);
		else
			sprintf(name, "GDOS DEVICE %d", devID);
	}
	else if (_VDIParBlk.contrl[2] == 1)
	{
		/*** Nur Dateiname des Geraetetreibers vorhanden ***/
		i = _VDIParBlk.contrl[4];
		if (i > 11)
			i = 11;
		name[i] = 0;
	}
	else /* if (_VDIParBlk.contrl[2] == 14) */
	{
		WORD	p = 0;
		UBYTE	*s;

		/*** Treiberbezeichnung ***/
		s = (UBYTE *)&_VDIParBlk.ptsout[1];
		for (i = 0; (i < 40) && (*s); i++)
			name[p++] = *s++;
		name[p] = EOS;
	}
	vst_unload_fonts(wkHandle, 0);
	v_clswk( wkHandle);

	strncpy(devInfo->devName, name, DEV_LEN - 1);
	devInfo->devName[DEV_LEN - 1] = EOS;

	return( TRUE);
} /* DeviceInfo */


VOID	scanDevices(VOID)
{
	WORD	i;

	if (dev_anzahl != 0)	/* nur einmal scannen! */
		return;
	start_aktion(STRING(SEARCHGDOS), FALSE, 80);
	dev_anzahl = 0;
	for (i = 21; i < 100; i++)
	{
		do_aktion(i - 20);
		if (DeviceInfo(i, &GdosDevices[dev_anzahl]))
			dev_anzahl++;
	}
	if (file_exist("gemfile.gem"))	/* Metafile-Treiber legt eine leere Datei an */
		Fdelete("gemfile.gem");			/* die wir nun wieder lschen. */
	end_aktion();
}

LOCAL VOID get_fontname(VOID)
{
	WORD	d;
	
	for (d = 1; d <= GdosDevices[gdos_device].FntAnz; d++)
		if (vqt_name(prn_handle, d, druckFont.name) == druckFont.id)
			break;
}

/*****************************************************************************/
/* Drucker-TestRoutinen																											*/
/*****************************************************************************/
LOCAL BOOLEAN prn_ready (VOID)
{
	switch (prn_device)
	{
		case 0 :
			return Cprnos() != 0;
		case 1 :
			return Cauxos() != 0;
		default:
			return FALSE;
	}
} /* prn_ready */


LOCAL BOOLEAN prn_check (WORD wait_time)
{
	BOOLEAN	ok = FALSE,
				cancel = FALSE;
	LONG		timer;

	/* Schnittstelle nur bei Druckertreibern berprfen!! */
	if ((pruef_prn && !use_gdos_print) ||
		 (pruef_prn && use_gdos_print && (GdosDevices[gdos_device].devID >= 21 && GdosDevices[gdos_device].devID <= 30)))
	{
		while (!ok && !cancel)
		{
			timer = 200 * wait_time + clock();
			ok = prn_ready();
			while (!ok && (timer > clock()))
				ok = prn_ready();
			if (!ok)
		 		cancel = (note(1, PRNOTRDY) == 2);
		}
		return (ok && !cancel);
	}
	else
		return TRUE;
} /* prn_check */

/***************************************************************************/

LOCAL VOID plot_char(UBYTE c)
{
	UBYTE	str[2];
	WORD	ext[8];

	if (use_gdos_print)
	{
		str[0] = c;
		str[1] = EOS;
		v_gtext(prn_handle,prn_x,prn_y,str);
		vqt_extent(prn_handle,str,ext);
		prn_x += (ext[2] - ext[0]);
	}
	else
	{
		if (c=='\n' || c=='\r')
			xpos = 0;
		else if (xpos >= wp_seiten_width)
			return;
		else xpos++;
		WPWrite(c);
	}
}

LOCAL VOID plot_ff(VOID)
{
	if (use_gdos_print)
	{
		prn_x = 0;
		prn_y = 0;
		v_updwk(prn_handle);
		v_clrwk(prn_handle);
	}
	else
		WPFormFeed();
}

LOCAL VOID plot_nl(VOID)
{
	if (use_gdos_print)
	{
		prn_x = 0;
		prn_y += line_height;
	}
	else
	{
		xpos = 0;
		WPWriteLn();
	}
}

LOCAL VOID plot_str(UBYTE *adr, WORD rand, BOOLEAN tab, WORD tab_size)
{
	WORD 		tabH;

	while	((--rand)>=0)
		plot_char(' ');
	tabH = 0;
	while	(*adr!='\0')
	{
		if (!tabH)
			tabH = tab_size;
		if (tab && *adr == '\t')
		{
			while (tabH > 0)
			{
				plot_char(' ');
				tabH--;
			}
			tabH = tab_size;
		}
		else
		{
			plot_char(*adr);
			tabH --;
		}
		adr++;
	}
}

LOCAL VOID plot_int(WORD z, WORD stellen)
{
	UBYTE str[12];

	itoa(z,str,10);
	plot_str(str, stellen - (short)strlen(str), FALSE, 0);
}

VOID blk_drucken(UBYTE *name, TEXTP t_ptr)
{
	RING t;

	block_copy(t_ptr,&t);
	if (use_gdos_print)
		gdos_drucken(name, &t, t_ptr->loc_opt->tab, t_ptr->loc_opt->tabsize);
	else
		drucken(name, &t, t_ptr->loc_opt->tab, t_ptr->loc_opt->tabsize);
	kill_textring(&t);
}

VOID txt_drucken(UBYTE *name, TEXTP t_ptr)
{
	if (use_gdos_print)
		gdos_drucken(name, &t_ptr->text, t_ptr->loc_opt->tab, t_ptr->loc_opt->tabsize);
	else
		drucken(name, &t_ptr->text, t_ptr->loc_opt->tab, t_ptr->loc_opt->tabsize);
}

LOCAL BOOLEAN open_printer(VOID)
{
	WORD	work_in[11], work_out[57];
	WORD	i, p_xy[4];

	if (gdos_device < 0)
		return FALSE;

	for (i=0; i<=10; i++)
		work_in[i] = 1;
	work_in[0] = GdosDevices[gdos_device].devID;					/* Drucker */
	work_in[5] = 0;
	work_in[10] = 2;
	v_opnwk(work_in, &prn_handle, work_out);

	/* Pfad fr eventuelle Dateiausgabe setzen */
	if ((metafile[0] != EOS) && (GdosDevices[gdos_device].devID >= 31))
	{
		PATH	tmp;

		vm_filename(prn_handle, metafile);
		file_splitt(metafile, tmp, NULL);
		set_path(tmp);
	}

	if (prn_handle==0)
		return FALSE;
	prn_w = work_out[0];
	prn_h = work_out[1];
	p_xy[0] = 0;
	p_xy[1] = 0;
	p_xy[2] = prn_w-1;
	p_xy[3] = prn_h+1;
	vs_clip(prn_handle, TRUE, p_xy);

	vswr_mode(prn_handle, MD_TRANS);
	return TRUE;
}

LOCAL VOID close_printer(VOID)
{
	vst_unload_fonts(prn_handle,0);
	v_clswk(prn_handle);
}

LOCAL VOID gdos_drucken(UBYTE *name, RINGP t, BOOLEAN tab, WORD tab_size)
{
	WORD		p_xy[8], dummy, eff[3], seite, lzeile, gdos_seiten_len;
	UBYTE		datum[11], str[40];
	long		zeile;
	ZEILEP		lauf;

	if (!open_printer())
		return;

	if (!prn_check(0))
	{
		close_printer();
		return;
	}

	/* Einige Einstellungen fr Metafile */
	if (GdosDevices[gdos_device].devID >= 31 && GdosDevices[gdos_device].devID <= 40)
	{
		vm_pagesize(prn_handle, 2100, 2970);			/* Blattgre DIN A4 */
/*		vm_coords(prn_handle, 0, 0, 2480, 3508);*/
		vm_coords(prn_handle, 0, 2480, 3508, 0);
		v_meta_extents(prn_handle, 0, 0, 2480, 3508);
	}

	vst_font(prn_handle, druckFont.id);
	vst_point(prn_handle, druckFont.pts, &dummy, &dummy, &dummy, &dummy);

	vqt_fontinfo(prn_handle, &dummy, &dummy, p_xy, &dummy, eff);
	line_height = p_xy[0] + p_xy[4] + 1;
	vst_alignment(prn_handle, TA_LEFT , TA_ASCENT, &dummy, &dummy); /* Oberkante */
	vqt_extent(prn_handle,"Hallo",p_xy);
	prn_x = 0; prn_y = 0;

	get_datum(datum);
	gdos_seiten_len = prn_h/line_height;
	lzeile = gdos_seiten_len;
	seite = 1;
	zeile = 0;

	strcpy(str, STRING(PRINTSTR));
	strcat(str,name);
	start_aktion(str,TRUE,t->lines);

	set_mouse(HOURGLASS, NULL);
	lauf = FIRST(t);
	while (TRUE)
	{
		if (!prn_check(5))
			break;

		if (abbruch())
			if (note(1,BREAK)==1) break;

		if (lzeile == gdos_seiten_len)
		{
			lzeile = 0;
			if (zeile!=0) plot_ff();
			if (seiten_nr)
			{
				plot_str(STRING(FILESTR), 7, FALSE, 0);
				plot_str(name,1,FALSE,0);
				plot_str(STRING(PAGESTR), 8, FALSE, 0);
				plot_int(seite++,0);
				plot_str(STRING(DATESTR), 8, FALSE, 0);
				plot_str(datum,0,FALSE,0);
				plot_nl();
				plot_nl();
				lzeile = 2;
			}
		}
		do_aktion(zeile);
		zeile++;
		lzeile++;
		if (use_rand && rand_len > 0)
			plot_str("",rand_len,FALSE,0);

		if (zeilen_nr)
			plot_int((short) zeile, 4);
		plot_str(TEXT(lauf),(zeilen_nr)?2:0,tab,tab_size);
		plot_nl();
		NEXT(lauf);
		if (IS_TAIL(lauf)) break;
	}
	v_updwk(prn_handle);
	if (vorschub)
		v_clrwk(prn_handle);
	close_printer();
	end_aktion();
	set_mouse(ARROW, NULL);
}

LOCAL VOID drucken(UBYTE *name, RINGP t, BOOLEAN tab, WORD tab_size)
{
	LONG		zeile;
	UBYTE		datum[11], str[40];
	WORD		seite, lzeile;
	ZEILEP		lauf;

	prn_device = ((Setprt(-1)&16) != 0);

	if (!prn_check(0))
		return;

	if (prn_device == 0)
		strcpy(str, "PRN:");
	else
		strcpy(str, "AUX:");
	if (!WPOpen(str))
		return;

	prn_ok = WPSendInit(wp_nlq);
	WPSetTabSize(tab_size);
	prn_ok = WPSetMode(wp_mode);

	get_datum(datum);
	lzeile = wp_seiten_len;
	seite = 1;
	zeile = 0;

	strcpy(str,STRING(PRINTSTR));
	strcat(str,name);
	start_aktion(str,TRUE,t->lines);

	set_mouse(HOURGLASS, NULL);
	lauf = FIRST(t);
	while (TRUE)
	{
		if (!prn_check(5))
			break;

		if (abbruch())
			if (note(1,BREAK)==1)
				break;

		if (wp_seiten_len && lzeile == wp_seiten_len)
		{
			lzeile = 0;
			if (zeile != 0)
				plot_ff();
			if (seiten_nr)
			{
				plot_str(STRING(FILESTR), 7, FALSE, 0); plot_str(name,1,FALSE,0);
				plot_str(STRING(PAGESTR), 8, FALSE, 0); plot_int(seite++,0);
				plot_str(STRING(DATESTR), 8, FALSE, 0); plot_str(datum,0,FALSE,0);
				plot_nl();
				plot_nl();
				lzeile = 2;
			}
		}
		do_aktion(zeile);
		zeile++;
		lzeile++;
		if	(use_rand && rand_len > 0)
			plot_str("", rand_len, FALSE, 0);
		if (zeilen_nr)
			plot_int((short) zeile,4);
		plot_str(TEXT(lauf), (zeilen_nr) ? 2 : 0, tab, tab_size);
		plot_nl();
		NEXT(lauf);
		if (IS_TAIL(lauf))
			break;
	}
	if (wp_seiten_len && zeile && vorschub)
		plot_ff();
	WPSendExit();
	WPClose();
	end_aktion();
	set_mouse(ARROW, NULL);
}
/*****************************************************************************/

LOCAL VOID set_font(VOID)		/* trgt Font in die Box ein */
{
	UBYTE	str[32];

	if ((strlen(druckFont.name) == 0) || dev_has_changed)
	{
		strcpy(druckFont.name, GdosDevices[gdos_device].firstName);
		druckFont.pts = GdosDevices[gdos_device].firstSize;
		druckFont.id = GdosDevices[gdos_device].firstID;
		dev_has_changed = FALSE;
	}
	itoa(druckFont.pts, str, 10);
	objc_setstring(printer, DSIZE, str);
	objc_setstring(printer, DFONT, druckFont.name);
}

LOCAL VOID set_button(BOOLEAN normal)
{
	disable_objc(printer, DSTART, !normal);
	if (normal)
		do_flags(printer, DSTART, DEFAULT);
	else
		undo_flags(printer, DSTART, DEFAULT);
}

LOCAL VOID enable_gdos(VOID)
{
	UBYTE	str[DEV_LEN + 1];

	top_kartei(printer, DREITER, DGDOSR);
	scanDevices();
	set_button((dev_anzahl > 0));
	if (dev_anzahl == 0)
	{
		objc_setstring(printer, DDEVICE, STRING(NODEVSTR));
		disable_objc(printer, DDEVICE, TRUE);
		disable_objc(printer, DDEVCIRC, TRUE);
		disable_objc(printer, DFONTSEL, TRUE);
		objc_setstring(printer, DFONT, "");
		objc_setstring(printer, DSIZE, "");
	}
	else
	{
		if (gdos_device >= dev_anzahl)		/* aus den Parametern */
		{
			gdos_device = 0;
			dev_has_changed = TRUE;
		}
		open_printer();							/* aktuelle Fontdaten holen */
		get_fontname();
		close_printer();

		strcpy(str, " ");
		strcat(str, GdosDevices[gdos_device].devName);
		objc_setstring(printer, DDEVICE, str);
		set_font();
	}
}

LOCAL VOID enable_gemdos(VOID)
{
	UBYTE	tmp[25];

	top_kartei(printer, DREITER, DGEMDOSR);
	switch (wp_mode)
	{
		case PICA :
			objc_setstring(printer, DDICHTE, (UBYTE *)get_obspec(popups, DICHTEPICA));
			break;
		case ELITE :
			objc_setstring(printer, DDICHTE, (UBYTE *)get_obspec(popups, DICHTEELITE));
			break;
		case CONDENSED :
			objc_setstring(printer, DDICHTE, (UBYTE *)get_obspec(popups, DICHTECOND));
			break;
	}
	if (!wp_config_read && wp_treiber[0] != EOS)
		WPLoadCFGFile(wp_treiber);
	if (wp_config_read)
		WPGetPrnName(tmp, 25);
	else
		strcpy(tmp, STRING(NODEVSTR));
	set_button(wp_config_read);
	disable_objc(printer, DNLQ, !wp_config_read);
	disable_objc(printer, DDICHTE, !wp_config_read);
	disable_objc(printer, DDICHTCIRC, !wp_config_read);
	select_objc(printer, DNLQ, wp_nlq);
	objc_setstring(printer, DTREIBNAME, tmp);
	itoa(wp_seiten_len, tmp, 10);
	objc_setstring(printer, DLENGTH, tmp);
	itoa(wp_seiten_width, tmp, 10);
	objc_setstring(printer, DWIDTH, tmp);
}

LOCAL VOID build_popup(POPUP *pop)
{
	UBYTE	str[DEV_LEN + 1];
	WORD	i;

	if (pop->tree != NULL)
		return;

	if (dev_anzahl > 0)
	{
		strcpy(str, " ");
		strcat(str, GdosDevices[0].devName);
		create_popup(pop, dev_anzahl, DEV_LEN, str);

		for (i = 1; i < dev_anzahl; i++)
		{
			strcpy(str, " ");
			strcat(str, GdosDevices[i].devName);
			append_popup(pop, str);
		}
		for(i = 0; i < pop->akt_item + 2; i++)
			rsrc_obfix(pop->tree, i);
		dial_fix(pop->tree);
	}
	else
		pop->tree = NULL;
}

BOOLEAN prn_options(BOOLEAN block)
{
	UBYTE			s[14];
	WORD			antw, save_dev, save_mode, edit_obj;
	BOOLEAN		save_gdos_print;
	FONTINFO		save_font;
	DIALINFO		dial;
	POPUP			pop;
	WORD			y;
	PATH			save_treiber;
	FSEL			fsel = {"", "*.cfg"};
	PATH			str = "";

	save_gdos_print = use_gdos_print;
	save_dev = gdos_device;
	memcpy(&save_font, &druckFont, sizeof(FONTINFO));

	save_mode = wp_mode;
	strcpy(save_treiber, wp_treiber);

	/* Allgemeine Parameter */
	select_objc(printer, NUMMERNJ, zeilen_nr);
	select_objc(printer, SEITENJ, seiten_nr);
	select_objc(printer, DVORSCHUB, vorschub);
	select_objc(printer, CHECKPRN, pruef_prn);
	select_objc(printer, DBLOCK, block);
	select_objc(printer, DTEXT, !block);
	disable_objc(printer, DBLOCK, !block);
	select_objc(printer, DRAND, use_rand);
	itoa(rand_len, s, 10);
	objc_setstring(printer, DRANDLEN, s);

	/* GDOS berhaupt vorhanden? */
	if (!gdos)
		disable_objc(printer, DGDOSR, TRUE);

	if (use_gdos_print && gdos)
		enable_gdos();
	else
		enable_gemdos();

	pop.tree = NULL;
	build_popup(&pop);

	open_dial(printer, &dial);
	dial_draw(&dial);
	edit_obj = DRANDLEN;
	do
	{
		antw = dial_do(&dial, &edit_obj) & 0x7FFF;
		switch (antw)
		{
			case DGEMDOSR :
				enable_gemdos();
				use_gdos_print = FALSE;
				draw_Objc(printer, DGEMDOSK, MAX_DEPTH);
				mydraw_obj(printer, DSTART);
				break;
			case DGDOSR :
				enable_gdos();
				use_gdos_print = TRUE;
				draw_Objc(printer, DGDOSK, MAX_DEPTH);
				mydraw_obj(printer, DSTART);
				build_popup(&pop);
				break;
			case DDATEI :
				if (metafile[0] != EOS)
				{
					file_name(metafile, fsel.name, FALSE);
					set_fsel_path(metafile);
				}
				else
					strcpy(fsel.name, "gemfile.gem");
				strcpy(fsel.suffix, "*.gem");
				close_dial(&dial);
				if (select_file(&fsel, str, STRING(FINDGDSTR)))
					strcpy(metafile, str);
				select_objc(printer, antw, FALSE);
				open_dial(printer, &dial);
				dial_draw(&dial);
				break;
			case DFONTSEL:
				close_dial(&dial);
				if (dev_anzahl > 0)
				{
					if (open_printer())
					{
						if (select_font(FALSE))
						{
							UBYTE	str[32];

							get_fontname();
							itoa(druckFont.pts, str, 10);
							objc_setstring(printer, DSIZE, str);
							objc_setstring(printer, DFONT, druckFont.name);
						}
					}
					close_printer();
				}
				select_objc(printer, antw, FALSE);
				open_dial(printer, &dial);
				dial_draw(&dial);
				break;
			case DDEVSTR :
			case DDEVCIRC:
			case DDEVICE:
				if (dev_anzahl > 0)
				{
					if (antw == DDEVICE)
						y = popup_select(printer, DDEVICE, pop.tree, 1, FALSE, DO_POPUP);
					else
						y = popup_select(printer, DDEVICE, pop.tree, 1, FALSE, DO_CYCLE);
					y -= pop.first_item;
					if (y >= 0)
					{
						gdos_device = y;
						dev_has_changed = TRUE;
						set_font();
						draw_Objc(printer, DGDOSK, MAX_DEPTH);
					}
				}
				select_objc(printer, antw, FALSE);
				draw_Objc(printer, antw, 1);
				break;
			case DTREIBER :
				close_dial(&dial);
				if (wp_treiber[0] != EOS)
				{
					file_name(wp_treiber, fsel.name, FALSE);
					set_fsel_path(wp_treiber);
				}
				else
					strcpy(fsel.name, "");
				strcpy(fsel.suffix, "*.cfg");
				if (select_file(&fsel, str, STRING(TREIBERSTR)))
				{
					strcpy(wp_treiber, str);
					wp_config_read = FALSE;
					if (WPLoadCFGFile(wp_treiber))
						WPGetPrnName(str, 25);
					else
						strcpy(str, STRING(NODEVSTR));
					objc_setstring(printer, DTREIBNAME, str);
					set_button(wp_config_read);
					disable_objc(printer, DNLQ, !wp_config_read);
					disable_objc(printer, DDICHTE, !wp_config_read);
					disable_objc(printer, DDICHTCIRC, !wp_config_read);
				}
				open_dial(printer, &dial);
				select_objc(printer, DTREIBER, FALSE);
				dial_draw(&dial);
				break;
			case DDICHTESTR :
			case DDICHTCIRC :
			case DDICHTE :
				if (antw == DDICHTE)
					y = popup_select(printer, DDICHTE, popups, DICHTEPOP, FALSE, DO_POPUP);
				else
					y = popup_select(printer, DDICHTE, popups, DICHTEPOP, FALSE, DO_CYCLE);
				y -= DICHTEPICA;
				if (y >= 0)
					wp_mode = y;
				break;
			default:
				break;
		}
	}
	while (antw != DOK && antw != DSTART && antw != DRAUS);
	select_objc(printer, antw, FALSE);
	free_popup(&pop);
	dial_end(&dial);
	if (antw == DRAUS)
	{
		use_gdos_print = save_gdos_print;
		gdos_device = save_dev;
		memcpy(&druckFont, &save_font, sizeof(FONTINFO));
		wp_mode = save_mode;
		strcpy(wp_treiber, save_treiber);
	}
	else
	{
		/* Allgemein */
		zeilen_nr = get_select(printer, NUMMERNJ);
		seiten_nr = get_select(printer, SEITENJ);
		vorschub = get_select(printer, DVORSCHUB);
		pruef_prn = get_select(printer, CHECKPRN);
		print_block = get_select(printer, DBLOCK);
		use_rand = get_select(printer, DRAND);
		objc_getstring(printer, DRANDLEN, s);
		rand_len = atoi(s);

		objc_getstring(printer, DLENGTH, s);
		if (*s)
			wp_seiten_len = atoi(s);
		else
			wp_seiten_len = 65;
		objc_getstring(printer, DWIDTH, s);
		if (*s)
			wp_seiten_width = atoi(s);
		else
			wp_seiten_width = 80;

		wp_nlq = get_select(printer, DNLQ);
	}
	return (antw == DSTART);
}

VOID init_printer(VOID)
{
	gdos_device = 0;
	druckFont.id = 1;
	druckFont.pts = 10;
	druckFont.name[0] = EOS;
	dev_has_changed = FALSE;
}
