#include <dirent.h>
#include <support.h>
#include <stat.h>
#include <time.h>

#include "global.h"
#include "av.h"
#include "ausgabe.h"
#include "clipbrd.h"
#include "comm.h"
#include "dd.h"
#include "edit.h"
#include "event.h"
#include "kurzel.h"
#include "file.h"
#include "find.h"
#include "icon.h"
#include "memory.h"
#include "menu.h"
#include "obj.h"
#include "options.h"
#include "printer.h"
#include "rsc.h"
#include "set.h"
#include "text.h"
#include "window.h"
#include "projekt.h"


/* exprortierte Variablen **************************************************/
WORD		prj_type;
PATH		def_prj_path;

/****** DEFINES ************************************************************/

#define KIND	(NAME|CLOSER|MOVER|INFO|SIZER|UPARROW|DNARROW|VSLIDE|SMALLER)
#define FLAGS	(WI_FONTSIZE|WI_REDRAW)

#define TEMP_PRJ	"TEMP$.QPJ"
#define TEMP_LINK 10001

/****** TYPES **************************************************************/

typedef struct {			/* fr Dreaddir */
		LONG		inode;
		FILENAME name;
} DIRENTRY;

/****** VAR ****************************************************************/
LOCAL SET		used_info;						/* Icon-Nr fr Text und Fenster */
LOCAL WORD		do_find_icon;
LOCAL PATH		df_path;
LOCAL WORD		def_icon;						/* Icon fr Defaultprojekt */

/****** FUNCTIONS **********************************************************/

LOCAL VOID		icon_exist			(WORD icon, SET actions);
LOCAL BOOLEAN	icon_test			(WORD icon, WORD action);
LOCAL WORD		icon_edit			(WORD icon, WORD action);
LOCAL BOOLEAN	icon_drag			(WORD icon, WORD source);
LOCAL VOID		draw_line			(WINDOWP window, WORD line);
LOCAL VOID		wi_draw				(WINDOWP window, CONST GRECT *d);
LOCAL VOID		wi_click 			(WINDOWP window, MOUSEDATA *mouse);
LOCAL VOID		wi_unclick			(WINDOWP window);
LOCAL BOOLEAN	wi_key				(WINDOWP window, KEYDATA *key);
LOCAL VOID		wi_snap				(WINDOWP window, GRECT *new, WORD mode);
LOCAL VOID		wi_iconify			(WINDOWP window);
LOCAL VOID		wi_uniconify		(WINDOWP window);
LOCAL BOOLEAN	find_files			(UBYTE *pfad, BOOLEAN rekursiv, UBYTE *df_muster, WORD icon);
LOCAL VOID		get_prj_line		(WORD link, WORD line, UBYTE *str);
LOCAL WORD		del_from_projekt	(WORD link, WORD line);
LOCAL BOOLEAN	open_prj 			(WORD icon);
LOCAL VOID		destruct 			(WORD icon);
LOCAL VOID		crt_prj				(WINDOWP window);
LOCAL WORD		crt_new_prj			(CONST UBYTE *filename);
LOCAL BOOLEAN	info_projekt		(WORD icon);

LOCAL VOID		select_def_prj 	(VOID);

/*****************************************************************************/

LOCAL LONG		p_maxvalue;
LOCAL	DIALINFO	scan_box;

VOID start_prjscan(CONST UBYTE *name, LONG max_value)
{
	p_maxvalue = max(max_value,1);
	fill_ptext(prjscan, PNAME, name);
	fill_ptext(prjscan, PDATEI, "");
	prjscan[PBOX2].ob_width = 1;
	open_dial(prjscan, &scan_box);
	dial_draw(&scan_box);
}

VOID do_prjscan (CONST UBYTE *name, LONG value)
{
	LONG max_len, help;

	fill_ptext(prjscan,PDATEI,name);
	max_len = prjscan[PBOX1].ob_width;
	help = max((max_len*value)/p_maxvalue,1);
	prjscan[PBOX2].ob_width = (short) min(max_len, help);
	draw_Objc(prjscan, PDATEI, 1);
	draw_Objc(prjscan, PBOX2, 1);
}

VOID end_prjscan (VOID)
{
	dial_end(&scan_box);
}

/*****************************************************************************/

WORD anz_prj_loaded(VOID)
{
	return setcard(used_info);
}

WORD prj_still_loaded(UBYTE *name)
{
	WORD i, min;

	min = setmin(used_info);
	for (i=setmax(used_info); i>=min; i--)
		if (setin(used_info,i))
		{
			TEXTP t_ptr = get_text(i);
			
/*			if (!t_ptr->namenlos && filematch(t_ptr->filename, name))*/
			if (!t_ptr->namenlos && strcmp(t_ptr->filename, name)==0)
				return i;
		}
	return -1;
}

LOCAL VOID do_for_prj(WORD icon, SET s, WORD (*do_it)(WORD,WORD), BOOLEAN verbose)
{
	TEXTP 	t_ptr, t_ptr2;
	ZEILEP 	lauf;
	WORD		min, i, anz, soll, erg;
	PATH		name;
	FILENAME file;

	t_ptr = get_text(icon);
	if (verbose)
	{
		t_ptr2 = get_text(icon);
		if (t_ptr2->namenlos)
			strcpy(file, t_ptr2->filename);
		else
			file_name(t_ptr2->filename,file, FALSE);
		start_prjscan(file,setcard(s));
	}

	min = setmin(s);
	/* So wg. DO_DELETE */
	for (i=setmax(s); i>=min; i--)
	{
		if (setin(s,i))
		{
			lauf = get_line(&t_ptr->text,i);
			lauf->info |= MARKED;
		}
	}
	soll = setcard(s);
	anz = i = 0;
	while (TRUE)
	{
		if (abbruch())
		{
			if (anz<soll && note(2,BREAK)==1) break;
		}
		lauf = get_line(&t_ptr->text,i);
		if (lauf==NULL) break;
		if (IS_MARKED(lauf))
		{
			anz++;
			lauf->info &= (~MARKED);				/* sonst Endlosschleife */
			if (verbose)
			{
				get_prj_line(icon,i,name);
				if (name[0]==EOS) break;
				file_name(name,file, FALSE);
				do_prjscan(file,anz);
			}
			erg = (*do_it)(icon,i);
			if (erg<0) break;
			if (erg==0)
			{
				if (anz<soll && note(2,BREAK)==1) break;
			}
		}
		else
			i++;
	}
	lauf = FIRST(&t_ptr->text);
	while (!IS_TAIL(lauf))
	{
		lauf->info &= (~MARKED);
		NEXT(lauf);
	}
	if (verbose) end_prjscan();
}

LOCAL VOID do_for_prj2(WORD icon, SET s, BOOLEAN (*do_it)(WORD))
{
	WORD	i, t_icon, anz, soll;
	TEXTP t_ptr, t_ptr2;
	PATH	name;
	FILENAME file;

	t_ptr = new_text(TEMP_LINK);
	if (t_ptr==NULL) return;

	t_ptr2 = get_text(icon);
	if (t_ptr2->namenlos)
		strcpy(file, t_ptr2->filename);
	else
		file_name(t_ptr2->filename,file, FALSE);
	start_prjscan(file,setcard(s));

	soll = setcard(s);
	for (i=setmin(s),anz=0; anz<soll; i++)
	{
		if (setin(s,i))
		{
			anz++;
			get_prj_line(icon,i,name);
			if (name[0]==EOS) break;
			file_name(name,file, FALSE);
			do_prjscan(file,anz);
			if ((t_icon = still_loaded(name)) >= 0)
			{
				if (!(*do_it)(t_icon)) break;
			}
			else
			{
				set_text_name(t_ptr, name, FALSE);
				if (load(t_ptr, FALSE)<0)
					if (anz<soll && note(2,BREAK)==1) break;
				if (!(*do_it)(TEMP_LINK)) break;
				clear_text(t_ptr);
			}
		}
		if (abbruch())
		{
			if (anz<soll && note(2,BREAK)==1) break;
		}
	}
	destruct_text(t_ptr);
	end_prjscan();
}

LOCAL BOOLEAN delete_prj(WORD icon)
{
	TEXTP t_ptr = get_text(icon);
	WORD	antw;
	FILENAME name;

/* if (!ist_leer(&t_ptr->text) && t_ptr->moved!=0)

	Ungeschickt: wenn man mit ^X alles gelscht hat, wird nicht nachgefragt
	bzw. gesichert, sondern die Datei so gelassen, wie sie war! */

	if (t_ptr->moved!=0)
	{
		if (quick_close)
			antw = 1;
		else
		{
			if (t_ptr->namenlos)
				strcpy(name, t_ptr->filename);
			else
				file_name(t_ptr->filename, name, FALSE);
			antw = fnote(1, MOVED, name);
		}
		if (antw==1)
		{
			if (do_icon(icon,DO_SAVE)<0)
				return (FALSE);
		}
		if (antw==3) return(FALSE);
	}
	return (TRUE);
}

LOCAL VOID chg_prj_name(WORD icon)
{
	WINDOWP 		window;
	FILENAME 	name;
	TEXTP 		t_ptr = get_text(icon);

	file_name(t_ptr->filename, name, TRUE);
	window = get_window (icon);
	set_wtitle(window, name);
}

/***************************************************************************/
/* Operation vorhanden ?																	*/
/***************************************************************************/

LOCAL VOID icon_exist(WORD icon, SET actions)
{
	setclr(actions);
	if (icon & SUB_ICON)
	{
		setincl(actions,DO_DELETE);
		setincl(actions,DO_OPEN);
		setincl(actions,DO_INFO);
		setincl(actions,DO_FIND);
		setincl(actions,DO_HELP);
	}
	else
	{
		WINDOWP window = get_window(icon);
		TEXTP t_ptr = get_text(icon);

		if ((window->flags & WI_ICONIFIED) || (window->flags & WI_SHADED))
		{
			setincl(actions, DO_DELETE);
		}
		else
		{
			if (window->flags & WI_OPEN)
				setincl(actions, DO_CLOSE);
			setincl(actions, DO_DELETE);
			setincl(actions, DO_SELALL);
			setincl(actions, DO_OPEN);
			setincl(actions, DO_INFO);
			setincl(actions, DO_FIND);
			if (!t_ptr->namenlos)
				setincl(actions, DO_ABAND);
			setincl(actions, DO_SAVE);
			setincl(actions, DO_SAVENEW);
			setincl(actions, DO_GOTO);
			setincl(actions, DO_UPDATE);
			setincl(actions, DO_PRINT);
			setincl(actions, DO_HELP);
			setincl(actions, DO_ADD);
			if (t_ptr->moved)
				setincl(actions, DO_AUTOSAVE);
		}
	}
}

/***************************************************************************/
/* Operation testen																			*/
/***************************************************************************/

LOCAL BOOLEAN icon_test(WORD icon, WORD action)
{
	BOOLEAN	erg;

	if (icon & SUB_ICON)		/* Eintrag im Projekt selektiert */
	{
		switch(action)
		{
			case DO_DELETE:	
				erg = TRUE; 
				break;
			case DO_OPEN:	
				erg = TRUE; 
				break;
			case DO_INFO:	
				erg = TRUE; 
				break;
			case DO_FIND:	
				erg = find_dial(TRUE); 
				break;
			case DO_HELP:	
				erg = TRUE; 
				break;
			default:	
				erg = FALSE;
		}
	}
	else
	{
		FILENAME name;
		TEXTP 	t_ptr = get_text(icon);

		switch(action)
		{
			case DO_SELALL:
				erg = TRUE; 
				break;
			case DO_CLOSE:
			case DO_DELETE:	
				erg = delete_prj(icon); 
				break;
			case DO_OPEN:
				erg = TRUE; 
				break;
			case DO_INFO:
				erg = TRUE; 
				break;
			case DO_FIND:
				erg = find_dial(TRUE); 
				break;
			case DO_ABAND:
				if (t_ptr->namenlos)
					erg = FALSE;
				else
				{
					erg = TRUE;
					if (!ist_leer(&t_ptr->text) && t_ptr->moved!=0)
					{
						file_name(t_ptr->filename, name, FALSE);
						erg = (fnote(1,ABANDON,name)==1);
					}
				}
				break;
			case DO_SAVE:
				erg = TRUE; 
				break;
			case DO_SAVENEW:
				erg = TRUE; 
				break;
			case DO_GOTO:
				erg = goto_line_dial(); 
				break;
			case DO_UPDATE :
				erg = TRUE; 
				break;
			case DO_PRINT	:
				erg = TRUE; 
				break;
			case DO_HELP	:
				erg = TRUE; 
				break;
			case DO_ADD 	:
				erg = diskfind_dial(df_path, df_name);
				break;
			case DO_AUTOSAVE :
				if (as_prj && t_ptr->moved)
				{
					WORD	btn;
					LONG	min;

					min = (short)((time(NULL) - t_ptr->asave) / 60L);
					if (min >= as_prj_min)
					{
						if (as_prj_ask)				/* Nachfrage ? */
						{
							FILENAME 	name;

							if (t_ptr->namenlos)
								strcpy(name, t_ptr->filename);
							else
								file_name(t_ptr->filename, name, FALSE);
							mybeep();
							btn = fnote(2, ASAVEASK, name);
							if (btn == 1)
								as_prj = FALSE;
						}
						else
							btn = 2;

						t_ptr->asave = time(NULL);
						erg = (btn == 2);
					}
					else
						erg = FALSE;
				}
				else
				{
					t_ptr->asave = time(NULL);
					erg = FALSE;
				}
				break;
			default:
				erg = FALSE;
		}
	}
	return erg;
}

/***************************************************************************/
/* Operation durchfhren																	*/
/***************************************************************************/

LOCAL WORD do_open(WORD prj_icon, WORD i)
{
	PATH	name;
	WORD	icon;
	BOOLEAN	prj;

	get_prj_line(prj_icon, i, name);
	prj = filematch(name, "*.QPJ");
	if (prj)
	{
		if (global_shift)
			return load_edit(name, FALSE);			/* Laden als Text und ffnen */
		else
			return load_projekt(name);					/* Laden als Projekt und ffnen */
	}
	else
	{
		icon = load_edit(name, FALSE);				/* Laden als Text und ffnen */
		return icon;
	}
}

LOCAL BOOLEAN do_find(WORD icon)
{
	WORD	erg;
	TEXTP t_ptr = get_text(icon);

	erg = start_find(t_ptr,TRUE);
	if (erg==1)
		add_to_projekt(do_find_icon, t_ptr->filename, FALSE);
	return (erg!=-1);
}

LOCAL WORD icon_edit(WORD icon, WORD action)
{
	PATH	name;
	WORD	erg;

	erg = 0;
	if (icon&SUB_ICON)
	{
		WINDOWP window;
		TEXTP t_ptr;
		SET	help;

		icon &= (~SUB_ICON);
		window = get_window(icon);
		if (sel_window==window)
			setcpy(help,sel_objs);
		else
			setclr(help);
		switch (action)
		{
			case DO_DELETE	:
				do_for_prj(icon,help,del_from_projekt,FALSE);
				break;
			case DO_OPEN	:
				do_for_prj(icon,help,do_open,FALSE);
				break;
			case DO_INFO	:
				do_for_prj2(icon,help,info_edit);
				break;
			case DO_FIND	:
				do_find_icon = crt_new_prj("");
				if (do_find_icon < 0)
					break;
				if (do_icon(do_find_icon, DO_OPEN) < 0)
				{
					note(1, NOWINDOW);
					Icon_edit(icon, DO_DELETE);
					break;
				}
				do_for_prj2(icon,help,do_find);
				t_ptr = get_text(do_find_icon);
				if (t_ptr->moved)									/* etwas gefunden? */
				{
					t_ptr->moved = 0;
					window = get_window(do_find_icon);
					if (t_ptr->namenlos)
						strcpy(name, t_ptr->filename);
					else
						file_name(t_ptr->filename, name, TRUE);
					change_window(window, name, FALSE);
					set_sliders(window, VERTICAL, SLPOS+SLSIZE);
					redraw_window(window,&window->work);
				}
				else
					Icon_edit(do_find_icon, DO_DELETE);	/* wenn nicht, gleich wieder zu */
				break;
			case DO_HELP	:
				erg = call_hyp(STRING(HYPPRJSTR));
				break;
		}
		erg = 1;
	}
	else
	{
		TEXTP 	t_ptr = get_text(icon);
		WINDOWP 	window = get_window(icon);
		WORD		i;
		SET		help;
		FILENAME file;
		PATH		h;
		FSEL		fsel;

		switch(action)
		{
			case DO_CLOSE	:
			case DO_DELETE	:
				if (icon == def_icon)
				{
					def_icon = -1;
					set_def_prj();
				}
				destruct(icon);
				erg = 1;
				break;
			case DO_SELALL :
				if (window != sel_window)
					unclick_window();
				if (!ist_leer(&t_ptr->text))
				{
					sel_window = window;
					for (i = (short) t_ptr->text.lines; (--i)>=0; )
						setincl(sel_objs,i);
					redraw_window(window,&window->work);
				}
				erg = 1;
				break;
			case DO_OPEN	:
				if (!open_prj (icon))
					erg = -1;
				else
					erg = 1;
				break;
			case DO_INFO	:
				info_projekt(icon);
				erg = 1;
				break;
			case DO_FIND	:
				setclr(help);
				for (i = (short) t_ptr->text.lines; (--i)>=0; )
					setincl(help,i);
				do_find_icon = crt_new_prj("");
				if (do_find_icon < 0)
					break;
				if (do_icon(do_find_icon, DO_OPEN) < 0)
				{
					note(1, NOWINDOW);
					Icon_edit(icon, DO_DELETE);
					break;
				}
				do_for_prj2(icon,help,do_find);
				t_ptr = get_text(do_find_icon);
				if (t_ptr->moved)									/* etwas gefunden? */
				{
					t_ptr->moved = 0;
					window = get_window(do_find_icon);
					if (t_ptr->namenlos)
						strcpy(h, t_ptr->filename);
					else
						file_name(t_ptr->filename, h, TRUE);
					change_window(window, h, FALSE);
					set_sliders(window, VERTICAL, SLPOS+SLSIZE);
					redraw_window(window,&window->work);
				}
				else
					Icon_edit(do_find_icon, DO_DELETE);	/* wenn nicht, gleich wieder zu */
				erg = 1;
				break;
			case DO_ABAND	:
				strcpy(name, t_ptr->filename);
				desire_y = window->doc.y+1;
				close_window(window);
				destruct_text(t_ptr);
				del_icon(icon);
				setexcl(used_info,icon);
				icon = load_projekt(name);
				if (icon > 0)
				{
					t_ptr = get_text(icon);
					if (t_ptr!=NULL)
					{
						i = (short) (desire_y - window->doc.y);
						arrow_window(window,WA_DNLINE,i);
						restore_edit();
						open_prj(icon);

						memset(msgbuff, 0, (WORD) sizeof(msgbuff));
						msgbuff[0] = WM_TOPPED;
						msgbuff[3] = window->handle;
						send_msg(gl_apid);
		
						erg = 1;
					}
				}
				break;
			case DO_SAVE	:
				if (!t_ptr->namenlos)
				{
					if (save(t_ptr) < 0)
						erg = -1;
					else
					{
						file_name(t_ptr->filename, h, TRUE);
						change_window(window, h, FALSE);
						erg = 1;
					}
					break;
				}
				/* Bei Namenlos zu DO_SAVENEW */
			case DO_SAVENEW:
				strcpy(fsel.name,"");
				strcpy(fsel.suffix,"*.qpj");
				if (save_new(name,&fsel,STRING(SAVEPRJSTR)))
				{
					make_ext(name,"qpj");
					if ((erg=save_as(t_ptr,name))==0)
					{
						if (t_ptr->namenlos || note(1,GETNAME)==1)
						{
							set_text_name(t_ptr, name, FALSE);
							chg_prj_name(icon);
							t_ptr->moved = 0;
							t_ptr->file_date_time = file_time(name,NULL,NULL);
							t_ptr->readonly = file_readonly(name);
						}
						file_name(t_ptr->filename, h, TRUE);
						change_window(window, h, FALSE);
						erg = 1;
					}
				}
				break;
			case DO_GOTO	:
				i = (short) (desire_y - window->doc.y);
				arrow_window(window,WA_DNLINE,i);
				erg = 1;
				break;
			case DO_UPDATE :
				redraw_window(window, &window->work);
				erg = 1;
				break;
			case DO_PRINT	:
				if (t_ptr->namenlos)
					strcpy(file, t_ptr->filename);
				else
					file_name(t_ptr->filename, file, FALSE);
				if (prn_options(FALSE))
					txt_drucken(file,t_ptr);
				erg = 1;
				break;
			case DO_HELP	:
				erg = call_hyp(STRING(HYPPRJSTR));
				break;
			case DO_ADD :
				if (df_path[0]!=EOS)			 /* Pfad durchsuchen */
				{
					set_mouse(HOURGLASS, NULL);
					strcpy(h, df_path);
					if (!caseSens(df_path, NULL))
						str_upper(df_name);
					find_files(h, df_rekursiv, df_name, icon);
					set_mouse(ARROW, NULL);
					redraw_window(window, &window->work);
				}
				break;
			case DO_AUTOSAVE:
				icon_edit(icon, DO_SAVE);
				break;
		}
	}
	return erg;
}

/***************************************************************************/
/* Ein Icon wurde auf ein Projekt-Icon geschoben									*/
/***************************************************************************/

LOCAL BOOLEAN icon_drag (WORD icon, WORD source)
{
	WINDOWP 	window = get_window(icon);
	BOOLEAN	erg = FALSE;
	PATH		h;

 	if ((window->flags & WI_ICONIFIED) || (window->flags & WI_SHADED))
 		return FALSE;

	switch (source)
	{
		case DRAGDROP_FILE :
			if (drag_filename[0] != EOS)
			{
				erg = add_to_projekt(icon, drag_filename, TRUE);
				drag_filename[0] = EOS;
			}
			break;
		case DRAGDROP_PATH :
			if (drag_filename[0] != EOS)
			{
				strcpy(df_path, drag_filename);
				erg = diskfind_dial(df_path, df_name);
				if (erg)
				{
					set_mouse(HOURGLASS, NULL);
					strcpy(h, df_path);
					if (!caseSens(df_path, NULL))
						str_upper(df_name);
					find_files(h, df_rekursiv, df_name, icon);
					set_mouse(ARROW, NULL);
					redraw_window(window, &window->work);
				}
				drag_filename[0] = EOS;
			}
			break;
		case DRAGDROP_DATA :
			mybeep();
			erg = FALSE;
			break;
		default:
			if (debug)
				Debug("projekt.icon_drag(): Unbekannter Mode %d\n", source);
	}
	return erg;
}
/***************************************************************************/

/*
 * Dateien fr Projekt suchen.
 */
LOCAL BOOLEAN find_files(UBYTE *pfad, BOOLEAN rekursiv, UBYTE *df_muster, WORD icon)
{
	TEXTP 	t_ptr;
	UBYTE 	*ptr;
	BOOLEAN	raus;
	WORD		t_icon;
	PATH		suchPfad;
	DIR		*dh;

	if (s_str[0]!=EOS)
	{
		t_ptr = new_text(TEMP_LINK);
		if (t_ptr==NULL) return TRUE;
	}
	strcpy(suchPfad, pfad);
	ptr = pfad + strlen(pfad);
	dh = opendir(suchPfad);
	if (dh != NULL)
	{
		struct dirent	*entry;
		struct stat		st;

		do_find_icon = icon;
		if (dh < 0)
			return FALSE;
		raus = FALSE;
		entry = readdir(dh);
		while (entry != NULL && !raus)
		{
			strcpy(ptr, entry->d_name);
			if (stat(pfad, &st) == 0)
			{
				if ((rekursiv) && (st.st_mode & S_IFDIR) && strcmp(entry->d_name, ".") && strcmp(entry->d_name, ".."))
				{
					strcat(ptr, "\\");
					raus = find_files(pfad, rekursiv, df_muster, icon);
				}

				if (!(st.st_mode & S_IFDIR) && filematch(entry->d_name, df_muster))
				{
					if (s_str[0] != EOS)
					{
						if ((t_icon = still_loaded(pfad)) <0)
						{
							set_text_name(t_ptr, pfad, FALSE);
							if (load(t_ptr,FALSE) < 0)
								if (note(2,BREAK)==1)
									break;
							if (!do_find(TEMP_LINK))
								raus = TRUE;
							clear_text(t_ptr);
						}
						else
						{
							if (!do_find(t_icon))
								raus = TRUE;
						}
					}
					else
						add_to_projekt(icon, pfad, TRUE);
				}
			}
			entry = readdir(dh);
			if (abbruch() && note(2, BREAK) == 1)
				raus = TRUE;
		} /* while */
		if (entry != NULL)
			raus = TRUE;
		closedir(dh);
		if (s_str[0] != EOS)
			destruct_text(t_ptr);
		return raus;
	}
	return FALSE;
}

/***************************************************************************/

LOCAL VOID get_prj_line(WORD link, WORD line, UBYTE *str)
{
	TEXTP 	t_ptr = get_text(link);
	ZEILEP	lauf;

	lauf = get_line(&t_ptr->text,line);
	if (lauf != NULL)
		strcpy(str, TEXT(lauf));
	else
		str[0] = EOS;
}

/***************************************************************************/

LOCAL WORD del_from_projekt (WORD link, WORD line)
{
	TEXTP 	t_ptr = get_text(link);
	ZEILEP	lauf;
	FILENAME	name;
	
	lauf = get_line(&t_ptr->text,line);
	if (lauf!=NULL)
	{
		WINDOWP window = get_window(link);

		unclick_window();
		if (t_ptr->text.lines>1)
		{
			col_delete(&t_ptr->text, lauf);
			window->doc.h--;
			set_sliders(window, VERTICAL, SLPOS+SLSIZE);
			redraw_window(window,&window->work);
		}
		else
		{
			REALLOC(&lauf,0,-lauf->len);
			redraw_window(window,&window->work);
		}
		t_ptr->moved++;
		if (t_ptr->namenlos)
			strcpy(name, t_ptr->filename);
		else
			file_name(t_ptr->filename, name, TRUE);
		change_window(window, name, TRUE);				/* '*' in den Titel */
	}
	return 1;
}

BOOLEAN add_to_projekt (WORD link, UBYTE *name, BOOLEAN draw)
{
	WORD		erg, i;
	TEXTP 	t_ptr = get_text(link);
	PATH		file;

	if (!caseSens(name, NULL))
		str_upper(name);

	strcpy(file,name);
	if (!make_normalpath(file,TRUE)) 
		return FALSE;
	erg = 1; i = 0;
	get_prj_line(link,i,file);
	while (file[0] != EOS && (erg = strcmp(file, name)) < 0)
	{
		i++;
		get_prj_line(link,i,file);
	}
	if (erg) 			/* noch nicht vorhanden */
	{
		WINDOWP window = get_window(link);

		if (ist_leer(&t_ptr->text))
			INSERT(&FIRST(&t_ptr->text),0,(short)strlen(name),name);
		else
		{
			ZEILEP new, lauf;

			if (i==0)
				lauf = &t_ptr->text.head;
			else
				lauf= get_line(&t_ptr->text,i-1);
			new = new_col(name,(short)strlen(name));
			col_insert(lauf,new);
			t_ptr->text.lines++;
			window->doc.h++;
			if (draw)
				set_sliders(window, VERTICAL, SLPOS+SLSIZE);
		}
		if (draw)
			redraw_window(window,&window->work);
		t_ptr->moved++;
		if (t_ptr->namenlos)
			strcpy(file, t_ptr->filename);
		else
			file_name(t_ptr->filename, file, TRUE);
		change_window(window, file, TRUE);					/* '*' in den Titel */
		return TRUE;
	}
	return FALSE;
}

GLOBAL WORD load_projekt(UBYTE *name)
/* return: <=0 wurde nicht geladen */
/* 		  0	weitere Texte versuchen sinnvoll */
/* 		  <0	weiter Texte versuchen nicht sinnvoll */
{
	WORD		err, icon;
	WINDOWP 	window;
	FILENAME datei;
	PATH		path;
	TEXTP 	t_ptr;

	if (!caseSens(name, NULL))
		str_upper(name);

	set_fsel_path(name);
	file_splitt(name, path, datei);
	if ((icon = prj_still_loaded(name)) >= 0)	/* schon geladen */
	{
		if (do_icon(icon, DO_OPEN) < 0)			/* nur Fenster auf */
			note(1, NOWINDOW);
		return icon;
	}
	icon = crt_new_prj(name);
	if (icon<0)
	{
		note(1,NOTEXT);
		return -1;
	}
	t_ptr = get_text(icon);;
	if ((err = load(t_ptr, TRUE)) == -33)		/* File not Found */
	{
		if (path_exist(path))
		{
			if (fnote(1,NEWTEXT,datei)==2)
			{
				Icon_edit(icon,DO_DELETE);
				return 0;
			}
		}
		else
		{
			fnote(1, READERR, datei);
			Icon_edit(icon,DO_DELETE);
			return 0;
		}
	}
	else if (err)										/* anderer Fehler */
	{
		fnote(1, READERR, datei);
		Icon_edit(icon,DO_DELETE);
		return 0;
	}

	window = get_window(icon);
	window->doc.y = 0;
	window->doc.h = t_ptr->text.lines;
	if (do_icon(icon,DO_OPEN) < 0)
	{
		note(1, NOWINDOW);
		Icon_edit(icon,DO_DELETE);
		icon = -2;
	}

	if (strip_endings(t_ptr))
	{
		file_name(t_ptr->filename, datei, TRUE);
		change_window(window, datei, TRUE);
	}
	
	if (strcmp(name, def_prj_path) == 0)		/* Default-Prj wurde geladen */
	{
		def_icon = icon;
		set_def_prj();
	}
	return icon;
}

LOCAL VOID destruct(WORD icon)
{
	TEXTP t_ptr = get_text(icon);
	WINDOWP window = get_window(icon);

	close_window(window);
	destruct_text(t_ptr);
	del_icon(icon);
	setexcl(used_info,icon);
	do_all_icon(prj_type,DO_UPDATE); 	/* Projekte updaten */
}

/***************************************************************************/
/* Anlegen eines neuen Projekts															*/
/***************************************************************************/

WORD new_prj(VOID)
{
	WORD	icon;

	icon = crt_new_prj("");
	if (icon < 0)
	{
		note(1,NOTEXT);
		return -1;
	}
	if (do_icon(icon, DO_OPEN) < 0)
	{
		note(1, NOWINDOW);
		Icon_edit(icon, DO_DELETE);
		icon = -3;
	}
	return icon;
}

WORD crt_new_prj (CONST UBYTE *filename)
{
	WINDOWP	win;
	BOOLEAN	namenlos;
	TEXTP 	t_ptr;
	PATH		name;

	strcpy(name, filename);
	if (name[0] == EOS)
	{
		strcpy(name, STRING(NAMENLOS));
		namenlos = TRUE;
	}
	else
		namenlos = FALSE;

	/* Fenster anlegen */
	win = create_window(KIND, CLASS_PROJEKT, crt_prj);
	if (win == NULL)
		return -1;
	if (!add_icon(prj_type, win->handle))
		return -1;

	/* Text kreiern */
	t_ptr = new_text(win->handle);
	if (t_ptr == NULL)
	{
		del_icon(win->handle);
		return -1;
	}
	set_text_name(t_ptr, name, namenlos);
	setincl(used_info, win->handle);

	if (t_ptr->namenlos)
		strcpy(name, t_ptr->filename);
	else
		file_name(t_ptr->filename, name, TRUE);
	set_wtitle(win, name);
	set_winfo(win, "");

	if (!namenlos)
		do_all_icon(prj_type,DO_UPDATE); 	/* Projekte updaten */

	t_ptr->asave = time(NULL);

	return win->handle;
}

/***************************************************************************/
/* Kreieren eines Fensters 																*/
/***************************************************************************/
LOCAL VOID crt_prj(WINDOWP window)
{
	WORD	initw, inith;

	if (window->work.g_w == 0 || window->work.g_h == 0)
	{
		/* Keine Gre bekannt. */
		initw  = gl_wchar * 13;
		inith  = (desk.g_h / gl_hchar) * gl_hchar - 7 * gl_hchar;
		window->work.g_x	= sys_wchar + 2 * 8;
		window->work.g_y	= 60;
		window->work.g_w	= initw;
		window->work.g_h	= inith;
	}
	
	window->flags		= FLAGS;
	window->doc.w		= 13;
	window->doc.h		= 0;
	window->xfac		= gl_wchar;
	window->yfac		= gl_hchar;
	window->w_width	= initw/gl_wchar;
	window->w_height	= inith/gl_hchar;
	window->draw		= wi_draw;
	window->click		= wi_click;
	window->unclick	= wi_unclick;
	window->key 		= wi_key;
	window->snap		= wi_snap;
	window->iconify	= wi_iconify;
	window->uniconify = wi_uniconify;
}

/***************************************************************************/
/* ffnen des Objekts																		*/
/***************************************************************************/
LOCAL BOOLEAN open_prj (WORD icon)
{
	BOOLEAN	ok = TRUE;
	WINDOWP 	window = get_window(icon);

	if (window->flags & WI_ICONIFIED)
		uniconify_window(window, NULL);
	else if (window->flags & WI_SHADED)
		shade_window(window, -1);
	else if (window->flags & WI_OPEN)
		top_window (window);
	else
		ok = open_window (window);
	return ok;
}

/***************************************************************************/

LOCAL VOID draw_line (WINDOWP window, WORD line)
{
	TEXTP t_ptr;
	GRECT	r;

	t_ptr = get_text(window->handle);
	if (line >= t_ptr->text.lines) 
		return;
	line -= (short)window->doc.y;
	if (line < 0) 
		return;
	if (line>=window->w_height) return;
	r.g_x = window->work.g_x;
	r.g_y = window->work.g_y + line * gl_hchar;
	r.g_w = window->work.g_w;
	r.g_h = gl_hchar;
	redraw_window(window, &r);
}

LOCAL VOID wi_draw (WINDOWP window, CONST GRECT *d)
{
	ZEILEP lauf;
	TEXTP t_ptr;
	WORD	line, y, x, i, link;
	PATH	name, str;

	set_clip(TRUE,d);
	line = (short)window->doc.y;
	y = window->work.g_y;
	x = window->work.g_x;
	i = window->w_height;
	if (d->g_y > y)
	{
		WORD anz;

		anz = (d->g_y - y) / gl_hchar;
		line += anz;
		y += anz * gl_hchar;
		i -= anz;
	}
	if (d->g_y + d->g_h < window->work.g_y + window->work.g_h)
	{
		WORD anz;

		anz = ((window->work.g_y + window->work.g_h)-(d->g_y + d->g_h)) / gl_hchar;
		i -= anz;
	}
	link = window->handle;
	t_ptr = get_text(link);
	lauf = get_line(&t_ptr->text,line);
	if (lauf!=NULL)
	{
		while ((--i)>=0)
		{
			get_prj_line(link, line, str);
			if (str[0] == EOS)
			{
				i++;
				break;
			}

			if ((still_loaded(str) >= 0) || (prj_still_loaded(str) >= 0)) 
				name[0] = '*';
			else 
				name[0] = ' ';
			make_shortpath(str, name + 1, window->w_width - 1);
			if (window == sel_window && setin(sel_objs,line))
				outsB(x, y, window->work.g_w, name);
			else
				outs(x, y, window->work.g_w, name);
			line++;
			y += gl_hchar;
		}
	}
	for (; (--i)>=0; y += gl_hchar)
		fill_line(x, y, window->work.g_w, WHITE);
}

/***************************************************************************/
LOCAL WORD drag_objs(WORD w, WORD h, WORD x, WORD y, MOUSEDATA *mouse)
{
	WORD		wh, d;
	
	set_mouse(FLAT_HAND, NULL);
	graf_dragbox(w, h, x, y, &desk, &d, &d);
	set_mouse(ARROW, NULL);
	graf_mkstate((EVNTDATA*)mouse);
	wh = wind_find(mouse->x, mouse->y);
	return wh;
}

LOCAL VOID wi_click (WINDOWP window, MOUSEDATA *mouse)
{
	WORD		y;
	GRECT		*s = &window->work;
	PATH		str;
	SET		new_obj;
	EVNTDATA	dummy;
	
	if (mouse->bstate & 2)								/* Rechtsklick */
		return;

	if (!inside(mouse->x, mouse->y, s))
		return;

	if (sel_window != window)
		unclick_window();
	set_winfo(window,"");

	y = (short)(window->doc.y) + (mouse->y - s->g_y) / gl_hchar;
	get_prj_line(window->handle, y, str);
	if (str[0] == EOS)
		return;

	setclr(new_obj);
	setincl(new_obj, y);									/* Aktuelles Objekt */

	if (mouse->kstate & (K_RSHIFT|K_LSHIFT))
	{
		setxor (sel_objs, new_obj);
		if (setcmp(sel_objs, NULL))
			sel_window = NULL;
		else
			sel_window = window;
		draw_line (window, y);
		if (!setin (sel_objs, y))
		{
			graf_mkstate (&dummy);
			if (dummy.bstate & 1)						/* Immernoch gedrckt ? */
				evnt_button(1, 1, 0, &dummy);
			return;
		}
	}
	else 														/* noch nicht angeklickt */
	{
		graf_mkstate((EVNTDATA*)mouse);
		if (!(mouse->bstate & 1))						/* Immernoch gedrckt -> nichts tun */
		{
			BOOLEAN	re_sel;

			re_sel = setcmp(new_obj, sel_objs);
			unclick_window ();							/* Alle Objekte lschen */

			/* re_sel ist TRUE, wenn ein Eintrag zum zweiten Mal selektiert wurde
			 * -> wieder deselektieren.
			*/
			if (!re_sel)
			{
				setincl(sel_objs, y);
				sel_window = window;
			}
			draw_line(window, y);
		}
	}
	if (mouse->breturn == 1 && mouse->bstate & 1)	/* Zieh-Operation */
	{
		GRECT		first;
		WORD		num_objs, i, obj;
		WINDOWP	qed_win;

		graf_mkstate(&dummy);
		if (!(dummy.bstate & 1))
			return; 					/* Immernoch gedrckt ? */

		if (window == sel_window)
			setcpy(new_obj,sel_objs);
		num_objs = 0;
		for (i = 0; i < window->w_height; i++)
		{
			if (setin(new_obj, i + (short)window->doc.y))
			{
				if (num_objs == 0)		/* Abmessungen des ersten merken */
				{
					first.g_x = s->g_x;
					first.g_y = s->g_y + (i * gl_hchar);
					first.g_w = s->g_w;
				}
				num_objs++;
			}
		}
		obj = drag_objs(first.g_w, gl_hchar * num_objs, first.g_x, first.g_y, mouse);
		qed_win = get_window(obj);
		if (qed_win)												/* eigenes Fenster */
		{
			if (qed_win != window && (qed_win->class == CLASS_PROJEKT ||
											  qed_win->class == CLASS_EDIT))
			{
				drag_data_size = num_objs;
				for (i = 0; i < window->w_height; i++)
					if (setin(new_obj, i + (short)window->doc.y))
					{
						get_prj_line(window->handle, i + (short)window->doc.y, drag_filename);
						if (drag_filename[0] == EOS)
							break;
						if ((mouse->kstate & K_ALT) || (qed_win->class == CLASS_PROJEKT))
							Icon_drag(qed_win->handle, DRAGDROP_FILE);
						if (mouse->kstate & (K_LSHIFT|K_RSHIFT))
							Icon_drag(qed_win->handle, DRAGDROP_PATH);
					}
				drag_data_size = 0;
			}
		}
		else											/* fremdes Fenster */
		{
			/* 
			 * Bisher wird immer an den Desktop geschickt,
			 * aber nur, wenn dieser AV_DRAG_ON_WINDOW kann.
			*/
			if ((av_shell_id >= 0) && (av_shell_status & 512))
			{		
				if (num_objs > 1)
				{
					drag_data_size = (LONG)num_objs * sizeof(PATH);
					drag_data = (UBYTE *)malloc(drag_data_size);
					strcpy(drag_data, "");
				}
				else
				{
					drag_data_size = 0L;
					drag_data = NULL;
				}
					
				for (i=0; i<window->w_height; i++)
				{
					if (setin(new_obj, i + (short)window->doc.y))
					{
						get_prj_line(window->handle, i + (short)window->doc.y, drag_filename);
						if (drag_filename[0] != EOS)
						{
							if (num_objs > 1)
							{
								if (drag_data[0] != EOS)
									strcat(drag_data, " ");
								strcat(drag_data, drag_filename);
							}
						/*	else steht das Arg in drag_filename */
						}
					}
				} /* for */

				if (num_objs > 1)
					send_avdrag(obj, mouse, DRAGDROP_DATA);
				else
					send_avdrag(obj, mouse, DRAGDROP_PATH);

				if (drag_data_size > 0)
				{
					free(drag_data);
					drag_data_size = 0;
				}
			} /* if av_ */
		} /* if !my_window */
	}
	if (mouse->breturn == 2)							/* Doppelklick */
	{
		unclick_window();
		sel_window = window;
		setincl(sel_objs,y);
		draw_line(window,y);
		graf_mkstate(&dummy);
		if (dummy.bstate & 1)							/* Immernoch gedrckt ? */
			evnt_button(1, 1, 0, &dummy);
		do_icon(window->handle + SUB_ICON, DO_OPEN);
	}
}

/***************************************************************************/

LOCAL VOID wi_unclick (WINDOWP window)
{
	SET	help;
	WORD	i, max;

	setcpy(help,sel_objs);
	setclr(sel_objs);
	max = setmax(help);
	for (i=setmin(help); i<=max; i++)
		if (setin(help,i))
			draw_line(window,i);
	set_winfo(window,"");
}

/***************************************************************************/

LOCAL VOID sel_line(WINDOWP window, WORD line)
{
	if (sel_window!=NULL)
		unclick_window();
	sel_window = window;
	setincl(sel_objs,line);
	draw_line(window,line);
	line -= (short) window->doc.y;
	if (line<0)
		arrow_window(window,WA_UPLINE,-line);
	else
	{
		line -= (window->w_height-1);
		if (line>0)
			arrow_window(window,WA_DNLINE,line);
	}
}


LOCAL VOID shift_up(WINDOWP window)
{
	WORD	i;

	if (window->doc.h == 0)
		return;
	if (sel_window == window)
	{
		i = setmin(sel_objs);
		if (i == 0)
			return ;
		i -= window->w_height;
		if (i < 0)
			i = 0;
		sel_line(window,i);
	}
	else
		sel_line(window, (short)window->doc.h-1);
}

LOCAL VOID shift_down(WINDOWP window)
{
	WORD	i;

	if (window->doc.h == 0)
		return ;
	if (sel_window == window)
	{
		i = setmin(sel_objs);
		if (i == window->doc.h - 1)
			return ;
		i += window->w_height;
		if (i >= window->doc.h)
			i = (short) window->doc.h - 1;
		sel_line(window,i);
	}
	else
		sel_line(window,0);
}

LOCAL BOOLEAN wi_key (WINDOWP window, KEYDATA *key)
{
	UBYTE 	asc;
	WORD		i, k;
	BOOLEAN	erg;

	/* Damit F-Tasten zum System-Desktop kommen! */
	if ((key->kreturn >= 0x3B00 && key->kreturn <= 0x4400) ||
		 (key->kreturn >= 0x5400 && key->kreturn <= 0x5D00))
		return FALSE;

	erg = FALSE;
	if ((key->normkey & NKF_FUNC) && (key->normkey & NKF_SHIFT))
	{
		k = key->normkey & ~(NKF_FUNC|NKF_SHIFT);
		switch (k)
		{
			case NK_CLRHOME :
				v_slider(window, 1000);
				sel_line(window, (short)window->doc.h - 1);
				erg = TRUE;
				break;
			case NK_UP	:
				shift_up(window);
				erg = TRUE;
				break;
			case NK_DOWN:
				shift_down(window);
				erg = TRUE;
				break;
			default:
				erg = FALSE;
				break;
		}
	}
	else if (key->normkey & NKF_FUNC)
	{
		k = key->normkey & ~(NKF_FUNC);
		switch (k)
		{
			case NK_RET :
			case (NK_ENTER|NKF_NUM) :
				do_icon(window->handle + SUB_ICON, DO_OPEN);
				erg = TRUE;
				break;
			case NK_CLRHOME :
				v_slider(window, 0);
				sel_line(window,0);
				erg = TRUE;
				break;
			case NK_UP :
				if (window->doc.h == 0)
					break;
				if (sel_window == window)
				{
					i = setmin(sel_objs);
					if (i == 0)
						break;
					i--;
					if (i < 0)
						i = 0;
					sel_line(window,i);
				}
				else
					sel_line(window, (short)window->doc.h - 1);
				erg = TRUE;
				break;
			case NK_DOWN:
				if (window->doc.h == 0)
					break;
				if (sel_window == window)
				{
					i = setmin(sel_objs);
					if (i==window->doc.h-1)
						break;
					i++;
					if (i >= window->doc.h)
						i = (short) window->doc.h-1;
					sel_line(window,i);
				}
				else
					sel_line(window,0);
				erg = TRUE;
				break;
			case NK_HELP :
				erg = FALSE;				/* DO_HELP wird von key_global verteilt */
				break;
			case NK_M_PGUP:				/* Mac: page up -> shift-up */
				shift_up(window);
				erg = TRUE;
				break;
			case NK_M_PGDOWN:				/* Mac: page down -> shift-down */
				shift_down(window);
				erg = TRUE;
				break;
			case NK_M_END:					/* Mac: end -> shift-home */
				v_slider(window, 1000);
				sel_line(window, (short)window->doc.h - 1);
				erg = TRUE;
				break;
			default:
				if (!(key->ctrl) && !(key->alt) && (!key->shift) && key->ascii_code)
				{
					if (sel_window == window)
						unclick_window();
					else
						set_winfo(window,"");
					erg = TRUE;
				}
				else
					erg = FALSE;
				break;
		}
	}
	else
	{
		WORD		l;
		FILENAME name;
		PATH		str, info;

		/* Auto-Locator */
		asc = nkc_toupper(key->ascii_code);
		strcpy(info, window->info);
		l = (short) strlen(info);
		info[l++] = asc;
		info[l] = EOS;
		i = 0;
		do
		{
			get_prj_line(window->handle,i,str);
			i++;
			if (str[0]==EOS)
				break;
			file_name(str,name, FALSE);
			str_upper(name);
		}
		while (strncmp(name, info, l) != 0);
		if (str[0]!=EOS)
		{
			sel_line(window,i-1);
			set_winfo(window,info);
		}
		erg = TRUE;
	}
	return erg;
}

/***************************************************************************/

LOCAL VOID	wi_snap(WINDOWP window, GRECT *new, WORD mode)
{
	WORD w, ex, pxy[8];

	/* zunchst Platz fr min. 1+Filename+1 im Fenster */
	vqt_extent(vdi_handle, "x", pxy);
	ex = pxy[2] - pxy[0];
	w = new->g_w;
	if (w < 14 * ex)
		w = 14 * ex;

	/* nun noch Platz fr Fenstertitel (1+8+1) */
	if (w < sys_wchar * 10)
		w = sys_wchar * 10;

	new->g_w = w;
}


LOCAL VOID wi_iconify(WINDOWP window)
{
	TEXTP 	t_ptr = get_text(window->handle);
	FILENAME short_name;

	make_shortpath(t_ptr->filename, short_name, 8);
	set_wtitle(window, short_name);
}


LOCAL VOID wi_uniconify(WINDOWP window)
{
	TEXTP 	t_ptr = get_text(window->handle);
	FILENAME name;

	file_name(t_ptr->filename, name, TRUE);
	set_wtitle(window, name);
}

/***************************************************************************/
/* Info des Objekts																			*/
/***************************************************************************/

LOCAL LONG len, bytes;
LOCAL WORD	anz, i_icon;

LOCAL WORD count(WORD icon, WORD i)
{
	PATH	name;

	anz++;
	get_prj_line(icon,i,name);
	if ((icon = still_loaded(name))>=0)
	{
		TEXTP t_ptr;

		t_ptr = get_text(icon);
		bytes += textring_bytes(&t_ptr->text);
		len += t_ptr->text.lines;
		return 1;
	}
	else
	{
		LONG	b,l;
		WORD	antw;

		antw = infoload(name,&b,&l);
		bytes += b;
		len += l;
		return (antw==0)?1:0;
	}
}

LOCAL BOOLEAN info_projekt (WORD icon)
{
	UBYTE 	str[32], date[11];
	TEXTP 	t_ptr = get_text(icon);
	WORD		r_anz, i, antw;
	SET		all;
	BOOLEAN	quit = FALSE;
	DIALINFO	dial;

	disable_objc(prjinfo, IPRJSCAN, FALSE);
	i_icon = icon;
	make_shortpath(t_ptr->filename, str, 30);
	fill_ptext (prjinfo, PRJNAME, str); 		/* Name mit Pfad */
	if (ist_leer(&t_ptr->text))
		r_anz = 0;
	else
		r_anz = (short) t_ptr->text.lines;
	ltoa(r_anz,str,10);
	fill_ptext (prjinfo, PRJFILES, str);		/* Dateien-Anzahl */
	str[0] = EOS;
	fill_ptext (prjinfo, PRJLEN , str); 		/* Lnge in Bytes */
	fill_ptext (prjinfo, PRJZEILE , str);		/* Lnge in Zeilen */
	if (t_ptr->namenlos)
	{
		strcpy(str, "");
		strcpy(date, "--");
	}
	else
		file_time (t_ptr->filename, date, str);
	fill_ptext (prjinfo, PRJDATUM, date);		/* Datum */
	fill_ptext (prjinfo, PRJZEIT, str); 		/* Uhrzeit */

	open_dial(prjinfo, &dial);
	dial_draw(&dial);
	do
	{
		antw = dial_do(&dial, NULL) & 0x7FFF;
		switch (antw)
		{
			case IPRJSCAN:
				if (ist_leer(&t_ptr->text))
					r_anz = 0;
				else
					r_anz = (short) t_ptr->text.lines;
				anz = 0;
				bytes = len = 0;
				setclr(all);
				for (i=r_anz; (--i)>=0; )
					setincl(all,i);
				do_for_prj(i_icon, all, count, TRUE);
				if (r_anz==anz)									/* alle durchlaufen */
					ltoa(bytes,str,10);
				else
					str[0] = EOS;
				fill_ptext (prjinfo, PRJLEN , str); 		/* Lnge in Bytes */
				draw_Objc(prjinfo, PRJLEN, 1);
				if (r_anz==anz)
					ltoa(len,str,10);
				else
					str[0] = EOS;
				fill_ptext (prjinfo, PRJZEILE , str);		/* Lnge in Zeilen */
				draw_Objc(prjinfo, PRJZEILE, 1);
				if (r_anz==anz)									/* alle durchlaufen */
				{
					disable_objc(prjinfo, IPRJSCAN, TRUE);
					draw_Objc(prjinfo, IPRJSCAN, 1);
				}
				break;
			default:
				quit = TRUE;
				break;
		}
		select_objc(prjinfo, antw, FALSE);
		draw_Objc(prjinfo, antw, 1);
	}
	while (!quit);
	dial_end(&dial);
	return TRUE;
}

/******************************************************************************/
/* Default-Projekt																				*/
/******************************************************************************/

VOID	open_def_prj(VOID)
{
	if (def_prj_path[0] != EOS && global_shift)	/* altes abmelden */
	{
		def_prj_path[0] = EOS;
		def_icon = -1;
	}
	else if (def_prj_path[0] != EOS) 				/* bekanntes ffnen */
		load_projekt(def_prj_path);
	else
		select_def_prj(); 								/* nix bekannt, also auswhlen */
	set_def_prj(); 		/* Men anpassen */
}


VOID	add_to_def(VOID)
{
	WINDOWP w;

	w = real_top();
	if (w == NULL)
		return;
	if (w->handle != def_icon)
	{
		TEXTP t_ptr = get_text(w->handle);

		if (!t_ptr->namenlos)
			add_to_projekt(def_icon, t_ptr->filename, TRUE);
	}
}


LOCAL VOID	select_def_prj(VOID)
{
	FSEL		fsel = {"", "*.qpj"};
	PATH		name = "";

	if (select_file(&fsel, name, STRING(DEFPRJ2STR)))
	{
		strcpy(def_prj_path, name);
		load_projekt(def_prj_path);
	}
}


VOID	set_def_prj(VOID)
{
	FILENAME n = "";

	if (def_icon == -1 || def_prj_path[0] == EOS)
	{
		menu_ienable(menu, MTAKEPRJ, FALSE);
		menu_icheck(menu, MPROJEKT, FALSE);
	}
	else
	{
		menu_ienable(menu, MTAKEPRJ, TRUE);
		menu_icheck(menu, MPROJEKT, TRUE);
	}

	/* Name ins Men eintragen */
	if (def_prj_path[0] != EOS)
		file_name(def_prj_path, n, FALSE);
	else
		strcpy(n, STRING(DEFPRJSTR));
	fillup_menu(MPROJEKT, n, 2);
}

GLOBAL VOID find_on_disk(VOID)
{
	WORD	icon;

	icon = crt_new_prj("");
	if (icon < 0) 
		return;
	if (do_icon(icon, DO_OPEN) < 0)
	{
		note(1, NOWINDOW);
		Icon_edit(icon, DO_DELETE);
	}
	do_icon(icon, DO_ADD);
}

/******************************************************************************/
/* Initialisierung																				*/
/******************************************************************************/

GLOBAL VOID	init_projekt(VOID)
{
	get_path(df_path, 0);							/* Aktuellen Pfad holen */
	setclr(used_info);
	prj_type = decl_icon_type(icon_test,icon_edit,icon_exist,icon_drag);
	def_prj_path[0] = EOS;
	def_icon = -1;
}
