#include "global.h"
#include "rsc.h"

/*
 * exportierte Variablen
 */
GLOBAL OBJECT 	*menu;
GLOBAL OBJECT 	*about;
GLOBAL OBJECT 	*about2;
GLOBAL OBJECT 	*printer;
GLOBAL OBJECT 	*textinfo;
GLOBAL OBJECT 	*prjinfo;
GLOBAL OBJECT	*blockinfo;
GLOBAL OBJECT	*sort;
GLOBAL OBJECT 	*replace;
GLOBAL OBJECT	*repask;
GLOBAL OBJECT 	*diskfind;
GLOBAL OBJECT 	*pos;
GLOBAL OBJECT 	*marken;
GLOBAL OBJECT 	*makrorep;
GLOBAL OBJECT 	*funktionstasten;
GLOBAL OBJECT	*umlautkonv;
GLOBAL OBJECT	*fehler;
GLOBAL OBJECT 	*globalop;
GLOBAL OBJECT 	*localop;
GLOBAL OBJECT 	*muster;
GLOBAL OBJECT 	*musterchg;
GLOBAL OBJECT	*autosave;
GLOBAL OBJECT	*klammer;
GLOBAL OBJECT	*seoptions;

GLOBAL OBJECT 	*aktion;
GLOBAL OBJECT 	*prjscan;
GLOBAL OBJECT 	*winicon;

GLOBAL OBJECT 	*fhilfe;
GLOBAL OBJECT 	*rphilfe;
GLOBAL OBJECT 	*dfhilfe;
GLOBAL OBJECT 	*popups;
GLOBAL OBJECT 	*strings;

GLOBAL UBYTE	**alertmsg;

GLOBAL BOOLEAN	mydials_are_init = FALSE;

EXTERN BOOLEAN	use_dial_3d;	/* -> options.h */

/****** VARIABLES **********************************************************/

LOCAL BOOLEAN	rsc_init = FALSE;

/***************************************************************************/
/* Initialisieren des Moduls																*/
/***************************************************************************/

GLOBAL BOOLEAN init_resource(VOID)
{
	PATH	rsc_path = "qed.rsc";

	shel_find(rsc_path);
	if (file_exist(rsc_path))
		rsc_init = rsrc_load(rsc_path);
	if (!rsc_init)
	{
		UBYTE	*p;

		p = getenv("QED");
		if (p != NULL)
		{
			strcpy(rsc_path, p);
			if (make_normalpath(rsc_path, FALSE))
			{
				strcat(rsc_path, "qed.rsc");
				if (file_exist(rsc_path))
					rsc_init = rsrc_load(rsc_path);
			}
		}
		if (!rsc_init)
			form_alert(1, "[3][Resource-File|qed.rsc??][Exit]");
	}

	if (rsc_init)
	{
		rsrc_gaddr(R_TREE, MENUTREE,	&menu);

		rsrc_gaddr(R_TREE, ABOUT,		&about);
		rsrc_gaddr(R_TREE, ABOUT2,		&about2);

		rsrc_gaddr(R_TREE, PRINTER,	&printer);
		rsrc_gaddr(R_TREE, TEXTINFO,	&textinfo);
		rsrc_gaddr(R_TREE, PRJINFO,	&prjinfo);
		rsrc_gaddr(R_TREE, BLOCKINFO, &blockinfo);
		rsrc_gaddr(R_TREE, SORT,      &sort);

		rsrc_gaddr(R_TREE, REPLACE,	&replace);
		rsrc_gaddr(R_TREE, REPASK,		&repask);
		rsrc_gaddr(R_TREE, DISKFIND,	&diskfind);
		rsrc_gaddr(R_TREE, POS,			&pos);
		rsrc_gaddr(R_TREE, MARKEN,		&marken);

		rsrc_gaddr(R_TREE, MAKROREP, 	&makrorep);
		rsrc_gaddr(R_TREE, FUNKTION,	&funktionstasten);
		rsrc_gaddr(R_TREE, UMLAUTE, 	&umlautkonv);
		rsrc_gaddr(R_TREE, FEHLER, 	&fehler);

		rsrc_gaddr(R_TREE, GLOBALOP,	&globalop);
		rsrc_gaddr(R_TREE, LOCALOP,	&localop);
		rsrc_gaddr(R_TREE, MUSTER,		&muster);
		rsrc_gaddr(R_TREE, MUSTERCH, 	&musterchg);
		rsrc_gaddr(R_TREE, AUTOSAVE,  &autosave);
		rsrc_gaddr(R_TREE, KLAMMER,	&klammer);

		rsrc_gaddr(R_TREE, SEOPTION, 	&seoptions);

		rsrc_gaddr(R_TREE, AKTION,		&aktion);
		rsrc_gaddr(R_TREE, PRJSCAN,	&prjscan);
		rsrc_gaddr(R_TREE, WINICON,	&winicon);

		rsrc_gaddr(R_TREE, FHILFE,		&fhilfe);
		rsrc_gaddr(R_TREE, RPHILFE,	&rphilfe);
		rsrc_gaddr(R_TREE, DFHILFE,	&dfhilfe);
		rsrc_gaddr(R_TREE, POPUPS,		&popups);
		rsrc_gaddr(R_TREE, STRINGS,   &strings);

		rsrc_gaddr(R_FRSTR, SCREEN,	&alertmsg);
	}
	return rsc_init;
}


/*
 * Inititialisierung der MyDials. Erfolgt, nachdem die Parameter geladen
 * sind!!
*/
GLOBAL VOID init_mydials(VOID)
{
	if (rsc_init && !mydials_are_init)
	{
		mydial_init(use_dial_3d, 700);
		mydials_are_init = TRUE;

		dial_fix(menu);
		dial_fix(about);
		dial_fix(about2);
		dial_fix(printer);
		dial_fix(textinfo);
		dial_fix(prjinfo);
		dial_fix(blockinfo);
		dial_fix(sort);
		dial_fix(replace);
		dial_fix(repask);
		dial_fix(diskfind);
		dial_fix(pos);
		dial_fix(marken);
		dial_fix(makrorep);
		dial_fix(funktionstasten);
		dial_fix(umlautkonv);
		dial_fix(fehler);
		dial_fix(globalop);
		dial_fix(localop);
		dial_fix(muster);
		dial_fix(musterchg);
		dial_fix(autosave);
		dial_fix(klammer);
		dial_fix(seoptions);

		dial_fix(aktion);
		dial_fix(prjscan);

		dial_fix(fhilfe);
		dial_fix(rphilfe);
		dial_fix(dfhilfe);
		dial_fix(popups);

		/* Men ist breiter als 640, ggf. anpassen */
		if (desk.g_w > 640)
			menu[MSOPT - 1].ob_x += 5 * sys_wchar;
		else
			menu[MSOPT - 1].ob_x -= 1 * sys_wchar;
			
		
		/* Hintergrundfarbe Iconify */
		if (planes > 1)
			winicon[WIBOX].ob_spec.obspec.interiorcol = LWHITE;

		/* Titel der Zeichenauswahl eintragen */
		ascii_head(STRING(ZEICHSTR));
	}
}

/***************************************************************************/
/* Terminieren des Moduls																	*/
/***************************************************************************/
GLOBAL VOID term_resource (VOID)
{
	if (rsc_init)
	{
		rsrc_free();
		mydial_exit();
		mydials_are_init = FALSE;
	}
}
