#include "global.h"
#include "edit.h"
#include "comm.h"
#include "file.h"
#include "icon.h"
#include "menu.h"
#include "obj.h"
#include "rsc.h"
#include "text.h"
#include "window.h"
#include "se.h"

/* exprortierte Variablem *****************************************************/
GLOBAL SHELLENTRY se_shells[SHELLANZ];	/* 0 - 4 : qed sucht Shell */
													/* 5		: Shell sucht qed */

GLOBAL BOOLEAN 	se_activ;				/* haben wir Kontakt zur Shell? */
GLOBAL BOOLEAN		se_autosave,
						se_autosearch;

typedef struct _separm
{
	WORD		id;
	WORD		shellCmd;
	WORD		editCmd;
	WORD		se_version;
	UBYTE		progName[25];
} SEPARMS;


/* lokale Variablem **********************************************************/
LOCAL SEPARMS	shellParm,
					editParm;
LOCAL WORD		aktiv;				/* Nummer der aktiven Shell (0..SHELLANZ - 1) */
LOCAL WORD		menu_len;
LOCAL LONG		timer;				/* wird hochgezhlt */
LOCAL	BOOLEAN	wait_for_answer;	/* TRUE, wenn auf SE_OK/_ACK gewartet wird */
LOCAL UBYTE		orgMenu[8][25];

/*****************************************************************************/
#define WAITTIME	2000				/* Zeit in ms, die qed auf ein SE_ACK wartet */

/* lokale Prototypen */
LOCAL VOID		sendOK(VOID);
LOCAL VOID		sendACK(BOOLEAN ok);
LOCAL VOID		sendCmd(WORD cmd, WORD bit);


LOCAL VOID	setupMakefile(VOID)
{
	FILENAME n = "";

	if (se_shells[aktiv].Makefile[0] == EOS)
		menu_text(menu, MSMAKEFILE, orgMenu[0]);
	else
	{
		file_name(se_shells[aktiv].Makefile, n, FALSE);
		fillup_menu(MSMAKEFILE, n, 2);
	}
}


LOCAL VOID setTitel(UBYTE *titel)
{
	UBYTE str[25] = " ";

	strcat(str, titel);
	strcat(str, " ");
	menu_bar(menu, 0);
	menu[2].ob_width = menu_len + (short)strlen(str) * sys_wchar;
	menu[TSHELL].ob_width = (short)strlen(str) * sys_wchar;
	strcpy(menu[TSHELL].ob_spec.free_string, str);
	menu_bar(menu, 1);
	updt_menu();
}

GLOBAL VOID setup_semenu(VOID)
{
	WORD	i;

	if (se_activ)
	{
		setupMakefile();
		set_menu(MSQUIT, TRUE);
		set_menu(MSMAKEFILE, (shellParm.editCmd & _ESMAKE));
		set_menu(MSCOMP, (shellParm.editCmd & _ESCOMPILE));
		set_menu(MSMAKE, (shellParm.editCmd & _ESMAKE));
		set_menu(MSMAKEALL, (shellParm.editCmd & _ESMAKEALL));
		set_menu(MSLINK, (shellParm.editCmd & _ESLINK));
		set_menu(MSEXEC, (shellParm.editCmd & _ESEXEC));
		set_menu(MSMAKEEXEC, (shellParm.editCmd & _ESMAKEEXEC));
		set_menu(MSSHELL, (shellParm.editCmd & _ESSHLCTRL));
	}
	else
	{
		for (i = MSQUIT; i <= MSSHELL; i++)
			set_menu(i, FALSE);
	}
}


LOCAL VOID resetShellMenu(VOID)
{
	WORD	i;

	setTitel("Shell");
	menu_text(menu, MSMAKEFILE, orgMenu[0]);
	for (i = MSCOMP; i <= MSSHELL; i++)
		menu_text(menu, i, orgMenu[i - MSCOMP + 1]);
}


GLOBAL VOID	timer_se(VOID)
{
	if (wait_for_answer)
	{
		timer += TIMER_INTERVALL;
		if (timer > WAITTIME)
		{
			timer = 0;
			wait_for_answer = FALSE;
			if (note(2, SENOANS) == 1)
			{
				se_activ = FALSE;
				setTitel("Shell");
			}
		}
	}
}


LOCAL VOID set_timer(VOID)
{
	timer = 0;
	wait_for_answer = TRUE;
}


LOCAL VOID reset_timer(VOID)
{
	timer = 0;
	wait_for_answer = FALSE;
}

/* Shell -> Editor ************************************************************/

/* forward Dekl. */
LOCAL VOID	sendESQUIT(VOID);
LOCAL VOID	sendCmd(WORD cmd, WORD bit);


/* Antwort auf SE_INIT */
LOCAL VOID	sendOK(VOID)
{
	if (shellParm.editCmd & _ESOK)
	{
		if (debug & DBG_SE)
			Debug("qed: sendOK -> %d\n", shellParm.id);
		memset(msgbuff, 0, (WORD)sizeof(msgbuff));
		msgbuff[0] = ES_OK;
		msgbuff[1] = editParm.id;
		msgbuff[3] = editParm.shellCmd;
		msgbuff[5] = editParm.editCmd;
		msgbuff[6] = SEPROTOVERSION;
		msgbuff[7] = shellParm.id;
		send_msg(shellParm.id);
	}
}


LOCAL VOID	sendACK(BOOLEAN ok)
{
	if (shellParm.editCmd & _ESACK)
	{
		if (debug & DBG_SE)
			Debug("qed: sendAck -> %d\n", shellParm.id);
		memset(msgbuff, 0, (WORD)sizeof(msgbuff));
		msgbuff[0] = ES_ACK;
		msgbuff[1] = editParm.id;
		msgbuff[3] = ok;
		send_msg(shellParm.id);
	}
}


GLOBAL VOID hndl_se(WORD *msg)
{
	UBYTE 		datei[255], fehler[255], str[9], *p, *p2;
	WORD			icon, i, d, x;
	LONG			y;
	ERRINFO		*error;
	SEMENUINFO	*pmenu;

	switch (msg[0])
	{
		case SE_INIT :
			if (debug & DBG_SE)
			{
				Debug("qed: SE_INIT von %d\n", msg[1]);
				Debug("      shellCmd = %d\n", msg[3]);
				Debug("      editCmd  = %d\n", msg[5]);
				Debug("      version  = 0x%X\n", msg[6]);
			}
			if (se_activ)
				sendESQUIT();
			shellParm.id = msg[1];
			shellParm.shellCmd = msg[3];
			shellParm.editCmd  = msg[5];
			shellParm.se_version = msg[6];
			sendOK();
			se_activ = TRUE;

			/* Wir versuchen den GEM-Namen des Senders zu ermitteln */
			if (magx)
			{
				/* MagiC-Special, funkt auch, wenn es kein appl_search gibt */
				sprintf(str, "? %cXXXXX", (char) shellParm.id);
				str[1] = '\0';
				appl_find(str);
			}
			else
			if ((appl_xgetinfo(4, &d, &d, &i, &d)) && (i == 1))	/* gibts appl_search? */
			{
				WORD	type, id;

				i = appl_search( 0, str, &type, &id);
				while (i != 0)
				{
					if (type == 2 && id == shellParm.id)
						break;
					i = appl_search( 1, str, &type, &id);
				}
			}
			else
				strcpy(str, "Shell");

			aktiv = SHELLANZ - 1;
			if ((p = strchr(str, ' ')) != NULL)		/* Blanks am Ende abschneiden */
				*p = EOS;
			for (i = 0; i < SHELLANZ - 1; i++)		/* Shell eine der angemeldeten? -> Makefile */
			{
				if (strcmp(str, se_shells[i].Name) == 0)
					aktiv = i;
			}
			if (aktiv == SHELLANZ - 1)					/* Shell nicht angemeldet */
			{
				strcpy(se_shells[aktiv].Name, str);
				strcpy(se_shells[aktiv].Makefile, "");
			}
			setTitel(se_shells[aktiv].Name);
			break;
		case SE_OK		:
			reset_timer();
			if (debug & DBG_SE)
			{
				Debug("qed: SE_OK von %d\n", msg[1]);
				Debug("      shellCmd = %d\n", msg[3]);
				Debug("      editCmd  = %d\n", msg[5]);
				Debug("      version  = 0x%X\n", msg[6]);
			}
			shellParm.id		 = msg[1];
			shellParm.shellCmd = msg[3];
			shellParm.editCmd  = msg[5];
			shellParm.se_version = msg[6];
			se_activ = TRUE;
			setTitel(se_shells[aktiv].Name);
			break;
		case SE_ACK 	:
			reset_timer();
			if (debug & DBG_SE)
				Debug("qed: SE_ACK von %d\n", msg[1]);
			break;
		case SE_OPEN	:
			p = *(UBYTE **)(msg + 3);
			if (p != NULL)
				strcpy(datei, p);
			if (debug & DBG_SE)
			{
				Debug("qed: SE_OPEN von %d\n", msg[1]);
				Debug("      name = %s\n", datei);
			}
			if (shellParm.se_version >= 0x102)
			{
				x = msg[7];
				y = (*(LONG *)(msg + 5));
				if (debug & DBG_SE)
				{
					Debug("      zeile = %ld\n", y);
					Debug("      spalte = %d\n", x);
				}
			}
			sendACK(TRUE);
			if ((strlen(datei) > 0) && file_exist(datei))
			{
				icon = load_edit(datei, FALSE);
				if ((shellParm.se_version >= 0x102) && (icon > 0) &&
				    (x >= 1) && (y >= 1))
				{
					desire_x = x - 1;
					desire_y = y - 1;
					Icon_edit(icon, DO_GOTO);
				}
			}
			break;
		case SE_ERROR :
			error = *(ERRINFO **)(msg + 3);
			if (error != NULL)
			{
				if (debug & DBG_SE)
					Debug("qed: SE_ERROR von %d\n", msg[1]);
				strcpy(datei, error->errFile);
				strcpy(fehler, error->errMess);
				x = error->errRow;
				y = error->errLine;
			}
			sendACK(TRUE);
			if ((strlen(datei) > 0) && file_exist(datei))
			{
				icon = load_edit(datei, FALSE);
				if (icon > 0)
				{
					UBYTE	str[256];

					strcpy(str, STRING(ERRORSTR));
					strcat(str, fehler);
					set_info(get_text(icon), str);
					if ((x >= 1) && (y >= 1))
					{
						desire_x = x - 1;
						desire_y = y - 1;
						Icon_edit(icon, DO_GOTO);
					}
				}
			}
			break;
		case SE_ERRFILE :
			p = *(UBYTE **)(msg + 5);
			p2 = *(UBYTE **)(msg + 3);
			if ((p != NULL) && (p2 != NULL))
			{
				strcpy(datei, p);
				strcpy(fehler, p2);
				if (debug & DBG_SE)
				{
					Debug("qed: SE_ERRFILE von %d\n", msg[1]);
					Debug("      name   = %s\n", datei);
					Debug("      fehler = %s\n", fehler);
				}
			}
			sendACK(TRUE);
			if ((strlen(datei) > 0) && file_exist(datei))
				icon = load_edit(datei, FALSE);
			if ((strlen(fehler) > 0) && file_exist(fehler))
			{
				icon = load_edit(fehler, FALSE);
				if (icon > 0)
				{
					do_icon(icon, DO_ABAND);
					desire_x = 0;
					desire_y = 0;
					Icon_edit(icon, DO_GOTO);
				}
			}
			break;
		case SE_PROJECT :
			p = *(UBYTE **)(msg + 3);
			if (p != NULL)
				strcpy(datei, p);
			else
				strcpy(datei, "");
			if (debug & DBG_SE)
			{
				Debug("qed: SE_PROJECT von %d\n", msg[1]);
				Debug("      name = %s\n", datei);
			}
		 	sendACK(TRUE);
			if (file_exist(datei))
			{
				strcpy(se_shells[aktiv].Makefile, datei);
				setupMakefile();
			}
		 	break;
		case SE_QUIT :
			if (debug & DBG_SE)
				Debug("qed: SE_QUIT von %d\n", msg[1]);
			se_activ = FALSE;
			resetShellMenu();
			break;
		case SE_CLOSE :
			if (debug & DBG_SE)
				Debug("qed: SE_CLOSE von %d\n", msg[1]);
			if (shellParm.se_version >= 0x101)
			{
				p = *(UBYTE **)(msg + 3);
				if ((p != NULL) && (strlen(p) > 0))
				{
					strcpy(datei, p);
				 	sendACK(TRUE);
#if 0
/*
 * Hack: Die PC_SHELL schickt *.* beim Projektwechsel :-(((((
*/
					if ((strcmp(se_shells[aktiv].Name, "PC_SHELL") == 0) && 
						 (strcmp(datei, "*.*") == 0))
						break;
					else
#endif
						close_edit(datei, msg[5]);
				}
			}
			else
			{
			 	sendACK(TRUE);
				close_edit("*.*", 1);
			}
		 	break;
		case SE_MENU :
			pmenu = *(SEMENUINFO **)(msg + 3);
			if (pmenu != NULL)
			{
				if (debug & DBG_SE)
					Debug("qed: SE_MENU von %d\n", msg[1]);

				if ((pmenu->compStr != NULL) && (strlen(pmenu->compStr) > 0))
					fillup_menu(MSCOMP, pmenu->compStr, 2);
				if ((pmenu->makeStr != NULL) && (strlen(pmenu->makeStr) > 0))
					fillup_menu(MSMAKE, pmenu->makeStr, 2);
				if ((pmenu->makeAllStr != NULL) && (strlen(pmenu->makeAllStr) > 0))
					fillup_menu(MSMAKEALL, pmenu->makeAllStr, 2);
				if ((pmenu->linkStr != NULL) && (strlen(pmenu->linkStr) > 0))
					fillup_menu(MSLINK, pmenu->linkStr, 2);
				if ((pmenu->execStr != NULL) && (strlen(pmenu->execStr) > 0))
					fillup_menu(MSEXEC, pmenu->execStr, 2);
				if ((pmenu->makeExecStr != NULL) && (strlen(pmenu->makeExecStr) > 0))
					fillup_menu(MSMAKEEXEC, pmenu->makeExecStr, 2);
				
				if (shellParm.se_version >= 0x104)
					if ((pmenu->progName != NULL) && (strlen(pmenu->progName) > 0))
						setTitel(pmenu->progName);

				if (shellParm.se_version >= 0x105)
					if ((pmenu->shellCtrlStr != NULL) && (strlen(pmenu->shellCtrlStr) > 0))
						fillup_menu(MSSHELL, pmenu->shellCtrlStr, 2);

			 	sendACK(TRUE);
			}
			break;
		default:
			break;
	} /* switch */
}


/* Editor -> Shell ************************************************************/


LOCAL VOID	sendESQUIT(VOID)
{
	if (debug & DBG_SE)
		Debug("qed: sendESQUIT -> %d\n", shellParm.id);
	memset(msgbuff, 0, (WORD)sizeof(msgbuff));
	msgbuff[0] = ES_QUIT;
	msgbuff[1] = editParm.id;
	(VOID) send_msg(shellParm.id);
	se_activ = FALSE;
}


LOCAL VOID	sendESINIT(WORD app)
{
	if (debug & DBG_SE)
		Debug("qed: sendESINIT -> %d\n", app);
	memset(msgbuff, 0, (WORD)sizeof(msgbuff));
	msgbuff[0] = ES_INIT;
	msgbuff[1] = editParm.id;
	msgbuff[3] = editParm.shellCmd;
	msgbuff[5] = editParm.editCmd;
	msgbuff[6] = SEPROTOVERSION;
	send_msg(app);
}


LOCAL VOID	sendESSHLCTRL(WORD flag)
{
	memset(msgbuff, 0, (WORD)sizeof(msgbuff));
	msgbuff[0] = ES_SHLCTRL;
	msgbuff[1] = editParm.id;
	if (global_str1[0] != EOS)
		*(UBYTE **) &msgbuff[3] = global_str1;
	else
		*(UBYTE **) &msgbuff[3] = NULL;
	msgbuff[5] = flag;
	send_msg(shellParm.id);
}


LOCAL VOID	sendCmd(WORD cmd, WORD bit)
{
	if (shellParm.editCmd & bit)
	{
		memset(msgbuff, 0, (WORD)sizeof(msgbuff));
		msgbuff[0] = cmd;
		msgbuff[1] = editParm.id;
		if (global_str1[0] != EOS)
			*(UBYTE **) &msgbuff[3] = global_str1;
		else
			*(UBYTE **) &msgbuff[3] = NULL;
		if (!send_msg(shellParm.id))
		{
			se_activ = FALSE;
			setTitel("Shell");
			note(1, SENOANS);
			return;
		}
		set_timer();
	}
}

LOCAL VOID get_filename(WORD icon)
{
	TEXTP 	t_ptr;

	if (icon != -1)
	{
		t_ptr = get_text(icon);
		strcpy(global_str1, t_ptr->filename);
	}
	else
		strcpy(global_str1, "");
}

LOCAL BOOLEAN such_shell(VOID)
{
	WORD	i, j;
	UBYTE	name[9];

	for (i = 0; i < SHELLANZ - 1; i++)
	{
		strcpy(name, se_shells[i].Name);
		if (name[0])
		{
			for (j = (short) strlen(name); j < 8; j++)
				strcat(name, " ");
			j = appl_find(name);
			if (j > 0)
			{
				aktiv = i;
				sendESINIT(j);
				set_timer();
				return TRUE;
			}
		}
	}
	return FALSE;
}

LOCAL VOID se_options(VOID)
{
	WORD	i, antw;
	UBYTE	tmp[30];

	if (se_activ)
	{
		sprintf(tmp, "%s, SE-Version %x", se_shells[aktiv].Name, shellParm.se_version);
		objc_setstring(seoptions, SESTATUS, tmp);
	}
	else
		objc_setstring(seoptions, SESTATUS, "--");
	
	for (i = 0; i < SHELLANZ - 1; i++)
		objc_setstring(seoptions, SENAME1 + i, se_shells[i].Name);

	select_objc(seoptions, SESAVE, se_autosave);
	select_objc(seoptions, SESEARCH, se_autosearch);

	if (se_activ)
	{
		do_flags(seoptions, SEOK, DEFAULT);
		undo_flags(seoptions, SESUCH, DEFAULT);
	}
	else
	{
		undo_flags(seoptions, SEOK, DEFAULT);
		do_flags(seoptions, SESUCH, DEFAULT);
	}
	
	antw = handle_dial(seoptions, SENAME1);
	if ((antw == SEOK) || (antw == SESUCH))
	{
		for (i = 0; i < SHELLANZ - 1; i++)
			objc_getstring(seoptions, SENAME1 + i, se_shells[i].Name);

		se_autosave = get_select(seoptions, SESAVE);
		se_autosearch = get_select(seoptions, SESEARCH);

		if (antw == SESUCH)
		{
			if (se_activ)
			{
				antw = note(2, SEONLINE);
				if (antw == 2)
					return;
				else
				{
					sendESQUIT();
					setTitel("Shell");
				}
			}
			if (!such_shell())
				note(1, SENOTFOUND);
		}
	}
}

LOCAL VOID do_sesave(WINDOWP window)
{
	if (window != NULL)
	{
		TEXTP	t_ptr;
		
		t_ptr = get_text(window->handle);
		if ((t_ptr!= NULL) && (t_ptr->moved != 0))
			do_icon(window->handle, DO_SAVE);
	}
}

GLOBAL VOID hndl_es(WORD item)
{
	FSEL		fsel = {"", "*.*"};
	PATH		name = "";
	FILENAME n = "";
	WINDOWP	window;
	WORD		top_icon = -1;
	
	if (item == MSOPT)
		se_options();

	if (!se_activ)
		return ;

	window = winlist_top();
	if (window != NULL && window->class == CLASS_EDIT)
		top_icon = window->handle;

	switch (item)
	{
		case MSQUIT :
			sendESQUIT();
			resetShellMenu();
			break;

		case MSMAKEFILE:
			if (global_shift && se_shells[aktiv].Makefile[0] != EOS)	/* Makefile lschen */
			{
				se_shells[aktiv].Makefile[0] = EOS;
				updt_menu();
				if (shellParm.se_version >= 0x101)
				{
					strcpy(global_str1, "");
					sendCmd(ES_PROJECT, _ESPROJECT);
				}
				break;
			}
			if (se_shells[aktiv].Makefile[0] != EOS)
			{
				file_name(se_shells[aktiv].Makefile, n, FALSE);
				set_fsel_path(se_shells[aktiv].Makefile);
			}
			strcpy(fsel.name, n);
			if (select_file(&fsel, name, STRING(FINDMKSTR)))
			{
				strcpy(se_shells[aktiv].Makefile, name);
				setupMakefile();
				strcpy(global_str1, se_shells[aktiv].Makefile);
				sendCmd(ES_PROJECT, _ESPROJECT);
			}
			break;

		case MSCOMP :
			if (se_autosave)
				do_sesave(window);
			get_filename(top_icon);
			if ((global_str1[0] != EOS) || (shellParm.se_version >= 0x103))
				sendCmd(ES_COMPILE, _ESCOMPILE);
			break;

		case MSMAKE :
			if (se_autosave)
				do_all_window(CLASS_EDIT, do_sesave);
			strcpy(global_str1, se_shells[aktiv].Makefile);
			sendCmd(ES_MAKE, _ESMAKE);
			break;

		case MSMAKEALL :
			if (se_autosave)
				do_all_window(CLASS_EDIT, do_sesave);
			strcpy(global_str1, se_shells[aktiv].Makefile);
			sendCmd(ES_MAKEALL, _ESMAKEALL);
			break;

		case MSLINK :
			get_filename(top_icon);
			sendCmd(ES_LINK, _ESLINK);
			break;

		case MSEXEC :
			get_filename(top_icon);
			sendCmd(ES_EXEC, _ESEXEC);
			break;

		case MSMAKEEXEC :
			if (se_autosave)
				do_all_window(CLASS_EDIT, do_sesave);
			strcpy(global_str1, se_shells[aktiv].Makefile);
			sendCmd(ES_MAKEEXEC, _ESMAKEEXEC);
			break;

		case MSSHELL :
			if (se_autosave)
				do_sesave(window);
			get_filename(top_icon);
			sendESSHLCTRL(0);			/* Shell toppen */
			break;

	} /* switch */
}

GLOBAL VOID	init_se(VOID)
{
	WORD	i;

	se_activ = FALSE;
	menu_len = menu[2].ob_width - menu[TSHELL].ob_width;
	setTitel("Shell");

	/* Meneintrge sichern */
	strcpy(orgMenu[0], (UBYTE *)get_obspec(menu, MSMAKEFILE));
	for (i = MSCOMP; i <= MSSHELL; i++)
		strcpy(orgMenu[i - MSCOMP + 1], (UBYTE *)get_obspec(menu, i));

	shellParm.id		 = -1;
	shellParm.shellCmd = 0;
	shellParm.editCmd  = 0;

	editParm.id 		 = gl_apid;
	editParm.shellCmd  = (_SEINIT|_SEOK|_SEACK|_SEQUIT|_SEOPEN|_SEERROR|_SEERRFILE|_SEPROJECT|_SECLOSE|_SEMENU);
	editParm.editCmd	 = (_ESINIT|_ESOK|_ESACK|_ESQUIT|_ESCOMPILE|_ESMAKE|_ESMAKEALL|_ESLINK|_ESEXEC|_ESMAKEEXEC|_ESPROJECT|_ESSHLCTRL);

	setupMakefile();

	if (se_autosearch)
		such_shell();
}

GLOBAL VOID term_se(VOID)
{
	if (se_activ && (shellParm.editCmd & _ESQUIT))
		sendESQUIT();
}
