/*
 * SE-Protokoll zur Kommunikation zwischen Shells zur Programmentwicklung
 * und Editoren.
 *
 * Dieses Protokoll dient dazu, unter Multitasking-Systemen die Shell
 * zur Compilierung und hnlichen Sachen zu veranlassen, und um Fehler-
 * meldungen und/oder Fehlerdateien an den Editor zurckzugeben.
 *
 * Kommandos bzw. Nachrichten von der Shell zum Editor beginnen
 * mit SE_, Nachrichten vom Editor zur Shell beginnen mit ES_
 *
 * Da teilweise Zeiger auf Speicherbereiche bergeben werden, ist vom
 * jeweiligen Absender der Nachricht darauf zu achten, da diese
 * Speicherbereiche vom Empfnger auch lesbar sind (Memory Protection!).
 * Dafr sind diese als Readable zu allozieren!
 *
 */

/*
 * Erweiterungen
 *
 * Datum 	Version nderungen
 *
 * 30.01.96  1.01 	SE_CLOSE fr Dateien/Masken, mit Close-Flag
 * 							msg[5] = 0 -> nur sichern
 * 							msg[5] = 1 -> sichern + schlieen
 * 						ES/SE_PROJEKT mit leerem Argument (NULL)
 * 						Um zur Version 0x100 kompatibel zu sein, sollte
 * 						das Programm die Versionsnummer berprfen!!
 *
 * 13.08.96  1.02 	SE_OPEN mit Zeilen- und Spaltennummer
 * 						neue Nachricht SE_MENU
 *
 * 19.11.96  1.03 	bei ES_COMPILE kann der Dateiname auch NULL sein
 *
 * 08.01.97  1.04 	SE_CLOSE: Flag 2
 * 						SE_MENU: progName
 *
 * 23.12.97  1.05 	ES_SHLCTRL neu, zur Kontrolle der Shell
 *							Dafr neuer String in SEMENUINFO.
 *
 */

#define SEPROTOVERSION 0x105	
/*
 * Die Versionsnummer des Protokolls. Highbyte ist die Major Number
 * Lowbyte ist die Lower Number
*/


/*
 * Shell -> Editor
*/
#define SE_INIT			0x4200
	/*
	 * Die Shell fragt an, ob ein Editor das SE-Protokoll versteht.
	 * Wort 3		Ein Bitset, welche Nachrichten die Shell versendet
	 * Wort 4+5		Ein Bitset, welche Editorkommandos verstanden werden
	 * Wort 6		Untersttze Versionsnummer des Protokolls
	 * Als Antwort erhlt es ein ES_OK vom  Editor.
	 */

#define SE_OK				0x4201
	/*
	 * Die Shell sagt dem Editor, das sie das Protokoll versteht.
	 * Wort 3		Ein Bitset, welche Nachrichten die Shell versendet
	 * Wort 4+5		Ein Bitset, welche Editorkommandos verstanden werden
	 * Wort 6		Untersttze Versionsnummer des Protokolls
	 * Wort 7		Die ApId des Programmes, dessen Nachricht beantwortet wird
	 */

#define SE_ACK 			0x4202
	/*
	 * Die Shell besttigt den Empfang eines Editorkommandos und gibt zurck,
	 * ob das Kommando ausgefhrt wird.
	 * Wort 3		TRUE: Kommando wird verstanden und ausgefhrt.
	 *			  		FALSE: Das Kommando wird nicht verstanden
	 * Eine SE_ACK mit TRUE sagt nichts darber aus, ob das Kommando erfolg-
	 * reich ausgefhrt wurde. Es sagt nur, da die Shell das Kommando
	 * versteht und ausfhren wird!
	 */

#define SE_OPEN			0x4203
	/*
	 * Die Shell sagt dem Editor, da er einen Text ffnen soll.
	 * Wort 3+4		Ein Zeiger auf den Filenamen des zu ffnenden Files
	 * Wort 5+6		Cursorposition (Zeilennummer)
	 * Wort 7		Cursorposition (Spaltennummer)
	 * Als Antwort erhlt die Shell ein ES_ACK
	 */

#define SE_ERROR			0x4204
	/*
	 * Es ist ein Fehler beim Compilieren aufgetreten.
	 * Wort 3+4		Ein Zeiger auf eine Infostruktur, die wie folgt
	 *			  		aufgebaut ist:
	 *				  	Wort 0+1	Ein Zeiger auf den Namen des compilierten Textes.
	 *				  	Wort 2+3	Ein Zeiger auf den Text der Fehlermeldung
	 *				  	Wort 4	Die Fehlernummer
	 *				  	Wort 5+6	Die fehlerhafte Zeile
	 *				  	Wort 7  	Die Spalte mit dem Fehler (oder 0)
	 * Mit ES_ACK besttigt der Editor die Meldung.
	 */

#define SE_ERRFILE		0x4205
	/*
	 * Es sind Fehler aufgetreten. Die Fehlermeldungen stehen in einem
	 * Errorfile, welches in der Message spezifiziert wird.
	 * Wort 3+4		Ein Zeiger auf den Filenamen des Errorfiles mit den
	 *			  		Fehlermeldungen
	 * Wort 5+6		Ein Zeiger auf den Namen des compilierten Textes
	 * Mit ES_ACK besttigt der Editor die Meldung.
	 */

#define SE_PROJECT		0x4206
	/*
	 * Die Shell teilt dem Editor mit, da das Projekt gendert wurde.
	 * Der Filename des aktuellen Projektfiles wird als Parameter bergeben
	 * Wort 3+4		Ein Zeiger auf den Namen des Projektfiles oder NULL.
	 * 				Wird NULL bergeben, sollte das aktuelle Projekt abgemeldet 
	 *					werden.
	 * Der Editor besttigt mit ES_ACK.
	 * Eine vernnftige Reaktion des Editors wre es in dem Fall,
	 * ebenfalls das Projekt zu wechseln, sofern er diese untersttzt.
	 */

#define SE_QUIT			0x4207
	/*
	 * Die Shell teilt dem Editor mit, da sie jetzt beendet wird.
	 * Der Editor sollte in dem Fall die Shell als Kommunikationspartner
	 * vergessen.
	 * Parameter gibt es keine.
	 * Es wird keine Antwort erwartet!
	 */

#define SE_TERMINATE 	  0x4208
	/*
	 * Die Shell teilt dem Editor mit, da dieser sich beenden soll.
	 * Der Editor sollte in dem Fall sich selbst beenden und seinen ganz
	 * normalen Terminierungsproze durchlaufen (und in dem auch ein ES_QUIT
	 * schicken!). Der Grund fr so eine Meldung der Shell knnte zum Beispiel
	 * zu wenig Speicher zum compilieren sein.
	 * Mit ES_ACK besttigt der Editor die Meldung.
	 */

#define SE_CLOSE			  0x4209
	/*
	 * Die Shell teilt dem Editor mit, da dieser bestimmte Texte sichern
	 * bzw. schlieen soll. Beim Schlieen von genderten Texten sollte der
	 * Editor vorher nachfragen.
	 * Wort 3+4		Ein Zeiger auf den Namen einer Datei oder eine Dateimaske.
	 *			  		'*.*' steht fr alle Textfenster (entspricht also dem SE_CLOSE
	 *			  		der Protokoll-Version 0x100).
	 * Wort 5		Steuer-Flag:
	 *						0 = nur sichern
	 *			  			1 = sichern und schlieen
	 *			  			2 = schlieen ohne sichern
	 * Mit ES_ACK besttigt der Editor die Meldung.
	 */

#define SE_MENU			0x420A
	/*
	 * Die Shell teilte dem Editor mit, was er fr die einzelnen Programme
	 * in sein Men eintragen soll.
	 * Word 3+4		Ein Zeiger auf eine SEMENUINFO-Struktur mit den Eintrgen.
	 * Mit ES_ACK besttigt der Editor die Meldung.
	 */


/*
 * Editor -> Shell
*/
#define ES_INIT			0x4240
	/*
	 * Ein Editor fragt an, ob eine Shell das SE-Protokoll versteht.
	 * Wort 3		Ein Bitset, welche Shellnachrichten verstanden werden
	 * Wort 4+5		Ein Bitset, welche Editorkommandos versendet werden
	 * Wort 6		Untersttze Versionsnummer des Protokolls
	 * Als Antwort erhlt es SE_OK von der Shell
	 */

#define ES_OK				0x4241
	/*
	 * Der Editor beantwortet die Anfrage der Shell nach dem Protokoll.
	 * Wort 3		Ein Bitset, welche Shellnachrichten verstanden werden
	 * Wort 4+5		Ein Bitset, welche Editorkommandos versendet werden
	 * Wort 6		Untersttze Versionsnummer des Protokolls
	 * Wort 7		Die ApId des Programmes, dessen Nachricht beantwortet wird
	 */

#define ES_ACK 			0x4242
	/*
	 * Der Editor besttigt den Empfang des Kommandos
	 * Wort 3		TRUE: Kommando wird verstanden und ausgefhrt.
	 *					FALSE: Das Kommando wird nicht verstanden
	 * Eine ES_ACK mit TRUE sagt nichts darber aus, ob das Kommando erfolg-
	 * reich ausgefhrt wurde. Es sagt nur, da der Editor das Kommando
	 * versteht und ausfhren wird!
	 */

#define ES_COMPILE		0x4243
	/*
	 * Der Editor sagt der Shell, da sie ein File bersetzen soll.
	 * Ein Pointer auf den Dateinamen wird in der Message bergeben.
	 * Wort 3+4		Zeiger auf den Namen der zu compilierenden Datei oder NULL.
	 * Diese Nachricht mu mit SE_ACK besttigt werden.
	 */

#define ES_MAKE			0x4244
	/*
	 * Der Editor sagt der Shell, da sie ein Make ausfhren soll.
	 * Ein Filename kann in der Message bergeben werden, mu aber nicht 
	 * gesetzt sein und mu von der Shell auch nicht beachtet werden!
	 * Wort 3+4		Zeiger auf den Namen des Makefiles oder NULL.
	 * Die Shell besttigt mit SE_ACK.
	 */

#define ES_MAKEALL		0x4245
	/*
	 * Der Editor sagt der Shell, da ein komplettes Make All ausgefhrt
	 * werden soll. Ein Filename fr das Makefile kann (mu nicht) in
	 * der Message bergeben werden.
	 * Wort 3+4		Zeiger auf den Namen des Makefiles oder NULL.
	 * Die Shell besttigt mit SE_ACK.
	 */

#define ES_LINK			0x4246
	/*
	 * Der Editor sagt der Shell, da das Programm gelinkt werden soll. 
	 * Ein Filename kann in der Message bergeben werden, mu aber nicht 
	 * unbedingt beachtet werden von der Shell!
	 * Wort 3+4		Zeiger auf den Namen der Source oder NULL.
	 * Die Shell besttigt mit SE_ACK.
	 */

#define ES_EXEC			0x4247
	/*
	 * Der Editor sagt der Shell, da das Programm zu der Source ausgefhrt 
	 * werden soll. Ein Filename kann bergeben werden, mu von der Shell 
	 * aber nicht beachtet werden.
	 * Wort 3+4		Zeiger auf den Namen des auszufhrenden Files oder NULL.
	 *			  		Bei einer Sourcedatei ist diese ggf. noch zu compilieren 
	 *					und/oder zu linken.
	 * Die Shell besttigt mit SE_ACK.
	 */

#define ES_MAKEEXEC		0x4248
	/*
	 * Die Shell soll ein Make ausfhren und danach das Programm ausfhren.
	 * Ein Filename fr das Makefile kann (mu nicht) in der Message
	 * bergeben werden.
	 * Wort 3+4		Zeiger auf den Namen des Makefiles oder NULL.
	 * Die Shell besttigt mit SE_ACK.
	 */

#define ES_PROJECT		0x4249
	/*
	 * Der Editor teilt der Shell mit, da das Project gendert/gewechselt
	 * wurde. Der Filename des  Projektfiles wird als Parameter in der Message
	 * bergeben. 
	 * Wort 3+4		Zeiger auf den Namen des Projektfiles oder NULL.
	 *					Wird NULL bergeben, sollte das aktuelle Projekt abgemeldet
	 * 				werden.
	 * Die Shell besttigt mit SE_ACK.
	 * Eine vernnftige Reaktion der Shell wre in dem Fall, ebenfalls
	 * das Projekt zu wechseln, sofern sie diese untersttzt.
	 */

#define ES_QUIT			0x424A
	/*
	 * Der Editor teilt der Shell mit, da er jetzt beendet wird. Die Shell 
	 * sollte in dem Fall den Editor als Kommunikationspartner vergessen.
	 * Parameter gibt es keine.
	 * Es wird keine Antwort erwartet!
	 */

#define ES_SHLCTRL		0x424B
	/*
	 * Sonstige Kontrolle der Shell durch den Editors.
	 * Wort 3+4		Zeiger auf den Namen des obersten Fensters des Editors
	 *             oder NULL.
	 * Wort 5		Steuer-Flag:
	 *						0: Shell soll sich toppen (Men/Fenster).
	 * Die Shell besttigt mit SE_ACK.
	 */


/*
 * Shell-Kommando-Bits 
 */
#define _SEINIT		0x0001
#define _SEOK			0x0002
#define _SEACK 		0x0004
#define _SEOPEN		0x0008
#define _SEERROR		0x0010
#define _SEERRFILE	0x0020
#define _SEPROJECT	0x0040
#define _SEQUIT		0x0080
#define _SETERMINATE 0x0100
#define _SECLOSE		0x0200
#define _SEMENU		0x0400

/*
 * Editor-Kommando-Bits
 */
#define _ESINIT		0x0001
#define _ESOK			0x0002
#define _ESACK 		0x0004
#define _ESCOMPILE	0x0008
#define _ESMAKE		0x0010
#define _ESMAKEALL	0x0020
#define _ESLINK		0x0040
#define _ESEXEC		0x0080
#define _ESMAKEEXEC	0x0100
#define _ESPROJECT	0x0200
#define _ESQUIT		0x0400
#define _ESSHLCTRL	0x0800



/*
 * Die Nachricht SE_ERROR liefert einen Zeiger auf diese Struktur:
 */
typedef struct
{
	char	*errFile;			/* Zeiger auf den Namen der compilierten Datei */
	char	*errMess;			/* Zeiger auf die Fehlermeldung */
	int	errNum;				/* Die Fehlernummer */
	long	errLine; 			/* Die fehlerhafte Zeile */
	int	errRow;				/* Die Spalte mit dem Fehler (oder 0) */
} ERRINFO;

/*
 * Die Nachricht SE_MENU verwendet einen Zeiger auf diese Struktur:
 */
typedef struct
{
	char	*compStr;
	char	*makeStr;
	char	*makeAllStr;
	char	*linkStr;
	char	*execStr;
	char	*makeExecStr;
	char	*progName;
	char	*shellCtrlStr; 	/* neu fr ES_SHLCTRL ab 0x105 */
} SEMENUINFO;
