#include "global.h"
#include "set.h"

LOCAL UBYTE bits[]={128,64,32,16,8,4,2,1};

/*****************************************************************************/

WORD setfree(SET set)
{
	WORD	i;
	ULONG help, h;

	h = 0xFFFFFFFFL;
	for (i=0; i<SETMAX; i+=32)
		if ((help=*set++)!=h)
		{
			h = 0x80000000L;
			while (help>=h)
			{
				i++; help<<=1;
			}
			break;
		}
	return i;
}

/*****************************************************************************/

WORD setmax(SET set)
{
	WORD	i;
	ULONG help;

	for (i=SETSIZE; (--i)>=0; )
		if ((help=set[i])!=0L)
		{
			i *= 32;
			for (i+=31; (help&1L)==0; i--,help>>=1) ;
			return (i);
		}
	return -1;
}

/*****************************************************************************/

WORD setmin(SET set)
{
	WORD	i;
	ULONG help, h;

	for (i=0; i<SETMAX; i+=32)
		if ((help=*set++)!=0L)
		{
			h = 0x80000000L;
			while (help<h)
			{
				i++; help<<=1;
			}
			break;
		}
	return i;
}

/*****************************************************************************/

VOID setcpy (SET set1, const SET set2)
{
	memcpy(set1, set2, SETSIZE * (short) sizeof(ULONG));
}

/*****************************************************************************/
#if (SETSIZE&1)!=0
	So gehts nicht
#endif

VOID setall (SET set)
{
	WORD i;

	i = SETSIZE/2;
	while ((--i)>=0)
	{
		*set++ = 0xFFFFFFFFL;
		*set++ = 0xFFFFFFFFL;
	}
} /* setall */

/*****************************************************************************/

VOID setclr (SET set)
{
	WORD i;

	i = SETSIZE/2;
	while ((--i)>=0)
	{
		*set++ = 0L;
		*set++ = 0L;
	}
} /* setclr */

/*****************************************************************************/

VOID setnot (SET set)
{
	WORD i;

	i = SETSIZE/2;
	while ((--i)>=0)
	{
		*set++ ^= 0xFFFFFFFFL;
		*set++ ^= 0xFFFFFFFFL;
	}
} /* setnot */

/*****************************************************************************/

VOID setand (SET set1, SET set2)
{
	WORD i;

	i = SETSIZE/2;
	while ((--i)>=0)
	{
		*set1++ &= *set2++;
		*set1++ &= *set2++;
	}
} /* setand */

/*****************************************************************************/

VOID setor (SET set1, SET set2)
{
	WORD i;

	i = SETSIZE/2;
	while ((--i)>=0)
	{
		*set1++ |= *set2++;
		*set1++ |= *set2++;
	}
} /* setor */

/*****************************************************************************/

VOID setxor (SET set1, SET set2)
{
	WORD i;

	i = SETSIZE/2;
	while ((--i)>=0)
	{
		*set1++ ^= *set2++;
		*set1++ ^= *set2++;
	}
} /* setxor */

/*****************************************************************************/

VOID setincl (SET set, WORD elt)
{
	if (elt>=0 && elt<=SETMAX)
		*((UBYTE*)set+(elt>>3)) |= bits[elt&7];
} /* setincl */

/*****************************************************************************/

VOID setexcl (SET set, WORD elt)
{
	if (elt>=0 && elt<=SETMAX)
		*((UBYTE*)set+(elt>>3)) &= ~bits[elt&7];
} /* setexcl */

/*****************************************************************************/

VOID setchg (SET set, WORD elt)
{
	if (elt>=0 && elt<=SETMAX)
		*((UBYTE*)set+(elt>>3)) ^= bits[elt&7];
}

/*****************************************************************************/

BOOLEAN setin (SET set, WORD elt)
{
	if (elt>=0 && elt<=SETMAX)
		return ((*((UBYTE*)set+(elt>>3)) & bits[elt&7]) ? TRUE : FALSE);
	else
		return (FALSE);
} /* setin */

/*****************************************************************************/

BOOLEAN setcmp (SET set1, SET set2)
{
	WORD i;

	if (set2==NULL)
		for (i=0; i<SETSIZE && *set1++==0; i++);
	else
		for (i=0; i<SETSIZE && *set1++==*set2++; i++);
	return (i==SETSIZE);
} /* setcmp */

/*****************************************************************************/

WORD setcard (SET set)
{
	WORD i, card, max;

	max = setmax(set);
	for (i=setmin(set), card=0; i<=max; i++)
		if (setin (set, i)) card++;

	return (card);
} /* setcard */

/*****************************************************************************/

VOID str2set (const UBYTE *str, SET set)
{
	WORD	i;

	setclr(set);
	i = 0;
	while(str[i])
	{
		if (str[i]=='-' && i>0)
		{
			UBYTE c;

			i++;
			for (c=str[i-2]; c<str[i]; c++)
				setincl(set,c);
		}
		else
			setincl(set,str[i++]);
	}
} /* str2set */
