#include "global.h"
#include "ausgabe.h"
#include "find.h"
#include "memory.h"
#include "options.h"
#include "rsc.h"
#include "text.h"

/*
 * Verwaltung der Texte als einfach verkettete Liste
*/
LOCAL TEXTP	text_list = NULL;

LOCAL VOID nullen(TEXTP t_ptr)
{
	t_ptr->cursor_line = FIRST(&t_ptr->text);
	t_ptr->file_date_time = -1L;
	t_ptr->xpos = 0;
	t_ptr->ypos = 0L;
	t_ptr->moved = 0;
	t_ptr->readonly = FALSE;
	t_ptr->blink = t_ptr->block = t_ptr->block_dir = t_ptr->up_down = FALSE;
	t_ptr->cursor = TRUE;
	t_ptr->namenlos = TRUE;
	t_ptr->loc_opt = &loc_opt[0];
	t_ptr->info_str[0] = EOS;
	t_ptr->filename[0] = EOS;
	t_ptr->asave = 0;
	t_ptr->max_line = NULL;
}

GLOBAL VOID clear_text(TEXTP t_ptr)
{
	free_textring(&t_ptr->text);
	nullen(t_ptr);
}

GLOBAL TEXTP new_text(WORD link)
{
	TEXTP new, p;

	/* Nummer schon vergeben? */
	if (get_text(link) != NULL)
	{
		fnote(1, FATALERR, 9);
		return NULL;
	}
	new = (TEXTP)malloc(sizeof(TEXT));
	if (new != NULL)
	{
		new->next = NULL;

		/* Erster Text -> Wurzel */
		if (text_list == NULL)
			text_list = new;
		else
		{
			/* Text am Ende der Liste anhngen */
			p = text_list;
			while (p->next != NULL)
				p = p->next;
			p->next = new;
		}
		new->link = link;
		init_textring(&new->text);
		nullen(new);
		return new;		
	}
	else
		note(1, NOMEMORY);	
	return NULL;
}

GLOBAL VOID destruct_text(TEXTP t_ptr)
{
	TEXTP p;

	/* Wurzel? */
	if (t_ptr == text_list)
		text_list = text_list->next;
	else
	{
		/* Vorgnger suchen */
		p = text_list;
		while (p->next != t_ptr)
			p = p->next;

		/* und Aushngen */	
		p->next = t_ptr->next;
	}
	kill_textring(&t_ptr->text);
	free(t_ptr);
	t_ptr = NULL;
}

GLOBAL TEXTP get_text(WORD icon)
{
	TEXTP	p;

	if (icon == -1) 
		return NULL;
	p = text_list;
	while (p != NULL)
	{
		if (p->link == icon)
			return p;
		p = p->next;
	}
	return NULL;
}

GLOBAL VOID do_all_text(TEXT_DOFUNC func)
{
	TEXTP	p;
	
	p = text_list;
	while (p)
	{
		(*func)(p);
		p = p->next;
	}
}


LOCAL WORD get_locopt_index(UBYTE *filename)
{
	WORD		i;
	FILENAME	str;
	UBYTE		m[MUSTER_LEN + 2];
	
	file_name(filename, str, FALSE);
	for (i = 1; i < loc_opt_anz; i++)
	{
		strcpy(m, "*.");
		strcat(m, muster_str[i]);
		if (filematch(str, m))
			return i;
	}
	return 0;
}

GLOBAL VOID set_text_name(TEXTP t_ptr, CONST UBYTE *filename, BOOLEAN namenlos)
{
	strcpy(t_ptr->filename, filename);	
	t_ptr->namenlos = namenlos;
	if (namenlos)
		t_ptr->loc_opt = &loc_opt[0];
	else
		t_ptr->loc_opt = &loc_opt[get_locopt_index(t_ptr->filename)];
}

GLOBAL VOID update_loc_opt(VOID)
{
	TEXTP	t_ptr;
	
	t_ptr = text_list;
	while (t_ptr != NULL)	
	{
		if (!t_ptr->namenlos)
			t_ptr->loc_opt = &loc_opt[get_locopt_index(t_ptr->filename)];
		t_ptr = t_ptr->next;
	}
}

/*
 * Leerzeichen/TABs am Zeilenden lschen.
*/
GLOBAL BOOLEAN strip_endings(TEXTP t_ptr)
{
	ZEILEP	lauf;
	WORD		i;
	UBYTE		c;

	lauf = FIRST(&t_ptr->text);
	while (!IS_TAIL(lauf))
	{
		for (i=lauf->len; (--i) >= 0; )
		{
			c = TEXT(lauf)[i];
			if (c != ' ' && c != '\t')
				break;
		}
		i++;
		if (i < lauf->len)								/* Zeile verkrzen */
		{
			REALLOC(&lauf,i,i-lauf->len);
			t_ptr->moved++;
		}
		NEXT(lauf);
	}
	return (t_ptr->moved != 0);
}

/*
 * Lngste Zeile suchen
*/
GLOBAL WORD get_longestline(TEXTP t_ptr)
{
	ZEILEP	lauf;
	WORD		len;
	
	if (t_ptr->max_line != NULL)
	{
		lauf = t_ptr->cursor_line;
		lauf->exp_len = BildPos(lauf->len, lauf, t_ptr->loc_opt->tab, t_ptr->loc_opt->tabsize) + 1;
	
		if (lauf->exp_len >= t_ptr->max_line->exp_len)	/* lnger als die Lngste */
		{
			t_ptr->max_line->is_longest = FALSE;	/* alte ist nicht mehr */
			t_ptr->max_line = lauf;
			lauf->is_longest = TRUE;
		}
		else									
		{
			if (lauf->is_longest)			/* wurde die Lngste krzer */
				t_ptr->max_line = NULL;		/*	-> neue lngeste suchen */
		}
	}
		
	if (t_ptr->max_line == NULL)			/* neu suche */
	{
		len = 0;
		lauf = FIRST(&t_ptr->text);
		while (!IS_TAIL(lauf))
		{
			if (lauf->exp_len == -1)		/* Lnge hat sich gendert */
				lauf->exp_len = BildPos(lauf->len, lauf, t_ptr->loc_opt->tab, t_ptr->loc_opt->tabsize) + 1;
			if (lauf->exp_len > len)
			{
				t_ptr->max_line = lauf;
				len = lauf->exp_len;
			}
			lauf->is_longest = FALSE;		/* berall lschen */
			NEXT(lauf);
		}
		t_ptr->max_line->is_longest = TRUE;
	}
	return t_ptr->max_line->exp_len;
}
