#ifndef _qed_types_h_
#define _qed_types_h_


#define SETSIZE	32							/* Gre eines Sets in Longs */
#define SETMAX		(SETSIZE*32 - 1)		/* Maximale Elemente eines Sets */

typedef ULONG 		SET[SETSIZE];			/* Menge */

/*
 * Dateinamen, Pfade, Dateiauswahl 
*/
#define MAX_PATH_LEN	256
typedef UBYTE PATH[MAX_PATH_LEN];

#define MAX_NAME_LEN	64
typedef UBYTE FILENAME[MAX_NAME_LEN];

typedef struct
{
	FILENAME name;
	FILENAME suffix;
} FSEL;


/* Aufzhlnungtypen */
typedef enum {tos, unix, apple, binmode} LINEENDING;

typedef enum {Atari, Latin, Mac, PC, LaTeX, HTML, ASCII} UMLAUTENCODING;

typedef enum {POS_CHANGE, LINE_CHANGE, TOTAL_CHANGE, NOP_CHANGE, SCROLL_UP,
				  SCROLL_DOWN, MOVE_UP, MOVE_DOWN, BLK_CHANGE, WT_CHANGE} CHANGE;


typedef struct                                                                
{                                                                             
	LONG	x;                                                              
	LONG	y;                                                              
	LONG	w;                                                              
	LONG	h;                                                              
} LRECT;                                                                      


/* 
 * Statt MKINFO benutzt qed zwei Struktuen: 
 * 	MOUSEDATA fr die Mousdaten
 *		KEYDATA fr die Tastendaten
*/
typedef struct
{
	WORD				x;					/* Die ersten 4 Words kompatibel EVNTDATA */
	WORD				y;
	WORD				bstate;
	WORD				kstate;
	WORD				breturn;			/* Anzahl der Klicks */
} MOUSEDATA;

typedef struct
{
	WORD				kreturn;			/* GEM-Keycode */
	WORD				kstate;			/* Sondertastenstatus */
	UWORD	 			normkey;			/* Normalisierter Keycode */
	WORD	 			ascii_code;		/* ASCII-Code der Taste */
	BOOLEAN			shift;			/* Shift-Taste bettigt ? */
	BOOLEAN			ctrl;				/* Control-Taste bettigt ? */
	BOOLEAN			alt; 				/* Alternate-Taste bettigt ? */
} KEYDATA;


typedef struct
{
	BOOLEAN			tab;
	WORD				tabsize;
	BOOLEAN			einruecken;
	BOOLEAN			umbrechen;
	BOOLEAN			format_by_load;
	BOOLEAN  		format_by_paste;
	WORD				lineal_len;
	UBYTE				umbruch_str[35];
	SET				umbruch_set;
	BOOLEAN			backup;
	UBYTE				backup_ext[4];
	PATH				kurzel;
	UBYTE				wort_str[34];
	SET				wort_set;
	BOOLEAN			show_end;
} LOCOPT, *LOCOPTP;


typedef struct _zeile
{
	struct _zeile 	*vorg;
	struct _zeile 	*nachf;
	UBYTE				info;
	WORD				len;					/* Lnge in Bytes */
	BOOLEAN			is_longest;
	WORD				exp_len;				/* expandierte Lnge */
} ZEILE, *ZEILEP;


typedef struct
{
	ZEILE				head;
	ZEILE				tail;
	LONG  			lines;
	LINEENDING		ending;				/* Zeilenende */
	UWORD				max_line_len;		/* Maximale Zeilenlnge */
} RING, *RINGP;


typedef struct _text
{
	struct _text 	*next;
	WORD				link;					/* Fensterhandle */
	RING				text;					/* Der Text */
	LONG				file_date_time;	/* Datei-Datum und Zeit */
	ZEILEP			cursor_line;      /* zeigt auf aktuellen Textzeile */
	WORD				xpos;            	/* x-Position des Cursors im Text */
	LONG				ypos;					/* y-Position des Cursors im Text */
	LONG				moved;				/* Text wurde seit letztem Sichern verndert */
	ZEILEP			p1,p2;				/* Zeiger fr Block */
	LONG				z1,z2;				/* ZeilenNr. fr p1 und p2 */
	WORD				x1,x2;				/* X-Pos fr Block-Anfang und Ende */
	BOOLEAN			cursor;				/* Cursor anzeigen */
	BOOLEAN			block;				/* Es gibt einen Block */
	BOOLEAN			blink;				/* Cursor ist gerade wg. Blinken aus */
	BOOLEAN			block_dir;			/* Blockrichtung laut Eingabe */
	BOOLEAN			up_down;				/* War letzte Operation Up oder Down */
	BOOLEAN			blk_mark_mode;		/* Block wird durch Cursor aufgezogen */
	BOOLEAN			readonly;			/* Datei auf Disk schreibgeschtzt */
	WORD				desire_x;			/* Fr UP und DOWN in [TASTEN] */
	UBYTE				info_str[256];		/* Text, der im Fenster-Info ausgegeben wird */
	PATH				filename;			/* Name der Datei */
	BOOLEAN			namenlos;			/* Datei hat noch keinen Name */
	LOCOPTP			loc_opt;				/* Zeiger auf lokalen Optionen */
	LONG				asave;				/* letzter Autosave (min) */
	ZEILEP			max_line;			/* lngeste Zeile */
} TEXT, *TEXTP;

typedef VOID (*TEXT_DOFUNC)(TEXTP t_ptr);

#define WINSTRLEN	128
typedef struct _window
{
	struct _window	*next;
	WORD				class;				/* Klasse des Fensters */
	WORD				init;					/* Nummer des Fensters fr die Konfig */
	WORD				handle;				/* Handle fr Fenster */
	WORD				kind;					/* Art des Fensters */
	WORD				flags;				/* Flags des Fensters */
	LRECT				doc;					/* Position und Gre des Dokumentes */
	WORD				xfac;					/* X-Factor des Dokumentes */
	WORD				yfac;					/* Y-Factor des Dokumentes */
	WORD				w_width;				/* Fensterbreite in Einheiten */
	WORD				w_height;			/* Fensterhhe in Einheiten */
	GRECT				work;					/* Arbeitsbereich */
	UBYTE				title[WINSTRLEN];	/* Titel des Fensters (mit ' ' und '*') */
	UBYTE				info[WINSTRLEN];	/* Infozeile des Fensters */
	WORD				icon_x, icon_y;	/* Position des Icons */
	GRECT				old_size;			/* Absolute Gre vor dem Iconify */

	VOID				(*draw)			(struct _window *window, CONST GRECT *d);
	VOID				(*snap)			(struct _window *window, GRECT *new, WORD mode);
	VOID				(*click)			(struct _window *window, MOUSEDATA *mouse);
	VOID				(*unclick)		(struct _window *window);
	BOOLEAN			(*key)			(struct _window *window, KEYDATA *key);
	VOID				(*top)			(struct _window *window);
	VOID				(*ontop)			(struct _window *window);
	VOID				(*untop)			(struct _window *window);
	VOID				(*bottom)		(struct _window *window);
	VOID				(*close)			(struct _window *window);
	VOID				(*iconify)		(struct _window *window);
	VOID				(*uniconify)	(struct _window *window);
} WINDOW, *WINDOWP;

typedef VOID (*WIN_DOFUNC)(WINDOWP w);
typedef VOID (*WIN_CRTFUNC)(WINDOWP w);

typedef struct
{
	WORD		id;				/* die echte ID */
	WORD		pts;				/* Gre in Points */
	BOOLEAN	prop;				/* proportionaler Font ? */
	UBYTE		name[33];		/* Name (nur fr Drucker benutzt) */
} FONTINFO;


typedef struct 
{
	UBYTE		Name[9];		/* GEM-Name der Shell */
	PATH		Makefile;
} SHELLENTRY;


typedef struct _posentry
{
	struct _posentry	*next;
	PATH					filename;
	LONG					zeile;
	WORD					spalte;
} POSENTRY;

#endif
